<?php

// update time so css and javascript will be loaded fresh
$jakdb->update("settings", ["used_value" => time()], ["varname" => "updated"]);
// update version
$jakdb->update("settings", ["used_value" => "3.8"], ["varname" => "version"]);

// Send update email
$email_body = 'URL: '.BASE_URL.'<br />Email: '.JAK_EMAIL.'<br />License: '.JAK_O_NUMBER;
$mail = new PHPMailer(); // defaults to using php "mail()"
$body = str_ireplace("[\]", "", $email_body);
$mail->SetFrom(JAK_EMAIL);
$mail->AddReplyTo(JAK_EMAIL);
$mail->AddAddress('lic@jakweb.ch');
$mail->Subject = 'Update - LiveChat 3.8';
$mail->AltBody = 'HTML Format';
$mail->MsgHTML($body);
$mail->Send();

// Now let us delete all cache files
$cacheallfiles = '../'.JAK_CACHE_DIRECTORY.'/';
$msfi = glob($cacheallfiles."*.php");
if ($msfi) foreach ($msfi as $filen) {
    if (file_exists($filen)) unlink($filen);
}

?>