<?php

use Slim\Http\Request;
use Slim\Http\Response;

// Routes

//$app->get('/[{name}]', function (Request $request, Response $response, array $args) {
//    // Sample log message
//    $this->logger->info("Slim-Skeleton '/' route");
//
//    // Render index view
//    return $this->renderer->render($response, 'index.phtml', $args);
//});
//
//$app->get('/hello/{name}', function ($request, $response, $args) {
//    return $response->write("Hello " . $args['name']);
//});

$app->get('/auth/{uname}/{asiri}', function ($request, $response, $args) {
    global $ad;
    
    $suc = $ad->authenticateUser((string)$args['uname'], (string)$args['asiri']);

    $found = FALSE;
    $errmsg = $succmsg = "";
    $udata = $ret = [];
    if ($suc) :
        //Ordinary User
        $found = TRUE;
    else:
        //Check If Admin
        $suc = $ad->authenticateAdmin((string)$args['uname'], (string)$args['asiri']);
        if ($suc) :
            //Is Admin
            $found = TRUE;
        else:
            $errmsg = "Error: Invalid Username/Password!";
            $ret = ['STATUS'=>0, 'ERROR'=>$errmsg];
        endif;
    endif;

    if ($found) :
        if (!$ad->isEnabled()) :
            $errmsg = "Error: Could not Authenticate this user at the moment. Kindly contact the Administrator via info@kkontech.com";
            $ret = ['STATUS'=>0, 'ERROR'=>$errmsg];
        else:
            $udata['loggedin'] = ($ad->isAdmin())? 201 : 101;
            $udata['userid'] = $ad->getUID();
            $udata['username'] = (string)$args['uname'];
            $udata['radusername'] = $ad->getRADUserName();
            $udata['fullname'] = $ad->getFullName();
            $udata['phoneNo'] = $ad->getMobile();
            $udata['email'] = $ad->getEmail();
            $udata['usertype'] = $ad->getUserType();
            $udata['usertype_id'] = $ad->getUserTypeID();
            $udata['expiration'] = $ad->getExpiration();
            $udata['package'] = $ad->getPackage();
            $udata['package_id'] = $ad->getPackageID();
            $udata['object'] = $ad;

            $succmsg = "Success: Login Successful!";
            $ret = ['STATUS'=>1, 'MSG'=>$succmsg, 'UDATA'=>$udata];
        endif;
    endif;

    return $response->write(json_encode($ret));
});

$app->get('/voipexist/{voip}', function ($request, $response, $args) {
    global $ad;
    
    if ($ad->verifyVOIPExist((string)$args['voip'])) :
        return $response->write(1);
    else:
        return $response->write(0);
    endif;
    
});

$app->get('/userexist/{uname}', function ($request, $response, $args) {
    global $ad;
    
    if ($ad->verifyUserExistAlone((string)$args['uname'])) :
        return $response->write(1);
    else:
        return $response->write(0);
    endif;
    
});

$app->get('/adminexist/{uname}', function ($request, $response, $args) {
    global $ad;
    
    if ($ad->verifyAdminExist((string)$args['uname'])) :
        return $response->write(1);
    else:
        return $response->write(0);
    endif;
    
});

$app->post('/add_subacct', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $uid = filter_var($data['uid'], FILTER_SANITIZE_NUMBER_INT);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $addon = filter_var($data['addon'], FILTER_SANITIZE_STRING);
    
    $subacc = split(',', $addon);
    if (!count($subacc) || ($addon=='null')) :
        return $response->write(json_encode(["STATUS"=>0, "ERROR"=>"You must select at least 1 Addon Service ID"]));
    endif;
    $re = $ad->createSubAccount($uid, $adminID, $subacc);

    if ($re) :
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Sub/Addon Account(s) Added!"]));
    else:
        return $response->write(json_encode(["STATUS"=>0, "ERROR"=>"An Error Occured while adding the Sub/Addon Account(s)"]));
    endif;
    
});


$app->post('/addplan', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $data_volume = filter_var($data['data_volume'], FILTER_SANITIZE_NUMBER_INT);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $plan = filter_var($data['plan'], FILTER_SANITIZE_STRING);
    $description = filter_var($data['description'], FILTER_SANITIZE_STRING);
    $packageid = filter_var($data['packageid'], FILTER_SANITIZE_NUMBER_INT);
    $validity = filter_var($data['validity'], FILTER_SANITIZE_NUMBER_INT);
    $amount = filter_var($data['amount'], FILTER_SANITIZE_NUMBER_FLOAT);
    
//    $description = (!isset($description))? "" : $description;
    
    //Convert Data to Byte
    $by = $data_volume * (1024) * 1024;
    return $response->write($ad->createPlan($plan, $packageid, $by, $amount, $validity, $description, $adminID));

});


$app->post('/cadmin', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $phoneNo = filter_var($data['phoneNo'], FILTER_SANITIZE_STRING);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
    $fullname = filter_var($data['fullname'], FILTER_SANITIZE_STRING);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $username = filter_var($data['username'], FILTER_SANITIZE_STRING);

    return $response->write($ad->createAdmin($username, $pass, $fullname, $email, $phoneNo, 1, $adminID));
});

$app->post('/chpass', function ($request, $response) {
    global $ad;
    $ret = -1;
    
    $data = $request->getParsedBody();
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $is_admin = filter_var($data['is_admin'], FILTER_SANITIZE_NUMBER_INT);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $oldpass = filter_var($data['opass'], FILTER_SANITIZE_STRING);
    
    if ($is_admin == 1) : //echo "IS ADMIN ";
        $ret = $ad->changeAdminPassword($user, $pass, $oldpass);
    else: //echo "IS_USER ";
        $ret = $ad->changePassword($user, $pass, $oldpass);
    endif;


    if ($ret == 1) :
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Password Change Successful!"]));
    else:
        $err = ($ret == 0)? "Password Change Failed!" : "Incorrect Current Password!";
        return $response->write(json_encode(["STATUS"=>0, "ERROR"=>$err]));
    endif;
});

$app->post('/cuser', function ($request, $response) {
    global $ad;
    $ret = -1;
    
    $data = $request->getParsedBody();
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $username = filter_var($data['username'], FILTER_SANITIZE_STRING);
    
    $rad_exist = $ad->loadRadUser($raduser, 1, 0);
    
    //Get Message
    $raw_msg = $ad->getCannedMessage("LOGIN_INFO");
    
    if (count($rad_exist) > 0) :
        $rett = $ad->createClient($username, $pass, $raduser, $adminID);
        $user_dets = $ad->loadClientRec($username);
        if (count($user_dets)):
            $user_det = $user_dets[$username];
            $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
            $email = $user_det["EMAIL"];
            $admin_user = 0;

            $url = SERVER_URL . "";

            $msg = sprintf($raw_msg, $fullname, $username, $pass, $url);

            $sent = $ad->sendEmail($email, EMAIL_SENDER, "Account Creation on KKONTech Online", $msg);
        endif;
        return $response->write($rett);
    else:
        return $response->write("Error: Invalid Service ID!");
    endif;
});

$app->post('/cvoip', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $voip_no = filter_var($data['voip_no'], FILTER_SANITIZE_STRING);
    
    $rad_exist = $ad->loadRadUser4VOIP($raduser, 1, 0);

    if (count($rad_exist) > 0) :
        return $response->write($ad->createVOIP($raduser, $voip_no, $adminID));

    else:
        return $response->write("Error: Invalid Service ID!");        
    endif;
});

$app->delete('/del_subacct/{uid}/(radu}', function ($request, $response, $args) {
    global $ad;
        
    $uid = (integer)$args['uid'];
    $radu = (integer)$args['radu'];
    
    if ($uid == 0 || $radu == "") :
        return $response->write("Error: Data Integrity Test Failed");
    endif;
    
    return $response->write($ad->delSubAccount($uid, $radu));
});

$app->post('/eadmin', function ($request, $response) {
    global $ad;

    $data = $request->getParsedBody();
    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $fullname = filter_var($data['fullname'], FILTER_SANITIZE_STRING);
    $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
    $phoneNo = filter_var($data['phoneNo'], FILTER_SANITIZE_STRING);
    $changep = filter_var($data['changep'], FILTER_SANITIZE_STRING);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $passconfirm = filter_var($data['passconfirm'], FILTER_SANITIZE_STRING);
    $is_enabled = filter_var($data['is_enabled'], FILTER_SANITIZE_NUMBER_INT);
    $username = filter_var($data['username'], FILTER_SANITIZE_STRING);
    
    if ($username == "") :
        return $response->write("Error! Invalid Username.");
    endif;
    
    $is_admin_pg = 1;
    $passwd = "";
    
    if (isset($changep) && ($changep == 'on') ) :
        if ($pass == $passconfirm) :
            if ($pass != "******************") :

            else:
                return $response->write("Error: Invalid Password!");
            endif;
        else:
            return $response->write("Error: Password and Confirm Pass do not match!");
        endif;

        $r = $ad->verifyPassword($username, $pass, $is_admin_pg);
        if ($r == 1) {
            return $response->write("Error: New Password must be different from Current Password!");
        } elseif ($r == -1) {
            return $response->write("Error: Invalid Username/Password provided");
        }

        $passwd = $pass;

    endif;
    if ($uxu != $username) :
        return $response->write("Error: Data Integrity Test Failed!");
    endif;

    return $response->write($ad->editAdmin($username, $passwd, $fullname, $email, $phoneNo, $is_enabled));
});

$app->post('/eplan', function ($request, $response) {
    global $ad;

    $data = $request->getParsedBody();
    $plan = filter_var($data['plan'], FILTER_SANITIZE_STRING);
    $pid = filter_var($data['pid'], FILTER_SANITIZE_NUMBER_INT);
    $planid = filter_var($data['planid'], FILTER_SANITIZE_NUMBER_INT);
    $rxp = filter_var($data['rxp'], FILTER_SANITIZE_STRING);
    $data_volume = filter_var($data['data_volume'], FILTER_SANITIZE_NUMBER_INT);
    $packageid = filter_var($data['packageid'], FILTER_SANITIZE_NUMBER_INT);
    $amount = filter_var($data['amount'], FILTER_SANITIZE_NUMBER_FLOAT);
    $is_enabled = filter_var($data['is_enabled'], FILTER_SANITIZE_NUMBER_INT);
    $validity = filter_var($data['validity'], FILTER_SANITIZE_NUMBER_INT);
    $description = filter_var($data['description'], FILTER_SANITIZE_STRING);
    
    if ($plan == "") :
        return $response->write("Error! Invalid Plan Name.");
    endif;

    if ($pid != $planid) :
        return $response->write("Error: Data Integrity Test Failed!");
    endif;

    if ($rxp != $plan) :
        return $response->write("Error: Data 2 Integrity Test Failed!");
    endif;
    
    //Convert Data to Byte
    $by = $data_volume * (1024) * 1024;

    return $response->write($ad->editPlan($planid, $plan, $packageid, $by, $amount, $validity, $description, $is_enabled));
});

$app->post('/euser', function ($request, $response) {
    global $ad;

    $data = $request->getParsedBody();
    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $rxu = filter_var($data['rxu'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $chradu = filter_var($data['chradu'], FILTER_SANITIZE_STRING);
    $changep = filter_var($data['changep'], FILTER_SANITIZE_STRING);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $passconfirm = filter_var($data['passconfirm'], FILTER_SANITIZE_STRING);
    $is_enabled = filter_var($data['is_enabled'], FILTER_SANITIZE_NUMBER_INT);
    $username = filter_var($data['username'], FILTER_SANITIZE_STRING);
    
    if ($username == "") :
        return $response->write("Error! Invalid Username.");
    endif;
    if (isset($chradu) && $chradu == "on" && $raduser == "") :
        return $response->write("Error! Invalid New Service ID.");
    endif;
    
    $is_admin_pg = 0;
    $passwd = "";
    
    if (isset($changep) && ($changep == 'on') ) :
        if ($pass == $passconfirm) :
            if ($pass != "******************") :

            else:
                return $response->write("Error: Invalid Password!");
            endif;
        else:
            return $response->write("Error: Password and Confirm Pass do not match!");
        endif;

        $r = $ad->verifyPassword($username, $pass, $is_admin_pg);
        if ($r == 1) {
            return $response->write("Error: New Password must be different from Current Password!");
        } elseif ($r == -1) {
            return $response->write("Error: Invalid Username/Password provided");
        }

        $passwd = $pass;

    endif;
    if ($uxu != $username) :
        return $response->write("Error: Data Integrity Test Failed!");
    endif;

    if (isset($chradu) && $chradu == "on" && $rxu == $raduser) :
        return $response->write("Error: Radius Data Integrity Test Failed!");
    endif;

    $radius_user = "";
    if (isset($chradu) && $chradu == "on" && $rxu != $raduser) :
        $radius_user = $raduser;
    endif;

    return $response->write($ad->editUser($username, $radius_user, $passwd, $is_enabled));
});


$app->post('/euserp', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $chradu = filter_var($data['chradu'], FILTER_SANITIZE_STRING);
    $phoneNo = filter_var($data['phoneNo'], FILTER_SANITIZE_STRING);
    $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
    $userid= filter_var($data['userid'], FILTER_SANITIZE_NUMBER_INT);
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);

    if ($user == "" /*|| $user != $_SESSION[$sid.'username']*/) :
        return $response->write("Error! Invalid Data.");
    endif;
    if ($raduser == "") :
        return $response->write("Error! Invalid R. Data.");
    endif;
    if (isset($chradu) && $chradu == "on" && ($email == "") || ($phoneNo == "") ) :
        return $response->write("Error! Email and Phone Number Cannot be Blank!");
    endif;
    
    $rads = $ad->loadAllRADAccount($userid);
    $rad = [];
    foreach ($rads[$user] as $k=>$r):
        $rad[] = $r["RAD_USERNAME"];
    endforeach;
    return $response->write($ad->updateUserProfile($rad, $email, $phoneNo)); 
});


$app->post('/euserp2', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $chradu2 = filter_var($data['chradu2'], FILTER_SANITIZE_STRING);
    $fullname = filter_var($data['fullname'], FILTER_SANITIZE_STRING);
    $address = filter_var($data['address'], FILTER_SANITIZE_STRING);
    $city = filter_var($data['city'], FILTER_SANITIZE_STRING);
    $state = filter_var($data['state'], FILTER_SANITIZE_STRING);

    if ($raduser == "") :
        return $response->write("Error! Invalid Service ID");
    endif;
    if (isset($chradu2) && $chradu2 == "on" && ($fullname == "") || ($address == "") || ($city == "") || ($state == "") ) :
        return $response->write("Error! All Fields Cannot be Blank!");
    endif;

    return $response->write($ad->updateUserProfile2($raduser, $fullname, $address, $city, $state)); 
});


$app->get('/getDetails/{user}', function ($request, $response, $args) {
    global $db;
    
    $user = (string)$args['user'];
    $strsql = "SELECT tc.ID, company, expiration, MAC_ADDRESS FROM `tblclients` tc
            LEFT JOIN rm_users ru ON tc.MAC_ADDRESS = ru.username
            WHERE tc.USERNAME LIKE ?";
    $some_st = $db->select($strsql, "s", $user);
    if ($some_st->num_rows() >= 1) :
        while ($row = $some_st->fetch_assoc()) :
            $exp = isExpired($row['expiration']);
            list($y, $m, $d) = sscanf($row['expiration'], '%d-%d-%d %s');      
            $du = "$d-$m-$y";
            if ($exp) $st = "Your account expired on <strong>$du</strong>";
            else $st = "Your due date is <strong>$du</strong>";
            return $response->write("Success|{$row['company']}|$st|{$row['expiration']}|{$row['MAC_ADDRESS']}|{$row['ID']}");
        endwhile;
    else:
        return $response->write("Error: Invalid Username, Please check and try again.");
    endif;

});

$app->get('/loadRadUser/{user}', function ($request, $response, $args) {
    global $ad;
    
    $user = (string)$args['user'];
    $suc = $ad->loadRadUserObject($user, 1, 0);
    $r = [];

    foreach ($suc as $key => $row) {
        $r[] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                            "LASTNAME"=> $row->lastname, 
                            "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                            "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                            "EXPIRATION" => $row->expiration, "IS_ENABLED" => $row->enableuser);
    }
    return $response->write(json_encode($r));

});

$app->get('/loadRadUser4VOIP/{user}', function ($request, $response, $args) {
    global $ad;
    
    $user = (string)$args['user'];
    $suc = $ad->loadRadUserObject4VOIP($user, 1, 0);
    $r = [];

    foreach ($suc as $key => $row) {
        $r[] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                            "LASTNAME"=> $row->lastname, 
                            "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                            "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                            "EXPIRATION" => $row->expiration, "IS_ENABLED" => $row->enableuser);
    }
    return $response->write(json_encode($r));

});

$app->get('/lstSubAcc', function ($request, $response, $args) {
    global $ad;
    
    $uid = (integer)$args['uid'];
    $user = (string)$args['user'];
    $sacct = $ad->loadSubAccount($uid);
    if (!isset($sacct[$user])):
        return $response->write("Error: No Sub-Account Found or Unable to load such at the moment<br/>");
    else:
        return $response->write(json_encode($sacct));
    endif;

});

$app->post('/recoverpass', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);

    $is_user = $ad->verifyUserExist($user);

    if ($is_user == 0) :
        //does not exist, verify if Admin
        $is_admin = $ad->verifyAdminExist($user);
        if ($is_admin == 0) :
            return $response->write("Error: Invalid Username, Please verify and try again later!");
        else:
            if ($is_admin == 2) :
                return $response->write("Error: Account has been disabled! Contact Administrator");
            endif;
        endif;
    else:
        if ($is_user == 2) :
            return $response->write("Error: Account has been disabled! Contact Administrator");
        endif;
    endif;

    //Get Message
    $raw_msg = $ad->getCannedMessage("PASS_RESET_REQUEST");

    if ($is_user) :
        $user_det = $ad->loadClientRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    elseif ($is_admin) :
        $user_det = $ad->loadAdminRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    endif;

    $tk = new Password_Generator();
    $token = $tk->generate(45, 60, true, false, true, false);
    $entoken = base64_encode($token);
    $enuser = $tk->generate(3,3) . base64_encode($user);

    //Store Token
    $save = $ad->savePResetToken($user, $token);

    if ($save == 1) :

        $url = SERVER_URL . RECOVERY_URL . "";

        $ddate = date("D, jS F, Y H:i:s T");

        $msg = sprintf($raw_msg, $fullname, $user, $url, $entoken, $enuser, $user, $ddate);

        $sent = $ad->sendEmail($email, EMAIL_SENDER, "Error: Password Reset Request on KKONTech Online (Via Mobile App)", $msg);
        if ($sent):
            return $response->write("Success: Password reset link sent to your mail on record [$email]");
        else: 
            return $response->write("Error: Unable to send Password Reset Link at this time.");
        endif;
    else:
        return $response->write($save);
    endif;
});

$app->post('/resetpass', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $tk = filter_var(base64_decode(urldecode($data['tk'])), FILTER_SANITIZE_STRING);
    $user = filter_var(base64_decode(substr(urldecode($data['user']), 3)), FILTER_SANITIZE_STRING);
    $pass = filter_var(base64_decode(urldecode($data['pass'])), FILTER_SANITIZE_STRING);

    $is_user = $ad->verifyUserExist($user);

    if ($is_user == 0) :
        //does not exist, verify if Admin
        $is_admin = $ad->verifyAdminExist($user);
        if ($is_admin == 0) :
            return $response->write("Error: Invalid Username, Please verify and try again later!");
        else:
            if ($is_admin == 2) :
                return $response->write("Error: Account has been disabled! Contact Administrator");
            endif;
        endif;
    else:
        if ($is_user == 2) :
            return $response->write("Error: Account has been disabled! Contact Administrator");
        endif;
    endif;

    //Get Message
    $raw_msg = $ad->getCannedMessage("PASS_RESET_SUCCESS");
    $admin_user = 0;

    if ($is_user) :
        $user_det = $ad->loadClientRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    elseif ($is_admin) :
        $user_det = $ad->loadAdminRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
        $admin_user = 1;
    endif;
    
    if ($ad->verifyPResetToken($user, $tk)) :
        //Valid Token
        $resp = $ad->resetPassword($user, $pass, $tk, $admin_user);
        if ($resp == 1):
            $url = SERVER_URL . "";

            $msg = sprintf($raw_msg, $fullname, $user, $url);

            $sent = $ad->sendEmail($email, EMAIL_SENDER, "Password Reset on KKONTech Online (Via Mobile App)", $msg);
            if ($sent):
                return $response->write("Success: Password reset successful and update sent to your mail on record [$email]");
            else: 
                return $response->write("Success: Password reset successful.");
            endif;
        else:
            return $response->write("Error: Password Reset Failed!");
        endif;

    else:
        //Invalid
        return $response->write("Error: Expired/Invalid Token!");
    endif;
});

$app->post('/requery', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $txnref = filter_var($data['txnref'], FILTER_SANITIZE_STRING);
    
    $vval =  $ad->getTranx4Verification($txnref);
    $product_id = PRODUCTID;
    $hashh = $ad->hashGeneratorNew($product_id . $txnref . HASH_KEY);
    $url = "https://webpay.interswitchng.com/collections/api/v1/gettransaction.json?amount=" . ($vval['REQ_AMOUNT']*100) . "&transactionreference=".$vval['TRANS_ID']."&productid=". $product_id;  
    $vArray = curlURL($url, $hashh);
    $expd = $vval["EXPIRY_DATE"];
    $exp = isExpired($vval["EXPIRY_DATE"]); //echo "<br>$expd :: $exp<br>";
    $nu_expd = $expd;
    $validity = 0;
    $is_okay = 0;
    
    if ($vArray->MerchantReference == $txnref) :
        //Response Integrity Passed
        if ($vArray->ResponseCode == "00") :
            //Transaction Successfully but verify amount paid
            if ($vval["REQ_AMOUNT"] == ($vArray->Amount/100)) :
                //Everything is Okay
                $is_okay = 1;
                $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
                $exp = isExpired($userdet['EXPIRATION']);
                $expd = $userdet['EXPIRATION'];
                $limitcomb = $userdet["LIMITCOMB"];
                $validity = ($vval["NMONTHS"]*$userdet["VALIDITY"]);
                if ($exp) :
                    $nu_expd = add_date(date("Y-m-d H:i:s"), ($vval["NMONTHS"]*$userdet["VALIDITY"]) );
                else:
                    $nu_expd = add_date($userdet['EXPIRATION'], ($vval["NMONTHS"]*$userdet["VALIDITY"]) );
                endif;

            else:
                //Wrong Amount Paid
                $vArray->MerchantReference = ($vArray->MerchantReference=="")? $txnref : $vArray->MerchantReference;
            endif;
        else:
            //Transaction Failed

        endif;
    else:
        //Response Integrity Failed
        $vArray->MerchantReference = ($vArray->MerchantReference=="")? $txnref : $vArray->MerchantReference;
    endif;

    //Save Transaction
    $pdate = date("Y-m-d H:i:s"); 
    $appDate = date("Y-m-d H:i:s", strtotime($vArray->TransactionDate));
    $ad->saveTranxResp($vArray->MerchantReference, $vArray->PaymentReference, ($vArray->Amount/100), CURRENCY, 
                        $vArray->ResponseCode, $vArray->ResponseDescription, $nu_expd, $pdate, "webpay", $appDate,
                        $vArray->CardNumber, $vArray->RetrievalReferenceNumber);

    if ($is_okay) :
        $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"]*$userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $vArray->MerchantReference);
        //Get Message
        $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS");
        $url = SERVER_URL . "";
        $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $nu_expd, $vArray->MerchantReference, $vArray->PaymentReference, $url);

        $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "Account Renewal on KKONTech Online (Mobile)", $msg);

        return $response->write("Success: Approved Successfully" .
        "\nTransaction Ref: " . $vArray->MerchantReference . "\n" .
        "Payment Ref: " . $vArray->PaymentReference);
    endif;

    return $response->write("Error: Transaction was not Successful\nTransaction Ref: " . $vArray->MerchantReference . 
          "\nReason: " . $vArray->ResponseDescription);

});




// Catch-all route to serve a 404 Not Found page if none of the routes match
// NOTE: make sure this route is defined last
$app->map(['GET', 'POST', 'PUT', 'DELETE', 'PATCH'], '/{routes:.+}', function($req, $res) {
    $handler = $this->notFoundHandler; // handle using the default Slim page not found handler
    return $handler($req, $res);
});