<?php

include_once "includes/opener.php";
include_once 'includes/db.inc';
// Open db connection

if (isset($_SESSION[$sid . 'loggedin'])):
    ?>
    <script>
        window.location.href = 'dasha.php';
    </script>
    <?PHP
else:
    $https = ((!empty($_SERVER['HTTPS'])) && ($_SERVER['HTTPS'] != 'off')) ? true : false;
    if (!$https):
        header('Location: https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
        //        header("location: " . "/recover-pass");
    endif;
endif;

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);

// Enable error reporting for debugging
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

$all_products = @$dashboard->getAllProductsSalesAdmin() ?? ['fob' => [], 'third_party' => []];

// Ensure the structure has the required keys
if (!isset($all_products['fob'])) {
    $all_products['fob'] = [];
}
if (!isset($all_products['third_party'])) {
    $all_products['third_party'] = [];
}
//print_r($all_products);
$products = [
    ['id' => 1, 'name' => 'Premium Max+ Plan', 'price' => 45231.89],
    ['id' => 2, 'name' => 'Installation', 'price' => 45231.89],
    ['id' => 3, 'name' => 'Battery Pack', 'price' => 45231.89],
];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>MyFOB [Web] | Customer Self Onboarding</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="description"
        content="FiberOne is the largest Fiber to the Home (FTTH) premium broadband provider in Nigeria. We deliver excellent Fiber internet services across homes and offices">
    <meta name="author" content="MATILUKO Opeyemi Emmanuel">
    <link rel="shortcut icon" type="image/x-icon" href="img/favicon.ico" />
    <link rel="icon" type="image/x-icon" href="img/favicon.ico" />
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/fontheadache.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="plugins/iCheck/square/blue.css">
    <link rel="stylesheet" href="dist/css/custom.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap" rel="stylesheet" />
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!-- Paystack -->
    <script src="https://js.paystack.co/v1/inline.js"></script>


    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: "AvenirLTStd", "Nunito", sans-serif;
        }

        /* Landing Page Hero Section */
        .landing-hero {
            background-image: url("./web-banners/bg-image.png");
            background-repeat: no-repeat;
            background-size: cover;
            background-position: center;
            min-height: 500px;
            padding: 20px 40px;
            position: relative;
        }

        /* Header Styles from Template */
        .header {
            background: #0d3e9b;
            padding: 1rem;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            position: sticky;
            top: 0;
            z-index: 9999;
            border-radius: 40px;
            margin-bottom: 20px;
        }

        .nav-container {
            display: flex;
            color: white;
            justify-content: space-between;
            align-items: center;
            max-width: 1200px;
            margin: 0 auto;
            border-radius: 0.375rem;
        }

        .logo {
            font-size: 1.5rem;
            font-weight: bold;
            color: white;
        }

        .logo img {
            height: 30px;
            width: 157px;
            color: white;
        }

        .nav-links {
            display: flex;
            gap: 2rem;
            list-style: none;
        }

        .nav-links a {
            text-decoration: none;
            color: white;
            font-weight: 500;
            transition: color 0.3s;
        }

        .nav-links a:hover {
            color: #dbeafe;
        }

        .nav-buttons {
            display: flex;
            gap: 1rem;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 0.375rem;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }

        .btn-primary {
            background: white !important;
            color: #185de0 !important;
            border-radius: 24px;
        }

        .btn-primary:hover {
            background: #f3f4f6 !important;
        }

        .btn-secondary {
            background: white;
            color: #185de0 !important;
            border-radius: 16px;
        }

        .btn-secondary:hover {
            background: white;
            color: #185de0;
        }

        /* Mobile Menu */
        .mobile-menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
            color: white;
        }

        .mobile-menu {
            display: none;
            position: fixed;
            overflow-y: auto;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: white;
            z-index: 10000;
            padding: 1rem;
        }

        .mobile-menu.active {
            display: block;
        }

        .mobile-menu-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding: 1rem 0;
        }

        .mobile-menu-close {
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
            color: #374151;
        }

        .mobile-menu-nav {
            display: flex;
            flex-direction: column;
            gap: 0;
        }

        .mobile-menu-nav a {
            padding: 1.5rem 0;
            text-decoration: none;
            color: #374151;
            text-align: center;
            font-size: 1.1rem;
            font-weight: 500;
            border-bottom: 1px solid #e5e7eb;
        }

        .mobile-menu-buttons {
            margin-top: 2rem;
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }

        .mobile-menu-buttons .btn {
            text-align: center;
            padding: 1rem;
            font-size: 1.1rem;
        }

        .mobile-get-connect {
            background: #185de0;
            color: white;
        }

        .mobile-get-connect:hover {
            background: #3576f0 !important;
            color: white;
        }

        .mobile-login {
            border: 1px solid #185de0;
            color: #185de0;
        }

        /* Hero Section */
        .hero {
            display: flex;
            align-items: center;
            justify-content: center;

            overflow: visible;
            padding-top: 20px;
            padding-bottom: 30px;
            width: 100%;
        }

        .hero-content {
            display: flex;
            justify-content: center;
            flex-direction: column;
            align-items: center;
            color: white;
            width: 100%;
        }

        .hero h1 {
            font-size: 56px;
            font-weight: bold;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
            margin-bottom: 30px;
            text-align: center;
        }

        /* Service Form from Template */
        .service-form {
            padding: 2rem;
            border-radius: 0.5rem;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            width: 100%;
        }

        .form-row-hero {
            display: flex;
            justify-content: space-between;
            background-color: #f4f4f4;
            gap: 1rem;
            margin-bottom: 1rem;
            border-radius: 0.375rem;
            padding: 1.5rem 2rem;

        }

        .form-group-hero {
            display: flex;
            flex-direction: column;
            flex: 1;
            position: relative;
            overflow: visible;
        }

        .form-input-hero {
            padding: 1rem 1.25rem;
            border: none;
            font-size: 1.1rem;
            outline: none;
            box-shadow: none;
            background-color: #f4f4f4;
            width: 100%;
            min-height: 50px;
            color: #333;
        }

        .form-input-hero:focus {
            outline: none;
            box-shadow: none;
            background-color: #fff;
            color: #333;
        }

        .form-input-hero::placeholder {
            color: #999;
            font-size: 1rem;
        }

        .check-btn {
            background: #0d3e9b;
            color: white;
            padding: 14px 28px;
            border: none;
            border-radius: 8px;
            font-size: 1.5rem;
            font-weight: 500;
            cursor: pointer;
            width: 600px;
            min-height: 54px;
            transition: background 0.3s;
        }

        .check-btn:hover {
            background: #1d4ed8;
        }

        /* Address Suggestions Styling */
        #addressSuggestions {
            position: absolute;
            top: calc(100% + 5px);
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            max-height: 300px;
            overflow-y: auto !important;
            overflow-x: hidden;
            z-index: 99999;
            margin: 0;
            padding: 0;
            scroll-behavior: smooth;
            scrollbar-width: thin;
            scrollbar-color: #888 #f1f1f1;
            -webkit-overflow-scrolling: touch;
        }

        /* Scrollbar styling for webkit browsers (Chrome, Edge, Safari) */
        #addressSuggestions::-webkit-scrollbar {
            width: 12px;
            -webkit-appearance: none;
        }

        #addressSuggestions::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 8px;
            margin: 4px 0;
        }

        #addressSuggestions::-webkit-scrollbar-thumb {
            background: #888;
            border-radius: 8px;
            border: 2px solid #f1f1f1;
            min-height: 40px;
        }

        #addressSuggestions::-webkit-scrollbar-thumb:hover {
            background: #555;
        }

        #addressSuggestions::-webkit-scrollbar-thumb:active {
            background: #333;
        }

        #addressSuggestions .list-group-item {
            padding: 12px 16px;
            cursor: pointer;
            border: none;
            border-bottom: 1px solid #f0f0f0;
            transition: background 0.2s;
            font-size: 0.95rem;
            color: #333;
        }

        #addressSuggestions .list-group-item:last-child {
            border-bottom: none;
        }

        #addressSuggestions .list-group-item:hover {
            background-color: #f8f9fa;
            color: #0d3e9b;
        }

        #addressSuggestions .list-group-item.active {
            background-color: #0d3e9b;
            color: white;
        }

        /* Main Content Container */
        .main-content {
            padding: 0;
            min-height: 100vh;
            background-color: white;
        }

        .main-content-container {
            padding: 20px 40px;
            max-width: 1200px;
            margin: 0 auto;
        }

        h2 {
            font-size: 23px;
        }

        .page-title {
            font-size: 23px;
            font-weight: 500;
            margin: 0;
        }

        .plans-section {
            padding: 20px;
        }

        .plans-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 24px;
            margin-top: 20px;
        }

        .plan-card {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
            cursor: pointer;
            transition: transform 0.2s, box-shadow 0.2s;
            position: relative;
        }

        .plan-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        .plan-icon-select {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 16px;
        }

        .plan-icon {
            font-size: 32px;
        }

        .circle-dot {
            width: 24px;
            height: 24px;
            border: 2px solid #4285f4;
            border-radius: 50%;
            background: transparent;
            position: relative;
        }

        .plan-card.selected .circle-dot::after {
            content: "";
            width: 12px;
            height: 12px;
            background: #4285f4;
            border-radius: 50%;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .plan-title {
            font-size: 20px;
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 8px;
        }

        .plan-description {
            color: #666;
            font-size: 14px;
            line-height: 1.5;
        }

        .category-plans-section {
            margin-top: 20px;
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            color: #4285f4;
            text-decoration: none;
            font-weight: 500;
            margin-bottom: 20px;
        }

        .plans-title {
            font-size: 24px;
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 20px;
        }

        .plan-detail-card {
            background: white;
            border-radius: 0.375rem;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .plan-detail-header {
            border-radius: 0.375rem;
            background: linear-gradient(to bottom, #185de0, #e73333);
            padding: 1.25rem;
        }

        .plan-detail-card::before {
            content: "";
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 100%;
            background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            transform: rotate(45deg);
        }

        .plan-name {
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 0.5rem;
            color: white !important;
        }

        .plan-speed {
            font-size: 0.9rem;
            margin-bottom: 1rem;
            opacity: 0.9;
        }

        .plan-price {
            font-size: 1.75rem;
            font-weight: bold;
            margin-bottom: 0.25rem;
        }

        .plan-billing {
            font-size: 0.85rem;
            opacity: 0.8;
            margin-bottom: 1rem;
        }

        .plan-detail-header>.plan-description {
            font-size: 0.9rem;
            margin-bottom: 1.5rem;
            opacity: 0.9;
            color: white;
        }

        .plan-features {
            list-style: none;
            color: #444449;
            padding: 1.25rem;
        }

        .plan-features li {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 0.5rem;
            font-size: 0.85rem;
        }

        .plan-features li::before {
            content: "✓";
            color: #4285f4;
            position: absolute;
            left: 0;
        }

        .select-plan-btn {
            background: #4285f4;
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            width: 100%;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.2s;
        }

        .select-plan-btn:hover {
            background: #3367d6;
        }

        .checkout-container {
            display: flex;
            gap: 24px;
            flex-wrap: wrap;
        }

        .checkout-main {
            flex: 2;
            min-width: 300px;
        }

        .checkout-sidebar {
            flex: 1;
            min-width: 250px;
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .cart-section,
        .vendor-section,
        .payment-section,
        .order-summary,
        .installation-section {
            background: white;
            border-radius: 12px;
            padding: 24px;
            margin-bottom: 24px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .cart-header,
        .summary-title,
        .installation-title {
            font-size: 18px;
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 16px;
        }

        .cart-items {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .cart-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 0;
            border-bottom: 1px solid #f0f0f0;
        }

        .cart-item:last-child {
            border-bottom: none;
        }

        .cart-item-checkbox {
            width: 20px;
            height: 20px;
        }

        .cart-item-info {
            flex: 1;
            font-size: 16px;
            color: #1a1a1a;
        }

        .cart-item-price {
            font-size: 16px;
            font-weight: 600;
            color: #1a1a1a;
        }

        .section-title {
            font-size: 20px;
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 20px;
        }

        .filter-tabs {
            display: flex;
            margin-bottom: 20px;
            background-color: #d9e5fc;
            width: fit-content;
            padding: 5px;
            border-radius: 6px;
        }

        .filter-tab {
            padding: 8px 8px;
            border: none;
            background: none;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.3s;
        }

        .filter-tab.active {
            background: white !important;
            border-radius: 20px;
            color: black !important;
        }

        .vendor-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 16px;
        }

        .vendor-name {
            font-size: 18px;
            font-weight: 600;
            color: #1a1a1a;
        }

        .filter-button {
            background: none;
            border: none;
            color: #4285f4;
            font-size: 14px;
            cursor: pointer;
        }

        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 24px;
        }

        .product-card {
            position: relative;
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .product-image img {
            width: 100%;
            height: 150px;
            object-fit: cover;
        }

        .product-info {
            padding: 16px;
        }

        .product-name {
            font-size: 16px;
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 8px;
        }

        .product-price {
            font-size: 16px;
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 8px;
        }

        .product-rating {
            color: #f4c107;
            font-size: 14px;
        }

        .product-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            gap: 12px;
            opacity: 0;
            transition: opacity 0.2s;
        }

        .product-card:hover .product-overlay {
            opacity: 1;
        }

        .overlay-button {
            background: #e74c3c;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
        }

        .overlay-button.view-button {
            background: #4285f4;
        }

        .installation-header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 16px;
        }

        .location-icon {
            font-size: 20px;
        }

        .address-input {
            width: 100%;
            padding: 12px;
            border: 1px solid #e1e5e9;
            border-radius: 8px;
            font-size: 14px;
            margin-bottom: 12px;
        }

        .address-details {
            color: #666;
            font-size: 14px;
        }

        .payment-options {
            display: flex;
            flex-direction: column;
            gap: 12px;
            margin-bottom: 24px;
        }

        .payment-option {
            padding: 12px;
            border: 1px solid #e1e5e9;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            color: #666;
        }

        .payment-option.selected {
            border-color: #4285f4;
            background: rgba(66, 133, 244, 0.1);
            color: #4285f4;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            font-size: 14px;
            color: #666;
            margin-bottom: 12px;
        }

        .summary-row.total {
            font-weight: 600;
            color: #1a1a1a;
        }

        .checkout-button {
            background: #4285f4;
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            width: 100%;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.2s;
        }

        .checkout-button:hover {
            background: #3367d6;
        }

        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }

        .modal-content {
            background: white;
            border-radius: 12px;
            padding: 24px;
            max-width: 800px;
            width: 90%;
            max-height: 80vh;
            overflow-y: auto;
            position: relative;
        }

        .modal-close {
            position: absolute;
            top: 16px;
            right: 16px;
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
        }

        .modal-product-section {
            display: flex;
            gap: 24px;
            flex-wrap: wrap;
        }

        .modal-product-images {
            flex: 1;
            min-width: 200px;
        }

        .modal-main-image img {
            width: 100%;
            border-radius: 8px;
        }

        .modal-thumbnail-images {
            display: flex;
            gap: 8px;
            margin-top: 8px;
        }

        .modal-thumbnail img {
            width: 60px;
            height: 60px;
            border-radius: 8px;
            cursor: pointer;
        }

        .modal-product-details {
            flex: 1;
            min-width: 200px;
        }

        .modal-product-title {
            font-size: 20px;
            font-weight: 600;
            color: #1a1a1a;
            margin-bottom: 16px;
        }

        .modal-price-section {
            display: flex;
            flex-direction: column;
            gap: 8px;
            margin-bottom: 16px;
        }

        .modal-price {
            font-size: 18px;
            font-weight: 600;
            color: #1a1a1a;
        }

        .modal-power-info {
            color: #666;
            font-size: 14px;
        }

        .modal-rating {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 16px;
        }

        .modal-stars {
            color: #f4c107;
            font-size: 14px;
        }

        .modal-rating-text {
            color: #666;
            font-size: 14px;
        }

        .modal-product-description {
            color: #666;
            font-size: 14px;
            margin-bottom: 16px;
        }

        .modal-quantity-section {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-bottom: 16px;
        }

        .modal-quantity-label {
            font-size: 14px;
            font-weight: 600;
            color: #1a1a1a;
        }

        .modal-quantity-controls {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .modal-quantity-btn {
            background: #e1e5e9;
            border: none;
            padding: 8px 12px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
        }

        .modal-quantity-input {
            width: 60px;
            padding: 8px;
            border: 1px solid #e1e5e9;
            border-radius: 8px;
            text-align: center;
        }

        .modal-stock-info {
            color: #666;
            font-size: 14px;
        }

        .modal-add-to-cart {
            background: #e74c3c;
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            width: 100%;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            margin-bottom: 16px;
        }

        .modal-section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            cursor: pointer;
            margin-bottom: 8px;
        }

        .modal-section-title {
            font-size: 16px;
            font-weight: 600;
            color: #1a1a1a;
        }

        .modal-section-icon {
            font-size: 16px;
            color: #666;
        }

        .modal-section-content {
            color: #666;
            font-size: 14px;
        }

        .modal-section-content.collapsed {
            display: none;
        }

        .modal-features-list {
            list-style: none;
            padding: 0;
        }

        .modal-features-list li {
            margin-bottom: 8px;
            position: relative;
            padding-left: 20px;
        }

        .modal-features-list li::before {
            content: "✓";
            color: #4285f4;
            position: absolute;
            left: 0;
        }

        .modal-product-type,
        .modal-delivery-info {
            color: #666;
            font-size: 14px;
            margin-bottom: 8px;
        }

        .modal-terms-link {
            color: #4285f4;
            text-decoration: none;
            font-size: 14px;
        }

        .toast {
            visibility: hidden;
            min-width: 250px;
            margin-left: -125px;
            background: #e74c3c;
            color: white;
            text-align: center;
            border-radius: 12px;
            padding: 16px 24px;
            position: fixed;
            z-index: 9999;
            left: 50%;
            bottom: 40px;
            font-size: 15px;
            font-weight: 500;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            opacity: 0;
            transform: translateY(20px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        .toast.show {
            visibility: visible;
            opacity: 1;
            transform: translateY(0);
        }

        .toast.success {
            background: linear-gradient(135deg, #10b981, #059669);
        }

        .toast.error {
            background: linear-gradient(135deg, #ef4444, #dc2626);
        }

        .coverage-result-container {
            margin-top: 20px;
            animation: slideIn 0.5s ease-out;
        }

        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .status-card {
            border-radius: 12px;
            padding: 24px;
            margin-top: 20px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            animation: fadeInUp 0.5s ease-out;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .status-card.success {
            background: linear-gradient(135deg, #ecfdf5, #d1fae5);
            border: 2px solid #10b981;
        }

        .status-card.coming-soon {
            background: linear-gradient(135deg, #fef3c7, #fde68a);
            border: 2px solid #f59e0b;
        }

        .status-header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
        }

        .status-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            animation: scaleIn 0.5s ease-out 0.2s both;
        }

        @keyframes scaleIn {
            from {
                transform: scale(0);
            }

            to {
                transform: scale(1);
            }
        }

        .status-card.success .status-icon {
            background: #10b981;
            color: white;
        }

        .status-card.coming-soon .status-icon {
            background: #f59e0b;
            color: white;
        }

        .status-title {
            font-size: 20px;
            font-weight: 600;
            color: #1a1a1a;
            margin: 0;
        }

        .status-card.success .status-title {
            color: #047857;
        }

        .status-card.coming-soon .status-title {
            color: #b45309;
        }

        .status-message {
            color: #4b5563;
            font-size: 15px;
            line-height: 1.6;
            margin-top: 8px;
        }

        .status-location {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-top: 16px;
            padding: 12px;
            background: white;
            border-radius: 8px;
            font-size: 14px;
            color: #6b7280;
        }

        .status-location-icon {
            font-size: 18px;
            color: #4285f4;
        }

        .coverage-details {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 12px;
            margin-top: 16px;
        }

        .coverage-detail-item {
            background: white;
            padding: 12px;
            border-radius: 8px;
            border-left: 3px solid #10b981;
        }

        .coverage-detail-label {
            font-size: 11px;
            font-weight: 600;
            color: #6b7280;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 4px;
        }

        .coverage-detail-value {
            font-size: 14px;
            font-weight: 600;
            color: #1a1a1a;
            word-break: break-word;
        }

        .change-location-link {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            margin-top: 16px;
            color: #4285f4;
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
            transition: all 0.2s;
        }

        .change-location-link:hover {
            color: #3367d6;
            gap: 8px;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-row {
            display: flex;
            width: 100%;
            gap: 20px;
            flex-wrap: wrap;
        }

        .form-row .form-group {
            flex: 1;
            min-width: 200px;
        }

        .form-group label {
            font-weight: 500;
            color: #333;
            margin-bottom: 5px;
            display: block;
        }


        .form-input,
        select,
        textarea {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }

        .form-control {
            width: 100%;

            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }

        .btn-primary {
            background: #0d3e9b !important;
            color: white !important;
            border: none;
            padding: 12px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-primary:hover {
            background: #1d4ed8 !important;
        }

        #proceedButton {
            margin-top: 16px;
            width: 100%;
        }

        .add-more {
            background: none;
            border: none;
            color: #4285f4;
            font-size: 14px;
            cursor: pointer;
            margin-top: 5px;
        }

        .additional-field {
            display: flex;
            gap: 10px;
            margin-top: 10px;
        }

        .remove-field-btn {
            background: #e74c3c;
            color: white;
            border: none;
            padding: 8px 12px;
            border-radius: 4px;
            cursor: pointer;
        }

        .step {
            display: none;
        }

        .step.active {
            display: block;
        }

        /* Installation/Appointment Modal Styles */
        .appointment-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            justify-content: center;
            align-items: center;
            z-index: 10000;
        }


        .appointment-modal.show {
            display: flex !important;
            justify-content: center;
            align-items: center;
        }

        .appointment-modal-content {
            background: white;
            border-radius: 12px;
            padding: 30px;
            max-width: 500px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            animation: slideUp 0.3s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .appointment-modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #e5e7eb;
        }

        .appointment-modal-title {
            font-size: 22px;
            font-weight: 600;
            color: #0d3e9b;
        }

        .appointment-modal-close {
            background: none;
            border: none;
            font-size: 28px;
            cursor: pointer;
            color: #6b7280;
            line-height: 1;
        }

        .appointment-form-group {
            margin-bottom: 20px;
        }

        .appointment-form-group label {
            display: block;
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 8px;
            color: #333;
        }

        .appointment-form-group input {
            width: 100%;
            padding: 12px;
            border: 1px solid #d1d5db;
            border-radius: 8px;
            font-size: 14px;
        }

        .appointment-form-group input:focus {
            outline: none;
            border-color: #0d3e9b;
            box-shadow: 0 0 0 3px rgba(13, 62, 155, 0.1);
        }

        .appointment-note {
            background: #f0f9ff;
            border-left: 4px solid #0d3e9b;
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 4px;
            font-size: 13px;
            color: #1e40af;
        }

        .appointment-submit-btn {
            background: #0d3e9b;
            color: white;
            border: none;
            padding: 14px;
            border-radius: 8px;
            width: 100%;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
        }

        .appointment-submit-btn:hover {
            background: #1d4ed8;
        }

        .appointment-submit-btn:disabled {
            background: #9ca3af;
            cursor: not-allowed;
        }

        /* Success Modal Styles */
        .success-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            justify-content: center;
            align-items: center;
            z-index: 10000;
        }

        .success-modal.show {
            display: flex !important;
            justify-content: center;
            align-items: center;
        }

        .success-modal-content {
            background: white;
            border-radius: 12px;
            padding: 40px;
            max-width: 450px;
            width: 90%;
            text-align: center;
            position: relative;
            animation: bounceIn 0.5s ease-out;
        }

        @keyframes bounceIn {
            0% {
                opacity: 0;
                transform: scale(0.3);
            }

            50% {
                opacity: 1;
                transform: scale(1.05);
            }

            70% {
                transform: scale(0.9);
            }

            100% {
                transform: scale(1);
            }
        }

        .success-icon {
            width: 80px;
            height: 80px;
            background: #10b981;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 40px;
            color: white;
            animation: checkmark 0.8s ease-out;
        }

        @keyframes checkmark {
            0% {
                transform: scale(0);
            }

            50% {
                transform: scale(1.2);
            }

            100% {
                transform: scale(1);
            }
        }

        .success-modal h3 {
            font-size: 24px;
            font-weight: 600;
            color: #059669;
            margin-bottom: 10px;
        }

        .success-modal p {
            font-size: 15px;
            color: #6b7280;
            margin-bottom: 25px;
            line-height: 1.6;
        }

        .success-modal-btn {
            background: #0d3e9b;
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.2s;
        }

        .success-modal-btn:hover {
            background: #1d4ed8;
        }

        /* Completion Modal Styles */
        .completion-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.8);
            justify-content: center;
            align-items: center;
            z-index: 10001;
        }

        .completion-modal.show {
            display: flex !important;
            justify-content: center;
            align-items: center;
        }

        .completion-modal-content {
            background: white;
            border-radius: 16px;
            padding: 45px 35px;
            max-width: 500px;
            width: 90%;
            text-align: center;
            position: relative;
            animation: bounceIn 0.5s ease-out;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
        }

        .completion-icon {
            width: 90px;
            height: 90px;
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
            font-size: 45px;
            color: white;
            animation: checkmark 0.8s ease-out;
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4);
        }

        .completion-modal h2 {
            font-size: 28px;
            font-weight: 700;
            color: #059669;
            margin-bottom: 15px;
        }

        .completion-modal p {
            font-size: 16px;
            color: #6b7280;
            margin-bottom: 25px;
            line-height: 1.6;
        }

        .completion-order-info {
            background: #f3f4f6;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            text-align: left;
        }

        .completion-order-label {
            font-size: 13px;
            color: #6b7280;
            font-weight: 500;
            margin-bottom: 5px;
        }

        .completion-order-value {
            font-size: 18px;
            color: #1f2937;
            font-weight: 600;
            font-family: monospace;
        }

        .completion-modal-btn {
            background: #0d3e9b;
            color: white;
            border: none;
            padding: 14px 35px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            width: 100%;
        }

        .completion-modal-btn:hover {
            background: #1d4ed8;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(13, 62, 155, 0.3);
        }

        /* Loading button state */
        .btn-loading {
            position: relative;
            pointer-events: none;
            opacity: 0.7;
        }

        .btn-loading::after {
            content: "";
            position: absolute;
            width: 16px;
            height: 16px;
            top: 50%;
            left: 50%;
            margin-left: -8px;
            margin-top: -8px;
            border: 2px solid #ffffff;
            border-radius: 50%;
            border-top-color: transparent;
            animation: spinner 0.6s linear infinite;
        }

        @keyframes spinner {
            to {
                transform: rotate(360deg);
            }
        }

        @media (max-width: 768px) {

            .nav-links,
            .nav-buttons {
                display: none;
            }

            .logo img {
                height: 25px;
                width: 137px;
            }

            .mobile-menu-toggle {
                display: block;
            }

            .hero h1 {
                font-size: 1.75rem;
                font-weight: 600;
            }

            .form-row-hero {
                flex-direction: column;
                padding: 1rem 1.25rem;
            }

            .form-input-hero {
                border: 1px solid #ddd;
                padding: 1rem;
                border-radius: 0.5rem;
                font-size: 1rem;
                min-height: 50px;
            }

            .service-form {
                margin: 1rem;
                padding: 1.5rem 1rem;
                max-width: 100%;
            }

            .check-btn {
                padding: 12px 20px;
                font-size: 1rem;
                min-height: 50px;
                width: 300px;
            }

            #addressSuggestions {
                /* max-height: 200px; */
                font-size: 0.9rem;
            }

            .landing-hero {
                padding: 20px;
            }

            .main-content-container {
                padding: 20px;
            }

            .main-content {
                margin-left: 0;
            }

            .plans-grid {
                grid-template-columns: 1fr;
            }

            .checkout-container {
                flex-direction: column;
            }

            .checkout-main,
            .checkout-sidebar {
                width: 100%;
            }

            .form-row {
                flex-direction: column;
                gap: 10px;
            }

            .form-row .form-group {
                min-width: 100%;
            }
        }

        @media (max-width: 480px) {
            .hero {
                /* min-height: 400px; */
                padding: 1rem;
            }

            .hero h1 {
                font-size: 2rem;
            }

            .service-form {
                padding: 1rem;
            }
        }
    </style>
</head>

<body class="hold-transition login-page" style="font-family: HeadacheNormal !important;">

    <!-- Mobile Menu -->
    <div class="mobile-menu" id="mobileMenu">
        <div class="mobile-menu-header">
            <div class="logo">
                <img src="./assets/images/logo_old.png" alt="logo" />
            </div>
            <button class="mobile-menu-close" onclick="toggleMobileMenu()">
                ✕
            </button>
        </div>
        <nav class="mobile-menu-nav">
            <a href="#plans" onclick="toggleMobileMenu()">Our Plans</a>
            <a href="#marketplace" onclick="toggleMobileMenu()">Marketplace</a>
            <a href="#support" onclick="toggleMobileMenu()">Support</a>
            <a href="#contact" onclick="toggleMobileMenu()">Contact Us</a>
            <a href="#career" onclick="toggleMobileMenu()">Career</a>
            <a href="#blog" onclick="toggleMobileMenu()">Blog</a>
            <a href="#about" onclick="toggleMobileMenu()">About Us</a>
        </nav>
        <div class="mobile-menu-buttons">
            <a href="index.php" class="btn btn-primary mobile-get-connect" onclick="toggleMobileMenu()">Get
                Connected</a>
            <a href="index.php" class="btn btn-secondary mobile-login" onclick="toggleMobileMenu()">Login</a>
        </div>
    </div>

    <div class="main-content">
        <div id="toast" class="toast"></div>

        <!-- Landing Hero Section - Step 1 -->
        <div id="step1" class="step active">
            <div class="landing-hero">
                <!-- Header -->
                <header class="header">
                    <div class="nav-container">
                        <div class="logo">
                            <img src="./web-banners/logo.png" alt="logo" />
                        </div>
                        <nav class="nav-links">
                            <a href="#plans">Our Plans</a>
                            <a href="#marketplace">Marketplace</a>
                            <a href="#support">Support</a>
                            <a href="#contact">Contact Us</a>
                            <a href="#career">Career</a>
                            <a href="#blog">Blog</a>
                            <a href="#about">About Us</a>
                        </nav>
                        <div class="nav-buttons">
                            <a href="index.php" class="btn btn-primary">Get Connected</a>
                            <a href="index.php" class="btn btn-secondary" style="padding-top: 15px;">Login</a>
                        </div>
                        <button class=" mobile-menu-toggle" onclick="toggleMobileMenu()">
                            ☰
                        </button>
                    </div>
                </header>

                <!-- Hero Section -->
                <section class="hero">
                    <div class="hero-content">
                        <h1>Check Service Availability to Begin</h1>
                        <div class="service-form">
                            <form id="coverageForm">
                                <!-- New fields -->
                                <div class="form-row-hero">
                                    <div class="form-group-hero">
                                        <input type="text" class="form-input-hero" id="name" name="name"
                                            placeholder="Full Name" required>
                                    </div>

                                    <div class="form-group-hero">
                                        <input type="email" class="form-input-hero" id="emailC" name="emailC"
                                            placeholder="Email Address" required>
                                    </div>
                                </div>

                                <div class="form-row-hero">
                                    <div class="form-group-hero">
                                        <input type="tel" class="form-input-hero" id="phoneC" name="phoneC"
                                            placeholder="Phone Number" required>
                                    </div>
                                </div>
                                <div class="form-row-hero">
                                    <div class="form-group-hero">
                                        <select class="form-input-hero" id="city" name="city" required>
                                            <option value="">Select City</option>
                                            <!-- Dynamically populated -->
                                        </select>
                                    </div>
                                    <div class="form-group-hero">
                                        <input type="text" class="form-input-hero" id="address" name="address"
                                            placeholder="Enter your Address" autocomplete="off" required>
                                        <ul id="addressSuggestions" class="list-group" style="display:none;"></ul>
                                    </div>
                                </div>
                                <button type="submit" class="check-btn">
                                    Check Network Coverage
                                </button>
                            </form>
                        </div>
                    </div>
                </section>
            </div>

            <!-- Status Messages -->
            <div class="main-content-container">
                <div id="addressError" class="text-danger" style="display:none; margin-top: 12px; font-weight: 500;">
                </div>

                <!-- Success Status Card -->
                <div id="statusMessage" class="status-card success" style="display: none;">
                    <div class="status-header">
                        <div class="status-icon">✓</div>
                        <h3 class="status-title">Coverage Available!</h3>
                    </div>
                    <p class="status-message">Great news! We have network coverage in your area. You can proceed to the
                        next
                        step.</p>
                    <div class="status-location" id="availableLocation">
                        <span class="status-location-icon">📍</span>
                        <span id="availableLocationText"></span>
                    </div>
                    <div class="coverage-details" id="coverageDetails" style="display: none;">
                        <div class="coverage-detail-item">
                            <div class="coverage-detail-label">Splitter ID</div>
                            <div class="coverage-detail-value" id="splitterId">-</div>
                        </div>
                        <div class="coverage-detail-item">
                            <div class="coverage-detail-label">Distance</div>
                            <div class="coverage-detail-value" id="coverageDistance">-</div>
                        </div>
                        <div class="coverage-detail-item">
                            <div class="coverage-detail-label">Network Type</div>
                            <div class="coverage-detail-value" id="networkType">-</div>
                        </div>
                    </div>
                    <button id="proceedButton" class="btn-primary" onclick="proceedToUserDetails()"
                        style="display: none; margin-top: 16px; width: 100%;">Proceed to Next
                        Step</button>
                </div>

                <!-- Coming Soon Status Card -->
                <div id="unavailableStatusMessage" class="status-card coming-soon" style="display: none;">
                    <div class="status-header">
                        <div class="status-icon">🚀</div>
                        <h3 class="status-title">Coming Soon</h3>
                    </div>
                    <p class="status-message">We're working hard to expand our network to your area. Our services will
                        be
                        available soon!</p>
                    <div class="status-location" id="unavailableLocation">
                        <span class="status-location-icon">📍</span>
                        <span id="unavailableLocationText"></span>
                    </div>
                    <a href="#" class="change-location-link" onclick="changeLocation(); return false;">
                        <span>←</span> Try another location
                    </a>
                </div>
            </div>
        </div>

        <!-- Step 2: User Details -->
        <div id="step2" class="step">
            <div class="main-content-container">
                <h2>Enter User Details</h2>
                <form id="userDetailsForm">
                    <div class="form-row">
                        <div class="form-group">
                            <label for="fullName">Full Name *</label>
                            <input type="text" id="fullName" name="fullName" class="form-control"
                                placeholder="Your Name" value="<?= htmlspecialchars($customer['name'] ?? '') ?>"
                                required readonly>
                        </div>
                        <div class="form-group">
                            <label for="companyName">Company Name</label>
                            <input type="text" id="companyName" name="companyName" class="form-control"
                                placeholder="Your Company Name"
                                value="<?= htmlspecialchars($customer['company_name'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="phone">Phone *</label>
                            <input type="tel" id="phone" name="phone" class="form-control"
                                placeholder="Your Phone Number"
                                value="<?= htmlspecialchars($customer['phone'] ?? '') ?>" required readonly>
                            <button type="button" class="add-more" onclick="addPhoneField()">+ Add more Phone
                                Number</button>
                            <div id="additionalPhones"></div>
                        </div>
                        <div class="form-group">
                            <label for="email">Email *</label>
                            <input type="email" id="email" name="email" class="form-control" placeholder="Your Email"
                                value="<?= htmlspecialchars($customer['email'] ?? '') ?>" required readonly>
                            <button type="button" class="add-more" onclick="addEmailField()">+ Add more Email</button>
                            <div id="additionalEmails"></div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="fullAddress">Full Address</label>
                            <input type="text" id="fullAddress" name="fullAddress" class="form-control" readonly
                                placeholder="Your Full Address"
                                value="<?= htmlspecialchars($customer['address'] ?? '') ?>">
                        </div>
                        <div class="form-group">
                            <label for="howDidYouHear">How did you hear about us?</label>
                            <select id="howDidYouHear" name="howDidYouHear" class="form-control">
                                <option value="">-- Select --</option>
                                <option value="social" <?= (!empty($customer['source']) && $customer['source'] == 'social') ? 'selected' : '' ?>>Social Media</option>
                                <option value="referral" <?= (!empty($customer['source']) && $customer['source'] == 'referral') ? 'selected' : '' ?>>Referral</option>
                                <option value="ads" <?= (!empty($customer['source']) && $customer['source'] == 'ads') ? 'selected' : '' ?>>Ads</option>
                                <option value="other" <?= (!empty($customer['source']) && $customer['source'] == 'other') ? 'selected' : '' ?>>Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="comments">Any comment</label>
                        <textarea id="comments" name="comments" class="form-control" placeholder="Additional Comment"
                            rows="4"><?= htmlspecialchars($customer['comment'] ?? '') ?></textarea>
                    </div>
                    <button type="submit" class="btn-primary">Proceed to Select Plan</button>
                </form>
            </div>
        </div>

        <!-- Step 3: Service Plans -->
        <div id="step3" class="step">
            <div class="main-content-container">
                <h2>Select a Service Plan</h2>
                <section class="plans-section">
                    <div class="plans-grid">
                        <div class="plan-card residential-card" onclick="selectPlan('residential')">
                            <div class="plan-icon-select">
                                <div class="plan-icon">🏠</div>
                                <div class="circle-dot"></div>
                            </div>
                            <h3 class="plan-title">Residential Plan</h3>
                            <p class="plan-description">
                                Tailored for homes and personal use. Enjoy reliable, high-speed internet for streaming,
                                browsing, video calls, and smart home devices — all at affordable rates.
                            </p>
                        </div>
                        <div class="plan-card business-card" onclick="selectPlan('business')">
                            <div class="plan-icon-select">
                                <div class="plan-icon">🏢</div>
                                <div class="circle-dot"></div>
                            </div>
                            <h3 class="plan-title">Business Plan</h3>
                            <p class="plan-description">
                                Designed for offices and enterprises. Get fast, scalable internet with dedicated
                                bandwidth, uptime guarantees, and priority support to keep your business running
                                smoothly.
                            </p>
                        </div>
                    </div>
                </section>
                <section class="category-plans-section" id="categoryPlans" style="display: none">
                    <a href="#" class="back-button" onclick="goBackToPlans()">
                        <span>←</span> Go Back
                    </a>
                    <h2 class="plans-title" id="plansTitle">Plans For You</h2>
                    <div class="plans-grid" id="plansContainer">
                        <!-- Plans will be dynamically loaded here -->
                    </div>
                </section>
            </div>
        </div>

        <!-- Step 4: Checkout -->
        <div id="step4" class="step">
            <div class="main-content-container">
                <h2>Checkout</h2>
                <div class="checkout-container">
                    <div class="checkout-main">
                        <div class="cart-section">
                            <div class="cart-header">
                                Cart (<span id="cartItemCount">0</span> Items)
                            </div>
                            <div class="cart-items" id="cartItems">
                                <!-- Cart items will be dynamically populated -->
                            </div>
                        </div>
                        <div class="section-title">Recommended Add-Ons</div>
                        <div class="filter-tabs">
                            <button class="filter-tab active" onclick="switchTab(this, 'all')">All</button>
                            <button class="filter-tab" onclick="switchTab(this, 'fiberone')">From Fiberone</button>
                            <button class="filter-tab" onclick="switchTab(this, 'third-party')">Third party
                                Vendors</button>
                        </div>
                        <div class="vendor-section" id="fiberone-section">
                            <div class="vendor-header">
                                <div class="vendor-name">From Fiberone</div>
                                <button class="filter-button">Filter <span>≡</span></button>
                            </div>
                            <div class="products-grid">
                                <?php if (!empty($all_products['fob'])): ?>
                                    <?php foreach ($all_products['fob'] as $product): ?>
                                        <?php
                                        $imageUrl = '../assets/images/wifi-range-img3.png'; // Default fallback
                                        $imageUrls = [];
                                        if (!empty($product->images) && is_array($product->images)) {
                                            foreach ($product->images as $img) {
                                                $imageUrls[] = $img['url'] ?? $img->url ?? '';
                                            }
                                            $imageUrl = htmlspecialchars($imageUrls[0] ?? $imageUrl);
                                        }
                                        ?>
                                        <div class="product-card" data-product-id="<?= htmlspecialchars($product->id) ?>"
                                            data-images="<?= htmlspecialchars(json_encode($imageUrls)) ?>"
                                            data-description="<?= htmlspecialchars($product->description ?? '') ?>">
                                            <div class="product-image">
                                                <img src="<?= $imageUrl ?>" alt="<?= htmlspecialchars($product->name) ?>"
                                                    width="100%">
                                            </div>
                                            <div class="product-info">
                                                <div class="product-name"><?= htmlspecialchars($product->name) ?></div>
                                                <div class="product-price">₦<?= number_format($product->price, 2) ?></div>
                                                <!-- <div class="product-rating">★★★★★</div> -->
                                            </div>
                                            <div class="product-overlay">
                                                <button class="overlay-button view-button"
                                                    onclick="viewProduct(this)">View</button>
                                                <button class="overlay-button add-to-cart-button" onclick="addToCart(this)">Add
                                                    to Cart</button>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p>No FOB products available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="vendor-section" id="third-party-section">
                            <div class="vendor-header">
                                <div class="vendor-name">From Third Party Vendor</div>
                                <button class="filter-button">Filter <span>≡</span></button>
                            </div>
                            <div class="products-grid">
                                <?php if (!empty($all_products['third_party'])): ?>
                                    <?php foreach ($all_products['third_party'] as $product): ?>
                                        <?php
                                        $imageUrl = '../assets/images/wifi-range-img3.png'; // Default fallback
                                        $imageUrls = [];
                                        if (!empty($product->images) && is_array($product->images)) {
                                            foreach ($product->images as $img) {
                                                $imageUrls[] = $img['url'] ?? $img->url ?? '';
                                            }
                                            $imageUrl = htmlspecialchars($imageUrls[0] ?? $imageUrl);
                                        }
                                        $hasDiscount = !empty($product->discount_price) && $product->discount_price > 0;
                                        $displayPrice = $hasDiscount ? $product->discount_price : $product->price;
                                        ?>
                                        <div class="product-card" data-product-id="<?= htmlspecialchars($product->id) ?>"
                                            data-images="<?= htmlspecialchars(json_encode($imageUrls)) ?>"
                                            data-description="<?= htmlspecialchars($product->description ?? '') ?>"
                                            data-price="<?= htmlspecialchars($product->price) ?>"
                                            data-discount-price="<?= htmlspecialchars($product->discount_price ?? 0) ?>"
                                            data-stock="<?= htmlspecialchars($product->stock_quantity ?? 0) ?>">
                                            <div class="product-image">
                                                <img src="<?= $imageUrl ?>" alt="<?= htmlspecialchars($product->name) ?>"
                                                    width="100%">
                                            </div>
                                            <div class="product-info">
                                                <div class="product-name"><?= htmlspecialchars($product->name) ?></div>
                                                <div class="product-price">
                                                    ₦<?= number_format($displayPrice, 2) ?>
                                                    <?php if ($hasDiscount): ?>
                                                        <span
                                                            style="text-decoration: line-through; color: #999; font-size: 12px; margin-left: 4px;">
                                                            ₦<?= number_format($product->price, 2) ?>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                                <!-- <div class="product-rating">★★★★★</div> -->
                                            </div>
                                            <div class="product-overlay">
                                                <button class="overlay-button view-button"
                                                    onclick="viewProduct(this)">View</button>
                                                <button class="overlay-button add-to-cart-button" onclick="addToCart(this)">Add
                                                    to Cart</button>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p>No third-party products available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="checkout-sidebar">
                        <div class="installation-section">
                            <div class="installation-header">
                                <div class="location-icon">📍</div>
                                <div class="installation-title">Installation Address</div>
                            </div>
                            <input type="text" class="address-input" id="installationAddress"
                                placeholder="Enter Installation Address" readonly>
                            <div class="address-details" id="addressDetails"></div>
                        </div>
                        <div class="payment-section">
                            <div class="section-title">Payment</div>
                            <div class="payment-options">
                                <div class="payment-option selected" onclick="selectPayment(this)">💳 Pay with card
                                </div>
                                <div class="payment-option" onclick="selectPayment(this)">💸 Pay with transfer</div>
                            </div>
                        </div>
                        <div class="order-summary">
                            <div class="summary-title">Order Summary</div>
                            <div class="summary-row">
                                <span>Subtotal</span>
                                <span id="subtotal">₦0.00</span>
                            </div>
                            <div class="summary-row">
                                <span>Delivery fee</span>
                                <span id="deliveryFee">₦0.00</span>
                            </div>
                            <div class="summary-row total">
                                <span>Total</span>
                                <span id="total">₦0.00</span>
                            </div>
                        </div>
                        <button class="checkout-button" id="checkoutBtn" onclick="proceedToPayment()">Proceed to
                            Payment</button>

                        <!-- <div id="orderDetails"
                            style="display:none; margin-top:20px; background:#f9f9f9; border-radius:8px; padding:16px; border:1px solid #e1e5e9;">
                            <h3 style="color:#185de0;">Order Created Successfully!</h3> -->
                        <!-- <div><strong>Customer ID:</strong> <span id="orderCustomerId"></span></div>
                        <div><strong>Order ID:</strong> <span id="orderOrderId"></span></div> -->
                        <!-- <div><strong>Order Number:</strong> <span id="orderOrderNumber"></span></div>
                            <div><strong>Checkout Link:</strong> <a id="orderCheckoutLink" href="#" target="_blank"></a>
                            </div> -->
                        <!-- </div> -->


                    </div>
                </div>

                <!-- Success Modal -->
                <div id="successModal" class="success-modal">
                    <div class="success-modal-content">
                        <div class="success-icon">✓</div>
                        <h3>Payment Successful!</h3>
                        <p id="successModalMessage">Your payment has been processed successfully. Let's schedule your
                            installation date.</p>
                        <button class="success-modal-btn" onclick="openAppointmentModal()">Schedule
                            Installation</button>
                    </div>
                </div>

                <!-- Appointment Modal -->
                <div id="appointmentModal" class="appointment-modal">
                    <div class="appointment-modal-content">
                        <div class="appointment-modal-header">
                            <h2 class="appointment-modal-title">Schedule Installation</h2>
                            <button class="appointment-modal-close" onclick="closeAppointmentModal()">&times;</button>
                        </div>
                        <div class="appointment-note">
                            &#9432; Please select a date and time for your installation. Our team will be available
                            between 8:00 AM and 4:00 PM.
                        </div>
                        <form id="appointmentForm" onsubmit="submitAppointment(event)">
                            <div class="appointment-form-group">
                                <label for="appointmentDate">Installation Date *</label>
                                <input type="date" id="appointmentDate" name="appointmentDate" required>
                            </div>
                            <div class="appointment-form-group">
                                <label for="appointmentTime">Installation Time *</label>
                                <input type="time" id="appointmentTime" name="appointmentTime" required>
                            </div>
                            <button type="submit" id="submitAppointmentBtn" class="appointment-submit-btn">Confirm
                                Appointment</button>
                        </form>
                    </div>
                </div>

                <!-- Completion Modal -->
                <div id="completionModal" class="completion-modal">
                    <div class="completion-modal-content">
                        <div class="completion-icon">✓</div>
                        <h2>Order Completed!</h2>
                        <p>Thank you for your order. Your installation has been scheduled and you will receive a
                            confirmation email shortly.</p>
                        <div class="completion-order-info">
                            <div class="completion-order-label">Order Number</div>
                            <div class="completion-order-value" id="completionOrderNumber">-</div>
                        </div>
                        <button class="completion-modal-btn" onclick="closeCompletionModal()">Return to Website</button>
                    </div>
                </div>

                <div class="modal" id="productModal">
                    <div class="modal-content">
                        <button class="modal-close" onclick="closeModal()">×</button>
                        <div class="modal-product-section">
                            <div class="modal-product-images">
                                <div class="modal-main-image">
                                    <img src="../assets/images/wifi-range-img3.png" alt="Product" width="100%"
                                        id="modalMainImage">
                                </div>
                                <div class="modal-thumbnail-images" id="modalThumbnails">
                                    <!-- Thumbnails will be dynamically inserted here -->
                                </div>
                            </div>
                            <div class="modal-product-details">
                                <h1 class="modal-product-title"></h1>
                                <div class="modal-price-section">
                                    <div class="modal-price">₦00.00</div>
                                    <div class="modal-original-price"
                                        style="display:none; text-decoration: line-through; color: #999; font-size: 14px; margin-top: 4px;">
                                        ₦00.00</div>
                                    <!-- <div class="modal-power-info">Power Input: AC110V - AC240V</div> -->
                                </div>
                                <!-- <div class="modal-rating">
                                    <div class="modal-stars">★★★★★</div>
                                    <div class="modal-rating-text">(5 reviews)</div>
                                </div> -->
                                <div class="modal-product-description">
                                    cart-item-info
                                </div>
                                <div class="modal-quantity-section">
                                    <div class="modal-quantity-label">QUANTITY</div>
                                    <div class="modal-quantity-controls">
                                        <button class="modal-quantity-btn" onclick="decreaseModalQuantity()">-</button>
                                        <input type="number" class="modal-quantity-input" value="1" min="1"
                                            id="modalQuantity">
                                        <button class="modal-quantity-btn" onclick="increaseModalQuantity()">+</button>
                                    </div>
                                    <div class="modal-stock-info">--</div>
                                </div>
                                <button class="modal-add-to-cart" onclick="addToCartFromModal()">Add to Cart</button>
                                <!-- <div class="modal-product-sections">
                                    <div class="modal-section">
                                        <div class="modal-section-header" onclick="toggleModalSection('expect')">
                                            <div class="modal-section-title">What You Can Expect</div>
                                            <div class="modal-section-icon" id="modal-expect-icon">−</div>
                                        </div>
                                        <div class="modal-section-content" id="modal-expect-content">
                                            Saying goodbye to frustrating dead zones and enjoying seamless connectivity
                                            throughout your home and offices. It extends the reach of our high-speed
                                            internet service, ensuring a reliable connection in every corner.
                                        </div>
                                    </div>
                                    <div class="modal-section">
                                        <div class="modal-section-header" onclick="toggleModalSection('love')">
                                            <div class="modal-section-title">Why You Will Love It</div>
                                            <div class="modal-section-icon" id="modal-love-icon">−</div>
                                        </div>
                                        <div class="modal-section-content" id="modal-love-content">
                                            <ul class="modal-features-list">
                                                <li>Easy Plug & Play Setup</li>
                                                <li>Up to 5G+ Speed</li>
                                                <li>Access Point Mode</li>
                                                <li>Full Coverage</li>
                                                <li>Browse without even being close to your router</li>
                                                <li>Faster Browsing Mode</li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="modal-section">
                                        <div class="modal-section-header" onclick="toggleModalSection('use')">
                                            <div class="modal-section-title">How to Use</div>
                                            <div class="modal-section-icon" id="modal-use-icon">+</div>
                                        </div>
                                        <div class="modal-section-content collapsed" id="modal-use-content">
                                            <p>1. Plug the extender into a power outlet halfway between your router and
                                                the area with poor WiFi coverage.</p>
                                            <p>2. Connect to the extender's network using your device's WiFi settings.
                                            </p>
                                            <p>3. Open a web browser and follow the setup wizard to configure the
                                                extender.</p>
                                            <p>4. Once configured, the extender will automatically connect to your
                                                existing network.</p>
                                        </div>
                                    </div>
                                    <div class="modal-section">
                                        <div class="modal-section-header" onclick="toggleModalSection('info')">
                                            <div class="modal-section-title">Additional Information</div>
                                            <div class="modal-section-icon" id="modal-info-icon">−</div>
                                        </div>
                                        <div class="modal-section-content" id="modal-info-content">
                                            <div class="modal-product-type">Product Type - T45Q</div>
                                            <div class="modal-delivery-info">Please note that delivery for this item
                                                will take between 2 to 5 working days from the date of payment
                                                confirmation.</div>
                                            <a href="#" class="modal-terms-link">Terms and Conditions apply</a>
                                        </div>
                                    </div>
                                </div> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="bower_components/jquery/dist/jquery.min.js"></script>
    <!-- Bootstrap 3.3.7 -->
    <script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- iCheck -->
    <script src="plugins/iCheck/icheck.min.js"></script>

    <!-- Ajax Form Validation Script -->
    <script src="dist/js/jquery.validate.js" type="text/javascript" charset="utf-8"></script>
    <!-- Bootstrap Validation Script -->
    <script src="dist/js/validator.min.js" type="text/javascript" charset="utf-8"></script>

    <script>
        //        console.log("boom");
        $(document).ready(function () {
            var fadeInFadeOut = function (jQueryElement, timeout) {
                jQueryElement.fadeIn(1000);
                // setTimeout(function() {
                //     jQueryElement.fadeOut("slow");
                // }, timeout);
            };

            function sanitizeInput(input) {
                return input.replace(/[<>\"'&]/g, function (char) {
                    const entities = {
                        '<': '&lt;',
                        '>': '&gt;',
                        '"': '&quot;',
                        "'": '&#39;',
                        '&': '&amp;'
                    };
                    return entities[char];
                });
            }

            // Toast notification function
            function showToast(type, message, duration = 3000) {
                const toast = document.getElementById("toast");
                toast.textContent = message;

                // Remove previous type classes
                toast.classList.remove('success', 'error');

                // Add the appropriate type class
                if (type === "success") {
                    toast.classList.add('success');
                } else if (type === "error") {
                    toast.classList.add('error');
                }

                toast.classList.add("show");

                setTimeout(() => {
                    toast.classList.remove("show");
                }, duration);
            }

            // Show order details after successful order creation
            function showOrderDetails(data) {
                // document.getElementById('orderCustomerId').textContent = data.customer_id;
                // document.getElementById('orderOrderId').textContent = data.order_id;
                document.getElementById('orderOrderNumber').textContent = data.order_number;
                document.getElementById('orderCheckoutLink').textContent = data.checkout_link;
                document.getElementById('orderCheckoutLink').href = data.checkout_link;
                document.getElementById('orderDetails').style.display = 'block';
            }

            // Network data fetching
            let availableLocation = [];
            let categorizedPlans = {};

            async function getNetworkData() {
                console.log("Fetching network data...");
                try {
                    const response = await fetch("https://eservice.fob.ng/apy/public/getplansWebsite");
                    if (!response.ok) {
                        throw new Error("Network response was not ok");
                    }

                    const data = await response.json();

                    // Extract unique locations
                    availableLocation = [...new Set(data.UDATA.map((item) => item.PLAN_LOCATION.toLowerCase()))];

                    // Build nested object: { Location: { residential: [], business: [] } }
                    categorizedPlans = data.UDATA.reduce((acc, plan) => {
                        const location = plan.PLAN_LOCATION.toLowerCase();
                        const category = plan.PLAN_CATEGORY?.toLowerCase() === "home" ? "residential" : "business";
                        if (!acc[location]) {
                            acc[location] = {
                                residential: [],
                                business: []
                            };
                        }
                        acc[location][category].push(plan);
                        return acc;
                    }, {});


                    // Populate city dropdown
                    const citySelect = document.getElementById("city");
                    citySelect.innerHTML = '<option value="">Select Location</option>';
                    availableLocation.forEach((location) => {
                        const option = document.createElement("option");
                        option.value = location;
                        option.textContent = location.charAt(0).toUpperCase() + location.slice(1);
                        citySelect.appendChild(option);
                    });

                    return {
                        availableLocation,
                        categorizedPlans
                    };
                } catch (error) {
                    console.error("Error fetching network data:", error);
                    showToast("error", "Failed to load network data. Please try again.");
                    return null;
                }
            }

            // Initialize network data on page load
            getNetworkData();

            // Step navigation and data storage
            const steps = ["step1", "step2", "step3", "step4"];
            let registrationData = {
                coverage: {},
                userDetails: {},
                selectedPlanType: null,
                selectedPlan: null,
                cart: [],
            };

            // Store current order data for payment
            let currentOrderData = null;

            function showStep(stepId) {
                steps.forEach((id) => {
                    const el = document.getElementById(id);
                    if (el) el.classList.remove("active");
                });
                const target = document.getElementById(stepId);
                if (target) target.classList.add("active");
            }

            // Function to proceed to user details step
            window.proceedToUserDetails = function () {
                console.log("Proceeding to user details with coverage data:", registrationData.coverage);
                // Store values in registrationData
                const address = registrationData.coverage.address || "";
                const name = registrationData.coverage.name || "";
                const email = registrationData.coverage.email || "";
                const phone = registrationData.coverage.phone || "";


                // Set the form field values
                document.getElementById("fullAddress").value = address;
                document.getElementById("fullName").value = name;
                document.getElementById("email").value = email;
                document.getElementById("phone").value = phone;



                // Also update registrationData.userDetails for consistency
                registrationData.userDetails.name = name;
                registrationData.userDetails.email = email;
                registrationData.userDetails.phone = phone;
                registrationData.userDetails.address = address;

                showStep("step2");
            };

            // Step 1: Network Coverage
            const coverageForm = document.getElementById("coverageForm");

            // Address autocomplete functionality
            let addressTimeout;
            $('#address').on('input', function () {
                clearTimeout(addressTimeout);
                let query = $(this).val().trim();

                if (query.length >= 3) {
                    addressTimeout = setTimeout(function () {
                        $.ajax({
                            url: 'ajax/ad_address_api.php',
                            type: 'POST',
                            data: {
                                address: query
                            },
                            success: function (data) {
                                if (data.success && data.data.length > 0) {
                                    let addresses = data.data;
                                    let html = '';
                                    addresses.forEach(function (addr) {
                                        html += `<li class="list-group-item address-item" 
                                            data-lat='${addr.location.lat}' 
                                            data-lon='${addr.location.lng}'
                                            data-address='${addr.address}'>${addr.text || addr.address}</li>`;
                                    });
                                    $('#addressSuggestions').html(html).show();
                                } else {
                                    $('#addressSuggestions').hide();
                                }
                            },
                            error: function () {
                                $('#addressSuggestions').hide();
                            }
                        });
                    }, 500); // Debounce for 500ms
                } else {
                    $('#addressSuggestions').hide();
                }
            });

            // Handle address selection from suggestions
            $(document).on('click', '.address-item', function () {
                let selectedAddress = $(this).data('address') || $(this).text();
                let lat = $(this).data('lat');
                let lon = $(this).data('lon');

                // Store the selected address with coordinates
                window.selectedAddressData = {
                    address: selectedAddress,
                    lat: lat,
                    lon: lon
                };

                // Fill the input field
                $('#address').val(selectedAddress);

                // Hide the dropdown
                $('#addressSuggestions').hide();
            });

            // Close suggestions when clicking outside
            $(document).click(function (e) {
                if (!$(e.target).closest('#address, #addressSuggestions').length) {
                    $('#addressSuggestions').hide();
                }
            });

            // Coverage form submission
            // coverageForm.addEventListener("submit", function(e) {
            //     e.preventDefault();
            //     const formData = new FormData(coverageForm);
            //     const city = formData.get("city").trim().toLowerCase();
            //     const address = formData.get("address");

            //     if (!city || !address) {
            //         showToast("Please select a city and enter your address");
            //         return;
            //     }

            // if (availableLocation.includes(city)) {
            //     registrationData.coverage = {
            //         city,
            //         address
            //     };
            //     document.getElementById("statusMessage").style.display = "block";
            //     document.getElementById("unavailableStatusMessage").style.display = "none";
            //     console.log("Coverage data:", registrationData.coverage);
            //     showStep("step2");
            // } else {
            //     document.getElementById("statusMessage").style.display = "none";
            //     document.getElementById("unavailableStatusMessage").style.display = "block";
            //     showToast(`Sorry, we do not have coverage in ${city.charAt(0).toUpperCase() + city.slice(1)} yet.`);
            // }
            // });

            $('#coverageForm').on('submit', function (e) {
                e.preventDefault();

                let address = $('#address').val().trim();

                let name = $('#name').val().trim(); // new field
                let email = $('#emailC').val().trim(); // new field
                let phone = $('#phoneC').val().trim(); // new field
                let city = $('#city').val().trim(); // new field

                $('#addressError').hide().text('');
                $('#addressSuggestions').hide();
                $('#statusMessage').hide();
                $('#unavailableStatusMessage').hide();

                if (!address) {
                    $('#addressError').text('Please enter your address.').show();
                    return;
                }
                if (!name) {
                    $('#addressError').text('Please enter your name.').show();
                    return;
                }

                // Add loading state to check button
                const checkBtn = $(this).find('button[type="submit"]');
                checkBtn.addClass('btn-loading');
                checkBtn.prop('disabled', true);
                const originalText = checkBtn.text();
                checkBtn.text('Checking Coverage...');

                // Step 1: Get coordinates from address API
                $.ajax({
                    url: 'ajax/ad_address_api.php',
                    type: 'POST',
                    data: {
                        address: address
                    },
                    success: function (data) {
                        if (data.success && data.data.length > 0) {

                            let first = data.data[0];
                            let selectedAddress = first.text || first.address;
                            let lat = first.location.lat;
                            let lon = first.location.lng;


                            $('#address').val(selectedAddress);

                            // Step 2: Call coverage API
                            $.ajax({
                                url: 'ajax/ad_coverage_api.php',
                                type: 'POST',
                                data: {
                                    lat: lat,
                                    lon: lon,
                                    name: name,
                                    email: email,
                                    phone: phone,
                                    city: city,
                                    address: selectedAddress
                                },
                                success: function (result) {
                                    if (result.success) {

                                        let responseText = result.data.data;
                                        let city = $('#city').val();
                                        let selectedAddress = $('#address').val().trim();
                                        let isAvailable = responseText.toLowerCase().includes("available");
                                        // console.log(isAvailable);
                                        //return;
                                        if (isAvailable) {
                                            // Coverage AVAILABLE
                                            // Parse coverage details
                                            let splitterId = '';
                                            let distance = '';
                                            let networkType = '';

                                            // Extract Splitter ID
                                            let splitterMatch = responseText.match(/Splitter ID:\s*([^,]+)/);
                                            if (splitterMatch) splitterId = splitterMatch[1].trim();

                                            // Extract Distance
                                            let distanceMatch = responseText.match(/Distance:\s*([\d.]+\s*m)/);
                                            if (distanceMatch) distance = distanceMatch[1].trim();

                                            // Extract Type
                                            let typeMatch = responseText.match(/Type:\s*([^,]+)/);
                                            if (typeMatch) networkType = typeMatch[1].trim();

                                            registrationData.coverage = {
                                                address: selectedAddress,
                                                details: responseText,
                                                city: city,
                                                name: name,
                                                email: email,
                                                phone: phone,
                                                splitterId: splitterId,
                                                distance: distance,
                                                networkType: networkType
                                            };



                                            // Show success status
                                            document.getElementById("statusMessage").style.display = "block";
                                            document.getElementById("unavailableStatusMessage").style.display = "none";

                                            // Update location display
                                            document.getElementById("availableLocationText").textContent = selectedAddress;

                                            // Scroll to status message
                                            setTimeout(() => {
                                                document.getElementById("statusMessage").scrollIntoView({
                                                    behavior: 'smooth',
                                                    block: 'center'
                                                });
                                            }, 100);

                                            // Update coverage details if available
                                            if (splitterId || distance || networkType) {
                                                document.getElementById("coverageDetails").style.display = "grid";
                                                if (splitterId) document.getElementById("splitterId").textContent = splitterId;
                                                if (distance) document.getElementById("coverageDistance").textContent = distance;
                                                if (networkType) document.getElementById("networkType").textContent = networkType;
                                            }

                                            // Show proceed button
                                            document.getElementById("proceedButton").style.display = "block";

                                            // Show success toast
                                            showToast('success', '✓ Coverage confirmed!');

                                            // Remove loading state
                                            checkBtn.removeClass('btn-loading');
                                            checkBtn.prop('disabled', false);
                                            checkBtn.text(originalText);

                                        } else {
                                            // Coverage NOT available (COMING SOON)
                                            document.getElementById("statusMessage").style.display = "none";
                                            document.getElementById("unavailableStatusMessage").style.display = "block";

                                            // Update location display
                                            document.getElementById("unavailableLocationText").textContent = selectedAddress;

                                            // Scroll to status message
                                            setTimeout(() => {
                                                document.getElementById("unavailableStatusMessage").scrollIntoView({
                                                    behavior: 'smooth',
                                                    block: 'center'
                                                });
                                            }, 100);

                                            // Show info toast
                                            showToast('error', '📍 Service coming soon to this area');

                                            // Remove loading state
                                            checkBtn.removeClass('btn-loading');
                                            checkBtn.prop('disabled', false);
                                            checkBtn.text(originalText);
                                        }

                                    } else {
                                        $('#addressError').text(result.error || 'Coverage check failed. Please try again.').show();
                                        showToast('error', 'Coverage check failed. Please try again.');

                                        // Remove loading state
                                        checkBtn.removeClass('btn-loading');
                                        checkBtn.prop('disabled', false);
                                        checkBtn.text(originalText);
                                    }
                                },
                                error: function () {
                                    $('#addressError').text('Unable to check coverage. Please try again.').show();
                                    showToast('error', 'Unable to check coverage. Please try again.');

                                    // Remove loading state
                                    checkBtn.removeClass('btn-loading');
                                    checkBtn.prop('disabled', false);
                                    checkBtn.text(originalText);
                                }
                            });

                        } else {
                            $('#addressError').text(data.error || 'Address not found. Please enter a valid address.').show();
                            showToast('error', 'Address not found. Please enter a valid address.');

                            // Remove loading state
                            checkBtn.removeClass('btn-loading');
                            checkBtn.prop('disabled', false);
                            checkBtn.text(originalText);
                        }
                    },
                    error: function () {
                        $('#addressError').text('Unable to get address. Please check your connection and try again.').show();
                        showToast('error', 'Unable to connect. Please try again.');

                        // Remove loading state
                        checkBtn.removeClass('btn-loading');
                        checkBtn.prop('disabled', false);
                        checkBtn.text(originalText);
                    }
                });
            });

            $('#city').on('change', function () {
                let city = $(this).val();
                $('#addressError').hide().text('');
                if (city) {
                    //console.log(city);
                    //return;
                    $.ajax({
                        url: 'ajax/ad_address_api.php',
                        type: 'POST',
                        data: {
                            address: city
                        },
                        success: function (data) {
                            if (data.success) {
                                let addresses = data.data;
                                let html = '';
                                addresses.forEach(function (addr) {
                                    html += `<li class="list-group-item address-item" 
                                    data-lat='${addr.location.lat}' 
                                    data-lon='${addr.location.lng}'>${addr.address}</li>`;
                                });
                                $('#addressSuggestions').html(html).show();
                            } else {
                                // Display error message
                                $('#addressSuggestions').hide();
                                $('#addressError').text(data.error).show();
                            }
                        },
                        error: function () {
                            // Handle network/server errors
                            $('#addressSuggestions').hide();
                            $('#addressError').text('Unable to fetch addresses. Please try again.').show();
                        }
                    });
                } else {
                    $('#addressSuggestions').hide();
                }
            });

            $(document).on('click', '.address-item', function () {
                let selectedAddress = $(this).text();
                let lat = $(this).data('lat');
                let lon = $(this).data('lon');
                //console.log(selectedAddress)
                //console.log(lat)
                //console.log(lon)
                // Fill the input field
                $('#address').val(selectedAddress);

                // Hide the dropdown
                $('#addressSuggestions').hide();
                $('#coverageResult').hide().text('');

                $.ajax({
                    url: 'ajax/ad_coverage_api.php',
                    type: 'POST',
                    data: {
                        lat: lat,
                        lon: lon
                    },
                    success: function (result) {
                        if (result.success) {
                            $('#coverageResult').text(result.data.data).show();
                        } else {
                            $('#coverageResult').text(result.error || 'Coverage check failed.').show();
                        }
                    },
                    error: function () {
                        // Network/server error
                        $('#coverageResult').text('Unable to check coverage. Please try again.').show();
                    }
                });
            });
            $(document).click(function (e) {
                if (!$(e.target).closest('#address, #addressSuggestions').length) {
                    $('#addressSuggestions').hide();
                }
            });

            // Step 2: User Details
            const userDetailsForm = document.getElementById("userDetailsForm");
            userDetailsForm.addEventListener("submit", function (e) {
                e.preventDefault();
                const formData = new FormData(userDetailsForm);
                registrationData.userDetails = {
                    name: formData.get("fullName"),
                    company_name: formData.get("companyName"),
                    phone: formData.get("phone"),
                    additionalPhones: Array.from(document.querySelectorAll("#additionalPhones input")).map((input) => input.value).filter((val) => val),
                    email: formData.get("email"),
                    additionalEmails: Array.from(document.querySelectorAll("#additionalEmails input")).map((input) => input.value).filter((val) => val),
                    address: formData.get("fullAddress"),
                    source: formData.get("howDidYouHear"),
                    comment: formData.get("comments"),
                };
                console.log("User details:", registrationData.userDetails);
                showStep("step3");
            });

            // Step 3: Service Plan Selection
            const plansContainer = document.getElementById("plansContainer");
            const categoryPlansSection = document.getElementById("categoryPlans");
            const plansTitle = document.getElementById("plansTitle");

            window.selectPlan = function (planType) {
                const city = registrationData.coverage.city;
                registrationData.selectedPlanType = planType;
                document.querySelectorAll(".plan-card").forEach((card) => card.classList.remove("selected"));
                document.querySelector(`.${planType}-card`).classList.add("selected");
                loadPlans(city, planType);
                categoryPlansSection.style.display = "block";
                categoryPlansSection.scrollIntoView({
                    behavior: "smooth"
                });
            };

            window.loadPlans = function (location, category) {
                plansTitle.textContent = `${category.charAt(0).toUpperCase() + category.slice(1)} Plans For You in ${location.charAt(0).toUpperCase() + location.slice(1)}`;
                plansContainer.innerHTML = "";

                if (!categorizedPlans[location] || !categorizedPlans[location][category]) {
                    plansContainer.innerHTML = "<p>No plans available for this selection.</p>";
                    return;
                }

                const plans = categorizedPlans[location][category];
                plans.forEach((plan) => {
                    const metadata = JSON.parse(plan?.METADATA || "{}");
                    const card = document.createElement("div");
                    card.className = "plan-detail-card";
                    card.innerHTML = `
                <div class="plan-detail-header">
                    <h3 class="plan-name">${plan?.PLAN || "N/A"}</h3>
                    <p class="plan-speed">Up to ${metadata?.speed || "Check speed"}</p>
                    <div class="plan-price">
                        ₦${Number(plan?.AMOUNT).toLocaleString("en-NG", { minimumFractionDigits: 2, maximumFractionDigits: 2 }) || "N/A"}
                        <span class="plan-billing">per month</span>
                    </div>
                    <div class="plan-description">${plan?.PLAN_DESC || ""}</div>
                </div>
                <ul class="plan-features">
                    <li>${metadata?.download || "N/A"}</li>
                    <li>${metadata?.devices || "N/A"}</li>
                    <li>${metadata?.hd || "N/A"}</li>
                    <li>${metadata?.hd4k || "N/A"}</li>
                </ul>
                <button class="select-plan-btn" onclick="selectPlanDetails('${plan?.PLAN_ID}', '${category}')">Select Plan</button>
            `;
                    plansContainer.appendChild(card);
                });
            };

            // window.selectPlanDetails = function (planId, planType) {
            //     const plan = categorizedPlans[registrationData.coverage.city][planType].find((p) => p?.PLAN_ID == planId);
            //     registrationData.selectedPlan = plan;
            //     registrationData.cart = registrationData.cart.map(item => ({
            //         ...item,
            //         quantity: item.id === 1 ? 1 : item.quantity // Auto-select "Premium Max+ Plan" or similar
            //     }));
            //     updateCart();
            //     showStep("step4");
            // };
            window.selectPlanDetails = function (planId, planType) {
                console.log("Plan details", planId, planType);
                console.log(
                    categorizedPlans[registrationData.coverage.city][planType]
                );
                const plan = categorizedPlans[registrationData.coverage.city][
                    planType
                ].find((p) => p?.PLAN_ID == planId);
                registrationData.selectedPlan = plan;
                console.log("The selected plan", plan);
                registrationData.cart = [{
                    name: `${plan?.PLAN} Plan`,
                    price: parseFloat(plan?.AMOUNT),
                    quantity: 1,
                    id: plan?.PLAN_ID,
                    plan_category: plan?.PLAN_CATEGORY,
                    plan_location: plan?.PLAN_LOCATION
                },
                {
                    name: "Installation",
                    price: parseFloat(plan?.OTC),
                    quantity: 1,
                    id: 1
                },
                ];
                updateCart();
                showStep("step4");
            };

            window.goBackToPlans = function () {
                categoryPlansSection.style.display = "none";
                document.querySelectorAll(".plan-card").forEach((card) => card.classList.remove("selected"));
                registrationData.selectedPlanType = null;
                registrationData.selectedPlan = null;
                document.querySelector(".plans-section").scrollIntoView({
                    behavior: "smooth"
                });
            };

            window.changeLocation = function () {
                document.getElementById("categoryPlans").style.display = "none";
                document.getElementById("statusMessage").style.display = "none";
                document.getElementById("unavailableStatusMessage").style.display = "none";
                showStep("step1");
                document.querySelector(".main-content").scrollIntoView({
                    behavior: "smooth"
                });
            };

            // Step 4: Checkout
            function updateCart() {
                const cartItems = document.getElementById("cartItems");
                const cartItemCount = document.getElementById("cartItemCount");
                const subtotalEl = document.getElementById("subtotal");
                const deliveryFeeEl = document.getElementById("deliveryFee");
                const totalEl = document.getElementById("total");
                const addressInput = document.getElementById("installationAddress");
                const addressDetails = document.getElementById("addressDetails");

                cartItems.innerHTML = "";
                let subtotal = 0;
                const activeItems = registrationData.cart.filter(item => item.quantity > 0);
                activeItems.forEach((item, index) => {
                    subtotal += item.price * item.quantity;
                    const cartItem = document.createElement("div");
                    cartItem.className = "cart-item";
                    cartItem.innerHTML = `
                <input type="checkbox" class="cart-item-checkbox" checked onchange="toggleCartItem(${index})" />
                <div class="cart-item-info">${item.name}</div>
                <div class="cart-item-price">₦${(item.price * item.quantity).toFixed(2)}</div>
            `;
                    cartItems.appendChild(cartItem);
                });
                cartItemCount.textContent = activeItems.length;
                subtotalEl.textContent = `₦${subtotal.toFixed(2)}`;
                const deliveryFee = parseFloat(deliveryFeeEl.textContent.replace(/[^0-9.]/g, ""));
                totalEl.textContent = `₦${(subtotal + deliveryFee).toFixed(2)}`;
                addressInput.value = registrationData.userDetails.fullAddress || "";
                addressDetails.textContent = registrationData.coverage.address || "";
            }

            window.toggleCartItem = function (index) {
                const checkbox = document.querySelectorAll(".cart-item-checkbox")[index];
                if (!checkbox.checked) {
                    registrationData.cart[index].quantity = 0;
                    updateCart();
                }
            };

            window.switchTab = function (element, tabType) {
                document.querySelectorAll(".filter-tab").forEach((tab) => tab.classList.remove("active"));
                element.classList.add("active");
                const fiberoneSection = document.getElementById("fiberone-section");
                const thirdPartySection = document.getElementById("third-party-section");
                if (tabType === "all") {
                    fiberoneSection.style.display = "block";
                    thirdPartySection.style.display = "block";
                } else if (tabType === "fiberone") {
                    fiberoneSection.style.display = "block";
                    thirdPartySection.style.display = "none";
                } else if (tabType === "third-party") {
                    fiberoneSection.style.display = "none";
                    thirdPartySection.style.display = "block";
                }
            };

            window.selectPayment = function (element) {
                document.querySelectorAll(".payment-option").forEach((option) => option.classList.remove("selected"));
                element.classList.add("selected");
            };

            window.viewProduct = function (button) {
                const productCard = button.closest(".product-card");
                const productName = productCard.querySelector(".product-name").textContent;
                const productDescription = productCard.dataset.description || 'No description available';
                const imagesJson = productCard.dataset.images || '[]';

                // Get price data
                const originalPrice = parseFloat(productCard.dataset.price || 0);
                const discountPrice = parseFloat(productCard.dataset.discountPrice || 0);
                const stockQuantity = parseInt(productCard.dataset.stock || 0);

                const hasDiscount = discountPrice > 0;
                const displayPrice = hasDiscount ? discountPrice : originalPrice;

                let images = [];
                try {
                    images = JSON.parse(imagesJson);
                } catch (e) {
                    console.error('Error parsing images:', e);
                }

                // Fallback to default image if no images available
                if (!images || images.length === 0) {
                    images = ['../assets/images/wifi-range-img3.png'];
                }

                // Update modal content
                const modal = document.getElementById("productModal");
                document.querySelector(".modal-product-title").textContent = productName;
                document.querySelector(".modal-price").textContent = `₦${displayPrice.toLocaleString('en-NG', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;

                // Show/hide original price if there's a discount
                const originalPriceElement = document.querySelector(".modal-original-price");
                if (hasDiscount) {
                    originalPriceElement.textContent = `₦${originalPrice.toLocaleString('en-NG', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;
                    originalPriceElement.style.display = 'block';
                } else {
                    originalPriceElement.style.display = 'none';
                }

                document.querySelector(".modal-product-description").textContent = productDescription;

                // Update stock info
                const stockInfo = document.querySelector(".modal-stock-info");
                stockInfo.textContent = `${stockQuantity} available in stock`;
                stockInfo.style.color = stockQuantity > 0 ? '#27ae60' : '#e74c3c';

                // Update quantity input max value
                const quantityInput = document.getElementById("modalQuantity");
                quantityInput.max = stockQuantity;
                quantityInput.value = 1;

                // Update main image
                const modalMainImage = document.getElementById("modalMainImage");
                modalMainImage.src = images[0];

                // Update thumbnails
                const thumbnailsContainer = document.getElementById("modalThumbnails");
                thumbnailsContainer.innerHTML = '';

                images.forEach((imageUrl, index) => {
                    const thumbnail = document.createElement('div');
                    thumbnail.className = 'modal-thumbnail';
                    thumbnail.innerHTML = `<img src="${imageUrl}" alt="Thumbnail ${index + 1}" width="100%" onclick="changeModalImage('${imageUrl}')">`;
                    thumbnailsContainer.appendChild(thumbnail);
                });

                modal.style.display = "flex";
            };

            window.closeModal = function () {
                document.getElementById("productModal").style.display = "none";
            };

            window.addToCart = function (button) {
                const productCard = button.closest(".product-card");
                const productId = productCard.dataset.productId;
                const productName = productCard.querySelector(".product-name").textContent;
                const productPrice = parseFloat(productCard.querySelector(".product-price").textContent.replace(/[^0-9.]/g, ""));
                const item = registrationData.cart.find(item => item.id == productId);
                if (item) {
                    item.quantity += 1;
                } else {
                    registrationData.cart.push({
                        name: productName,
                        price: productPrice,
                        quantity: 1,
                        id: productId
                    });
                }
                updateCart();
                button.style.background = "#27ae60";
                button.textContent = "Added!";
                setTimeout(() => {
                    button.style.background = "#e74c3c";
                    button.textContent = "Add to Cart";
                }, 1500);
                showToast("success", `${productName} (₦${productPrice.toFixed(2)}) added to cart!`);
            };

            window.addToCartFromModal = function () {
                const productName = document.querySelector(".modal-product-title").textContent;
                const productPrice = parseFloat(document.querySelector(".modal-price").textContent.replace(/[^0-9.]/g, ""));
                const quantity = parseInt(document.getElementById("modalQuantity").value);
                const item = registrationData.cart.find(item => item.name === productName);
                if (item) {
                    item.quantity += quantity;
                } else {
                    registrationData.cart.push({
                        name: productName,
                        price: productPrice,
                        quantity: quantity
                    });
                }
                updateCart();
                showToast("success", `${productName} (₦${productPrice.toFixed(2)}) added to cart!`);
                closeModal();
            };

            window.increaseModalQuantity = function () {
                const quantityInput = document.getElementById("modalQuantity");
                quantityInput.value = parseInt(quantityInput.value) + 1;
            };

            window.decreaseModalQuantity = function () {
                const quantityInput = document.getElementById("modalQuantity");
                const currentValue = parseInt(quantityInput.value);
                if (currentValue > 1) quantityInput.value = currentValue - 1;
            };

            window.toggleModalSection = function (sectionId) {
                const content = document.getElementById(`modal-${sectionId}-content`);
                const icon = document.getElementById(`modal-${sectionId}-icon`);
                if (content.classList.contains("collapsed")) {
                    content.classList.remove("collapsed");
                    icon.textContent = "−";
                } else {
                    content.classList.add("collapsed");
                    icon.textContent = "+";
                }
            };

            window.changeModalImage = function (src) {
                document.getElementById("modalMainImage").src = src;
            };

            function serializeFormData(formData) {
                const params = new URLSearchParams();

                // Handle products array
                // formData.products.forEach((product, index) => {
                //     Object.entries(product).forEach(([key, value]) => {
                //         params.append(`products[${index}][${key}]`, value);
                //     });
                // });

                formData.products.forEach((product) => {
                    params.append("products[]", product.id);
                });
                params.append("product_information", JSON.stringify(formData.products));
                // Handle the rest of the fields
                Object.entries(formData).forEach(([key, value]) => {
                    if (key !== "products") {
                        params.append(key, value);
                    }
                });

                return params.toString();
            }




            window.proceedToPayment = function () {
                $('#succPan, #errPan').hide().empty();
                const selectedPayment = document.querySelector(".payment-option.selected");
                const paymentMethod = selectedPayment.textContent.trim();
                const activeItems = registrationData.cart.filter(item => item.quantity > 0);

                // Validate fields
                if (!registrationData.coverage.city || !registrationData.coverage.address) {
                    showToast("error", "Please complete the network coverage step.");
                    return;
                }
                if (!registrationData.userDetails.name || !registrationData.userDetails.email || !registrationData.userDetails.phone) {
                    showToast("error", "Please complete all required user details.");
                    return;
                }
                if (!registrationData.selectedPlan) {
                    showToast("error", "Please select a service plan.");
                    return;
                }
                if (activeItems.length === 0) {
                    showToast("error", "Please select at least one product.");
                    return;
                }

                // Add loading state to checkout button
                const checkoutBtn = document.getElementById('checkoutBtn');
                checkoutBtn.classList.add('btn-loading');
                checkoutBtn.disabled = true;
                const originalText = checkoutBtn.textContent;
                checkoutBtn.textContent = 'Processing...';

                const formDatum = {
                    products: activeItems,
                    ...registrationData.userDetails
                };

                // Usage
                const serialized = serializeFormData(formDatum);
                console.log(serialized);
                var formData = serialized


                console.log("FormData", formDatum)


                $.ajax({
                    url: 'ajax/add_customer_order_public.php',
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function (response) {
                        console.log("response here", response)

                        // Remove loading state
                        checkoutBtn.classList.remove('btn-loading');
                        checkoutBtn.textContent = originalText;

                        if (response.success) {
                            // Store order data globally
                            currentOrderData = response;

                            // Disable checkout button after successful order
                            checkoutBtn.disabled = true;
                            checkoutBtn.style.backgroundColor = "gray";

                            const dataForPaystack = {
                                email: registrationData.userDetails.email,
                                name: registrationData.userDetails.name,
                                phone: registrationData.userDetails.phone,
                                total_amount: activeItems.reduce((total, item) => total + (item.price * item.quantity), 0),
                                order_number: response.order_number,
                                tracking_id: response.order_number,
                                plan: registrationData.selectedPlan?.PLAN || "N/A",
                                no_of_months: 1,
                                planId: registrationData.selectedPlan?.PLAN_ID || null,
                                paystack_reference: response.order_number + '-' + Math.floor(Date.now() / 1000) || null
                            };


                            populatePaymentReferenceTable(response.order_number, dataForPaystack.paystack_reference);
                            // Initiate Paystack payment
                            payWithPaystack(dataForPaystack);
                        } else {
                            checkoutBtn.disabled = false;
                            showToast("error", `${response.message}`)
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.log("AJAX error:", textStatus, errorThrown, jqXHR.responseText);

                        // Remove loading state
                        checkoutBtn.classList.remove('btn-loading');
                        checkoutBtn.disabled = false;
                        checkoutBtn.textContent = originalText;

                        showToast("error", 'Cannot contact server. Please try again later.');
                    }
                });
            };

            function populatePaymentReferenceTable(trackingId, reference) {
                $.ajax({
                    url: 'ajax/store_payment_reference.php',
                    type: 'POST',
                    data: {
                        tracking_id: trackingId,
                        reference: reference
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (!response.success) {
                            console.error('Failed to store payment reference:', response.message);
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.error('AJAX error while storing payment reference:', textStatus, errorThrown, jqXHR.responseText);
                    }
                });
            }

            // Paystack Payment Handler
            function payWithPaystack(orderData) {
                const pubkey = "pk_test_8b59b340591f86af7c6641bdf2577cfca2526961"; // Replace with your actual key
                const amountKobo = parseFloat(orderData.total_amount) * 100;
                const reference = orderData.paystack_reference

                var handler = PaystackPop.setup({
                    key: pubkey,
                    email: orderData.email,
                    amount: amountKobo,
                    currency: 'NGN',
                    ref: reference,
                    phone: orderData.phone,
                    first_name: orderData.name,
                    last_name: '',
                    metadata: {

                        custom_fields: [{
                            display_name: "Full Name",
                            variable_name: "fullname",
                            value: orderData.name
                        },
                        {
                            display_name: "Plan Name",
                            variable_name: "planname",
                            value: orderData.plan_name
                        },
                        {
                            display_name: "Plan ID",
                            variable_name: "planid",
                            value: orderData.planId
                        },
                        {
                            display_name: "No of Months",
                            variable_name: "months",
                            value: orderData.no_of_months
                        },
                        {
                            display_name: "Tracking ID",
                            variable_name: "tracking_id",
                            value: orderData.tracking_id
                        }
                        ]
                    },
                    callback: function (response) {
                        // Payment successful
                        console.log('Payment successful. Reference: ' + response.reference);

                        // Verify payment on backend (optional but recommended)
                        $.ajax({
                            url: 'ajax/ajax_verify_payment.php',
                            type: 'POST',
                            data: {
                                reference: response.reference,
                                tracking_id: sanitizeInput(orderData.tracking_id || orderData.order_number)
                            },
                            dataType: 'json',
                            success: function (verifyResponse) {
                                if (verifyResponse.success) {
                                    showSuccessModal();
                                } else {
                                    showToast('error', 'Payment verification failed. Please contact support.');
                                }
                            },
                            error: function () {
                                // Even if verification fails, show success since Paystack confirmed payment
                                showSuccessModal();
                            }
                        });
                    },
                    onClose: function () {
                        // User closed payment modal
                        showToast('info', 'Payment cancelled. You can try again when ready.');

                        // Re-enable checkout button
                        const checkoutBtn = document.getElementById('checkoutBtn');
                        checkoutBtn.disabled = false;
                        checkoutBtn.style.backgroundColor = '';
                    }
                });

                handler.openIframe();
            }

            // Show success modal after payment
            function showSuccessModal() {
                const modal = document.getElementById('successModal');
                modal.classList.add('show');
            }

            // Close success modal
            function closeSuccessModal() {
                const modal = document.getElementById('successModal');
                modal.classList.remove('show');
            }

            // Open appointment modal
            window.openAppointmentModal = function () {
                closeSuccessModal();
                const modal = document.getElementById('appointmentModal');
                modal.classList.add('show');

                // Set minimum date to tomorrow
                const tomorrow = new Date();
                tomorrow.setDate(tomorrow.getDate() + 1);
                const minDate = tomorrow.toISOString().split('T')[0];
                document.getElementById('appointmentDate').setAttribute('min', minDate);
            };

            // Close appointment modal
            window.closeAppointmentModal = function () {
                const modal = document.getElementById('appointmentModal');
                modal.classList.remove('show');
            };

            // Show completion modal
            function showCompletionModal(orderNumber) {
                const modal = document.getElementById('completionModal');
                document.getElementById('completionOrderNumber').textContent = orderNumber;
                modal.classList.add('show');
            }

            // Close completion modal and return to home
            window.closeCompletionModal = function () {
                const modal = document.getElementById('completionModal');
                modal.classList.remove('show');
                // Redirect to home page or reload
                setTimeout(function () {
                    window.location.href = window.location.pathname;
                }, 300);
            };

            // Submit appointment
            window.submitAppointment = function (event) {
                event.preventDefault();

                const appointmentDate = document.getElementById('appointmentDate').value;
                const appointmentTime = document.getElementById('appointmentTime').value;

                // Validate time is between 8:00 AM and 4:00 PM
                const [hours, minutes] = appointmentTime.split(':').map(Number);
                if (hours < 8 || hours >= 16) {
                    showToast('error', 'Installation time must be between 8:00 AM and 4:00 PM');
                    return;
                }

                // Validate date is in future
                const selectedDate = new Date(appointmentDate);
                const today = new Date();
                today.setHours(0, 0, 0, 0);
                if (selectedDate <= today) {
                    showToast('error', 'Please select a future date');
                    return;
                }

                const appointmentDateTime = appointmentDate + ' ' + appointmentTime + ':00';

                // Add loading state
                const submitBtn = document.getElementById('submitAppointmentBtn');
                submitBtn.classList.add('btn-loading');
                submitBtn.disabled = true;
                const originalText = submitBtn.textContent;
                submitBtn.textContent = 'Saving...';

                $.ajax({
                    url: 'ajax/set-installation-date.php',
                    type: 'POST',
                    data: {
                        tracking_id: sanitizeInput(currentOrderData.tracking_id || currentOrderData.order_number),
                        installDate: sanitizeInput(appointmentDateTime)
                    },
                    dataType: 'json',
                    success: function (response) {
                        // Remove loading state
                        submitBtn.classList.remove('btn-loading');
                        submitBtn.textContent = originalText;
                        submitBtn.disabled = false;

                        if (response.success) {
                            showToast('success', 'Installation date scheduled successfully!');
                            closeAppointmentModal();

                            // Show completion message
                            setTimeout(function () {
                                showCompletionModal(currentOrderData.order_number);
                            }, 500);
                        } else {
                            showToast('error', response.message || 'Failed to schedule installation');
                        }
                    },
                    error: function () {
                        // Remove loading state
                        submitBtn.classList.remove('btn-loading');
                        submitBtn.textContent = originalText;
                        submitBtn.disabled = false;

                        showToast('error', 'Unable to schedule installation. Please try again.');
                    }
                });
            };

            // Additional phone/email fields
            let phoneCounter = 1;
            let emailCounter = 1;

            window.addPhoneField = function () {
                phoneCounter++;
                const container = document.getElementById("additionalPhones");
                const fieldDiv = document.createElement("div");
                fieldDiv.className = "additional-field";
                fieldDiv.innerHTML = `
            <input type="tel" class="form-input" placeholder="Additional Phone Number" name="phone${phoneCounter}">
            <button type="button" class="remove-field-btn" onclick="this.parentElement.remove()">Remove</button>
        `;
                container.appendChild(fieldDiv);
            };

            window.addEmailField = function () {
                emailCounter++;
                const container = document.getElementById("additionalEmails");
                fieldDiv.className = "additional-field";
                fieldDiv.innerHTML = `
            <input type="email" class="form-input" placeholder="Additional Email Address" name="email${emailCounter}">
            <button type="button" class="remove-field-btn" onclick="this.parentElement.remove()">Remove</button>
        `;
                container.appendChild(fieldDiv);
            };

            // Initialize
            if (registrationData.selectedPlan) {
                updateCart();
            }
            document.querySelector(".filter-tab.active") && switchTab(document.querySelector(".filter-tab.active"), "all");

            // Close modal when clicking outside
            document.addEventListener("click", function (event) {
                const modal = document.getElementById("productModal");
                if (event.target === modal) {
                    closeModal();
                }
            });

            // Mobile menu toggle
            window.toggleMobileMenu = function () {
                const mobileMenu = document.getElementById("mobileMenu");
                mobileMenu.classList.toggle("active");
            };

            // Close mobile menu when clicking outside
            document.addEventListener("click", function (e) {
                const mobileMenu = document.getElementById("mobileMenu");
                const menuToggle = document.querySelector(".mobile-menu-toggle");

                if (
                    mobileMenu.classList.contains("active") &&
                    !mobileMenu.contains(e.target) &&
                    !menuToggle.contains(e.target)
                ) {
                    mobileMenu.classList.remove("active");
                }
            });
        });
    </script>

</body>

</html>