<?PHP 
$page = "Plan Switch Report";
$page_url="ad_planswitch";
include_once 'includes/header.php'; 
include_once 'includes/sidemenu.php'; 
    
if ( isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101) ) : 
?>  
   <script> window.location.href = 'dash'; </script>
<?PHP
    exit();
endif;

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8"); 

$ad = new UserProfile($db);
//$tck = new Tickets($db, $ad);
$username = $_SESSION[$sid.'username'];
$deptid = 0;

include_once 'includes/accesschk.php'; 
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Plan Switch Report
        <small>history of plan switch.</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Plan Switch Report</li>
      </ol>
    </section>
    
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"> Plan Switch Report</h3>
                </div>
                <div class="box-body">
                    
                  <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs"> 
                        <li class="active"><a href="#allTickets" data-toggle="tab">Report</a></li>
<!--                        <li><a href="#deptTickets" data-toggle="tab">My Department''s Tickets</a></li>
                        <li><a href="#openTickets" data-toggle="tab">Opened Tickets</a></li>
                        <li><a href="#closeTickets" data-toggle="tab">Closed Tickets</a></li>-->
                    </ul>
                    <div class="tab-content">
                      <div class="tab-pane active" id="allTickets">
                          <h3>All Plan Changes
                                <small>list of all plan switch history</small>
                            </h3>
                            

<form role="form" class="form-horizontal" data-toggle="validator" id='frmAllTck' name='frmAllTck' action="" method="post" autocomplete="off" spellcheck="off">
                    <table border="0" cellspacing="5" cellpadding="5">
                    <tbody>
                        <tr style="padding-bottom:4px;">
                            <td style="min-width:70px; background-color: crimson; color: #FFF; text-align: center; padding: 10px;">Query By </td>
                            <td class='spacer-col'>&nbsp;</td>
                            <td style='min-width:50px;'>Report:</td>
                            <td style='min-width:240px;'>
                            <select class="form-control select2" id="tckType" name="tckType" placeholder="Select Report" >
                                <option value="" selected>All</option>
                                <option value="Upgrade">Upgrade</option>
                                <option value="Downgrade">Downgrade</option>
                            </select>
                            </td>
                            <td class='spacer-col'>&nbsp;</td>
                            <td style='min-width:80px;'>Duration:</td>
                            <td style='min-width:240px;'>
                                <input type="date" class="form-control" id="durFrom" name="durFrom" value="<?php echo date('Y-m-d', strtotime('first day of january this year')); ?>" />
                            </td>
                            <td class='spacer-col'>to</td>
                            <td style='min-width:240px;'>
                                <input type="date" class="form-control" id="durTo" name="durTo" value="<?php echo date('Y-m-d'); ?>" />
                            </td>
                            <td class='spacer-col'>&nbsp;</td>
                            <td colspan='2'>
                                <input type="submit" style="background-color: crimson; color: #FFF; padding: 10px;" id="loadAllTckBtn" name="loadAllTckBtn" value="Submit Query" >
                            </td>
                        </tr>
                    </tbody>
                    </table>
                    </form>
                    <br/>

                <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                    <thead>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>OLD_PLAN</th>
                        <th style='text-align: center !important;'>NEW_PLAN</th>
                        <th style='text-align: center !important;'>DONE BY</th>
                        <th style='text-align: center !important; '>IS_AUTO</th>
                        <th style='text-align: center !important;'>CHANGE_TYPE</th>
                        <th style='text-align: center !important;'>DATE DONE</th>
                    </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                    <tfoot>
                    <tr style="font-size:0.9em;">
                        <!--<th>SN</th>-->
                        <th style='text-align: center !important;'>USERNAME</th>
                        <th style='text-align: center !important;'>OLD_PLAN</th>
                        <th style='text-align: center !important;'>NEW_PLAN</th>
                        <th style='text-align: center !important;'>DONE BY</th>
                        <th style='text-align: center !important; '>IS_AUTO</th>
                        <th style='text-align: center !important;'>CHANGE_TYPE</th>
                        <th style='text-align: center !important;'>DATE DONE</th>
                    </tr>
                    </tfoot>
                    
                </table>

                      </div>
                      <!-- /.tab-pane -->
                      
                    </div>
                    <!-- /.tab-content -->
                      
                  </div>
                  <!-- /.nav-tabs-custom -->
                    
                </div>
                <!-- /.box-body -->
              </div>
              <!-- /.box -->  
            </div>
            <!-- /.col-md-12 -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.Main content -->
    
</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>

<script>
$(document).ready(function () {
    
    validateDates = () => {
        var durFrom = $('#durFrom').val();
        var durTo = $('#durTo').val();
        
        if (durFrom && durTo) {
            if (new Date(durTo) < new Date(durFrom)) {
                $("#loadAllTckBtn").prop("disabled",true);
                alert("Start Date must be less than End Date");
                return false;
            } else {
                $("#loadAllTckBtn").prop("disabled",false);
            }
        }
    	console.log("validating...");
    };
    $("#durFrom").on("blur", validateDates);
    $("#durTo").on("blur", validateDates);

    var table = $('#acctable').DataTable({
        'ordering'    : false,
        'autoWidth'   : true,
        "aLengthMenu": [ [50, 100, 200, 500, 1000, 1500, 2000, 5000, -1], [50, 100, 200, 500, 1000, 1500, 2000, 5000, "All"] ],
        "iDisplayLength": 100,
        fixedHeader: false,
        "deferRender": true,
        "processing": true,
        "serverSide": true,
        'serverMethod': 'post',
        dom: 'B<"clear"><"clear">lfrtip',
//            scrollCollapse: true,
        scrollX: true,
        scrollY: '50vh',
        'ajax': {
            'url':'ajax/planSwitchLoader',
            'data': function(data){
               // Read values
               var durFrom = $('#durFrom').val();
               var durTo = $('#durTo').val();
               var tckType = $('#tckType').val();

               // Append to data
               data.durFrom = durFrom && durTo? durFrom : '';
               data.durTo = durFrom && durTo? durTo : '';
               data.isAdmin=-1;
               data.tckType=tckType;
            }
         },
          'columns': [
             { data: 'USERNAME' },
             { data: 'OLD_PLAN' },
             { data: 'NEW_PLAN' },
             { data: 'ADMIN_NAME' },
             { data: 'ISAUTO' },
             { data: 'CHANGE_TYPE' },
             { data: 'DATEDONE' }
          ],
        buttons: {
            name: 'primary',
            buttons: [ 'copy',  
                {
                    "text": 'CSV',
                    "action": _customizeExcelExport
                },
                {
                    "text": 'Excel',
                    "action": _customizeExcelExport
                },
                'print', 'colvis', {
                    text: 'Reload',
                    action: function ( e, dt, node, config ) {
                        dt.ajax.reload();
                    }
                } ]
        }
        
    });
    
    function _customizeExcelExport(e, dt, button, config) {
        
        var params = dt.ajax.params();
    	console.log('Export Excel');
        console.log(params);
        $.ajax({
            type: "POST",
            url: "ajax/planSwitchReportGen",
            data: params,
            success: function(response){  
                alert(response);
                $('#myLoading').modal('hide');
            },
            error: function() {
                alert("Sorry, cannot contact server at this time. Please try again later!");
                $('#myLoading').modal('hide');
            }
        });
    }
    
    // Form Submit Event listener to redraw on input
    $('#frmAllTck').on('submit', function (e) {
        if (e.isDefaultPrevented()) {
          // handle the invalid form...
          //alert("Error");
        } else {
            e.preventDefault();
            table.draw();
        }
    });
    
});
</script>

