<?PHP
$page = "Admin Vendor ORders";
$page_url = "admin_vendor_orders";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)) :
?>
    <script>
        window.location.href = 'dasha';
    </script>
<?PHP
    exit();
endif;
if (!isset($_GET['id'])) :
?>
    <script>
        window.location.href = 'vendors';
    </script>
<?php
    exit();
endif;
$vendorId = base64_decode(urldecode($_GET['id']));
if (!is_numeric($vendorId)) :
?>
    <script>
        window.location.href = 'vendors';
    </script>
<?php
    exit();
endif;

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 
//print_r("vendor id is" . $vendorId);

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$allorders = $dashboard->getVendorOrdersPaginated(
    $vendorId,
    $_GET['page'] ?? 1,
    1,
    $_GET['search'] ?? null
);
//$vendorOrders = $dashboard->getVendorOrders($vendorId);
//$vendor = $dashboard->getVendorDetails($vendorId);
//print_r($vendorOrders);
//$mmdat = $ad->getTransactions("", 0, 20);

$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
?>
<style>
    .search-form {
        margin-bottom: 20px;
    }

    .search-form input[type="text"] {
        padding: 8px;
        width: 300px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    .search-form button {
        padding: 8px 12px;
        border: none;
        background: #007bff;
        color: white;
        border-radius: 4px;
        cursor: pointer;
    }

    .search-form .reset-btn {
        display: inline-block;
        margin-left: 5px;
        padding: 8px 12px;
        background: #ccc;
        color: #000;
        border-radius: 4px;
        text-decoration: none;
    }

    .search-form .reset-btn:hover {
        background: #999;
        color: #fff;
    }

    /* Orders Grid */
    .orders-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
        gap: 20px;
    }

    .order-card {
        background: #fff;
        border: 1px solid #ddd;
        border-radius: 8px;
        padding: 15px;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .order-card h3 {
        margin-top: 0;
        color: #333;
    }

    .order-card p {
        margin: 5px 0;
    }

    .order-card .status {
        font-weight: bold;
    }

    .order-card .status.completed {
        color: green;
    }

    .order-card .status.pending {
        color: orange;
    }

    .order-card .status.cancelled {
        color: red;
    }

    .order-card .view-btn {
        display: inline-block;
        margin-top: 10px;
        padding: 6px 12px;
        background: #28a745;
        color: white;
        border-radius: 4px;
        text-decoration: none;
    }

    .order-card .view-btn:hover {
        background: #218838;
    }

    /* No Orders */
    .no-orders {
        grid-column: 1 / -1;
        text-align: center;
        padding: 20px;
        color: #666;
        background: #f9f9f9;
        border-radius: 6px;
    }

    /* Pagination */
    .pagination {
        margin-top: 20px;
        text-align: center;
    }

    .pagination a,
    .pagination span {
        display: inline-block;
        padding: 8px 12px;
        margin: 0 3px;
        border: 1px solid #ccc;
        border-radius: 4px;
        text-decoration: none;
        color: #007bff;
    }

    .pagination .active {
        background: #007bff;
        color: white;
        font-weight: bold;
    }

    .pagination a:hover {
        background: #0056b3;
        color: white;
    }
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">


    <form method="get" action="" class="search-form">
        <input type="hidden" name="id" value="<?= htmlspecialchars($_GET['id']) ?>">

        <input type="text" name="search" placeholder="Search orders by customer, email, or status..."
            value="<?= htmlspecialchars($allorders->search ?? '') ?>">
        <button type="submit">Search</button>

        <?php if (!empty($allorders->search)): ?>
            <a href="?id=<?= urlencode($_GET['id']) ?>" class="reset-btn">Reset</a>
        <?php endif; ?>
    </form>

    <!-- Orders Grid -->
    <div class="orders-grid">
        <?php if (!empty($allorders->orders)): ?>
            <?php foreach ($allorders->orders as $order): ?>
                <div class="order-card">
                    <h3>Order #<?= htmlspecialchars($order->order_id) ?></h3>
                    <p><strong>Customer:</strong> <?= htmlspecialchars($order->customer_name) ?> (<?= htmlspecialchars($order->customer_email) ?>)</p>
                    <p><strong>Total:</strong> $<?= number_format($order->total_amount, 2) ?></p>
                    <p class="status <?= strtolower($order->status) ?>">
                        <strong>Status:</strong> <?= ucfirst($order->status) ?>
                    </p>
                    <p class="dates">Placed: <?= htmlspecialchars($order->created_at) ?></p>
                    <a href="order_detail.php?id=<?= urlencode(base64_encode($order->order_id)) ?>" class="view-btn">View Details</a>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="no-orders">
                <?php if (!empty($allorders->search)): ?>
                    <p>No orders found for "<strong><?= htmlspecialchars($allorders->search) ?></strong>".</p>
                <?php else: ?>
                    <p>This vendor has no orders yet.</p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if ($allorders->totalPages > 1): ?>
        <div class="pagination">
            <?php
            $currentPage = $allorders->currentPage;
            $searchQuery = !empty($allorders->search) ? "&search=" . urlencode($allorders->search) : "";
            $vendorParam = "id=" . urlencode($_GET['id']);
            ?>

            <?php if ($currentPage > 1): ?>
                <a href="?<?= $vendorParam ?>&page=<?= $currentPage - 1 ?><?= $searchQuery ?>">« Prev</a>
            <?php endif; ?>

            <?php for ($i = 1; $i <= $allorders->totalPages; $i++): ?>
                <?php if ($i == $currentPage): ?>
                    <span class="active"><?= $i ?></span>
                <?php else: ?>
                    <a href="?<?= $vendorParam ?>&page=<?= $i ?><?= $searchQuery ?>"><?= $i ?></a>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if ($currentPage < $allorders->totalPages): ?>
                <a href="?<?= $vendorParam ?>&page=<?= $currentPage + 1 ?><?= $searchQuery ?>">Next »</a>
            <?php endif; ?>
        </div>
    <?php endif; ?>

</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>

<?PHP
include_once 'includes/footer_end.php';
