<?PHP
$page = "Admin Vendor Products";
$page_url = "admin_vendor_product";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)) :
?>
    <script>
        window.location.href = 'dasha';
    </script>
<?PHP
    exit();
endif;
if (!isset($_GET['id'])) :
?>
    <script>
        window.location.href = 'vendors';
    </script>
<?php
    exit();
endif;
$vendorId = base64_decode(urldecode($_GET['id']));
if (!is_numeric($vendorId)) :
?>
    <script>
        window.location.href = 'vendors';
    </script>
<?php
    exit();
endif;

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 
//print_r("vendor id is" . $vendorId);

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$allproducts = $dashboard->getVendorProductsPaginated(
    $vendorId,
    $_GET['page'] ?? 1,
    2,
    $_GET['search'] ?? null
);
//$allproducts = $dashboard->getVendorProductsPaginated($vendorId);
//$vendor = $dashboard->getVendorDetails($vendorId);
//print_r($allproducts);
//$mmdat = $ad->getTransactions("", 0, 20);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
?>
<style>
    .pagination {
        margin: 20px 0;
        text-align: center;
    }

    .pagination a {
        display: inline-block;
        margin: 0 5px;
        padding: 8px 14px;
        border-radius: 6px;
        background: #f0f0f0;
        color: #333;
        text-decoration: none;
        font-size: 14px;
        transition: background 0.2s ease;
    }

    .pagination a:hover {
        background: #3498db;
        color: #fff;
    }

    .pagination a.active {
        background: #3498db;
        color: #fff;
        font-weight: bold;
    }

    .vendor-container {
        max-width: 1000px;
        margin: 30px auto;
        padding: 20px;
        background: #ffffff;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        font-family: Arial, sans-serif;
        color: #333;
    }

    .vendor-header {
        border-bottom: 2px solid #f0f0f0;
        padding-bottom: 15px;
        margin-bottom: 25px;
    }

    .vendor-header h2 {
        margin: 0;
        font-size: 28px;
        color: #2c3e50;
    }

    .vendor-header p {
        margin: 5px 0;
        font-size: 15px;
    }

    .vendor-header a {
        color: #3498db;
        text-decoration: none;
    }

    .vendor-header a:hover {
        text-decoration: underline;
    }

    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
    }

    .product-card {
        background: #f9f9f9;
        padding: 15px;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }

    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
    }

    .product-card h3 {
        margin: 0 0 10px;
        font-size: 20px;
        color: #34495e;
    }

    .product-card .description {
        font-size: 14px;
        color: #555;
        margin-bottom: 10px;
        min-height: 40px;
    }

    .product-card .price {
        font-weight: bold;
        color: #27ae60;
        margin-bottom: 8px;
    }

    .product-card .status {
        font-size: 13px;
        font-weight: bold;
        margin-bottom: 8px;
    }

    .product-card .status.active {
        color: #27ae60;
    }

    .product-card .status.inactive {
        color: #e67e22;
    }

    .product-card .status.archived {
        color: #c0392b;
    }

    .product-card .dates {
        font-size: 12px;
        color: #888;
        line-height: 1.4;
    }

    .no-products,
    .no-vendor {
        text-align: center;
        font-size: 16px;
        color: #999;
        padding: 20px;
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><!--  style="color:#eee"> -->
            Vendor Products
            <small> </small> <!--  style="color: #aaa" -->
        </h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Dashboard</li>
        </ol>
    </section>
    <?php if ($allproducts): ?>
        <div class="vendor-container">
            <div class="vendor-header">
                <h2>Vendor Name: <?= htmlspecialchars($allproducts->vendor->name) ?></h2>
                <p>Email: <a href="mailto:<?= htmlspecialchars($allproducts->vendor->email) ?>"><?= htmlspecialchars($allproducts->vendor->email) ?></a></p>
                <p>Total Products: <strong><?= $allproducts->total_products ?></strong></p>
            </div>
            <!-- Search Form -->
            <form method="get" action="">
                <!-- Keep vendor ID in query -->
                <input type="hidden" name="id" value="<?= htmlspecialchars($_GET['id']) ?>">

                <input type="text" name="search" placeholder="Search products..."
                    value="<?= htmlspecialchars($allproducts->search ?? '') ?>">
                <button type="submit">Search</button>

                <?php if (!empty($allproducts->search)): ?>
                    <a href="?id=<?= urlencode($_GET['id']) ?>" class="reset-btn">Reset</a>
                <?php endif; ?>
            </form>
            <!-- Products Grid -->
            <div class="products-grid">
                <?php if (!empty($allproducts->products)): ?>
                    <?php foreach ($allproducts->products as $product): ?>
                        <div class="product-card">
                            <h3><?= htmlspecialchars($product->name) ?></h3>
                            <p class="price">$<?= number_format($product->price, 2) ?></p>
                            <p class="status <?= strtolower($product->status) ?>">
                                Status: <?= ucfirst($product->status) ?>
                            </p>
                            <p class="dates">
                                Created: <?= htmlspecialchars($product->created_at) ?><br>
                                Updated: <?= htmlspecialchars($product->updated_at) ?>
                            </p>
                            <button>
                                <a href="product_detail.php?id=<?= urlencode(base64_encode($product->id)) ?>">
                                    View Product
                                </a>
                            </button>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p>No products found.</p>
                <?php endif; ?>
            </div>

            <!-- Pagination -->
            <?php if ($allproducts->totalPages > 1): ?>
                <div class="pagination">
                    <?php
                    $currentPage = $allproducts->currentPage;
                    $searchQuery = !empty($allproducts->search) ? "&search=" . urlencode($allproducts->search) : "";
                    $vendorParam = "id=" . urlencode($_GET['id']); // base64 encoded vendor ID
                    ?>

                    <!-- Previous Button -->
                    <?php if ($currentPage > 1): ?>
                        <a href="?<?= $vendorParam ?>&page=<?= $currentPage - 1 ?><?= $searchQuery ?>">« Prev</a>
                    <?php endif; ?>

                    <!-- Page Numbers -->
                    <?php for ($i = 1; $i <= $allproducts->totalPages; $i++): ?>
                        <?php if ($i == $currentPage): ?>
                            <span class="active"><?= $i ?></span>
                        <?php else: ?>
                            <a href="?<?= $vendorParam ?>&page=<?= $i ?><?= $searchQuery ?>"><?= $i ?></a>
                        <?php endif; ?>
                    <?php endfor; ?>

                    <!-- Next Button -->
                    <?php if ($currentPage < $allproducts->totalPages): ?>
                        <a href="?<?= $vendorParam ?>&page=<?= $currentPage + 1 ?><?= $searchQuery ?>">Next »</a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <p class="no-vendor">Vendor not found.</p>
    <?php endif; ?>


    <!-- ./Content Header (Page header) -->



</div>
<!-- /.content-wrapper -->

<?PHP include_once 'includes/footer.php'; ?>

<?PHP
include_once 'includes/footer_end.php';
