<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../includes/AddressCoverage.php"; // Make sure this path is correct

include_once "../config.php";

// Only allow AJAX requests
if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest')) {
    die(json_encode(['error' => 'This file cannot be accessed directly!']));
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");
$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);



$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$city = trim($_POST['city'] ?? '');
$address = trim($_POST['address'] ?? '');

$lat = filter_var($_POST['lat'] ?? '', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
$lon = filter_var($_POST['lon'] ?? '', FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

// Validate inputs
if ($lat === '' || $lon === '') {
    echo json_encode([
        'success' => false,
        'error' => 'Latitude and longitude are required.'
    ]);
    exit;
}




$ad = new AddressCoverage();
$coverage = $ad->checkCoverage($lat, $lon);


if (stripos($coverage['data'], 'AVAILABLE') !== false) {
    $hasCoverage = true;
} else {
    $hasCoverage = false;
}

if (!empty($name) && !empty($email) && !empty($phone)) {
    $leadManager = $dashboard->createCoverageLead(
        $name,
        $email,
        $phone,
        $city,
        $address,
        $hasCoverage,
        $coverage['data']
    );
}


echo json_encode([
    'success' => true,
    'data' => $coverage,
]);
