<?php
header('Content-type: application/json');

//error_reporting(E_ALL);

include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once 'config.php';

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
  die('This file cannot be accessed directly!');
}

## Read value

$data = $_POST;

$required = ['product_id', 'quantity', 'customer_name', 'customer_email', 'shipping_address'];
foreach ($required as $field) {
  if (empty($data[$field])) {
    echo json_encode(['success' => false, 'message' => "Missing field: $field"]);
    exit;
  }
}


$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");


$dashboard = new MarketplaceDashboard($db);

$orderResponse = $dashboard->addProductOrderPublic($data);

// Check insertion
if (!empty($orderResponse['order_id'])) {
  echo json_encode([
    'success' => true,
    'order_id' => $orderResponse['order_id'],
    'total_amount' => $orderResponse['total_amount']
  ]);
} else {
  echo json_encode([
    'success' => false,
    'message' => 'Unable to create order',
    'data' => $orderResponse
  ]);
}
