<?php
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    die('Requested file does not exist!');
}
header('Content-Type: application/json');

// collect form data safely
$data = [
    "title"           => $_POST['title'] ?? null,
    "name"            => $_POST['name'] ?? null,
    "email"           => $_POST['email'] ?? null,
    "phone_number"    => $_POST['phone_number'] ?? null,
    "business_name"   => $_POST['business_name'] ?? null,
    "logo"            => $_POST['logo'] ?? null,
    "bio"             => $_POST['bio'] ?? null,
    "cac"             => $_POST['cac'] ?? null,
    "tax"             => $_POST['tax'] ?? null,
    "website"         => $_POST['website'] ?? null,
    "business_info" => $_POST['business_type_id'] ?? null,
    "address"         => $_POST['address'] ?? null,
    "city"            => $_POST['city'] ?? null,
    "state"           => $_POST['State'] ?? null
];
//echo json_encode($data);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$result = $dashboard->addVendorPublic($data);

if ($result['status'] === "success") {
    http_response_code(200);
    echo json_encode($result);
} else {
    http_response_code(400);
    echo json_encode($result);
}
