<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    die('This file cannot be accessed directly!');
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);
$fob_vendor_id = $dashboard->getFobVendor();

// Check if this is an export request
if (isset($_GET['action']) && $_GET['action'] === 'export') {
    $search = isset($_GET['search']) ? trim($_GET['search']) : null;
    $status = isset($_GET['status']) ? trim($_GET['status']) : 'all';
    $startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
    $endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

    // Fetch all orders for export
    $ordersData = $dashboard->getFobOrders($fob_vendor_id, 1, 0, $search, $status, $startDate, $endDate, true);
    $orders = $ordersData['orders'];

    // Format data for export
    $data = [];
    foreach ($orders as $order) {
        $status = strtolower($order->status ?: 'pending');
        $data[] = [
            'customer_name' => $order->customer_name,
            'customer_email' => $order->customer_email,
            'order_id' => $order->order_id,
            'status' => ucfirst($status),
            'total_amount' => '₦' . number_format($order->total_amount, 2),
            'created_at' => date('Y-m-d h:i A', strtotime($order->created_at))
        ];
    }

    echo json_encode(['data' => $data]);
    exit;
}

// DataTables request
$draw = isset($_GET['draw']) ? (int) $_GET['draw'] : 1;
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$limit = isset($_GET['length']) ? (int) $_GET['length'] : 10;
$search = isset($_GET['search']) ? trim($_GET['search']) : null;
$status = isset($_GET['status']) ? trim($_GET['status']) : 'all';
$startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
$endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

// Fetch paginated orders
$ordersData = $dashboard->getFobOrders($fob_vendor_id, $page, $limit, $search, $status, $startDate, $endDate);
$orders = $ordersData['orders'];
$totalRecords = $ordersData['totalRecords'];
$filteredRecords = $ordersData['filteredRecords'];

// Format data for DataTables
$data = [];
foreach ($orders as $order) {
    $status = strtolower($order->status ?: 'pending');
    $avatarInitials = strtoupper(substr($order->customer_name, 0, 1) . (strpos($order->customer_name, ' ') !== false ? substr($order->customer_name, strpos($order->customer_name, ' ') + 1, 1) : ''));
    $data[] = [
        'customer_name' => '
            <div class="customer-info">
                <input type="checkbox" class="order-checkbox" />
                <div class="customer-avatar">' . htmlspecialchars($avatarInitials) . '</div>
                <div class="customer-details">
                    <h6>' . htmlspecialchars($order->customer_name) . '</h6>
                    <p>' . htmlspecialchars($order->customer_email) . '</p>
                </div>
            </div>',
        'order_id' => '<a href="/eservice/order_detail.php?id=' . urlencode(base64_encode($order->order_id)) . '" class="order-id">#' . htmlspecialchars($order->order_id) . '</a>',
        'status' => '<span class="status-badge status-' . htmlspecialchars($status) . '">' . htmlspecialchars(ucfirst($status)) . ' Payment</span>',
        'total_amount' => '<span class="order-price">₦' . htmlspecialchars(number_format($order->total_amount, 2)) . '</span>',
        'created_at' => '<span class="order-date">' . htmlspecialchars(date('Y-m-d h:i A', strtotime($order->created_at))) . '</span>',
        'actions' => '<button class="view-btn" onclick="viewOrder(' . $order->order_id . ')"><i class="fa fa-eye"></i></button>'
    ];
}

// Return DataTables JSON response
echo json_encode([
    'draw' => $draw,
    'recordsTotal' => $totalRecords,
    'recordsFiltered' => $filteredRecords,
    'data' => $data
]);