<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    echo json_encode(['error' => 'This file cannot be accessed directly!']);
    exit;
}

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$dashboard = new MarketplaceDashboard($db);
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
//$vendorId = $this->getVendorState($_SESSION[$sid . 'userid']);


// Check if vendor_id is valid
if ($vendor_id === null) {
    echo json_encode([
        'draw' => isset($_GET['draw']) ? (int) $_GET['draw'] : 1,
        'recordsTotal' => 0,
        'recordsFiltered' => 0,
        'data' => []
    ]);
    exit;
}

// Check if this is an export request
if (isset($_GET['action']) && $_GET['action'] === 'export') {
    $search = isset($_GET['search']) ? trim($_GET['search']) : null;
    $status = isset($_GET['status']) ? trim($_GET['status']) : 'all';
    $startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
    $endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

    $ordersData = $dashboard->getVendorOrders($vendor_id, 1, 0, $search, $status, $startDate, $endDate, true);
    $orders = $ordersData['orders'];

    $data = [];
    foreach ($orders as $order) {
        $status = strtolower($order->status ?: 'pending');
        $data[] = [
            'customer_name' => $order->customer_name,
            'customer_email' => $order->customer_email,
            'order_id' => $order->order_id,
            'status' => ucfirst($status),
            'total_amount' => '₦' . number_format($order->total_amount, 2),
            'created_at' => date('Y-m-d h:i A', strtotime($order->created_at))
        ];
    }

    echo json_encode(['data' => $data]);
    exit;
}

// DataTables request
$draw = isset($_GET['draw']) ? (int) $_GET['draw'] : 1;
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$limit = isset($_GET['length']) ? (int) $_GET['length'] : 10;
$search = isset($_GET['search']) ? trim($_GET['search']) : null;
$status = isset($_GET['status']) ? trim($_GET['status']) : 'all';
$startDate = isset($_GET['startDate']) ? trim($_GET['startDate']) : null;
$endDate = isset($_GET['endDate']) ? trim($_GET['endDate']) : null;

// Fetch paginated orders
$ordersData = $dashboard->getVendorOrders($vendor_id, $page, $limit, $search, $status, $startDate, $endDate);
$orders = $ordersData['orders'];
$totalRecords = $ordersData['totalRecords'];
$filteredRecords = $ordersData['filteredRecords'];

$avatarColors = ['avatar-pink', 'avatar-blue', 'avatar-orange', 'avatar-green', 'avatar-purple', 'avatar-teal', 'avatar-red'];
$statusColors = [
    'fulfilled' => '#4caf50',
    'pending' => '#ff9800',
    'declined' => '#f44336',
    'canceled' => '#9c27b0'
];

// Format data for DataTables
$data = [];
foreach ($orders as $index => $order) {
    $status = strtolower($order->status ?: 'pending');
    $avatarColor = $avatarColors[$index % count($avatarColors)];
    $statusColor = $statusColors[$status] ?? '#607d8b';
    $avatarInitials = strtoupper(substr($order->customer_name, 0, 1) . (strpos($order->customer_name, ' ') !== false ? substr($order->customer_name, strpos($order->customer_name, ' ') + 1, 1) : ''));
    $dropdownActions = '
        <p class="actions-header">Actions</p>
        <a href="#" class="view-btn" data-order-id="' . htmlspecialchars($order->order_id) . '">View</a>';
    if ($status !== 'fulfilled') {
        $dropdownActions .= '<a href="#" class="mark-fulfilled" data-status="fulfilled" data-order-id="' . htmlspecialchars($order->order_id) . '">Mark as Fulfilled</a>';
    }
    if ($status !== 'declined' && $status !== 'canceled' && $status !== 'fulfilled') {
        $dropdownActions .= '<a href="#" class="mark-declined" data-status="declined" data-order-id="' . htmlspecialchars($order->order_id) . '">Mark as Declined</a>';
    }

    $data[] = [
        'customer_name' => '
            <div style="display: flex; align-items: center">
                <input type="checkbox" class="order-checkbox" />
                <a href="#" class="view-btn" data-order-id="' . htmlspecialchars($order->order_id) . '">
                    <div class="customer-info">
                        <div class="customer-avatar ' . $avatarColor . '">' . htmlspecialchars($avatarInitials) . '</div>
                        <div class="customer-details">
                            <h6>' . htmlspecialchars($order->customer_name) . '</h6>
                            <p>' . htmlspecialchars($order->customer_email) . '</p>
                        </div>
                    </div>
                </a>
            </div>',
        'order_id' => '<span class="order-id">#' . htmlspecialchars($order->order_id) . '</span>',
        'status' => '<span class="label" style="background: ' . $statusColor . ';">' . htmlspecialchars(ucfirst($status)) . '</span>',
        'total_amount' => '₦' . number_format($order->total_amount, 2),
        'created_at' => date('Y-m-d h:i A', strtotime($order->created_at)),
        'actions' => '
            <div class="action-container">
                <button class="action-btn"><i class="fa fa-ellipsis-h"></i></button>
                <div class="itemdropdown">' . $dropdownActions . '</div>
            </div>'
    ];
}

echo json_encode([
    'draw' => $draw,
    'recordsTotal' => $totalRecords,
    'recordsFiltered' => $filteredRecords,
    'data' => $data
]);
