<?php
//header('Content-Type: application/json');
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

// Only accept POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

// Extract POST data
$reference   = $_POST['reference'] ?? '';
$tracking_id = $_POST['tracking_id'] ?? '';

if (!$reference || !$tracking_id) {
    echo json_encode(['success' => false, 'message' => 'Missing reference or tracking ID']);
    exit();
}

// Open DB connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");
$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
// Fetch transaction info for this reference
$vverify = $dashboard->getTrackingIdByPaymentRef($reference);
if (empty($vverify) || $vverify === "0" || $vverify !== $tracking_id) {
    echo json_encode(['success' => false, 'message' => 'Transaction not found']);
    exit();
}


// Decide which private key to use
// if ($vval['IS_UPCOUNTRY']) {
//     $privkey = PS_UPC_LIVE_PRIV_KEY;
//     // $journal_info = $ad->getJournalInfoERP2("PAYSTACK_UPC");
// } else {
//     $privkey = PS_TEST_PRIV_KEY;
//     //  $journal_info = $ad->getJournalInfoERP2("PAYSTACK_REG");
// }

$privkey = "sk_test_1653e28f4ddca5363e71b207e49b7915867c1b01";
// Verify transaction with Paystack
$url = VERIFY_PS_URL . $reference;
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . $privkey
]);
$response = curl_exec($ch);
$curlError = curl_error($ch);
curl_close($ch);

if ($curlError) {
    echo json_encode(['success' => false, 'message' => 'cURL Error: ' . $curlError]);
    exit();
}

$result = json_decode($response, true);
if (!$result || !isset($result['data'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid response from Paystack']);
    exit();
}

// Check if transaction was successful
$payData = $result['data'];
$is_okay = false;
$vval = $dashboard->getCustomerByTrackingIdPS($tracking_id);
if (
    $payData['status'] === 'success' &&
    $reference == $payData['reference']
) {
    $totalAmount = $vval->total_amount;
    $planId = $vval->plan_id;

    $plansUrl = "https://eservice.fob.ng/apy/public/getplansWebsite";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $plansUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $plansResponse = curl_exec($ch);
    $plansError = curl_error($ch);
    curl_close($ch);

    if ($plansError) {
        echo json_encode(['success' => false, 'message' => 'Plans API error: ' . $plansError]);
        exit();
    }
    $plansData = json_decode($plansResponse, true);
    if (!$plansData || !isset($plansData['UDATA'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid plans API response']);
        exit();
    }

    $matchedPlan = null;
    foreach ($plansData['UDATA'] as $plan) {
        if ($plan['PLAN_ID'] == $planId) {
            $matchedPlan = $plan;
            break;
        }
    }

    if (!$matchedPlan) {
        echo json_encode(['success' => false, 'message' => 'Plan not found in plans API']);
        exit();
    }

    $expectedAmount = (float)$matchedPlan['AMOUNT'] + (float)$matchedPlan['OTC'];
    $amountPaid = $payData['amount'] / 100;

    $reason = [];
    if (isset($payData['currency']) && $payData['currency'] !== 'NGN') {
        $reason[] = "Invalid currency: " . $payData['currency'];
    }

    if ($amountPaid < $expectedAmount) {
        $reason[] = "Underpaid: Paid {$amountPaid}, Expected {$expectedAmount}";
    }

    if (!empty($reason)) {
        $reasonText = implode("; ", $reason);
        $refPaid = $dashboard->setPaystackReferencePaid($reference, 'failed', $reasonText);

        echo json_encode(['success' => false, 'message' => $reasonText]);
        exit();
    }

    $is_okay = true;
    //    $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
    //  $exp = isExpired($userdet['EXPIRATION']);
    //$validity = ($vval["NMONTHS"] >= 12) ? ($vval["NMONTHS"] * $userdet["VALIDITY"]) + 8 : ($vval["NMONTHS"] * $userdet["VALIDITY"]);
    //$nu_expd = $exp ? add_date(date("Y-m-d H:i:s"), $validity) : add_date($userdet['EXPIRATION'], $validity);

    // Save transaction
    $pdate = date("Y-m-d H:i:s");
    // $appDate = date("Y-m-d H:i:s", strtotime($payData['transaction_date']));
    $appDate = isset($payData['transaction_date']) ? date("Y-m-d H:i:s", strtotime($payData['transaction_date'])) : $pdate;


    $trackingId = $dashboard->getTrackingIdByPaymentRef($reference);
    $onboardPaid = $dashboard->setOnboardingPaid($trackingId);
    $refPaid = $dashboard->setPaystackReferencePaid($reference);
    // $dashboard->getTrackingIdByPaymentRef($reference);
    // $dashboard->setOnboardingPaid($trackingId);
    // $dashboard->setPaystackReferencePaid($reference);

    $agent_commission   = $dashboard->calculateCommission($totalAmount, $planId);
    $updateOrder = $dashboard->updateSalesOrderAfterPayment(
        $trackingId,
        $payData['reference'],
        $payData['authorization']['authorization_code'] ?? '',
        $payData['status'],
        $payData['gateway_response'] ?? '',

        $appDate,
        $agent_commission
    );





    // Send emails
    // $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS_NEW");
    //$msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], ($payData['amount'] / 100), $vval["PACKAGE"], $nu_expd, $payData['reference'], $payData['reference'], SERVER_URL);
    //$ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "FiberOne - Successful Subscription Renewal", $msg);

    echo json_encode([
        'success' => true,
        'message' => 'Payment verified and order processed',

    ]);
} else {

    $reason = [];

    if ($vval['total_amount'] > ($payData['amount'] / 100)) {
        $reason[] = "Amount mismatch (paid lower than expected)";
    }
    if ($reference != $payData['reference']) {
        $reason[] = "Reference mismatch";
    }
    if (isset($payData['currency']) && $payData['currency'] !== 'NGN') {
        $reason[] = "Invalid currency: " . $payData['currency'];
    }
    $reasonText = implode("; ", $reason);
    $refPaid = $dashboard->setPaystackReferencePaid($reference, 'failed', $reasonText);

    echo json_encode([
        'success' => false,
        'message' => 'Payment verification failed: ' . ($reasonText ?: 'Unknown'),
        'data' => $payData
    ]);
}

exit();
