<?php
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
extract($_POST);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$adminUser = $_SESSION[$sid.'username'];
$adminId = $_SESSION[$sid.'userid'];
if ($adminUser != $user) :
    echo "Error: Unauthorized Access";
    exit();
endif;
$log = new Logger($db, $adminUser);
$ad = new UserProfile($db);

$sendTo = "sel";
$criteria = [$username];

//check Ticket ID
$tcks = $ad->loadOutageTicket($ticketId);
if (count($tcks) > 0) {
    echo "Ticket Id already exist in Loss Days request";
    exit();
}

$affected = json_encode($criteria);
$creationDate = date("Y-m-d H:i:s");

if ($expectedResolutionDate < $incidencedate || $expectedResolutionDate == ''):
    $expectedResolutionDate = add_date($incidencedate, 1);
endif;

$cticket = $ad->createOutageTicket($ticketId, "Local Support", null, null, $affected, $incidencedate, $expectedResolutionDate, 
            "Open", $incsummary, $adminUser, $creationDate, $adminId);

if ($cticket) {
    $strsql = "UPDATE tbl_outage_local_ticket SET TICKET_STATUS='Request Opened' WHERE TICKET_ID=?";
    $db->execute_query($strsql, 's', $ticketId);
    
    $tckInfoLst = $ad->loadOutageTicket($ticketId);
    foreach($tckInfoLst as $val) {
        $lossDays = $val;
    }
    if ( in_array($ticketResolved, ['isclosed', 'isclosedrequest']) ) {
        $incidenceId = $lossDays['INCIDENCE_ID'];
        //close ticket
        $ret = $ad->closeOutageTicket($ticketId, $incidenceId, $resolutiondate, 'Closed', 1, $qualified, $adminUser);
        if ($ret) {
            $strsql = "UPDATE tbl_outage_local_ticket SET TICKET_STATUS='Ticket Processed' WHERE TICKET_ID=?";
            $db->execute_query($strsql, 's', $ticketId);
    
            if ($ticketResolved == 'isclosedrequest') {
                $tckInfoLst = $ad->loadOutageTicket($ticketId);
                foreach($tckInfoLst as $val) {
                    $lossDays = $val;
                }
                if ($lossDays["ISCLOSED"] && ($lossDays["DURATION"] > 0) && $qualified):
                    $rett = $ad->requestLostDays($ticketId, $incidenceId, $lossDays["DURATION"], $adminUser, $adminId, $lossDays['AFFECTED_USERS'] );
                    if ($rett) {
                        $sent = $ad->sendNotifToLossDaysLevelApprover(1, $ticketId, $incidenceId, $lossDays["DURATION"]);
                        echo "Success: Incidence Ticket with ID $ticketId closed and request for approval automatically completed!";
                        exit();
                    }
                endif;
                //return
                echo "Success: Incidence Ticket with ID $ticketId closed but request for approval could not be automatically completed.";
                exit();
            }
            

            //return
            echo "Success: Incidence Ticket with ID $ticketId closed.";
        } else {
            echo "Error: Unable to close the incidence ticket with Ticket ID: $ticketId";
        }
    } else {
        echo "Success: Incidence Ticket with ID $ticketId created";
    }
} else {
    echo "Error: Unable to create the local incidence ticket with Ticket ID: $ticketId";
}