<?php
set_time_limit(0);
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

include_once __DIR__ . '/../includes/fast-excel-writer/autoload.php';

use \avadim\FastExcelWriter\Excel;

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
$storeFileDir = __DIR__ . '/../storage/';
$outFileDir = SERVER_URL . 'reporfils/';
$adminUsername = trim($_SESSION[$sid.'username']);
$adminUser = str_replace(".","-",trim($_SESSION[$sid.'username']));
$adminEmail = $_SESSION[$sid.'email'];

if (!isset($_SESSION[$sid.'email']) || (!isset($_SESSION[$sid.'username']))) {
    echo "Your session has expired and your request cannot be completed at the moment. Please login and try again";
    exit();
}
   
extract($_POST);
   
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new AdminDashboardReport($db);

//log Report Request
$logId = $ad->logReportRequest($action, json_encode($_POST), $adminUsername, $adminEmail, date("Y-m-d H:i:s"));

session_write_close();
$reportType = (($action == 'totalCust')? "$category customers [location: $location]" :
        (($action == 'newCust')? "$category new customers [duration: $duration]" : 
        (($action == 'serviceRenewal')? "$category service renewals [duration: $duration]" : 
        (($action == 'expiringCust')? "$category expiring customers" : 
        (($action == 'expiredCust')? "$category expired customers" : 
        (($action == 'freeCust')? "$category free customers" : ""))))));
$message ='Your request for a report on '.$reportType.' has been received and is currently been proceessed.';
$message .= " The report will be sent to your email ($adminEmail) once ready. Thank you";
echo $message;
$backgroundJob = function () use ($message) {
    echo $message;
};
 register_shutdown_function($backgroundJob);
 fastcgi_finish_request();
// if (function_exists('fastcgi_finish_request')) {
//     fastcgi_finish_request();
// 	// echo '<p style="color: red;">This serve supports <code>fastcgi_finish_request()</code> function.</p>' . PHP_EOL;
// 	// echo 'Exit now.<br>' . PHP_EOL;
// 	// exit();
// } else {
//     echo '<p style="color: red;">This server does not support <code>fastcgi_finish_request()</code> function.</p>' . PHP_EOL;
//     echo 'Exit now.<br>' . PHP_EOL;
//     exit();
// }

$rand = new Password_Generator();
$randStr = $rand->generate(9, 15, true, true);

if ($action == 'totalCust') :
    totalCust($ad, $location, $category);
elseif ($action == 'newCust') :
    (newCust($ad, $duration, $category));
elseif ($action == 'serviceRenewal') :
    (renewals($ad, $duration, $category));
elseif ($action == 'expiringCust') :
    (expiring($ad, $category));
elseif ($action == 'expiredCust') :
    (expired($ad, $category));
elseif ($action == 'freeCust') :
     (freeCust($ad, $category));
endif;

/**
 * Create Excel sheet. $columnFormat defines the format for the columns in the sheet in a key-value pattern,
 * where the key is the column number starting from 1.
 * 
 * @param mixed $sheet
 * @param array $data
 * @param array $columnFormat   
 */
function makeExcelSheet(&$sheet, $data, $columnFormat=[]) {
    
    $headStyle = [
        'font' => [
            'style' => 'bold'
        ],
        'text-align' => 'center',
        'vertical-align' => 'center',
        'border' => 'thin',
        'height' => 24,
    ];
    $headings = array_keys($data[0]);
    $sheet->writeHeader($headings, $headStyle);
    //set format
    if (count($columnFormat)):
        foreach ($columnFormat as $key => $value) {
            $sheet->setColFormat($key, $value);
        }
    endif;
    
    $rowNum = 1;
    foreach($data as $rowData) {
        $rowOptions = [
            'height' => 20, 'border' => 'thin',
        ];
        if ($rowNum % 2) {
            $rowOptions['fill-color'] = '#eee';
        }
        $sheet->writeRow($rowData, $rowOptions);
    }
}

function sendMail($mailType, $subject, $file, $startTime, $endTime, $duration) {
    global $db, $adminEmail, $logId, $ad;
    if (filter_var($adminEmail, FILTER_VALIDATE_EMAIL)) {
    	$up = new UserProfile($db); 
    	$raw_msg = $up->getCannedMessage($mailType); 
    	// $raw_msg_addon = $up->getCannedMessageAddon($mailType); print_r( $raw_msg_addon); return;
    	$msg = sprintf($raw_msg, $subject, $startTime, $endTime, $duration ."s", $file, $file); 
    	$sent = $up->sendEmailBrevo($adminEmail, 'fiberonepayment@gmail.com', "Report on $subject - ".date("Y-m-d H:i:s"), $msg, [], [], $raw_msg_addon);
    }
    $ad->setReportGenCompleted($logId, date("Y-m-d H:i:s"), $sent);
    
    return $sent;
}

function totalCust($ad, $loc, $category='all') {
    global $outFileDir, $storeFileDir,  $adminUser, $randStr;
    $location = $loc<>'all'? $loc : '';
    
    $requestTime = date("d-m-Y H:i:s");
    $timer = microtime(true);
    
    $excel = Excel::create();
    
    if ($category == 'all'):
        $sheet1 = $excel->makeSheet('All Customers');
        $totalCust = $ad->getAllCustomers($location);
        $colformat = [ 8=>"@text",
            13=>'@date', 14=>'@datetime', 15=>'@datetime'
        ];
        makeExcelSheet($sheet1, $totalCust, $colformat);
    endif;
    if (in_array($category, ['all', 'online'])):
        $sheet2 = $excel->makeSheet('Online Customers');
        $onlineCust = $ad->getOnlineCustomers($location);
        $colformat = [ 8=>"@text",
            10=>'@datetime', 11=>'@datetime'
        ];
        makeExcelSheet($sheet2, $onlineCust, $colformat);
    endif;
    if (in_array($category, ['all', 'active'])):
        $sheet3 = $excel->makeSheet('Active Customers');
        $activeCust = $ad->getActiveCustomers($location);
        $colformat = [ 8=>"@text",
            13=>'@datetime', 14=>'@datetime', 15=>'@datetime'
        ];
        makeExcelSheet($sheet3, $activeCust, $colformat);
    endif;
    if (in_array($category, ['all', 'expired'])):
        $sheet4 = $excel->makeSheet('Expired Customers');
        $expiredCust = $ad->getExpiredCustomers($location);
        $colformat = [ 8=>"@text",
            13=>'@datetime', 14=>'@datetime', 15=>'@datetime',
            17=>'@integer', 18=> '0.00'
        ];
        makeExcelSheet($sheet4, $expiredCust, $colformat);
    endif;
    if (in_array($category, ['all', 'paused'])):
        $sheet5 = $excel->makeSheet('Paused Customers');
        $pausedCust = $ad->getPausedCustomers($location);
        $colformat = [ 8=>"@text",
            13=>'@datetime', 14=>'@datetime', 15=>'@datetime',
            16=>'@datetime', 17=>'@datetime', 18=>'@integer'
        ];
        makeExcelSheet($sheet5, $pausedCust, $colformat);
    endif;
    if (in_array($category, ['all', 'pending'])):
        $sheet6 = $excel->makeSheet('Pending Customers');
        $pendingCust = $ad->getPendingCustomers($location);
        $colformat = [
            8=>"@text", 13=>'@datetime'
        ];
        makeExcelSheet($sheet6, $pendingCust, $colformat);
    endif;
    
    //remove sheet1
    $excel->removeSheet('Sheet1');
    
    //save Excel File
    $filename = $category."_Customer_".$adminUser."_".date('dmYHi');
    $outFileName = $outFileDir.  $randStr . "/" . $filename;
    $storename = $storeFileDir . $filename . ".xlsx";
    $excel->save($storename);
    
    //timer
    $time = round(microtime(true) - $timer, 3);
    $completeTiime = date("d-m-Y H:i:s");
    
    //send file download link in email
    sendMail("REPORT_MAIL", " $category Customers [$loc]", $outFileName, $requestTime, $completeTiime, $time);
}


function newCust($ad, $duration, $category) {
    global $outFileDir, $storeFileDir,  $adminUser, $randStr;
    $cat = $category<>'all'? $category : '';
    
    $requestTime = date("d-m-Y H:i:s");
    $timer = microtime(true);
    
    $excel = Excel::create();
    
    $startDate = $endDate = "";
    if ($duration == "thisMonth"):
        $startDate = date('Y-m-d', strtotime('first day of this month'));
        $endDate = date('Y-m-d', strtotime('last day of this month'));
    elseif ($duration == "lastMonth") :
        $startDate = date('Y-m-d', strtotime('first day of last month'));
        $endDate = date('Y-m-d', strtotime('last day of last month'));
    elseif ($duration == "twoMonthAgo") :
        $startDate = date('Y-m-01', strtotime('-2 months'));
        $endDate = date('Y-m-t', strtotime('-2 months'));
    elseif ($dur == "last3Months") :
        $startDate = date('Y-m-01', strtotime('-3 months'));
        $endDate = date('Y-m-t', strtotime('-3 months'));
    elseif ($dur == "last6Months") :
        $startDate = date('Y-m-01', strtotime('-6 months'));
        $endDate = date('Y-m-t', strtotime('-6 months'));
    elseif ($dur == "thisYear") :
        $startDate = date('Y-m-d', strtotime('first day of January this year'));
        $endDate = date('Y-m-d', strtotime('last day of this month'));
    elseif ($dur == "lastYear") :
        $startDate = date('Y-m-d', strtotime('first day of January last year'));
        $endDate = date('Y-m-d', strtotime('last day of December last year'));
    elseif (is_int((int)$duration)) :
        $startDate = date('Y-m-d', strtotime("-".$duration." days"));
        $endDate = date('Y-m-d');
    endif;
    $resp = $ad->getNewActivationsByLocation($startDate, $endDate, $cat);
    foreach ($resp as $key => $value) {
        $sheet6 = $excel->makeSheet($key . ' Customers');
        $colformat = [
            8=>"@text", 13=>'@datetime', 14=>'@date', 15=>'@datetime'
        ];
        makeExcelSheet($sheet6, $value, $colformat);
    }
    
    //remove sheet1
    $excel->removeSheet('Sheet1');
    
    //save Excel File
    $filename = $category."_NewCustomer_".$adminUser."_".date('dmYHi');
    $outFileName = $outFileDir.  $randStr . "/" . $filename;
    $storename = $storeFileDir . $filename . ".xlsx";
    $excel->save($storename);
    
    //timer
    $time = round(microtime(true) - $timer, 3);
    $completeTiime = date("d-m-Y H:i:s");
    
    //send file download link in email
    sendMail("REPORT_MAIL", " $category New Customers [from $startDate to $endDate]", $outFileName, $requestTime, $completeTiime, $time);
}


function renewals($ad, $duration, $category) {
    global $outFileDir, $storeFileDir,  $adminUser, $randStr;
    $cat = $category<>'all'? $category : '';
    
    $requestTime = date("d-m-Y H:i:s");
    $timer = microtime(true);
    
    $excel = Excel::create();
    
    $startDate = $endDate = "";
    if ($duration == "thisMonth"):
        $startDate = date('Y-m-d', strtotime('first day of this month'));
        $endDate = date('Y-m-d', strtotime('last day of this month'));
    elseif ($duration == "lastMonth") :
        $startDate = date('Y-m-d', strtotime('first day of last month'));
        $endDate = date('Y-m-d', strtotime('last day of last month'));
    elseif ($duration == "twoMonthAgo") :
        $startDate = date('Y-m-01', strtotime('-2 months'));
        $endDate = date('Y-m-t', strtotime('-2 months'));
    elseif ($dur == "last3Months") :
        $startDate = date('Y-m-01', strtotime('-3 months'));
        $endDate = date('Y-m-t', strtotime('-3 months'));
    elseif ($dur == "last6Months") :
        $startDate = date('Y-m-01', strtotime('-6 months'));
        $endDate = date('Y-m-t', strtotime('-6 months'));
    elseif ($dur == "thisYear") :
        $startDate = date('Y-m-d', strtotime('first day of January this year'));
        $endDate = date('Y-m-d', strtotime('last day of this month'));
    elseif ($dur == "lastYear") :
        $startDate = date('Y-m-d', strtotime('first day of January last year'));
        $endDate = date('Y-m-d', strtotime('last day of December last year'));
    elseif (is_int((int)$duration)) :
        $startDate = date('Y-m-d', strtotime("-".$duration." days"));
        $endDate = date('Y-m-d');
    endif;
    $resp = $ad->getRenewalTransactions($startDate, $endDate, $cat);
    foreach ($resp as $key => $value) {
        $sheet6 = $excel->makeSheet($key . ' Service Renewals');
        $colformat = [
            8=>"@text", 10=>'@datetime', 11=>'@datetime', 13=>"@text",
        	14=>'@datetime', 15=>'@datetime', 16=>"@text"
        ];
        makeExcelSheet($sheet6, $value, $colformat);
    }
    
    //remove sheet1
    $excel->removeSheet('Sheet1');
    
    //save Excel File
    $filename = $category."_RenewalTransactions_".$adminUser."_".date('dmYHi');
    $outFileName = $outFileDir.  $randStr . "/" . $filename;
    $storename = $storeFileDir . $filename . ".xlsx";
    $excel->save($storename);
    
    //timer
    $time = round(microtime(true) - $timer, 3);
    $completeTiime = date("d-m-Y H:i:s");
    
    //send file download link in email
    sendMail("REPORT_MAIL", " $category Renewal Transactions [from $startDate to $endDate]", $outFileName, $requestTime, $completeTiime, $time);
}

function expiring($ad, $category) {
    global $outFileDir, $storeFileDir,  $adminUser, $randStr;
    $cat = $category<>'all'? $category : '';
    
    $requestTime = date("d-m-Y H:i:s");
    $timer = microtime(true);
    
    $excel = Excel::create();
    
    $sheet1 = $excel->makeSheet('Expiring Today '.date("Y-m-d"));
    $respToday = $ad->getExpiringByDate(date("Y-m-d"), $cat);
    $colformat = [
        8=>"@text", 13=>'@date', 14=>'@datetime', 15=>'@datetime'
    ];
    makeExcelSheet($sheet1, $respToday, $colformat);
    
    $sheet2 = $excel->makeSheet('Expiring Today '.date("Y-m-d", strtotime("+1 days")));
    $respTomorrow = $ad->getExpiringByDate(date("Y-m-d", strtotime("+1 days")), $cat);
    makeExcelSheet($sheet2, $respTomorrow, $colformat);
    
    $sheet3 = $excel->makeSheet('Expiring in 10days ');
    $respIn10 = $ad->getExpiringInDays(10, $cat);
    makeExcelSheet($sheet3, $respIn10, $colformat);
    
    //remove sheet1
    $excel->removeSheet('Sheet1');
    
    //save Excel File
    $filename = $category."_ExpiringCustomers_".$adminUser."_".date('dmYHi');
    $outFileName = $outFileDir.  $randStr . "/" . $filename;
    $storename = $storeFileDir . $filename . ".xlsx";
    $excel->save($storename);
    
    //timer
    $time = round(microtime(true) - $timer, 3);
    $completeTiime = date("d-m-Y H:i:s");
    
    //send file download link in email
    sendMail("REPORT_MAIL", " $category Expiring Customers", $outFileName, $requestTime, $completeTiime, $time);
}

function expired($ad, $category) {
    global $db, $outFileDir, $storeFileDir,  $adminUser, $randStr;
    $cat = $category<>'all'? $category : '';
    
    $requestTime = date("d-m-Y H:i:s");
    $timer = microtime(true);
    
    $excel = Excel::create();
    
    $table = '__expiry1';
    $adb = new AdminDashboard($db); 
    if ($adb->__createTempExpiryTable($table)): 
        
        $sheet1 = $excel->makeSheet('Expired <= 30days as at '.date("Y-m-d")); 
        $respLTE30 = $ad->getExpiredCustomersFromTable($table, $cat, "0-30", 0, ''); 
        $colformat = [
            8=>"@text", 13=>'@date', 14=>'@datetime', 15=>'@datetime',
            17=>'#,##0', 18=>'#,##0.00'
        ];
        makeExcelSheet($sheet1, $respLTE30, $colformat);

        $sheet2 = $excel->makeSheet('Expired 31-89days as at '.date("Y-m-d"));
        $resp31To89 = $ad->getExpiredCustomersFromTable($table, $cat, "31-89", 0, '');
        makeExcelSheet($sheet2, $resp31To89, $colformat);
        
        $sheet3 = $excel->makeSheet('Churn (Expired>=90days) as at '.date("Y-m-d"));
        $respGTE90 = $ad->getExpiredCustomersFromTable($table, $cat, "Churn", 0, '');
        makeExcelSheet($sheet3, $respGTE90, $colformat);

        //remove sheet1
        $excel->removeSheet('Sheet1');

        //save Excel File
        $filename = $category."_ExpiredCustomers_".$adminUser."_".date('dmYHi');
        $outFileName = $outFileDir.  $randStr . "/" . $filename;
        $storename = $storeFileDir . $filename . ".xlsx";
        $excel->save($storename);
        
        $adb->__destroyTempTable($table);

        //timer
        $time = round(microtime(true) - $timer, 3);
        $completeTiime = date("d-m-Y H:i:s");

        //send file download link in email
        sendMail("REPORT_MAIL", " $category Expired Customers", $outFileName, $requestTime, $completeTiime, $time);
        
    endif;
    
    
}


function freeCust($ad, $category) {
    global $db, $outFileDir, $storeFileDir,  $adminUser, $randStr;
    $cat = $category<>'all'? $category : '';
    
    $requestTime = date("d-m-Y H:i:s");
    $timer = microtime(true);
    
    $excel = Excel::create();
    $sheets = 0;
    $table = '__expiry2';
    $adb = new AdminDashboard($db);  
    if ($adb->__createTempExpiryTable($table)): 
        
        $acolformat = [ 8=>"@text",
            13=>'@datetime', 14=>'@datetime', 15=>'@datetime'
        ]; 
        $ecolformat = [
            8=>"@text", 13=>'@date', 14=>'@datetime', 15=>'@datetime',
            17=>'#,##0', 18=>'#,##0.00'
        ];
        
        $respActiveStaff = $ad->getActiveCustomers($cat, 1, 'S'); 
        if (count($respActiveStaff)): ++$sheets; 
            $sheet1 = $excel->makeSheet('Active Staff Acc as at '.date("Y-m-d")); 
            makeExcelSheet($sheet1, $respActiveStaff, $acolformat); 
        endif;

        $respExpiredStaff = $ad->getExpiredCustomersFromTable($table, $cat, "", 1, 'S'); 
        if (count($respExpiredStaff)): ++$sheets;
            $sheet2 = $excel->makeSheet('Expired Staff Acc as at '.date("Y-m-d")); 
            makeExcelSheet($sheet2, $respExpiredStaff, $ecolformat); 
        endif;
        
        $respActiveFnF = $ad->getActiveCustomers($cat, 1, 'C'); 
        if (count($respActiveFnF)): ++$sheets;
            $sheet3 = $excel->makeSheet('Active FnF Acc as at '.date("Y-m-d")); 
            makeExcelSheet($sheet3, $respActiveFnF, $acolformat); 
        endif;

        $respExpiredFnF = $ad->getExpiredCustomersFromTable($table, $cat, "", 1, 'C'); 
        if (count($respExpiredFnF)): ++$sheets;
            $sheet4 = $excel->makeSheet('Expired Fnf Acc as at '.date("Y-m-d")); 
            makeExcelSheet($sheet4, $respExpiredFnF, $ecolformat); 
        endif;

        //remove sheet1
        if ($sheets) { $excel->removeSheet('Sheet1'); }

        //save Excel File
        $filename = $category."_ComplimentaryAcc_".$adminUser."_".date('dmYHi');
        $outFileName = $outFileDir.  $randStr . "/" . $filename;
        $storename = $storeFileDir . $filename . ".xlsx";
        $excel->save($storename);
        
        $adb->__destroyTempTable($table);

        //timer
        $time = round(microtime(true) - $timer, 3);
        $completeTiime = date("d-m-Y H:i:s");

        //send file download link in email
        sendMail("REPORT_MAIL", " $category Complimentary Account", $outFileName, $requestTime, $completeTiime, $time);
        
    endif;
    
    
}