<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {$a["error"]="Nothing to view here"; die(json_encode(a)); /*die('This file cannot be accessed directly!');*/ }
   
extract($_POST);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);

$raduser = $user = strtolower($clientId);

//$userRec = $ad->loadClientRec($raduser);
//$ret[$row->USERNAME] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
//                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
//                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
//                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
//                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID);

$profile = $ad->loadUserProfile($raduser);
//ru.username, enableuser, firstname, lastname, email,
//                    company, mobile, expiration, ru.srvid, rs.srvname, address, city, state
$found = 0; 
$userRecord = [];
if ($profile <> ""){
    $found = 1;
    $userRecord = (array)$profile;
    $userRecord["expiry_formatted"] = date("d-M-Y H:i:s", strtotime($profile->expiration));
}
//foreach ($userRec as $u => $rec) {
//    if (strtolower($u) == strtolower($user)){
//        $found = 1;
//        $userRecord = $rec;
//        break;
//    }
//}
if (!$found) {
    echo json_encode(["STATUS"=>0, "MSG"=>"Invalid ID, kindly check and try again later"]);
    exit();
}
// check if active
$isactive = $ad->isActiveAccount($raduser);
if (!$isactive) {
    echo json_encode(["STATUS"=>0, "MSG"=>"Account is not currently active and cannot change plan at the moment. Please contact Support (csc@fob.ng) if you need assistance!"]);
    exit();
}

//check if exhausted benefit from PROMO already
$hasExhaustedBenefit = $ad->hasExhaustedBenefitFromPromo($user, "1FOR2UPGRADE", 1);
if ($hasExhaustedBenefit) {
    echo json_encode(["STATUS"=>0, "MSG"=>"This account is no longer eligible for this promo because it has exhausted its promo slot. If this is incorrect, kindly contact Support (csc@fob.ng)!"]);
    exit();
}

$plans = $ad->loadPlansByHierarchy($profile->srvid, 1);
$hasPlans = (count($plans))? 1: 0;
if (!$hasPlans) :
    echo json_encode(["STATUS"=>0, "MSG"=>"Your plan cannot be upgraded at the moment because there is no higher plan in your plan category.<br/> For further assistance, kindly contact the support team"]);
    exit();
endif;
echo json_encode(["STATUS"=>1, "MSG"=>"User exist and is qualified<br/><strong>USERNAME:</strong>$user<br/><strong>NAME:</strong>{$profile->firstname} {$profile->lastname}<br/><strong>PLAN:</strong>{$profile->srvname}", 
    "PROFILE"=>$userRecord, "PLANS"=>json_encode($plans)]);