<?php
header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {$a["error"]="Nothing to view here"; die(json_encode(a)); /*die('This file cannot be accessed directly!');*/ }
   
extract($_POST);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);

//check if exhausted benefit from PROMO already
$hasExhaustedBenefit = $ad->hasExhaustedBenefitFromPromo($raduser, "1FOR2UPGRADE", 1);
if ($hasExhaustedBenefit) {
    echo json_encode(["STATUS"=>0, "MSG"=>"This account is no longer eligible for this promo because it has exhausted its promo slot. If this is incorrect, kindly contact Support (csc@fob.ng)!"]);
    exit();
}

//check amount is correct
$plann = $ad->loadPlanFromName($srvname);
if ( (($plann['AMOUNT']*$nmonths) <> $amount_due) || ($nmonths < 2) || ($use_promo <> '1FOR2UPGRADE') ) {
    echo json_encode(["STATUS"=>0, "MSG"=>"Error: Invalid data"]);
    exit();
}

$nmonths += 1;

$expiry = $ad->getExpirationDate($raduser);
$reqid = $ad->initPlanUpgrade($raduser, $cur_plan_id, $srvid, $cur_plan, $srvname);
if ($reqid) {
    //successful, create transaction
    $codeg = new Password_Generator();
    $txn_id = "PAYS-PCQ-$raduser-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);

    $saveRet = $ad->saveInitTranx($txn_id, $raduser, $expiry, $amount_due, CURRENCY, $nmonths, $plan_id, 0, 1, $use_promo);
    while (!$saveRet):
        $txn_id = "PAYS-PCQ-$raduser-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);
        $saveRet = $ad->saveInitTranx($txn_id, $raduser, $expiry, $amount_due, CURRENCY, 1, $plan_id, 0, 1, $use_promo);
    endwhile;
    if ($saveRet) :
        $ret = $ad->addTranxToPlanUpgrade($reqid, $txn_id);
    endif;
    if ($saveRet && $ret){
        echo json_encode(["STATUS"=>1, "MSG"=>"Success: Initialization completed", 
            "TRANX_ID"=>$txn_id ]);
    	exit();
    }
} 
    // failed
    echo json_encode(["STATUS"=>0, "MSG"=>"Error: Initialization failed"]);
