<?php
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   
extract($_POST);

if ($uname != $_SESSION[$sid.'username']) :
    echo "Error: Request Validation Failed";
    exit();
endif;

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);

$user = filter_var($uname, FILTER_SANITIZE_STRING);
$email = filter_var($email, FILTER_SANITIZE_STRING);
$phone = filter_var($phone, FILTER_SANITIZE_STRING);
$old_addy = filter_var($curAddy, FILTER_SANITIZE_STRING);
$new_addy = filter_var($newAddy, FILTER_SANITIZE_STRING);

$reloc = $ad->createRelocationRequest($user, $phone, $email, $old_addy, $new_addy);

if (isset($reloc)) {
    $raw_msg = "Dear Esteemed Customer,

    Thank you for reaching out to us at FiberOne Broadband.

    Please be informed that your request has been received for processing and as such you will be contacted by one of our Customer Experience team shortly.

    Thank you for choosing FiberOne Broadband.";

    $ad->sendEmail($email, ADMIN_RELOC_EMAIL, "Relocation Request on FiberOne Online (Web)", $raw_msg);

    $raw_msg = "Dear Team,
    There is a new relocation Request from $user as found below; 

    <strong>User:</strong> $user   
    <strong>Email:</strong> $email   
    <strong>Phone:</strong> $phone   
    <strong>Old Address:</strong> $old_addy   
    <strong>New Address:</strong> $new_addy 

    Thank you.
     ";
            /* EMAIL_SENDER */ 
    $ad->sendEmail(ADMIN_RELOC_EMAIL, $email, "Relocation Request on FiberOne Online (Web) - $user", $raw_msg);
    echo "Success: Request Submitted. Our customer experience team will be in touch shortly.";
} else {
    echo "Error: An error was encountered.";
} 