<?php

//header('Content-type: application/json');

include_once "../includes/opener.php";
include_once "../includes/db.inc";

if (!( isset( $_SERVER['HTTP_X_REQUESTED_WITH'] ) && ( $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest' ) ))
   {die('This file cannot be accessed directly!'); }
   extract($_POST);

$relocId = $_POST['relocId'] * 1;

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db); 

$response = $ad->getRelocationStatusUpdate($relocId); 

$bg = [
    "bg-info", "bg-danger", "bg-warning", "bg-secondary", "bg-success", "bg-primary",
    "bg-info", "bg-danger", "bg-warning", "bg-secondary", "bg-success", "bg-primary",
    "bg-info", "bg-danger", "bg-warning", "bg-secondary", "bg-success", "bg-primary",
    "bg-info", "bg-danger", "bg-warning", "bg-secondary", "bg-success", "bg-primary"
];
$ico = [
    "Planning and Design"=> "fa fa-address-card", "others"=>"fa fa-archive", 
    "Completed"=> "fa fa-anchor", "Onboarding Assignment"=>"fa fa-asterisk", 
    "Service Delivery"=> "fa fa-automobile", "Account"=>"fa fa-bank", 
    "CNP QA"=>"fa fa-question", "Onboarding Confirmation"=>"fa fa-phone"
];
$counter = 0;
?>
<div class="timeline-centered">

<?PHP
//echo json_encode($response);
    foreach ($response['aaData'] as $i => $log) {
       $align = ($i == 0 || ($i % 2) == 0)? "left-aligned" : "";
       $time = date("h:ia", strtotime($log["STATUS_DATE"]));
?>
    
    <article class="timeline-entry <?PHP echo $align; ?>">

        <div class="timeline-entry-inner">
            <time class="timeline-time" datetime="<?PHP echo $log["STATUS_DATE"]; ?>">
                <span><?PHP echo $time; ?></span> 
                <span><?PHP echo getDateTimeDifferenceString($log["STATUS_DATE"]); ?></span>
            </time>

            <div class="timeline-icon <?PHP echo $bg[$i]; ?>">
                <i class="<?PHP echo isset($ico[$log["STATUS"]])? $ico[$log["STATUS"]] : $ico["others"]; ?>"></i>
            </div>

            <div class="timeline-label">
                <h2><a href="#"><?PHP echo $log["STATUS"]; ?></a> <span>by <?PHP echo $log["CHANGED_BY"]; ?></span></h2>
                <p><?PHP echo $log["STATUS_LOG"]; ?></p>
            </div>
        </div>

    </article>
    
<?PHP
    }
?>
    
    <article class="timeline-entry begin">

        <div class="timeline-entry-inner">

            <div class="timeline-icon" style="-webkit-transform: rotate(-90deg); -moz-transform: rotate(-90deg);">
                <i class="entypo-flight"></i>
            </div>

        </div>

    </article>

</div>
