<?php
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

if (!(isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest'))) {
    die('Requested file does not exist!');
}
header('Content-Type: application/json');
$tracking_id = $_POST['tracking_id'] ?? null;
if (empty($tracking_id)) {
    echo json_encode([
        'error' => true,
        'message' => 'Missing tracking_id parameter.'
    ]);
    exit;
}

if (!preg_match('/^SO-\d{8}-\d{6}-\d{4}$/', $tracking_id)) {
    echo json_encode([
        'error' => true,
        'message' => 'Invalid tracking ID format.'
    ]);
    exit;
}
$installDate = $_POST['installDate'] ?? null;

// Accept both date and datetime formats
$d = DateTime::createFromFormat('Y-m-d H:i:s', $installDate);
if (!$d) {
    // Fallback to date-only format for backward compatibility
    $d = DateTime::createFromFormat('Y-m-d', $installDate);
}

if (!$d) {
    echo json_encode(['success' => false, 'message' => 'Invalid installation date format. Expected Y-m-d or Y-m-d H:i:s']);
    exit;
}

// Validate date is not in the past
$today = new DateTime();
$today->setTime(0, 0, 0);
if ($d < $today) {
    echo json_encode(['success' => false, 'message' => 'Installation date must be in the future']);
    exit;
}
//echo json_encode($data);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
//$order = $dashboard->getCustomerByTrackingId($tracking_id);
$success = $dashboard->updateAppointmentDate($tracking_id, $installDate);

// 4️⃣ Return JSON response
if ($success) {
    echo json_encode(['success' => true, 'message' => 'Installation date updated successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to update installation date']);
}
