<?php
$page = "Admin Products Dashboard";
$page_url = "all_products";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'dasha';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);

$allproducts = $dashboard->getAllProducts();
$overview = $dashboard->getAdminDashboardOverview();
$mydash = array_keys($ad->adminDashList($_SESSION[$sid . 'userid']));
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));

// Handle AJAX status update for unrestrict
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_status'])) {
    header('Content-Type: application/json');
    $productId = $_POST['product_id'];
    $newStatus = $_POST['new_status'];
    $updated = $dashboard->updateProductStatus($productId, $newStatus); // Assumed method
    if ($updated) {
        echo json_encode(['success' => true, 'message' => "Product status updated to $newStatus."]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update status.']);
    }
    exit();
}
?>

<style>
    .main-content {
        margin-left: 230px;
        min-height: 100vh;
        background: white;
    }

    .top-bar {
        background: white;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .content-area {
        padding: 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb span {
        color: #6c757d;
        margin: 0 8px;
    }

    .search-filter-bar {
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        margin-bottom: 20px;
        justify-content: space-between;
        align-items: center;
    }

    .search-input {
        flex: 1;
        max-width: 300px;
        position: relative;
    }

    .search-input input {
        width: 100%;
        padding: 8px 40px 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .search-input i {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
    }

    .button-filters {
        display: flex;
        gap: 20px;
    }

    .filter-btn,
    .export-btn {
        padding: 8px 16px;
        border: 1px solid #ddd;
        background: white;
        border-radius: 4px;
        font-size: 14px;
        color: #333;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.3s ease;
    }

    .filter-btn:hover,
    .export-btn:hover {
        background: #f8f9fa;
    }

    .products-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .products-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
    }

    .products-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .products-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .filter-tabs {
        padding: 0 16px;
        background-color: #f1f5f9;
        width: fit-content;
        border-radius: 6px;
        margin-bottom: 16px;
    }

    .filter-tabs ul {
        list-style: none;
        padding: 6px 0;
        margin: 0;
        display: flex;
    }

    .filter-tabs li {
        margin-right: 30px;
    }

    .filter-tabs a {
        display: block;
        border-radius: 6px;
        padding: 8px;
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .filter-tabs a.active {
        background-color: #fff;
    }

    .filter-tabs a:hover {
        text-decoration: none;
        background: #e9ecef;
    }

    .table-container {
        overflow-x: auto;
    }

    .products-table {
        width: 100%;
        margin: 0;
        border-collapse: collapse;
    }

    .products-table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .products-table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
        text-align: left;
    }

    .products-table tbody tr {
        border-bottom: 1px solid #f8f9fa;
        transition: background 0.3s ease;
    }

    .products-table tbody tr:hover {
        background: #f8f9fa;
    }

    .products-table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        font-size: 14px;
    }

    .product-info {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .product-checkbox {
        margin-right: 30px;
    }

    .product-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: #0d3e9b;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
        margin-right: 15px;
    }

    .product-details h6 {
        margin: 0;
        color: #333;
        font-weight: 500;
        font-size: 14px;
    }

    .product-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .status-badge {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 500;
        display: inline-block;
    }

    .status-active {
        background: #0d3e9b;
        color: white;
    }

    .status-pending {
        background: #ffc107;
        color: white;
    }

    .status-restricted {
        background: #dc3545;
        color: white;
    }

    .status-declined {
        background: #6c757d;
        color: white;
    }

    .product-name {
        color: #333;
        font-size: 14px;
    }

    .product-email {
        color: #6c757d;
        font-size: 14px;
    }

    .product-price {
        color: #6c757d;
        font-size: 14px;
    }

    .product-date {
        color: #6c757d;
        font-size: 14px;
    }

    .actions-btn,
    .view-btn {
        background: none;
        border: none;
        color: #6c757d;
        padding: 5px;
        cursor: pointer;
        border-radius: 4px;
        transition: background 0.3s ease;
    }

    .actions-btn:hover,
    .view-btn:hover {
        background: #f8f9fa;
    }

    .pagination-container {
        padding: 20px 25px;
        border-top: 1px solid #f8f9fa;
        display: flex;
        justify-content: flex-end;
        align-items: center;
        gap: 20px;
    }

    .pagination-info {
        color: #6c757d;
        font-size: 14px;
    }

    .pagination-controls {
        display: flex;
        gap: 8px;
        align-items: center;
    }

    .pagination-btn {
        padding: 5px 10px;
        border: 1px solid #ddd;
        background: white;
        border-radius: 4px;
        cursor: pointer;
        transition: all 0.3s ease;
        color: #6c757d;
    }

    .pagination-btn:hover {
        background: #f8f9fa;
    }

    .pagination-btn:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        border-radius: 8px;
        border: none;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }

    .modal-header {
        border-bottom: 1px solid #e9ecef;
        padding: 20px;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    .modal-body {
        padding: 20px;
    }

    .modal-body p {
        color: #666;
        margin-bottom: 20px;
        line-height: 1.5;
    }

    .modal-footer {
        border-top: 1px solid #e9ecef;
        padding: 15px 20px;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .btn-primary {
        background: #0d3e9b;
        border: 1px solid #0d3e9b;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
        font-size: 14px;
        cursor: pointer;
    }

    .btn-primary:hover {
        background: #0b3484;
        border-color: #0b3484;
    }

    .btn-secondary {
        background-color: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    .alert {
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-dismissible .close {
        position: absolute;
        top: 0;
        right: 10px;
        padding: 10px;
        color: inherit;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .top-bar {
            padding: 15px 20px;
        }

        .search-filter-bar {
            flex-direction: column;
            align-items: stretch;
            gap: 10px;
        }

        .search-input {
            max-width: none;
        }

        .pagination-container {
            flex-direction: column;
            gap: 10px;
            text-align: center;
        }

        .products-table th,
        .products-table td {
            padding: 10px;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Products</h1>
        <button class="btn btn-primary" onclick="addProduct()">
            <i class="fa fa-plus"></i> Add New Product
        </button>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span>></span>
            <span style="color: #333; font-weight: 500">Products</span>
        </nav>

        <!-- Search and Filter Bar -->
        <div class="search-filter-bar">
            <div class="search-input">
                <input type="text" placeholder="Search products" id="productSearch" />
                <i class="fa fa-search"></i>
            </div>
            <div class="button-filters">
                <button class="filter-btn" onclick="showFilters()">
                    <i class="fa fa-filter"></i> Filter
                </button>
                <button class="export-btn" onclick="exportProducts()">
                    <i class="fa fa-download"></i> Export
                </button>
            </div>
        </div>

        <!-- Filter Tabs -->
        <div class="filter-tabs">
            <ul>
                <li><a href="#" class="active" onclick="filterProducts('all')">All</a></li>
                <li><a href="#" onclick="filterProducts('active')">Active</a></li>
                <li><a href="#" onclick="filterProducts('pending')">Pending</a></li>
                <li><a href="#" onclick="filterProducts('declined')">Declined</a></li>
            </ul>
        </div>

        <!-- Products Section -->
        <div class="products-section">
            <div class="products-header">
                <div>
                    <h3 class="products-title">Products</h3>
                    <p class="products-subtitle">Manage products and view their information.</p>
                </div>
            </div>

            <!-- Products Table -->
            <div class="table-container">
                <table class="products-table">
                    <thead>
                        <tr>
                            <th>
                                <input type="checkbox" id="selectAll" onchange="toggleSelectAll()" />
                                <span style="margin-left: 10px">Vendor Name</span>
                            </th>
                            <th>Vendor Email</th>
                            <th>Product Name</th>
                            <th>Status</th>
                            <th>Selling Price</th>
                            <th>Date of Product Listing</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody id="productsTableBody">
                        <?php foreach ($allproducts as $product): ?>
                            <?php
                            $status = strtolower($product->status ?: 'pending');
                            $avatarInitials = strtoupper(substr($product->vendor_name, 0, 2));
                            ?>
                            <tr data-product-id="<?= $product->id ?>" data-status="<?= htmlspecialchars($status) ?>">
                                <td>
                                    <div class="product-info">
                                        <input type="checkbox" class="product-checkbox" />
                                        <div class="product-avatar"><?= htmlspecialchars($avatarInitials) ?></div>
                                        <div class="product-details">
                                            <h6><?= htmlspecialchars($product->vendor_name) ?></h6>
                                            <p><?= htmlspecialchars($product->vendor_email) ?></p>
                                        </div>
                                    </div>
                                </td>
                                <td><span class="product-email"><?= htmlspecialchars($product->vendor_email) ?></span></td>
                                <td><span class="product-name"><?= htmlspecialchars($product->name) ?></span></td>
                                <td>
                                    <span class="status-badge status-<?= $status ?>">
                                        <?= htmlspecialchars(ucfirst($product->status ?: 'Pending')) ?>
                                    </span>
                                </td>
                                <td><span
                                        class="product-price">₦<?= htmlspecialchars(number_format($product->price, 2)) ?></span>
                                </td>
                                <td><span
                                        class="product-date"><?= htmlspecialchars(date('Y-m-d h:i A', strtotime($product->created_at))) ?></span>
                                </td>
                                <td>

                                    <button class="view-btn" onclick="viewProduct(<?= $product->id ?>)">
                                        <i class="fa fa-eye"></i>
                                    </button>

                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="pagination-container">
                <div class="pagination-info">Page 1 of <?= ceil($overview['total_products'] / 10) ?></div>
                <div class="pagination-controls">
                    <button class="pagination-btn" onclick="goToPage('first')" disabled><i
                            class="fa fa-angle-double-left"></i></button>
                    <button class="pagination-btn" onclick="goToPage('prev')" disabled><i
                            class="fa fa-angle-left"></i></button>
                    <button class="pagination-btn" onclick="goToPage('next')"><i class="fa fa-angle-right"></i></button>
                    <button class="pagination-btn" onclick="goToPage('last')"><i
                            class="fa fa-angle-double-right"></i></button>
                </div>
            </div>
        </div>
    </div>
</div>



<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    let currentPage = 1;
    const totalPages = <?= ceil($overview['total_products'] / 10) ?>;

    // Navigation function
    function navigateTo(page) {
        window.location.href = page === 'dashboard' ? 'dasha' : page === 'all_products' ? 'all_products' : '#';
    }

    // Add product (placeholder)
    function addProduct() {
        alert("Add New Product - would open product registration form");
    }

    // View product details
    function viewProduct(productId) {
        window.location.href = `product_detail.php?id=${encodeURIComponent(btoa(productId))}`;
    }

    // Show unrestrict modal
    function showUnrestrictModal(productId, productName) {
        document.getElementById('unrestrictMessage').innerHTML = `Are you sure you want to unrestrict ${productName}? This will restore its visibility on the Marketplace.`;
        document.getElementById('confirmUnrestrictBtn').dataset.productId = productId;
        $('#unrestrictModal').modal('show');
    }

    // Hide unrestrict modal
    function hideUnrestrictModal() {
        $('#unrestrictModal').modal('hide');
    }


    // Filter products by status
    function filterProducts(status) {
        document.querySelectorAll('.filter-tabs a').forEach(tab => {
            tab.classList.remove('active');
        });
        event.target.classList.add('active');

        const rows = document.querySelectorAll('#productsTableBody tr');
        rows.forEach(row => {
            const rowStatus = row.dataset.status;
            row.style.display = (status === 'all' || rowStatus === status) ? '' : 'none';
        });
    }

    // Search functionality
    document.getElementById('productSearch').addEventListener('input', function () {
        const searchTerm = this.value.toLowerCase();
        const rows = document.querySelectorAll('#productsTableBody tr');

        rows.forEach(row => {
            const vendorName = row.querySelector('.product-details h6').textContent.toLowerCase();
            const vendorEmail = row.querySelector('.product-email').textContent.toLowerCase();
            const productName = row.querySelector('.product-name').textContent.toLowerCase();
            const productPrice = row.querySelector('.product-price').textContent.toLowerCase();

            row.style.display = (vendorName.includes(searchTerm) ||
                vendorEmail.includes(searchTerm) ||
                productName.includes(searchTerm) ||
                productPrice.includes(searchTerm)) ? '' : 'none';
        });
    });

    // Toggle select all checkboxes
    function toggleSelectAll() {
        const selectAllCheckbox = document.getElementById('selectAll');
        const productCheckboxes = document.querySelectorAll('.product-checkbox');
        productCheckboxes.forEach(checkbox => {
            checkbox.checked = selectAllCheckbox.checked;
        });
    }

    // Show filters (placeholder)
    function showFilters() {
        alert('Show Filters - would open filter options modal');
    }

    // Export products
    function exportProducts() {
        const rows = document.querySelectorAll('#productsTableBody tr');
        let csvContent = 'Vendor Name,Vendor Email,Product Name,Status,Selling Price,Date of Product Listing\n';

        rows.forEach(row => {
            const vendorName = row.querySelector('.product-details h6').textContent;
            const vendorEmail = row.querySelector('.product-email').textContent;
            const productName = row.querySelector('.product-name').textContent;
            const status = row.querySelector('.status-badge').textContent;
            const price = row.querySelector('.product-price').textContent;
            const date = row.querySelector('.product-date').textContent;
            csvContent += `"${vendorName}","${vendorEmail}","${productName}","${status}","${price}","${date}"\n`;
        });

        const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
        const link = document.createElement('a');
        link.href = URL.createObjectURL(blob);
        link.download = 'products.csv';
        link.click();
    }

    // Pagination navigation
    function goToPage(direction) {
        if (direction === 'first') {
            currentPage = 1;
        } else if (direction === 'prev' && currentPage > 1) {
            currentPage--;
        } else if (direction === 'next' && currentPage < totalPages) {
            currentPage++;
        } else if (direction === 'last') {
            currentPage = totalPages;
        }

        // Update pagination info
        document.querySelector('.pagination-info').textContent = `Page ${currentPage} of ${totalPages}`;

        // Update button states
        document.querySelector('.pagination-btn[onclick="goToPage(\'first\')]').disabled = currentPage === 1;
        document.querySelector('.pagination-btn[onclick="goToPage(\'prev\')]').disabled = currentPage === 1;
        document.querySelector('.pagination-btn[onclick="goToPage(\'next\')]').disabled = currentPage === totalPages;
        document.querySelector('.pagination-btn[onclick="goToPage(\'last\')]').disabled = currentPage === totalPages;

        // Fetch new page data (placeholder)
        alert(`Navigate to page ${currentPage}`);
        // In a real app, fetch new product data via AJAX
    }



    // Initialize page
    document.addEventListener('DOMContentLoaded', function () {
        console.log('Products Dashboard initialized');
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        }
    });

    // Handle responsive behavior
    window.addEventListener('resize', function () {
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        } else {
            document.body.classList.remove('mobile-view');
        }
    });

    // Initialize Bootstrap tooltips
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>