<?PHP
$page = "Analytics";
$page_url = "analytics";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';


if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'marketdash';
    </script>
    <?PHP
    exit();
endif;


$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
//$locations = $dashboard->getLocations();
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);

$vendor_check = $dashboard->getDashboardByGlobalId($_SESSION[$sid . 'userid']);

if ($vendor_id !== null) {
    $vendorOrders = $dashboard->getVendorOrders($vendor_id);
    //    $vendorId = $vendor_check['vendor_id'];
    //    $lastSales = $dashboard->getLast10FulfilledSales($vendorId);
    //  $lastSales = $dashboard->getLast10FulfilledSales($vendorId);

    // Now $lastSales has the last 10 fulfilled orders for that vendor
}
//$mmdat = $ad->getTransactions("", 0, 20);
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//$plan_sales = $dashboard->salesByLocation($startDate, $endDate);

?>

<style>
    /* Main Content */
    .main-content {
        margin-left: 230px;
        min-height: 100vh;
    }

    .top-bar {
        background: white;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }


    .content-nav {
        margin-bottom: 4px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        /* background: white; */
        border-radius: 8px;
        padding: 25px;
        /* box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1); */
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }


    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .content-area {
        padding: 30px;
        background: white;
    }

    /* Breadcrumb */
    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 25px;
        font-size: 14px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
    }

    .breadcrumb a:hover {
        color: #0d3e9b;
    }

    /* Analytics Section */
    .analytics-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
        padding: 25px;
    }

    .analytics-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 25px;
        flex-wrap: wrap;
        gap: 15px;
    }

    .analytics-controls {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .select-wrapper {
        position: relative;
    }

    .custom-select {
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
        background: white;
        border: 1px solid #e9ecef;
        padding: 8px 35px 8px 12px;
        border-radius: 6px;
        font-size: 14px;
        color: #333;
        min-width: 120px;
        cursor: pointer;
    }

    .select-wrapper::after {
        content: "\f107";
        font-family: FontAwesome;
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
        pointer-events: none;
    }

    .date-picker {
        display: flex;
        align-items: center;
        gap: 8px;
        background: white;
        border: 1px solid #e9ecef;
        padding: 8px 12px;
        border-radius: 6px;
        font-size: 14px;
        color: #333;
        cursor: pointer;
    }

    /* Chart Container */
    .chart-container {
        position: relative;
        height: 400px;
        width: 100%;
    }

    #analyticsChart {
        width: 100%;
        height: 100%;
    }

    /* User Dropdown */
    .user-dropdown {
        position: absolute;
        bottom: 20px;
        left: 20px;
        right: 20px;
    }

    .user-info {
        display: flex;
        align-items: center;
        padding: 10px;
        background: #f8f9fa;
        border-radius: 6px;
        cursor: pointer;
        transition: background 0.3s ease;
    }

    .user-info:hover {
        background: #e9ecef;
    }

    .user-avatar {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        background: #0d3e9b;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 12px;
        margin-right: 10px;
    }

    .user-name {
        color: #333;
        font-size: 14px;
        font-weight: 500;
        flex: 1;
    }

    .dropdown-arrow {
        color: #6c757d;
    }

    /* Responsive */
    @media (max-width: 768px) {

        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 15px;
        }

        .analytics-header {
            flex-direction: column;
            align-items: stretch;
        }

        .analytics-controls {
            flex-direction: column;
        }

        .custom-select,
        .date-picker {
            width: 100%;
        }
    }
</style>

<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Analytics</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <?php if ($vendor_check === null): ?>
            <div
                style="padding: 20px; border: 1px solid #f44336; background-color: #ffebee; color: #b71c1c; border-radius: 8px; text-align: center;">
                <h2>Vendor Account Not Available</h2>
                <p>You need to create a vendor account to access this dashboard.</p>
                <a href="/eservice/add_vendor"
                    style="display: inline-block; padding: 10px 20px; background-color: #1976d2; color: white; text-decoration: none; border-radius: 4px; font-weight: bold;">
                    Create Vendor Account
                </a>
            </div>
        <?php else: ?>
            <!-- Breadcrumb -->
            <nav class="breadcrumb">
                <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
                <span style="color: #6c757d; margin: 0 8px">></span>
                <span style="color: #333">Analytics</span>
            </nav>

            <!-- Stats Row -->
            <div class="row stats-row">
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Revenue</div>
                            <div class="stat-icon">
                                <i class="fa fa-dollar"></i>
                            </div>
                        </div>
                        <div class="stat-value">₦45,231.89</div>
                        <div class="stat-label">Sum of all sales transactions</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Calculated Profit</div>
                            <div class="stat-icon">
                                <i class="fa fa-line-chart"></i>
                            </div>
                        </div>
                        <div class="stat-value">₦5,231.89</div>
                        <div class="stat-label">Sum of profits made on products</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-card">
                        <div class="stat-header">
                            <div>Sales</div>
                            <div class="stat-icon">
                                <i class="fa fa-shopping-cart"></i>
                            </div>
                        </div>
                        <div class="stat-value">2350</div>
                        <div class="stat-label">Total number of products sold</div>
                    </div>
                </div>
            </div>

            <!-- Analytics Section -->
            <div class="analytics-section">
                <div class="analytics-header">
                    <div class="analytics-controls">
                        <div class="select-wrapper">
                            <select class="custom-select" id="salesFilter">
                                <option>All sales</option>
                                <option>Successful</option>
                                <option>Pending</option>
                                <option>Refunded</option>
                            </select>
                        </div>
                        <div class="select-wrapper">
                            <select class="custom-select" id="productFilter">
                                <option>All products</option>
                                <option>Laser Lemonade Machine</option>
                                <option>Gaming Controller Pro</option>
                                <option>Wireless Headphones</option>
                                <option>Smart Watch Series</option>
                            </select>
                        </div>
                    </div>
                    <div class="date-picker" onclick="showDatePicker()">
                        <i class="fa fa-calendar"></i>
                        <span>Choose a Date</span>
                    </div>
                </div>

                <div class="chart-container">
                    <canvas id="analyticsChart"></canvas>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>


<?PHP include_once 'includes/footer.php'; ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>
<script>
    let chart;

    // Chart data
    const chartData = {
        labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun"],
        datasets: [
            {
                data: [35000, 45000, 52000, 38000, 28000, 48000],
                borderColor: "#4285f4",
                backgroundColor: "transparent",
                borderWidth: 3,
                pointBackgroundColor: "#4285f4",
                pointBorderColor: "#ffffff",
                pointBorderWidth: 2,
                pointRadius: 6,
                pointHoverRadius: 8,
                tension: 0.4,
            },
        ],
    };

    // Initialize chart
    function initChart() {
        const ctx = document.getElementById("analyticsChart").getContext("2d");

        chart = new Chart(ctx, {
            type: "line",
            data: chartData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false,
                    },
                    tooltip: {
                        backgroundColor: "#333",
                        titleColor: "#fff",
                        bodyColor: "#fff",
                        borderColor: "#4285f4",
                        borderWidth: 1,
                        cornerRadius: 8,
                        displayColors: false,
                        callbacks: {
                            label: function (context) {
                                return "₦" + context.parsed.y.toLocaleString();
                            },
                        },
                    },
                },
                scales: {
                    x: {
                        grid: {
                            display: false,
                        },
                        border: {
                            display: false,
                        },
                        ticks: {
                            color: "#6c757d",
                            font: {
                                size: 12,
                            },
                        },
                    },
                    y: {
                        display: false,
                        grid: {
                            display: false,
                        },
                        border: {
                            display: false,
                        },
                    },
                },
                elements: {
                    point: {
                        hoverBackgroundColor: "#4285f4",
                    },
                },
                interaction: {
                    intersect: false,
                    mode: "index",
                },
            },
        });

        // Add special red point for March
        setTimeout(() => {
            if (chart && chart.data.datasets[0]) {
                chart.data.datasets[0].pointBackgroundColor = [
                    "#4285f4",
                    "#4285f4",
                    "#dc3545",
                    "#4285f4",
                    "#4285f4",
                    "#4285f4",
                ];
                chart.update();
            }
        }, 100);
    }

    // Navigation
    function navigateTo(page) {
        $(".nav-sidebar a").removeClass("active");
        $(event.target).closest("a").addClass("active");
        $(".page-title").text(page.charAt(0).toUpperCase() + page.slice(1));
        if (page !== "analytics") {
            alert(`Navigate to ${page} - This would show ${page} content`);
        }
    }

    // Date picker
    function showDatePicker() {
        alert("Date picker would open here");
    }

    // User dropdown toggle
    function toggleUserDropdown() {
        const dropdownMenu = `
          <div style="background: white; margin-top: 5px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); position: absolute; width: calc(100% - 40px); left: 20px;">
            <div style="padding: 10px; cursor: pointer; color: #333;" onclick="alert('Profile settings would open')">Profile</div>
            <div style="padding: 10px; cursor: pointer; color: #333;" onclick="alert('Logging out...')">Logout</div>
          </div>`;
        const existingMenu = $(".user-dropdown").find(
            'div[style*="box-shadow"]'
        );
        if (existingMenu.length) {
            existingMenu.remove();
        } else {
            $(".user-dropdown").append(dropdownMenu);
        }
    }

    // Filter change handlers
    $("#salesFilter, #productFilter").change(function () {
        const salesFilter = $("#salesFilter").val();
        const productFilter = $("#productFilter").val();

        // Update chart data based on filters
        let newData = [35000, 45000, 52000, 38000, 28000, 48000];

        if (salesFilter === "Successful") {
            newData = [40000, 50000, 55000, 42000, 32000, 52000];
        } else if (salesFilter === "Pending") {
            newData = [15000, 20000, 25000, 18000, 12000, 22000];
        } else if (salesFilter === "Refunded") {
            newData = [5000, 8000, 12000, 6000, 4000, 9000];
        }

        if (productFilter !== "All products") {
            // Adjust data for specific products
            newData = newData.map((val) => val * 0.3);
        }

        chart.data.datasets[0].data = newData;
        chart.update();
    });

    // Initialize when document is ready
    $(document).ready(function () {
        initChart();
    });

    // Handle window resize
    $(window).resize(function () {
        if (chart) {
            chart.resize();
        }
    });
</script>