<?php
// error_reporting(E_ALL);
// set_error_handler(function ($severity, $message, $file, $line) {
//     if (error_reporting() & $severity) {
//         throw new \ErrorException($message, 0, $severity, $file, $line);
//     }
// });
date_default_timezone_set("Africa/Lagos");
set_time_limit(0);

if (PHP_SAPI == 'cli-server') {
    // To help the built-in PHP dev server, check if the request was actually for
    // something which should probably be served as a static file
    $url  = parse_url($_SERVER['REQUEST_URI']);
    $file = __DIR__ . $url['path'];
    if (is_file($file)) {
        return false;
    }
}

require __DIR__ . '/../vendor/autoload.php';

require __DIR__ . '/../../classes/mysqli_ext.php';
require __DIR__ . '/../../classes/UserProfile.php';
// require __DIR__ . '/../../classes/Password_Generator.php';
require __DIR__ . '/../../classes/Tickets.php';
require __DIR__ . '/../../classes/ImageResize.php';
require __DIR__ . '/../../classes/ImageResizeException.php';
//require __DIR__ . '/../../classes/common_functions.php';
require __DIR__ . '/config.php';

session_start();

// Instantiate the app
$settings = require __DIR__ . '/../src/settings.php';
$app = new \Slim\App($settings);

//Instantiate Important Classes
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database); //print_r($db);
$db->set_charset("utf8");

$ad = new UserProfile($db);

//Confirm
$_SESSION = array();

// Set up dependencies
require __DIR__ . '/../src/dependencies.php';

// Register middleware
require __DIR__ . '/../src/middleware.php';

// Register routes
require __DIR__ . '/../src/routes.php';

// Run app
$app->run();