<?php

use Slim\Http\Request;
use Slim\Http\Response;
use \Firebase\JWT\JWT;

// Routes

//$app->get('/[{name}]', function (Request $request, Response $response, array $args) {
//    // Sample log message
//    $this->logger->info("Slim-Skeleton '/' route");
//
//    // Render index view
//    return $this->renderer->render($response, 'index.phtml', $args);
//});
//
$app->get('/hello/{name}', function ($request, $response, $args) {
   return $response->write("Hello " . $args['name'] . "\n");
});

// $app->get('/erpgen', function ($request, $response, $args) {
  
//    $settings = $this->get('settings'); // get settings array.
   
//    $token = JWT::encode(['id' => "erp", 'entry' => "webservice!23*#*"], $settings['jwt']['secret'], "HS512");

//    return $this->response->withJson(['token' => $token]);
// });


$app->group('/bitrix', function(\Slim\App $app) { 
	

    $app->post('/createOutageTicket',function(Request $request, Response $response, array $args) {
        global $ad;
    	$tok = $request->getAttribute('decoded_token_data');
    	$data = $request->getParsedBody();
    	$logda = "'".json_encode($data)."','".date("Y-m-d H:i:s")."', 'OUTAGE_UPDATE'"; $ff = "DATA, DATESENT, DATAORIGIN";
        $ad->insertLog($ff, $logda, "tbl_bitrix_log");
    	// if (json_decode($tok, TRUE) == $data) {
        if ($tok->id === 'bitrix' && $tok->entry === "247webservice!23*#*") {
        	$ticketId = filter_var($data['ticketId'], FILTER_SANITIZE_STRING);
            $olt = filter_var($data['olt'], FILTER_SANITIZE_STRING);
            $gpon = filter_var($data['gpon'], FILTER_SANITIZE_STRING);
            $outageStartDate = filter_var($data['outageStartDate'], FILTER_SANITIZE_STRING);
            $expectedResolutionDate = filter_var($data['expectedResolutionDate'], FILTER_SANITIZE_STRING);
            $ticketStatus = filter_var($data['ticketStatus'], FILTER_SANITIZE_STRING);
            $summary = filter_var($data['summary'], FILTER_SANITIZE_STRING);
            $createdBy = filter_var($data['createdBy'], FILTER_SANITIZE_STRING);
            $creationDate = filter_var($data['creationDate'], FILTER_SANITIZE_STRING);
        
        	$create = $ad->createOutageTicket($ticketId, $olt, $gpon, $outageStartDate, $expectedResolutionDate, 
                                              $ticketStatus, $summary, $createdBy, $creationDate);
        	if ($create) :
            	return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Outage Ticket Created Successfully!"]));
            else: 
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Process Failed"]));
           	endif;
        } else {
        	return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while creating Ticket. Unverfiable Transaction"]));
        }
    	
    });

    $app->put('/updateOutageTicket/{ticketId}',function(Request $request, Response $response, array $args) {
        global $ad;
    	$tok = $request->getAttribute('decoded_token_data');
    	$data = $request->getParsedBody();
    	$logda = "'".json_encode($data)."','".date("Y-m-d H:i:s")."', 'OUTAGE_UPDATE'"; $ff = "DATA, DATESENT, DATAORIGIN";
        $ad->insertLog($ff, $logda, "tbl_bitrix_log");
    	// if (json_decode($tok, TRUE) == $data) {
        if ($tok->id === 'bitrix' && $tok->entry === "247webservice!23*#*") {
        	$ticketId = (string)$args['ticketId']; // filter_var($data['ticketId'], FILTER_SANITIZE_STRING);
            $ticketStatus = filter_var($data['ticketStatus'], FILTER_SANITIZE_STRING);
            $updatedBy = filter_var($data['updatedBy'], FILTER_SANITIZE_STRING);
            $completed = filter_var($data['completed'], FILTER_SANITIZE_STRING);
        
        	$update = $ad->updateOutageTicket($ticketId, $ticketStatus, $updatedBy, $completed);
        	if ($update) :
            	return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Outage Ticket Updated Successfully!"]));
            else: 
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Process Failed"]));
           	endif;
        } else {
        	return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while creating Ticket. Unverfiable Transaction"]));
        }
    	
    });
    
    
    $app->post('/accinit',function(Request $request, Response $response, array $args) {
        global $ad;
        try { 
        $tok = $request->getAttribute('decoded_token_data');
        $data = $request->getParsedBody();
        $ff = "DATA, DATESENT, DATAORIGIN";
        	
        $bitrixid = filter_var($data['bitrixid'], FILTER_SANITIZE_NUMBER_INT);
        $orderno = filter_var($data['orderno'], FILTER_SANITIZE_STRING);
        $logda = "'".base64_encode(json_encode($data))."|$bitrixid|$orderno','".date("Y-m-d H:i:s")."', 'BITRIX_ACCINIT'"; 
        $ad->insertLog($ff, $logda, "tbl_erpinvoice_data_encrypt");
        $logda = "'".str_replace("'", "\'", json_encode($data))."','".date("Y-m-d H:i:s")."', 'BITRIX_ACCINIT'"; 
        $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
            
            
        if ($tok->id === 'bitrix' && $tok->entry === "247webservice!23*#*"):
//            $erpid = filter_var($data['erpid'], FILTER_SANITIZE_NUMBER_INT);
//            $order_erpid = filter_var($data['order_erpid'], FILTER_SANITIZE_NUMBER_INT);
            
//            $bitrixid = filter_var($data['bitrixid'], FILTER_SANITIZE_NUMBER_INT);
//            $bitrix_order_id = filter_var($data['bitrix_order_id'], FILTER_SANITIZE_NUMBER_INT);
            $firstname = filter_var($data['firstname'], FILTER_SANITIZE_STRING);
            $lastname = filter_var($data['lastname'], FILTER_SANITIZE_STRING);
            $username = strtolower(trim(filter_var($data['service_id'], FILTER_SANITIZE_STRING)));
            $company = filter_var($data['company'], FILTER_SANITIZE_STRING);
            $addy = filter_var($data['address'], FILTER_SANITIZE_STRING);
            $city = filter_var($data['city'], FILTER_SANITIZE_STRING);
            $state = filter_var($data['state'], FILTER_SANITIZE_STRING);
            $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
            $phone = filter_var($data['phone'], FILTER_SANITIZE_STRING);
//            $mobile = filter_var($data['mobile'], FILTER_SANITIZE_STRING);
            $pck = filter_var($data['pck'], FILTER_SANITIZE_STRING);
//            $ip = filter_var($data['ip'], FILTER_SANITIZE_STRING);
//            $orderno = filter_var($data['orderno'], FILTER_SANITIZE_STRING);
            $salesperson = filter_var($data['salesperson'], FILTER_SANITIZE_STRING);
            $salesemail = filter_var($data['salesemail'], FILTER_SANITIZE_STRING);
            $orderdate = date("Y-m-d H:i:s", strtotime(filter_var($data['orderdate'], FILTER_SANITIZE_STRING)));
            $item1 = filter_var($data['item1'], FILTER_SANITIZE_STRING);
            $item2 = filter_var($data['item2'], FILTER_SANITIZE_STRING);
            $item1_cost = filter_var($data['item1_cost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            $item2_cost = filter_var($data['item2_cost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            $item1_qty = filter_var($data['item1_qty'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) * 1;
            $item2_qty = filter_var($data['item2_qty'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) * 1;
            $tot_amt = filter_var($data['tot_amt'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            $estate = filter_var($data['name_of_estate'], FILTER_SANITIZE_STRING);

            
            if ($bitrixid <>'' && $pck !="" && $orderno != "" && $salesperson != "" && $username != ""
                     && $addy !="" && $email !="" && $phone !="" && $firstname !="" && $tot_amt > 0    
                    && $item1 != "" && $item2 != "" && $item1_cost >= 0 && $item2_cost >= 0 ):
//                $pass = $username;
            
                $prod = $prod_qty = $prod_cost = $install = $install_qty = $install_cost = 0;

                        $prod = $item1;
                        $prod_qty = $item1_qty;
                        $prod_cost = $item1_cost;
                        $install = $item2;
                        $install_qty = $item2_qty;
                        $install_cost = $item2_cost;   
                        
                if (!$ad->planExist($pck)) {
                    $resp = ["STATUS"=>0, "MSG"=>"An Error Occured: Invalid Package ($pck) sent.", "D"=>$data];
                    $logda = "'".str_replace("'", "\'", json_encode($resp))."','".date("Y-m-d H:i:s")."', 'BITRIX_ACCINIT_OUT'"; 
                    $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
                    return $response->write(json_encode($resp));
                }
                
                if (!preg_match('/^fob\d+$/', $username)) {
                    $resp = ["STATUS"=>0, "MSG"=>"An Error Occured: Invalid Username Format ($username) sent.", "D"=>$data];
                    $logda = "'".str_replace("'", "\'", json_encode($resp))."','".date("Y-m-d H:i:s")."', 'BITRIX_ACCINIT_OUT'"; 
                    $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
                    return $response->write(json_encode($resp));
                }
                     
                $ree = $ad->bitrixOrderProvisioningv2($bitrixid, $orderno, $username, $company, $orderdate, 
                            $prod, $install, $prod_cost, $install_cost, $prod_qty, $install_qty, $tot_amt, $salesperson, $salesemail, $firstname, $lastname,
                        $addy, $city, $state, $email, $phone, $pck, '0.0.0.0','', $estate, json_encode($data));
                
                $logda = "'".str_replace("'", "\'", json_encode($ree))."','".date("Y-m-d H:i:s")."', 'BITRIX_ACCINIT_OUT'"; 
                $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
                return $response->write(json_encode($ree));
            else:
                $resp = ["STATUS"=>0, "MSG"=>"An Error Occured: Incomplete data", "D"=>$data];
                $logda = "'".str_replace("'", "\'", json_encode($resp))."','".date("Y-m-d H:i:s")."', 'BITRIX_ACCINIT_OUT'"; 
                $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
               return $response->write(json_encode($resp));
            endif;
            
//            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Account Provisioned!"]));
        else:
            $resp = ["STATUS"=>0, "MSG"=>"An Error Occured while provisioning Account"];
            $logda = "'".str_replace("'", "\'", json_encode($resp))."','".date("Y-m-d H:i:s")."', 'BITRIX_ACCINIT_OUT'"; 
            $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
           return $response->write(json_encode($resp));
        endif;
        } catch (Exception $ex) {
          $resp = ["STATUS"=>0, "MSG"=>"An Error Occured while provisioning Account", "EX"=>$ex];
          $logda = "'".str_replace("'", "\'", json_encode($resp))."','".date("Y-m-d H:i:s")."', 'BITRIX_ACCINIT_OUT'"; 
          $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
           return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while provisioning Account", "EX"=>$ex]));
        }
    });
        
});


$app->group('/erp', function(\Slim\App $app) {

    $app->get('/getCustomersId', function ($request, $response, $args) {
    	global $db;
    	$sql = "SELECT ERPID, RAD_USERNAME FROM tbl_erp";
    	$rst = $db->select($sql);
    	$ret = [];
    	while ($row = $rst->fetch_object()) :
    		$ret[$row->RAD_USERNAME] = $row->ERPID;
    	endwhile;
   		return $response->write(json_encode($ret));  
    });
    
    $app->post('/finalizeInv',function(Request $request, Response $response, array $args) {
        global $ad;
        
        $tok = $request->getAttribute('decoded_token_data');
        if ( ($tok->id === 'erp' && $tok->entry === "webservice!23*#*") || 
            ($tok->id === 'erpu' && $tok->entry === "w3bs3rvic3!23*") ):
            $data = $request->getParsedBody();
            $orderno = filter_var($data['orderno'], FILTER_SANITIZE_STRING);
            $order_erpid = filter_var($data['order_erpid'], FILTER_SANITIZE_NUMBER_INT);
            $closedBy = filter_var($data['closedBy'], FILTER_SANITIZE_STRING);
            $closeDate = filter_var($data['closeDate'], FILTER_SANITIZE_STRING);
            $closeDate = $closeDate?:date("Y-m-d H:i:s");
            
            $logda = "'".json_encode($data)."','".date("Y-m-d H:i:s")."', 'ERP_FINALIZEINV'"; $ff = "DATA, DATESENT, DATAORIGIN";
            $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
            
            if ($order_erpid > 0 && $orderno != ""):
                $ordernoV = $ad->getOrderNoByID($order_erpid);
                if (strtoupper($ordernoV) == strtoupper($orderno)) {
                    $vval =  $ad->finalizeInvoice($orderno, $order_erpid, $closeDate, $closedBy);
                    if ($vval) :
                        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Order Finalized Successfully!"]));
                    else: 
                        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Process Failed"]));
                    endif;
                } else {
                    return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Data Mismatch"]));  
                }
                
            else:
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Incomplete data"]));                
            endif;
            
        else:
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while finalizing Account"]));
        endif;

    });
    
     $app->post('/maninvpay',function(Request $request, Response $response, array $args) {
        global $ad;
        
        $tok = $request->getAttribute('decoded_token_data');
        if ( ($tok->id === 'erp' && $tok->entry === "webservice!23*#*") || 
            ($tok->id === 'erpu' && $tok->entry === "w3bs3rvic3!23*") ):
            $data = $request->getParsedBody();
            $erpid = filter_var($data['erpid'], FILTER_SANITIZE_NUMBER_INT);
            $order_erpid = filter_var($data['order_erpid'], FILTER_SANITIZE_NUMBER_INT);
            $orderno = filter_var($data['orderno'], FILTER_SANITIZE_STRING);
            $tellerno = filter_var($data['tellerno'], FILTER_SANITIZE_STRING);
            $processedby = filter_var($data['processedby'], FILTER_SANITIZE_STRING);
//            $salesemail = filter_var($data['salesemail'], FILTER_SANITIZE_STRING);
            $paydate = filter_var($data['paydate'], FILTER_SANITIZE_STRING);
            $paid_amt = filter_var($data['paid_amt'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            $paydate = $paydate? $paydate : date("Y-m-d H:i:s");
            
     		$ff = "DATA, DATESENT, DATAORIGIN";
     		$logda = "'".base64_encode(json_encode($data))."|$orderno','".date("Y-m-d H:i:s")."', 'ERP_MANINVPAY'";
            $ad->insertLog($ff, $logda, "tbl_erpinvoice_data_encrypt");
     		$logda = "'".json_encode($data)."','".date("Y-m-d H:i:s")."', 'ERP_MANINVPAY'";
            $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
     		$isPaid = 1;
     		$isErr = "";
            
            if ($order_erpid > 0 && $paid_amt > 0 && $processedby != "" ): //&& $tellerno != ""
     			$tellerno = ($tellerno != "")? $tellerno: "TRF-$orderno";
                //$orderno = $ad->getOrderNoByID($order_erpid);
                if ($orderno) {
                    $vval =  $ad->getInvoice4Verification($orderno);
                    if ($vval['PAID'] == 1) :
                        //Already Recorded, Do something
                        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Payment Already Updated!"]));
                    endif;
                    if ($vval["REQ_AMOUNT"] > $paid_amt):  //($vval["REQ_AMOUNT"] != $paid_amt):
                		$logda = "'".json_encode($data)."','".date("Y-m-d H:i:s")."', 'ERP_MANINVPAY'"; $ff = "DATA, DATESENT, DATAORIGIN";
            			$ad->insertLog($ff, $logda, "tbl_erpinvoice_data_lowamt");
                		$isPaid = 2;
                		$isErr = "An Error Occured: Invalid paid_amt";
                        // return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Invalid paid_amt"]));
                    endif;
                    $dSave = $ad->saveInvoiceTranxResp($orderno, $isPaid, $tellerno, $paid_amt, 566, "00", "Approved-ERP($orderno)", $paydate, 
                                "ERP-".$processedby, $paydate, "XYZ0", $vval["RAD_USERNAME"]);
                    if ($vval['ERPID']>0 && $vval["ORDER_ERPID"]>0 && $dSave) {   //ERP_DB
                        //Create on eService & Radius
                        $bac = $ad->accProvisionFromOrder($vval["RAD_USERNAME"], $vval['TRANS_ID']);
                        //TODO: update SENTTOERP in tbl_install_invoice=1 //DONE
                        $ad->sendInvoiceToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], $vval["ORDER_ERPID"], $paid_amt, $vval["RAD_USERNAME"]."-ESERVICE-INIT-Invoice(erp-manual)", date("Y-m-d"), 9, 1 );
                    }
                	if ($isErr == "" && $dSave) :
                    	return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Order Updated Successfully!", "REE"=>$bac]));
                	else: 
                		return $response->write(json_encode(["STATUS"=>0, "MSG"=>$isErr, "REE"=>$bac]));
                	endif;
                } else {return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Invalid order_erpid [$order_erpid | $orderno]"]));};

            else:
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Incomplete data"]));
            endif;
            
//            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Account Provisioned!"]));
        else:
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while provisioning Account"]));
        endif;

    });
    
    $app->post('/user',function(Request $request, Response $response, array $args) {
        global $ad;
        
        $tok = $request->getAttribute('decoded_token_data');
        if ( ($tok->id === 'erp' && $tok->entry === "webservice!23*#*") || 
            ($tok->id === 'erpu' && $tok->entry === "w3bs3rvic3!23*") ):
            $data = $request->getParsedBody();
            $erpid = filter_var($data['erpid'], FILTER_SANITIZE_NUMBER_INT);
            $firstname = filter_var($data['first_name'], FILTER_SANITIZE_STRING);
            $lastname = filter_var($data['last_name'], FILTER_SANITIZE_STRING);
            $username = trim(filter_var($data['username'], FILTER_SANITIZE_STRING));
            $company = filter_var($data['company'], FILTER_SANITIZE_STRING);
            $addy = filter_var($data['address'], FILTER_SANITIZE_STRING);
            $city = filter_var($data['city'], FILTER_SANITIZE_STRING);
            $state = filter_var($data['state'], FILTER_SANITIZE_STRING);
            $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
            $phone = filter_var($data['phone'], FILTER_SANITIZE_STRING);
            $pck = filter_var($data['pck'], FILTER_SANITIZE_STRING);
            $ip = filter_var($data['ip'], FILTER_SANITIZE_STRING);
            $estate = filter_var($data['estate'], FILTER_SANITIZE_STRING);
            $gender = filter_var($data['gender'], FILTER_SANITIZE_STRING);
            $dob = filter_var($data['dob'], FILTER_SANITIZE_STRING);
            
     		$logda = "'".json_encode($data)."','".date("Y-m-d H:i:s")."', 'ERP_USER'"; $ff = "DATA, DATESENT, DATAORIGIN";
            $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
            
            if ($erpid > 0 && $username != "" && strtolower($username) != "false" && $company !=""):
                $ree = $ad->erpProvisioning($erpid, $username, $company, $firstname, $lastname,
                        $addy, $city, $state, $email, $phone, $pck, 
                        $ip, '', $estate, $gender, $dob);
                return $response->write(json_encode($ree));
            else:
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Incomplete data [$username]"]));
            endif;
            
//            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Account Provisioned!"]));
        else:
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while provisioning Account [$username]"]));
        endif;

    });
    
    $app->post('/accinit',function(Request $request, Response $response, array $args) {
        global $ad;
        try { 
        $tok = $request->getAttribute('decoded_token_data');
        if ( ($tok->id === 'erp' && $tok->entry === "webservice!23*#*") || 
            ($tok->id === 'erpu' && $tok->entry === "w3bs3rvic3!23*") ):
            $data = $request->getParsedBody();
            $erpid = filter_var($data['erpid'], FILTER_SANITIZE_NUMBER_INT);
            $order_erpid = filter_var($data['order_erpid'], FILTER_SANITIZE_NUMBER_INT);
            $firstname = filter_var($data['firstname'], FILTER_SANITIZE_STRING);
            $lastname = filter_var($data['lastname'], FILTER_SANITIZE_STRING);
            $username = trim(filter_var($data['username'], FILTER_SANITIZE_STRING));
            $company = filter_var($data['company'], FILTER_SANITIZE_STRING);
            $addy = filter_var($data['address'], FILTER_SANITIZE_STRING);
            $city = filter_var($data['city'], FILTER_SANITIZE_STRING);
            $state = filter_var($data['state'], FILTER_SANITIZE_STRING);
            $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
            $phone = filter_var($data['phone'], FILTER_SANITIZE_STRING);
            $mobile = filter_var($data['mobile'], FILTER_SANITIZE_STRING);
            $pck = filter_var($data['pck'], FILTER_SANITIZE_STRING);
            $ip = filter_var($data['ip'], FILTER_SANITIZE_STRING);
            $orderno = filter_var($data['orderno'], FILTER_SANITIZE_STRING);
            $salesperson = filter_var($data['salesperson'], FILTER_SANITIZE_STRING);
            $salesemail = filter_var($data['salesemail'], FILTER_SANITIZE_STRING);
            $orderdate = filter_var($data['orderdate'], FILTER_SANITIZE_STRING);
            $item1 = filter_var($data['item1'], FILTER_SANITIZE_STRING);
            $item2 = filter_var($data['item2'], FILTER_SANITIZE_STRING);
            $item1_cost = filter_var($data['item1_cost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            $item2_cost = filter_var($data['item2_cost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            $item1_qty = filter_var($data['item1_qty'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) * 1;
            $item2_qty = filter_var($data['item2_qty'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) * 1;
            $tot_amt = filter_var($data['tot_amt'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            
     		$ff = "DATA, DATESENT, DATAORIGIN";
        	
        	$logda = "'".base64_encode(json_encode($data))."|$username|$orderno','".date("Y-m-d H:i:s")."', 'ERP_ACCINIT'"; 
        	$ad->insertLog($ff, $logda, "tbl_erpinvoice_data_encrypt");
        	$logda = "'".str_replace("'", "\'", json_encode($data))."','".date("Y-m-d H:i:s")."', 'ERP_ACCINIT'"; 
            $ad->insertLog($ff, $logda, "tbl_erpinvoice_data");
            
            if ($erpid > 0 && $username != "" && strtolower($username) != "false" && $company !="" && $orderno != "" && $salesperson != "" 
                        && $item1 != "" && $item2 != "" && $item1_cost >= 0 && $item2_cost >= 0 ):
                $pass = $username;
      			// if ($pck == "") { $pck = $item1; }
        		$prod = $prod_qty = $prod_cost = $install = $install_qty = $install_cost = 0;
        		if ($ad->planExist($item2)) {
                	$prod = $item2;
                	$prod_qty = $item2_qty;
                	$prod_cost = $item2_cost;
                	$install = $item1;
                	$install_qty = $item1_qty;
                        $install_cost = $item1_cost;
                	if ($pck == "") { $pck = $item2; }
                } else if ($ad->planExist($item1)) {
                        $prod = $item1;
                        $prod_qty = $item1_qty;
                        $prod_cost = $item1_cost;
                        $install = $item2;
                        $install_qty = $item2_qty;
                        $install_cost = $item2_cost;   
                        if ($pck == "") { $pck = $item1; }
                } else {
                   return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Invalid Package. Item 1 or 2 on invoice must contain the plan/package", "D"=>$data]));
                }
                $phone = ($phone == "False")? $mobile : $phone; 
                $ree = $ad->erpOrderProvisioningV3($erpid, $order_erpid, $orderno, $username, $company, $orderdate, 
                            $prod, $install, $prod_cost, $install_cost, $prod_qty, $install_qty, $tot_amt, $salesperson, $salesemail, $firstname, $lastname,
                        $addy, $city, $state, $email, $phone, $pck, $ip, $pass, json_encode($data));
                // $ree = $ad->erpOrderProvisioningV3($erpid, $order_erpid, $orderno, $username, $company, $orderdate, 
                //             $item1, $item2, $item1_cost, $item2_cost, $item1_qty, $item2_qty, $tot_amt, $salesperson, $salesemail, $firstname, $lastname,
                //         $addy, $city, $state, $email, $phone, $pck, $ip, $pass, json_encode($data));
                
//                $ree = $ad->erpOrderProvisioning(json_encode($data)); // ["STATUS"=>1, "MSG"=> "Success: Order [$orderno] received!"];
                return $response->write(json_encode($ree));
            else:
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Incomplete data", "D"=>$data]));
            endif;
            
//            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Account Provisioned!"]));
        else:
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while provisioning Account"]));
        endif;
        } catch (Exception $ex) {
          return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while provisioning Account", "EX"=>$ex]));
        }
    });
    
    
    $app->post('/oinvprocess',function(Request $request, Response $response, array $args) {
        global $ad;
        try { 
        $tok = $request->getAttribute('decoded_token_data');
        if ( ($tok->id === 'erp' && $tok->entry === "webservice!23*#*") || 
            ($tok->id === 'erpu' && $tok->entry === "w3bs3rvic3!23*") ):
            $data = $request->getParsedBody();
            $erpid = filter_var($data['erpid'], FILTER_SANITIZE_NUMBER_INT);
            $order_erpid = filter_var($data['order_erpid'], FILTER_SANITIZE_NUMBER_INT);
            $firstname = filter_var($data['firstname'], FILTER_SANITIZE_STRING);
            $lastname = filter_var($data['lastname'], FILTER_SANITIZE_STRING);
            $username = trim(filter_var($data['username'], FILTER_SANITIZE_STRING));
            $company = filter_var($data['company_name'], FILTER_SANITIZE_STRING);
            $addy = filter_var($data['address'], FILTER_SANITIZE_STRING);
            $city = filter_var($data['city'], FILTER_SANITIZE_STRING);
            $state = filter_var($data['state'], FILTER_SANITIZE_STRING);
            $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
            $phone = filter_var($data['phone'], FILTER_SANITIZE_STRING);
            $mobile = filter_var($data['mobile'], FILTER_SANITIZE_STRING);
//            $pck = filter_var($data['pck'], FILTER_SANITIZE_STRING);
            $company_id = filter_var($data['company'], FILTER_SANITIZE_NUMBER_INT);
//            $ip = filter_var($data['ip'], FILTER_SANITIZE_STRING);
            $orderno = filter_var($data['orderno'], FILTER_SANITIZE_STRING);
            $salesperson = filter_var($data['salesperson'], FILTER_SANITIZE_STRING);
            $salesemail = filter_var($data['salesemail'], FILTER_SANITIZE_STRING);
            $orderdate = filter_var($data['invoice_date'], FILTER_SANITIZE_STRING);
            $invoice_for = filter_var($data['invoice_for'], FILTER_SANITIZE_STRING);
            $item1 = filter_var($data['item1'], FILTER_SANITIZE_STRING);
            $item2 = filter_var($data['item2'], FILTER_SANITIZE_STRING);
            $item1_cost = filter_var($data['item1_cost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            $item2_cost = filter_var($data['item2_cost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            $item1_qty = filter_var($data['item1_qty'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) * 1;
            $item2_qty = filter_var($data['item2_qty'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) * 1;
            $tot_amt = filter_var($data['tot_amt'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
            
            $logda = "'".str_replace("'", "\'", json_encode($data))."','".date("Y-m-d H:i:s")."', 'ERP_OINVPROCESS'"; $ff = "DATA, DATESENT, DATAORIGIN";
            $ad->insertLog($ff, $logda, "tbl_oinvoices_data");
            
            if ($erpid > 0 && $username != "" && $orderno != "" && trim($orderno) != "/" && $salesperson != "" 
                        && $item1 != "" && $item1_cost >= 0 && $invoice_for != "" ):
                $req_options = ['Relocation','Upgrade','Downgrade','Modem Replacement','Support','Reconnection'];
                if (!in_array($invoice_for, $req_options)) {
                    return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Invalid Invoice For",
                        "PossibleValues"=>$req_options]));
                }
                $phone = ($phone == "False")? $mobile : $phone; 
                $ree = $ad->oOrderProvisioningV1($erpid, $order_erpid, $orderno, $username, $company, $orderdate, 
                            $item1, $item2, $item1_cost, $item2_cost, $item1_qty, $item2_qty, $tot_amt, $salesperson, $salesemail, $firstname, $lastname,
                        $addy, $city, $state, $email, $phone, $invoice_for, json_encode($data));
                
                return $response->write(json_encode($ree));
            else:
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured: Incomplete data", "D"=>$data]));
            endif;
            
//            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Account Provisioned!"]));
        else:
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while creating Invoice"]));
        endif;
        } catch (Exception $ex) {
          return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while creating Invoice", "EX"=>$ex]));
        }
    });
   
});


$app->post('/auth', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $uname = filter_var($data['uname'], FILTER_SANITIZE_STRING);
    $pass = filter_var($data['asiri'], FILTER_SANITIZE_STRING);  
    
    $suc = $ad->authenticateUser($uname, $pass);

    $found = FALSE;
    $errmsg = $succmsg = "";
    $udata = $ret = [];
    if ($suc) :
        //Ordinary User
        $found = TRUE;
    else:
        //Check If Admin
        $suc = $ad->authenticateAdmin($uname, $pass);
        if ($suc) :
            //Is Admin
            $found = TRUE;
        else:
            $errmsg = "Error: Invalid Username/Password!";
            $ret = ['STATUS'=>0, 'ERROR'=>$errmsg];
        endif;
    endif;

    if ($found) :
        if (!$ad->isEnabled()) :
            $errmsg = "Error: Could not Authenticate this user at the moment. Kindly contact the Administrator via info@kkontech.com";
            $ret = ['STATUS'=>0, 'ERROR'=>$errmsg];
        else:
            $udata['loggedin'] = ($ad->isAdmin())? 201 : 101;
            $udata['userid'] = $ad->getUID();
            $udata['username'] = (string)$uname;
            $udata['radusername'] = $ad->getRADUserName();
            $udata['fullname'] = $ad->getFullName();
            $udata['phoneNo'] = $ad->getMobile();
            $udata['email'] = trim($ad->getEmail());
            $udata['usertype'] = $ad->getUserType();
            $udata['usertype_id'] = $ad->getUserTypeID();
            $udata['expiration'] = $ad->getExpiration();
            $udata['expiration_format'] = date("d-M-Y h:i:s A", strtotime($ad->getExpiration()));
            $udata['package'] = $ad->getPackage();
            $udata['package_id'] = $ad->getPackageID();
            $udata['object'] = $ad;
            $udata['lastlogoff'] = $ad->getLastLogOff();
            $udata['lastlogoff_format'] = date("d-M-Y h:i:s A", strtotime($ad->getLastLogOff()));
            $curDate = date('Y-m-d H:i:s');
//            $daysLeft = round((strtotime($curDate) - strtotime($ad->getExpiration()))/(24*3600)); 
            $udata['daysToExpiration'] = round( (strtotime($ad->getExpiration()) - strtotime($curDate))/(24*3600));
            $udata['daysToExpiration2'] = round( ((strtotime($ad->getExpiration()) - strtotime($curDate))/(24*3600)), 2);
            
            $udata["DATAHIST"] = $ad->getUserDataUsage($uname);

            $succmsg = "Success: Login Successful!";
            $ret = ['STATUS'=>1, 'MSG'=>$succmsg, 'UDATA'=>$udata];
        endif;
    endif;

    return $response->write(json_encode($ret));
    
});

$app->get('/auth/{uname}/{asiri}', function ($request, $response, $args) {
    global $ad;
    
    $suc = $ad->authenticateUser((string)$args['uname'], (string)$args['asiri']);

    $found = FALSE;
    $errmsg = $succmsg = "";
    $udata = $ret = [];
    if ($suc) :
        //Ordinary User
        $found = TRUE;
    else:
        //Check If Admin
        $suc = $ad->authenticateAdmin((string)$args['uname'], (string)$args['asiri']);
        if ($suc) :
            //Is Admin
            $found = TRUE;
        else:
            $errmsg = "Error: Invalid Username/Password!";
            $ret = ['STATUS'=>0, 'ERROR'=>$errmsg];
        endif;
    endif;

    if ($found) :
        if (!$ad->isEnabled()) :
            $errmsg = "Error: Could not Authenticate this user at the moment. Kindly contact the Administrator via info@kkontech.com";
            $ret = ['STATUS'=>0, 'ERROR'=>$errmsg];
        else:
            $udata['loggedin'] = ($ad->isAdmin())? 201 : 101;
            $udata['userid'] = $ad->getUID();
            $udata['username'] = (string)$args['uname'];
            $udata['radusername'] = $ad->getRADUserName();
            $udata['fullname'] = $ad->getFullName();
            $udata['phoneNo'] = $ad->getMobile();
            $udata['email'] = $ad->getEmail();
            $udata['usertype'] = $ad->getUserType();
            $udata['usertype_id'] = $ad->getUserTypeID();
            $udata['expiration'] = $ad->getExpiration();
            $udata['expiration_format'] = date("d-M-Y h:i:s A", strtotime($ad->getExpiration()));
            $udata['package'] = $ad->getPackage();
            $udata['package_id'] = $ad->getPackageID();
            $udata['object'] = $ad;
            $curDate = date('Y-m-d H:i:s');
//            $daysLeft = round((strtotime($curDate) - strtotime($ad->getExpiration()))/(24*3600)); 
            $udata['daysToExpiration'] = round( (strtotime($ad->getExpiration()) - strtotime($curDate))/(24*3600));

            $succmsg = "Success: Login Successful!";
            $ret = ['STATUS'=>1, 'MSG'=>$succmsg, 'UDATA'=>$udata];
        endif;
    endif;

    return $response->write(json_encode($ret));
});

$app->get('/voipexist/{voip}', function ($request, $response, $args) {
    global $ad;
    
    if ($ad->verifyVOIPExist((string)$args['voip'])) :
        return $response->write(1);
    else:
        return $response->write(0);
    endif;
    
});

$app->get('/userexist/{uname}', function ($request, $response, $args) {
    global $ad;
    
    if ($ad->verifyUserExistAlone((string)$args['uname'])) :
        return $response->write(1);
    else:
        return $response->write(0);
    endif;
    
});

$app->get('/adminexist/{uname}', function ($request, $response, $args) {
    global $ad;
    
    if ($ad->verifyAdminExist((string)$args['uname'])) :
        return $response->write(1);
    else:
        return $response->write(0);
    endif;
    
});

$app->post('/add_subacct', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $uid = filter_var($data['uid'], FILTER_SANITIZE_NUMBER_INT);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $addon = filter_var($data['addon'], FILTER_SANITIZE_STRING);
    
    $subacc = split(',', $addon);
    if (!count($subacc) || ($addon=='null')) :
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"You must select at least 1 Addon Service ID"]));
    endif;
    $re = $ad->createSubAccount($uid, $adminID, $subacc);

    if ($re) :
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Sub/Addon Account(s) Added!"]));
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An Error Occured while adding the Sub/Addon Account(s)"]));
    endif;
    
});


$app->post('/addplan', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $data_volume = filter_var($data['data_volume'], FILTER_SANITIZE_NUMBER_INT);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $plan = filter_var($data['plan'], FILTER_SANITIZE_STRING);
    $description = filter_var($data['description'], FILTER_SANITIZE_STRING);
    $packageid = filter_var($data['packageid'], FILTER_SANITIZE_NUMBER_INT);
    $validity = filter_var($data['validity'], FILTER_SANITIZE_NUMBER_INT);
    $amount = filter_var($data['amount'], FILTER_SANITIZE_NUMBER_FLOAT);
    
//    $description = (!isset($description))? "" : $description;
    
    //Convert Data to Byte
    $by = $data_volume * (1024) * 1024;
    return $response->write($ad->createPlan($plan, $packageid, $by, $amount, $validity, $description, $adminID));

});


$app->post('/cadmin', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $phoneNo = filter_var($data['phoneNo'], FILTER_SANITIZE_STRING);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
    $fullname = filter_var($data['fullname'], FILTER_SANITIZE_STRING);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $username = filter_var($data['username'], FILTER_SANITIZE_STRING);

    return $response->write($ad->createAdmin($username, $pass, $fullname, $email, $phoneNo, 1, $adminID));
});

$app->post('/chpass', function ($request, $response) {
    global $ad;
    $ret = -1;
    
    $data = $request->getParsedBody();
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $is_admin = filter_var($data['is_admin'], FILTER_SANITIZE_NUMBER_INT);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $oldpass = filter_var($data['opass'], FILTER_SANITIZE_STRING);
    
    if ($is_admin == 1) : //echo "IS ADMIN ";
        $ret = $ad->changeAdminPassword($user, $pass, $oldpass);
    else: //echo "IS_USER ";
        $ret = $ad->changePassword($user, $pass, $oldpass);
    endif;


    if ($ret == 1) :
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Password Change Successful!"]));
    else:
        $err = ($ret == 0)? "Password Change Failed!" : "Incorrect Username/Current Password!";
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>$err]));
    endif;
});

$app->post('/cuser', function ($request, $response) {
    global $ad;
    $ret = -1;
    
    $data = $request->getParsedBody();
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $username = filter_var($data['username'], FILTER_SANITIZE_STRING);
    
    $rad_exist = $ad->loadRadUser($raduser, 1, 0);
    
    //Get Message
    $raw_msg = $ad->getCannedMessage("LOGIN_INFO");
    
    if (count($rad_exist) > 0) :
        $rett = $ad->createClient($username, $pass, $raduser, $adminID);
        $user_dets = $ad->loadClientRec($username);
        if (count($user_dets)):
            $user_det = $user_dets[$username];
            $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
            $email = $user_det["EMAIL"];
            $admin_user = 0;

            $url = SERVER_URL . "";

            $msg = sprintf($raw_msg, $fullname, $username, $pass, $url);

            $sent = $ad->sendEmail($email, EMAIL_SENDER, "Account Creation on FiberOne Online", $msg);
        endif;
        return $response->write($rett);
    else:
        return $response->write("Error: Invalid Service ID!");
    endif;
});

$app->post('/cvoip', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $adminID = filter_var($data['adminID'], FILTER_SANITIZE_NUMBER_INT);
    $voip_no = filter_var($data['voip_no'], FILTER_SANITIZE_STRING);
    
    $rad_exist = $ad->loadRadUser4VOIP($raduser, 1, 0);

    if (count($rad_exist) > 0) :
        return $response->write($ad->createVOIP($raduser, $voip_no, $adminID));

    else:
        return $response->write("Error: Invalid Service ID!");        
    endif;
});

$app->delete('/del_subacct/{uid}/(radu}', function ($request, $response, $args) {
    global $ad;
        
    $uid = (integer)$args['uid'];
    $radu = (integer)$args['radu'];
    
    if ($uid == 0 || $radu == "") :
        return $response->write("Error: Data Integrity Test Failed");
    endif;
    
    return $response->write($ad->delSubAccount($uid, $radu));
});

$app->post('/eadmin', function ($request, $response) {
    global $ad;

    $data = $request->getParsedBody();
    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $fullname = filter_var($data['fullname'], FILTER_SANITIZE_STRING);
    $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
    $phoneNo = filter_var($data['phoneNo'], FILTER_SANITIZE_STRING);
    $changep = filter_var($data['changep'], FILTER_SANITIZE_STRING);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $passconfirm = filter_var($data['passconfirm'], FILTER_SANITIZE_STRING);
    $is_enabled = filter_var($data['is_enabled'], FILTER_SANITIZE_NUMBER_INT);
    $username = filter_var($data['username'], FILTER_SANITIZE_STRING);
    
    if ($username == "") :
        return $response->write("Error! Invalid Username.");
    endif;
    
    $is_admin_pg = 1;
    $passwd = "";
    
    if (isset($changep) && ($changep == 'on') ) :
        if ($pass == $passconfirm) :
            if ($pass != "******************") :

            else:
                return $response->write("Error: Invalid Password!");
            endif;
        else:
            return $response->write("Error: Password and Confirm Pass do not match!");
        endif;

        $r = $ad->verifyPassword($username, $pass, $is_admin_pg);
        if ($r == 1) {
            return $response->write("Error: New Password must be different from Current Password!");
        } elseif ($r == -1) {
            return $response->write("Error: Invalid Username/Password provided");
        }

        $passwd = $pass;

    endif;
    if ($uxu != $username) :
        return $response->write("Error: Data Integrity Test Failed!");
    endif;

    return $response->write($ad->editAdmin($username, $passwd, $fullname, $email, $phoneNo, $is_enabled));
});

$app->post('/eplan', function ($request, $response) {
    global $ad;

    $data = $request->getParsedBody();
    $plan = filter_var($data['plan'], FILTER_SANITIZE_STRING);
    $pid = filter_var($data['pid'], FILTER_SANITIZE_NUMBER_INT);
    $planid = filter_var($data['planid'], FILTER_SANITIZE_NUMBER_INT);
    $rxp = filter_var($data['rxp'], FILTER_SANITIZE_STRING);
    $data_volume = filter_var($data['data_volume'], FILTER_SANITIZE_NUMBER_INT);
    $packageid = filter_var($data['packageid'], FILTER_SANITIZE_NUMBER_INT);
    $amount = filter_var($data['amount'], FILTER_SANITIZE_NUMBER_FLOAT);
    $is_enabled = filter_var($data['is_enabled'], FILTER_SANITIZE_NUMBER_INT);
    $validity = filter_var($data['validity'], FILTER_SANITIZE_NUMBER_INT);
    $description = filter_var($data['description'], FILTER_SANITIZE_STRING);
    
    if ($plan == "") :
        return $response->write("Error! Invalid Plan Name.");
    endif;

    if ($pid != $planid) :
        return $response->write("Error: Data Integrity Test Failed!");
    endif;

    if ($rxp != $plan) :
        return $response->write("Error: Data 2 Integrity Test Failed!");
    endif;
    
    //Convert Data to Byte
    $by = $data_volume * (1024) * 1024;

    return $response->write($ad->editPlan($planid, $plan, $packageid, $by, $amount, $validity, $description, $is_enabled));
});

$app->post('/euser', function ($request, $response) {
    global $ad;

    $data = $request->getParsedBody();
    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $rxu = filter_var($data['rxu'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $chradu = filter_var($data['chradu'], FILTER_SANITIZE_STRING);
    $changep = filter_var($data['changep'], FILTER_SANITIZE_STRING);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);
    $passconfirm = filter_var($data['passconfirm'], FILTER_SANITIZE_STRING);
    $is_enabled = filter_var($data['is_enabled'], FILTER_SANITIZE_NUMBER_INT);
    $username = filter_var($data['username'], FILTER_SANITIZE_STRING);
    
    if ($username == "") :
        return $response->write("Error! Invalid Username.");
    endif;
    if (isset($chradu) && $chradu == "on" && $raduser == "") :
        return $response->write("Error! Invalid New Service ID.");
    endif;
    
    $is_admin_pg = 0;
    $passwd = "";
    
    if (isset($changep) && ($changep == 'on') ) :
        if ($pass == $passconfirm) :
            if ($pass != "******************") :

            else:
                return $response->write("Error: Invalid Password!");
            endif;
        else:
            return $response->write("Error: Password and Confirm Pass do not match!");
        endif;

        $r = $ad->verifyPassword($username, $pass, $is_admin_pg);
        if ($r == 1) {
            return $response->write("Error: New Password must be different from Current Password!");
        } elseif ($r == -1) {
            return $response->write("Error: Invalid Username/Password provided");
        }

        $passwd = $pass;

    endif;
    if ($uxu != $username) :
        return $response->write("Error: Data Integrity Test Failed!");
    endif;

    if (isset($chradu) && $chradu == "on" && $rxu == $raduser) :
        return $response->write("Error: Radius Data Integrity Test Failed!");
    endif;

    $radius_user = "";
    if (isset($chradu) && $chradu == "on" && $rxu != $raduser) :
        $radius_user = $raduser;
    endif;

    return $response->write($ad->editUser($username, $radius_user, $passwd, $is_enabled));
});


$app->post('/euserp', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $chradu = filter_var($data['chradu'], FILTER_SANITIZE_STRING);
    $phoneNo = filter_var($data['phoneNo'], FILTER_SANITIZE_STRING);
    $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
    $userid= filter_var($data['userid'], FILTER_SANITIZE_NUMBER_INT);
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);

    if ($user == "" /*|| $user != $_SESSION[$sid.'username']*/) :
        return $response->write("Error! Invalid Data.");
    endif;
    if ($raduser == "") :
        return $response->write("Error! Invalid R. Data.");
    endif;
    if (isset($chradu) && $chradu == "on" && ($email == "") || ($phoneNo == "") ) :
        return $response->write("Error! Email and Phone Number Cannot be Blank!");
    endif;
    
    $rads = $ad->loadAllRADAccount($userid);
    $rad = [];
    foreach ($rads[$user] as $k=>$r):
        $rad[] = $r["RAD_USERNAME"];
    endforeach;
    return $response->write($ad->updateUserProfile($rad, $email, $phoneNo)); 
});

$app->get('/getallradacct/{uname}', function ($request, $response, $args) {
    global $ad;
    
    $user = strtolower((string)$args['uname']);
    $sacct = $ad->loadAllRADAccountByUsername($user);
    $rad = [];
    
    if (isset($sacct[$user])) {
        foreach ($sacct[$user] as $key => $kos) :
            $rad[$key] = $kos;
        endforeach;
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$rad]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/gettranshistory/{multipleu}/{uname}', function ($request, $response, $args) {
    global $ad;
    
    $user = strtolower((string)$args['uname']);
    $mu = (integer)$args['multipleu'];
    if ($mu == 1){
        $sacct = $ad->loadAllRADAccountByUsername($user);
        $radlst = [];
        if (isset($sacct[$user])) {
            foreach ($sacct[$user] as $ky => $ks) :
                $radlst[] = $ks['RAD_USERNAME'];
            endforeach;
        } 
    } else {
        $radlst = $user;
    }
    
    $mdat = $ad->getTransactions($radlst);
    
    if (isset($mdat)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$mdat]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getplan/{serviceid}', function ($request, $response, $args) {
    global $ad;
    
    $svrid = (integer)$args['serviceid'];
    $sacct = $ad->loadPlans($svrid);
    $rad = [];
    
    if (isset($sacct)) {
        foreach ($sacct as $key => $kos) :
            $rad = $kos;
        endforeach;
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$rad]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getplans', function ($request, $response, $args) {
    global $ad;
    
    // $svrid = (integer)$args['serviceid'];
    $sacct = $ad->loadPlans(-1, 0, 1);
    $rad = [];
    
    if (isset($sacct)) {
        foreach ($sacct as $key => $kos) :
    		if ($kos['SRVID']):
            	$rad[] = $kos;
    		endif;
        endforeach;
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$rad]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getPlansByHierarchy/{serviceid}', function ($request, $response, $args) {
    global $ad;
    
    $svrid = (integer)$args['serviceid'];
    $sacct = $ad->loadPlansByHierarchy($svrid, 1);
    $rad = [];
    
    if (isset($sacct)) {
        foreach ($sacct as $key => $kos) :
    		if ($kos['SRVID']):
            	$rad[] = $kos;
    		endif;
        endforeach;
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$rad]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getfaqs', function ($request, $response, $args) {
    global $ad, $db;
    
    // $svrid = (integer)$args['serviceid'];
	$qry = "SELECT FAQ_ID, QUESTION, ANSWER, LASTUPDATE, CREATEDON FROM tbl_faqs";
	$some_sth = $db->select($qry);
	$ret = [];
    while ( $row = $some_sth->fetch_object() ) {
       $ret[] = ["FAQ_ID"=>$row->FAQ_ID, "QUESTION"=>$row->QUESTION, "ANSWER"=>$row->ANSWER,
                	"LASTUPDATE"=>$row->LASTUPDATE, "CREATEDON"=>$row->CREATEDON];
    }
    
    if (count($ret)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$ret]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered/No data found."]));
    }    
});

$app->get('/getusage/{username}', function ($request, $response, $args) {
    global $ad;
    
    $user= (string)$args['username'];
    //$mdat = $ad->getMonthlyDataUsageAsString($user); 
    $mdata = $ad->getMonthlyDataUsage($user); 
    $mdat = $ad->getMonthlyDataUsageMobile($user);
    if (isset($mdat)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$mdata, "UDATASTR" =>$mdat])); //a, "UDATASTR" =>$mdat
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }
});


$app->get('/getUsageV2/{username}/{start}/{end}/{unit}', function ($request, $response, $args) {
    global $ad;
    ///(start}/{end}/{unit}
    $user= (string)$args['username']; 
    $start= (string)$args['start'];
    $end= (string)$args['end'];
    $unit= (string)$args['unit'];
    //$mdat = $ad->getMonthlyDataUsageAsString($user); 
    // $mdata = $ad->getMonthlyDataUsage($user); 
    // $mdat = $ad->getMonthlyDataUsageMobile($user);
	$mmdat = $ad->getDataUsageByUser($user, $start, $end, $unit); //print_r($mmdat); //, $start, $end, $unit
    if (isset($mmdat)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$mmdat])); //a, "UDATASTR" =>$mdat
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }
});


$app->post('/gentrans', function ($request, $response) {
    global $ad;
     return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Webpay Payments temporary unavailable, kindly use other payment options. Thank you."]));
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $fullname = filter_var($data['fullname'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $planid = filter_var($data['planid'], FILTER_SANITIZE_NUMBER_INT);
    $packageid = filter_var($data['packageid'], FILTER_SANITIZE_NUMBER_INT);
    $nmonths = filter_var($data['nmonths'], FILTER_SANITIZE_NUMBER_INT);

    if ($nmonths < 0 || $nmonths == "") :
        return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Invalid Number of Months"]));
    endif;
    if ($raduser == "") :
        return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Invalid Service ID"]));
    endif;
    if ($planid == "" || $planid < 0) :
        return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Invalid Plan"]));
    endif;
    if ($packageid == "" || $packageid < 0) :
        return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Invalid Package"]));
    endif;
    
    $plists = $ad->loadPlans($packageid, $planid);
    $plist = $plists[$planid];
    $expiry = $ad->getExpirationDate($raduser);
    $exp = isExpired($expiry);
    $du = date("jS M, Y g:i:sa T", strtotime($expiry));
    if ($exp) {
        $st = "Your account expired on <strong>$du</strong>";
        $col = "danger";
    } else {
        $st = "Your due date is <strong>$du</strong>";
        $col = "info";
    }

    $amount_due = ($nmonths * $plist['AMOUNT']);

    $codeg = new Password_Generator();
    $txn_id = "KK". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);

    $saveRet = $ad->saveInitTranx($txn_id, $raduser, $expiry, $amount_due, CURRENCY, $nmonths, $planid);
    $ct = 0;
    while (!$saveRet && $ct++ < 10):
        $txn_id = "KK". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);
        $saveRet = $ad->saveInitTranx($txn_id, $raduser, $expiry, $amount_due, CURRENCY, $nmonths, $planid);
    endwhile;
    
    if (!$saveRet) { return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Unable to generate Transaction ID at the moment."])); }

    $product_id = PRODUCTID;
    $pay_item_id = PAYITEMID;
    $notif_url = "https://eservice.fob.ng/psuccess_mobile.php"; // NOTIFICATION_URL;
    $hash = $ad->hashGeneratorNew($txn_id . $product_id . $pay_item_id . ($amount_due*100) . $notif_url . HASH_KEY);
    $ret = ["txn_ref"=>$txn_id,"amount"=>($amount_due*100),"amount_naira"=>($amount_due), "currency"=>CURRENCY, "cust_id"=>$raduser,
            "cust_name"=>$fullname, "pay_item_id"=>$pay_item_id, "product_id"=>$product_id, "hash"=>$hash,
            "local_date_time"=>date("d-M-y H:i:s"), "site_redirect_url"=>$notif_url, "nmonths"=>$nmonths];
    
    return $response->write(json_encode(["STATUS"=>1,"MSG"=>"Generated", "UDATA"=>$ret]));
    //return $response->write($ad->updateUserProfile2($raduser, $fullname, $address, $city, $state)); 
});


$app->post('/gentransps', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $fullname = filter_var($data['fullname'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $planid = filter_var($data['planid'], FILTER_SANITIZE_NUMBER_INT);
    $packageid = filter_var($data['packageid'], FILTER_SANITIZE_NUMBER_INT);
    $nmonths = filter_var($data['nmonths'], FILTER_SANITIZE_NUMBER_INT);

    if ($nmonths < 0 || $nmonths == "") :
        return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Invalid Number of Months"]));
    endif;
    if ($raduser == "") :
        return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Invalid Service ID"]));
    endif;
    if ($planid == "" || $planid < 0) :
        return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Invalid Plan"]));
    endif;
    if ($packageid == "" || $packageid < 0) :
        return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Invalid Package"]));
    endif;
    
    $plists = $ad->loadPlans($packageid, $planid);
    $plist = $plists[$planid];
    $isupcountry = $plist['IS_UPCOUNTRY'];
    if ($isupcountry):
        $pubkey = PS_UPC_LIVE_PUB_KEY;
    else:
        $pubkey = PS_LIVE_PUB_KEY;
    endif;
    $expiry = $ad->getExpirationDate($raduser);
    $exp = isExpired($expiry);
    $du = date("jS M, Y g:i:sa T", strtotime($expiry));
    if ($exp) {
        $st = "Your account expired on <strong>$du</strong>";
        $col = "danger";
    } else {
        $st = "Your due date is <strong>$du</strong>";
        $col = "info";
    }

    $amount_due = ($nmonths * $plist['AMOUNT']);

    $codeg = new Password_Generator();
    $txn_id = "PAYSM-$raduser-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);

    $saveRet = $ad->saveInitTranx($txn_id, $raduser, $expiry, $amount_due, CURRENCY, $nmonths, $planid);
    $ct = 0;
    while (!$saveRet && $ct++ < 10):
        $txn_id = "PAYSM-$raduser-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);
        $saveRet = $ad->saveInitTranx($txn_id, $raduser, $expiry, $amount_due, CURRENCY, $nmonths, $planid);
    endwhile;
    
    if (!$saveRet) { return $response->write(json_encode(["STATUS"=>0,"MSG"=>"Error! Unable to generate Transaction ID at the moment."])); }

    $notif_url = "https://eservice.fob.ng/psuccess_psmobile.php"; // NOTIFICATION_URL;
    $ret = ["txn_ref"=>$txn_id,"amount"=>($amount_due*100),"amount_naira"=>($amount_due), "currency"=>CURRENCY, "cust_id"=>$raduser,
            "cust_name"=>$fullname, "local_date_time"=>date("d-M-y H:i:s"), "site_redirect_url"=>$notif_url, "nmonths"=>$nmonths,
            "is_upcontry"=>$isupcountry, "pubkey"=>$pubkey, "plan"=>$plist['PLAN']];
    
    return $response->write(json_encode(["STATUS"=>1,"MSG"=>"Generated", "UDATA"=>$ret]));
    //return $response->write($ad->updateUserProfile2($raduser, $fullname, $address, $city, $state)); 
});


$app->post('/mobile-ps-process', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();

    $txnid = filter_var($data['txnid'], FILTER_SANITIZE_STRING);
//    $txnref = filter_var($data['txnref'], FILTER_SANITIZE_STRING);
    
    $url = SERVER_URL . "psuccess_ps?txnid=$txnid&ismobile=1";
    $vArray =curlURL($url); //$vArray =json_decode(curlURL($url), TRUE); //curlURL($url);
    return $response->write( json_encode( ["STATUS"=>($vArray->STATUS=="00")?1:0,"MSG"=>$vArray->MSG ] ) );
	// return $response->withJson(curlURL($url));
	// return $response->write( json_encode( ["STATUS"=>($vArray['STATUS']=="00")?1:0,"MSG"=>$vArray['MSG'] ] ) );
    // return $response->write(json_encode( ["STATUS"=>($vArray->STATUS=="00")?1:0,"MSG"=>$vArray->MSG ] ));
});


$app->post('/euserp2', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['raduser'], FILTER_SANITIZE_STRING);
    $chradu2 = filter_var($data['chradu2'], FILTER_SANITIZE_STRING);
    $fullname = filter_var($data['fullname'], FILTER_SANITIZE_STRING);
    $address = filter_var($data['address'], FILTER_SANITIZE_STRING);
    $city = filter_var($data['city'], FILTER_SANITIZE_STRING);
    $state = filter_var($data['state'], FILTER_SANITIZE_STRING);

    if ($raduser == "") :
        return $response->write("Error! Invalid Service ID");
    endif;
    if (isset($chradu2) && $chradu2 == "on" && ($fullname == "") || ($address == "") || ($city == "") || ($state == "") ) :
        return $response->write("Error! All Fields Cannot be Blank!");
    endif;

    return $response->write($ad->updateUserProfile2($raduser, $fullname, $address, $city, $state)); 
});


$app->post('/euserprofile', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $raduser = filter_var($data['user'], FILTER_SANITIZE_STRING);
//    $chradu2 = filter_var($data['chradu2'], FILTER_SANITIZE_STRING);
    $firstname = filter_var($data['firstname'], FILTER_SANITIZE_STRING);
    $lastname = filter_var($data['lastname'], FILTER_SANITIZE_STRING);
    $address = filter_var($data['address'], FILTER_SANITIZE_STRING);
    $city = filter_var($data['city'], FILTER_SANITIZE_STRING);
    $state = filter_var($data['state'], FILTER_SANITIZE_STRING);
    $phone = filter_var($data['phone'], FILTER_SANITIZE_STRING);
    $email = filter_var($data['email'], FILTER_SANITIZE_STRING);

    if ($raduser == "") :
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Error! Invalid Service ID"]));
    endif;
    if ( ($firstname == "") || ($lastname == "") 
             || ($phone == "") || ($email == "")) :
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Error! All Fields Cannot be Blank!"]));
    endif;
    
    if ($ad->updateUserProfile3($raduser, $firstname, $lastname, $address, $city, $state, $email, $phone)):
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Update Successful!"]));
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Error! An error Occurred!"]));
    endif;
});


$app->get('/getDetails/{user}', function ($request, $response, $args) {
    global $db;
    
    $user = (string)$args['user'];
    $strsql = "SELECT tc.ID, company, expiration, RAD_USERNAME, tp.PLAN FROM `tblclients` tc
            LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
            LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID
            WHERE tc.USERNAME LIKE ?";
    $some_st = $db->select($strsql, "s", $user);
    if ($some_st->num_rows() >= 1) :
        while ($row = $some_st->fetch_assoc()) :
            $exp = isExpired($row['expiration']);
            list($y, $m, $d) = sscanf($row['expiration'], '%d-%d-%d %s');      
            $du = "$d-$m-$y";
            if ($exp) $st = "Your account expired on <strong>$du</strong>";
            else $st = "Your due date is <strong>$du</strong>";  			
            $expiration_format = date("d-M-Y h:i:s A", strtotime($row['expiration']));
            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Success: $st", "COMPANY"=>$row['company'], "EXPIRATION"=>$row['expiration'], "EXPIRATION_FORMAT"=>$expiration_format, "PACKAGE"=>$row['PLAN']]));
        endwhile;
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Error: Invalid Username, Please check and try again."]));
    endif;

});

$app->get('/getUserDetails/{user}', function ($request, $response, $args) {
    global $db, $ad;
    
    $user = (string)$args['user'];
    $strsql = "SELECT company, expiration, username, tp.PLAN, CONCAT(firstname, ' ', lastname) AS 'fullname', address, lastlogoff, tp.SRVID,
            ru.email, ru.mobile 
            FROM rm_users ru
		LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID
            WHERE ru.username LIKE ?";
    $some_st = $db->select($strsql, "s", $user);
    if ($some_st->num_rows() >= 1) :
        $dataHist = $ad->getUserDataUsage($user);
        while ($row = $some_st->fetch_assoc()) :
            $exp = isExpired($row['expiration']);
            list($y, $m, $d) = sscanf($row['expiration'], '%d-%d-%d %s');      
            $du = "$d-$m-$y";
            if ($exp) $st = "Your account expired on <strong>$du</strong>";
            else $st = "Your due date is <strong>$du</strong>"; 			
            $expiration_format = date("d-M-Y h:i:s A", strtotime($row['expiration']));	
			$daysToExpiration = round( (strtotime($row['expiration']) - strtotime(date('Y-m-d H:i:s')))/(24*3600));
            $daysToExpiration2 = round( ((strtotime($row['expiration']) - strtotime(date('Y-m-d H:i:s')))/(24*3600)), 2);
            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Success: $st", "COMPANY"=>$row['company'], 
                                  "EXPIRATION"=>$row['expiration'], "EXPIRATION_FORMAT"=>$expiration_format, 
                                  "PACKAGE"=>$row['PLAN'], "FULLNAME"=>$row['fullname'], "PACKAGE_ID"=>$row['SRVID'], 
                                  "ADDRESS"=>$row['address'], "daysToExpiration"=>$daysToExpiration, 
                                  "lastlogoff"=>$row["lastlogoff"], "DATAHIST"=>$dataHist, "daysToExpiration2"=>$daysToExpiration2,
                                  "EMAIL"=>trim($row["email"]), "MOBILE"=>$row["mobile"]  ]));
        endwhile;
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Error: Invalid Username, Please check and try again."]));
    endif;

});

$app->get('/loadRadUser/{user}', function ($request, $response, $args) {
    global $ad;
    
    $user = (string)$args['user'];
    $suc = $ad->loadRadUserObject($user, 1, 0);
    $r = [];

    foreach ($suc as $key => $row) {
        $r[] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                            "LASTNAME"=> $row->lastname, 
                            "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                            "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                            "EXPIRATION" => $row->expiration, "EXPIRATION_FORMAT"=>date("d-M-Y h:i:s A", strtotime($row->expiration)), "IS_ENABLED" => $row->enableuser);
    }
    return $response->write(json_encode($r));

});

$app->get('/loadRadUser4VOIP/{user}', function ($request, $response, $args) {
    global $ad;
    
    $user = (string)$args['user'];
    $suc = $ad->loadRadUserObject4VOIP($user, 1, 0);
    $r = [];

    foreach ($suc as $key => $row) {
        $r[] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                            "LASTNAME"=> $row->lastname, 
                            "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                            "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                            "EXPIRATION" => $row->expiration, "EXPIRATION_FORMAT"=>date("d-M-Y h:i:s A", strtotime($row->expiration)), "IS_ENABLED" => $row->enableuser);
    }
    return $response->write(json_encode($r));

});

$app->get('/lstSubAcc', function ($request, $response, $args) {
    global $ad;
    
    $uid = (integer)$args['uid'];
    $user = (string)$args['user'];
    $sacct = $ad->loadSubAccount($uid);
    if (!isset($sacct[$user])):
        return $response->write("Error: No Sub-Account Found or Unable to load such at the moment<br/>");
    else:
        return $response->write(json_encode($sacct));
    endif;

});

$app->post('/recoverpass', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);

    $is_user = $ad->verifyUserExist($user);

    if ($is_user == 0) :
        //does not exist, verify if Admin
        $is_admin = $ad->verifyAdminExist($user);
        if ($is_admin == 0) :
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Invalid Username, Please verify and try again later!"]));
        else:
            if ($is_admin == 2) :
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Account has been disabled! Contact Administrator"]));
            endif;
        endif;
    else:
        if ($is_user == 2) :
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Account has been disabled! Contact Administrator"]));
        endif;
    endif;

    //Get Message
    $raw_msg = $ad->getCannedMessage("PASS_RESET_REQUEST");

    if ($is_user) :
        $user_det = $ad->loadClientRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    elseif ($is_admin) :
        $user_det = $ad->loadAdminRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    endif;

    $tk = new Password_Generator();
    $token = $tk->generate(45, 60, true, false, true, false);
    $entoken = base64_encode($token);
    $enuser = $tk->generate(3,3) . base64_encode($user);

    //Store Token
    $save = $ad->savePResetToken($user, $token);

    if ($save == 1) :

        $url = SERVER_URL . RECOVERY_URL . "";

        $ddate = date("D, jS F, Y H:i:s T");

        $msg = sprintf($raw_msg, $fullname, $user, $url, $entoken, $enuser, $user, $ddate);

        $sent = $ad->sendEmail($email, EMAIL_SENDER, "Error: Password Reset Request on FiberOne Online (Via Mobile App)", $msg);
        if ($sent):
            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Password reset link sent to your mail on record [$email]"]));
        else: 
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Unable to send Password Reset Link at this time."]));
        endif;
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>$save]));
    endif;
});

$app->post('/recoverpassV2', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);

    $is_user = $ad->verifyUserExist($user);

    if ($is_user == 0) :
        //does not exist, verify if Admin
        $is_admin = $ad->verifyAdminExist($user);
        if ($is_admin == 0) :
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Invalid Username, Please verify and try again later!"]));
        else:
            if ($is_admin == 2) :
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Account has been disabled! Contact Administrator"]));
            endif;
        endif;
    else:
        if ($is_user == 2) :
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Account has been disabled! Contact Administrator"]));
        endif;
    endif;

    //Get Message
    $raw_msg = $ad->getCannedMessage("PASS_RESET_REQUEST_TOKEN");

    if ($is_user) :
        $user_det = $ad->loadClientRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    elseif ($is_admin) :
        $user_det = $ad->loadAdminRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    endif;

    $mtoken = $token = $ad->getActivePResetToken($user);
    $tk = new Password_Generator();
    if ($token == 0) {        
        $token = $tk->generate(6, 6, false, false, true, false);
    }
    $entoken = base64_encode($token);
    $enuser = $tk->generate(3,3) . base64_encode($user);

    //Store Token
    if ($mtoken == 0) { 
        $save = $ad->savePResetToken($user, $token);
    } else { $save = 1; }

    if ($save == 1) :

        $url = SERVER_URL . RECOVERY_URL . "";

        $ddate = date("D, jS F, Y H:i:s T");

        $msg = sprintf($raw_msg, $fullname, $user, $url, $entoken, $enuser, $token, $user, $ddate);

        $sent = $ad->sendEmail($email, EMAIL_SENDER, "Password Reset Request on FiberOne Online (Via Mobile App)", $msg);
        if ($sent):
            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Please check your mail for Reset Code"]));
        else: 
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Error: Unable to send Code at this time."]));
        endif;
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>$save]));
    endif;
});

$app->post('/verifyResetToken', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $tk = filter_var($data['tk'], FILTER_SANITIZE_STRING);
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);

	$is_user = $ad->verifyUserExist($user);

    if ($is_user == 0) :
        //does not exist, verify if Admin
        $is_admin = $ad->verifyAdminExist($user);
        if ($is_admin == 0) :
            return $response->withJson(["STATUS"=>0, "MSG"=>"Error: Invalid Username, Please verify and try again later!"]);
        else:
            if ($is_admin == 2) :
                return $response->withJson(["STATUS"=>0, "MSG"=>"Error: Account has been disabled! Contact Administrator"]);
            endif;
        endif;
    else:
        if ($is_user == 2) :
            return $response->withJson(["STATUS"=>0, "MSG"=>"Error: Account has been disabled! Contact Administrator"]);
        endif;
    endif;

	//Get Message
    // $raw_msg = $ad->getCannedMessage("PASS_RESET_SUCCESS");
//     $admin_user = 0;

//     if ($is_user) :
//         $user_det = $ad->loadClientRec($user)[$user];
//         $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
//         $email = $user_det["EMAIL"];
//     elseif ($is_admin) :
//         $user_det = $ad->loadAdminRec($user)[$user];
//         $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
//         $email = $user_det["EMAIL"];
//         $admin_user = 1;
//     endif;
    
    if ($ad->verifyPResetToken($user, $tk)) :
		return $response->withJson(["STATUS"=>1, "MSG"=>"Token Validated!"]);
	else:
		return $response->withJson(["STATUS"=>0, "MSG"=>"Invalid/Expired Token"]);
	endif;

});


$app->post('/resetpassV2', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $tk = filter_var($data['tk'], FILTER_SANITIZE_STRING);
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $pass = filter_var($data['pass'], FILTER_SANITIZE_STRING);

    $is_user = $ad->verifyUserExist($user);

    if ($is_user == 0) :
        //does not exist, verify if Admin
        $is_admin = $ad->verifyAdminExist($user);
        if ($is_admin == 0) :
            return $response->withJson(["STATUS"=>0, "MSG"=>"Error: Invalid Username, Please verify and try again later!"]);
        else:
            if ($is_admin == 2) :
                return $response->withJson(["STATUS"=>0, "MSG"=>"Error: Account has been disabled! Contact Administrator"]);
            endif;
        endif;
    else:
        if ($is_user == 2) :
            return $response->withJson(["STATUS"=>0, "MSG"=>"Error: Account has been disabled! Contact Administrator"]);
        endif;
    endif;

    //Get Message
    $raw_msg = $ad->getCannedMessage("PASS_RESET_SUCCESS");
    $admin_user = 0;

    if ($is_user) :
        $user_det = $ad->loadClientRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    elseif ($is_admin) :
        $user_det = $ad->loadAdminRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
        $admin_user = 1;
    endif;
    
    if ($ad->verifyPResetToken($user, $tk)) :
        //Valid Token
        $resp = $ad->resetPassword($user, $pass, $tk, $admin_user);
        if ($resp == 1):
            $url = SERVER_URL . "";

            $msg = sprintf($raw_msg, $fullname, $user, $url);

            $sent = $ad->sendEmail($email, EMAIL_SENDER, "Password Reset on FiberOne Online (Via Mobile App)", $msg);
            if ($sent):
                return $response->withJson(["STATUS"=>1, "MSG"=>"Success: Password reset successful and update sent to your mail on record [$email]"]);
            else: 
                return $response->withJson(["STATUS"=>1, "MSG"=>"Success: Password reset successful."]);
            endif;
        else:
            return $response->withJson(["STATUS"=>0, "MSG"=>"Error: Password Reset Failed!"]);
        endif;

    else:
        //Invalid
        return $response->withJson(["STATUS"=>0, "MSG"=>"Error: Expired/Invalid Token!"]);
    endif;
});

$app->post('/resetpass', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
//    $uxu = filter_var($data['uxu'], FILTER_SANITIZE_STRING);
    $tk = filter_var(base64_decode(urldecode($data['tk'])), FILTER_SANITIZE_STRING);
    $user = filter_var(base64_decode(substr(urldecode($data['user']), 3)), FILTER_SANITIZE_STRING);
    $pass = filter_var(base64_decode(urldecode($data['pass'])), FILTER_SANITIZE_STRING);

    $is_user = $ad->verifyUserExist($user);

    if ($is_user == 0) :
        //does not exist, verify if Admin
        $is_admin = $ad->verifyAdminExist($user);
        if ($is_admin == 0) :
            return $response->write("Error: Invalid Username, Please verify and try again later!");
        else:
            if ($is_admin == 2) :
                return $response->write("Error: Account has been disabled! Contact Administrator");
            endif;
        endif;
    else:
        if ($is_user == 2) :
            return $response->write("Error: Account has been disabled! Contact Administrator");
        endif;
    endif;

    //Get Message
    $raw_msg = $ad->getCannedMessage("PASS_RESET_SUCCESS");
    $admin_user = 0;

    if ($is_user) :
        $user_det = $ad->loadClientRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
    elseif ($is_admin) :
        $user_det = $ad->loadAdminRec($user)[$user];
        $fullname = $user_det["FIRSTNAME"] . " " . $user_det["LASTNAME"];
        $email = $user_det["EMAIL"];
        $admin_user = 1;
    endif;
    
    if ($ad->verifyPResetToken($user, $tk)) :
        //Valid Token
        $resp = $ad->resetPassword($user, $pass, $tk, $admin_user);
        if ($resp == 1):
            $url = SERVER_URL . "";

            $msg = sprintf($raw_msg, $fullname, $user, $url);

            $sent = $ad->sendEmail($email, EMAIL_SENDER, "Password Reset on FiberOne Online (Via Mobile App)", $msg);
            if ($sent):
                return $response->write("Success: Password reset successful and update sent to your mail on record [$email]");
            else: 
                return $response->write("Success: Password reset successful.");
            endif;
        else:
            return $response->write("Error: Password Reset Failed!");
        endif;

    else:
        //Invalid
        return $response->write("Error: Expired/Invalid Token!");
    endif;
});

$app->post('/requery', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $txnref = filter_var($data['txnref'], FILTER_SANITIZE_STRING);
    
    $vval =  $ad->getTranx4Verification($txnref);
    
    if ($vval['DB_UPDATED'] == 1) :
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Transaction Duplication\nTransaction Ref: $txnref"]));
    endif;
    //upcountry
    $isupcountry = $vval['IS_UPCOUNTRY'];
    if ($isupcountry):
        $privkey = PS_UPC_LIVE_PRIV_KEY;
        $erpacct = PAYSTACK_UPCOUNTRY;
    //    $notifurl = NOTIFICATION_PS_UPCINV_URL;
    else:
        $privkey = PS_LIVE_PRIV_KEY;
        $erpacct = PAYSTACK_RENEWAL;
    //    $notifurl = NOTIFICATION_PS_INV_URL;
    endif;
    $result = array();
    //The parameter after verify/ is the transaction reference to be verified
    $url = VERIFY_PS_URL . $vval['TRANS_ID'];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt(
      $ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $privkey]
    ); //PS_LIVE_PRIV_KEY
    $request = curl_exec($ch);
    curl_close($ch);

    $is_okay = 0;
    $expd = $vval["EXPIRY_DATE"];
    $exp = isExpired($vval["EXPIRY_DATE"]); //echo "<br>$expd :: $exp<br>";
    $nu_expd = $expd;
    $addition = "";
    $validity = 0;
    
    if ($request) {
        $result = json_decode($request, true);
        // print_r($result);
        if($result){
          if($result['data']){
            //something came in
              $respcode = '00';
              $resp = "";
            if($result['data']['status'] == 'success'){
              // the transaction was successful, you can deliver value

    //          echo "Transaction was successful";
                if ( ($vval["REQ_AMOUNT"] == ($result['data']['amount']/100))
                            && ($vval['TRANS_ID'] == $result['data']['reference']) ):

                    $is_okay = 1;

                    $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
                    $exp = isExpired($userdet['EXPIRATION']);
                    $expd = $userdet['EXPIRATION'];
                    $limitcomb = $userdet["LIMITCOMB"];

                    $validity = ($vval["NMONTHS"] >= 12)? ($vval["NMONTHS"]*$userdet["VALIDITY"])+8 : ($vval["NMONTHS"]*$userdet["VALIDITY"]);
                    if ($exp) :
                        $nu_expd = add_date(date("Y-m-d H:i:s"), $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                    else:
                        $nu_expd = add_date($userdet['EXPIRATION'], $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                    endif;
                    $resp = $result['data']['gateway_response'];
                else:
                    $respcode = "ZZ";
                    $resp = $result['data']['gateway_response'] . ": Invalid Amount";
                endif;    

            }else{
              // the transaction was not successful, do not deliver value'
              // print_r($result);  //uncomment this line to inspect the result, to check why it failed.
                return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Transaction was not successful: Last gateway response was: ".$result['data']['gateway_response']]));
              $respcode = "Z0";
              $resp = $result['data']['gateway_response'];
            }

            //Save Transaction
            $pdate = date("Y-m-d H:i:s"); 
            $appDate = date("Y-m-d H:i:s", strtotime($result['data']['transaction_date']));

            $ad->saveTranxResp($result['data']['reference'], $result['data']['authorization']['authorization_code'], 
                                ($result['data']['amount']/100), CURRENCY, $respcode, $resp, $nu_expd, $pdate, 
                                "paystack-".$result['data']['channel'], $appDate,
                                $result['data']['authorization']['last4'], $result['data']['reference'], "", $vval["RAD_USERNAME"]);


            $du = date("jS M, Y g:i:sa T", strtotime($nu_expd));

            if ($is_okay) :
                $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"]*$userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $result['data']['reference'], $exp);
                //Log To ERP
                if ($vval['ERPID']>0) { $ad->sendToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], ($result['data']['amount']/100), $vval["RAD_USERNAME"]."-ESERVICE-{$vval["PACKAGE"]}-Renewal(paystack RequeryMobile)", date("Y-m-d"), $vval['ERP_CODE'], $vval["NMONTHS"], $erpacct, $txnref); } // PAYSTACK_RENEWAL

                //Get Message
                $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS_NEW");
                $url = SERVER_URL . "";
    //            $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $nu_expd, $result['data']['reference'], $result['data']['reference'], $url);
        $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], ($result['data']['amount']/100), $vval["PACKAGE"], $nu_expd, $result['data']['reference'], $result['data']['reference'], $url);

                $sent = $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "Account Renewal on FiberOne Online", $msg);

                //Send Admin Email
                $raw_msg = $ad->getCannedMessage("ADMIN_NOTIFICATION");
                $payDate = $appDate;
                $msg = sprintf($raw_msg, $result['data']['reference'], $resp, $vval["RAD_USERNAME"], $payDate, number_format(($result['data']['amount']/100), 2));

                $adminsent = $ad->sendEmail(PAY_NOTIF_EMAIL, EMAIL_SENDER, "Succesful Transaction on Paystack", $msg);
                
                $mdat = $ad->getDisTransaction($txnref);
                if (isset($mdat)) {
                    return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Successful", "UDATA"=>$mdat]));
                } else {
                    return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
                }  

            endif;
            
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Error: Transaction was not Successful\nTransaction Ref: " . $result['data']['reference'] . 
                "\nReason: " . $result['data']['reference']]));

          }else{
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>$result['message']]));
          }

        }else{
          //print_r($result);
          return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Something went wrong while trying to convert the request"]));
        }
      }else{
        //var_dump($request);
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Something went wrong while executing curl."]));
        
      }
    
});

$app->post('/requery_interswitch', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $txnref = filter_var($data['txnref'], FILTER_SANITIZE_STRING);
    
    $vval =  $ad->getTranx4Verification($txnref);
    $product_id = PRODUCTID;
    $hashh = $ad->hashGeneratorNew($product_id . $txnref . HASH_KEY);
    $url = "https://webpay.interswitchng.com/collections/api/v1/gettransaction.json?amount=" . ($vval['REQ_AMOUNT']*100) . "&transactionreference=".$vval['TRANS_ID']."&productid=". $product_id;  
    $vArray = curlURL($url, $hashh);
    $expd = $vval["EXPIRY_DATE"];
    $exp = isExpired($vval["EXPIRY_DATE"]); //echo "<br>$expd :: $exp<br>";
    $nu_expd = $expd;
    $validity = 0;
    $is_okay = 0;
    
    if ($vArray->MerchantReference == $txnref) :
        //Response Integrity Passed
        if ($vArray->ResponseCode == "00") :
            //Transaction Successfully but verify amount paid
            if ($vval["REQ_AMOUNT"] == ($vArray->Amount/100)) :
                //Everything is Okay
                $is_okay = 1;
                $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
                $exp = isExpired($userdet['EXPIRATION']);
                $expd = $userdet['EXPIRATION'];
                $limitcomb = $userdet["LIMITCOMB"];
                $validity = ($vval["NMONTHS"] >= 12)? ($vval["NMONTHS"]*$userdet["VALIDITY"])+8 : ($vval["NMONTHS"]*$userdet["VALIDITY"]);
                if ($exp) :
                    $nu_expd = add_date(date("Y-m-d H:i:s"), $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                else:
                    $nu_expd = add_date($userdet['EXPIRATION'], $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                endif;

            else:
                //Wrong Amount Paid
                $vArray->MerchantReference = ($vArray->MerchantReference=="")? $txnref : $vArray->MerchantReference;
            endif;
        else:
            //Transaction Failed

        endif;
    else:
        //Response Integrity Failed
        $vArray->MerchantReference = ($vArray->MerchantReference=="")? $txnref : $vArray->MerchantReference;
    endif;

    //Save Transaction
    $pdate = date("Y-m-d H:i:s"); 
    $appDate = date("Y-m-d H:i:s", strtotime($vArray->TransactionDate));
    $ad->saveTranxResp($vArray->MerchantReference, $vArray->PaymentReference, ($vArray->Amount/100), CURRENCY, 
                        $vArray->ResponseCode, $vArray->ResponseDescription, $nu_expd, $pdate, "webpay", $appDate,
                        $vArray->CardNumber, $vArray->RetrievalReferenceNumber, "", $vval["RAD_USERNAME"]);

    if ($is_okay) :
        $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"]*$userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $vArray->MerchantReference, $exp);
        //Log To ERP
        if ($vval['ERPID']>0) { $ad->sendToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], ($vArray->Amount/100), $vval["RAD_USERNAME"]."-ESERVICE-{$vval["PACKAGE"]}-Renewal(webpay Mobile Requery)", date("Y-m-d"), $vval['ERP_CODE'], $vval["NMONTHS"], INTERSWITCH_RENEWAL, $txnref); }
            
        //Get Message
        $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS_NEW");
        $url = SERVER_URL . "";
        //$msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $nu_expd, $vArray->MerchantReference, $vArray->PaymentReference, $url);
        $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], ($vArray->Amount/100), $vval["PACKAGE"], $nu_expd, $vArray->MerchantReference, $vArray->PaymentReference, $url);

        $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "Account Renewal on FiberOne Online (Mobile)", $msg);

//        return $response->write("Success: Approved Successfully" .
//        "\nTransaction Ref: " . $vArray->MerchantReference . "\n" .
//        "Payment Ref: " . $vArray->PaymentReference);
        $mdat = $ad->getDisTransaction($radlst);
    
        if (isset($mdat)) {
            return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Successful", "UDATA"=>$mdat]));
        } else {
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
        }  
    endif;

    return $response->write(json_encode(["STATUS"=>-1, "MSG"=>"Transaction was not Successful\nTransaction Ref: " . $vArray->MerchantReference . 
          "\nReason: " . $vArray->ResponseDescription]));
//    return $response->write("Error: Transaction was not Successful\nTransaction Ref: " . $vArray->MerchantReference . 
//          "\nReason: " . $vArray->ResponseDescription);

});

$app->get('/getprofile/{username}', function ($request, $response, $args) {
    global $ad;
    
    $user= (string)$args['username'];
    
    $prof = $ad->loadUserProfile($user);
    $ret = ["FIRSTNAME"=>$prof->firstname, "LASTNAME"=>$prof->lastname, "ADDRESS"=>$prof->address,
            "CITY"=>$prof->city, "STATE"=>$prof->state, "EMAIL"=>$prof->email, "MOBILE"=>$prof->mobile, 
            "USERNAME"=>$prof->username];
    
    if (isset($prof)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$ret])); //a, "UDATASTR" =>$mdat
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }
});

$app->get('/getstates', function ($request, $response, $args) {
    global $ad;
    
    $prof = $ad->loadStates();
    //$ret = ["STATECODE"=>$prof->STATECODE, "STATE"=>$prof->STATENAME, "STATENAME"=>$prof->STATENAME];
    
    if (isset($prof)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$prof])); //a, "UDATASTR" =>$mdat
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }
});

$app->post('/savePushUUID', function ($request, $response) {
    global $ad;
    $ret = -1;
    
    $data = $request->getParsedBody();
    $userid = filter_var($data['userid'], FILTER_SANITIZE_NUMBER_INT);
    $uuid = filter_var($data['uuid'], FILTER_SANITIZE_STRING);
    
    $ret = $ad->savePushUUID($userid, $uuid);


    if ($ret == 1) :
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Successful!"]));
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Failed!"]));
    endif;
});

$app->get('/getAdBanners', function ($request, $response, $args) {
    global $ad;
    
    $profs = $ad->loadAdBanner(0, 1);
    $prof = [];
    foreach ($profs as $k=>$p):
        $prof[] = ["AD_ID"=>$p["AD_ID"], "AD_IMG"=>SERVER_URL . $p["AD_IMG"], 
            "AD_CONTENT_URL"=>$p["AD_CONTENT_URL"], "DATEADDED"=>$p["DATEADDED"]];
    endforeach;
    if (isset($prof) && count($prof)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$prof]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }
});

$app->get('/getNews', function ($request, $response, $args) {
    global $ad;
    
    $profs = $ad->loadMobileNews(0, 1);
    $prof = [];
    foreach ($profs as $k=>$p):
        $prof[] = ["NEWS_ID"=>$p["NEWS_ID"], "NEWS_IMG_URL"=>SERVER_URL . $p["NEWS_IMG_URL"], "NEWS_URL"=>$p["NEWS_URL"],
            "NEWS_TITLE"=>$p["NEWS_TITLE"], "DATEADDED"=>$p["DATEADDED"], "NEWS_SUMMARY"=>$p["NEWS_SUMMARY"], 
            "DATEADDED_FORMAT"=>date("d-M-Y", strtotime($p["DATEADDED"]))];
    endforeach;
    if (isset($prof) && count($prof)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$prof]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }
});

$app->get('/getRelocationRequests/{uname}', function ($request, $response, $args) {
    global $ad;
    
    $username = strtolower((string)$args['uname']);
    $reloc = $ad->getRelocationRequest($username);
    
    if (isset($reloc)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$reloc]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getRelocationRequests', function ($request, $response, $args) {
    global $ad;
    
    $reloc = $ad->getRelocationRequest();
    
    if (isset($reloc)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$reloc]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->post('/saveRelocationRequest', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $email = filter_var($data['email'], FILTER_SANITIZE_STRING);
    $phone = filter_var($data['phone'], FILTER_SANITIZE_STRING);
    $old_addy = filter_var($data['oldAddress'], FILTER_SANITIZE_STRING);
    $new_addy = filter_var($data['newAddress'], FILTER_SANITIZE_STRING);
    
    $reloc = $ad->createRelocationRequest($user, $phone, $email, $old_addy, $new_addy);
    
    if (isset($reloc)) {
    	$raw_msg = "Dear Esteemed Customer,
        
        Thank you for reaching out to us at FiberOne Broadband.
        
        Please be informed that your request has been received for processing and as such you will be contacted by one of our Customer Experience team shortly.
        
        Thank you for choosing FiberOne Broadband.";

        $ad->sendEmail($email, EMAIL_SENDER, "Relocation Request on FiberOne Online (Mobile)", $raw_msg);
        
        $raw_msg = "Dear Team,
        There is a new relocation Request from $user as found below; 
            
        <strong>User:</strong> $user   
        <strong>Email:</strong> $email   
        <strong>Phone:</strong> $phone   
        <strong>Old Address:</strong> $old_addy   
        <strong>New Address:</strong> $new_addy 
            
        Thank you.
         ";
		/* EMAIL_SENDER */
        $ad->sendEmail(ADMIN_NOTIF_EMAIL, $email, "Relocation Request on FiberOne Online (Mobile) - $user", $raw_msg);
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Submitted Successfully. Our customer experience team will be in touch shortly."]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->post('/savePlanSwitchRequest', function ($request, $response) {
    global $ad;
    
    $data = $request->getParsedBody();
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
    $curPlan = filter_var($data['currentPlanID'], FILTER_SANITIZE_NUMBER_INT);
    $newPlan = filter_var($data['newPlanID'], FILTER_SANITIZE_NUMBER_INT);
    $cur_plan = filter_var($data['currentPlan'], FILTER_SANITIZE_STRING);
    $new_plan = filter_var($data['newPlanName'], FILTER_SANITIZE_STRING);
    
    $reloc = $ad->createPlanSwitchRequest($user, $curPlan, $newPlan);
    
    if ($reloc === 1) {
    	$raw_msg = "Dear Esteemed Customer,
        
        Thank you for reaching out to us at FiberOne Broadband.
        
        Please be informed that your request has been received for processing and as such you will be contacted by one of our Customer Experience team shortly.
        
        Thank you for choosing FiberOne Broadband.";

        $ad->sendEmail($email, EMAIL_SENDER, "Plan Switch Request on FiberOne Online (Mobile)", $raw_msg);
        
        $raw_msg = "Dear Team,
        There is a new Plan Switch Request from $user as found below; 
            
        <strong>User:</strong> $user     
        <strong>Current Plan:</strong> $cur_plan   
        <strong>New Plan:</strong> $new_plan 
            
        Thank you.
         ";
		/* EMAIL_SENDER */
        $ad->sendEmail(ADMIN_NOTIF_EMAIL, $email, "Plan Switch Request on FiberOne Online (Mobile) - $user", $raw_msg);
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Submitted Successfully. Our customer experience team will be in touch shortly."]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getPlanSwitchHistory/{uname}', function ($request, $response, $args) {
    global $ad;
    
    $username = strtolower((string)$args['uname']);
    $reloc = $ad->getPlanSwitchHistory($username);
    
    if (isset($reloc)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$reloc]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});


/*** TICKETS ****/
$app->get('/getmytickets/{uname}', function ($request, $response, $args) {
    global $ad, $db;
    
    $tck = new Tickets($db, $ad);
    
    $username = strtolower((string)$args['uname']);
    $mytcks = $tck->getTicketList($username);
    
    if (isset($mytcks)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$mytcks]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getticketdetails/{tckid}', function ($request, $response, $args) {
    global $ad, $db;
    
    $tck = new Tickets($db, $ad);
    
//    $username = strtolower((string)$args['uname']);
    $tid = ((int)$args['tckid']);
    $mytck = $tck->getDisTicket($tid);
    
    if (isset($mytck)) {
        $myresp = $tck->getTicketDetails($tid);
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$mytck, "UDETAILS"=>$myresp]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getdisticket/{uname}/{tid}', function ($request, $response, $args) {
    global $ad, $db;
    
    $tck = new Tickets($db, $ad);
    
    $username = strtolower((string)$args['uname']);
    $tid = ((int)$args['tid']);
    $mytck = $tck->getDisTicket($tid);
    
    if (isset($mytcks)) {
        if (isset($mytck["USERNAME"]) && $mytck["USERNAME"] != $username) :
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Invalid Data."]));
        endif;
        $myresp = $tck->getTicketDetails($tid);
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$mytcks, "UDETAILS"=>$myresp]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->get('/getdepts', function ($request, $response, $args) {
    global $ad, $db;
    
    $tck = new Tickets($db, $ad);
    
    $mytcks = $tck->getDepts();
    
    if (isset($mytcks)) {
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Retrieved", "UDATA"=>$mytcks]));
    } else {
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"An error was encountered."]));
    }    
});

$app->post('/cticket', function ($request, $response) {
    global $ad, $db;
    
    $tck = new Tickets($db, $ad);
    //return $response->write("ISWRITE: " . is_writable(dirname("/home/kkontech/pubfiles1/support_files/tr.jpg")) . "|". dirname("/home/kkontech/pubfiles1/support_files/tr.jpg"));
    $data = $request->getParsedBody();
    //return $response->write(json_encode($request->getParsedBody()));
    //$title, $content, $nufile, $userid, $deptid, $priority
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $userid = filter_var($data['userid'], FILTER_SANITIZE_NUMBER_INT);
    $fileSent = filter_var($data['filesent'], FILTER_SANITIZE_NUMBER_INT);
    $title = filter_var($data['title'], FILTER_SANITIZE_STRING);
    $content = filter_var($data['content'], FILTER_SANITIZE_STRING);
    $deptid = filter_var($data['deptid'], FILTER_SANITIZE_NUMBER_INT);
    $priority = filter_var($data['priority'], FILTER_SANITIZE_NUMBER_INT);
	
    if ($fileSent) :
        $files = $request->getUploadedFiles(); //$content .= " | Filesent:$fileSent | " .json_encode($files);
        if (empty($files['tfile'])) :
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"File not found."]));
        endif;
        $tfile = $files['tfile'];
        if ($tfile->getError() === UPLOAD_ERR_OK) :
            $dated = date("dmYHis");
            //$uploadFileName = $tfile->getClientFilename();

            //$ext = pathinfo($uploadFileName, PATHINFO_EXTENSION);
            $nufile = "support_files/{$user}_{$dated}.jpg";
            $nufiles = "/home/kkontech/pubv2/support_files/{$user}_{$dated}.jpg";

            $nutfiles = "/home/kkontech/pubv2/support_files/{$user}_{$dated}_thumb.jpg";
            $tfile->moveTo($nufiles);
            $image = new ImageResize($nufiles);
            $image->resizeToLongSide(100);
            $image->save($nutfiles);
        else:
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"File Missing."]));
        endif;
    else:
        $nufile = "";
    endif;
    
    $resp = $tck->createTicket($title, $content, $nufile, $userid, $deptid, $priority);
    if ($resp):
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Ticket Created"]));
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Failed to create Ticket."]));
    endif;


});

$app->post('/scomment', function ($request, $response) {
    global $ad, $db;
    
    $tck = new Tickets($db, $ad);
    
    $data = $request->getParsedBody();
    //$title, $content, $nufile, $userid, $deptid, $priority
    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $userid = filter_var($data['userid'], FILTER_SANITIZE_NUMBER_INT);
    $fileSent = filter_var($data['filesent'], FILTER_SANITIZE_NUMBER_INT);
//    $title = filter_var($data['title'], FILTER_SANITIZE_STRING);
    $content = filter_var($data['content'], FILTER_SANITIZE_STRING);
    $ticketID = filter_var($data['ticketid'], FILTER_SANITIZE_NUMBER_INT);
//    $deptid = filter_var($data['deptid'], FILTER_SANITIZE_NUMBER_INT);
//    $priority = filter_var($data['priority'], FILTER_SANITIZE_NUMBER_INT);

    if ($fileSent) :
        $files = $request->getUploadedFiles();
        if (empty($files['tfile'])) :
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"File not found."]));
        endif;
        $tfile = $files['tfile'];
        if ($tfile->getError() === UPLOAD_ERR_OK) :
            $dated = date("dmYHis");
            //$uploadFileName = $tfile->getClientFilename();

            //$ext = pathinfo($uploadFileName, PATHINFO_EXTENSION);
            $nufile = "support_files/{$user}_{$dated}.jpg";
            $nufiles = "/home/kkontech/pubv2/support_files/{$user}_{$dated}.jpg";

            $nutfiles = "/home/kkontech/pubv2/support_files/{$user}_{$dated}_thumb.jpg";
            $tfile->moveTo($nufiles);
            $image = new ImageResize($nufiles);
            $image->resizeToLongSide(100);
            $image->save($nutfiles);
        else:
            return $response->write(json_encode(["STATUS"=>0, "MSG"=>"File Missing."]));
        endif;
    else:
        $nufile = "";
    endif;
    
    $resp = $tck->addComment($ticketID, $content, $nufile, $tck::RESPONSE_COMMENT, $userid, "NULL", $userid);
//    $resp = $tck->createTicket($title, $content, $nufile, $userid, $deptid, $priority);
    if ($resp):
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Comment Saved"]));
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Failed to save Comment."]));
    endif;


});

$app->post('/tckclose', function ($request, $response) {
    global $ad, $db;
    
    $tck = new Tickets($db, $ad);
    
    $data = $request->getParsedBody();
//    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $userid = filter_var($data['userid'], FILTER_SANITIZE_NUMBER_INT);
    $ticketID = filter_var($data['ticketid'], FILTER_SANITIZE_NUMBER_INT);

    $nufile = $content = "";

    
    $resp = $tck->addComment($ticketID, $content, $nufile, $tck::RESPONSE_CLOSE, $userid, "NULL", $userid);
//    $resp = $tck->createTicket($title, $content, $nufile, $userid, $deptid, $priority);
    if ($resp):
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Ticket Closed"]));
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Failed to close Ticket."]));
    endif;


});

$app->post('/srating', function ($request, $response) {
    global $ad, $db;
    
    $tck = new Tickets($db, $ad);
    
    $data = $request->getParsedBody();
//    $user = filter_var($data['user'], FILTER_SANITIZE_STRING);
    $userid = filter_var($data['userid'], FILTER_SANITIZE_NUMBER_INT);
    $tck_resp_id = filter_var($data['tckrespid'], FILTER_SANITIZE_NUMBER_INT);
    $ctype = filter_var($data['ctype'], FILTER_SANITIZE_STRING);
    $score = filter_var($data['score'], FILTER_SANITIZE_NUMBER_INT);
    
    switch ($ctype) {
            case "SATISFACTION":
                $comtype = $tck::COMMENT_SATISFACTION;
                break;
            case "COURTESY":
                $comtype = $tck::COMMENT_COURTESY;
                break;
            case "TIMELINESS":
                $comtype = $tck::COMMENT_TIMELINESS;
                break;
            case "OVERALL":
                $comtype = $tck::COMMENT_OVERALL;
                break;
            default:
                echo "Error: Unknown Error1";
                exit();
                break;
        } 

    $resp = $tck->rateResponse($tck_resp_id, $comtype, $score);
    if ($resp):
        return $response->write(json_encode(["STATUS"=>1, "MSG"=>"Rating Saved"]));
    elseif ($resp):
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Comment not found"]));
    else:
        return $response->write(json_encode(["STATUS"=>0, "MSG"=>"Failed to save Rating."]));
    endif;

});



/**** END TICKETS ****/




// Catch-all route to serve a 404 Not Found page if none of the routes match
// NOTE: make sure this route is defined last
$app->map(['GET', 'POST', 'PUT', 'DELETE', 'PATCH'], '/{routes:.+}', function($req, $res) {
    $handler = $this->notFoundHandler; // handle using the default Slim page not found handler
    return $handler($req, $res);
});