<?php


/**
 * Description of AddressCoverage
 *
 * @author opmat
 */
class AddressCoverage {
    
    const BASE_URL = "https://coverage.fob.ng/api";
    const ADDRESS_CHECK_URL = "/checker";
    const COVERAGE_CHECK_URL = "/confirmchecker";
    
    public function checkAddress($address) {
        if(stristr($address, 'Nigeria') === FALSE) {
            $address .= ", Nigeria";
        } 
        $url = $this::BASE_URL . $this::ADDRESS_CHECK_URL . "?address=" . urlencode($address);
        $resp = json_decode($this->__curlURL($url), TRUE); //return ($resp);// exit();
        $ret = []; $i=0;
        foreach ($resp['data'] as $res) { 
        	$re = [];
            $re['text'] = $res['formatted_address'];
            $re['id'] = json_encode(array_merge($res['geometry']['location'], ['address'=>$res['formatted_address']]));
        	$re['address'] = $res['formatted_address'];
                $re['location'] = $res['geometry']['location'];
        	$ret[]=$re;
        }
        
        return $ret;
    }
    
    public function checkCoverage($lat, $lon) {
        $url = $this::BASE_URL . $this::COVERAGE_CHECK_URL . "?lat=$lat&lon=$lon";
        $resp = json_decode($this->__curlURL($url), TRUE);
        
        //"FIBERONE BROADBAND is available in your area"
        return $resp;
    }
    
    private function __curlURL($strURL, $method='GET', $postdata=[], $header=[]) {
        $ch = curl_init();
        // curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array_merge([
        //         "X-Requested-With: XMLHttpRequest", 
        //         "Content-type: application/json"],
        //         $header));
        curl_setopt($ch, CURLOPT_URL, $strURL);
        
        if (in_array($method, ['POST','PUT'])):
            ($method=="POST")? curl_setopt($ch, CURLOPT_POST, true) : curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
        endif;
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE); 

        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1);
        
        $server_output = curl_exec($ch);
        $info = curl_getinfo($ch);
        curl_close($ch);
        if($info['http_code'] == 200) {
          return $server_output;
        } else {
          return $info;
        }
    }
}
