<?php

if (file_exists("config2.php")) {
    require_once "config2.php";
} elseif (file_exists("../config2.php")) {
    require_once "../config2.php";
} elseif (file_exists("../../config2.php")) {
    require_once "../../config2.php";
}

if (file_exists("includes/common_functions.php")) {
    require_once "includes/common_functions.php";
} elseif (file_exists("../includes/common_functions.php")) {
    require_once "../includes/common_functions.php";
} elseif (file_exists("../../includes/common_functions.php")) {
    require_once "../../includes/common_functions.php";
}

if (file_exists("includes/opener.php")) {
    require_once "includes/opener.php";
} elseif (file_exists("../includes/opener.php")) {
    require_once "../includes/opener.php";
} elseif (file_exists("../../includes/opener.php")) {
    require_once "../../includes/opener.php";
} elseif (file_exists("../../../includes/opener.php")) {
    require_once "../../../includes/opener.php";
} 
/**
 * Description of AdminDashboardReport
 *
 * @author opmat
 */
class AdminDashboardReport {
    
    private $db;
    private $sid;
            
    public function __construct($dbconnection) {
        $this->db = $dbconnection;
        $this->sid = session_id();
    } 
    
    public function getLocations() {
        $sql = "SELECT DISTINCT PLAN_LOCATION FROM tbl_plans ORDER BY PLAN_LOCATION";
        $some_sth = $this->db->select($sql);
        $plans = [];
        while ( $row = $some_sth->fetch_object() ) {
            $plans[] = $row->PLAN_LOCATION;
        }
        return $plans;
    }
    
    public function logReportRequest($report, $requestParams, $requester, $requester_email, $request_time) {
        $sql = "INSERT INTO `tbl_dashboard_report_log` 
                (`REPORT`, `REQUEST`, `REQUESTER`, `REQUESTER_EMAIL`, REQUEST_TIME) 
                VALUES 
                (?, ?, ?, ?, ?)";
        $in_id = $this->db->insert($sql, 'sssss', $report, $requestParams, $requester, $requester_email, $request_time);
        if ($in_id) :
            return $in_id;
        endif;
        return 0;
    }
    
    public function setReportGenCompleted($logId, $completion_time, $mail_status) {
        $upd = "UPDATE tbl_dashboard_report_log SET COMPLETION_TIME=?, MAIL_STATUS=? WHERE REPORT_ID=?";
        $this->db->execute_query($upd, "sii", $completion_time, $mail_status, $logId);
    }
    
    public function getAllCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = "LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID WHERE PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT ru.username, enableuser, firstname, lastname, email, staticipcpe, 
                    company, mobile, expiration, ru.srvid, rs.srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff, OLT_NAME, GPON_NAME, INTERFACE, SERIALNO, VLAN
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              LEFT JOIN tbl_usrloc tul ON tul.USERNAME=ru.username
              LEFT JOIN tbl_usrolt tuol ON tuol.USERNAME=ru.username
              LEFT JOIN tbl_olt tol ON tuol.OLT=tol.OLT_ID
              LEFT JOIN tbl_gpon tg ON tuol.GPON=tg.GPON_ID
              $addon";
        $some_sth = $this->db->select($sql);
        $rows = [];
        while ($row = $some_sth->fetch_object()) :
            $rows[] = ["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "CREATEDON"=>$row->createdon, "IP"=>"'".$row->staticipcpe,
                "EXPIRATION"=>$row->expiration, "LASTLOGOFF"=>$row->lastlogoff, "OLT_NAME"=>$row->OLT_NAME, 
                "GPON_NAME"=>$row->GPON_NAME, "INTERFACE"=>$row->INTERFACE, "SERIALNO"=>$row->SERIALNO, "VLAN"=>$row->VLAN];
        endwhile;
        
        return $rows;
    }
    
    public function getOnlineCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT ru.username, enableuser, firstname, lastname, email, staticipcpe, 
                    company, mobile, expiration, ru.srvid, rs.srvname, address, city, state,
                    PLAN_LOCATION, rt.acctstarttime, acctsessiontime
                FROM radacct rt
                    LEFT JOIN rm_users ru ON rt.username = ru.username
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                WHERE rt.acctstoptime IS NULL
              $addon";
        $some_sth = $this->db->select($sql);
        $rows = [];
        while ($row = $some_sth->fetch_object()) :
            $rows[] = ["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "PLAN_LOCATION"=>$row->PLAN_LOCATION, 
                "EXPIRATION"=>$row->expiration, "LOGIN_TIME"=>$row->acctstarttime, "IP"=>"'".$row->staticipcpe, 
                "SESSION_TIME(s)"=>$row->acctsessiontime];
        endwhile;
        
        return $rows;
    }
    
    public function getActiveCustomers($location='', $getComplimentaryAcc=0, $complimentaryType='') {
        $locations = $this->getLocations();
        $addon = $groupBy = $addPlanField = $compClause = $compTypeClause = $compTypeField = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " WHERE PLAN_LOCATION='$location'";
        endif;
        if ($getComplimentaryAcc):
            $compClause = " INNER JOIN tbl_comp_account tca ON ru.username=tca.USERNAME ";
            $compTypeField = ", ACCOUNT_TYPE";
            if($complimentaryType && in_array($complimentaryType, ['C', 'S'])):
                $compTypeClause = " AND ACCOUNT_TYPE = '". strtoupper($complimentaryType) ."'";
            endif;
        endif;
        $sql = "SELECT username, enableuser, firstname, lastname, email, staticipcpe, 
                    company, mobile, expiration, srvid,srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff $compTypeField
            FROM (
            SELECT ru.username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, PLAN_LOCATION $compTypeField
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              $compClause
		$addon					
                ) AS tmp
  	    WHERE 1 AND (acctype IN ( '0', '1', '2', '3', '4', '5' )) AND enableuser = 1
                AND
              (limitdl = 0 OR IF (limitdl =1, downlimit -
              (SELECT COALESCE(SUM(acctoutputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) -
              (SELECT COALESCE(SUM(dlbytes), 0) 
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
              AND
              (limitul = 0 OR IF (limitul =1, uplimit -
              (SELECT COALESCE(SUM(acctinputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) -
              (SELECT COALESCE(SUM(ulbytes ), 0)
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
              AND
              (limitcomb = 0 OR IF (limitcomb =1, comblimit -
              (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
              FROM radacct WHERE radacct.username = tmp.username) +
              (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
              AND
              (limituptime = 0 OR IF (limituptime=1, uptimelimit -
              (SELECT COALESCE(SUM(acctsessiontime), 0)
              FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(acctsessiontime), 0) 
              FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) > 0)
              AND
              (limitexpiration = 0 OR IF (limitexpiration=1, UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()), 1) > 0)
              $compTypeClause  ";
        $some_sth = $this->db->select($sql);
        $rows = [];
        while ($row = $some_sth->fetch_object()):
    		$rowss = [];
            if ($getComplimentaryAcc):
                $rowss['ACCOUNT_TYPE'] = $row->ACCOUNT_TYPE;
            endif;
            $rows[] = array_merge(["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "CREATEDON"=>$row->createdon, "IP"=>"'".$row->staticipcpe,
                "EXPIRATION"=>$row->expiration, "LASTLOGOFF"=>$row->lastlogoff], $rowss);

        endwhile;
            
        return $rows;   
        
    }
    
    public function getExpiredCustomersFromTable($tablename, $location='', $daysExpired='', $getComplimentaryAcc=0, 
                    $complimentaryType='') {
        $locations = $this->getLocations();
        $addon = $expiredClause = $groupBy = $addPlanField = $compClause = $compTypeClause = $compTypeField = "";
        $expiredDays = " AND DAYS_EXPIRED_ROUND >= 0";
        
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        
        if ($getComplimentaryAcc):
            $compClause = " INNER JOIN tbl_comp_account tca ON t.username=tca.USERNAME ";
            $compTypeField = ", ACCOUNT_TYPE";
            if($complimentaryType && in_array($complimentaryType, ['C', 'S'])):
                $compTypeClause = " AND ACCOUNT_TYPE = '". strtoupper($complimentaryType) ."'";
            endif;
        endif;
        if ($daysExpired == "0-30"):
            $expiredDays = " AND DAYS_EXPIRED_ROUND <= 30";
        elseif ($daysExpired == "31-60"):
            $expiredDays = " AND DAYS_EXPIRED_ROUND BETWEEN 31 AND 60";
        elseif ($daysExpired == "31-89"):
            $expiredDays = " AND DAYS_EXPIRED_ROUND BETWEEN 31 AND 89";
        elseif ($daysExpired == ">=90" || $daysExpired == "Churn" ):
            $expiredDays = " AND DAYS_EXPIRED_ROUND >= 90";
        endif;
        
        $sql = "SELECT t.username, enableuser, firstname, lastname, email, staticipcpe, 
                    company, mobile, expiration, srvid, srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff, PLAN_TYPE, DAYS_EXPIRED_ROUND, DAYS_EXPIRED $compTypeField
                FROM `$tablename` t
                $compClause
                WHERE 1 $addon $compTypeClause $expiredDays
                ";
        $some_sth = $this->db->select($sql);
        $rows = [];
        while ($row = $some_sth->fetch_object()):
    		$rowss = [];
            if ($getComplimentaryAcc):
                $rowss['ACCOUNT_TYPE'] = $row->ACCOUNT_TYPE;
            endif;
            $rows[] = array_merge(["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "CREATEDON"=>$row->createdon, "IP"=>"'".$row->staticipcpe,
                "EXPIRATION"=>$row->expiration, "LASTLOGOFF"=>$row->lastlogoff, "PLAN_TYPE"=>$row->PLAN_TYPE, 
                "DAYS_EXPIRED_ROUND"=>$row->DAYS_EXPIRED_ROUND, "DAYS_EXPIRED"=>$row->DAYS_EXPIRED], $rowss);
        endwhile;
            
        return $rows;
        
    }
    
    public function getExpiredCustomers($location='', $daysExpired='', $getComplimentaryAcc=0, 
                    $complimentaryType='') {
        $locations = $this->getLocations();
        $addon = $expiredClause = $groupBy = $addPlanField = $compClause = $compTypeClause = $compTypeField = "";
        $expiredDays = " <= 0";
        
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " WHERE PLAN_LOCATION='$location'";
        endif;
        
        if ($getComplimentaryAcc):
            $compClause = " INNER JOIN tbl_comp_account tca ON ru.username=tca.USERNAME ";
            $compTypeField = ", ACCOUNT_TYPE";
            if($complimentaryType && in_array($complimentaryType, ['C', 'S'])):
                $compTypeClause = " AND ACCOUNT_TYPE = '". strtoupper($complimentaryType) ."'";
            endif;
        endif;
        if ($daysExpired == "0-30"):
            $expiredDays = "BETWEEN -30 AND 0";
            $expiredClause = " AND (((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600)) $expiredDays )";
        elseif ($daysExpired == "31-60"):
            $expiredDays = "BETWEEN -60 AND -31";
            $expiredClause = " AND (((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600)) $expiredDays )";
        elseif ($daysExpired == "31-89"):
            $expiredDays = "BETWEEN -89 AND -31";
            $expiredClause = " AND (((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600)) $expiredDays )";
        elseif ($daysExpired == ">=90" || $daysExpired == "Churn" ):
            $expiredDays = "<= -90";
            $expiredClause = " AND (((UNIX_TIMESTAMP(lastlogoff) - UNIX_TIMESTAMP(NOW()))/(24*3600)) $expiredDays )";
        endif;
        $sql = "SELECT username, enableuser, firstname, lastname, email, staticipcpe, 
                    company, mobile, expiration, srvid, srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff $compTypeField,
IF ((limitdl=1 OR limitul=1 OR limitcomb=1 OR limituptime=1), 'CAPPED', 'UNCAPPED') AS 'PLAN_TYPE',
IF ((limitdl=1 OR limitul=1 OR limitcomb=1 OR limituptime=1), ROUND(-1*((UNIX_TIMESTAMP(COALESCE(lastlogoff,expiration)) - UNIX_TIMESTAMP(NOW()))/(24*3600))), ROUND(-1*((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600))) ) AS 'DAYS_EXPIRED_ROUND',
IF ((limitdl=1 OR limitul=1 OR limitcomb=1 OR limituptime=1), -1*((UNIX_TIMESTAMP(COALESCE(lastlogoff,expiration)) - UNIX_TIMESTAMP(NOW()))/(24*3600)), -1*((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)) ) AS 'DAYS_EXPIRED'
            FROM (
            SELECT ru.username, firstname, lastname, address, city, zip, country, state, phone, mobile, email, company,
              taxid, ru.srvid, ru.downlimit, ru.uplimit, ru.comblimit, ru.expiration,
              ru.uptimelimit, credits, comment, enableuser, staticipcpe, staticipcm, ipmodecpe, ipmodecm, srvname, limitdl,
              limitul, limitcomb, limitexpiration, limituptime, createdon, verifycode, verified, selfreg, acctype, maccm,
              mac, groupid, contractid, contractvalid, ru.owner, srvtype, lastlogoff, PLAN_LOCATION $compTypeField
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              $compClause
		$addon					
                ) AS tmp
  	    WHERE 1 AND (acctype IN ( '0', '1', '2', '3', '4', '5', '6' )) AND enableuser = 1
                AND
              ( (IF (limitdl = 1, downlimit - (SELECT COALESCE(SUM(acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(dlbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 $expiredClause )
                OR 
                (IF (limitul = 1, uplimit - (SELECT COALESCE(SUM(acctinputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) - (SELECT COALESCE(SUM(ulbytes), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 $expiredClause )
                OR
                (IF (limitcomb = 1, comblimit -
                (SELECT COALESCE(SUM(acctinputoctets + acctoutputoctets), 0)
                FROM radacct WHERE radacct.username = tmp.username) +
                (SELECT COALESCE(SUM(ulbytes + dlbytes), 0)
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 $expiredClause )
                OR 
                (IF (limituptime = 1, uptimelimit - (SELECT COALESCE(SUM(acctsessiontime), 0)
                FROM radacct WHERE radacct.username = tmp.username) + (SELECT COALESCE(SUM(acctsessiontime), 0) 
                FROM rm_radacct WHERE rm_radacct.username = tmp.username) , 1) <= 0 $expiredClause )
                OR 
                IF (limitexpiration=1, ((UNIX_TIMESTAMP(expiration) - UNIX_TIMESTAMP(NOW()))/(24*3600)), 1) $expiredDays )
                $compTypeClause "; //echo $sql;
        $some_sth = $this->db->select($sql);
        $rows = [];
        while ($row = $some_sth->fetch_object()):
    		$rowss = [];
            if ($getComplimentaryAcc):
                $rowss['ACCOUNT_TYPE'] = $row->ACCOUNT_TYPE;
            endif;
            $rows[] = array_merge(["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "CREATEDON"=>$row->createdon,
                "EXPIRATION"=>$row->expiration, "LASTLOGOFF"=>$row->lastlogoff, "PLAN_TYPE"=>$row->PLAN_TYPE, "IP"=>"'".$row->staticipcpe, 
                "DAYS_EXPIRED_ROUND"=>$row->DAYS_EXPIRED_ROUND, "DAYS_EXPIRED"=>$row->DAYS_EXPIRED], $rowss);
        endwhile;
            
        return $rows;
        
    }
    
    public function getPausedCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT ru.username, enableuser, firstname, lastname, ru.email, staticipcpe, 
                    company, ru.mobile, expiration, ru.srvid, rs.srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff, tpa.PAUSE_DATE, PAUSE_TILL, DAYS_TO_EXPIRE,
                    tad.FULLNAME AS 'PAUSED_BY'
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              LEFT JOIN tbl_pause_account tpa ON ru.username=tpa.USERNAME
							LEFT JOIN tbl_admins tad ON tpa.PAUSED_BY=tad.AID
                WHERE enableuser=0 AND IS_PAUSED=1
                AND ru.username IN (SELECT USERNAME FROM tbl_pause_account WHERE IS_PAUSED=1)
              $addon";
        $some_sth = $this->db->select($sql);
        $rows = [];
        while ($row = $some_sth->fetch_object()):
            $rows[] = ["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "CREATEDON"=>$row->createdon, "IP"=>"'".$row->staticipcpe,
                "EXPIRATION"=>$row->expiration, "LASTLOGOFF"=>$row->lastlogoff, "PAUSE_DATE"=>$row->PAUSE_DATE,
                "PAUSE_TILL"=>$row->PAUSE_TILL, "DAYS_TO_EXPIRE"=>$row->DAYS_TO_EXPIRE, "PAUSED_BY"=>$row->PAUSED_BY];

        endwhile;
            
        return $rows;
    }
    
    public function getPendingCustomers($location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT ru.username, enableuser, firstname, lastname, ru.email, staticipcpe, 
                    company, ru.mobile, expiration, ru.srvid, rs.srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff
              FROM rm_users ru
              JOIN rm_services rs USING (srvid)
              JOIN tbl_plans tp ON ru.srvid=tp.SRVID
              WHERE enableuser=0
                AND username IN (SELECT USERNAME FROM tblclients WHERE USERTYPE=8)
                AND lastlogoff IS NULL
              $addon";
        $some_sth = $this->db->select($sql);
        $rows = [];
        while ($row = $some_sth->fetch_object()):
            $rows[] = ["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "CREATEDON"=>$row->createdon];

        endwhile;
            
        return $rows;
    }
    
    public function getNewActivationsByLocation($startDate, $endDate, $location='') {
        $stat = $response = [];
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT ru.username, enableuser, firstname, lastname, ru.email, staticipcpe, 
                    company, ru.mobile, expiration, ru.srvid, rs.srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff 
                    FROM tbl_install_invoice tii
                    LEFT JOIN rm_users ru ON tii.RAD_USERNAME=ru.username
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                    WHERE 1 $addon
                    AND DATE(tii.DATE_ACTIVATED) BETWEEN '$startDate' AND '$endDate'
                 ORDER BY PLAN_LOCATION, createdon
              ";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()):
            $stat[$row->PLAN_LOCATION][] = ["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "EXPIRATION"=>$row->expiration, "IP"=>"'".$row->staticipcpe,
                "CREATEDON"=>$row->createdon, "LASTLOGOFF"=>$row->lastlogoff];
        endwhile;
        
        return $stat;
    }
    
    public function getRenewalTransactions($startDate, $endDate, $location) {
        $locations = $this->getLocations();
        $stat = $response = [];
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $sql = "SELECT ru.username, rs.srvname, tp.PLAN, firstname, lastname, enableuser, email, phone,
 PLAN_LOCATION, tx.EXPIRY_DATE, tx.NU_EXPIRY_DATE, PAY_GATEWAY, TRANX_ID, REQUEST_DATE, PAY_DATE, RET_REF_NO,
 DB_UPDATED, tx.AUTORENEW, PLAN_CHANGE, PROMO
                    FROM `tbl_tranx` tx
                    LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
                    WHERE STATUS_CODE = '00' $addon
                    AND DATE(tx.PAY_DATE) BETWEEN '$startDate' AND '$endDate'
                    ORDER BY PLAN_LOCATION, PAY_DATE DESC
              ";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()):
            $stat[$row->PLAN_LOCATION][] = ["USERNAME"=>$row->username, "CURRENT_PLAN"=>$row->srvname, 
                "RENEWED_PLAN"=>$row->PLAN, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", 
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "PLAN_LOCATION"=>$row->PLAN_LOCATION, 
                "EXPIRATION_BEFORE_RENEWAL"=>$row->EXPIRY_DATE, "NEW_EXPIRATION"=>$row->NU_EXPIRY_DATE,
                "PAYMENT_GATEWAY"=>$row->PAY_GATEWAY, "TRANS_ID"=>$row->TRANX_ID, 
                "REQUEST_DATE"=>$row->REQUEST_DATE, "PAY_DATE"=>$row->PAY_DATE, "GATEWAY_REFERENCE"=>$row->RET_REF_NO,
                "DB_UPDATED"=>$row->DB_UPDATED? "Yes":"No", "IS_AUTORENEW"=>$row->AUTORENEW? "Yes":"No",
                "IS_PLAN_CHANGE"=>$row->PLAN_CHANGE? "Yes":"No", "PROMO"=>$row->PROMO];
        endwhile;
        
        return $stat;
    }
    
    public function getExpiringByDate($expiryDate, $location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $stat = $response = [];
        $sql = "SELECT username, enableuser, firstname, lastname, email, staticipcpe, 
                    company, mobile, expiration, ru.srvid, srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff
                    FROM rm_users ru 
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                    WHERE 1 AND enableuser = 1
                    AND DATE(expiration) = '$expiryDate' $addon
                      ";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()):
            $stat[] = ["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "CREATEDON"=>$row->createdon, "IP"=>"'".$row->staticipcpe,
                "EXPIRATION"=>$row->expiration, "LASTLOGOFF"=>$row->lastlogoff];
        endwhile;
        
        return $stat;
    }
    
    public function getExpiringInDays($daysToExpire, $location='') {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)) :
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $stat = $response = [];
        $sql = "SELECT username, enableuser, firstname, lastname, email, staticipcpe, 
                    company, mobile, expiration, ru.srvid, srvname, address, city, state,
                    PLAN_LOCATION, createdon, lastlogoff 
                    FROM rm_users ru 
                    JOIN rm_services rs USING (srvid)
                    JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                    WHERE 1 AND enableuser = 1
                    AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND $daysToExpire $addon
                      ";
        $some_sth = $this->db->select($sql);
        while ($row = $some_sth->fetch_object()):
            $stat[] = ["USERNAME"=>$row->username, "PLAN"=>$row->srvname, "FIRSTNAME"=>$row->firstname,
                "LASTNAME"=>$row->lastname, "ENABLED"=>$row->enableuser? "Yes":"No", "COMPANY"=>$row->company,
                "EMAIL"=>$row->email, "PHONE"=>$row->mobile, "ADDRESS"=>$row->address, "CITY"=>$row->city,
                "STATE"=>$row->state, "PLAN_LOCATION"=>$row->PLAN_LOCATION, "CREATEDON"=>$row->createdon, "IP"=>"'".$row->staticipcpe,
                "EXPIRATION"=>$row->expiration, "LASTLOGOFF"=>$row->lastlogoff];
        endwhile;
        
        return $stat;
    }
    
    
}
