<?PHP

if (file_exists("includes/common_functions.php"))
    require_once "includes/common_functions.php";
elseif (file_exists("../includes/common_functions.php"))
    require_once "../includes/common_functions.php";
elseif (file_exists("../../includes/common_functions.php"))
    require_once "../../includes/common_functions.php";

if (file_exists("includes/opener.php"))
    require_once "includes/opener.php";
elseif (file_exists("../includes/opener.php"))
    require_once "../includes/opener.php";
elseif (file_exists("../../includes/opener.php"))
    require_once "../../includes/opener.php";
elseif (file_exists("../../../includes/opener.php"))
    require_once "../../../includes/opener.php";

/**
 * Description of UserProfile
 *
 * @author OPMat
 */
class FreshWorks extends Logger {
    
    const FRESHDESK_API_BASE_URL = "https://fiberonefiberone.freshdesk.com/api/v2";
    const FRESHDESK_CONTACT_URL = "/contacts";
    const FRESHDESK_API_KEY = "Qi5AH8wVbQeAt0xbU4";
    const FRESHDESK_API_PASS = "XxX";
    
    private $db;
    private $sid;
    
    
    public function __construct($dbconnection) {
        $this->db = $dbconnection;
        $this->sid = session_id();
        parent::__construct($dbconnection, $_SESSION[$this->sid."username"]);
    } 
    
    
    private function __curlURL($strURL, $method='GET', $postdata=[], $header=[]) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, array_merge([
                "X-Requested-With: XMLHttpRequest", 
                "Content-type: application/json"],
                $header));
        curl_setopt($ch, CURLOPT_URL, $strURL);
        curl_setopt($ch, CURLOPT_USERPWD, $this::FRESHDESK_API_KEY.":".$this::FRESHDESK_API_PASS);
        
        if ($method == 'POST'):
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
        elseif ($method == 'PUT'):
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
        endif;
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE); 

        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1);
        
        $server_output = curl_exec($ch);
        $info = curl_getinfo($ch);
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $headers = substr($server_output, 0, $header_size);
        $response = substr($server_output, $header_size);
		print_r($info);
        if($info['http_code'] == 201) {
          echo "Contact created successfully, the response is given below \n";
          echo "Response Headers are \n";
          echo $headers."\n";
          echo "Response Body \n";
          echo "$response \n";
        } else {
          if($info['http_code'] == 404) {
            echo "Error, Please check the end point \n";
          } else {
            echo "Error, HTTP Status Code : " . $info['http_code'] . "\n";
            echo "Headers are ".$headers;
            echo "Response are ".$response;
          }
        }

        //echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);

        return $server_output;
    }
    
    
    public function addContact($username, $fullname, $email, $phone,
            $mobile, $address, $plan, $state) {
        
        $createURL = $this::FRESHDESK_API_BASE_URL . $this::FRESHDESK_CONTACT_URL;
        echo "<pre>$createURL<br/>";
        $postdata = [
            "name"=>$fullname, "email"=>$email, "phone"=>$phone,
            "mobile"=>$mobile, "unique_external_id"=>$username,
            "address"=>$address, job_title=>"Customer",
            "custom_fields"=>[
              "username"=>$username,
              "plan"=>$plan,
              "state"=>$state,
            ],
            "tags"=>[$username, $plan, $state], 
            "lookup_parameter"=>"primary_field_value"];
    	echo "<br/><br/>";
    	print_r(json_encode($postdata));
        //send post
        $ret = $this->__curlURL($createURL, 'POST', $postdata);
        $nret = json_decode($ret, TRUE);
        return $nret;
    }
    
    public function upsertContact($username, $fullname, $email, $phone,
            $mobile, $address, $plan, $state) {
        $createURL = $this::FRESHDESK_API_BASE_URL . $this::FRESHDESK_CONTACT_URL . '/upsert';
        echo "<pre>$createURL<br/>";
        $postdata = [
            "unique_identifier"=>["emails"=> $email],
            "contact" => [ 
            "name"=>$fullname, "email"=>$email, "phone"=>$phone,
            "mobile"=>$mobile, "unique_external_id"=>$username,
            "address"=>$address, job_title=>"Customer",
            "custom_fields"=>[
              "username"=>$username,
              "plan"=>$plan,
              "state"=>$state,
            ],
            "tags"=>[$username, $plan, $state], 
            "lookup_parameter"=>"primary_field_value"
                ]
            ];
    	echo "<br/><br/>";
    	print_r(json_encode($postdata));
        //send post
        $ret = $this->__curlURL($createURL, 'POST', $postdata);
        $nret = json_decode($ret, TRUE);
        return $nret;
    }
    
    public function updateContactinfo($username, $param=[]) {
        if ($param !== []) :
            $createURL = $this::FRESHDESK_API_BASE_URL . $this::FRESHDESK_CONTACT_URL . "/" . $username;
            //send post
            $ret = $this->__curlURL($createURL, 'PUT', $param);
            $nret = json_decode($ret, TRUE);
            return $nret;
        else:
            return "Invalid Parameter";
        endif;
    }
    
}