<?php

/**
 * Description of Logger
 *
 * @author OPMat
 */
class Logger {
    /**
    * The database connection object.
    *
    * @var object
    */
    private $_db;
    /**
    * The Username of the user.
    *
    * @var string
    */
    private $_username;
    
    const STATUS_PASSED = 1;
    const STATUS_FAILED = 0;
    
    const AUTHENTICATION = 1;
    const PASSWORD_CHANGE = 2;
    const RENEWAL_AUTO = 3;
    const RENEWAL_MANUAL = 4;
    const USER_LINK = 5;
    const NEW_USER = 6;
    const INFO = 7;
    const SERVICE_CHANGE = 8;
    const PAYMENT = 9;
    
    /**
    * Class constructor.
    *
     * @param object $dbconnection Database Connection Object
     * @param string $username Username of the user
    */
    public function __construct($dbconnection, $username) {
        $this->_db = $dbconnection;
        $this->_username = $username;
    } 
    
    /**
     * Getter Method for Private Variable $_username
     * 
     * @return string returns the username
     */
    public function getUsername() {
        return $this->_username;
    }
    
    /**
     * Setter Method for Private Variable $_username
     * 
     * @param integer $uusername username
     */
    public function setUsername($username) {
        $this->_username = $username;
    }
    
    /**
     * Setter Method for Private Variable $_db
     * 
     * @param object $db database connection
     */
    protected function setDB($db) {
        $this->_db = $db;
    }
    
    /**
     * Logs audit trails
     * 
     * @param integer $log_type_id Type of Log (as defined in CONSTANTS)
     * @param string $log Log statement/information
     * @param integer $logstatus Status of the action/process. 1/0
     * @param string $ipaddress IP Address of the User that initiated the process/action
     * 
     * @return integer Status of the logging whether successful or not
     */
    public function logTrail($log_type_id, $log, $logstatus, $ipaddress) {
        $ins = "INSERT INTO tbl_logs (LOG_TYPE_ID, LOG, LOG_STATUS, USERNAME, IP_ADDRESS, LOG_DATE) 
                VALUES (?, ?, ?, ?, ?, NOW()) ";
        $saved = $this->_db->insert($ins, "isiss", $log_type_id, $log, $logstatus, $this->_username, $ipaddress);
        if ($saved > 0)
            return 1;
        else
            return 0;
    }
    
    /**
     * Get the log from database for stipulated date range
     * 
     */
    public function getLogV2($log_type=0, $startdate = '', $enddate = '', $searchval='', $sortby='', $sortorder='desc', $startrow=0, $len = 0, $is_admin=-1) {
        $addon = "";
        
        if ($is_admin>-1):
            $addon = ($is_admin)? "AND tl.USERNAME IN (SELECT USERNAME FROM tbl_admins)" : 
                        "AND tl.USERNAME IN (SELECT USERNAME FROM tblclients)";
        endif;
        
        $ret = $response = array();
        $sn = 0; 
        
        $ad = "";
        $ad .= $addon;
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->_db, $searchval);
            $ad .= " AND (LOG LIKE '%$searchval%' OR USERNAME LIKE '%$searchval%' OR IP_ADDRESS = '$searchval' OR `DESCRIPTION` LIKE '%$searchval%') ";
        endif;
        if ($startdate <> "") :
            $startdate = mysqli_real_escape_string($this->_db, $startdate);
            $ad .= " AND ( DATE(LOG_DATE) >= '$startdate' ) ";
        endif;
        if ($enddate <> "") :
            $enddate = mysqli_real_escape_string($this->_db, $enddate);
            $ad .= " AND ( DATE(LOG_DATE) <= '$enddate' ) ";
        endif;
        
        if (is_array($log_type)):
            $lt = join(",", $log_type);
            $ad .= " AND tl.LOG_TYPE_ID IN ($lt)";
        else:
            $log_type = intval($log_type);
            $ad .= (is_int($log_type) && $log_type> 0)? " AND tl.LOG_TYPE_ID IN ($log_type)" : "";
        endif; 
        
        // $eqry = "SET @count = 0;"; $this->_db->execute_query($eqry);
        $mqry = "SELECT LOG_ID, tl.LOG_TYPE_ID, LOG, LOG_STATUS, USERNAME, IP_ADDRESS, LOG_DATE
                    FROM tbl_logs tl 
                    LEFT JOIN tbl_log_types tlt ON tl.LOG_TYPE_ID=tlt.LOG_TYPE_ID ";
        $some_st = $this->_db->select($mqry); //echo $mqry; exit();
        $totalRecords = $some_st->num_rows();
        
        $fqry = "$mqry WHERE 1 $ad ";
        $some_s = $this->_db->select($fqry);
        $totalRecordwithFilter = $some_s->num_rows();
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY LOG_DATE DESC";
        $qry = "$mqry WHERE 1 $ad $msort $limit"; 
        $some_sth = $this->_db->select($qry);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $stat = ($row->LOG_STATUS)? 
            "<span style='font-size:1.2em' class=\"label-default label label-success\"><i class='glyphicon glyphicon-ok-circle'></i></span>" :
            "<span style='font-size:1.2em' class=\"label-default label label-danger\"><i class='glyphicon glyphicon-remove-circle'></i></span>" ;
            $ret[] = array("USERNAME"=>$row->USERNAME, "IP_ADDRESS"=>$row->IP_ADDRESS, "LOG_TYPE"=>$row->LOG_TYPE, "LOG"=>$row->LOG,
                    "LOG_DATE"=>date('d-m-Y H:i:s', strtotime($row->LOG_DATE)), "STAT"=>$stat);
        }
        
        ## Response
        $response = array(
          "iTotalRecords" => $totalRecords,
          "iTotalDisplayRecords" => $totalRecordwithFilter,
          "aaData" => $ret
        );
        return $response;
    }
    
    /**
     * Get the log from database for stipulated date range
     * 
     */
    public function getLog($limit=50, $log_type=0, $log='%', $username='', $ip='', $from='', $to='', $is_admin=-1) {
        $params = $types = "";
        $args = $rets = [];
        $addon = "";
        
        if ($is_admin>-1):
            $addon = ($is_admin)? "AND tl.USERNAME IN (SELECT USERNAME FROM tbl_admins)" : 
                        "AND tl.USERNAME IN (SELECT USERNAME FROM tblclients)";
        endif;
        
        $strsql = "SELECT LOG_ID, tl.LOG_TYPE_ID, LOG, LOG_STATUS, USERNAME, IP_ADDRESS, LOG_DATE, LOG_TYPE, `DESCRIPTION` 
            FROM tbl_logs tl
            LEFT JOIN tbl_log_types tlt ON tl.LOG_TYPE_ID=tlt.LOG_TYPE_ID
                WHERE 1=1 $addon";
        $strsql .= ($log_type)? " AND tl.LOG_TYPE_ID=?" : "";
        $strsql .= ($log != "%")? " AND LOG LIKE ?" : "";
        $strsql .= ($username != '')? " AND USERNAME LIKE ?" : "";
        $strsql .= ($ip != '')? " AND IP_ADDRESS LIKE ?" : "";
        $strsql .= ($from != '' && $to != '')? " AND LOG_DATE BETWEEN ? AND ?" : "";
        $strsql .= ($limit>0)? " LIMIT ?" : "";
        
        $types .= ($log_type)? "i" : "";
        $types .= ($log != "%")? "s" : "";
        $types .= ($username != '')? "s" : "";
        $types .= ($ip != '')? "s" : "";
        $types .= ($from != '' && $to != '')? "ss" : "";
        $types .= ($limit>0)? "i" : "";
        
        ($log_type)? array_push($args, $log_type) : "";
        ($log != "%")? array_push($args, "%$log%") : "";
        ($username != '')? array_push($args, $username) : "";
        ($ip != '')? array_push($args, "%$ip%") : "";
        ($from != '' && $to != '')? array_merge($args, [$from, $to]) : "";
        ($limit>0)? array_push($args, $limit) : "";
        
        $newarr = ($types != "")? [$strsql, $types] : [$strsql];
        $args = array_merge( $newarr, $args); //print_r($args);
        $some_sth = call_user_func_array(array($this->_db, 'select'), $this->ref($args));
        
        //$some_sth = $this->_db->select($strsql, 'iis', $this->isStudent, $this->isStudent, $user_group);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_assoc() ) :
            array_push($rets, $row);
        endwhile;
        
        return $rets;
    }
    
    /**
     * Get Username of users with log records
     * 
     * @return mixed Array of usernames that exist in log table
     */
    public function getLogUsers() {
        $users = [];
        
        $strsql = "SELECT DISTINCT USERNAME FROM tbl_logs ORDER BY USERNAME";
        $some_sth = $this->_db->select($strsql);
        while ( $row = $some_sth->fetch_object() ) :
            array_push($users, $row->USERNAME);
        endwhile;
        
        return $users;
    }
    
    /**
     * Get Log Types
     * 
     * @return mixed Array of Log types
     */
    public function getLogTypes() {
        $users = [];
        
        $strsql = "SELECT LOG_TYPE_ID, LOG_TYPE, DESCRIPTION FROM tbl_log_types ORDER BY LOG_TYPE";
        $some_sth = $this->_db->select($strsql);
        while ( $row = $some_sth->fetch_assoc() ) :
            $users[$row["LOG_TYPE_ID"]] = $row;
        endwhile;
        
        return $users;
    }
    
    /**
     * Check if a string starts with another string
     * @param string $haystack The Original String to be searched
     * @param string $needle The search string. Note that the needle may be a string of one or more characters.
If needle is not a string, it is converted to an integer and applied as the ordinal value of a character
     * @return boolean returns TRUE is the $haystack starts with $needle else it returns FALSE
     */
    function startsWith($haystack, $needle) {
        return $needle === "" || stripos($haystack, $needle) === 0;
    }
    
    
    
    // ----------------------------------------------------------------------------------
    // helper function to turn an array of values into an array of value references
    // necessary because mysqli_stmt::bind_param needs value refereces for no good reason
    function ref($arr) {
        $refs = array();
        foreach ($arr as $key => $val) $refs[$key] = &$arr[$key];
        return $refs;
    }
    
}
