<?php

if (file_exists("config2.php")) {
    require_once "config2.php";
} elseif (file_exists("../config2.php")) {
    require_once "../config2.php";
} elseif (file_exists("../../config2.php")) {
    require_once "../../config2.php";
}

if (file_exists("includes/common_functions.php")) {
    require_once "includes/common_functions.php";
} elseif (file_exists("../includes/common_functions.php")) {
    require_once "../includes/common_functions.php";
} elseif (file_exists("../../includes/common_functions.php")) {
    require_once "../../includes/common_functions.php";
}

if (file_exists("includes/opener.php")) {
    require_once "includes/opener.php";
} elseif (file_exists("../includes/opener.php")) {
    require_once "../includes/opener.php";
} elseif (file_exists("../../includes/opener.php")) {
    require_once "../../includes/opener.php";
} elseif (file_exists("../../../includes/opener.php")) {
    require_once "../../../includes/opener.php";
}

if (file_exists("includes/htmlpurifier/library/HTMLPurifier.auto.php")) {
    require_once "includes/htmlpurifier/library/HTMLPurifier.auto.php";
} elseif (file_exists("../includes/htmlpurifier/library/HTMLPurifier.auto.php")) {
    require_once "../includes/htmlpurifier/library/HTMLPurifier.auto.php";
} elseif (file_exists("../../includes/htmlpurifier/library/HTMLPurifier.auto.php")) {
    require_once "../../includes/htmlpurifier/library/HTMLPurifier.auto.php";
} else {
    die("HTMLPurifier library not found!");
}

/**
 * Description of MArketplaceDashboard
 *
 * @author adeshola
 */
class MarketplaceDashboard
{
    //put your code here
    private $db;
    private $sid;

    private $purifier;


    private $uid;
    private $fullname;
    private $is_admin;
    private $is_enabled;
    private $usertype;
    private $usertype_id;
    private $username;
    private $rad_username;
    private $lastname;
    private $firstname;
    private $package;
    private $packageid;
    private $expiration;
    private $email;
    private $mobile;
    private $global_id;
    private $location;
    private $company;

    public $totalRecords;
    public $totalRecordwithFilter;


    /**
     * Upload multiple product images securely
     *
     * @param int $vendor_id
     * @param int $product_id
     * @param array $files  $_FILES['images']
     * @return array ['uploaded'=>[], 'errors'=>[]]
     */

    public function __construct($dbconnection)
    {
        $this->db = $dbconnection;
        //        parent::setDB($dbconnection);
        $this->sid = session_id();
        $config = HTMLPurifier_Config::createDefault();
        $config->set('HTML.Allowed', 'p,strong,em,u,a[href],ol,ul,li,br,h1,h2,h3');
        $this->purifier = new HTMLPurifier($config);
    }

    public function uploadProductImages($vendor_id, $product_id, $files)
    {
        $uploaded = [];
        $errors = [];
        $seen = [];
        if (!isset($files['tmp_name']) || count($files['tmp_name']) === 0) {
            $errors[] = "No images uploaded.";
            return ['uploaded' => $uploaded, 'errors' => $errors];
        }

        for ($i = 0; $i < count($files['tmp_name']); $i++) {

            $fingerprint = md5(
                $files['name'][$i] .
                $files['size'][$i] .
                $files['tmp_name'][$i]
            );

            if (isset($seen[$fingerprint])) {
                continue; // skip duplicate
            }

            $seen[$fingerprint] = true;

            $tmpName = $files['tmp_name'][$i];
            $originalName = $files['name'][$i];
            $fileError = $files['error'][$i];

            if ($fileError !== 0) {
                $errors[] = "$originalName failed to upload (error code $fileError).";
                continue;
            }

            // ---------------- IMAGE VALIDATION ----------------
            $allowedMime = ['image/jpeg', 'image/png', 'image/webp'];
            $finfo = finfo_open(FILEINFO_MIME_TYPE);
            $mimeType = finfo_file($finfo, $tmpName);
            finfo_close($finfo);

            if (!in_array($mimeType, $allowedMime)) {
                $errors[] = "$originalName is not a valid image type.";
                continue;
            }

            if (getimagesize($tmpName) === false) {
                $errors[] = "$originalName is not a valid image file.";
                continue;
            }

            $allowedExts = ['jpg', 'jpeg', 'png', 'webp'];
            $ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
            if (!in_array($ext, $allowedExts)) {
                $errors[] = "$originalName has invalid extension.";
                continue;
            }

            // ---------------- MOVE FILE TO UPLOAD FOLDER ----------------
            $uploadDir = __DIR__ . "../../public/uploads/products/vendor_$vendor_id/product_$product_id/";

            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }

            $newName = bin2hex(random_bytes(12)) . "." . $ext;
            $destination = $uploadDir . $newName;

            if (!move_uploaded_file($tmpName, $destination)) {
                $errors[] = "$originalName could not be saved.";
                continue;
            }

            $stmt = $this->db->prepare("
                INSERT INTO marketplace_product_images (product_id, vendor_id, filename)
                VALUES (?, ?, ?)
            ");
            $path = "vendor_$vendor_id/product_$product_id/$newName";
            $stmt->bind_param("iis", $product_id, $vendor_id, $path);

            if ($stmt->execute()) {
                $uploaded[] = $newName;
            } else {
                $errors[] = "Database error for $originalName: " . $stmt->error;
            }
        }

        return ['uploaded' => $uploaded, 'errors' => $errors];
    }



    public function removeProductImages($vendor_id, $product_id, $removedImages)
    {
        $deleted = [];
        $errors = [];

        if (!is_array($removedImages) || empty($removedImages)) {
            return ['deleted' => $deleted, 'errors' => $errors];
        }

        foreach ($removedImages as $path) {

            if (strpos($path, "vendor_$vendor_id/product_$product_id/") !== 0) {
                $errors[] = "Invalid image path: $path";
                continue;
            }

            $fullPath = __DIR__ . "../../public/uploads/products/" . $path;

            if (file_exists($fullPath)) {
                if (!unlink($fullPath)) {
                    $errors[] = "Could not delete file: $path";
                    continue;
                }
            }

            $stmt = $this->db->prepare("
            DELETE FROM marketplace_product_images
            WHERE product_id = ? AND vendor_id = ? AND filename = ?
        ");
            $stmt->bind_param("iis", $product_id, $vendor_id, $path);

            if ($stmt->execute()) {
                $deleted[] = $path;
            } else {
                $errors[] = "Database error removing $path";
            }
        }

        return ['deleted' => $deleted, 'errors' => $errors];
    }


    public function authenticateVendor($username, $password)
    {
        // Query using selected columns plus global_id and company
        $qry = "SELECT 
                v.id AS ID,
                v.username AS USERNAME,
                v.name AS fullname,
                v.email,
                v.is_enabled AS IS_ENABLED,
                v.usertype AS USERTYPE,
                tal.admin_type AS ADMIN_TYPE,
                v.phone_number AS mobile,
                v.address AS location,
                v.global_id,
                v.business_name
            FROM `tbl_vendors` v
            LEFT JOIN tbl_admin_level tal ON v.usertype = tal.ID
            WHERE v.username LIKE ? 
              AND v.password = ?";

        $some_sth = $this->db->select($qry, 'ss', $username, sha1($password));
        $rows = $some_sth->num_rows();

        while ($row = $some_sth->fetch_object()) {
            $this->uid = $row->ID;
            $this->username = $row->USERNAME;
            $this->fullname = $row->fullname;
            $this->email = $row->email;
            $this->is_enabled = ($row->IS_ENABLED == 1);
            $this->usertype = $row->ADMIN_TYPE;
            $this->usertype_id = $row->USERTYPE;
            $this->mobile = $row->mobile;
            $this->location = $row->location;
            $this->global_id = $row->global_id;
            $this->company = $row->business_name;
        }

        return $rows;
    }


    public function getLocations()
    {
        $sql = "SELECT DISTINCT PLAN_LOCATION FROM tbl_plans ORDER BY PLAN_LOCATION";
        $some_sth = $this->db->select($sql);
        $plans = [];
        while ($row = $some_sth->fetch_object()) {
            $plans[] = $row->PLAN_LOCATION;
        }
        return $plans;
    }

    /**
     * 
     * Get the list of Complimentary, Pending and Paused Accounts for IN Query
     * 
     * @return string $userlist
     */


    /**
     * Get dashboard overview: total vendors, total products, and top selling product
     */
    public function getAdminDashboardOverview()
    {
        // Fetch counts in a single query
        $counts = $this->db->select("
        SELECT 
            (SELECT COUNT(*) FROM tbl_vendors) AS total_vendors,
            (SELECT COUNT(*) FROM tbl_products WHERE status != 'archived') AS total_products     ")->fetch_object();

        // Fetch top selling product
        $topSelling = $this->db->select("  SELECT  
    p.name AS product_name, 
    COALESCE(SUM(oi.quantity), 0) AS total_sold
FROM tbl_order_items oi
INNER JOIN tbl_products p ON p.id = oi.product_id
INNER JOIN tbl_orders o ON oi.order_id = o.id
WHERE o.status = 'fulfilled'
GROUP BY p.id, p.name
ORDER BY total_sold DESC
LIMIT 1;
        -- SELECT 
        --     p.name AS product_name, 
        --     COALESCE(SUM(oi.quantity), 0) AS total_sold
        -- FROM tbl_order_items oi
        -- INNER JOIN tbl_products p ON p.id = oi.product_id
        -- GROUP BY oi.product_id
        -- ORDER BY total_sold DESC
        -- LIMIT 1
    ")->fetch_object();

        return [
            "total_vendors" => (int) $counts->total_vendors,
            "total_products" => (int) $counts->total_products,
            "top_selling_product" => $topSelling->product_name ?? null,
            "units_sold" => (int) ($topSelling->total_sold ?? 0)
        ];
    }

    /**
     * Get last 4 pending vendors
     */
    public function getLastPendingVendors()
    {
        $result = $this->db->select("
            SELECT id, name, email, status, address, created_at
            FROM tbl_vendors
            WHERE status = 'pending'
            ORDER BY created_at DESC
            LIMIT 4
        ");
        $vendors = [];
        while ($row = $result->fetch_object()) {
            $vendors[] = $row;
        }
        return $vendors;
    }

    public function getVendorsPaginatedold($page = 1, $limit = 5)
    {
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5; // default per page
        }

        $offset = ($page - 1) * $limit;

        // Count total vendors
        $countStmt = $this->db->prepare("SELECT COUNT(*) AS total FROM tbl_vendors");
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $totalVendors = $countResult->fetch_object()->total;
        $totalPages = ceil($totalVendors / $limit);

        // Fetch vendors with pagination
        $stmt = $this->db->prepare("
        SELECT *
        FROM tbl_vendors
        ORDER BY created_at DESC
        LIMIT ? OFFSET ?
    ");
        $stmt->bind_param("ii", $limit, $offset);
        $stmt->execute();
        $result = $stmt->get_result();

        $vendors = [];
        while ($row = $result->fetch_object()) {
            $vendors[] = $row;
        }

        return [
            'vendors' => $vendors,
            'totalPages' => $totalPages,
            'currentPage' => $page
        ];
    }

    public function getVendorsPaginatedNew($page = 1, $limit = 5, $search = null)
    {
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5;
        }

        $offset = ($page - 1) * $limit;

        $searchQuery = "";
        $params = [];
        $types = "";

        if (!empty($search)) {
            $search = "%" . $search . "%";
            $searchQuery = "WHERE business_name LIKE ? OR email LIKE ?";
            $params[] = $search;
            $params[] = $search;
            $types .= "ss";
        }

        // Count total vendors
        $countSql = "SELECT COUNT(*) AS total FROM tbl_vendors $searchQuery";
        $countStmt = $this->db->prepare($countSql);

        if (!empty($params)) {
            $countStmt->bind_param($types, ...$params);
        }

        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $totalVendors = $countResult->fetch_object()->total;
        $totalPages = ceil($totalVendors / $limit);

        // Fetch vendors with pagination
        $sql = "
        SELECT *
        FROM tbl_vendors
        $searchQuery
        ORDER BY created_at DESC
        LIMIT ? OFFSET ?
    ";
        $stmt = $this->db->prepare($sql);

        if (!empty($params)) {
            $typesWithLimits = $types . "ii";
            $paramsWithLimits = array_merge($params, [$limit, $offset]);
            $stmt->bind_param($typesWithLimits, ...$paramsWithLimits);
        } else {
            $stmt->bind_param("ii", $limit, $offset);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        $vendors = [];
        while ($row = $result->fetch_object()) {
            $vendors[] = $row;
        }

        return [
            'vendors' => $vendors,
            'totalPages' => $totalPages,
            'currentPage' => $page,
            'search' => $search ? trim($search, "%") : null
        ];
    }

    public function getVendorsPaginated($page = 1, $limit = 5, $search = null, $status = 'all', $startDate = null, $endDate = null, $fetchAll = false)
    {
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5;
        }

        $offset = ($page - 1) * $limit;

        $whereClauses = [];
        $params = [];
        $types = "";

        // Build search condition
        if (!empty($search)) {
            $search = "%" . $search . "%";
            $whereClauses[] = "(business_name LIKE ? OR email LIKE ?)";
            $params[] = $search;
            $params[] = $search;
            $types .= "ss";
        }

        // Build status condition
        if ($status !== 'all') {
            $whereClauses[] = "status = ?";
            $params[] = $status;
            $types .= "s";
        }

        // Build date range condition
        if (!empty($startDate) && !empty($endDate)) {
            $whereClauses[] = "created_at BETWEEN ? AND ?";
            $params[] = $startDate . ' 00:00:00';
            $params[] = $endDate . ' 23:59:59';
            $types .= "ss";
        }

        // Combine where clauses
        $whereQuery = !empty($whereClauses) ? "WHERE " . implode(" AND ", $whereClauses) : "";

        // Count total vendors
        $totalSql = "SELECT COUNT(*) AS total FROM tbl_vendors";
        $totalStmt = $this->db->prepare($totalSql);
        $totalStmt->execute();
        $totalResult = $totalStmt->get_result();
        $totalRecords = $totalResult->fetch_object()->total;

        // Count filtered vendors
        $countSql = "SELECT COUNT(*) AS total FROM tbl_vendors $whereQuery";
        $countStmt = $this->db->prepare($countSql);
        if (!empty($params)) {
            $countStmt->bind_param($types, ...$params);
        }
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $filteredRecords = $countResult->fetch_object()->total;

        // Fetch vendors
        $sql = "
        SELECT *
        FROM tbl_vendors
        $whereQuery
        ORDER BY created_at DESC
    ";

        // Add pagination unless fetching all
        if (!$fetchAll) {
            $sql .= " LIMIT ? OFFSET ?";
            $params[] = $limit;
            $params[] = $offset;
            $types .= "ii";
        }

        $stmt = $this->db->prepare($sql);
        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
        }
        $stmt->execute();
        $result = $stmt->get_result();

        $vendors = [];
        while ($row = $result->fetch_object()) {
            $vendors[] = $row;
        }

        return [
            'vendors' => $vendors,
            'totalRecords' => $totalRecords,
            'filteredRecords' => $filteredRecords,
            'totalPages' => ceil($filteredRecords / $limit),
            'currentPage' => $page,
            'search' => $search ? trim($search, "%") : null,
            'status' => $status,
            'startDate' => $startDate,
            'endDate' => $endDate
        ];
    }
    public function getVendorProductsPaginated($vendorId, $page = 1, $limit = 5, $search = null)
    {
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        if ($vendorId === false) {
            return null;
        }

        // Validate pagination params
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5;
        }

        $offset = ($page - 1) * $limit;

        // Check if vendor exists
        $vendorStmt = $this->db->prepare("
        SELECT id, name, email
        FROM tbl_vendors
        WHERE id = ?
    ");
        $vendorStmt->bind_param("i", $vendorId);
        $vendorStmt->execute();
        $vendorResult = $vendorStmt->get_result();

        if (!$vendor = $vendorResult->fetch_object()) {
            return null; // Vendor not found
        }

        $searchQuery = "";
        $params = [$vendorId];
        $types = "i";

        if (!empty($search)) {
            $search = "%" . $search . "%";
            $searchQuery = "AND (p.name LIKE ? OR p.description LIKE ?)";
            $params = array_merge($params, [$search, $search]);
            $types .= "ss";
        }

        // Count total vendor products
        $countSql = "
        SELECT COUNT(*) AS total
        FROM tbl_products p
        WHERE p.vendor_id = ? AND p.status != 'archived' $searchQuery
    ";
        $countStmt = $this->db->prepare($countSql);
        $countStmt->bind_param($types, ...$params);
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $totalProducts = $countResult->fetch_object()->total;
        $totalPages = ceil($totalProducts / $limit);

        // Fetch vendor's products with pagination + search
        $sql = "
        SELECT 
            p.id, p.name, p.description, p.price, p.status, p.created_at, p.updated_at
        FROM 
            tbl_products p
        WHERE 
            p.vendor_id = ? AND p.status != 'archived' $searchQuery
        ORDER BY 
            p.created_at DESC
        LIMIT ? OFFSET ?
    ";
        $stmt = $this->db->prepare($sql);

        $typesWithLimits = $types . "ii";
        $paramsWithLimits = array_merge($params, [$limit, $offset]);
        $stmt->bind_param($typesWithLimits, ...$paramsWithLimits);

        $stmt->execute();
        $result = $stmt->get_result();

        $products = [];
        while ($product = $result->fetch_object()) {
            $products[] = $product;
        }

        // Return structured response
        return (object) [
            'vendor' => (object) [
                'id' => $vendor->id,
                'name' => $vendor->name,
                'email' => $vendor->email,
            ],
            'products' => $products,
            'total_products' => $totalProducts,
            'totalPages' => $totalPages,
            'currentPage' => $page,
            'search' => $search ? trim($search, "%") : null
        ];
    }

    public function getVendorProducts($vendorId)
    {
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        if ($vendorId === false) {
            return null;
        }

        // First, check if the vendor exists
        $vendorStmt = $this->db->prepare("
        SELECT id, name, email
        FROM tbl_vendors
        WHERE id = ?
    ");
        $vendorStmt->bind_param("i", $vendorId);
        $vendorStmt->execute();
        $vendorResult = $vendorStmt->get_result();

        if (!$vendor = $vendorResult->fetch_object()) {
            return null; // Vendor not found
        }

        $vendorData = (object) [
            'id' => $vendor->id,
            'name' => $vendor->name,
            'email' => $vendor->email,
            'total_products' => 0,
            'products' => []
        ];

        // Fetch vendor's products
        $productStmt = $this->db->prepare("
        SELECT 
            id, name, description, price, status, created_at, updated_at
        FROM 
            tbl_products
        WHERE 
            vendor_id = ? AND status != 'archived'
        ORDER BY 
            created_at DESC
    ");
        $productStmt->bind_param("i", $vendorId);
        $productStmt->execute();
        $productResult = $productStmt->get_result();

        while ($product = $productResult->fetch_object()) {
            $vendorData->products[] = $product;
        }


        $vendorData->total_products = count($vendorData->products);

        return $vendorData;
    }
    public function getAllActiveProductsPaginated($page = 1, $limit = 5, $search = null, $fetchAll = false)
    {
        // Validate pagination values
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5;
        }

        // Base conditions: active + in stock
        $whereClauses = [
            "p.status = 'active'",
            "p.stock_quantity > 0"
        ];

        $params = [];
        $types = "";

        if (!empty($search)) {
            $whereClauses[] = "(p.name LIKE ? OR c.name LIKE ? OR v.name LIKE ?)";
            $searchParam = "%" . $search . "%";
            $params[] = $searchParam;
            $params[] = $searchParam;
            $params[] = $searchParam;
            $types .= "sss";
        }


        $whereQuery = "WHERE " . implode(" AND ", $whereClauses);

        // Count total active + in-stock products
        $totalSql = "
        SELECT COUNT(*) AS total
        FROM tbl_products p
        INNER JOIN tbl_product_categories c ON p.category_id = c.id
        INNER JOIN tbl_vendors v ON p.vendor_id = v.id
        $whereQuery
    ";

        $totalStmt = $this->db->prepare($totalSql);
        if (!empty($params)) {
            $totalStmt->bind_param($types, ...$params);
        }
        $totalStmt->execute();
        $totalResult = $totalStmt->get_result();
        $totalRecords = $totalResult->fetch_object()->total;

        // Fetch paginated records
        $sql = "
        SELECT  
            p.*,
            c.name AS category_name,
            v.name AS vendor_name
        FROM 
            tbl_products p
        INNER JOIN 
            tbl_product_categories c ON p.category_id = c.id
        INNER JOIN 
            tbl_vendors v ON p.vendor_id = v.id
        $whereQuery
        ORDER BY 
            p.created_at DESC
    ";

        if (!$fetchAll) {
            $sql .= " LIMIT ? OFFSET ?";
            $params[] = $limit;
            $params[] = ($page - 1) * $limit;
            $types .= "ii";
        }

        $stmt = $this->db->prepare($sql);
        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
        }
        $stmt->execute();
        $result = $stmt->get_result();

        $products = [];
        while ($row = $result->fetch_object()) {
            $products[] = $row;
        }

        return [
            'products' => $products,
            'totalRecords' => $totalRecords,
            'totalPages' => ceil($totalRecords / $limit),
            'currentPage' => $page,
            'search' => $search ? trim($search) : null
        ];
    }

    public function getAllProductsPaginated($page = 1, $limit = 5, $search = null, $status = 'all', $startDate = null, $endDate = null, $fetchAll = false)
    {
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5;
        }

        $whereClauses = ["p.status != 'archived'"];
        $params = [];
        $types = "";

        // Build search condition
        if (!empty($search)) {
            $search = "%" . $search . "%";
            $whereClauses[] = "(p.name LIKE ? OR v.name LIKE ? OR v.email LIKE ?)";
            $params = [$search, $search, $search];
            $types = "sss";
        }

        // Build status condition
        if ($status !== 'all') {
            $whereClauses[] = "p.status = ?";
            $params[] = $status;
            $types .= "s";
        }

        // Build date range condition
        if (!empty($startDate) && !empty($endDate)) {
            $whereClauses[] = "p.created_at BETWEEN ? AND ?";
            $params[] = $startDate . ' 00:00:00';
            $params[] = $endDate . ' 23:59:59';
            $types .= "ss";
        }

        // Combine where clauses
        $whereQuery = !empty($whereClauses) ? "WHERE " . implode(" AND ", $whereClauses) : "";

        // Count total products (all non-archived products)
        $totalSql = "
        SELECT COUNT(*) AS total
        FROM tbl_products p
        JOIN tbl_vendors v ON p.vendor_id = v.id
        WHERE p.status != 'archived'
    ";
        $totalStmt = $this->db->prepare($totalSql);
        $totalStmt->execute();
        $totalResult = $totalStmt->get_result();
        $totalRecords = $totalResult->fetch_object()->total;

        // Count filtered products
        $countSql = "
        SELECT COUNT(*) AS total
        FROM tbl_products p
        JOIN tbl_vendors v ON p.vendor_id = v.id
        $whereQuery
    ";
        $countStmt = $this->db->prepare($countSql);
        if (!empty($params)) {
            $countStmt->bind_param($types, ...$params);
        }
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $filteredRecords = $countResult->fetch_object()->total;

        // Fetch products
        $sql = "
        SELECT 
            p.*,
            v.name AS vendor_name,
            v.email AS vendor_email
        FROM 
            tbl_products p
        JOIN 
            tbl_vendors v ON p.vendor_id = v.id
        $whereQuery
        ORDER BY 
            p.created_at DESC
    ";

        // Add pagination unless fetching all
        if (!$fetchAll) {
            $sql .= " LIMIT ? OFFSET ?";
            $params[] = $limit;
            $params[] = ($page - 1) * $limit;
            $types .= "ii";
        }

        $stmt = $this->db->prepare($sql);
        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
        }
        $stmt->execute();
        $result = $stmt->get_result();

        $products = [];
        while ($row = $result->fetch_object()) {
            $products[] = $row;
        }

        return [
            'products' => $products,
            'totalRecords' => $totalRecords,
            'filteredRecords' => $filteredRecords,
            'totalPages' => ceil($filteredRecords / $limit),
            'currentPage' => $page,
            'search' => $search ? trim($search, "%") : null,
            'status' => $status,
            'startDate' => $startDate,
            'endDate' => $endDate
        ];
    }

    public function getAllProductsPaginatedNew($page = 1, $limit = 5, $search = null)
    {
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5;
        }

        $offset = ($page - 1) * $limit;

        $searchQuery = "";
        $params = [];
        $types = "";

        if (!empty($search)) {
            $search = "%" . $search . "%";
            $searchQuery = "AND (p.name LIKE ? OR v.name LIKE ? OR v.email LIKE ?)";
            $params = [$search, $search, $search];
            $types = "sss";
        }

        // Count total products
        $countSql = "
        SELECT COUNT(*) AS total
        FROM tbl_products p
        JOIN tbl_vendors v ON p.vendor_id = v.id
        WHERE p.status != 'archived' $searchQuery
    ";
        $countStmt = $this->db->prepare($countSql);
        if (!empty($params)) {
            $countStmt->bind_param($types, ...$params);
        }
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $totalProducts = $countResult->fetch_object()->total;
        $totalPages = ceil($totalProducts / $limit);

        // Fetch products with pagination + search
        $sql = "
        SELECT 
            p.*,
            v.name AS vendor_name,
            v.email AS vendor_email
        FROM 
            tbl_products p
        JOIN 
            tbl_vendors v ON p.vendor_id = v.id
        WHERE 
            p.status != 'archived' $searchQuery
        ORDER BY 
            p.created_at DESC
        LIMIT ? OFFSET ?
    ";
        $stmt = $this->db->prepare($sql);

        if (!empty($params)) {
            $typesWithLimits = $types . "ii";
            $paramsWithLimits = array_merge($params, [$limit, $offset]);
            $stmt->bind_param($typesWithLimits, ...$paramsWithLimits);
        } else {
            $stmt->bind_param("ii", $limit, $offset);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        $products = [];
        while ($row = $result->fetch_object()) {
            $products[] = $row;
        }

        return [
            'products' => $products,
            'totalPages' => $totalPages,
            'currentPage' => $page,
            'search' => $search ? trim($search, "%") : null
        ];
    }


    public function getAllProductsPaginatedold($page = 1, $limit = 5)
    {
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5; // default
        }

        $offset = ($page - 1) * $limit;

        // Count total products (excluding archived)
        $countStmt = $this->db->prepare("
        SELECT COUNT(*) AS total 
        FROM tbl_products
        WHERE status != 'archived'
    ");
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $totalProducts = $countResult->fetch_object()->total;
        $totalPages = ceil($totalProducts / $limit);

        // Fetch products with limit and offset
        $stmt = $this->db->prepare("
        SELECT 
            p.*,
            v.name AS vendor_name,
            v.email AS vendor_email
        FROM 
            tbl_products p
        JOIN 
            tbl_vendors v ON p.vendor_id = v.id
        WHERE 
            p.status != 'archived'
        ORDER BY 
            p.created_at DESC
        LIMIT ? OFFSET ?
    ");
        $stmt->bind_param("ii", $limit, $offset);
        $stmt->execute();
        $result = $stmt->get_result();

        $products = [];
        while ($row = $result->fetch_object()) {
            $products[] = $row;
        }

        return [
            'products' => $products,
            'totalPages' => $totalPages,
            'currentPage' => $page
        ];
    }


    public function getAllProducts()
    {
        $result = $this->db->select("
          SELECT 
    p.*,
    v.name AS 'vendor_name',
    v.email  AS 'vendor_email'
FROM 
    tbl_products p
JOIN 
    tbl_vendors v ON p.vendor_id = v.id WHERE p.status != 'archived' ORDER BY p.created_at DESC ");
        $vendors = [];
        while ($row = $result->fetch_object()) {
            $vendors[] = $row;
        }
        return $vendors;
    }

    public function getVendorDetails($vendorId)
    {
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        if ($vendorId === false) {
            return null;
        }

        $stmt = $this->db->prepare("SELECT * FROM tbl_vendors WHERE id = ?");
        $stmt->bind_param("i", $vendorId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($vendor = $result->fetch_object()) {
            return $vendor;
        } else {
            return null;
        }
    }

    public function updateVendorStatus($vendorId, $newStatus, $adminID)
    {

        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        if ($vendorId === false) {
            return false;
        }

        $allowedStatuses = ['active', 'declined', 'pending', 'approve', 'restrict', 'restricted', 'unrestrict'];
        if (!in_array(strtolower($newStatus), $allowedStatuses)) {
            return false;
        }
        if (strtolower($newStatus) === 'approve') {

            $vendor = $this->getVendorById($vendorId);
            // return false;
            if (!$vendor) {
                return false; // vendor not found
            }

            $userCreated = $this->approveVendorAccount($vendor);
            if (!$userCreated) {
                return false; // 
            }

            $newStatus = 'active';
        }

        $now = date('Y-m-d H:i:s');
        $stmt = $this->db->prepare("UPDATE tbl_vendors SET status = ?, updated_at = ? WHERE id = ?");
        if (!$stmt) {
            return false;
        }

        $stmt->bind_param("ssi", $newStatus, $now, $vendorId);
        $success = $stmt->execute();

        return $success;
    }


    public function updateProductStock($productId, $vendorId, $newStockQty)
    {

        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        $newStockQty = filter_var($newStockQty, FILTER_VALIDATE_INT);

        if ($productId === false || $vendorId === false || $newStockQty === false) {
            return false;
        }

        $sql = "UPDATE tbl_products 
               SET stock_quantity = ? 
             WHERE id = ? AND vendor_id = ?";

        $result = $this->db->execute_query($sql, "iii", $newStockQty, $productId, $vendorId);

        if ($result) {

            return true;
        }

        return false;
    }

    public function submitArhiveProduct($productId, $vendorId, $product_status)
    {

        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);

        if ($productId === false || $vendorId === false) {
            return false;
        }
        $checkSql = "SELECT status FROM tbl_products WHERE vendor_id = ? AND id = ?";
        $res = $this->db->select($checkSql, "ii", $vendorId, $productId);
        $row = $res->fetch_assoc();
        if (strtolower($row['status']) !== 'archived') {
            return false;
        }
        $sql = "UPDATE tbl_products 
               SET status = ? 
             WHERE id = ? AND vendor_id = ?";

        $result = $this->db->execute_query($sql, "sii", $product_status, $productId, $vendorId);

        if ($result) {

            return true;
        }

        return false;
    }


    public function updateProductStockNew($productId, $vendorId, $addStockQty)
    {
        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        $addStockQty = filter_var($addStockQty, FILTER_VALIDATE_INT);

        if ($productId === false || $vendorId === false || $addStockQty === false) {
            return false;
        }

        $sql = "UPDATE tbl_products 
               SET stock_quantity = stock_quantity + ? 
             WHERE id = ? AND vendor_id = ?";

        $result = $this->db->execute_query($sql, "iii", $addStockQty, $productId, $vendorId);

        return (bool) $result;
    }

    public function updateVendorStatusOld($vendorId, $newStatus)
    {

        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        if ($vendorId === false) {
            return false;
        }

        $allowedStatuses = ['active', 'declined', 'pending', 'approved', 'restrict', 'restricted', 'unrestrict'];
        if (!in_array(strtolower($newStatus), $allowedStatuses)) {
            return false;
        }

        $stmt = $this->db->prepare("UPDATE tbl_vendors SET status = ? WHERE id = ?");
        if (!$stmt) {
            return false;
        }

        $stmt->bind_param("si", $newStatus, $vendorId);
        $success = $stmt->execute();

        return $success;
    }

    public function getVendorById($vendorId)
    {
        $stmt = $this->db->prepare("
        SELECT 
            id, name, email, username, global_id, address, type, business_name, 
            business_type_id, business_info, tax_id, cac_registration_number, 
            website, phone_number, state, state_code, city, bio, logo, title, 
            location, bank_account, status, created_at, updated_at
        FROM tbl_vendors
        WHERE id = ?
    ");

        if (!$stmt) {
            return false;
        }

        $stmt->bind_param("i", $vendorId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows > 0) {
            return $result->fetch_assoc();
        }

        return false;
    }
    public function approveVendorAccount($vendor)
    {
        $plainPassword = bin2hex(random_bytes(4));
        $hashedPassword = md5($plainPassword);
        $now = date('Y-m-d H:i:s');

        $stmt = $this->db->prepare("
        UPDATE tbl_vendors 
        SET password = ?, is_enabled = 1, global_id = ? , updated_at = ?
        WHERE id = ?
    ");


        if (!$stmt) {
            return false;
        }
        $stmt->bind_param('sisi', $hashedPassword, $vendor['id'], $now, $vendor['id']);
        //  $stmt->bind_param('si', $hashedPassword, $vendor['id']);

        if (!$stmt->execute()) {
            return false;
        }

        // --- Notify Vendor ---
        $subject = "Vendor Account Approved: " . $vendor['name'];
        $message = "Hello {$vendor['name']},\n\n" .
            "Your vendor account has been approved and is now active.\n\n" .
            "You can log in using the following credentials:\n" .
            "Username: {$vendor['username']}\n" .
            "Email Address: {$vendor['email']}\n" .
            "Password: {$plainPassword}\n\n" .
            "Please log in and change your password as soon as possible.\n\n" .
            "Best regards,\n" .
            "FOB Team";
        $headers = "From: no-reply@inclide.com\r\n";

        // Use your existing mail method
        $this->sendEmail($vendor['email'], 'reminder@fob.com.ng', $subject, $message);


        return true;
    }
    public function createCoverageLead($name, $email, $phone, $city, $address, $hasCoverage, $comment)
    {
        $ins = "INSERT INTO coverage_leads
        (id, name, email, phone, city, address, has_coverage, comment, created_at)
        VALUES (NULL, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP())";

        $types = 'sssssis';
        $params = [$name, $email, $phone, $city, $address, $hasCoverage ? 1 : 0, $comment];

        $result = $this->db->insert($ins, $types, ...$params);

        if ($result) {
            return true;
        } else {
            return false;
        }
    }

    public function createUserFromVendor($vendor, $adminID)
    {
        // Generate unique username and random password
        $username = $this->generateUniqueUsername($vendor['name']);
        $plainPassword = bin2hex(random_bytes(4));
        $mpass = md5($plainPassword);

        // Split full name
        $fullName = trim($vendor['name']);
        $nameParts = explode(" ", $fullName, 2);
        $firstname = $nameParts[0];
        $lastname = isset($nameParts[1]) ? $nameParts[1] : $nameParts[0];

        // Defaults for limits and service
        $download = 0;
        $upload = 0;
        $total = 0;
        $srvid = 1; // default service ID

        // Vendor info with fallback defaults
        $company = $vendor['business_name'] ?? 'N/A';
        $phoneNo = $vendor['phone'] ?? '0000000000';
        $email = $vendor['email'] ?? 'noemail@example.com';
        $address = $vendor['address'] ?: 'N/A';
        $city = $vendor['city'] ?: 'Unknown';
        $state = $vendor['state'] ?: 'Unknown';
        $zip = $vendor['zip'] ?? '00000';
        $comment = $vendor['comment'] ?? '';
        $ip = "0.0.0.0";
        $expiryDate = date("Y-m-d", strtotime("+2 years"));
        $createdOn = date("Y-m-d");
        $contractvalid = $expiryDate;
        $useme = "eService_" . $username;

        // Defaults for remaining NOT NULL fields
        $gpslat = 0;
        $gpslong = 0;
        $dd = date("Y-m-d");
        $ins = "
INSERT INTO rm_users (
    username, `password`, downlimit, uplimit, comblimit, 
    firstname, lastname, company,    phone, mobile, 
    email, address, city, zip, country, 
    state, `comment`, mac, expiration,    enableuser, 


    usemacauth, uptimelimit, srvid, staticipcm, staticipcpe, 
    ipmodecm, ipmodecpe,    createdon, acctype,  createdby, 
    taxid, maccm, credits, `owner`, groupid, 
    custattr, poolidcm, poolidcpe, contractid, contractvalid, 
    gpslong, gpslat, alertemail, alertsms, lang,
    macpswmode, cardfails, cnic, warningsent, verifycode, verified, selfreg, 
    verifyfails, verifysentnum, verifymobile, actcode, pswactsmsnum, autorenew
)                

VALUES (
    ?, ?, ?, ?, ?, 
    ?, ?, ?, ?, ?, 
    ?, ?, ?, '', 'Nigeria', 
   
 ?, '', '', ?, " . "'1',
    
     0, '0', ?, '', ?, 
                0, 2, '$dd', '0', ' $useme', 
    '' ,'', '0.00','admin', '1', 
    '', '0', '0', '', '$expiryDate', 
    '0', '0', 1, 1, 'English',
     0, 0,'', 0, '', 0, 0, 0, 0, '', '', 0,0
)";

        $values = [
            $username,      // username
            $mpass,         // password
            $download,      // downlimit
            $upload,        // uplimit
            $total,         // comblimit
            $firstname,     // firstname
            $lastname,      // lastname
            $company,       // company
            $phoneNo,       // phone
            $phoneNo,       // mobile
            $email,         // email
            $address,       // address
            $city,          // city
            $state,         // state
            $expiryDate,
            $srvid,            // mac
            $ip,    // expiration

        ];

        $typeString = 'ssiiissssssssssis';
        //        $typeString = 'ssiiissssssssssiss';
        // Debug: check placeholders vs values
        if (substr_count($ins, '?') !== count($values)) {
            // return [
            //     "error" => "Binding mismatch",
            //     "placeholders" => substr_count($ins, '?'),
            //     "values_count" => count($values),
            //     "values" => $values
            // ];/
            return false;
        }


        // Perform insert
        $saved = $this->db->insert($ins, $typeString, ...$values);


        //  return $saved;
        $qry = "SELECT username FROM rm_users WHERE username = ?";
        $some_sth = $this->db->select($qry, 's', $username);
        $rows = $some_sth->num_rows();


        if ($rows > 0) {
            // 3. Insert into tblclients
            $ins2 = "INSERT INTO tblclients (USERNAME, `PASSWORD`, RAD_USERNAME, IS_ENABLED, DATE_CREATED, USERTYPE, ADDED_BY)
                 VALUES (?, ?, ?, 0, NOW(),3, ?)";
            $this->db->insert($ins2, 'sssi', $username, sha1($mpass), $username, $adminID);


            $insertID = $this->db->insert_id;
            return $insertID;

            // return true;
            // return [
            //     'success'  => true,
            //     'username' => $username,
            //     'password' => $plainPassword
            // ];
        } else {
            // return [
            //     'error'    => 'User not found after insert into rm_users',
            //     'username' => $username
            // ];
            return false;
        }
    }

    private function generateUniqueUsername($vendorName)
    {
        // Take only the first word of vendor name (cleaned up)
        $baseName = preg_replace('/[^A-Za-z0-9]/', '', ucfirst(strtok($vendorName, ' ')));

        do {
            $username = $baseName . rand(10000, 99999);
            $stmt = $this->db->prepare("SELECT username FROM rm_users WHERE username = ?");
            $stmt->bind_param("s", $username);
            $stmt->execute();
            $result = $stmt->get_result();

            $exists = ($result && $result->num_rows > 0);
        } while ($exists);
        return $username;
    }

    public function getProductDetailsOld($productId)
    {
        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        if ($productId === false) {
            return null;
        }

        $stmt = $this->db->prepare("
        SELECT p.*, c.name AS category_name, c.description AS category_description
        FROM tbl_products p
        LEFT JOIN tbl_product_categories c ON p.category_id = c.id
        WHERE p.id = ?
    ");
        $stmt->bind_param("i", $productId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($product = $result->fetch_object()) {
            return $product;
        } else {
            return null;
        }
    }

    public function getProductDetails($productId)
    {
        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        if ($productId === false) {
            return null;
        }

        $stmt = $this->db->prepare("
SELECT
p.*,
c.name AS category_name,
c.description AS category_description,
i.id AS image_id,
i.filename,
i.uploaded_at
FROM tbl_products p
LEFT JOIN tbl_product_categories c ON p.category_id = c.id
LEFT JOIN marketplace_product_images i ON i.product_id = p.id
WHERE p.id = ?
ORDER BY i.id ASC
");

        $stmt->bind_param("i", $productId);
        $stmt->execute();
        $result = $stmt->get_result();

        $product = null;
        $images = [];
        $baseUrl = "public/uploads/products/";

        while ($row = $result->fetch_object()) {

            if (!$product) {
                $product = $row; // object
            }

            if (!empty($row->filename)) {
                $images[] = (object) [
                    'id' => $row->image_id,
                    'filename' => $baseUrl . $row->filename,
                    'uploaded_at' => $row->uploaded_at
                ];
            }
        }
        if (!$product) {
            return null; // product not found
        }

        $product->images = $images;

        $stmtSpec = $this->db->prepare(
            "SELECT id, product_id, name, value
         FROM tbl_product_specifications
         WHERE product_id = ?"
        );
        $stmtSpec->bind_param("i", $productId);
        $stmtSpec->execute();
        $specResult = $stmtSpec->get_result();

        $specifications = [];
        while ($row = $specResult->fetch_assoc()) {
            $specifications[] = [
                'id' => $row['id'],
                'name' => $row['name'],
                'value' => $row['value']
            ];
        }
        $product->specifications = $specifications;

        $stmtAttr = $this->db->prepare(
            "SELECT 
            pa.id AS attribute_id,
            pa.name AS attribute_name,
            pav.id AS value_id,
            pav.value AS attribute_value,
            pav.quantity
         FROM tbl_product_attributes pa
         INNER JOIN tbl_product_attribute_values pav 
            ON pa.id = pav.attribute_id
         WHERE pa.product_id = ?
         ORDER BY pa.name, pav.value"
        );
        $stmtAttr->bind_param("i", $productId);
        $stmtAttr->execute();
        $attrResult = $stmtAttr->get_result();

        $attributes = [];
        while ($row = $attrResult->fetch_assoc()) {
            $attrName = $row['attribute_name'];
            if (!isset($attributes[$attrName])) {
                $attributes[$attrName] = [];
            }
            $attributes[$attrName][] = [
                'value_id' => $row['value_id'],
                'value' => $row['attribute_value'],
                'quantity' => $row['quantity'],
                'attribute_id' => $row['attribute_id']
            ];
        }

        $product->attributes = $attributes;

        return $product;
        // if ($product) {
        //     $product->images = $images;
        //     return $product;
        // }

        // return null;
    }

    public function getAllCategories()
    {
        $result = $this->db->query("SELECT id, name,description  FROM tbl_product_categories ORDER BY name ASC");

        $categories = [];
        while ($category = $result->fetch_object()) {
            $categories[] = $category;
        }

        return $categories;
    }
    function formatDate($datetime)
    {
        return $datetime ? date('M d, Y', strtotime($datetime)) : 'N/A';
    }

    function formatPrice($price)
    {
        return 'NGN' . number_format($price, 2);
    }
    // public function updateProductStatus($productId, $action, $categoryId = null, $adminReason = null)
    // {
    //     // Validate inputs
    //     $productId = filter_var($productId, FILTER_VALIDATE_INT);
    //     $categoryId = filter_var($categoryId, FILTER_VALIDATE_INT);

    //     if ($productId === false) {
    //         return false; // invalid product ID
    //     }

    //     if ($action !== 'approve' && $action !== 'deny') {
    //         return false; // invalid action
    //     }

    //     if ($action === 'approve') {
    //         // Make sure category is valid and not null
    //         if ($categoryId === false || $categoryId === null) {
    //             return false; // category required for approve
    //         }
    //         $status = 'active';

    //         $stmt = $this->db->prepare("
    //         UPDATE tbl_products 
    //         SET status = ?, category_id = ?, admin_reason = NULL 
    //         WHERE id = ?
    //     ");
    //         $stmt->bind_param('sii', $status, $categoryId, $productId);
    //     } else {
    //         // Deny
    //         $status = 'rejected';
    //         if (empty($adminReason)) {
    //             return false; // admin reason required for deny
    //         }
    //         $stmt = $this->db->prepare("
    //         UPDATE tbl_products 
    //         SET status = ?, admin_reason = ? 
    //         WHERE id = ?
    //     ");
    //         $stmt->bind_param('ssi', $status, $adminReason, $productId);
    //     }

    //     return $stmt->execute();
    // }
    public function updateProductStatus($productId, $action, $categoryId = null, $adminReason = null)
    {
        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        $categoryId = filter_var($categoryId, FILTER_VALIDATE_INT);

        if ($productId === false) {
            return ['error' => false, 'message' => 'Invalid product ID'];
        }

        if ($action !== 'approve' && $action !== 'deny') {
            return ['error' => false, 'message' => 'Invalid action'];
        }

        if ($action === 'approve') {
            if ($categoryId === false || $categoryId === null) {
                return ['error' => false, 'message' => 'Category required for approval'];
            }
            $status = 'active';
            $stmt = $this->db->prepare("
            UPDATE tbl_products 
            SET status = ?, category_id = ?, admin_reason = NULL 
            WHERE id = ?
        ");
            $stmt->bind_param('sii', $status, $categoryId, $productId);
        } else {
            $status = 'rejected';
            if (empty($adminReason)) {
                return ['error' => false, 'message' => 'Admin reason required for denial'];
            }
            $stmt = $this->db->prepare("
            UPDATE tbl_products 
            SET status = ?, admin_reason = ? 
            WHERE id = ?
        ");
            $stmt->bind_param('ssi', $status, $adminReason, $productId);
        }

        if ($stmt->execute()) {
            return ['success' => true, 'message' => 'Product updated successfully.'];
        } else {
            return ['success' => false, 'message' => 'Database error '];
        }
    }

    public function getVendorsPaginated2($pager = 1, $limiter = 10)
    {
        $page = max(1, (int) $pager);
        $limit = max(1, (int) $limiter);
        $offset = ($page - 1) * $limit;

        $sql = "        SELECT v.*, totals.total_count         FROM tbl_vendors v
        JOIN (
            SELECT COUNT(*) AS total_count FROM tbl_vendors
        ) AS totals
        ORDER BY v.created_at DESC
        LIMIT {$limit} OFFSET {$offset}    ";

        $vendors = $this->db->select($sql)->fetch_all(MYSQLI_ASSOC);

        $total = $vendors ? $vendors[0]['total_count'] : 0;

        return [
            "data" => array_map(function ($vendor) {
                unset($vendor['total_count']);
                return $vendor;
            }, $vendors),
            "total" => (int) $total,
            "page" => $page,
            "limit" => $limit,
            "pages" => ceil($total / $limit)
        ];
    }
    public function getVendorAndBusinessTypes($globalId)
    {
        // 1. Get vendor info (if exists)
        $vendorQry = "SELECT * FROM tbl_vendors WHERE id = ?";
        $vendorRes = $this->db->select($vendorQry, 's', $globalId);
        $vendorData = null;
        if ($vendorRes->num_rows() > 0) {
            $vendorData = $vendorRes->fetch_assoc();
        }

        // 2. Get all business types
        $typesQry = "SELECT * FROM tbl_business_types ORDER BY type_name ASC";
        $typesRes = $this->db->select($typesQry);
        $businessTypes = [];
        while ($row = $typesRes->fetch_assoc()) {
            $businessTypes[] = $row;
        }
        // 3. Get state names only
        $statesQry = "SELECT * FROM tbl_states ORDER BY statename ASC";
        $statesRes = $this->db->select($statesQry);
        $stateNames = [];
        while ($row = $statesRes->fetch_assoc()) {
            $stateNames[] = [
                'statecode' => $row['STATECODE'],
                'statename' => $row['STATENAME']
            ];
        }
        // 3. Return both
        return [
            'vendor' => $vendorData,
            'business_types' => $businessTypes,
            'states' => $stateNames
        ];
    }

    public function addVendor2($data)
    {

        //        exit;
        // Required fields based on schema & business logic
        $required = [
            'name',
            'email',
            'global_id',
            'business_name',
            'business_type_id'
        ];

        // Validate required fields
        foreach ($required as $field) {
            if (!isset($data[$field]) || trim($data[$field]) === '') {
                return ['status' => 0, 'message' => "Missing required field: {$field}"];
            }
        }

        //        exit;
        // Prepare SQL - legacy style with parameter binding
        $sql = "INSERT INTO tbl_vendors 
        (name, email, username, global_id, address, type, 
             business_name, business_type_id, business_info, tax_id, 
             cac_registration_number, website, phone_number, state, state_code, 
             city, bio, logo, title, location, bank_account, status)           
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";        // $placeholderCount = substr_count($sql, '?');
        //error_log("Placeholder count: " . $placeholderCount);
        // Bind types: s = string, i = integer
        // business_type_id is integer, all others here are strings  
        // echo json_encode(['debug_data' => $sql]);
        // exit;
        $result = $this->db->insert(
            $sql,
            'sssssssisssssssssssssss',
            $data['name'],
            $data['email'],
            $data['global_id'],
            $data['global_id'],
            isset($data['address']) ? $data['address'] : "",
            isset($data['type']) ? $data['type'] : 'individual',
            $data['business_name'],
            (int) $data['business_type_id'],
            isset($data['business_info']) ? $data['business_info'] : null,
            isset($data['tax_id']) ? $data['tax_id'] : null,
            isset($data['cac_registration_number']) ? $data['cac_registration_number'] : null,
            isset($data['website']) ? $data['website'] : null,
            isset($data['phone_number']) ? $data['phone_number'] : null,
            isset($data['state']) ? $data['state'] : null,
            isset($data['state_code']) ? $data['state_code'] : null,
            isset($data['city']) ? $data['city'] : null,
            isset($data['bio']) ? $data['bio'] : null,
            isset($data['logo']) ? $data['logo'] : null,
            isset($data['title']) ? $data['title'] : null,
            isset($data['location']) ? $data['location'] : null,
            isset($data['bank_account']) ? $data['bank_account'] : null,
            isset($data['status']) ? $data['status'] : 'pending'
        );

        if ($result) {
            return ['success' => true, 'message' => 'Vendor added successfully'];
        } else {
            return ['error' => false, 'message' => 'Failed to add vendor'];
        }
    }


    public function addVendor($data)
    {
        $required = [
            'name',
            'email',
            'global_id',
            'business_name',
            'business_type_id'
        ];

        foreach ($required as $field) {
            if (!isset($data[$field]) || trim($data[$field]) === '') {
                return [
                    'status' => 0,
                    'message' => "Missing required field: {$field}"
                ];
            }
        }

        $sql = "INSERT INTO tbl_vendors 
        (name, email, username, global_id, address, type, 
         business_name, business_type_id, business_info, tax_id, 
         cac_registration_number, website, phone_number, state, state_code, 
         city, bio, logo, title, location, bank_account, status)           
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $types = 'sssssssissssssssssssss';

        // Pre-assign variables so they can be bound by reference
        $name = $data['name'];
        $email = $data['email'];
        $username = $data['usertype_id'];
        $global_id = $data['global_id'];
        $address = isset($data['address']) ? $data['address'] : "";
        $type = isset($data['type']) ? $data['type'] : 'individual';
        $business_name = $data['business_name'];
        $business_type_id = (int) $data['business_type_id'];
        $business_info = isset($data['business_info']) ? $data['business_info'] : null;
        $tax_id = isset($data['tax_id']) ? $data['tax_id'] : null;
        $cac_reg_no = isset($data['cac_registration_number']) ? $data['cac_registration_number'] : null;
        $website = isset($data['website']) ? $data['website'] : null;
        $phone_number = isset($data['phone_number']) ? $data['phone_number'] : null;
        $state = isset($data['state']) ? $data['state'] : null;
        $state_code = isset($data['state_code']) ? $data['state_code'] : null;
        $city = isset($data['city']) ? $data['city'] : null;
        $bio = isset($data['bio']) ? $data['bio'] : null;
        $logo = isset($data['logo']) ? $data['logo'] : null;
        $title = isset($data['title']) ? $data['title'] : null;
        $location = isset($data['location']) ? $data['location'] : null;
        $bank_account = isset($data['bank_account']) ? $data['bank_account'] : null;
        $status = isset($data['status']) ? $data['status'] : 'pending';

        // // Debug placeholder count vs types vs params
        // $placeholderCount = substr_count($sql, '?');
        // $paramCount       = 22; // manually checked

        // if ($placeholderCount !== strlen($types) || $placeholderCount !== $paramCount) {
        //     return json_encode([
        //         'error'            => 'Parameter count mismatch',
        //         'placeholderCount' => $placeholderCount,
        //         'typeStringLength' => strlen($types),
        //         'paramCount'       => $paramCount,
        //         'sql'              => $sql
        //     ]);
        // }

        // Prepare & bind manually for debugging
        $stmt = $this->db->prepare($sql);
        if (!$stmt) {
            return [
                'error' => 'Prepare failed',
                'message' => $this->db->error
            ];
        }

        if (
            !$stmt->bind_param(
                $types,
                $name,
                $email,
                $username,
                $global_id,
                $address,
                $type,
                $business_name,
                $business_type_id,
                $business_info,
                $tax_id,
                $cac_reg_no,
                $website,
                $phone_number,
                $state,
                $state_code,
                $city,
                $bio,
                $logo,
                $title,
                $location,
                $bank_account,
                $status
            )
        ) {
            return [
                'error' => "Bind failed",
                'message' => $stmt->error,
            ];
        }

        if (!$stmt->execute()) {
            return [
                'error' => "Execute failed",
                'message' => $stmt->error,
            ];
        }

        return [
            'success' => true,
            'message' => 'Vendor added successfully'
        ];
    }


    public function addVendorPublic($data)
    {

        $required = ['name', 'email', 'business_name'];
        foreach ($required as $field) {
            if (empty($data[$field]) || trim($data[$field]) === '') {
                return [
                    'status' => 'error',
                    'message' => "Missing required field: {$field}"
                ];
            }
        }


        $name = trim($data['name']);
        $email = filter_var($data['email'], FILTER_VALIDATE_EMAIL);
        if (!$email) {
            return ['status' => 'error', 'message' => 'Invalid email address'];
        }



        $global_id = "temp_" . bin2hex(random_bytes(8));
        //        $global_id        = trim($data['global_id']);
        $business_name = trim($data['business_name']);
        $business_type_id = (int) $data['business_type_id'];

        $website = $this->validateWebsite($data['website'] ?? null);
        $username = $global_id;
        $address = $data['address'] ?? '';
        $type = $data['type'] ?? 'individual';
        $business_info = $data['business_info'] ?? null;
        $tax_id = $data['tax'] ?? null;
        $cac_reg_no = $data['cac'] ?? null;
        $phone_number = $data['phone_number'] ?? null;
        $state = $data['state'] ?? null;
        $state_code = $data['state_code'] ?? null;
        $city = $data['city'] ?? null;
        $bio = $data['bio'] ?? null;
        $logo = $data['logo'] ?? null;
        $title = $data['title'] ?? null;
        $location = $data['location'] ?? null;
        $bank_account = $data['bank_account'] ?? null;
        $status = $data['status'] ?? 'pending';
        $now = date('Y-m-d H:i:s');
        //        $now = date('Y-m-d H:i:s');
        $sql = "INSERT INTO tbl_vendors 
        (name, email, username, global_id, address, type, 
         business_name, business_info, tax_id, 
         cac_registration_number, website, phone_number, state, state_code, 
         city, bio, logo, title, location, bank_account, status, updated_at)           
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";

        $types = 'ssssssssssssssssssssss';

        $stmt = $this->db->prepare($sql);
        if (!$stmt) {
            return [
                'status' => 'error',
                'message' => 'Internal server error'
            ];
        }

        if (
            !$stmt->bind_param(
                $types,
                $name,
                $email,
                $username,
                $global_id,
                $address,
                $type,
                $business_name,
                $business_info,
                $tax_id,
                $cac_reg_no,
                $website,
                $phone_number,
                $state,
                $state_code,
                $city,
                $bio,
                $logo,
                $title,
                $location,
                $bank_account,
                $status,
                $now
            )
        ) {
            return [
                'status' => 'error',
                'message' => 'Internal server error'
            ];
        }

        if (!$stmt->execute()) {
            return [
                'status' => 'error',
                'message' => 'Could not save vendor at this time or email already exist'
            ];
        }

        return [
            'status' => 'success',
            'message' => 'Vendor added successfully',
        ];
    }

    public function updateVendor($data)
    {
        // Check for required field
        if (!isset($data['global_id']) || trim($data['global_id']) === '') {
            return [
                'error' => false,
                'message' => 'Missing required field: global_id'
            ];
        }

        $global_id = $data['global_id'];

        // Check if vendor exists
        $checkSql = "SELECT id FROM tbl_vendors WHERE global_id = ?";
        $sth = $this->db->select($checkSql, "s", $global_id);
        if ($sth->num_rows() === 0) {
            return [
                'error' => false,
                'message' => 'Vendor not found'
            ];
        }
        $business_type_id = isset($data['business_type_id']) ? (int) $data['business_type_id'] : 0;

        // Fetch type_name from tbl_business_types
        $business_info = '';
        if ($business_type_id > 0) {
            $sql = "SELECT type_name FROM tbl_business_types WHERE id = ?";
            $res = $this->db->select($sql, "i", $business_type_id);
            if ($res && $res->num_rows > 0) {
                $row = $res->fetch_assoc();
                $business_info = $row['type_name'];
            }
        }
        // return [
        //     'success' => $data,
        //     'message' => 'Vendor found'
        // ];
        // exit();
        // SQL with same column order as addVendor
        $sql = "UPDATE tbl_vendors SET 
        name = ?, email = ?, username = ?, global_id = ?, address = ?, type = ?, 
        business_name = ?, business_type_id = ?, business_info = ?, tax_id = ?, 
        cac_registration_number = ?, website = ?, phone_number = ?, state = ?, state_code = ?, 
        city = ?, bio = ?, logo = ?, title = ?, location = ?, bank_account = ?, status = ?, updated_at =? 
        WHERE global_id = ?";
        $types = 'sssssssissssssssssssssss';

        // Variables in same order as addVendor
        $name = $data['name'] ?? '';
        $email = $data['email'] ?? '';
        $username = $data['global_id'];
        $global_id_field = $data['global_id']; // For SET clause
        $address = $data['address'] ?? "";
        $type = $data['type'] ?? 'individual';
        $business_name = $data['business_name'] ?? '';
        // if (!empty($data['business_type_id']) && strpos($data['business_type_id'], '::') !== false) {
        //     list($business_type_id, $business_info) = explode('::', $data['business_type_id'], 2);
        //     $business_type_id = (int)$business_type_id;
        // } else {
        //     $business_type_id = isset($data['business_type_id']) ? (int)$data['business_type_id'] : 0;
        //     $business_info    = $data['business_info'] ?? '';
        // }
        $tax_id = $data['tax_id'] ?? '';
        $cac_reg_no = $data['cac_registration_number'] ?? '';
        $website = $data['website'] ?? '';
        $phone_number = $data['phone_number'] ?? '';
        $state = $data['state'] ?? '';
        $state_code = $data['state_code'] ?? '';
        $city = $data['city'] ?? '';
        $bio = $data['bio'] ?? '';
        $logo = $data['logo'] ?? '';
        $title = $data['title'] ?? '';
        $location = $data['location'] ?? '';
        $bank_account = $data['bank_account'] ?? '';
        $status = $data['status'] ?? 'pending';
        $now = date('Y-m-d H:i:s');

        $where_global_id = $data['global_id']; // For WHERE clause
        // Debugging output before executing query
        //        $now = date('Y-m-d H:i:s');


        if (
            $this->db->execute_query(
                $sql,
                $types,
                $name,
                $email,
                $username,
                $global_id_field,
                $address,
                $type,
                $business_name,
                $business_type_id,
                $business_info,
                $tax_id,
                $cac_reg_no,
                $website,
                $phone_number,
                $state,
                $state_code,
                $city,
                $bio,
                $logo,
                $title,
                $location,
                $bank_account,
                $status,
                $now,
                $where_global_id
            )
        ) {
            return [
                'success' => true,
                'message' => 'Vendor updated successfully'
            ];
        } else {
            return [
                'error' => false,
                'message' => 'Failed to update vendor'
            ];
        }
    }

    //get fob vendor account type id
    public function getFobVendor()
    {
        $vendorQry = "
        SELECT v.id
        FROM tbl_vendors v
        JOIN tbl_admin_level a ON v.username = a.id
        WHERE a.ADMIN_TYPE LIKE '%fob vendor%'
    ";

        $vendorRes = $this->db->select($vendorQry);

        if ($vendorRes && $vendorRes->num_rows > 0) {
            $vendorIds = [];
            while ($row = $vendorRes->fetch_assoc()) {
                $vendorIds[] = (int) $row['id'];
            }
            return $vendorIds;
        }

        return [];
    }

    public function validateWebsite($url)
    {
        // Default to empty if null
        $url = trim($url ?? '');

        // If nothing entered, bail out
        if ($url === '') {
            return null;
        }

        // If no scheme (http/https/ftp etc.), prepend http://
        if (!preg_match('~^[a-z][a-z0-9+\-.]*://~i', $url)) {
            $url = 'https://' . $url;
        }

        // Now validate with filter_var
        return filter_var($url, FILTER_VALIDATE_URL) ?: null;
    }
    //sales agent code start from there

    public function getSalesDashboardOverview($user_id)
    {
        $salesagent_Id = $this->getSalesAdminState($user_id);

        if ($salesagent_Id === null) {
            // agent not found
            return null;
        }

        return $this->getAgentDashboardOverview($salesagent_Id);
    }





    public function getSalesAdminState($user_id)
    {
        $agentQry = "SELECT agent_id FROM tbl_salesagents WHERE user_id = ?";
        $agentRes = $this->db->select($agentQry, 'i', $user_id);

        if ($agentRes && $agentRes->num_rows() > 0) {
            $agentData = $agentRes->fetch_assoc();
            return (int) $agentData['agent_id'];
        }

        // Return null if agent not found
        return null;
    }


    public function getAgentDashboardOverview($agent_id)
    {



        // 1. Registered customers per agent
        $registeredRes = $this->db->select("
                SELECT COUNT(*) AS total_registered
FROM tbl_onboardingcustomers
WHERE salesagent_id = ?    ", 'i', [$agent_id])->fetch_object();

        // 2. Pending customers (not paid yet per agent)
        $pendingRes = $this->db->select("
    SELECT COUNT(*) AS total_pending
    FROM tbl_onboardingcustomers
    WHERE salesagent_id = ? AND status = 'pending'
", 'i', [$agent_id])->fetch_object();

        // 3. Paid customers per agent
        $paidRes = $this->db->select("
    SELECT COUNT(*) AS total_customers
    FROM tbl_onboardingcustomers
    WHERE salesagent_id = ? AND status = 'paid'
", 'i', [$agent_id])->fetch_object();

        return [
            "agent_id" => (int) $agent_id,
            "total_registered" => (int) ($registeredRes->total_registered ?? 0),
            "total_pending" => (int) ($pendingRes->total_pending ?? 0),
            "total_customers" => (int) ($paidRes->total_customers ?? 0),
        ];
    }

    public function getSalesadminPaid($user_id, $search = '', $status = 'paid', $page = 1, $limit = 10)
    {
        $salesagent_Id = $this->getSalesAdminState($user_id);

        if ($salesagent_Id === null) {
            // agent not found
            return null;
        }

        return $this->getAllPaidCustomers($salesagent_Id, $search, $status, $page, $limit);
    }


    public function getSalesadminPending($user_id)
    {



        $salesagent_Id = $this->getSalesAdminState($user_id);

        if ($salesagent_Id === null) {
            // agent not found
            return null;
        }

        return $this->getLast10PendingCustomers($salesagent_Id);
    }

    public function getLast10PendingCustomers($agent_id)
    {
        $query = "        SELECT 
    customer_id, location,
    name AS customer_name,
    phone AS customer_phone,
    email AS customer_email,
    address AS customer_address,
    created_at,
    salesagent_id
FROM tbl_onboardingcustomers
WHERE status = 'pending' AND salesagent_id = ?
ORDER BY created_at DESC
LIMIT 10    ";

        $result = $this->db->select($query, 'i', $agent_id);

        $customers = [];
        while ($row = $result->fetch_assoc()) {
            $customers[] = $row;
        }

        return $customers;
    }
    public function getAllPaidCustomers($agent_id, $search = null, $status = 'paid', $page = 1, $limit = 10)
    {
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 10;
        }

        $offset = ($page - 1) * $limit;

        $whereClauses = ["c.salesagent_id = ?"];
        $params = [$agent_id];
        $types = "i";

        // Only filter by status if not 'all'
        if (!empty($status) && $status !== 'all') {
            $whereClauses[] = "c.status = ?";
            $params[] = $status;
            $types .= "s";
        }

        if (!empty($search)) {
            $search = "%" . $search . "%";
            $whereClauses[] = "(c.email LIKE ? OR c.tracking_id LIKE ? OR so.sales_order_id LIKE ?)";
            $params[] = $search;
            $params[] = $search;
            $params[] = $search;
            $types .= "sss";
        }


        $whereQuery = "WHERE " . implode(" AND ", $whereClauses);

        // 🧮 Count total (all paid for this agent)
        $countSql = "
        SELECT COUNT(*) AS total_count
        FROM tbl_onboardingcustomers c
        LEFT JOIN tbl_salesorders so 
            ON so.customer_id = c.customer_id
        $whereQuery
    ";

        $countStmt = $this->db->prepare($countSql);
        $countStmt->bind_param($types, ...$params);
        $countStmt->execute();
        $countRes = $countStmt->get_result()->fetch_object();
        $totalCount = $countRes ? (int) $countRes->total_count : 0;


        $sql = "
        SELECT 
            c.customer_id,
            c.tracking_id,
            c.name AS customer_name,
            c.phone AS customer_phone,
            c.email AS customer_email,
            c.address AS customer_address,
            c.created_at,
            c.status,
            so.sales_order_id,
            so.order_id,
            so.total_price
        FROM tbl_onboardingcustomers c
        LEFT JOIN tbl_salesorders so 
            ON so.customer_id = c.customer_id
        $whereQuery
        ORDER BY c.created_at DESC
        LIMIT ? OFFSET ?
    ";

        $params[] = $limit;
        $params[] = $offset;
        $types .= "ii";

        $stmt = $this->db->prepare($sql);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();

        $customers = [];
        while ($row = $result->fetch_assoc()) {
            $customers[] = $row;
        }

        return [
            'customers' => $customers,
            'total_count' => $totalCount,
            'limit' => $limit,
            'page' => $page,
            'search' => $search ? trim($search, "%") : null,
            'status' => $status,
            'total_pages' => ceil($totalCount / $limit)
        ];
    }



    public function getAllSalesadminCustomers($user_id, $search = '', $status = null, $limit = 10, $page = 1)
    {
        $salesagent_Id = $this->getSalesAdminState($user_id);

        if ($salesagent_Id === null) {
            // agent not found
            return null;
        }

        $offset = ($page - 1) * $limit;

        return $this->getAllCustomers($salesagent_Id, $search, $status, $limit, $offset);
    }

    public function getAllCustomers(
        $agent_id,
        $search = null,
        $status = null,
        $page = 1,
        $limit = 10
    ) {
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 10;
        }

        $offset = ($page - 1) * $limit;

        $whereClauses = ["c.salesagent_id = ?"];
        $params = [$agent_id];
        $types = "i";
        if (!empty($status)) {
            $whereClauses[] = "so.status = ?";
            $params[] = $status;
            $types .= "s";
        }

        if (!empty($search)) {
            $search = "%" . $search . "%";
            $whereClauses[] = "(c.email LIKE ? OR c.tracking_id LIKE ? OR so.sales_order_id LIKE ?)";
            $params[] = $search;
            $params[] = $search;
            $params[] = $search;
            $types .= "sss";
        }

        $whereQuery = "WHERE " . implode(" AND ", $whereClauses);

        $countSql = "
        SELECT COUNT(*) AS total
        FROM tbl_onboardingcustomers c
        LEFT JOIN tbl_salesorders so
            ON so.customer_id = c.customer_id
        $whereQuery
    ";

        $countStmt = $this->db->prepare($countSql);
        $countStmt->bind_param($types, ...$params);
        $countStmt->execute();
        $countRes = $countStmt->get_result()->fetch_object();
        $totalCount = $countRes ? (int) $countRes->total : 0;

        $sql = "
        SELECT
            c.customer_id,
            c.tracking_id,
            c.name AS customer_name,
            c.phone AS customer_phone,
            c.email AS customer_email,
            c.address AS customer_address,
            c.created_at AS onboarded_at,

            so.sales_order_id,
            so.order_id,
            so.status,
            so.total_price,
            so.created_at AS order_created_at
        FROM tbl_onboardingcustomers c
        LEFT JOIN tbl_salesorders so
            ON so.customer_id = c.customer_id

        $whereQuery
        ORDER BY c.created_at DESC
        LIMIT ? OFFSET ?
    ";

        $params[] = $limit;
        $params[] = $offset;
        $types .= "ii";

        $stmt = $this->db->prepare($sql);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();

        $customers = [];
        while ($row = $result->fetch_assoc()) {
            $customers[] = $row;
        }

        return [
            'customers' => $customers,
            'total_count' => $totalCount,
            'limit' => $limit,
            'page' => $page,
            'search' => $search ? trim($search, "%") : null,
            'status' => $status,
            'total_pages' => ceil($totalCount / $limit)
        ];
    }



    public function oldgetAgentEarnings($agent_id)
    {
        // Ensure valid ID
        if (empty($agent_id)) {
            return ['total' => 0, 'month' => 0];
        }

        // SQL for total and monthly earnings
        $sql = "
        SELECT 
            SUM(CASE WHEN so.status = 'paid' THEN so.total_price ELSE 0 END) AS total_earnings,
            SUM(CASE 
                    WHEN so.status = 'paid' 
                     AND MONTH(so.payment_date) = MONTH(CURRENT_DATE())
                     AND YEAR(so.payment_date) = YEAR(CURRENT_DATE())
                    THEN so.total_price 
                    ELSE 0 
                END
            ) AS month_earnings
        FROM tbl_salesorders so
        WHERE so.agent_id = ?
    ";

        $stmt = $this->db->prepare($sql);
        $stmt->bind_param('i', $agent_id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();

        // Return cleanly formatted numbers
        return [
            'total' => (float) ($result['total_earnings'] ?? 0),
            'month' => (float) ($result['month_earnings'] ?? 0)
        ];
    }
    public function getAgentEarnings($agent_id)
    {
        if (empty($agent_id)) {
            return [
                'total' => 0,
                'month' => 0,
                'total_commission' => 0,
                'month_commission' => 0
            ];
        }

        $sql = "
        SELECT 
            -- Earnings
            SUM(
                CASE 
                    WHEN so.status = 'paid' 
                    THEN so.total_price 
                    ELSE 0 
                END
            ) AS total_earnings,

            SUM(
                CASE 
                    WHEN so.status = 'paid'
                     AND MONTH(so.payment_date) = MONTH(CURRENT_DATE())
                     AND YEAR(so.payment_date) = YEAR(CURRENT_DATE())
                    THEN so.total_price 
                    ELSE 0 
                END
            ) AS month_earnings,

            -- Commissions (NULL-safe)
            SUM(
                CASE 
                    WHEN so.status = 'paid' 
                    THEN COALESCE(so.agent_commission, 0) 
                    ELSE 0 
                END
            ) AS total_commission,

            SUM(
                CASE 
                    WHEN so.status = 'paid'
                     AND MONTH(so.payment_date) = MONTH(CURRENT_DATE())
                     AND YEAR(so.payment_date) = YEAR(CURRENT_DATE())
                    THEN COALESCE(so.agent_commission, 0) 
                    ELSE 0 
                END
            ) AS month_commission

        FROM tbl_salesorders so
        WHERE so.agent_id = ?
    ";

        $stmt = $this->db->prepare($sql);
        $stmt->bind_param('i', $agent_id);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();

        return [
            'total' => (float) ($result['total_earnings'] ?? 0),
            'month' => (float) ($result['month_earnings'] ?? 0),
            'total_commission' => (float) ($result['total_commission'] ?? 0),
            'month_commission' => (float) ($result['month_commission'] ?? 0),
        ];
    }


    public function getallPaidCustomersoldworking($agent_id)
    {
        $query = "

        SELECT 
            c.customer_id,  c.tracking_id,
            c.name AS customer_name,
            c.phone AS customer_phone,             c.email AS customer_email,  c.address AS customer_address,

            c.created_at,
            sa.agent_id,
            sa.location,     so.sales_order_id ,     so.total_price
        FROM tbl_onboardingcustomers c
        LEFT JOIN tbl_salesagents sa 
            ON sa.agent_id = c.salesagent_id LEFT JOIN tbl_salesorders so 
    ON so.customer_id = c.customer_id
        WHERE so.status = 'paid' AND sa.agent_id = ?
        ORDER BY c.created_at DESC ";

        $result = $this->db->select($query, 'i', $agent_id);

        $customers = [];
        while ($row = $result->fetch_assoc()) {
            $customers[] = $row;
        }

        return $customers;
    }


    public function getPaidOrdersByMonth($agent_id, $year = null)
    {
        if ($year === null) {
            $year = date('Y');
        }

        $query = "


        SELECT 
    m.month_name,
    m.month_num,
    COALESCE(COUNT(s.order_id), 0) AS total_orders,
    COALESCE(SUM(s.agent_commission), 0) AS agent_commission,
    COALESCE(SUM(s.total_price), 0) AS total_sales
FROM tbl_sales_months m
LEFT JOIN tbl_salesorders s 
    ON MONTH(s.payment_date) = m.month_num
    AND YEAR(s.payment_date) = ?
    AND s.agent_id = ?
    AND s.status = 'paid'
GROUP BY m.month_num, m.month_name
ORDER BY m.month_num;


    
    ";

        $result = $this->db->select($query, 'ii', $year, $agent_id);

        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        return $data;
    }



    public function getPaidOrdersWithCustomerDetailswrkn(
        $agent_id,
        $month = null,
        $year = null,
        $start_date = null,
        $end_date = null
    ) {
        if ($month === null) {
            $month = date('m');
        }

        if ($year === null) {
            $year = date('Y');
        }

        $params = [];
        $types = '';

        $query = "
        SELECT 
            s.order_id,
            s.customer_id,
            s.total_price,
            s.agent_commission,
            s.payment_date AS order_created_at,
            s.status AS order_status,
            c.*
        FROM tbl_salesorders s
        INNER JOIN tbl_onboardingcustomers c 
            ON s.customer_id = c.customer_id
        WHERE 
            s.agent_id = ?
            AND s.status = 'paid'
    ";

        $params[] = $agent_id;
        $types .= 'i';

        if (!empty($start_date) && !empty($end_date)) {

            $start_date .= " 00:00:00";
            $end_date .= " 23:59:59";

            $query .= " AND s.payment_date BETWEEN ? AND ?";
            $params[] = $start_date;
            $params[] = $end_date;
            $types .= 'ss';
        } else {
            $query .= " AND MONTH(s.payment_date) = ? AND YEAR(s.payment_date) = ?";
            $params[] = (int) $month;
            $params[] = (int) $year;
            $types .= 'ii';
        }

        $query .= " ORDER BY s.payment_date DESC";

        $result = $this->db->select($query, $types, ...$params);

        $data = [];
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
        }

        return $data;
    }




    public function getPaidOrdersWithCustomerDetails($agent_id, $month, $year = null)
    {
        if ($year === null) {
            $year = date('Y');
        }

        $query = "
        SELECT 
            s.order_id,
            s.customer_id,
            s.total_price, s.agent_commission,
            s.created_at AS order_created_at,
            s.status AS order_status,
            c.*
        FROM tbl_salesorders s
        INNER JOIN tbl_onboardingcustomers c 
            ON s.customer_id = c.customer_id
        WHERE 
            s.agent_id = ?
            AND s.status = 'paid'
            AND MONTH(s.created_at) = ?
            AND YEAR(s.created_at) = ?
        ORDER BY s.created_at DESC;
    ";

        $result = $this->db->select($query, 'iii', $agent_id, $month, $year);

        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        return $data;
    }




    public function getCustomerFromSalesOrder($orderId, $agentId)
    {

        if (!is_numeric($orderId) || !is_numeric($agentId)) {
            return null;
        }


        $sql = "
        SELECT 
so.transaction_id,
so.sales_order_id,  so.payment_date, 

oc.appointment_date, so.agent_commission,
            oc.name,
            oc.email,
            oc.phone,
            oc.address,
            oc.plan_type,
            oc.plan_id,
            oc.plan_name,
            oc.plan_amount,
            oc.otc_cost,
            oc.total_amount,
            oc.status
        FROM tbl_salesorders AS so
        INNER JOIN tbl_onboardingcustomers AS oc
            ON oc.customer_id = so.customer_id
        WHERE so.order_id = ?
          AND so.agent_id = ?
        LIMIT 1
    ";

        $stmt = $this->db->prepare($sql);

        if (!$stmt) {
            return null;
        }

        $stmt->bind_param("ii", $orderId, $agentId);
        $stmt->execute();

        $result = $stmt->get_result();

        if ($data = $result->fetch_object()) {


            if (isset($data->plan_amount)) {
                $data->plan_amount = floatval($data->plan_amount);
            }
            if (isset($data->total_amount)) {
                $data->total_amount = floatval($data->total_amount);
            }

            return $data;
        }

        return null;
    }








    function generateTrackingLink($order_number)
    {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";

        $host = $_SERVER['HTTP_HOST'];

        $appFolder = '/eservice/';

        $baseUrl = $protocol . $host . $appFolder;
        $generatedLink = $baseUrl . "tracking_id_public.php?order=" . base64_encode($order_number);

        //        $generatedLink = $baseUrl . "tracking_id_public/" . base64_encode($order_number);

        return $generatedLink;
    }







    public function oldaddCustomerOrder($data)
    {
        $required = [
            'name',
            'email',
            'phone',
            'address',
            'salesagent_id',
            'products' // array of product_ids
        ];

        foreach ($required as $field) {
            if (!isset($data[$field]) || (is_string($data[$field]) && trim($data[$field]) === '') || (is_array($data[$field]) && count($data[$field]) === 0)) {
                return [
                    'error' => 0,
                    'message' => "Missing required field: {$field}"
                ];
            }
        }
        $product_id = (int) $data['product_id'];
        $this->db->autocommit(false); // 🚦 Start transaction
        $all_query_ok = true;

        // Step 1: Insert into tbl_onboardingcustomers
        $sqlCustomer = "INSERT INTO tbl_onboardingcustomers
        (salesagent_id, name, email, phone, address, company_name, comment, hear_about_us, status, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'pending', NOW())";

        $stmtCust = $this->db->prepare($sqlCustomer);
        if (!$stmtCust) {
            return ['error' => 'Prepare failed (customer)', 'message' => $this->db->error];
        }

        $company = $data['company_name'] ?? null;
        $comment = $data['any_comment'] ?? null;
        $howHear = $data['how_hear'] ?? null;

        $stmtCust->bind_param(
            "isssssss",
            $data['salesagent_id'],
            $data['name'],
            $data['email'],
            $data['phone'],
            $data['address'],
            $company,
            $comment,
            $howHear
        );

        $all_query_ok = $stmtCust->execute();
        if (!$all_query_ok) {
            $err = $stmtCust->error;
            $stmtCust->close();
            $this->db->rollback();
            $this->db->autocommit(true);
            return [
                'error' => false,
                'stage' => 'Insert Customer',
                'message' => $err,
                'sql' => $sqlCustomer
            ];
        }
        $customer_id = $stmtCust->insert_id;
        $stmtCust->close();
        $sales_order_id = "SO-" . date("Ymd-His") . "-" . mt_rand(1000, 9999);

        $checkout_link = "https://yourapp.com/checkout/" . $sales_order_id;

        if ($all_query_ok) {
            $sqlOrder = "INSERT INTO tbl_salesorders
              (sales_order_id, customer_id, agent_id, total_price, status, checkout_link, created_at)
    VALUES (?, ?, ?, ?, 'pending', ?, NOW())";

            $stmtOrder = $this->db->prepare($sqlOrder);
            if (!$stmtOrder) {
                $this->db->rollback();
                return ['error' => 'Prepare failed (order)', 'message' => $this->db->error];
            }

            $products = json_encode($data['products']);
            $total = $data['total_amount'] ?? 0;
            $checkoutLink = "/checkout/temp";
            $productId = $data['product_id'];




            $stmtOrder->bind_param(


                "siids",
                $sales_order_id,
                $customer_id,
                $data['salesagent_id'],
                $total,
                $checkoutLink
            );

            $all_query_ok = $stmtOrder->execute();
            if (!$all_query_ok) {
                $err = $stmtOrder->error;
                $stmtOrder->close();
                $this->db->rollback();
                $this->db->autocommit(true);
                return [
                    'error' => true,
                    'stage' => 'Insert Order',
                    'message' => $err,
                    'sql' => $sqlOrder
                ];
            }
            $order_id = $stmtOrder->insert_id;
            $stmtOrder->close();
        }
        $sqlItem = "INSERT INTO tbl_salesorder_items (order_id, product_id, qty, price, created_at) 
                VALUES (?, ?, ?, ?, NOW())";
        $stmtItem = $this->db->prepare($sqlItem);
        if (!$stmtItem) {
            $this->db->rollback();
            return ['error' => false, 'stage' => 'Prepare Items', 'message' => $this->db->error];
        }

        foreach ($data['products'] as $product_id) {
            $qty = 1;
            $price = 0;
            $stmtItem->bind_param("iiid", $order_id, $product_id, $qty, $price);

            $all_query_ok = $stmtItem->execute();
            if (!$all_query_ok) {
                $err = $stmtItem->error;
                $stmtItem->close();
                $this->db->rollback();
                $this->db->autocommit(true);
                return ['error' => false, 'stage' => 'Insert Items', 'message' => $err];
            }
        }
        $stmtItem->close();

        if ($all_query_ok) {
            $generatedLink = "/checkout/" . base64_encode($order_id);
            $all_query_ok = $this->db->query(
                "
            UPDATE tbl_salesorders 
            SET checkout_link = '" . $this->db->real_escape_string($generatedLink) . "' 
            WHERE id = " . (int) $order_id
            );
        }

        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(true);

            return [
                'success' => true,
                'message' => 'Customer order created successfully',
                'customer_id' => $customer_id,
                'order_id' => $order_id,
                'checkout_link' => $generatedLink
            ];
        } else {
            $this->db->rollback();
            $this->db->autocommit(true);

            return [
                'error' => false,
                'message' => 'Failed to create customer order. Transaction rolled back.',
                'last_error' => $this->db->error,
                'last_query' => $this->db->info
            ];
        }
    }


    public function addCustomerOrder($data)
    {
        $required = [
            'name',
            'email',
            'phone',
            'address',
            //            'salesagent_id',
            'products' // array of product_ids
        ];
        // return $data;
        foreach ($required as $field) {
            if (!isset($data[$field]) || (is_string($data[$field]) && trim($data[$field]) === '') || (is_array($data[$field]) && count($data[$field]) === 0)) {
                return [
                    'error' => true,
                    'message' => "Missing required field: {$field}"
                ];
            }
        }

        if (empty($data['product_information'])) {
            return ['error' => true, 'message' => 'Missing required field: product_information'];
        }
        $productInfo = json_decode($data['product_information'], true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            return ['error' => true, 'message' => 'Invalid JSON format in product_information'];
        }

        if (!is_array($productInfo) || count($productInfo) === 0) {
            return ['error' => true, 'message' => 'product_information must contain at least one product'];
        }
        // 🧠 Extract fields
        $plan_id = $productInfo[0]['id'] ?? null;
        $plan_name = $productInfo[0]['name'] ?? null;
        $plan_amount = $productInfo[0]['price'] ?? null;
        $plan_location = $productInfo[0]['plan_location'] ?? null;
        $plan_type = $productInfo[0]['plan_category'] ?? null;
        $no_of_months = $productInfo[0]['quantity'] ?? null;
        $otc_cost = isset($productInfo[1]) ? $productInfo[1]['price'] ?? null : null;
        $this->db->autocommit(false); // 🚦 Start transaction
        $all_query_ok = true;
        $phones = !empty($data['additionalPhones'])
            ? array_filter(array_map('trim', explode(',', $data['additionalPhones'])))
            : [];
        $emails = !empty($data['additionalEmails'])
            ? array_filter(array_map('trim', explode(',', $data['additionalEmails'])))
            : [];

        $phonesJson = json_encode($phones);
        $emailsJson = json_encode($emails);
        $order_number = "SO-" . date("Ymd-His") . "-" . mt_rand(1000, 9999);

        // Step 1: Insert into tbl_onboardingcustomers
        $sqlCustomer = "INSERT INTO tbl_onboardingcustomers
        (salesagent_id, name, email, phone, address, company_name, comment, hear_about_us, phone_alt, email_alt, plan_id, plan_name, plan_amount, otc_cost,tracking_id,plan_type,location,no_of_months, status, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?,?, ?,?, ?, ?,?, 'pending', NOW())";

        $stmtCust = $this->db->prepare($sqlCustomer);
        if (!$stmtCust) {
            return ['error' => true, 'stage' => 'Prepare Customer', 'message' => $this->db->error];
        }

        $company = $data['company_name'] ?? null;
        $comment = $data['comment'] ?? null;
        $howHear = $data['source'] ?? null;

        $stmtCust->bind_param(
            "isssssssssisddsssi",
            $data['salesagent_id'],
            $data['name'],
            $data['email'],
            $data['phone'],
            $data['address'],
            $company,
            $comment,
            $howHear,
            $phonesJson,
            $emailsJson,
            $plan_id,
            $plan_name,
            $plan_amount,
            $otc_cost,
            $order_number,
            $plan_type,
            $plan_location,
            $no_of_months

        );

        $all_query_ok = $stmtCust->execute();
        if (!$all_query_ok) {
            $err = $stmtCust->error;
            $stmtCust->close();
            $this->db->rollback();
            $this->db->autocommit(true);
            return ['error' => true, 'stage' => 'Insert Customer', 'message' => "insert error"];
        }
        $customer_id = $stmtCust->insert_id;
        $stmtCust->close();

        // Step 2: Insert into tbl_salesorders
        //      $checkoutLink = "/checkout/" . base64_encode($order_id);

        $checkoutLink = "/checkout/temp";
        // $total = $data['total_amount'] ?? 0;
        $planAmount = (float) $plan_amount;
        $otcCost = (float) $otc_cost;
        $total = $planAmount + $otcCost;

        $sqlOrder = "INSERT INTO tbl_salesorders
        ( customer_id, agent_id, total_price, status, checkout_link, created_at)
        VALUES ( ?, ?, ?, 'pending', ?, NOW())";

        $stmtOrder = $this->db->prepare($sqlOrder);
        if (!$stmtOrder) {
            $this->db->rollback();
            return ['error' => true, 'stage' => 'Prepare Order', 'message' => "prepare order error"];
        }

        $stmtOrder->bind_param(
            "iids",

            $customer_id,
            $data['salesagent_id'],
            $total,
            $checkoutLink
        );

        $all_query_ok = $stmtOrder->execute();
        if (!$all_query_ok) {
            $err = $stmtOrder->error;
            $stmtOrder->close();
            $this->db->rollback();
            $this->db->autocommit(true);
            return ['error' => true, 'stage' => 'Insert Order', 'message' => "error"];
        }
        $order_id = $stmtOrder->insert_id; // 🔑 this is tbl_salesorders.order_id (PK)
        $stmtOrder->close();



        // Step 3: Update checkout_link with encoded order_id
        if ($all_query_ok) {

            $generatedLink = $this->generateTrackingLink($order_number);


            // $generatedLink = "https://fob.ng/self_onboarding/checkout/" . base64_encode($order_number);
            $all_query_ok = $this->db->query(
                "UPDATE tbl_salesorders 
             SET checkout_link = '" . $this->db->real_escape_string($generatedLink) . "' ,
             sales_order_id = '$order_number' 
             WHERE order_id = " . (int) $order_id
            );
        }

        // Commit or rollback
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(true);
            return [
                'success' => true,
                'message' => 'Customer order created successfully',
                'customer_id' => $customer_id,
                'order_id' => $order_id,
                'order_number' => $order_number,
                'checkout_link' => $generatedLink
            ];
        } else {
            $this->db->rollback();
            $this->db->autocommit(true);
            return [
                'error' => true,
                'message' => 'Failed to create customer order. Transaction rolled back.',
                'last_error' => $this->db->error
            ];
        }
    }
    public function addCustomerOrderPublic($data)
    {
        $required = [
            'name',
            'email',
            'phone',
            'address',
            //            'salesagent_id',
            'products' // array of product_ids
        ];
        // return $data;
        foreach ($required as $field) {
            if (!isset($data[$field]) || (is_string($data[$field]) && trim($data[$field]) === '') || (is_array($data[$field]) && count($data[$field]) === 0)) {
                return [
                    'error' => true,
                    'message' => "Missing required field: {$field}"
                ];
            }
        }

        if (empty($data['product_information'])) {
            return ['error' => true, 'message' => 'Missing required field: product_information'];
        }
        $productInfo = json_decode($data['product_information'], true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            return ['error' => true, 'message' => 'Invalid JSON format in product_information'];
        }

        if (!is_array($productInfo) || count($productInfo) === 0) {
            return ['error' => true, 'message' => 'product_information must contain at least one product'];
        }
        // 🧠 Extract fields
        $plan_id = $productInfo[0]['id'] ?? null;
        $plan_name = $productInfo[0]['name'] ?? null;
        $plan_amount = $productInfo[0]['price'] ?? null;
        $plan_location = $productInfo[0]['plan_location'] ?? null;
        $plan_type = $productInfo[0]['plan_category'] ?? null;
        $no_of_months = $productInfo[0]['quantity'] ?? null;
        $otc_cost = isset($productInfo[1]) ? $productInfo[1]['price'] ?? null : null;
        $this->db->autocommit(false); // 🚦 Start transaction
        $all_query_ok = true;
        $phones = !empty($data['additionalPhones'])
            ? array_filter(array_map('trim', explode(',', $data['additionalPhones'])))
            : [];
        $emails = !empty($data['additionalEmails'])
            ? array_filter(array_map('trim', explode(',', $data['additionalEmails'])))
            : [];

        $phonesJson = json_encode($phones);
        $emailsJson = json_encode($emails);
        $order_number = "SO-" . date("Ymd-His") . "-" . mt_rand(1000, 9999);

        // Step 1: Insert into tbl_onboardingcustomers
        $sqlCustomer = "INSERT INTO tbl_onboardingcustomers
        (salesagent_id, name, email, phone, address, company_name, comment, hear_about_us, phone_alt, email_alt, plan_id, plan_name, plan_amount, otc_cost,tracking_id,plan_type,location,no_of_months, status, created_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?,?, ?,?, ?, ?,?, 'pending', NOW())";

        $stmtCust = $this->db->prepare($sqlCustomer);
        if (!$stmtCust) {
            return ['error' => true, 'stage' => 'Prepare Customer', 'message' => $this->db->error];
        }

        $company = $data['company_name'] ?? null;
        $comment = $data['comment'] ?? null;
        $howHear = $data['source'] ?? null;

        $stmtCust->bind_param(
            "isssssssssisddsssi",
            $data['salesagent_id'],
            $data['name'],
            $data['email'],
            $data['phone'],
            $data['address'],
            $company,
            $comment,
            $howHear,
            $phonesJson,
            $emailsJson,
            $plan_id,
            $plan_name,
            $plan_amount,
            $otc_cost,
            $order_number,
            $plan_type,
            $plan_location,
            $no_of_months

        );

        $all_query_ok = $stmtCust->execute();
        if (!$all_query_ok) {
            $err = $stmtCust->error;
            $stmtCust->close();
            $this->db->rollback();
            $this->db->autocommit(true);
            return ['error' => true, 'stage' => 'Insert Customer', 'message' => "insert error"];
        }
        $customer_id = $stmtCust->insert_id;
        $stmtCust->close();

        $userid = $this->createUserFromVendor($data, 1);
        if ($userid !== false) {
            $agentID = $this->createSalesAgent($userid);
        }
        $stmtupdate = $this->db->prepare(
            "UPDATE tbl_onboardingcustomers 
     SET salesagent_id = ? 
     WHERE customer_id = ?"
        );
        $stmtupdate->bind_param("ii", $agentID, $customer_id);
        $stmtupdate->execute();
        // Step 2: Insert into tbl_salesorders
        //      $checkoutLink = "/checkout/" . base64_encode($order_id);

        $checkoutLink = "/checkout/temp";
        // $total = $data['total_amount'] ?? 0;
        $planAmount = (float) $plan_amount;
        $otcCost = (float) $otc_cost;
        $total = $planAmount + $otcCost;

        $sqlOrder = "INSERT INTO tbl_salesorders
        ( customer_id, agent_id, total_price, status, checkout_link, created_at)
        VALUES ( ?, ?, ?, 'pending', ?, NOW())";

        $stmtOrder = $this->db->prepare($sqlOrder);
        if (!$stmtOrder) {
            $this->db->rollback();
            return ['error' => true, 'stage' => 'Prepare Order', 'message' => "prepare order error"];
        }

        $stmtOrder->bind_param(
            "iids",

            $customer_id,
            $agentID,
            $total,
            $checkoutLink
        );

        $all_query_ok = $stmtOrder->execute();
        if (!$all_query_ok) {
            $err = $stmtOrder->error;
            $stmtOrder->close();
            $this->db->rollback();
            $this->db->autocommit(true);
            return ['error' => true, 'stage' => 'Insert Order', 'message' => "error"];
        }
        $order_id = $stmtOrder->insert_id; // 🔑 this is tbl_salesorders.order_id (PK)
        $stmtOrder->close();



        // Step 3: Update checkout_link with encoded order_id
        if ($all_query_ok) {

            $generatedLink = $this->generateTrackingLink($order_number);


            // $generatedLink = "https://fob.ng/self_onboarding/checkout/" . base64_encode($order_number);
            $all_query_ok = $this->db->query(
                "UPDATE tbl_salesorders 
             SET checkout_link = '" . $this->db->real_escape_string($generatedLink) . "' ,
             sales_order_id = '$order_number' 
             WHERE order_id = " . (int) $order_id
            );
        }

        // Commit or rollback
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(true);
            return [
                'success' => true,
                'message' => 'Customer order created successfully',
                'customer_id' => $customer_id,
                'order_id' => $order_id,
                'order_number' => $order_number,
                'checkout_link' => $generatedLink
            ];
        } else {
            $this->db->rollback();
            $this->db->autocommit(true);
            return [
                'error' => true,
                'message' => 'Failed to create customer order. Transaction rolled back.',
                'last_error' => $this->db->error
            ];
        }
    }

    public function createSalesAgent($userID)
    {
        $ins = "INSERT INTO tbl_salesagents 
            (agent_id, user_id, user_type, location, commission_rate, total_commission, status, created_at)
            VALUES (NULL, ?, 'user', NULL, 0.00, 0.00, 'active', CURRENT_TIMESTAMP())";

        $result = $this->db->insert($ins, 'i', $userID);

        if ($result) {
            return $this->db->insert_id;
        } else {
            return false;
        }
    }

    public function enableClientByAgentId($agentId)
    {
        // Step 1: Get user ID from sales agent
        $agentQry = "SELECT user_id FROM tbl_salesagents WHERE agent_id = ?";
        $agentRes = $this->db->select($agentQry, 'i', $agentId);

        // if (!$agentRes) {
        //     return "Failed to select agent";
        // }

        if ($agentRes->num_rows() == 0) {
            return false;
        }

        $agentData = $agentRes->fetch_assoc();
        $userId = (int) $agentData['user_id'];

        // Step 2: Update client using prepared statement
        $stmt = $this->db->prepare("UPDATE tblclients SET IS_ENABLED = ? WHERE ID = ?");
        // if (!$stmt) {
        //     return "Failed to prepare update statement";
        // }

        $enabled = 1;
        $stmt->bind_param("ii", $enabled, $userId);

        if (!$stmt->execute()) {
            return false;
        }

        if ($stmt->affected_rows === 0) {
            return false;
        }

        return true;
    }

    public function enableClientByAgentIdwrk($agentId)
    {
        $agentQry = "SELECT user_id FROM tbl_salesagents WHERE agent_id = ?";
        $agentRes = $this->db->select($agentQry, 'i', $agentId);

        if ($agentRes->num_rows() == 0) {
            return false;
        }

        $agentData = $agentRes->fetch_assoc();
        $userId = (int) $agentData['user_id'];

        $updateQry = "UPDATE tblclients SET IS_ENABLED = ? WHERE ID = ?";
        $updateRes = $this->db->query($updateQry, 'ii', 1, $userId);

        return $updateRes ? true : false;
    }
    public function enableClientByUserIdwrking($userId)
    {
        $updateQry = "UPDATE tblclients SET IS_ENABLED = ? WHERE ID = ?";
        $updateRes = $this->db->query($updateQry, 'ii', 1, (int) $userId);

        return $updateRes ? true : false;
    }
    public function enableClientByUserId($userId)
    {
        // Ensure $userId is an integer
        $userId = (int) $userId;
        $enabled = 1;

        // Prepare the update statement
        $stmt = $this->db->prepare("UPDATE tblclients SET IS_ENABLED = ? WHERE ID = ?");

        // Bind parameters
        $stmt->bind_param("ii", $enabled, $userId);

        // Execute the statement
        if (!$stmt->execute()) {
            return false; // Debug message if execute fails
        }

        // // Check if any row was affected
        // if ($stmt->affected_rows === 0) {
        //     return false; // Nothing to update
        // }

        return true; // Success
    }

    public function isAgentNotUser($agentId)
    {
        $query = "SELECT user_type FROM tbl_salesagents WHERE agent_id = ?";
        $result = $this->db->select($query, 'i', $agentId);

        if ($result->num_rows() == 0) {
            return false;
        }

        $agentData = $result->fetch_assoc();
        if (strtolower($agentData['user_type']) !== 'user') {
            return true;
        }

        return false;
    }
    public function getAgentInfo($agentId)
    {
        $query = "SELECT user_id, user_type FROM tbl_salesagents WHERE agent_id = ?";
        $result = $this->db->select($query, 'i', $agentId);

        if ($result->num_rows() == 0) {
            return null;
        }

        $agentData = $result->fetch_assoc();

        $isNotUser = strtolower($agentData['user_type']) !== 'user';

        return [
            'user_id' => (int) $agentData['user_id'],
            'is_not_user' => $isNotUser
        ];
    }

    public function getCustomerByTrackingId($trackingId)
    {
        $trackingId = trim($trackingId);

        if (empty($trackingId)) {
            return null;
        }

        if (!preg_match('/^SO-\d{8}-\d{6}-\d{4}$/', $trackingId)) {
            return null;
        }

        $stmt = $this->db->prepare(


            " SELECT 
        c.tracking_id,
        c.name,
        c.email,
        c.phone,
        c.phone_alt,
        c.email_alt,
        c.address,
        c.company_name,
        c.plan_name,
        c.plan_id,
        c.plan_amount,
        c.total_amount,
        c.appointment_date,
        c.otc_cost,
        c.no_of_months,
        c.created_at,
        s.status
    FROM tbl_onboardingcustomers c
    LEFT JOIN tbl_salesorders s 
        ON s.sales_order_id LIKE ?
    WHERE c.tracking_id = ?
    LIMIT 1"
        );


        if (!$stmt) {
            return null;
        }
        $stmt->bind_param("ss", $trackingId, $trackingId);
        //        $stmt->bind_param("s", $trackingId);
        $stmt->execute();

        $result = $stmt->get_result();

        if ($customer = $result->fetch_object()) {

            if (!empty($customer->phone_alt)) {
                $decoded = json_decode($customer->phone_alt, true);
                $customer->phone_alt = json_last_error() === JSON_ERROR_NONE ? $decoded : $customer->phone_alt;
            }

            if (!empty($customer->email_alt)) {
                $decoded = json_decode($customer->email_alt, true);
                $customer->email_alt = json_last_error() === JSON_ERROR_NONE ? $decoded : $customer->email_alt;
            }

            if (!empty($customer->product_information)) {
                $decoded = json_decode($customer->product_information, true);
                $customer->product_information = json_last_error() === JSON_ERROR_NONE ? $decoded : $customer->product_information;
            }


            // ✅ If status is not paid, generate Paystack reference and insert into tbl_sales_order_paystack_references
            if ($customer->status !== 'paid') {

                // Generate unique reference
                $paystackRef = $trackingId . '-' . time();
                // Insert into tbl_sales_order_paystack_references
                $insertStmt = $this->db->prepare(
                    "INSERT INTO tbl_sales_order_paystack_references 
                (tracking_id, paystack_ref, created_at, status) 
                VALUES (?, ?, NOW(), 'pending')"
                );

                if ($insertStmt) {
                    $insertStmt->bind_param("ss", $trackingId, $paystackRef);
                    $insertStmt->execute();
                }

                // Add reference to customer object
                $customer->paystack_reference = $paystackRef;
            }



            return $customer;
        }

        return null;
    }

    public function populatePaystackReference($trackingId, $paystackRef)
    {

        $insertStmt = $this->db->prepare(
            "INSERT INTO tbl_sales_order_paystack_references 
            (tracking_id, paystack_ref, created_at, status) 
            VALUES (?, ?, NOW(), 'pending')"
        );

        if ($insertStmt) {
            $insertStmt->bind_param("ss", $trackingId, $paystackRef);
            $insertStmt->execute();
        }
        $success = $insertStmt->affected_rows > 0;
        $insertStmt->close();

        return $success;
    }

    public function getCustomerByTrackingIdPS($trackingId)
    {
        $trackingId = trim($trackingId);

        if (empty($trackingId)) {
            return null;
        }

        if (!preg_match('/^SO-\d{8}-\d{6}-\d{4}$/', $trackingId)) {
            return null;
        }

        $stmt = $this->db->prepare(
            "SELECT 
            tracking_id,
            name,
            email,
            phone,
            address,
            company_name,
            plan_name,
            plan_id,
            plan_amount,             total_amount,
        
salesagent_id,

            otc_cost,
            phone_alt,
            email_alt,
            status,
            no_of_months,
            created_at
        FROM tbl_onboardingcustomers
        WHERE tracking_id = ?
        LIMIT 1"
        );

        if (!$stmt) {
            return null;
        }

        $stmt->bind_param("s", $trackingId);
        $stmt->execute();

        $result = $stmt->get_result();

        if ($customer = $result->fetch_object()) {

            if (!empty($customer->phone_alt)) {
                $decoded = json_decode($customer->phone_alt, true);
                $customer->phone_alt = json_last_error() === JSON_ERROR_NONE ? $decoded : $customer->phone_alt;
            }

            if (!empty($customer->email_alt)) {
                $decoded = json_decode($customer->email_alt, true);
                $customer->email_alt = json_last_error() === JSON_ERROR_NONE ? $decoded : $customer->email_alt;
            }

            if (!empty($customer->product_information)) {
                $decoded = json_decode($customer->product_information, true);
                $customer->product_information = json_last_error() === JSON_ERROR_NONE ? $decoded : $customer->product_information;
            }



            return $customer;
        }

        return null;
    }

    public function getTrackingIdByPaymentRef($paymentRef)
    {
        $qry = "SELECT tracking_id FROM tbl_sales_order_paystack_references 
            WHERE paystack_ref = ?";

        $sth = $this->db->select($qry, "s", $paymentRef);

        $row = $sth->fetch_object();

        return $row ? $row->tracking_id : null;
    }
    public function setOnboardingPaid($trackingId)
    {
        // Update query: set status to 'paid' for the given tracking ID
        $upd = "UPDATE tbl_onboardingcustomers 
            SET status = 'paid' 
            WHERE tracking_id = ?";

        // Execute query
        $rett = $this->db->execute_query($upd, "s", $trackingId);

        if ($rett) {
            // $this->logTrail(
            //     $this::INFO,
            //     "Success: Onboarding customer with tracking ID [$trackingId] marked as paid!",
            //     $this::STATUS_PASSED,
            //     get_client_ip_env()
            // );
            return 1;
        } else {
            // $this->logTrail(
            //     $this::INFO,
            //     "ERROR: Failed to update onboarding payment for tracking ID [$trackingId]!",
            //     $this::STATUS_FAILED,
            //     get_client_ip_env()
            // );
            return 0;
        }
    }


    public function updateAppointmentDate($trackingId, $appointmentDate)
    {
        $trackingId = trim($trackingId);
        if (empty($trackingId)) {
            return false;
        }

        // Accept both date and datetime formats
        $d = DateTime::createFromFormat('Y-m-d H:i:s', $appointmentDate);
        if (!$d) {
            // Fallback to date-only format for backward compatibility
            $d = DateTime::createFromFormat('Y-m-d', $appointmentDate);
        }

        if (!$d) {
            return false;
        }

        $stmt = $this->db->prepare("SELECT customer_id FROM tbl_onboardingcustomers WHERE tracking_id = ?");
        if (!$stmt)
            return false;
        $stmt->bind_param("s", $trackingId);
        $stmt->execute();
        $result = $stmt->get_result();
        $order = $result->fetch_assoc();
        $stmt->close();

        if (!$order) {
            return false;
        }

        $stmt = $this->db->prepare("UPDATE tbl_onboardingcustomers SET appointment_date = ? WHERE tracking_id = ?");

        $stmt = $this->db->prepare("
    UPDATE tbl_onboardingcustomers 
    SET appointment_date = ? 
    WHERE tracking_id = ? AND status = ?
");
        if (!$stmt)
            return false;
        $status = "paid";
        $stmt->bind_param("sss", $appointmentDate, $trackingId, $status);
        //        $stmt->bind_param("ss", $appointmentDate, $trackingId);
        $success = $stmt->execute();
        $stmt->close();

        return $success;
    }


    // public function setPaystackReferencePaid($paystackRef)
    // {
    //     // Update query: set status to 'paid' for the given paystack_ref
    //     $upd = "UPDATE tbl_sales_order_paystack_references 
    //         SET status = 'success' 
    //         WHERE paystack_ref = ?";

    //     // Execute query
    //     $rett = $this->db->execute_query($upd, "s", $paystackRef);

    //     if ($rett) {

    //         return 1;
    //     } else {

    //         return 0;
    //     }
    // }



    public function oldworkingsendPaymentReminderEmail($user_id, $customer_id)
    {
        $salesagent_Id = $this->getSalesAdminState($user_id);
        if ($salesagent_Id === null) {
            return ['success' => false, 'message' => 'Agent not found'];
        }

        $qry = "
        SELECT so.checkout_link, so.total_price,
               c.email, c.name, c.plan_name, c.tracking_id
        FROM tbl_salesorders so
        INNER JOIN tbl_onboardingcustomers c
            ON so.customer_id = c.customer_id
        WHERE so.customer_id = ?
          AND so.agent_id = ?
        LIMIT 1
    ";

        $sth = $this->db->select($qry, "ii", $customer_id, $salesagent_Id);
        if (!$sth) {
            return ['success' => false, 'message' => 'Sales order not found'];
        }

        $row = $sth->fetch_assoc();
        if (!$row) {
            return ['success' => false, 'message' => 'No customer data found'];
        }

        $raw_msg = $this->getCannedMessage("PAYMENT_REMINDER");
        if (!$raw_msg) {
            return ['success' => false, 'message' => 'Email template not found'];
        }

        $msg = sprintf(
            $raw_msg,
            $row['name'],

            $row['plan_name'],
            $row['total_price'],
            $row['checkout_link'],
            $row['tracking_id'],
            SERVER_URL,
            SERVER_URL
        );


        // $emailSent = $this->sendEmail(
        //     $row['email'],
        //     EMAIL_SENDER,
        //     "FiberOne - Reminder: Complete Your Payment",
        //     $msg
        // );
        $emailSent = true;
        if ($emailSent) {
            return ['success' => true, 'message' => 'Payment reminder sent successfully', 'rawmsg' => $msg];
        } else {
            return ['success' => false, 'message' => 'Failed to send email', 'rawmsg' => $msg];
        }
    }

    public function getCannedMessage($purpose = "")
    {
        $msg = "";
        $ad = "";
        if ($purpose <> ""):
            $purpose = mysqli_real_escape_string($this->db, $purpose);
            $ad = " WHERE PURPOSE LIKE '$purpose'";
        endif;

        $qry = "SELECT CANNED_MSG FROM `tbl_canned_msg` $ad LIMIT 1";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ($row = $some_sth->fetch_object()) {
            $msg = $row->CANNED_MSG;
        }

        return $msg;
    }

    public function getPaymentReminderDetails($user_id, $customer_id)
    {
        $salesagent_Id = $this->getSalesAdminState($user_id);
        if ($salesagent_Id === null) {
            return null;
        }

        $qry = "
        SELECT so.checkout_link, so.total_price,
               c.email, c.name, c.plan_name, c.tracking_id
        FROM tbl_salesorders so
        INNER JOIN tbl_onboardingcustomers c
            ON so.customer_id = c.customer_id
        WHERE so.customer_id = ?
          AND so.agent_id = ?
        LIMIT 1
    ";

        $sth = $this->db->select($qry, "ii", $customer_id, $salesagent_Id);
        if (!$sth)
            return null;

        $row = $sth->fetch_assoc();
        return $row ?: null;
    }


    public function setPaystackReferencePaid($paystackRef, $status = 'success', $reason = null)
    {
        // If reason is provided, update reason column too
        $upd = "UPDATE tbl_sales_order_paystack_references 
            SET status = ?, reason = ?
            WHERE paystack_ref = ?";

        // Execute query
        $rett = $this->db->execute_query($upd, "sss", $status, $reason, $paystackRef);

        return $rett ? 1 : 0;
    }

    public function updateSalesOrderAfterPaymentrks(
        $sales_order_id,
        $transaction_id,
        $payment_reference,
        $status_code,
        $payment_status_message,
        $payment_date,
        $agent_commission = null,
        $commission_percent = null
    ) {
        $done = 0;
        if (is_numeric($agent_commission)) {
            $agent_commission = round(floatval($agent_commission), 2);
        } else {
            $agent_commission = null; // keep null
        }

        if (is_numeric($commission_percent)) {
            $commission_percent = round((float) $commission_percent, 2);
        } else {
            $commission_percent = null;
        }

        $upd = "UPDATE tbl_salesorders 
            SET status = ?, 
                status_code = ?, 
                payment_reference = ?, 
                transaction_id = ?, 
                payment_status_message = ?, 
                payment_date = ? , 
                agent_commission = ? ,
            commission_percent = ?
            WHERE sales_order_id = ?";

        // Execute the query
        $rett = $this->db->execute_query(
            $upd,
            "ssssssds",
            "paid",                  // new status
            $status_code,
            $payment_reference,
            $transaction_id,
            $payment_status_message,
            $payment_date,
            $agent_commission,
            $commission_percent,
            $sales_order_id
        );



        if ($rett) {
            $done = 1;
        }

        return $done;
    }
    public function updateSalesOrderAfterPayment(
        $sales_order_id,
        $transaction_id,
        $payment_reference,
        $status_code,
        $payment_status_message,
        $payment_date,
        $agent_commission = null,
        $commission_percent = null
    ) {
        // Step 0: Validate sales_order_id
        // if (empty($sales_order_id) || !is_numeric($sales_order_id)) {
        //     return "Error: Invalid sales_order_id";
        // }

        // Step 1: Normalize commission values
        if (is_numeric($agent_commission)) {
            $agent_commission = round(floatval($agent_commission), 2);
        } else {
            $agent_commission = null;
        }

        if (is_numeric($commission_percent)) {
            $commission_percent = round((float) $commission_percent, 2);
        } else {
            $commission_percent = null;
        }

        // Step 2: Prepare update statement
        $upd = "UPDATE tbl_salesorders 
        SET status = ?, 
            status_code = ?, 
            payment_reference = ?, 
            transaction_id = ?, 
            payment_status_message = ?, 
            payment_date = ?,
            agent_commission = ?,
            commission_percent = ?
        WHERE sales_order_id = ?";

        $stmt = $this->db->prepare($upd);
        if (!$stmt) {
            return false;
        }
        $status = "paid"; // assign after bind_param variable exists

        // Step 3: Bind parameters
        if (
            !$stmt->bind_param(
                "ssssssdds",
                $status,          // "paid"
                $status_code,
                $payment_reference,
                $transaction_id,
                $payment_status_message,
                $payment_date,
                $agent_commission,
                $commission_percent,
                $sales_order_id
            )
        ) {
            return false;
        }


        // Step 4: Execute statement
        if (!$stmt->execute()) {
            return false;
        }

        return true;
    }

    public function updateAgentCommission($sales_order_id, $agent_commission)
    {
        // Validate inputs
        if (!is_numeric($agent_commission)) {
            return "invalid numbers";
        }

        // Ensure commission is a float with 2 decimals
        $agent_commission = round(floatval($agent_commission), 2);

        // Update query
        $upd = "UPDATE tbl_salesorders 
            SET agent_commission = ? 
            WHERE sales_order_id = ?";

        // Execute query
        $result = $this->db->execute_query(
            $upd,
            "ds",                   // "d" = double/float, "s" = string
            $agent_commission,
            $sales_order_id
        );

        return $result ? "done" : "didnt work";
    }

    // starts commison for internal agents here


    public function getIsmTeamHierarchyold($ismId)
    {
        // Validate ISM ID
        $ismId = filter_var($ismId, FILTER_VALIDATE_INT);
        if ($ismId === false) {
            return null;
        }

        $stmt = $this->db->prepare(
            "SELECT a.AID AS team_lead_id, a.FULLNAME AS team_lead_name
         FROM tbl_admin_hierarchy h
         JOIN tbl_admins a ON a.AID = h.child_admin_id
         WHERE h.parent_admin_id = ? AND a.IS_ENABLED = 1"
        );
        $stmt->bind_param("i", $ismId);
        $stmt->execute();
        $teamLeadsResult = $stmt->get_result();

        $teamHierarchy = [];

        while ($teamLead = $teamLeadsResult->fetch_object()) {
            $teamLeadId = $teamLead->team_lead_id;

            $stmtSales = $this->db->prepare(
                "SELECT a.AID AS sales_id, a.FULLNAME AS sales_name
             FROM tbl_admin_hierarchy h
             JOIN tbl_admins a ON a.AID = h.child_admin_id
             WHERE h.parent_admin_id = ? AND a.IS_ENABLED = 1"
            );
            $stmtSales->bind_param("i", $teamLeadId);
            $stmtSales->execute();
            $salesResult = $stmtSales->get_result();

            $salesTeam = [];
            while ($sales = $salesResult->fetch_object()) {
                $salesTeam[] = $sales;
            }

            $teamHierarchy[] = [
                'team_lead' => $teamLead,
                'sales_team' => $salesTeam
            ];

            $stmtSales->close();
        }

        $stmt->close();
        return $teamHierarchy;
    }
    public function getTeamHierarchy($adminId, $accessLevel)
    {
        $adminId = filter_var($adminId, FILTER_VALIDATE_INT);
        if ($adminId === false)
            return null;

        $teamHierarchy = [];

        if ($accessLevel == 18) {
            $stmt = $this->db->prepare(
                "SELECT a.AID AS team_lead_id, a.FULLNAME AS team_lead_name
             FROM tbl_admin_hierarchy h
             JOIN tbl_admins a ON a.AID = h.child_admin_id
             WHERE h.parent_admin_id = ? AND a.IS_ENABLED = 1"
            );
            $stmt->bind_param("i", $adminId);
            $stmt->execute();
            $teamLeadsResult = $stmt->get_result();

            while ($teamLead = $teamLeadsResult->fetch_object()) {
                // Step 2: Get Sales under each Team Lead
                $stmtSales = $this->db->prepare(
                    "SELECT a.AID AS sales_id, a.FULLNAME AS sales_name
                 FROM tbl_admin_hierarchy h
                 JOIN tbl_admins a ON a.AID = h.child_admin_id
                 WHERE h.parent_admin_id = ? AND a.IS_ENABLED = 1"
                );
                $stmtSales->bind_param("i", $teamLead->team_lead_id);
                $stmtSales->execute();
                $salesResult = $stmtSales->get_result();

                $salesTeam = [];
                while ($sales = $salesResult->fetch_object()) {
                    $salesTeam[] = $sales;
                }

                $teamHierarchy[] = [
                    'team_lead' => $teamLead,
                    'sales_team' => $salesTeam
                ];

                $stmtSales->close();
            }

            $stmt->close();
        } elseif ($accessLevel == 20) { // Team Lead
            // Team Lead sees only their Sales
            $stmtSales = $this->db->prepare(
                "SELECT a.AID AS sales_id, a.FULLNAME AS sales_name
             FROM tbl_admin_hierarchy h
             JOIN tbl_admins a ON a.AID = h.child_admin_id
             WHERE h.parent_admin_id = ? AND a.IS_ENABLED = 1"
            );
            $stmtSales->bind_param("i", $adminId);
            $stmtSales->execute();
            $salesResult = $stmtSales->get_result();

            $salesTeam = [];
            while ($sales = $salesResult->fetch_object()) {
                $salesTeam[] = $sales;
            }

            $teamHierarchy[] = [
                'team_lead' => null,  // No parent for display
                'sales_team' => $salesTeam
            ];

            $stmtSales->close();
        }

        return $teamHierarchy;
    }


    public function getUnassignedSalesExecs()
    {
        $stmt = $this->db->prepare(
            "SELECT a.AID, a.FULLNAME
         FROM tbl_admins a
         LEFT JOIN tbl_admin_hierarchy h
             ON h.child_admin_id = a.AID
         WHERE a.ACCESS_LEVEL = 21
           AND a.IS_ENABLED = 1  AND h.child_admin_id IS NULL"
        );

        $stmt->execute();
        $result = $stmt->get_result();

        $salesExecs = [];
        while ($row = $result->fetch_object()) {
            $salesExecs[] = $row;
        }

        $stmt->close();
        return $salesExecs;
    }


    public function removeSalesFromTeamLead($teamLeadId, $salesId)
    {
        $teamLeadId = filter_var($teamLeadId, FILTER_VALIDATE_INT);
        $salesId = filter_var($salesId, FILTER_VALIDATE_INT);

        if (!$teamLeadId || !$salesId)
            return false;

        $stmt = $this->db->prepare(
            "DELETE FROM tbl_admin_hierarchy
         WHERE parent_admin_id = ? AND child_admin_id = ?"
        );
        $stmt->bind_param("ii", $teamLeadId, $salesId);

        return $stmt->execute();
    }
    public function assignSalesToTeamLead($teamLeadId, $salesId)
    {
        $teamLeadId = filter_var($teamLeadId, FILTER_VALIDATE_INT);
        $salesId = filter_var($salesId, FILTER_VALIDATE_INT);

        if (!$teamLeadId || !$salesId) {
            return [
                'success' => false,
                'code' => 0,
                'message' => 'Invalid Team Lead or Sales ID.'
            ];
        }

        // Ensure Sales Exec is not already assigned
        $check = $this->db->prepare(
            "SELECT 1 FROM tbl_admin_hierarchy WHERE child_admin_id = ?"
        );
        $check->bind_param("i", $salesId);
        $check->execute();
        if ($check->get_result()->num_rows > 0) {
            return [
                'success' => false,
                'code' => 1,
                'message' => 'This Sales Exec is already assigned to a Team Lead.'
            ];
        }


        $stmt = $this->db->prepare(
            "INSERT INTO tbl_admin_hierarchy (parent_admin_id, child_admin_id)
         VALUES (?, ?)"
        );
        $stmt->bind_param("ii", $teamLeadId, $salesId);

        if ($stmt->execute()) {
            return [
                'success' => true,
                'code' => 2,
                'message' => 'Sales Exec assigned successfully!'
            ];
        } else {
            return [
                'success' => false,
                'code' => 3,
                'message' => 'Database error: ' . $stmt->error
            ];
        }
    }

    public function canViewSalesExec($viewerId, $viewerAccessLevel, $salesId)
    {
        if ($viewerAccessLevel == 18) {
            return true; // ISM can view all under them
        }

        if ($viewerAccessLevel == 20) {
            $stmt = $this->db->prepare(
                "SELECT 1
             FROM tbl_admin_hierarchy
             WHERE parent_admin_id = ?
               AND child_admin_id = ?"
            );
            $stmt->bind_param("ii", $viewerId, $salesId);
            $stmt->execute();
            return $stmt->get_result()->num_rows > 0;
        }

        return null;
    }
    public function getSalesExecDetailsold($salesId)
    {
        $stmt = $this->db->prepare(
            "SELECT AID, FULLNAME, EMAIL, MOBILE, DATE_ADDED
         FROM tbl_admins
         WHERE AID = ? AND ACCESS_LEVEL = 21"
        );
        $stmt->bind_param("i", $salesId);
        $stmt->execute();

        return $stmt->get_result()->fetch_object();
    }

    public function getSalesExecDetails($salesId)
    {
        $salesQry = "
        SELECT AID, FULLNAME, EMAIL, MOBILE, DATE_ADDED
        FROM tbl_admins
        WHERE AID = ? AND ACCESS_LEVEL = 21
    ";

        $salesRes = $this->db->select($salesQry, 'i', $salesId);

        if ($salesRes->num_rows() > 0) {
            return $salesRes->fetch_object();
        }

        // Return null if sales executive not found
        return "null";
    }
    public function getSalesExecUnderTeamLead($teamLeadId)
    {
        $stmt = $this->db->prepare(
            "SELECT a.AID, a.FULLNAME
         FROM tbl_admin_hierarchy h
         JOIN tbl_admins a ON a.AID = h.child_admin_id
         WHERE h.parent_admin_id = ?"
        );
        $stmt->bind_param("i", $teamLeadId);
        $stmt->execute();
        return $stmt->get_result();
    }
    public function saveSalesTarget($salesExecId, $teamLeadId, $amount, $month)
    {
        $stmt = $this->db->prepare(
            "INSERT INTO tbl_monthly_targets (admin_id, parent_id, target_amount, month)
         VALUES (?, ?, ?, ?)
         ON DUPLICATE KEY UPDATE target_amount = VALUES(target_amount)"
        );

        $stmt->bind_param("iids", $salesExecId, $teamLeadId, $amount, $month);
        return $stmt->execute();
    }
    public function getSalesTargetsForMonth($teamLeadId, $month, $accessLevel)
    {
        $query = "SELECT admin_id, target_amount FROM tbl_monthly_targets WHERE month = ?";

        if ($accessLevel != 18) {
            $query .= " AND parent_id = ?";
        }

        $stmt = $this->db->prepare($query);

        if ($accessLevel != 18) {
            $stmt->bind_param("si", $month, $teamLeadId);
        } else {
            $stmt->bind_param("s", $month);
        }

        $stmt->execute();

        $targets = [];
        $result = $stmt->get_result();

        while ($row = $result->fetch_object()) {
            $targets[$row->admin_id] = $row->target_amount;
        }

        return $targets;
    }


    public function getSalesTargetForSalesExec($salesExecId, $month)
    {
        $stmt = $this->db->prepare(
            "SELECT target_amount 
         FROM tbl_monthly_targets 
         WHERE month = ? AND admin_id = ?"
        );
        $stmt->bind_param("si", $month, $salesExecId);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($row = $result->fetch_object()) {
            return (float) $row->target_amount;
        }

        return 0;
    }


    public function oldgetSalesTargetsForMonth($teamLeadId, $month)
    {
        $stmt = $this->db->prepare(
            "SELECT admin_id, target_amount
         FROM tbl_monthly_targets
         WHERE parent_id = ? AND month = ?"
        );
        $stmt->bind_param("is", $teamLeadId, $month);
        $stmt->execute();

        $targets = [];
        $result = $stmt->get_result();

        while ($row = $result->fetch_object()) {
            $targets[$row->admin_id] = $row->target_amount;
        }

        return $targets;
    }
    public function getSalesExecMonthlySales($userId, $month)
    {
        $stmt = $this->db->prepare("SELECT agent_id FROM tbl_salesagents WHERE user_id = ?");
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $agent = $stmt->get_result()->fetch_object();

        if (!$agent) {
            return 0;
        }

        $startDate = date('Y-m-01', strtotime($month));
        $endDate = date('Y-m-t', strtotime($month));

        $stmt = $this->db->prepare(
            "SELECT SUM(total_price) AS total_sales
         FROM tbl_salesorders
         WHERE agent_id = ?
           AND status = 'paid'
           AND payment_date BETWEEN ? AND ?"
        );
        $stmt->bind_param("iss", $agent->agent_id, $startDate, $endDate);
        $stmt->execute();

        return $stmt->get_result()->fetch_object()->total_sales ?? 0;
    }

    public function getAgentIdBySalesExec($salesExecId)
    {
        $stmt = $this->db->prepare(
            "SELECT agent_id FROM tbl_salesagents WHERE user_id = ? LIMIT 1"
        );
        $stmt->bind_param("i", $salesExecId);
        $stmt->execute();

        $result = $stmt->get_result()->fetch_object();
        return $result->agent_id ?? 0;
    }
    public function getMonthlySalesOrdersBySalesExec($salesExecId, $month)
    {
        $agentId = $this->getAgentIdBySalesExec($salesExecId);
        if ($agentId <= 0)
            return [];

        $startDate = date('Y-m-01', strtotime($month));
        $endDate = date('Y-m-t', strtotime($month));

        $stmt = $this->db->prepare(
            "SELECT sales_order_id, total_price, payment_date, status
         FROM tbl_salesorders
         WHERE agent_id = ?
           AND status = 'paid'
           AND payment_date BETWEEN ? AND ?
         ORDER BY payment_date DESC"
        );

        $stmt->bind_param("iss", $agentId, $startDate, $endDate);
        $stmt->execute();

        return $stmt->get_result();
    }

    public function getLastSalesOrdersBySalesExec($salesExecId, $limit = 5)
    {
        $agentId = $this->getAgentIdBySalesExec($salesExecId);
        if ($agentId <= 0)
            return [];

        $stmt = $this->db->prepare(
            "SELECT sales_order_id, total_price, payment_date, status
         FROM tbl_salesorders
         WHERE agent_id = ?
           AND status = 'paid'
         ORDER BY payment_date DESC
         LIMIT ?"
        );

        $stmt->bind_param("ii", $agentId, $limit);
        $stmt->execute();

        return $stmt->get_result();
    }
    public function getMonthlySalesOrdersWithPlanBySalesExec($salesExecId, $month)
    {
        $agentId = $this->getAgentIdBySalesExec($salesExecId);
        if ($agentId <= 0)
            return [];

        $startDate = date('Y-m-01', strtotime($month));
        $endDate = date('Y-m-t', strtotime($month));

        $stmt = $this->db->prepare(
            "SELECT s.sales_order_id, s.total_price, s.payment_date, s.status, c.plan_name , c.plan_id
         FROM tbl_salesorders s
         LEFT JOIN tbl_onboardingcustomers c ON c.tracking_id = s.sales_order_id
         WHERE s.agent_id = ?
           AND s.status = 'paid'
           AND s.payment_date BETWEEN ? AND ?
         ORDER BY s.payment_date DESC"
        );

        $stmt->bind_param("iss", $agentId, $startDate, $endDate);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_all(MYSQLI_ASSOC);
        // return $stmt->get_result();
    }


    public function getMonthlySalesByPlan($salesExecId, $month)
    {
        $agentId = $this->getAgentIdBySalesExec($salesExecId);
        if ($agentId <= 0)
            return [];

        $startDate = date('Y-m-01', strtotime($month));
        $endDate = date('Y-m-t', strtotime($month));

        $stmt = $this->db->prepare(
            "SELECT c.plan_id, c.plan_name, SUM(s.total_price) AS total_revenue, COUNT(s.sales_order_id) AS total_orders
         FROM tbl_salesorders s
         LEFT JOIN tbl_onboardingcustomers c ON c.tracking_id = s.sales_order_id
         WHERE s.agent_id = ?
           AND s.status = 'paid'
           AND s.payment_date BETWEEN ? AND ?
         GROUP BY c.plan_id, c.plan_name
         ORDER BY total_revenue DESC"
        );

        $stmt->bind_param("iss", $agentId, $startDate, $endDate);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_all(MYSQLI_ASSOC);
    }


    public function getTeamLeadMonthlyTopPlans($sales_team_members, $month)
    {
        $planTotals = [];

        foreach ($sales_team_members as $exec) {
            $salesExecId = (int) $exec->sales_id;
            $plans = $this->getMonthlySalesByPlan($salesExecId, $month);

            foreach ($plans as $plan) {
                $planId = $plan['plan_id'];
                if (!isset($planTotals[$planId])) {
                    $planTotals[$planId] = [
                        'plan_id' => $planId,
                        'plan_name' => $plan['plan_name'],
                        'total_revenue' => 0,
                        'total_orders' => 0
                    ];
                }

                $planTotals[$planId]['total_revenue'] += $plan['total_revenue'];
                $planTotals[$planId]['total_orders'] += $plan['total_orders'];
            }
        }

        // Sort plans by total revenue descending
        usort($planTotals, function ($a, $b) {
            return $b['total_revenue'] <=> $a['total_revenue'];
        });

        return $planTotals;
    }


    function calculateTotalCommission($monthlyOrders, $performancePercent)
    {
        if (empty($monthlyOrders) || $performancePercent < 75) {
            return ['totalCommission' => 0, 'missingPlans' => []];
        }

        $totalCommission = 0;
        $missingPlans = [];
        $performancePercent = round($performancePercent, 2);
        foreach ($monthlyOrders as $order) {
            $planId = $order['plan_id'] ?? 0;
            $planName = $order['plan_name'] ?? 'Unknown Plan';

            // Get commission rate for this plan
            $stmt = $this->db->prepare("
            SELECT commission_rate
            FROM tbl_plan_commissions
            WHERE plan_id = ?
             AND min_percent <= ?
    ORDER BY min_percent DESC
    LIMIT 1
        ");
            $stmt->bind_param("id", $planId, $performancePercent);
            $stmt->execute();
            $result = $stmt->get_result()->fetch_assoc();
            $rate = $result['commission_rate'] ?? 0;

            if ($rate > 0) {
                $totalCommission += ($order['total_price'] * $rate / 100);
            } else {
                if (!isset($missingPlans[$planId])) {
                    $missingPlans[$planId] = [
                        'plan_id' => $planId,
                        'plan_name' => $planName
                    ];
                }
            }
        }

        $missingPlans = array_values($missingPlans);

        return ['totalCommission' => $totalCommission, 'missingPlans' => $missingPlans];
    }

    function calculateTotalCommissionold($monthlyOrders, $performancePercent)
    {
        if (empty($monthlyOrders) || $performancePercent < 75) {
            return 0;
        }
        //  $performancePercent = round($performancePercent, 2);
        return $performancePercent = min(round($performancePercent, 2), 999);

        $totalCommission = 0;
        $missingPlans = [];
        foreach ($monthlyOrders as $order) {
            $planId = $order['plan_id'] ?? 0;
            $planName = $order['plan_name'] ?? 'Unknown Plan';


            $stmt = $this->db->prepare("
            SELECT commission_rate
            FROM tbl_plan_commissions
            WHERE plan_id = ?
             AND min_percent <= ?
    ORDER BY min_percent DESC
    LIMIT 1
        ");
            $stmt->bind_param("id", $planId, $performancePercent);
            $stmt->execute();
            $result = $stmt->get_result()->fetch_assoc();
            $rate = $result->commission_rate ?? 0;

            if ($rate > 0) {
                $totalCommission += ($order['total_price'] * $rate / 100);
            }
            if (!isset($missingPlans[$planId])) {
                $missingPlans[$planId] = [
                    'plan_id' => $planId,
                    'plan_name' => $planName
                ];
            }
        }

        $missingPlans = array_values($missingPlans);

        return ['totalCommission' => $totalCommission, 'missingPlans' => $missingPlans];
    }


    public function getTeamLeadMonthlyTargetSummary($adminId, $month, $salesExecs, $accessLevel)
    {
        $summary = [
            'total_target' => 0,
            'missing_targets' => []
        ];

        if (empty($salesExecs)) {
            return $summary;
        }

        foreach ($salesExecs as $exec) {
            $salesExecId = (int) $exec->sales_id;

            // 2. Get target for this sales exec
            $targets = $this->getSalesTargetsForMonth($adminId, $month, $accessLevel); // 21 = sales exec level
            $targetAmount = $targets[$salesExecId] ?? 0;

            if ($targetAmount > 0) {
                $summary['total_target'] += $targetAmount;
            } else {
                // Track missing targets
                $summary['missing_targets'][$salesExecId] = $exec->sales_name ?? 'Unknown';
            }
        }

        return $summary;
    }

    public function getTeamLeadMonthlySales($adminId, $month, $sales_team_members)
    {
        $totalSales = 0;

        if (empty($sales_team_members)) {
            return $totalSales;
        }

        foreach ($sales_team_members as $exec) {
            $salesExecId = (int) $exec->sales_id;

            $salesAmount = $this->getSalesExecMonthlySales($salesExecId, $month);

            $totalSales += $salesAmount;
        }

        return $totalSales;
    }

    public function calculateTeamLeadCommission($totalMonthlyTarget, $performancePercent)
    {

        $commissionRate = 0;
        if ($performancePercent >= 75 && $performancePercent <= 79) {
            $commissionRate = 0.45;
        } elseif ($performancePercent >= 80 && $performancePercent <= 89) {
            $commissionRate = 0.60;
        } elseif ($performancePercent >= 90 && $performancePercent <= 99) {
            $commissionRate = 0.75;
        } elseif ($performancePercent >= 100) {
            $commissionRate = 0.85;
        }
        $commissionAmount = ($totalMonthlyTarget * $commissionRate) / 100;

        return [
            'performance_percent' => $performancePercent,
            'commission' => $commissionAmount,
        ];
    }


    // end commsions for interntal agents here

    public function calculateCommission($totalAmount, $planId)
    {
        $totalAmount = (float) $totalAmount;

        $qry = "SELECT commission_percent FROM tbl_external_agents_commission WHERE plan_id = ?";
        $sth = $this->db->select($qry, "i", $planId);

        if (!$sth) {
            return false;
        }

        $row = $sth->fetch_object();

        if (!$row || $row->commission_percent === null) {
            return false;
        }

        $commissionPercent = (float) $row->commission_percent;

        $commissionAmount = ($totalAmount * $commissionPercent) / 100;

        //return $commissionAmount;
        return [
            'percent' => $commissionPercent,
            'amount' => $commissionAmount
        ];
    }

    function insertSalesAgent($userId)
    {
        $sales_check = $this->db->query("SELECT * FROM tbl_salesagents WHERE user_id = $userId")->fetch_assoc();

        if ($sales_check === null) {
            // Prepare the insert statement
            $stmt = $this->db->prepare(
                "INSERT INTO tbl_salesagents (user_id, user_type) VALUES (?, ?)"
            );

            $user_type = 'sales_exec';

            $stmt->bind_param("is", $userId, $user_type);

            if ($stmt->execute()) {
                return true;
            } else {
                return false;
            }
        }

        return false;
    }



    ////
    public function getAllProductsSalesAdmin()
    {
        // 1️⃣ Get all active products
        $query = "
        SELECT *
        FROM tbl_products
        WHERE status = 'active' AND stock_quantity > 0
    ";
        $result = $this->db->select($query);

        $products = [
            'fob' => [],
            'third_party' => []
        ];

        $productIds = [];
        $productObjects = [];

        // Collect product IDs and store product objects temporarily
        while ($row = $result->fetch_object()) {
            $productIds[] = $row->id;
            $productObjects[$row->id] = $row;
        }

        // 2️⃣ Fetch all images for these products in a single query
        if (!empty($productIds)) {

            // Prepare placeholders for IN clause
            $placeholders = implode(',', array_fill(0, count($productIds), '?'));

            $types = str_repeat('i', count($productIds)); // all integers
            $stmtImg = $this->db->prepare(
                "SELECT id, product_id, vendor_id, filename, uploaded_at
             FROM marketplace_product_images
             WHERE product_id IN ($placeholders)
             ORDER BY id ASC"
            );

            // Bind params dynamically
            $stmtImg->bind_param($types, ...$productIds);
            $stmtImg->execute();
            $imgResult = $stmtImg->get_result();

            // Map images to their respective products
            $imageMap = [];
            while ($imgRow = $imgResult->fetch_assoc()) {
                $pid = $imgRow['product_id'];
                if (!isset($imageMap[$pid])) {
                    $imageMap[$pid] = [];
                }
                // $baseUrl = "public/uploads/products/";

                $baseUrl = "public/uploads/products/";

                $imageMap[$pid][] = [
                    'id' => $imgRow['id'],
                    'filename' => $imgRow['filename'],
                    'url' => $baseUrl . $imgRow['filename'],
                    'uploaded_at' => $imgRow['uploaded_at']
                ];
            }

            // Attach images to product objects
            foreach ($productObjects as $pid => $product) {
                $product->images = $imageMap[$pid] ?? [];
            }
        }

        // 3️⃣ Categorize by vendor type
        foreach ($productObjects as $product) {
            if ($product->vendor_type_id == 28) {
                $products['fob'][] = $product;
            } else {
                $products['third_party'][] = $product;
            }
        }

        return $products;
    }

    public function getAllProductsSalesAdminold()
    {
        $query = "
        SELECT *
        FROM tbl_products
        WHERE status = 'active' and stock_quantity > 0
    ";

        $result = $this->db->select($query);

        $products = [
            'fob' => [],          // vendor_type_id = 28 for fob vendor
            'third_party' => []   // all other vendor types
        ];

        while ($row = $result->fetch_object()) {
            if ($row->vendor_type_id == 28) {
                $products['fob'][] = $row;
            } else {
                $products['third_party'][] = $row;
            }
        }

        return $products;
    }

    public function getAllProductsPublicwrk(int $limit = 20, int $offset = 0, string $search = '')
    {
        $params = [];
        $types = '';

        $sql = "
        SELECT *
        FROM tbl_products
        WHERE status = 'active'
          AND stock_quantity > 0
    ";

        if (!empty($search)) {
            $sql .= " AND name LIKE ?";
            $searchTerm = '%' . $search . '%';
            $params[] = $searchTerm;
            $types .= 's';
        }

        $sql .= " ORDER BY created_at DESC LIMIT ? OFFSET ?";
        $params[] = $limit;
        $params[] = $offset;
        $types .= 'ii';

        $stmt = $this->db->prepare($sql);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();

        $result = $stmt->get_result();

        $products = [];
        while ($row = $result->fetch_assoc()) {
            $products[] = $row;
        }

        return $products;
    }

    public function getAllProductsPublic(int $limit = 20, int $offset = 0, string $search = '')
    {
        $params = [];
        $types = '';

        $sql = "
        SELECT *
        FROM tbl_products
        WHERE status = 'active'
          AND stock_quantity > 0
    ";

        if (!empty($search)) {
            $sql .= " AND name LIKE ?";
            $params[] = '%' . $search . '%';
            $types .= 's';
        }

        $sql .= " ORDER BY created_at DESC LIMIT ? OFFSET ?";
        $params[] = $limit;
        $params[] = $offset;
        $types .= 'ii';

        $stmt = $this->db->prepare($sql);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();

        $products = [];
        $productIds = [];

        while ($row = $result->fetch_assoc()) {
            $row['images'] = [];
            $products[$row['id']] = $row;
            $productIds[] = $row['id'];
        }

        if (!empty($productIds)) {
            $placeholders = implode(',', array_fill(0, count($productIds), '?'));
            $types = str_repeat('i', count($productIds));

            $imgSql = "
            SELECT id, product_id, filename, uploaded_at
            FROM marketplace_product_images
            WHERE product_id IN ($placeholders)
            ORDER BY product_id, id ASC
        ";

            $imgStmt = $this->db->prepare($imgSql);
            $imgStmt->bind_param($types, ...$productIds);
            $imgStmt->execute();
            $imgResult = $imgStmt->get_result();

            while ($img = $imgResult->fetch_assoc()) {
                $products[$img['product_id']]['images'][] = $img;
            }
        }

        return array_values($products);
    }



    public function getAllProductsCountPublic(string $search = ''): int
    {
        $params = [];
        $types = '';

        $sql = "
        SELECT COUNT(*) AS total
        FROM tbl_products
        WHERE status = 'active'
          AND stock_quantity > 0
    ";

        if (!empty($search)) {
            $sql .= " AND name LIKE ?";
            $searchTerm = '%' . $search . '%';
            $params[] = $searchTerm;
            $types .= 's';
        }

        $stmt = $this->db->prepare($sql);

        if ($params) {
            $stmt->bind_param($types, ...$params);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        $row = $result->fetch_assoc();

        return (int) $row['total'];
    }

    public function getProductByIdPublic(int $id)
    {
        $stmt = $this->db->prepare("
        SELECT 
            p.*,
            i.id AS image_id,
            i.filename,
            i.uploaded_at
        FROM tbl_products p
        LEFT JOIN marketplace_product_images i 
            ON i.product_id = p.id
        WHERE p.id = ?
          AND p.status = 'active'
          AND p.stock_quantity > 0
        ORDER BY i.id ASC
    ");

        $stmt->bind_param('i', $id);
        $stmt->execute();
        $result = $stmt->get_result();

        $product = null;
        $images = [];

        while ($row = $result->fetch_assoc()) {
            if (!$product) {
                $product = $row;
            }
            $baseUrl = "public/uploads/products/";

            if (!empty($row['filename'])) {
                $images[] = [
                    'id' => $row['image_id'],
                    'filename' => $baseUrl . $row['filename'],
                    'uploaded_at' => $row['uploaded_at']
                ];
            }
        }

        if ($product) {
            $product['images'] = $images;
        }

        return $product;
    }



    public function getProductByIdPublicwkr(int $id)
    {
        $stmt = $this->db->prepare("
        SELECT *
        FROM tbl_products
        WHERE id = ? AND status = 'active' AND stock_quantity > 0
        LIMIT 1
    ");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        $result = $stmt->get_result();

        return $result->fetch_assoc();
    }

    public function addProductOrderPublic($data)
    {
        // Required fields
        $required = [
            'product_id',
            'quantity',
            'shipping_address',
            'billing_address',
            'payment_method',
            'currency',
            'customer_name',
            'customer_email',
            'customer_phone',
            'customer_address'
        ];
        foreach ($required as $field) {
            if (empty($data[$field])) {
                return ['error' => "Missing field: $field"];
            }
        }

        $created_at = date('Y-m-d H:i:s');
        $insCustomer = "INSERT INTO tbl_vendor_customers (name, email, phone, address) 
                    VALUES (?, ?, ?, ?)";
        $customer_id = $this->db->insert(
            $insCustomer,
            "ssss",
            $data['customer_name'],
            $data['customer_email'],
            $data['customer_phone'],
            $data['customer_address']
        );

        if (!$customer_id) {
            return ['success' => false,];
        }



        $stmt = $this->db->prepare(
            "SELECT vendor_id, price, discount_price FROM tbl_products WHERE id = ? LIMIT 1"
        );
        $stmt->bind_param("i", $data['product_id']);
        $stmt->execute();
        $result = $stmt->get_result();

        // Fetch the row as an object (or use fetch_assoc for array)
        $product = $result->fetch_object();
        // $prodSel = "SELECT vendor_id, price, discount_price FROM tbl_products WHERE id = ? LIMIT 1";
        // $product = $this->db->select($prodSel, "i", $data['product_id']);
        if (!$product) {
            return ['success' => false, 'success' => false,];
        }
        // return [
        //     'success' => false,
        //     'order_id' => $product,
        // ];
        // $product = $product[0];

        $vendor_id = (int) $product->vendor_id;
        //var_dump($customer_id, $product, $vendor_id);

        $quantity = (int) $data['quantity'];
        $original_price = (float) $product->price;
        $discount_price = (float) $product->discount_price;
        $unit_price = $discount_price > 0 ? $discount_price : $original_price;

        $subtotal_amount = $unit_price * $quantity;
        $discounted_amount = $subtotal_amount - ($unit_price * $quantity);
        $tax_amount = 0;
        $shipping_amount = isset($data['shipping_amount']) ? (float) $data['shipping_amount'] : 0;
        $total_amount = ($unit_price * $quantity) + $tax_amount + $shipping_amount;

        $status = 'pending';
        $sales_status = 'pending';
        $refund_amount = 0;
        $discount_amount = $discounted_amount;
        $payment_reference = null; // bind NULL safely

        $currency = $data['currency'];
        $payment_method = $data['payment_method'];
        $shipping_address = $data['shipping_address'];
        $billing_address = $data['billing_address'];


        $insOrder = "INSERT INTO tbl_orders
    (vendor_id, customer_id, total_amount, subtotal_amount, discounted_amount, tax_amount, status, payment_reference, sales_status, 
     shipping_amount, discount_amount, refund_amount, currency, payment_method, shipping_address, billing_address)
VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $order_id = $this->db->insert(
            $insOrder,
            "iiddddsssddsssss",
            $vendor_id,
            $customer_id,
            $total_amount,
            $subtotal_amount,
            $discounted_amount,
            $tax_amount,
            $status,
            $payment_reference,   // NULL safely bound
            $status,
            $shipping_amount,
            $discount_amount,
            $refund_amount,
            $currency,
            $payment_method,
            $shipping_address,
            $billing_address
        );
        // return ['success' => false,  'db_error' => $order_id];

        if (!$order_id) {
            return ['error' => 'Order insert failed: ' . $this->db->error];
        }

        if ($order_id) {

            $unit_price = $unit_price;           // price actually paid per unit
            $total_price = $unit_price * $quantity;    // total for this line item
            $product_id = $data['product_id'];
            $insItem = "INSERT INTO tbl_order_items
        (order_id, product_id, vendor_id, quantity, unit_price, total_price, created_at, updated_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW(), NOW())";

            $item_id = $this->db->insert(
                $insItem,
                "iiiddi",
                $order_id,
                $product_id,
                $vendor_id,
                $quantity,
                $unit_price,
                $total_price
            );

            if (!$item_id) {
                return ['error' => 'Order item insert failed: ' . $this->db->error];
            }
        }


        return [
            'success' => true,
            'order_id' => $order_id,
            'total_amount' => $total_amount,
            'customer_id' => $customer_id

        ];
    }


    function addProductOrderPublicworkingold($data)
    {
        $required = ['product_id', 'quantity', 'shipping_address', 'billing_address', 'payment_method', 'currency'];
        foreach ($required as $field) {
            if (!isset($data[$field])) {
                return ['error' => "Missing field: $field"];
            }
        }

        $name = $this->db->real_escape_string($data['customer_name']);
        $email = $this->db->real_escape_string($data['customer_email']);
        $phone = $this->db->real_escape_string($data['customer_phone']);
        $address = $this->db->real_escape_string($data['customer_address']);

        $customerSql = "INSERT INTO tbl_customers (name, email, phone, address, created_at)
                    VALUES ('$name', '$email', '$phone', '$address')";
        $customerResult = $this->db->query($customerSql);

        if (!$customerResult) {
            return ['error' => 'Failed to insert customer: ' . $this->db->error];
        }

        $customer_id = $this->db->insert_id; // get the newly inserted customer ID

        $product_id = (int) $data['product_id'];
        // $customer_id = 4;
        $quantity = (int) $data['quantity'];
        $shipping_address = $this->db->real_escape_string($data['shipping_address']);
        $billing_address = $this->db->real_escape_string($data['billing_address']);
        $payment_method = $this->db->real_escape_string($data['payment_method']);
        $currency = $this->db->real_escape_string($data['currency']);

        // Lookup product to get vendor_id and price
        $productResult = $this->db->query("SELECT vendor_id, price, discount_price FROM tbl_products WHERE id = $product_id LIMIT 1");
        if (!$productResult || $productResult->num_rows == 0) {
            return ['error' => 'Invalid product'];
        }
        $product = $productResult->fetch_assoc();
        $vendor_id = (int) $product['vendor_id'];
        $unit_price = (float) $product['discount_price'] > 0 ? (float) $product['discount_price'] : (float) $product['price'];


        $subtotal_amount = $unit_price * $quantity;
        $discounted_amount = (float) $product['price'] * $quantity - $subtotal_amount;
        $tax_amount = 0;
        $shipping_amount = isset($data['shipping_amount']) ? (float) $data['shipping_amount'] : 0;
        $total_amount = $subtotal_amount + $tax_amount + $shipping_amount;

        // Status
        $status = 'pending';
        $sales_status = 'pending';
        $payment_reference = NULL;
        $discount_amount = $discounted_amount;
        $refund_amount = 0;
        //        $created_at = date('Y-m-d H:i:s'); // table will handle updated_at automatically if configured

        // Insert order
        $sql = "INSERT INTO tbl_orders
        (vendor_id, customer_id, total_amount, subtotal_amount, discounted_amount, tax_amount, status, sales_status, payment_reference, shipping_amount, discount_amount, refund_amount, currency, payment_method, shipping_address, billing_address)
        VALUES
        ($vendor_id, $customer_id, $total_amount, $subtotal_amount, $discounted_amount, $tax_amount, '$status', '$sales_status', NULL, $shipping_amount, $discount_amount, $refund_amount, '$currency', '$payment_method', '$shipping_address', '$billing_address')";

        $result = $this->db->query($sql);

        if ($result) {
            $order_id = $this->db->insert_id;
            return ['order_id' => $order_id, 'total_amount' => $total_amount];
        } else {
            return ['error' => 'Database error: ' . $this->db->error];
        }
    }


    public function getAllOrders()
    {
        $strsql = "SELECT status, total_amount, subtotal_amount 
               FROM `tbl_orders`";

        $some_sth = $this->db->select($strsql); // No parameters now
        $ret = [];

        while ($row = $some_sth->fetch_object()) {
            $ret[] = $row; // each row is an object with status, total_amount, subtotal_amount
        }

        return $ret;
    }

    public function getAllGroupMenuURLs()
    {
        $strsql = "SELECT URL 
               FROM `tbl_usergroup_menus` tum
               LEFT JOIN tbl_menus tm ON tum.MID = tm.MID";

        $some_sth = $this->db->select($strsql); // No parameters now
        $ret = [];

        while ($row = $some_sth->fetch_object()) {
            $ret[] = $row->URL;
        }

        return $ret;
    }
    public function getOrderForVerification($orderId)
    {
        $strsql = "SELECT id, status, total_amount, subtotal_amount 
               FROM `tbl_orders` 
               WHERE id = ?";

        $some_sth = $this->db->select($strsql, 'i', $orderId);

        $order = $some_sth->fetch_object();

        if (!$order) {
            return [
                'status' => 'not_found',
                'success' => 'false',

                'message' => "Order with ID not found."
            ];
        }

        $lowerStatus = strtolower($order->status);
        if (in_array($lowerStatus, ['paid', 'fulfilled'])) {
            return [
                'status' => $order->status,
                'success' => 'false',

                'message' => "Order with ID {$orderId} is {$order->status}."
            ];
        }
        return [
            'status' => true,
            'success' => 'true',

            'order' => $order,
            'message' => "Order with ID {$orderId} retrieved successfully."
        ];
    }

    public function markOrderPaidtestworking($orderId, $paymentReference)
    {
        $orderId = (int) $orderId;
        // return [
        //     'status' => 'false',
        //     'step' => 'prepare',
        //     'error' => $orderId,
        //     'ref' => $paymentReference,
        // ];
        $sql = "
        UPDATE tbl_orders 
        SET 
            status = 'paid',
            sales_status = 'successful',
            payment_reference = ?,
            updated_at = NOW()
        WHERE id = ?
    ";

        // Prepare
        $stmt = $this->db->prepare($sql);
        if (!$stmt) {
            return [
                'status' => 'false',
                'step' => 'prepare',
                'error' => $this->db->error
            ];
        }

        // Bind
        if (!$stmt->bind_param("si", $paymentReference, $orderId)) {
            return [
                'status' => 'false',
                'step' => 'bind_param',
                'error' => $stmt->error
            ];
        }

        // Execute
        if (!$stmt->execute()) {
            return [
                'status' => 'false',
                'step' => 'execute',
                'error' => $stmt->error
            ];
        }

        // Affected rows check
        if ($stmt->affected_rows === 0) {
            return [
                'status' => 'false',
                'step' => 'no_rows_updated',
                'message' => 'Query ran but no row was updated. Check if order ID exists or values are same.'
            ];
        }

        return [
            'status' => 'true',
            'message' => "Order with ID {$orderId} has been marked as paid."
        ];
    }

    public function markOrderPaidmine($orderId, $paymentReference)
    {
        $orderId = (int) $orderId;

        $sql = "
        UPDATE tbl_orders 
        SET 
            status = 'paid',
            sales_status = 'successful',
            payment_reference = ?,
            updated_at = NOW()
        WHERE id = ?
    ";

        $stmt = $this->db->prepare($sql);

        if (!$stmt) {
            return [
                'status' => 'false',
                'message' => "Prepare failed."
            ];
        }

        $stmt->bind_param("si", $paymentReference, $orderId);

        if (!$stmt->execute()) {
            return [
                'status' => 'false',
                'message' => "Execute failed."
            ];
        }

        return [
            'status' => 'true',
            'message' => "Order with ID {$orderId} has been marked as paid."
        ];
    }

    public function markOrderPaid($orderId, $paymentReference)
    {
        $upd = "
        UPDATE tbl_orders 
        SET 
            status = 'paid',
            sales_status = 'successful',
            payment_reference = ?,
            updated_at = NOW()
        WHERE id = ?
    ";
        $success = $this->db->execute_query($upd, "si", $paymentReference, $orderId);

        if ($success) {
            return [
                'status' => 'true',
                'message' => "Order with ID {$orderId} has been marked as paid."
            ];
        } else {
            return [
                'status' => 'false',
                'message' => "Failed to update order with ID {$orderId}."
            ];
        }
    }


    public function getOrderForVerification3($order_id)
    {


        $order_id = (int) $order_id;

        $orderQry = "SELECT subtotal_amount, total_amount, status
             FROM tbl_orders
             WHERE id = ?
             LIMIT 1";

        $order = $this->db->select($orderQry, 'i', 40);

        return $order;

        return [
            'success' => true,
            'debug' => [
                'order_id' => $order_id,
                'query_result' => $order,
                'query' => $orderQry
            ]
        ];
        // Query failed
        if ($order === false) {
            return [
                'success' => false,
                'error' => 'Database query failed'
            ];
        }

        // Order not found
        if (!$order) {
            return [
                'success' => false,
                'error' => 'Order not found'
            ];
        }

        // Already paid
        if ($order['status'] === 'paid') {
            return [
                'success' => false,
                'error' => 'Order already verified'
            ];
        }

        // Already fulfilled
        if ($order['status'] === 'fulfilled') {
            return [
                'success' => false,
                'error' => 'Order already fulfilled'
            ];
        }

        return [
            'success' => true,
            'order' => $order
        ];
    }




    public function getOrderForVerificationold($order_id)
    {
        $order = $this->db->query(
            "SELECT subtotal_amount, total_amount, status 
         FROM tbl_orders 
         WHERE id = ? 
         LIMIT 1",
            "i",
            $order_id
        )->fetch_assoc();

        if (!$order) {
            return [
                'success' => false,
                'error' => 'Order not found'
            ];
        }

        if ($order['status'] === 'paid') {
            return [
                'success' => true,
                'message' => 'Order already verified',
                'order' => $order
            ];
        }
        if ($order['status'] === 'fulfilled') {
            return [
                'success' => true,
                'message' => 'Order already on your way',
                'order' => $order
            ];
        }
        return [
            'success' => true,
            'order' => $order
        ];
    }




    //sales agent code ends here

    //third party vendor code starts from here
    public function getVendorState($globalId)
    {
        $vendorQry = "SELECT id FROM tbl_vendors WHERE global_id = ?";
        $vendorRes = $this->db->select($vendorQry, 's', $globalId);

        if ($vendorRes->num_rows() > 0) {
            $vendorData = $vendorRes->fetch_assoc();
            return (int) $vendorData['id'];
        }

        // Return null if vendor not found
        return null;
    }
    public function getDashboardByGlobalId($globalId)
    {
        //  $vendorId = $globalId;
        $vendorId = $this->getVendorState($globalId);

        if ($vendorId === null) {
            // Vendor not found 
            return null; // 
        }
        // if ($vendorId === null) {
        //     // Vendor not found 
        //     return null; // 
        // }

        return $this->getVendorDashboardOverview($vendorId);
    }
    public function getsalesByGlobalId($globalId)
    {
        $vendorId = $this->getVendorState($globalId);

        if ($vendorId === null) {
            // Vendor not found 
            return null; // 
        }

        return $this->getLast10FulfilledSales($vendorId);
    }
    public function getVendorDashboardOverview($vendor_id)
    {

        // Total revenue and orders for this vendor
        $revenueOrders = $this->db->select("        
        SELECT  
        COALESCE(SUM(CASE WHEN o.status = 'fulfilled' THEN o.total_amount ELSE 0 END), 0) AS total_revenue, 
         COALESCE(SUM(CASE WHEN o.status = 'fulfilled' THEN o.discounted_amount ELSE 0 END), 0) AS total_subtotal,

        COUNT(DISTINCT CASE WHEN o.status = 'fulfilled' THEN o.id END) AS total_orders,
        COUNT(DISTINCT o.id) AS total_orders_overall
    FROM tbl_orders o
    WHERE o.vendor_id = {$vendor_id}
     ")->fetch_object();

        // Top selling product for this vendor
        $topSelling = $this->db->select("
        SELECT  
            p.name AS product_name, 
            COALESCE(SUM(oi.quantity), 0) AS total_sold
        FROM tbl_order_items oi
        INNER JOIN tbl_products p ON p.id = oi.product_id
        INNER JOIN tbl_orders o ON oi.order_id = o.id
        WHERE o.status = 'fulfilled' AND o.vendor_id = {$vendor_id}
        GROUP BY p.id, p.name
        ORDER BY total_sold DESC
        LIMIT 1
    ")->fetch_object();


        // Count total fulfilled orders for the vendor
        $totalOrdersResult = $this->db->select("
    SELECT COUNT(*) AS total_orders
    FROM tbl_orders
    WHERE vendor_id = {$vendor_id} AND status = 'fulfilled'
")->fetch_object();

        return [
            "total_revenue" => (float) $revenueOrders->total_revenue,
            "total_orders" => (int) $revenueOrders->total_orders,
            "calculated_profit" => (float) $revenueOrders->total_subtotal, // profit
            "total_orders_overall" => (int) $revenueOrders->total_orders_overall,
            "top_selling_product" => $topSelling->product_name ?? null,
            "units_sold" => (int) ($topSelling->total_sold ?? 0),
            "vendor_id" => (int) $vendor_id,
            "total_orders" => (int) ($totalOrdersResult->total_orders ?? 0),

        ];
    }
    public function getLast10FulfilledSales($vendor_id)
    {
        $query = "
        SELECT 
            o.id AS order_id,
            o.total_amount,
            c.name AS customer_name,
            c.email AS customer_email,
            GROUP_CONCAT(p.name SEPARATOR ', ') AS product_names,
            o.created_at
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        INNER JOIN tbl_order_items oi ON oi.order_id = o.id
        INNER JOIN tbl_products p ON oi.product_id = p.id
        WHERE o.vendor_id = ? AND o.status = 'fulfilled'
        GROUP BY o.id, o.total_amount, c.name, c.email, o.created_at
        ORDER BY o.created_at DESC
        LIMIT 10
    ";

        $result = $this->db->select($query, 'i', $vendor_id);

        $sales = [];
        while ($row = $result->fetch_assoc()) {
            $sales[] = $row;
        }

        return $sales;
    }

    public function getFobOrders($vendor_ids, $page = 1, $limit = 10, $search = null, $status = 'all', $startDate = null, $endDate = null, $fetchAll = false)
    {
        if (!is_array($vendor_ids)) {
            $vendor_ids = [$vendor_ids];
        }

        if (empty($vendor_ids)) {
            return ['orders' => [], 'totalRecords' => 0, 'filteredRecords' => 0, 'totalPages' => 0, 'currentPage' => $page];
        }

        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 10;
        }

        $placeholders = implode(',', array_fill(0, count($vendor_ids), '?'));

        $whereClauses = ["o.vendor_id IN ($placeholders)"];
        $params = $vendor_ids;
        $types = str_repeat('i', count($vendor_ids));

        // Build search condition
        if (!empty($search)) {
            $search = "%" . $search . "%";
            $whereClauses[] = "(c.name LIKE ? OR o.id LIKE ?)";
            $params[] = $search;
            $params[] = $search;
            $types .= "ss";
        }

        // Build status condition
        if ($status !== 'all') {
            $whereClauses[] = "o.status = ?";
            $params[] = $status;
            $types .= "s";
        }

        // Build date range condition
        if (!empty($startDate) && !empty($endDate)) {
            $whereClauses[] = "o.created_at BETWEEN ? AND ?";
            $params[] = $startDate . ' 00:00:00';
            $params[] = $endDate . ' 23:59:59';
            $types .= "ss";
        }

        // Combine where clauses
        $whereQuery = !empty($whereClauses) ? "WHERE " . implode(" AND ", $whereClauses) : "";

        // Count total orders
        $totalSql = "
        SELECT COUNT(*) AS total
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        WHERE o.vendor_id IN ($placeholders)
    ";
        $totalStmt = $this->db->prepare($totalSql);
        $totalStmt->bind_param(str_repeat('i', count($vendor_ids)), ...$vendor_ids);
        $totalStmt->execute();
        $totalResult = $totalStmt->get_result();
        $totalRecords = $totalResult->fetch_object()->total;

        // Count filtered orders
        $countSql = "
        SELECT COUNT(*) AS total
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        $whereQuery
    ";
        $countStmt = $this->db->prepare($countSql);
        if (!empty($params)) {
            $countStmt->bind_param($types, ...$params);
        }
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $filteredRecords = $countResult->fetch_object()->total;

        // Fetch orders
        $sql = "
        SELECT 
            o.id AS order_id,
            o.total_amount,
            o.status,
            c.name AS customer_name,
            c.email AS customer_email,
            o.created_at,
            o.vendor_id
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        $whereQuery
        ORDER BY o.created_at DESC
    ";

        // Add pagination unless fetching all
        if (!$fetchAll) {
            $sql .= " LIMIT ? OFFSET ?";
            $params[] = $limit;
            $params[] = ($page - 1) * $limit;
            $types .= "ii";
        }

        $stmt = $this->db->prepare($sql);
        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
        }
        $stmt->execute();
        $result = $stmt->get_result();

        $orders = [];
        while ($row = $result->fetch_object()) {
            $orders[] = $row;
        }

        return [
            'orders' => $orders,
            'totalRecords' => $totalRecords,
            'filteredRecords' => $filteredRecords,
            'totalPages' => ceil($filteredRecords / $limit),
            'currentPage' => $page,
            'search' => $search ? trim($search, "%") : null,
            'status' => $status,
            'startDate' => $startDate,
            'endDate' => $endDate
        ];
    }

    public function getFobOrdersNew($vendor_ids, $status = null, $limit = null)
    {
        if (!is_array($vendor_ids)) {
            $vendor_ids = [$vendor_ids];
        }

        if (empty($vendor_ids)) {
            return []; // no vendors = no orders
        }

        $placeholders = implode(',', array_fill(0, count($vendor_ids), '?'));

        $query = "
        SELECT  
            o.id AS order_id,
            o.total_amount,
            o.status,
            c.name AS customer_name,
            c.email AS customer_email,
            o.created_at,
            o.vendor_id
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        WHERE o.vendor_id IN ($placeholders)
    ";

        $params = [str_repeat('i', count($vendor_ids))];
        foreach ($vendor_ids as $vid) {
            $params[] = (int) $vid;
        }

        if (!is_null($status)) {
            $query .= " AND o.status = ?";
            $params[0] .= 's';
            $params[] = $status;
        }

        $query .= " ORDER BY o.created_at DESC";

        if (!is_null($limit) && is_numeric($limit)) {
            $query .= " LIMIT ?";
            $params[0] .= 'i';
            $params[] = (int) $limit;
        }

        $result = $this->db->select($query, ...$params);

        $orders = [];
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $orders[] = $row;
            }
        }

        return $orders;
    }

    public function getFobOrderDetails($order_id)
    {
        $query = "
        SELECT 
            o.id AS order_id,
            o.total_amount,           
  o.subtotal_amount,
             o.tax_amount,
            o.shipping_amount,
            o.discount_amount,
            o.refund_amount,
            o.currency,
            o.status,
            o.payment_method,
            o.created_at,
            o.updated_at,

            c.id AS customer_id,
            c.name AS customer_name,
            c.email AS customer_email,
            c.phone AS customer_phone,
            c.address AS customer_address,

           
            p.id AS product_id,
            p.name AS product_name,
            p.sku AS product_sku,
            oi.quantity,
            oi.unit_price AS unit_price,
            (oi.quantity * oi.unit_price) AS line_total
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        INNER JOIN tbl_order_items oi ON o.id = oi.order_id
        INNER JOIN tbl_products p ON oi.product_id = p.id
        WHERE o.id = ?
        ORDER BY p.name
    ";

        $result = $this->db->select($query, 'i', $order_id);

        if ($result->num_rows() === 0) {
            return null; // No order found for this vendor & ID
        }

        $order = null;
        $customer = null;
        $items = [];

        while ($row = $result->fetch_assoc()) {
            if ($order === null) {
                $order = [
                    'order_id' => $row['order_id'],
                    'total_amount' => $row['total_amount'],
                    'subtotal_amount' => $row['subtotal_amount'],

                    'tax_amount' => $row['tax_amount'],
                    'shipping_amount' => $row['shipping_amount'],
                    'discount_amount' => $row['discount_amount'],
                    'refund_amount' => $row['refund_amount'],
                    'currency' => $row['currency'],
                    'status' => $row['status'],
                    'payment_method' => $row['payment_method'],
                    'created_at' => $row['created_at'],
                    'updated_at' => $row['updated_at'],
                ];

                $customer = [
                    'customer_id' => $row['customer_id'],
                    'name' => $row['customer_name'],
                    'email' => $row['customer_email'],
                    'phone' => $row['customer_phone'],
                    'address' => $row['customer_address'],
                ];
            }

            $items[] = [
                'product_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_sku' => $row['product_sku'],
                'quantity' => $row['quantity'],
                'unit_price' => $row['unit_price'],
                'line_total' => $row['line_total'],
            ];
        }

        return [
            'order' => $order,
            'customer' => $customer,
            'items' => $items
        ];
    }

    public function getVendorOrdersPaginated($vendorId, $page = 1, $limit = 5, $search = null, $dateFrom = null, $dateTo = null)
    {
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        if ($vendorId === false) {
            return null;
        }

        // Validate pagination params
        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 5;
        }

        $offset = ($page - 1) * $limit;

        // Base params (vendor required)
        $searchQuery = "";
        $dateQuery = "";
        $params = array($vendorId);
        $types = "i";

        // Search filter
        if (!empty($search)) {
            $search = "%" . $search . "%";
            $searchQuery = "AND (c.name LIKE ? OR c.email LIKE ? OR o.status LIKE ?)";
            $params = array_merge($params, array($search, $search, $search));
            $types .= "sss";
        }

        // Date filter
        if (!empty($dateFrom)) {
            $dateQuery .= " AND o.created_at >= ? ";
            $params[] = $dateFrom . " 00:00:00";
            $types .= "s";
        }
        if (!empty($dateTo)) {
            $dateQuery .= " AND o.created_at <= ? ";
            $params[] = $dateTo . " 23:59:59";
            $types .= "s";
        }

        // Count total orders
        $countSql = "
        SELECT COUNT(*) AS total
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        WHERE o.vendor_id = ? $searchQuery $dateQuery
    ";
        $countStmt = $this->db->prepare($countSql);
        $countStmt->bind_param($types, ...$params);
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $totalOrders = $countResult->fetch_object()->total;
        $totalPages = ceil($totalOrders / $limit);

        // Calculate total fulfilled sales
        $salesSql = "
        SELECT COALESCE(SUM(o.total_amount), 0) AS total_sales
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        WHERE o.vendor_id = ? $searchQuery $dateQuery
        AND o.status = 'fulfilled'
    ";
        $salesStmt = $this->db->prepare($salesSql);
        $salesStmt->bind_param($types, ...$params);
        $salesStmt->execute();
        $salesResult = $salesStmt->get_result();
        $rowSales = $salesResult->fetch_object();
        $totalSales = $rowSales ? $rowSales->total_sales : 0;

        // Fetch paginated orders
        $sql = "
        SELECT  
            o.id AS order_id,
            o.total_amount,
            o.status,
            c.name AS customer_name,
            c.email AS customer_email,
            o.created_at
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        WHERE o.vendor_id = ? $searchQuery $dateQuery
        ORDER BY o.created_at DESC
        LIMIT ? OFFSET ?
    ";
        $stmt = $this->db->prepare($sql);

        $typesWithLimits = $types . "ii";
        $paramsWithLimits = array_merge($params, array($limit, $offset));
        $stmt->bind_param($typesWithLimits, ...$paramsWithLimits);

        $stmt->execute();
        $result = $stmt->get_result();

        $orders = array();
        while ($row = $result->fetch_object()) {
            $orders[] = $row;
        }

        return (object) array(
            'orders' => $orders,
            'total_orders' => $totalOrders,
            'totalPages' => $totalPages,
            'currentPage' => $page,
            'total_sales' => $totalSales,
            'search' => !empty($search) ? trim($search, "%") : null,
            'date_from' => $dateFrom,
            'date_to' => $dateTo
        );
    }

    public function getVendorOrders($vendor_id, $page = 1, $limit = 10, $search = null, $status = 'all', $startDate = null, $endDate = null, $fetchAll = false)
    {
        if (empty($vendor_id)) {
            return ['orders' => [], 'totalRecords' => 0, 'filteredRecords' => 0, 'totalPages' => 0, 'currentPage' => $page];
        }

        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 10;
        }

        $whereClauses = ["o.vendor_id = ?"];
        $params = [$vendor_id];
        $types = "i";

        if (!empty($search)) {
            $search = "%" . $search . "%";
            $whereClauses[] = "(c.name LIKE ? OR o.id LIKE ?)";
            $params[] = $search;
            $params[] = $search;
            $types .= "ss";
        }

        if ($status !== 'all') {
            $whereClauses[] = "o.status = ?";
            $params[] = $status;
            $types .= "s";
        }

        if (!empty($startDate) && !empty($endDate)) {
            $whereClauses[] = "o.created_at BETWEEN ? AND ?";
            $params[] = $startDate . ' 00:00:00';
            $params[] = $endDate . ' 23:59:59';
            $types .= "ss";
        }

        $whereQuery = !empty($whereClauses) ? "WHERE " . implode(" AND ", $whereClauses) : "";

        // Count total orders
        $totalSql = "
        SELECT COUNT(*) AS total
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        WHERE o.vendor_id = ?
    ";
        $totalStmt = $this->db->prepare($totalSql);
        if (!$totalStmt) {
            error_log("Total SQL Error: " . $this->db->error);
            return ['orders' => [], 'totalRecords' => 0, 'filteredRecords' => 0, 'totalPages' => 0, 'currentPage' => $page];
        }
        $totalStmt->bind_param('i', $vendor_id);
        $totalStmt->execute();
        $totalResult = $totalStmt->get_result();
        $totalRecords = $totalResult->fetch_object()->total;

        // Count filtered orders
        $countSql = "
        SELECT COUNT(*) AS total
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        $whereQuery
    ";
        $countStmt = $this->db->prepare($countSql);
        if (!$countStmt) {
            error_log("Count SQL Error: " . $this->db->error);
            return ['orders' => [], 'totalRecords' => $totalRecords, 'filteredRecords' => 0, 'totalPages' => 0, 'currentPage' => $page];
        }
        if (!empty($params)) {
            $countStmt->bind_param($types, ...$params);
        }
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $filteredRecords = $countResult->fetch_object()->total;

        // Fetch orders
        $sql = "
        SELECT 
    o.id AS order_id,
    o.total_amount,
    o.status,
    (SELECT p.name 
     FROM tbl_order_items oi 
     INNER JOIN tbl_products p ON oi.product_id = p.id
     WHERE oi.order_id = o.id 
     LIMIT 1) AS product_name,
    c.name AS customer_name,
    c.email AS customer_email,
    o.created_at,
    o.vendor_id
FROM tbl_orders o
INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
$whereQuery
ORDER BY o.created_at DESC

    ";

        if (!$fetchAll) {
            $sql .= " LIMIT ? OFFSET ?";
            $params[] = $limit;
            $params[] = ($page - 1) * $limit;
            $types .= "ii";
        }

        $stmt = $this->db->prepare($sql);
        if (!$stmt) {
            error_log("Main SQL Error: " . $this->db->error);
            return ['orders' => [], 'totalRecords' => $totalRecords, 'filteredRecords' => $filteredRecords, 'totalPages' => 0, 'currentPage' => $page];
        }
        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
        }
        $stmt->execute();
        $result = $stmt->get_result();

        $orders = [];
        while ($row = $result->fetch_object()) {
            $orders[] = $row;
        }

        return [
            'orders' => $orders,
            'totalRecords' => $totalRecords,
            'filteredRecords' => $filteredRecords,
            'totalPages' => ceil($filteredRecords / $limit),
            'currentPage' => $page,
            'search' => $search ? trim($search, "%") : null,
            'status' => $status,
            'startDate' => $startDate,
            'endDate' => $endDate
        ];
    }

    public function getVendorOrdersOld($vendor_id, $status = null, $limit = null)
    {
        $query = "
        SELECT 
            o.id AS order_id,
            o.total_amount,
            o.status,
            c.name AS customer_name,
            c.email AS customer_email,
            o.created_at
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        WHERE o.vendor_id = ?
    ";

        $params = ['i', $vendor_id];

        // Optional status filter
        if (!is_null($status)) {
            $query .= " AND o.status = ?";
            $params[0] .= 's';
            $params[] = $status;
        }

        $query .= " ORDER BY o.created_at DESC";

        // Optional limit
        if (!is_null($limit) && is_numeric($limit)) {
            $query .= " LIMIT ?";
            $params[0] .= 'i';
            $params[] = (int) $limit;
        }

        $result = $this->db->select($query, ...$params);

        $orders = [];
        while ($row = $result->fetch_assoc()) {
            $orders[] = $row;
        }

        return $orders;
    }


    public function getVendorOrderDetails_simple($vendor_id, $order_id)
    {
        $query = "
        SELECT 
            o.id AS order_id,
            o.total_amount,
             o.subtotal_amount,
            o.tax_amount,
            o.shipping_amount,
            o.discount_amount,
            o.refund_amount,
            o.currency,
            o.status,
            o.payment_method,
            o.created_at,
            o.updated_at,
            c.id AS customer_id,
            c.name AS customer_name,
            c.email AS customer_email,
            c.phone AS customer_phone,
            c.address AS customer_address,
            p.id AS product_id,
            p.name AS product_name,
            p.sku AS product_sku,
            oi.quantity,
            oi.price AS unit_price,
            (oi.quantity * oi.price) AS line_total
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        INNER JOIN tbl_order_items oi ON o.id = oi.order_id
        INNER JOIN tbl_products p ON oi.product_id = p.id
        WHERE o.vendor_id = ? 
          AND o.id = ?
        ORDER BY p.name
    ";

        $result = $this->db->select($query, 'ii', $vendor_id, $order_id);

        $orderDetails = [];
        while ($row = $result->fetch_assoc()) {
            $orderDetails[] = $row;
        }

        return $orderDetails;
    }


    public function getVendorOrderDetails($vendor_id, $order_id)
    {
        $query = "
        SELECT 
            o.id AS order_id,
            o.total_amount,           
  o.subtotal_amount,
             o.tax_amount,
            o.shipping_amount,
            o.discount_amount,
            o.refund_amount,
            o.currency,
            o.status,
            o.payment_method,
            o.created_at,
            o.updated_at,

            c.id AS customer_id,
            c.name AS customer_name,
            c.email AS customer_email,
            c.phone AS customer_phone,
            c.address AS customer_address,

           
            p.id AS product_id,
            p.name AS product_name,
            p.sku AS product_sku,
            oi.quantity,
            oi.unit_price AS unit_price,
            (oi.quantity * oi.unit_price) AS line_total
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        INNER JOIN tbl_order_items oi ON o.id = oi.order_id
        INNER JOIN tbl_products p ON oi.product_id = p.id
        WHERE o.vendor_id = ? 
          AND o.id = ?
        ORDER BY p.name
    ";

        $result = $this->db->select($query, 'ii', $vendor_id, $order_id);

        if ($result->num_rows() === 0) {
            return null; // No order found for this vendor & ID
        }

        $order = null;
        $customer = null;
        $items = [];

        while ($row = $result->fetch_assoc()) {
            if ($order === null) {
                $order = [
                    'order_id' => $row['order_id'],
                    'total_amount' => $row['total_amount'],
                    'subtotal_amount' => $row['subtotal_amount'],

                    'tax_amount' => $row['tax_amount'],
                    'shipping_amount' => $row['shipping_amount'],
                    'discount_amount' => $row['discount_amount'],
                    'refund_amount' => $row['refund_amount'],
                    'currency' => $row['currency'],
                    'status' => $row['status'],
                    'payment_method' => $row['payment_method'],
                    'created_at' => $row['created_at'],
                    'updated_at' => $row['updated_at'],
                ];

                $customer = [
                    'customer_id' => $row['customer_id'],
                    'name' => $row['customer_name'],
                    'email' => $row['customer_email'],
                    'phone' => $row['customer_phone'],
                    'address' => $row['customer_address'],
                ];
            }

            $items[] = [
                'product_id' => $row['product_id'],
                'product_name' => $row['product_name'],
                'product_sku' => $row['product_sku'],
                'quantity' => $row['quantity'],
                'unit_price' => $row['unit_price'],
                'line_total' => $row['line_total'],
            ];
        }

        return [
            'order' => $order,
            'customer' => $customer,
            'items' => $items
        ];
    }





    public function getVendorOrders_full($vendor_id, $status = null, $limit = null)
    {
        $query = "
        SELECT 
            o.id AS order_id,
            o.total_amount,
            o.status,
            c.name AS customer_name,
            c.email AS customer_email,
            GROUP_CONCAT(p.name SEPARATOR ', ') AS product_names,
            o.created_at
        FROM tbl_orders o
        INNER JOIN tbl_vendor_customers c ON o.customer_id = c.id
        INNER JOIN tbl_order_items oi ON oi.order_id = o.id
        INNER JOIN tbl_products p ON oi.product_id = p.id
        WHERE o.vendor_id = ?
    ";

        $params = ['i', $vendor_id];

        // Optional status filter
        if (!is_null($status)) {
            $query .= " AND o.status = ?";
            $params[0] .= 's'; // add string type
            $params[] = $status;
        }

        $query .= "
        GROUP BY o.id, o.total_amount, o.status, c.name, c.email, o.created_at
        ORDER BY o.created_at DESC
    ";

        // Optional limit
        if (!is_null($limit) && is_numeric($limit)) {
            $query .= " LIMIT ?";
            $params[0] .= 'i'; // integer type
            $params[] = (int) $limit;
        }

        // Execute query
        $result = $this->db->select($query, ...$params);

        $sales = [];
        while ($row = $result->fetch_assoc()) {
            $sales[] = $row;
        }

        return $sales;
    }



    public function updateVendorOrderStatusvariant($vendor_id, $order_id, $new_status)
    {
        // Normalize new status to lowercase
        $new_status = strtolower(trim($new_status));

        // Allowed statuses
        $allowed_statuses = ['declined', 'canceled', 'fulfilled'];

        if (!in_array($new_status, $allowed_statuses)) {
            return [
                'error' => false,
                'message' => 'Invalid status provided'
            ];
        }

        // Check if the order exists for this vendor
        $checkSql = "SELECT status FROM tbl_orders WHERE vendor_id = ? AND id = ?";
        $res = $this->db->select($checkSql, "ii", $vendor_id, $order_id);

        if ($res->num_rows() === 0) {
            return [
                'error' => false,
                'message' => 'Order not found for this vendor'
            ];
        }

        $row = $res->fetch_assoc();

        // Prevent change if already fulfilled
        if (strtolower($row['status']) === 'fulfilled') {
            return [
                'error' => false,
                'message' => 'This order has already been fulfilled and cannot be changed'
            ];
        }

        // Update the status
        $updateSql = "UPDATE tbl_orders SET status = ?, updated_at = NOW() WHERE vendor_id = ? AND id = ?";
        $updated = $this->db->execute_query($updateSql, "sii", $new_status, $vendor_id, $order_id);

        if ($updated) {
            return [
                'success' => true,
                'message' => 'Order status updated successfully'
            ];
        } else {
            return [
                'error' => false,
                'message' => 'Failed to update order status'
            ];
        }
    }
    public function updateVendorOrderStatus($vendor_id, $order_id, $new_status)
    {
        // Normalize new status
        $new_status = strtolower(trim($new_status));

        // Allowed statuses
        $allowed_statuses = ['declined', 'canceled', 'fulfilled'];

        if (!in_array($new_status, $allowed_statuses)) {
            return [
                'error' => true,
                'message' => 'Invalid status provided'
            ];
        }

        // Check if the order exists for this vendor
        $checkSql = "SELECT status FROM tbl_orders WHERE vendor_id = ? AND id = ?";
        $res = $this->db->select($checkSql, "ii", $vendor_id, $order_id);

        if ($res->num_rows() === 0) {
            return [
                'error' => true,
                'message' => 'Order not found for this vendor'
            ];
        }

        $row = $res->fetch_assoc();

        // Prevent change if already fulfilled
        if (strtolower($row['status']) === 'fulfilled') {
            return [
                'error' => true,
                'message' => 'This order has already been fulfilled and cannot be changed'
            ];
        }


        $updateSql = "UPDATE tbl_orders SET status = ?, updated_at = NOW() WHERE vendor_id = ? AND id = ?";
        $updated = $this->db->execute_query($updateSql, "sii", $new_status, $vendor_id, $order_id);

        if (!$updated) {
            return [
                'error' => true,
                'message' => 'Failed to update order status'
            ];
        }

        // If the order is fulfilled, update product stock quantities
        // If the order is fulfilled, update product stock quantities
        if ($new_status === 'fulfilled') {
            $itemsSql = "SELECT product_id, quantity FROM tbl_order_items WHERE order_id = ?";
            $itemsRes = $this->db->select($itemsSql, "i", $order_id);

            if ($itemsRes->num_rows() > 0) {
                while ($item = $itemsRes->fetch_assoc()) {
                    $product_id = (int) $item['product_id'];
                    $quantity = (int) $item['quantity'];

                    // Reduce stock (not below 0)
                    $updateStockSql = "
                UPDATE tbl_products 
                SET stock_quantity = GREATEST(stock_quantity - ?, 0)
                WHERE id = ?
            ";
                    $this->db->execute_query($updateStockSql, "ii", $quantity, $product_id);

                    // Check if stock is now below reminder level
                    $checkStockSql = "
                SELECT p.name, p.stock_quantity, p.stock_reminder, v.email AS vendor_email
                FROM tbl_products p
                JOIN tbl_vendors v ON v.id = p.vendor_id
                WHERE p.id = ?
            ";
                    $checkRes = $this->db->select($checkStockSql, "i", $product_id);

                    if ($checkRes->num_rows() > 0) {
                        $prod = $checkRes->fetch_assoc();

                        if ($prod['stock_quantity'] < $prod['stock_reminder']) {
                            // Send low-stock email (simplified example)
                            $subject = "Low Stock Alert: " . $prod['name'];
                            $message = "Hello,\n\nYour product '{$prod['name']}' has low stock.\n" .
                                "Remaining: {$prod['stock_quantity']} (Reminder level: {$prod['stock_reminder']})\n\n" .
                                "Please restock soon.";
                            $headers = "From: no-reply@inclide.com\r\n";
                            $this->sendEmail($prod['vendor_email'], 'reminder@fob.com.ng', $subject, $message);

                            //                            @mail("emmpraise@yahoo.com", $subject, $message, $headers);
                        }
                    }
                }
            }
        }


        return [
            'success' => true,
            'message' => 'Order status updated successfully'
        ];
    }


    //vendor products page dashboard endpoints
    public function vendorProductDashboard($vendor_id)
    {

        // Total revenue and orders for this vendor
        $revenueOrders = $this->db->select("
        SELECT 
            COALESCE(SUM(o.total_amount), 0) AS total_revenue,
            COUNT(DISTINCT o.id) AS total_orders
        FROM tbl_orders o
        WHERE o.vendor_id = {$vendor_id} AND o.status = 'fulfilled'
    ")->fetch_object();


        //         // Count active products for this vendor
        //         $activeProducts = $this->db->select("
        //     SELECT COUNT(*) AS active_count
        //     FROM tbl_products
        //     WHERE vendor_id = {$vendor_id} AND status = 'active'
        // ")->fetch_object();



        $allProducts = [];
        $result = $this->db->select("
   SELECT 
    p.id AS product_id,
    p.name AS product_name,
    p.status AS product_status,
    p.created_at AS product_created_date,
    COALESCE(SUM(oi.total_price), 0) AS total_amount_sold,
    COALESCE(COUNT(DISTINCT oi.order_id), 0) AS number_of_sales
FROM tbl_products p
LEFT JOIN tbl_order_items oi 
    ON oi.product_id = p.id
LEFT JOIN tbl_orders o 
    ON o.id = oi.order_id
WHERE p.vendor_id = {$vendor_id}
GROUP BY 
    p.id, 
    p.name, 
    p.status, 
    p.created_at
ORDER BY p.created_at DESC
");

        while ($row = $result->fetch_assoc()) {
            $allProducts[] = $row;
        }

        // Calculate active product count from the fetched data
        $activeCount = 0;
        foreach ($allProducts as $product) {
            if (isset($product['product_status']) && $product['product_status'] === 'active') {
                $activeCount++;
            }
        }
        return [
            "total_revenue" => (float) $revenueOrders->total_revenue,
            "total_orders" => (int) $revenueOrders->total_orders,
            "active_products" => $activeCount,
            "all_products" => $allProducts,
            "vendor_id" => (int) $vendor_id

        ];
    }

    // get vendor product 

    public function getVendorProductPaginated($vendor_id, $page = 1, $limit = 10, $search = null, $status = null, $startDate = null, $endDate = null, $fetchAll = false)
    {
        if (empty($vendor_id)) {
            return ['products' => [], 'totalRecords' => 0, 'filteredRecords' => 0, 'totalPages' => 0, 'currentPage' => $page];
        }

        $page = filter_var($page, FILTER_VALIDATE_INT);
        if ($page === false || $page < 1) {
            $page = 1;
        }

        $limit = filter_var($limit, FILTER_VALIDATE_INT);
        if ($limit === false || $limit < 1) {
            $limit = 10;
        }

        $whereClauses = ["p.vendor_id = ?"];
        $params = [$vendor_id];
        $types = "i";

        if (!empty($search)) {
            $search = "%" . $search . "%";
            $whereClauses[] = "p.name LIKE ?";
            $params[] = $search;
            $types .= "s";
        }

        if (!empty($status)) {
            $whereClauses[] = "p.status = ?";
            $params[] = $status;
            $types .= "s";
        }

        if (!empty($startDate) && !empty($endDate)) {
            $whereClauses[] = "p.created_at BETWEEN ? AND ?";
            $params[] = $startDate . ' 00:00:00';
            $params[] = $endDate . ' 23:59:59';
            $types .= "ss";
        }

        $whereQuery = !empty($whereClauses) ? "WHERE " . implode(" AND ", $whereClauses) : "";

        // Count total products
        $totalSql = "
        SELECT COUNT(*) AS total
        FROM tbl_products p
        WHERE p.vendor_id = ?
    ";
        $totalStmt = $this->db->prepare($totalSql);
        if (!$totalStmt) {
            error_log("Total SQL Error: " . $this->db->error);
            return ['products' => [], 'totalRecords' => 0, 'filteredRecords' => 0, 'totalPages' => 0, 'currentPage' => $page];
        }
        $totalStmt->bind_param('i', $vendor_id);
        $totalStmt->execute();
        $totalResult = $totalStmt->get_result();
        $totalRecords = $totalResult->fetch_object()->total;

        // Count filtered products
        $countSql = "
        SELECT COUNT(*) AS total
        FROM tbl_products p
        $whereQuery
    ";
        $countStmt = $this->db->prepare($countSql);
        if (!$countStmt) {
            error_log("Count SQL Error: " . $this->db->error);
            return ['products' => [], 'totalRecords' => $totalRecords, 'filteredRecords' => 0, 'totalPages' => 0, 'currentPage' => $page];
        }
        if (!empty($params)) {
            $countStmt->bind_param($types, ...$params);
        }
        $countStmt->execute();
        $countResult = $countStmt->get_result();
        $filteredRecords = $countResult->fetch_object()->total;

        // Fetch products
        $sql = "
        SELECT 
            p.id AS product_id,
            p.name AS product_name,
            p.status AS product_status,
            p.created_at AS product_created_date,
            COALESCE(SUM(oi.total_price), 0) AS total_amount_sold,
            COALESCE(COUNT(DISTINCT oi.order_id), 0) AS number_of_sales
        FROM tbl_products p
        LEFT JOIN tbl_order_items oi ON oi.product_id = p.id
        LEFT JOIN tbl_orders o ON o.id = oi.order_id
        $whereQuery
        GROUP BY p.id, p.name, p.status, p.created_at
        ORDER BY p.created_at DESC
    ";

        if (!$fetchAll) {
            $sql .= " LIMIT ? OFFSET ?";
            $params[] = $limit;
            $params[] = ($page - 1) * $limit;
            $types .= "ii";
        }

        $stmt = $this->db->prepare($sql);
        if (!$stmt) {
            error_log("Main SQL Error: " . $this->db->error);
            return ['products' => [], 'totalRecords' => $totalRecords, 'filteredRecords' => $filteredRecords, 'totalPages' => 0, 'currentPage' => $page];
        }
        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
        }
        $stmt->execute();
        $result = $stmt->get_result();

        $products = [];
        while ($row = $result->fetch_object()) {
            $products[] = $row;
        }

        return [
            'products' => $products,
            'totalRecords' => $totalRecords,
            'filteredRecords' => $filteredRecords,
            'totalPages' => ceil($filteredRecords / $limit),
            'currentPage' => $page,
            'search' => $search ? trim($search, "%") : null,
            'status' => $status,
            'startDate' => $startDate,
            'endDate' => $endDate
        ];
    }


    //     public function getvendorproductDetails($vendorId)
    //     {
    //         $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
    //         if ($vendorId === false) {
    //             return null;
    //         }
    // SELECT * FROM `tbl_products` WHERE `id` = 21 AND `vendor_id` = 21
    //         $stmt = $this->db->prepare("SELECT * FROM tbl_vendors WHERE id = ?");
    //         $stmt->bind_param("i", $vendorId);
    //         $stmt->execute();
    //         $result = $stmt->get_result();

    //         if ($vendor = $result->fetch_object()) {
    //             return $vendor;
    //         } else {
    //             return null;
    //         }
    //     }
    public function getVendorProductDetails_single($productId, $vendorId)
    {
        // Validate IDs
        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);

        if ($productId === false || $vendorId === false) {
            return null;
        }

        // Prepare and execute query
        $stmt = $this->db->prepare(
            "SELECT * 
         FROM tbl_products 
         WHERE id = ? AND vendor_id = ?"
        );
        $stmt->bind_param("ii", $productId, $vendorId);
        $stmt->execute();

        $result = $stmt->get_result();

        if ($product = $result->fetch_object()) {
            return $product;
        }

        return null;
    }
    public function getVendorProductDetails($productId, $vendorId)
    {
        // Validate IDs
        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);

        if ($productId === false || $vendorId === false) {
            return null;
        }

        // 1. Get product details
        $stmt = $this->db->prepare(
            "SELECT * 
         FROM tbl_products 
         WHERE id = ? AND vendor_id = ?"
        );
        $stmt->bind_param("ii", $productId, $vendorId);
        $stmt->execute();
        $result = $stmt->get_result();

        if (!($product = $result->fetch_object())) {
            return null; // No product found for this vendor
        }

        // 2. Get attributes + values + quantities
        $stmtAttr = $this->db->prepare(
            "SELECT 
            pa.id AS attribute_id,
            pa.name AS attribute_name,
            pav.id AS value_id,  pav.attribute_id AS attribute_id,
            pav.value AS attribute_value,
            pav.quantity
         FROM tbl_product_attributes pa
         INNER JOIN tbl_product_attribute_values pav 
            ON pa.id = pav.attribute_id
         WHERE pa.product_id = ?
         ORDER BY pa.name, pav.value"
        );
        $stmtAttr->bind_param("i", $productId);
        $stmtAttr->execute();
        $attrResult = $stmtAttr->get_result();

        // Group attributes for easy front-end use
        $attributes = [];
        while ($row = $attrResult->fetch_assoc()) {
            $attrName = $row['attribute_name'];
            if (!isset($attributes[$attrName])) {
                $attributes[$attrName] = [];
            }
            $attributes[$attrName][] = [
                'value_id' => $row['value_id'],
                'value' => $row['attribute_value'],
                'quantity' => $row['quantity'],
                'attribute_id' => $row['attribute_id']
            ];
        }

        // 3. Attach attributes to product object
        $product->attributes = $attributes; // 3. Get specifications
        $stmtSpec = $this->db->prepare(
            "SELECT id, product_id, name, value
         FROM tbl_product_specifications
         WHERE product_id = ?"
        );
        $stmtSpec->bind_param("i", $productId);
        $stmtSpec->execute();
        $specResult = $stmtSpec->get_result();

        $specifications = [];
        while ($row = $specResult->fetch_assoc()) {
            $specifications[] = [
                'id' => $row['id'],
                'name' => $row['name'],
                'value' => $row['value']
            ];
        }
        $product->specifications = $specifications;

        // 4. Get product images
        $stmtImg = $this->db->prepare(
            "SELECT 
        id,
        filename,
        uploaded_at
     FROM marketplace_product_images
     WHERE product_id = ? AND vendor_id = ?
     ORDER BY id ASC"
        );
        $stmtImg->bind_param("ii", $productId, $vendorId);
        $stmtImg->execute();
        $imgResult = $stmtImg->get_result();

        $images = [];

        $baseUrl = "public/uploads/products/";

        while ($row = $imgResult->fetch_assoc()) {

            $images[] = [
                'id' => $row['id'],
                'filename' => $row['filename'],
                'url' => $baseUrl . $row['filename'],
                'uploaded_at' => $row['uploaded_at']
            ];
        }

        $product->images = $images;

        return $product;
    }

    public function updateVendorProductStatus($productId, $action, $categoryId = null, $adminReason = null)
    {
        $productId = filter_var($productId, FILTER_VALIDATE_INT);
        $categoryId = filter_var($categoryId, FILTER_VALIDATE_INT);

        if ($productId === false) {
            return ['error' => false, 'message' => 'Invalid product ID'];
        }

        if ($action !== 'approve' && $action !== 'deny') {
            return ['error' => false, 'message' => 'Invalid action'];
        }

        if ($action === 'approve') {
            if ($categoryId === false || $categoryId === null) {
                return ['error' => false, 'message' => 'Category required for approval'];
            }
            $status = 'active';
            $stmt = $this->db->prepare("
            UPDATE tbl_products 
            SET status = ?, category_id = ?, admin_reason = NULL 
            WHERE id = ?
        ");
            $stmt->bind_param('sii', $status, $categoryId, $productId);
        } else {
            $status = 'rejected';
            if (empty($adminReason)) {
                return ['error' => false, 'message' => 'Admin reason required for denial'];
            }
            $stmt = $this->db->prepare("
            UPDATE tbl_products 
            SET status = ?, admin_reason = ? 
            WHERE id = ?
        ");
            $stmt->bind_param('ssi', $status, $adminReason, $productId);
        }

        if ($stmt->execute()) {
            return ['success' => true, 'message' => 'Product updated successfully.'];
        } else {
            return ['error' => false, 'message' => 'Database error: ' . $stmt->error];
        }
    }

    public function updateVendorProduct($vendorId, $data)
    {
        // Validate IDs
        //    $productId = filter_var($data['product_id'], FILTER_VALIDATE_INT);
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);

        if ($vendorId === false) {
            return ['error' => false, 'message' => 'Invalid product or vendor ID'];
        }
        $productId = isset($data['product_id']) ? filter_var($data['product_id'], FILTER_VALIDATE_INT) : false;

        if ($productId === false || $productId <= 0) {
            return ['error' => false, 'message' => 'Invalid product ID'];
        }
        // Required fields
        $mandatoryFields = ['action', 'product_name', 'stock_quantity', 'product_price'];
        foreach ($mandatoryFields as $field) {
            if (!isset($data[$field]) || $data[$field] === '') {
                return ['error' => false, 'message' => "Missing required field: {$field}"];
            }
        }

        // Validate action
        $allowedActions = ['update', 'archived', 'pending'];
        if (!in_array($data['action'], $allowedActions, true)) {
            return ['error' => false, 'message' => 'Invalid action'];
        }

        // Validate numeric fields
        if (!is_numeric($data['stock_quantity']) || (int) $data['stock_quantity'] < 0) {
            return ['error' => false, 'message' => 'Invalid stock quantity'];
        }
        if (!is_numeric($data['product_price']) || (float) $data['product_price'] < 0) {
            return ['error' => false, 'message' => 'Invalid product price'];
        }
        $data['discount_price'] = isset($data['discount_price']) ? (float) $data['discount_price'] : 0;
        $rawDescription = $data['description'] ?? '';
        $data['description'] = $this->saveDescription($rawDescription);

        //  $data['description']     = $data['description'] ?? '';
        $data['category_id'] = isset($data['category_id']) ? (int) $data['category_id'] : 1; // default category id = 1

        $all_query_ok = true;
        $this->db->autocommit(FALSE);


        $statusToSave = $data['action'];
        $now = date('Y-m-d H:i:s');

        if ($data['action'] === 'update') {
            $stmt = $this->db->prepare("SELECT status FROM tbl_products WHERE id = ? AND vendor_id = ?");
            $stmt->bind_param("ii", $productId, $vendorId);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($product = $result->fetch_object()) {
                // Only preserve status if current is 'active'
                if ($product->status === 'active') {
                    $statusToSave = $product->status;
                }
            } else {
                return ['error' => false, 'message' => 'Product not found'];
            }
        }




        // Update main product
        $stmt = $this->db->prepare("
        UPDATE tbl_products
        SET name = ?, stock_quantity = ?,  stock_reminder = ?,  price = ?, status = ?,  description = ?,
        discount_price = ?,
        category_id = ? , updated_at = ?
        WHERE id = ? AND vendor_id = ? AND status NOT IN ('declined', 'rejected')
    ");
        $stmt->bind_param(
            "sddssdiisii",
            $data['product_name'],
            $data['stock_quantity'],
            $data['stock_reminder'],
            $data['product_price'],
            $statusToSave,
            $data['description'],
            $data['discount_price'],
            $data['category_id'],
            $now,
            $productId,
            $vendorId
        );
        $stmt->execute() ? null : $all_query_ok = false;
        //var_dump($data['attributes']);
        //exit();
        // Update attributes
        if (!empty($data['attributes']) && is_array($data['attributes'])) {
            $this->db->query("DELETE FROM tbl_product_attribute_values WHERE product_id = " . (int) $productId . " 
      AND vendor_id = " . (int) $vendorId) ? null : $all_query_ok = false;

            $stmtAttr = $this->db->prepare("
           INSERT INTO tbl_product_attribute_values (product_id, vendor_id, attribute_id, value, quantity)
    VALUES (?, ?, ?, ?, ?)
        ");
            foreach ($data['attributes'] as $attr) {
                $stmtAttr->bind_param(
                    "iiisd",
                    $productId,
                    $vendorId,
                    $attr['attribute_id'],
                    $attr['value'],
                    $attr['quantity']
                );
                $stmtAttr->execute() ? null : $all_query_ok = false;
            }
        }
        // var_dump($data['specifications']);
        if (!empty($data['specifications'])) {
            // decode JSON string into array
            $specifications = json_decode($data['specifications'], true);

            if (json_last_error() !== JSON_ERROR_NONE) {
                return ['error' => false, 'message' => 'Invalid specifications JSON'];
            }

            // Delete old specs
            $this->db->query("DELETE FROM tbl_product_specifications WHERE product_id = " . (int) $productId . " 
      AND vendor_id = " . (int) $vendorId) ? null : $all_query_ok = false;

            // Insert new specs
            $stmtSpec = $this->db->prepare("
        INSERT INTO tbl_product_specifications (product_id,vendor_id, name, value)
        VALUES (?,?, ?, ?)
    ");

            foreach ($specifications as $spec) {
                $stmtSpec->bind_param(
                    "iiss",
                    $productId,
                    $vendorId,
                    $spec['name'],
                    $spec['value']
                );
                $stmtSpec->execute() ? null : $all_query_ok = false;
            }
        }

        // Update specifications
        //     if (!empty($data['specifications']) && is_array($data['specifications'])) {
        //         $this->db->query("DELETE FROM tbl_product_specifications WHERE product_id = " . (int) $productId . " 
        //   AND vendor_id = " . (int) $vendorId) ? null : $all_query_ok = false;

        //         $stmtSpec = $this->db->prepare("
        //         INSERT INTO tbl_product_specifications (product_id,vendor_id, name, value)
        //         VALUES (?,?, ?, ?)
        //     ");
        //         foreach ($data['specifications'] as $spec) {
        //             $stmtSpec->bind_param(
        //                 "iiss",
        //                 $productId,
        //                 $vendorId,

        //                 $spec['name'],
        //                 $spec['value']
        //             );
        //             $stmtSpec->execute() ? null : $all_query_ok = false;
        //         }
        //     }

        // Commit or rollback
        $all_query_ok ? $this->db->commit() : $this->db->rollback();
        $this->db->autocommit(TRUE);

        return $all_query_ok
            ? ['success' => true, 'message' => 'Product updated successfully']
            : ['success' => false, 'message' => 'Failed to update product'];
    }



    public function updateCategories($data)
    {
        if (empty($data['categories'])) {
            return ['error' => "false", 'message' => 'No categories received'];
        }

        $categories = json_decode($data['categories'], true);
        if (!is_array($categories)) {
            return ['error' => "false", 'message' => 'Invalid categories format'];
        }

        $all_query_ok = true;
        $this->db->autocommit(FALSE);

        // // ⚡ Delete ALL categories
        // $this->db->query("DELETE FROM tbl_product_categories") ? null : $all_query_ok = false;
        if (!$this->db->query("DELETE FROM tbl_product_categories")) {
            return ['error' => false, 'message' => "Delete failed: " . $this->db->error];
        }

        // ⚡ Insert new ones
        if (!empty($categories)) {
            $stmt = $this->db->prepare("
            INSERT INTO tbl_product_categories (name, description)
            VALUES (?, ?)
        ");
            if (!$stmt) {
                return ['error' => false, 'message' => "Prepare failed: " . $this->db->error];
            }
            foreach ($categories as $cat) {
                $name = $cat['name'] ?? '';
                $desc = $cat['description'] ?? '';

                if (trim($name) === '') {
                    continue; // skip blank names
                }
                if (!$stmt->bind_param("ss", $name, $desc)) {
                    return ['error' => false, 'message' => "Bind failed: " . $stmt->error];
                }
                if (!$stmt->execute()) {
                    return ['error' => false, 'message' => "Execute failed: " . $stmt->error];
                }
                // $stmt->bind_param("ss", $name, $desc);
                // $stmt->execute() ? null : $all_query_ok = false;
            }
        }

        $this->db->commit();
        $this->db->autocommit(TRUE);

        return ['success' => true, 'message' => 'Categories updated successfully'];
    }

    public function saveDescription($rawInput)
    {
        // Purify user input
        $clean_html = $this->purifier->purify($rawInput);


        return $clean_html;
    }

    public function insertVendorProduct($vendorId, $vendor_type_id, $data)
    {
        // Validate vendor ID
        $vendorId = filter_var($vendorId, FILTER_VALIDATE_INT);
        if ($vendorId === false) {
            return ['error' => true, 'message' => 'Invalid vendor ID'];
        }

        // Required fields
        $mandatoryFields = ['action', 'product_name', 'stock_quantity', 'product_price'];
        foreach ($mandatoryFields as $field) {
            if (!isset($data[$field]) || $data[$field] === '') {
                return ['error' => true, 'message' => "Missing required field: {$field}"];
            }
        }

        // Validate action (only pending or archived allowed)
        $allowedActions = ['pending', 'archived'];
        if (!in_array($data['action'], $allowedActions, true)) {
            return ['error' => true, 'message' => 'Invalid action'];
        }

        // Validate numeric fields
        if (!is_numeric($data['stock_quantity']) || (int) $data['stock_quantity'] < 0) {
            return ['error' => true, 'message' => 'Invalid stock quantity'];
        }
        if (!is_numeric($data['product_price']) || (float) $data['product_price'] < 0) {
            return ['error' => true, 'message' => 'Invalid product price'];
        }

        // Set defaults for optional fields
        $data['discount_price'] = isset($data['discount_price']) ? (float) $data['discount_price'] : 0;
        $rawDescription = $data['description'] ?? '';
        $data['description'] = $this->saveDescription($rawDescription);

        //        $data['description'] = $data['description'] ?? '';
        $data['category_id'] = isset($data['category_id']) ? (int) $data['category_id'] : 1; // default category id = 1

        $all_query_ok = true;
        $this->db->autocommit(FALSE);
        $now = date('Y-m-d H:i:s'); // current timestamp
        $sku = $vendorId . "-" . $data['category_id'] . "-" . strtoupper(substr($data['product_name'], 0, 3)) . "-" . time();
        // Insert main product
        $stmt = $this->db->prepare("
        INSERT INTO tbl_products 
            (vendor_id,vendor_type_id,  sku, name, stock_quantity,stock_reminder, price, status, description, discount_price, category_id, updated_at)
        VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)
    ");
        $stmt->bind_param(
            "iissiidssdis",
            $vendorId,
            $vendor_type_id,
            $sku,
            $data['product_name'],
            $data['stock_quantity'],
            $data['stock_reminder'],
            $data['product_price'],
            $data['action'],
            $data['description'],
            $data['discount_price'],
            $data['category_id'],
            $now
        );
        $stmt->execute() ? null : $all_query_ok = false;

        // Get the inserted product ID
        $productId = $stmt->insert_id;
        $attributes = [];
        // Process raw POST data into structured $data['attributes']
        $attributes = [];
        if (!empty($_POST['attribute_name']) && is_array($_POST['attribute_name'])) {
            foreach ($_POST['attribute_name'] as $i => $name) {
                if (!isset($name) || $name === '')
                    continue; // skip empty attribute names

                $value = $_POST['attribute_value'][$i] ?? '';
                $quantity = $_POST['attribute_quantity'][$i] ?? '';

                // Skip if value is empty or quantity is not numeric/non-negative
                if ($value === '' || !is_numeric($quantity) || (float) $quantity < 0)
                    continue;

                // Group by attribute name
                $attributes[$name][] = [
                    'value' => $value,
                    'quantity' => (float) $quantity,
                    'attribute_id' => '' // will be set after insertion
                ];
            }
        }

        // Insert attributes into database
        if (!empty($attributes)) {
            foreach ($attributes as $attrName => $valuesArray) {
                // 1️⃣ Insert attribute name into tbl_product_attributes
                $stmtAttrName = $this->db->prepare("
            INSERT INTO tbl_product_attributes (product_id, name)
            VALUES (?, ?)
        ");
                $stmtAttrName->bind_param(
                    "is",
                    $productId,
                    $attrName
                );
                $stmtAttrName->execute() ? null : $all_query_ok = false;

                // Get the auto-generated attribute_id
                $attributeId = $stmtAttrName->insert_id;

                // 2️⃣ Insert all values for this attribute
                $stmtAttrValue = $this->db->prepare("
            INSERT INTO tbl_product_attribute_values (product_id, vendor_id, attribute_id, value, quantity)
            VALUES (?, ?, ?, ?, ?)
        ");
                foreach ($valuesArray as $attr) {
                    $stmtAttrValue->bind_param(
                        "iiisd",
                        $productId,
                        $vendorId,
                        $attributeId,
                        $attr['value'],
                        $attr['quantity']
                    );
                    $stmtAttrValue->execute() ? null : $all_query_ok = false;
                }
            }
        }

        // Process specifications from POST data
        if (!empty($_POST['specifications']['name']) && is_array($_POST['specifications']['name'])) {
            $stmtSpec = $this->db->prepare("
        INSERT INTO tbl_product_specifications (product_id, vendor_id, name, value)
        VALUES (?, ?, ?, ?)
    ");

            foreach ($_POST['specifications']['name'] as $i => $specName) {
                $specName = $specName ?? '';
                $specValue = $_POST['specifications']['value'][$i] ?? '';

                // Skip if either name or value is empty
                if ($specName === '' || $specValue === '')
                    continue;

                $stmtSpec->bind_param(
                    "iiss",
                    $productId,
                    $vendorId,
                    $specName,
                    $specValue
                );
                $stmtSpec->execute() ? null : $all_query_ok = false;
            }
        }


        // Commit or rollback
        $all_query_ok ? $this->db->commit() : $this->db->rollback();
        $this->db->autocommit(TRUE);

        return $all_query_ok
            ? ['success' => true, 'message' => 'Product inserted successfully', 'product_id' => $productId]
            : ['error' => true, 'message' => 'Failed to insert product'];
    }


    //mockup email module setting with mailhog


    public function sendEmail($to, $from, $subject, $message, $cc = [], $bcc = [], $addon = [])
    {
        $emailCred = [
            "csc@fob.ng" => "",
            "onboarding@fob.ng" => "",
            "newsales@fob.ng" => "",
            "accounts@fob.ng" => "",
            "reminder@fob.com.ng" => "",
        ];

        if ($to <> "" && $subject <> "" && $message <> ""):
            $mail = new PHPMailer;
            $mail->isSMTP();


            // 🧩 LOCAL: Use MailHog
            $mail->Host = 'localhost';
            $mail->Port = 1025;
            $mail->SMTPAuth = false;
            $mail->SMTPSecure = false;


            $mail->setFrom($from, 'FiberOne');
            $mail->addAddress($to);
            $mail->addReplyTo($from, 'FiberOne');
            $mail->isHTML(true);

            if (count($cc) > 0) {
                foreach ($cc as $key => $value) {
                    $mail->addCC($value, $key);
                }
            }

            if (count($bcc) > 0) {
                foreach ($bcc as $key => $value) {
                    $mail->addBCC($value, $key);
                }
            }

            $mail->Subject = $subject;
            $mail->Body = nl2br($message);
            $mail->AltBody = nl2br($message);

            $mail->SMTPOptions = [
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                ]
            ];

            return $mail->send();
        else:
            return false;
        endif;
    }




    ///end mockup
    public function salesByLocation($startDate, $endDate, $location = '')
    {
        $locations = $this->getLocations();
        $addon = "";
        if ($location <> "" && !in_array($location, $locations)):
            return 0;
        elseif (in_array($location, $locations)):
            $addon = " AND PLAN_LOCATION='$location'";
        endif;
        $stat = $response = [];

        $qry = "SELECT PLAN, PLAN_LOCATION, PLAN_DESC, SUM(NTRANS) AS 'TOTAL_TRANS', SUM(SALES) AS 'TOTAL_SALES', SUM(CASE
                    WHEN PLAN_LOCATION = 'Lagos' THEN NTRANS ELSE 0 END
                  ) AS 'TotalTrans_Lagos', SUM(CASE
                    WHEN PLAN_LOCATION = 'Lagos' THEN SALES ELSE 0 END
                  ) AS 'Sales_Lagos', SUM(CASE
                    WHEN PLAN_LOCATION = 'Abuja' THEN NTRANS ELSE 0 END
                  ) AS 'TotalTrans_Abuja', SUM(CASE
                    WHEN PLAN_LOCATION = 'Abuja' THEN SALES ELSE 0 END
                  ) AS 'Sales_Abuja', SUM(CASE
                    WHEN PLAN_LOCATION = 'Port Harcourt' THEN NTRANS ELSE 0 END
                  ) AS 'TotalTrans_PH', SUM(CASE
                    WHEN PLAN_LOCATION = 'Port Harcourt' THEN SALES ELSE 0 END
                  ) AS 'Sales_PH', SUM(CASE
                    WHEN PLAN_LOCATION = 'Ilorin' THEN NTRANS ELSE 0 END
                  ) AS 'TotalTrans_Ilorin', SUM(CASE
                    WHEN PLAN_LOCATION = 'Ilorin' THEN SALES ELSE 0 END
                  ) AS 'Sales_Ilorin'
                  FROM
		(SELECT tp.PLAN_LOCATION, tp.PLAN AS 'PLAN', tp.DESCRIPTION AS 'PLAN_DESC', 
                        COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES'
                FROM `tbl_tranx` tx
                LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
                LEFT JOIN tbl_plans tp ON tx.PLAN_ID=tp.PLAN_ID
                WHERE STATUS_CODE = '00' AND DATE(PAY_DATE) BETWEEN ? AND ?
                $addon
                GROUP BY tp.PLAN_LOCATION, tp.PLAN) AS tmp
								
            GROUP BY PLAN
            ORDER BY PLAN_LOCATION, PLAN";
        $some_sth = $this->db->select($qry, "ss", $startDate, $endDate);
        while ($row = $some_sth->fetch_object()):
            $response[] = [
                "PLAN" => $row->PLAN,
                "PLAN_LOCATION" => $row->PLAN_LOCATION,
                "PLAN_DESC" => $row->PLAN_DESC,
                "TOTAL_TRANS" => $row->TOTAL_TRANS,
                "TOTAL_SALES" => $row->TOTAL_SALES,
                "TotalTrans_Lagos" => $row->TotalTrans_Lagos,
                "Sales_Lagos" => $row->Sales_Lagos,
                "TotalTrans_Abuja" => $row->TotalTrans_Abuja,
                "Sales_Abuja" => $row->Sales_Abuja,
                "TotalTrans_PH" => $row->TotalTrans_PH,
                "Sales_PH" => $row->Sales_PH,
                "TotalTrans_Ilorin" => $row->TotalTrans_Ilorin,
                "Sales_Ilorin" => $row->Sales_Ilorin
            ];
        endwhile;

        return $response;
    }
}
