<?php

/*************************************************************************
 * Password_Generator.php                                          *
 *************************************************************************
 *                                                                       *
 * (c) 2008-2011 Wolf Software Limited <support@wolf-software.com>       *
 * All Rights Reserved.                                                  *
 *                                                                       *
 * This program is free software: you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation, either version 3 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 *                                                                       *
 *************************************************************************/

class Password_Generator
{
  private $class_name             = "Password Generator";
  private $class_version          = "1.0.0";
  private $class_author           = "Wolf Software";
  private $class_source           = "http://www.wolf-software.com/php-classes/keygrid_class";

  public function class_name()
    {
      return $this->class_name;
    }

  public function class_version()
    {
      return $this->class_version;
    }

  public function class_author()
    {
      return $this->class_author;
    }

  public function class_source()
    {
      return $this->class_source;
    }

  public function __construct($seed = null)
    {
    }

  public function generate($minlength = 8, $maxlength = 18, $uselower = true, $useupper = false, $usenumbers = false, $usespecial = false)
    {
      $password = '';
      $charset = '';

      if ($uselower)
        {
          $charset .= "abcdefghijkmnopqrstuvwxyz";
          //$charset .= "abcdefghijklmnopqrstuvwxyz";
        }
      if ($useupper)
        {
          $charset .= "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        }
      if ($usenumbers)
        {
          $charset .= "123456789";
          //$charset .= "0123456789";
        }
      if ($usespecial)
        {
          //$charset .= "~!@#$%^&*()_+`-={}|\\]?[\":;'><,./ ";
          $charset .= "!@#$%&+=?";
        }
      if ($charset)
        {
          mt_srand((double)microtime() * 1000000);

          if ($minlength > $maxlength)
            $length = mt_rand($maxlength, $minlength);
          else
            $length = mt_rand($minlength, $maxlength);

          for ($i = 0; $i < $length; $i++)
            $password .= $charset[(mt_rand(0, (strlen($charset) - 1)))];
        }
      return $password;
    }
}

?>

