<?PHP

/**
 * Description of PelPay
 *
 * @author OPMat
 */
class PelPay extends Logger {
    //put your code here
    private $db;
    private $clientId = "fib0000039";
    private $clientSecret = "bf7aed02-7b70-475c-8fc7-63f197c1dd86";
    private $integrationKey = "7a978c2b-f05c-443e-b133-a84c58edea32";
    private $accessToken;
    
    const API_BASE_URL = "https://api.pelpay.africa/";
    const AUTH_URL = "api/Account/login";
    const INIT_PAYMENT_URL = "Payment/advice";
    const VALIDATE_PAY_BY_ADVICE_REF_URL = "api/Transaction/byadvicereference/";
    const VALIDATE_PAY_BY_PAYMENT_REF_URL = "api/Transaction/bypaymentreference/";

    
    
    public function __construct($dbconnection) {
        $this->db = $dbconnection;

        $this->sid = session_id();
        parent::__construct($dbconnection, $_SESSION[$this->sid."username"]);
    } 
    
    
    public function auth() {
        $param = ["clientId"=>$this->clientId, "clientSecret"=>$this->clientSecret];
        
        $ret = $this->__curlURL($this::API_BASE_URL . $this::AUTH_URL, 1, 
                        json_encode($param), ['Content-Type: application/json']);
        $retArr = json_decode($ret, TRUE);
        
        $this->accessToken = $retArr['access_token'];
    }
    
    
    public function createPayAdvice($param) {
        $ret = $this->__curlURL($this::API_BASE_URL . $this::INIT_PAYMENT_URL, 1, 
                        json_encode($param), ['Authorization: Bearer ' . $this->accessToken, 
                            'Content-Type: application/json']);
        $retArr = json_decode($ret, TRUE);
        
        return $retArr;
    }
    
    
    public function validateByPayAdvice($adviceRef) {
        $ret = $this->__curlURL($this::API_BASE_URL . $this::VALIDATE_PAY_BY_ADVICE_REF_URL . $adviceRef, 0, 
                        "", ['Authorization: Bearer ' . $this->accessToken, 
                            'Content-Type: application/json']);
        $retArr = json_decode($ret, TRUE);
        
        return $retArr;
    }
    
    
    public function validateByPayRef($payRef) {
        $ret = $this->__curlURL($this::API_BASE_URL . $this::VALIDATE_PAY_BY_PAYMENT_REF_URL . $payRef, 0, 
                        "", ['Authorization: Bearer ' . $this->accessToken, 
                            'Content-Type: application/json']);
        $retArr = json_decode($ret, TRUE);
        
        return $retArr;
    }
    
    
    private function __curlURL($strURL, $isPost=0, $postdata="", $header=[]) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE); // Return data inplace of echoing on screen
        curl_setopt($ch, CURLOPT_HTTPHEADER, array_merge(["X-Requested-With: XMLHttpRequest"],$header));
        curl_setopt($ch, CURLOPT_URL, $strURL);
        
        if ($isPost):
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
        endif;
        
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE); // Skip SSL Verification
        //curl_setopt($ch, CURLOPT_SSLVERSION,3);
        //curl_setopt( $ch, CURLOPT_SSLVERSION, 'CURL_SSLVERSION_SSLv3' );
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1);
        $rsData = curl_exec($ch); //print_r($rsData); echo "Dahs"; //return;
        //echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);

        return $rsData;
    }
    
    
    public function getAccessToken() {
        return $this->accessToken;
    }    
    
    public function getIntegrationKey() {
        return $this->integrationKey;
    }
    
    
}