<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

if (file_exists("includes/common_functions.php"))
    require_once "includes/common_functions.php";
elseif (file_exists("../includes/common_functions.php"))
    require_once "../includes/common_functions.php";
elseif (file_exists("../../includes/common_functions.php"))
    require_once "../../includes/common_functions.php";

if (file_exists("classes/Password_Generator.php"))
    require_once "classes/Password_Generator.php";
elseif (file_exists("../classes/Password_Generator.php"))
    require_once "../classes/Password_Generator.php";
elseif (file_exists("../../classes/Password_Generator.php"))
    require_once "../../classes/Password_Generator.php";

if (file_exists("classes/UserProfile.php"))
    require_once "classes/UserProfile.php";
elseif (file_exists("../classes/UserProfile.php"))
    require_once "../classes/UserProfile.php";
elseif (file_exists("../../classes/UserProfile.php"))
    require_once "../../classes/UserProfile.php";

if (file_exists("classes/BulkSMS.php"))
    require_once "classes/BulkSMS.php";
elseif (file_exists("../classes/BulkSMS.php"))
    require_once "../classes/BulkSMS.php";
elseif (file_exists("../../classes/BulkSMS.php"))
    require_once "../../classes/BulkSMS.php";

/**
 * Description of Referral
 *
 * @author OPMat
 */
class Referral extends Logger {
    //put your code here
    private $db;
    
    public $totalRecords;
    public $totalRecordwithFilter;
    
    /*** URL SHORTENER **/
    /**
     * Default characters to use for shortening.
     *
     * @var string
     */
    private $chars = 'PAC3mfIEHY0dcb87TrsZazxgF1lVK4wJ2WeBpL9vNUMGktROijnSoq5DX6yQhu';

    /**
     * Salt for id encoding.
     *
     * @var string
     */
    private $salt = 'EHY0dcb87TrsZTd';

    /**
     * Length of number padding.
     */
    private $padding = 3;

    /**
     * Hostname
     */
    public $hostname = 'https://eservice.fob.ng/affiliate';
    

    public function __construct($dbconnection) {
        $this->db = $dbconnection;

        $this->sid = session_id();
        parent::__construct($dbconnection, $_SESSION[$this->sid."username"]);
    } 
        
    public function insert2Table($fields, $value, $table) {
        
        $qry = "INSERT INTO $table ($fields)
                    VALUES ($value)";
        $in_id = $this->db->insert($qry);
        if ($in_id) :
            return $in_id;
        else:
            return 0;
        endif;
         
    }   
    
    public function getReferralStats($username) {
        $strsql = "SELECT COUNT(USERNAME) AS 'REFERRALS', 
(SELECT COUNT(USERNAME) FROM tbl_referrals WHERE USERNAME=trf.USERNAME AND ACCEPTED=1 ) AS 'ACCEPTED', 
COALESCE((SELECT (COUNT(ASSIGNED_USERNAME)) FROM tbl_referral_details WHERE REFERRER_USERNAME=trf.USERNAME AND ASSIGNED_USERNAME IS NOT NULL ), 0) AS 'FULFILLED', 
COALESCE((SELECT (COUNT(ASSIGNED_USERNAME)) FROM tbl_referral_details WHERE REFERRER_USERNAME=trf.USERNAME AND ASSIGNED_USERNAME IS NOT NULL AND REWARDED=0 ),0) AS 'PENDING',
(SELECT COUNT(REWARDID) FROM tbl_referral_reward_log WHERE REFERRER=trf.USERNAME) AS 'REWARDED'
FROM tbl_referrals trf
WHERE USERNAME LIKE ?";
        $some_sth = $this->db->select($strsql, "s", "$username");
        $row = $some_sth->fetch_object();
        
        return ["REFERRALS"=>$row->REFERRALS, "ACCEPTED"=>$row->ACCEPTED, 
                "FULFILLED"=>$row->FULFILLED, "PENDING"=>$row->PENDING,
            "REWARDED"=>$row->REWARDED];
    }
    
    
    public function userHasFilledHowQuestion($username) {
        $strsql ="SELECT USERNAME, `MEDIUM` FROM tbl_ref_code WHERE USERNAME LIKE ? AND `MEDIUM` <> ''";
        $some_sth = $this->db->select($strsql, "s", "$username");
        
        return $some_sth->num_rows()? true : false;
    }
    
    public function setInfoMedium($username, $medium) {
        $upd = "UPDATE tbl_ref_code SET `MEDIUM`=? WHERE USERNAME LIKE ?";
        return $this->db->execute_query($upd, "ss", $medium, $username)? 'success' : 'error';
    }
    
    
    public function userHasRefCode($username) {
        $strsql ="SELECT REFCODE FROM tbl_ref_code WHERE USERNAME LIKE ?";
        $some_sth = $this->db->select($strsql, "s", "$username");
        
        return $some_sth->num_rows();
    }
    
    public function refCodeExist($refCode) {
        $strsql ="SELECT USERNAME FROM tbl_ref_code WHERE REFCODE LIKE ?";
        $some_sth = $this->db->select($strsql, "s", "$refCode");
        
        return $some_sth->num_rows();
    }
    
    public function getUserByRefCode($refCode) {
        $strsql ="SELECT USERNAME FROM tbl_ref_code WHERE REFCODE LIKE ?";
        $some_sth = $this->db->select($strsql, "s", "$refCode");
        $row = $some_sth->fetch_object();
        if ($some_sth->num_rows() == 1) :
            return $row->USERNAME;
        else:
            return 0;
        endif;
    }
    
    public function getUserRefCode($username) {
        $strsql ="SELECT REFCODE FROM tbl_ref_code WHERE USERNAME LIKE ?";
        $some_sth = $this->db->select($strsql, "s", "$username");
        $row = $some_sth->fetch_object();
        if ($some_sth->num_rows() == 1) :
            return $row->REFCODE;
        else:
            return 0;
        endif;
    }
    
    public function getUserRefCodeInfo($id) {
        $strsql ="SELECT REFCODE, USERNAME, DATE_CREATED FROM tbl_ref_code WHERE REFCODE_ID = ?";
        $some_sth = $this->db->select($strsql, "i", "$id");
        $row = $some_sth->fetch_object();
        if ($some_sth->num_rows() == 1) :
            return ["REFCODE"=>$row->REFCODE, "USERNAME"=>$row->USERNAME, "DATE_CREATED"=>$row->DATE_CREATED];
        else:
            return 0;
        endif;
    }
    
    public function getUserRefCodeId($username, $refCode) {
        $strsql ="SELECT REFCODE_ID FROM tbl_ref_code WHERE REFCODE LIKE ? AND USERNAME LIKE ?";
        $some_sth = $this->db->select($strsql, "ss", "$refCode", $username);
        $row = $some_sth->fetch_object();
        if ($some_sth->num_rows() == 1) :
            return $row->REFCODE_ID;
        else:
            return 0;
        endif;
    }
    
    public function isAlreadyInvited($email) {
        $strsql ="SELECT USERNAME FROM tbl_referrals WHERE REFERRAL_EMAIL LIKE ?";
        $some_sth = $this->db->select($strsql, "s", "$email");
        
        return $some_sth->num_rows();
    }
    
    public function hasAlreadyFilled($email) {
        $strsql ="SELECT REFID FROM tbl_referral_details WHERE EMAIL LIKE ?";
        $some_sth = $this->db->select($strsql, "s", "$email");
        
        return $some_sth->num_rows();
    }
    
    public function getRefIdByEmail($email) {
        $strsql ="SELECT REFID FROM tbl_referral_details WHERE EMAIL LIKE ?";
        $some_sth = $this->db->select($strsql, "s", "$email");
        $row = $some_sth->fetch_object();
        if ($some_sth->num_rows() == 1) :
            return $row->REFID;
        else:
            return 0;
        endif;
    }
    
    public function referralEmailIsCorrect($username, $refemail) {
        $strsql ="SELECT USERNAME FROM tbl_referrals WHERE REFERRAL_EMAIL LIKE ? AND USERNAME LIKE ?";
        $some_sth = $this->db->select($strsql, "ss", $refemail, $username);
        
        return $some_sth->num_rows();
    }
    
    public function genRefCode($username) {
        if ($this->userHasRefCode($username)) {
            return $this->getUserRefCode($username);
        }
        
        //generate
        $pgen = new Password_Generator();
        while (true):
            $code = $pgen->generate(6, 6, true, false, true, false);
            if (!$this->refCodeExist($code)):
                //save and return
                $qry = "INSERT INTO tbl_ref_code (USERNAME, REFCODE, DATE_CREATED) 
                 VALUES(?, ?, NOW())";
                $saved = $this->db->insert($qry, "ss", $username, $code);
                if ($saved > 0):
                    return $code;
                endif;
            endif;
        endwhile;
    }
    
    public function saveReferralMsg($referrer, $referral_name, $referral_email, $referral_phone, $msglink, $salesperson=0) {
        if ($this->isAlreadyInvited($referral_email)):
            return json_encode(["STATUS"=>0, "MSG"=> "Someone with the email ($referral_email) has already been referred"]);
        endif;
        $qry = "INSERT INTO tbl_referrals (USERNAME, REFERRAL_NAME, REFERRAL_EMAIL, REFERRAL_PHONE, MSGLINK, DATE_SENT, SALESPERSON) 
                 VALUES(?, ?, ?, ?, ?, NOW(), ?)";
        $saved = $this->db->insert($qry, "sssssi", $referrer, $referral_name, $referral_email, $referral_phone, $msglink, $salesperson);
        if ($saved > 0):
            return json_encode(["STATUS"=>1, "MSG"=> "Referral Saved", "REFID"=>$saved]);
        else:
            return json_encode(["STATUS"=>0, "MSG"=> "Unable to save at the moment"]);
        endif;
    }
    
    public function getReferralInfo($username, $refemail) {
        $strsql ="SELECT SENTID, USERNAME, REFERRAL_NAME, REFERRAL_EMAIL, REFERRAL_PHONE, MSGLINK, DATE_SENT, SALESPERSON 
                 FROM tbl_referrals WHERE REFERRAL_EMAIL LIKE ? AND USERNAME LIKE ?";
        $some_sth = $this->db->select($strsql, "ss", $refemail, $username);
        
        return $some_sth->fetch_assoc();
    }
    
    public function getReferralInvites($user='', $searchval='', $sortby='', $sortorder='desc', $startrow=0, 
            $len=50, $expstart='', $expend='', $assignedAdmin=0) {
        
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $adw = " WHERE tr.USERNAME LIKE '$user'";
        else:
            $adw = " WHERE 1";
        endif;
        
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (tr.USERNAME LIKE '%$searchval%' OR REFERRAL_NAME LIKE '%$searchval%' OR REFERRAL_EMAIL LIKE '%$searchval%'  ) ";
        endif;
        if ($expstart <> "") :
            $expstart = mysqli_real_escape_string($this->db, $expstart);
            $ad .= " AND ( DATE(DATE_SENT) >= '$expstart' ) ";
        endif;
        if ($expend <> "") :
            $expend = mysqli_real_escape_string($this->db, $expend);
            $ad .= " AND ( DATE(DATE_SENT) <= '$expend' ) ";
        endif;
        if ($assignedAdmin > 0) :
            $assignedAdmin = mysqli_real_escape_string($this->db, $assignedAdmin);
            $ad .= " AND ( ASSIGNEDTO = '$assignedAdmin' ) ";
        endif;
        
        $mqry1 = "SELECT COUNT(REFERRAL_EMAIL) AS 'TOTAL' FROM tbl_referrals tr $adw ";
        $some_st = $this->db->select($mqry1);
        $rec = $some_st->fetch_object();
        $this->totalRecords = $rec->TOTAL; 
        if ($ad==""):
            $this->totalRecordwithFilter = $this->totalRecords;
    	else:
            $fqry = "$mqry1 $ad";  
            $some_s = $this->db->select($fqry);
            $rec = $some_s->fetch_object();
            $this->totalRecordwithFilter = $rec->TOTAL;
    	endif;
        
        $strsql ="SELECT SENTID, tr.USERNAME, REFERRAL_NAME, REFERRAL_EMAIL, REFERRAL_PHONE, MSGLINK, DATE_SENT, ACCEPTED, DATE_ACCEPTED,
                    (SELECT COUNT(EMAIL) FROM tbl_referral_details WHERE REFERRER_USERNAME=tr.USERNAME AND EMAIL=tr.REFERRAL_EMAIL AND ASSIGNED_USERNAME IS NOT NULL ) AS 'CREATED',
                    ASSIGNED, tad.FULLNAME AS 'ASSIGNEDTO', tadd.FULLNAME AS 'ASSIGNEDBY', DATE_ASSIGNED, SALESPERSON
                    FROM tbl_referrals tr 
                    LEFT JOIN tbl_admins tad ON tr.ASSIGNEDTO=tad.AID
                    LEFT JOIN tbl_admins tadd ON tr.ASSIGNEDBY=tadd.AID
                    $adw $ad"; 
        
        $limit = ($len == -1)? "" : "LIMIT $startrow, $len";
        
        $msort = ($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY DATE_SENT DESC";
        $qry = "$strsql $msort $limit";
        $some_sth = $this->db->select($qry);
        $sn = 0;
        while ( $row = $some_sth->fetch_object() ) {
//            $ret[] = $row;
            $ret[] = [
                "SN"=>++$sn, "USERNAME"=>$row->USERNAME, "REFERRAL_NAME"=>$row->REFERRAL_NAME, "REFERRAL_PHONE"=>$row->REFERRAL_PHONE, 
                "REFERRAL_EMAIL"=>$row->REFERRAL_EMAIL, "MSGLINK"=>$row->MSGLINK, 'CREATED'=>$row->CREATED, 'ASSIGNED'=>$row->ASSIGNED,
                "DATE_SENT"=>$row->DATE_SENT, "ACCEPTED"=>$row->ACCEPTED, "DATE_ACCEPTED"=>$row->DATE_ACCEPTED, "SENTID"=>$row->SENTID, 
                "ASSIGNEDTO"=>$row->ASSIGNEDTO, "ASSIGNEDBY"=>$row->ASSIGNEDBY, "DATE_ASSIGNED"=>$row->DATE_ASSIGNED, "SALESPERSON"=>$row->SALESPERSON
            ];
        }
        
        return $ret;
    }
    
    public function assignReferral2Admin($referralID, $assignee, $assigner) {
        $upd = "UPDATE tbl_referrals SET ASSIGNED=1, DATE_ASSIGNED=NOW(), ASSIGNEDTO=?, ASSIGNEDBY=? WHERE SENTID = ?";
        $rett = $this->db->execute_query($upd, "iii", $assignee, $assigner, $referralID);
            
        if ($rett) :
            $ad = new UserProfile($this->db);
            $adminInfo = $ad->loadAdminRec('', 1);
            $sendToEmail = '';
            foreach($adminInfo as $admin) :
                if ($admin['UID'] == $assignee) {
                    $sendToEmail = $admin['EMAIL'];
                }
            endforeach;
            if ($sendToEmail !== ''){
               $raw_msg = $ad->getCannedMessage("REFERRAL_ASSIGNED"); 
               $ref = $this->getReferralInviteByID($referralID);
               $msg = sprintf($raw_msg, $ref['REFERRAL_NAME']);
               $ad->sendEmailAWS($sendToEmail, "infosystem@fob.ng", "Referral Account Assigned to you - ". date("d M, Y H:i:s"), $msg);
            }
            return "Success: Update Completed!";
        else:
            return "Error: Update failed! Try Again.";
        endif;
    }
    
    public function getReferralInviteByID($sentid) {
        $strsql ="SELECT SENTID, USERNAME, REFERRAL_NAME, REFERRAL_EMAIL, REFERRAL_PHONE, MSGLINK, DATE_SENT, ACCEPTED, DATE_ACCEPTED "
                . "FROM tbl_referrals WHERE SENTID=?";
        $some_sth = $this->db->select($strsql, "i", $sentid);
        $row = $some_sth->fetch_object();
        if ($some_sth->num_rows() == 1) :
            return ["USERNAME"=>$row->USERNAME, "REFERRAL_NAME"=>$row->REFERRAL_NAME, "REFERRAL_PHONE"=>$row->REFERRAL_PHONE,
                "REFERRAL_EMAIL"=>$row->REFERRAL_EMAIL, "MSGLINK"=>$row->MSGLINK, 
                "DATE_SENT"=>$row->DATE_SENT, "ACCEPTED"=>$row->ACCEPTED, "DATE_ACCEPTED"=>$row->DATE_ACCEPTED, "SENTID"=>$row->SENTID];
        else:
            return 0;
        endif;
    }
    
    public function referralAccepted($username, $referral_email) {
        $upd = "UPDATE tbl_referrals SET ACCEPTED=1, DATE_ACCEPTED=NOW() WHERE USERNAME LIKE ? AND REFERRAL_EMAIL LIKE ?";
        $rett = $this->db->execute_query($upd, "ss", $username, $referral_email);
            
        if ($rett) :
            return "Success: Update Completed!";
        else:
            return "Error: Update failed! Try Again.";
        endif;
    }
    
    public function emailAlreadyExist($email) {
        $strsql = "SELECT EMAIL AS email FROM tbl_erpdata WHERE EMAIL LIKE ?
            UNION
            SELECT email FROM rm_users WHERE email LIKE ?";
        $some_sth = $this->db->select($strsql, "ss", $email, $email);
        if ($some_sth->num_rows() >= 1) :
            return 1;
        else:   
            return 0; 
        endif;
    }
    
    public function referralRegistration($fullname, $email, $refcode, $refuser, $addy='', $phone='', $plan='') {
        
        if ($this->emailAlreadyExist($email)):
            return json_encode(["STATUS"=>0, "MSG"=> "Error: This email ($email) is already on record"]);
        endif;
        
        if ($this->hasAlreadyFilled($email)):
            return json_encode(["STATUS"=>0, "MSG"=> "Error: Someone with the email ($email) has already filled the referral form"]);
        endif;
        if (!$this->referralEmailIsCorrect($refuser, $email) ) {
            return json_encode(["STATUS"=>0, "MSG"=> "Error: Kindly fill the form with the email address the invitation was sent"]);
        }
        $qry = "INSERT INTO tbl_referral_details (FULLNAME, ADDRESS, PHONE, 
                    EMAIL, REFERRAL_CODE, REFERRER_USERNAME, DATE_REGISTERED, PLAN) 
                 VALUES(?, ?, ?, ?, ?, ?, NOW(), ?)";
        $saved = $this->db->insert($qry, "sssssss", $fullname, $addy, $phone, $email, $refcode, $refuser, $plan);
        if ($saved > 0):
            $this->referralAccepted($refuser, $email);
            return json_encode(["STATUS"=>1, "MSG"=> "Success: Information Saved. We will get back to you soonest."]);
        else:
            return json_encode(["STATUS"=>0, "MSG"=> "Error: Unable to save at the moment. Please try again later."]);
        endif;
        
    }
    
    public function referralRegistration_bak($firstname, $lastname, $email, $refcode, 
            $refuser, $company='', $addy='', $city='', $state='', $phone='') {
        
        if ($this->hasAlreadyFilled($email)):
            return json_encode(["STATUS"=>0, "MSG"=> "Error: Someone with the email ($email) has already filled the referral form"]);
        endif;
        if (!$this->referralEmailIsCorrect($refuser, $email) ) {
            return json_encode(["STATUS"=>0, "MSG"=> "Error: Kindly fill the form with the email address the invitation was sent"]);
        }
        $qry = "INSERT INTO tbl_referral_details (FIRSTNAME, LASTNAME, COMPANY, ADDRESS, CITY, STATE, PHONE, 
                    EMAIL, REFERRAL_CODE, REFERRER_USERNAME, DATE_REGISTERED) 
                 VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
        $saved = $this->db->insert($qry, "ssssssssss", $firstname, $lastname, $company, $addy, $city, $state, $phone, $email, $refcode, $refuser);
        if ($saved > 0):
            $this->referralAccepted($refuser, $email);
            return json_encode(["STATUS"=>1, "MSG"=> "Success: Information Saved. We will get back to you soonest."]);
        else:
            return json_encode(["STATUS"=>0, "MSG"=> "Error: Unable to save at the moment. Please try again later."]);
        endif;
        
    }
    
    public function getReferralDetails($refid=0, $email='', $referrer='') {
        
        $ad = "";
        $ad = (is_numeric($refid) && ($refid > 0) )? " WHERE REFID = $refid" : "";
        
        if ($email <> "") :
            $email = mysqli_real_escape_string($this->db, $email);
            $ad = ($ad=="")? " WHERE trd.EMAIL LIKE '$email'" : $ad . " AND trd.EMAIL LIKE '$email'";
        endif;
        
        if ($referrer <> "") :
            $$referrer = mysqli_real_escape_string($this->db, $referrer);
            $ad = ($ad=="")? " WHERE REFERRER_USERNAME LIKE '$referrer'" : $ad . " AND REFERRER_USERNAME LIKE '$referrer'";
        endif;
        
        $strsql ="SELECT REFID, trd.FULLNAME, ADDRESS, PHONE, 
                    trd.EMAIL, REFERRAL_CODE, REFERRER_USERNAME, ASSIGNED_USERNAME, DATE_REGISTERED, 
                    DATE_ACC_CREATED, ACC_CREATEDBY, ta.FULLNAME FROM tbl_referral_details trd
                LEFT JOIN tbl_admins ta ON trd.ACC_CREATEDBY=ta.AID $ad";
        $some_sth = $this->db->select($strsql);
        $row = $some_sth->fetch_object();
        if ($some_sth->num_rows() == 1) :
            return $row;
        else:
            return 0;
        endif;
        
    }
    
    public function updateRefCreated($refid, $username, $adminID) {
        $init = $this->hasBeenInitiated($refid);
        if ($init != 0):
            return "Error: Account already initiated by $init.";
        endif;
        $upd = "UPDATE tbl_referral_details SET ASSIGNED_USERNAME=?, ACC_CREATEDBY=?, DATE_ACC_CREATED=NOW() WHERE REFID=?";
        $rett = $this->db->execute_query($upd, "sii", $username, $adminID, $refid);
            
        if ($rett) :
            return "Success: Update Completed!";
        else:
            return "Error: Update failed! Try Again.";
        endif;
    }    
    
    public function hasBeenInitiated($refid) {
        $strsql ="SELECT ta.FULLNAME FROM tbl_referral_details trd LEFT JOIN tbl_admins ta ON trd.ACC_CREATEDBY=ta.AID WHERE REFID = ?";
        $some_sth = $this->db->select($strsql, "i", $refid);
        
        if ($some_sth->num_rows()):
            $row = $some_sth->fetch_object();
            return $row->FULLNAME;
        else:
            return 1;
        endif;
    } 
    
    public function getRefID($refemail, $username) {
        $strsql ="SELECT REFID FROM tbl_referral_details WHERE EMAIL LIKE ? AND REFERRER_USERNAME LIKE ?";
        $some_sth = $this->db->select($strsql, "ss", $refemail, $username);
        $row = $some_sth->fetch_object();
        return $row->REFID;
    }
    
    public function getTelesalesStaff($teamType='All') {
        $team = '16, 21';
        if (strtolower($teamType) === 'telesales') { $team = '16'; }
        elseif (strtolower($teamType) === 'sales') { $team = '21'; }
        $strsql = "SELECT AID, USERNAME, FULLNAME FROM `tbl_admins`
                    WHERE ACCESS_LEVEL IN ($team)";
        $some_sth = $this->db->select($strsql);
        $ret = [];
        while ($row = $some_sth->fetch_object()):
            $ret[] = $row;
        endwhile;
        return $ret;
    }
    
    public function getUserPendingReferralReward($referrer, $limit=3) {
        
        $ad = "";
        $resp = [];
        
        if ($referrer <> "") :
            $$referrer = mysqli_real_escape_string($this->db, $referrer);
            $ad = " AND REFERRER_USERNAME LIKE '$referrer'";
        endif;
        
        $strsql ="SELECT REFID, trd.FULLNAME, ADDRESS, PHONE, 
                    trd.EMAIL, REFERRAL_CODE, REFERRER_USERNAME, ASSIGNED_USERNAME, DATE_REGISTERED, 
                    DATE_ACC_CREATED, ACC_CREATEDBY, ta.FULLNAME AS 'CREATOR' FROM tbl_referral_details trd
                LEFT JOIN tbl_admins ta ON trd.ACC_CREATEDBY=ta.AID
                WHERE 1 AND REWARDED=0 AND ASSIGNED_USERNAME IS NOT NULL $ad
                LIMIT $limit ";
        $some_sth = $this->db->select($strsql);
        
        if ($some_sth->num_rows() >= 1) :
            while ($row = $some_sth->fetch_assoc()):
                $resp[] = $row;
            endwhile;
            return $resp;
        else:
            return 0;
        endif;
        
    }
    
    public function getUsersQualifiedForReward($limit=3) {
        $ret = [];
        if (!is_int($limit)) { return []; }
        $strsql = "SELECT REFERRER_USERNAME, NREFERRALS
FROM (
SELECT REFERRER_USERNAME, COUNT(ASSIGNED_USERNAME)  AS NREFERRALS
FROM `tbl_referral_details` 
WHERE 1 AND ACC_CREATEDBY IS NOT NULL AND ASSIGNED_USERNAME IS NOT NULL AND REWARDED=0
GROUP BY REFERRER_USERNAME) AS reftable
WHERE NREFERRALS >= $limit";
        $some_sth = $this->db->select($strsql);
        while ($row = $some_sth->fetch_assoc()) :
            $ret[] = ["USERNAME"=>$row['REFERRER_USERNAME'], "NREFERRALS"=>$row['NREFERRALS']];
        endwhile;
        
        return $ret;
    }
    
    public function rewardReferrers($limit=3) {
        if (!is_int($limit)) { return 0; }
        $qualifiedUsers = $this->getUsersQualifiedForReward($limit);
        foreach ($qualifiedUsers as $user):
            $nloops = intdiv( $user['NREFERRALS'], $limit);
            for ($i=0; $i<$nloops; $i++) {
                //call reward
                $resp = $this->rewardThisUser($user["USERNAME"], $limit);
            }
        endforeach;
    }
    
    public function rewardThisUser($referrer, $limit) {
        $referrals = $this->getUserPendingReferralReward($referrer, $limit);
        $refIDs = array_column($referrals, "REFID");
        $refUsers = array_column($referrals, "ASSIGNED_USERNAME");
        $refNames = array_column($referrals, "FULLNAME");
        
        $ad = new UserProfile($this->db);
//        $userExpiration = $ad->getExpirationDate($referrer);
        $userRecords = $ad->loadClientRec($referrer, 1);
        $userRecord = $userRecords[$referrer];
        
        if (!$userRecord['ENABLED']) { return; }
        $plan = $ad->loadPlanFromName($userRecord['SERVICE']);
        
        $is_expd = isExpired($userRecord["EXPIRATION"]);
        $nu_expd = ($is_expd)? add_date(date("Y-m-d H:i:s"), 1*$plan['VALIDITY'] ) : add_date($userRecord['EXPIRATION'], 1*$plan['VALIDITY'] );
        
        $up = $down = $tot = $ntot = 0;
        $qry = "SELECT
                (SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ?) AS 'DOWN',
                (SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ?) AS 'UP',
                (SELECT comblimit FROM rm_users WHERE username = ?) AS 'COMB'";
        $some_sth = $this->db->select($qry, "sssss", $referrer, $referrer, $referrer, $referrer, $referrer);

        while ( $row = $some_sth->fetch_object() ) {
            $down = $row->DOWN;
            $up = $row->UP;
            $diff = ($row->COMB - ($down + $up));
            $combb = ( $diff<0 )? ($row->COMB+($diff * -1)) : ($row->COMB) ;
            $tot = ($is_expd)? ($down + $up) : ($combb);
        }
        
        $ntot = ($plan['DATA']>0)? ($tot + $plan['DATA']) : $tot;
        $renewData = bytes($plan['DATA'], "GiB", '%01.2f %s');
        
        $all_query_ok = true;
        $this->db->autocommit(FALSE);
        
        // add 1 month
        $upd = "UPDATE rm_users SET uplimit = '$up', downlimit = '$down', comblimit = '$ntot', expiration=?
                WHERE username = ?";
        $this->db->execute_query($upd, "ss", $nu_expd, $referrer)? null : $all_query_ok=false;
        
        $ins = "INSERT INTO `tbl_referral_reward_log` VALUES
                 (NULL, ?, ?, '1 Month', '{$userRecord['EXPIRATION']}', '$nu_expd', '{$userRecord['SERVICE']}', NOW())";
        $insId = $this->db->insert($ins, "ss", json_encode($refIDs), $referrer);
        $insId? null : $all_query_ok=false; 
        
        // set rewarded
        $reflist = "'" . implode("', '", $refIDs) . "'";
        $upd1 = "UPDATE `tbl_referral_details` SET REWARDED=1, DATE_REWARDED=NOW(), REWARDID='$insId' WHERE REFID IN ($reflist)";
        $this->db->execute_query($upd1)? null : $all_query_ok=false;
        
        $all_query_ok ? $this->db->commit() : $this->db->rollback();
        $this->db->autocommit(TRUE);
        
        $rref = json_encode($refUsers);
        if ($all_query_ok):
            $raw_msg = $ad->getCannedMessage("REFERRAL_REWARDv1"); 
            $raw_sms = $ad->getCannedSMS("REFERRAL_REWARDv1");
            $msgaddon = $ad->getCannedMessageAddon("REFERRAL_REWARDv1");
            $msg = sprintf($raw_msg, $userRecord['FIRSTNAME'] . " " .$userRecord['LASTNAME']); // json_encode($refNames), $userRecord["EXPIRATION"], $nu_expd );
            $sent = $ad->sendEmailAWS($userRecord['EMAIL'], "csc@fob.ng", "1 Free Month of Internet Activated!", $msg, [], [], $msgaddon);
            $ad->logTrail($ad::RENEWAL_MANUAL, "(Referral Promo attempt) Success: 1 month added to Referrer $referrer for referring ($rref)! Data Added: $renewData; Old Expiry Date: {$userRecord["EXPIRATION"]}; New Expiry Date: $nu_expd", $ad::STATUS_PASSED, get_client_ip_env());
            
            $bs = new BulkSMS($this->db);
            $recipient = $bs->cleanMobile($userRecord['MOBILE']); 
            $ret = $bs->sendSMS($raw_sms, $recipient); 
            $response = $ret["message"];
            $responseID = $ret["messageId"];
            $av = $ad->saveSMS('', "FiberOne", $raw_sms, json_encode($recipient), count($recipient), 1, $ret);
            $avv = $ad->saveSMSDetails($av, $responseID);
            if ($response == "Sent"){
                $log->logTrail($log::INFO, "(Referral Auto Msg attempt) Success: Sent Bulk SMS (1 Free Month of Internet Activated!) to {$userRecord['FIRSTNAME']}. <$av>", $log::STATUS_PASSED, get_client_ip_env());
            } else {
                $log->logTrail($log::INFO, "(Referral Auto Msg attempt) Error: Fail to Send Bulk SMS (1 Free Month of Internet Activated!) to {$userRecord['FIRSTNAME']}. ", $log::STATUS_FAILED, get_client_ip_env()); 
            }
    
            return 1;
        else:
            $ad->logTrail($ad::RENEWAL_MANUAL, "(Referral Promo attempt) Error: Fail to add 1 month to Referrer $referrer for referring ($rref)! ", $ad::STATUS_FAILED, get_client_ip_env());
            return 0;
        endif;
    }
    
    /******* SHORTEN URL CODES *******/
    /* Adopted from https://github.com/mikecao/shorty/blob/master/shorty.php **/

    /**
     * Converts an id to an encoded string.
     *
     * @param int $n Number to encode
     * @return string Encoded string
     */
    public function encode($n) {
        $k = 0;

        if ($this->padding > 0 && !empty($this->salt)) {
            $k = self::get_seed($n, $this->salt, $this->padding);
            $n = (int)($k.$n);
        }

        return self::num_to_alpha($n, $this->chars);
    }

    /**
     * Converts an encoded string into a number.
     *
     * @param string $s String to decode
     * @return int Decoded number
     */
    public function decode($s) {
        $n = self::alpha_to_num($s, $this->chars);

        return (!empty($this->salt)) ? substr($n, $this->padding) : $n;
    }

    /**
     * Gets a number for padding based on a salt.
     *
     * @param int $n Number to pad
     * @param string $salt Salt string
     * @param int $padding Padding length
     * @return int Number for padding
     */
    public static function get_seed($n, $salt, $padding) {
        $hash = md5($n.$salt);
        $dec = hexdec(substr($hash, 0, $padding));
        $num = $dec % pow(10, $padding);
        if ($num == 0) $num = 1;
        $num = str_pad($num, $padding, '0');

        return $num;
    }

    /**
     * Converts a number to an alpha-numeric string.
     *
     * @param int $num Number to convert
     * @param string $s String of characters for conversion
     * @return string Alpha-numeric string
     */
    public static function num_to_alpha($n, $s) {
        $b = strlen($s);
        $m = $n % $b;

        if ($n - $m == 0) return substr($s, $n, 1);

        $a = '';

        while ($m > 0 || $n > 0) {
            $a = substr($s, $m, 1).$a;
            $n = ($n - $m) / $b;
            $m = $n % $b;
        }

        return $a;
    }

    /**
     * Converts an alpha numeric string to a number.
     *
     * @param string $a Alpha-numeric string to convert
     * @param string $s String of characters for conversion
     * @return int Converted number
     */
    public static function alpha_to_num($a, $s) {
        $b = strlen($s);
        $l = strlen($a);

        for ($n = 0, $i = 0; $i < $l; $i++) {
            $n += strpos($s, substr($a, $i, 1)) * pow($b, $l - $i - 1);
        }

        return $n;
    }
    
}
