<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
if (file_exists("classes/UserProfile.php")) {
    require_once "classes/UserProfile.php";
} elseif (file_exists("../classes/UserProfile.php")) {
    require_once "../classes/UserProfile.php";
} elseif (file_exists("../../classes/UserProfile.php")) {
    require_once "../../classes/UserProfile.php";
}
if (file_exists("classes/Password_Generator.php")) {
    require_once "classes/Password_Generator.php";
} elseif (file_exists("../classes/Password_Generator.php")) {
    require_once "../classes/Password_Generator.php";
} elseif (file_exists("../../classes/Password_Generator.php")) {
    require_once "../../classes/Password_Generator.php";
}
/**
 * Description of Tickets
 *
 * @author OPMat
 */
class Tickets {
    
    const RESPONSE_ASSIGN = 1;
    const RESPONSE_COMMENT = 2;
    const RESPONSE_CLOSE = 3;
    private $resp_type = [1=>"ASSIGN", 2=>"COMMENT", 3=>"CLOSE"];
    
    const COMMENT_SATISFACTION = 1;
    const COMMENT_COURTESY = 2;
    const COMMENT_TIMELINESS = 3;
    const COMMENT_OVERALL = 4;
    private $comment_type = [1=>'SATISFACTION', 2=>'COURTESY', 3=>'TIMELINESS', 4=>'OVERALL', 5=>'USER_FEEDBACK'];

    private $db;
    private $user;
    
    public $totalRecords;
    public $totalRecordwithFilter;

    public function __construct($dbconnection, UserProfile $user) {
        $this->db = $dbconnection;
        $this->user = $user;
    } 
    
    public function getTckQueryString($ticket_type) {
        $ad = '';
        switch ($ticket_type) {
            case "NewTickets":
                $ad .= " AND tt.`STATUS`='Needs Assistance'
AND ((SELECT COUNT(TCK_RESP_ID) FROM tck_reponses WHERE TCK_ID=tt.TCK_ID)<1) ";
                break;
            
            case "TicketsAwaitingSupport":
                $ad .= " AND tt.`STATUS`='Needs Assistance'
AND ((SELECT COUNT(TCK_RESP_ID) FROM tck_reponses WHERE TCK_ID=tt.TCK_ID)>1) ";
                break;
            
            case "TicketsAwaitingUser":
                $ad .= " AND tt.`STATUS`='Assistance Received'
AND ((SELECT COUNT(TCK_RESP_ID) FROM tck_reponses WHERE TCK_ID=tt.TCK_ID)>1) ";
                break;
            
            case "ClosedTickets":
                $ad .= " AND tt.`STATUS`='Closed' ";
                break;
        }
        
        return $ad;
    }
    
    public function getTckQueryString2($startdate = '', $enddate = '', $searchval='') {
        $ad = '';
        if ($searchval <> "") :
            $searchval = mysqli_real_escape_string($this->db, $searchval);
            $ad .= " AND (tc.RAD_USERNAME LIKE '$searchval' OR tc.USERNAME LIKE '$searchval' OR tt.TITLE LIKE '%$searchval%' ) ";
        endif;
        if ($startdate <> "" && $startdate <= $enddate ) :
            $startdate = mysqli_real_escape_string($this->db, $startdate);
            $ad .= " AND ( DATE(tt.DATE_CREATED) >= '$startdate' ) ";
        endif;
        if ($enddate <> "" && $startdate <= $enddate) :
            $enddate = mysqli_real_escape_string($this->db, $enddate);
            $ad .= " AND ( DATE(tt.DATE_CREATED) <= '$enddate' ) ";
        endif;
        
        return $ad;
    }
    
    public function getTicketReport($toDisplay=1, $ticket_type='', $startdate = '', $enddate = '', $searchval='', $sortby='', $sortorder='desc', $startrow=0, $len = 0) {
        $ad = $addon = "";
        $ret = [];
        
        $ad .= $this->getTckQueryString($ticket_type);
        $ad .= $this->getTckQueryString2($startdate, $enddate, $searchval);

        $mqry = "SELECT TCK_ID, tc.RAD_USERNAME, TITLE, CONTENT, tt.DATE_CREATED, DEPT, `STATUS`, CATEGORY,
(SELECT COUNT(TCK_RESP_ID) FROM tck_reponses WHERE TCK_ID=tt.TCK_ID) AS 'CONVO_COUNT' 
FROM tck_tickets tt
LEFT JOIN tblclients tc ON tt.CLIENT_ID=tc.ID
LEFT JOIN tck_departments td ON tt.DID=td.DEPT_ID
                   LEFT JOIN rm_users ru ON tc.RAD_USERNAME=ru.username ";
        $some_st = $this->db->select($mqry); //echo $mqry; exit();
        $this->totalRecords = $some_st->num_rows();
        
        $fqry = "$mqry WHERE 1 $ad ";
        $some_s = $this->db->select($fqry);
        $this->totalRecordwithFilter = $some_s->num_rows();
        
        $limit = ($len == -1 || $len == 0)? "" : "LIMIT $startrow, $len";
        
        $msort = "ORDER BY tt.DATE_CREATED DESC"; //($sortby != "")? "ORDER BY $sortby $sortorder" : "ORDER BY tt.DATE_CREATED DESC";
        $qry = "$mqry WHERE 1 $ad $msort $limit"; 
        $some_sth = $this->db->select($qry);

        while ( $row = $some_sth->fetch_object() ) {
            $title = $row->TITLE; $tckId = $row->TCK_ID;
            $stat = $row->STATUS; $coded = "";
            $phrase = [];
            if ($toDisplay):
                preg_match("/(?:\w+(?:\W+|$)){0,20}/", $row->CONTENT, $phrase);
                if ($row->STATUS == "Needs Assistance"):
                    $lblcolor = "label-info";
                elseif ($row->STATUS == "Assistance Received"):
                    $lblcolor = "label-success";
                elseif ($row->STATUS == "Closed"):
                    $lblcolor = "label-warning";
                endif;
                $rand = new Password_Generator();
                $coded = base64_encode($row->TCK_ID);
                $coded = $rand->generate(50, 50, TRUE, TRUE, TRUE) . $coded . $coded . $coded;
                $tckId = "<a href=\"ad_vtick/$coded\">{$row->TCK_ID}</a>";
                $title = "<a href=\"ad_vtick/$coded\"><strong>{$row->TITLE}</strong><br/>{$phrase[0]} ...</a>";
                $stat = "<span class=\"label-default label $lblcolor\">{$row->STATUS}</span>";
            endif;
            $ret[] = ["TCK_ID"=>$tckId, "RAD_USERNAME"=>$row->RAD_USERNAME, "TITLE"=>$title, "CONTENT"=>$row->CONTENT, 
                "DATE_CREATED"=>date("d M, Y H:i:s a", strtotime($row->DATE_CREATED)), 
                "STATUS"=>$stat, "DEPT"=>$row->DEPT, 
                "CONVO_COUNT"=>$row->CONVO_COUNT, "CATEGORY"=>$row->CATEGORY, "ACTION"=>""]; 
        }
        return $ret;
    }
    
    public function getTicketList($username="", $deptid=0, $is_closed=-1) {
//        $msg = "";
        $ad = "";
        $ret = [];
        if ($username <> "") :
            $username = filter_var($username, FILTER_SANITIZE_STRING);//mysqli_escape_string($this->db, $username);
            $ad .= ($ad == "")? " WHERE tc.USERNAME LIKE '$username'" : " AND tc.USERNAME LIKE '$username'";
        endif;
        if ($deptid <> 0) :            
            $deptid = filter_var($deptid, FILTER_SANITIZE_NUMBER_INT); //(int)mysqli_escape_string($this->db, $deptid);
            $ad .= ($ad == "")? " WHERE tt.DID = '$deptid'" : " AND tt.DID = '$deptid'";
        endif;
        if ($is_closed <> -1 && $is_closed > -1):
            $is_closed = filter_var($is_closed, FILTER_SANITIZE_NUMBER_INT);
            $ad .= ($ad == "")? " WHERE tt.IS_CLOSED = $is_closed" : " AND tt.IS_CLOSED = $is_closed";
        endif;
        
        $strsql = "SELECT tt.TCK_ID, tt.TITLE, tt.CONTENT, tt.FILE, tt.CLIENT_ID, tt.DATE_CREATED, tt.IS_CLOSED, 
			tt.PRIORITY, tt.`STATUS`, tc.USERNAME, td.DEPT_ID, td.DEPT, ru.company AS 'COMPANY', 
                        ru.lastname AS 'NAME', `CATEGORY`
                    FROM tck_tickets tt
                   LEFT JOIN tblclients tc ON tt.CLIENT_ID=tc.ID
                   LEFT JOIN tck_departments td ON tt.DID=td.DEPT_ID
                   LEFT JOIN rm_users ru ON tc.RAD_USERNAME=ru.username $ad ORDER BY tt.DATE_CREATED DESC";
        $some_sth = $this->db->select($strsql);
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = ["TICKETID"=>$row->TCK_ID, "TITLE"=>$row->TITLE, "CONTENT"=>$row->CONTENT, 
                "FILE"=>$row->FILE, "CLIENT_ID"=>$row->CLIENT_ID, "DATE_CREATED"=>$row->DATE_CREATED, 
                "IS_CLOSED"=>$row->IS_CLOSED, "PRIORITY"=>$row->PRIORITY, "STATUS"=>$row->STATUS, 
                "USERNAME"=>$row->USERNAME, "DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, 
                "COMPANY"=>$row->COMPANY, "NAME"=>$row->NAME, "CATEGORY"=>$row->CATEGORY]; //$ret[$row->TCK_ID]
        }
        return $ret;
    }
    
    public function getDisTicket($ticketID) {
        $ret = [];
        
        $strsql = "SELECT tt.TCK_ID, tt.TITLE, tt.CONTENT, tt.FILE, tt.CLIENT_ID, tt.DATE_CREATED, tt.IS_CLOSED, 
			tt.PRIORITY, tt.`STATUS`, tc.USERNAME, td.DEPT_ID, td.DEPT, ru.company AS 'COMPANY', 
                        ru.lastname AS 'NAME', `CATEGORY`
                    FROM tck_tickets tt
                   LEFT JOIN tblclients tc ON tt.CLIENT_ID=tc.ID
                   LEFT JOIN tck_departments td ON tt.DID=td.DEPT_ID
                   LEFT JOIN rm_users ru ON tc.RAD_USERNAME=ru.username 
                   WHERE TCK_ID=?";
        $some_sth = $this->db->select($strsql, "i", $ticketID);
        while ( $row = $some_sth->fetch_object() ) {
            $ret = ["TICKETID"=>$row->TCK_ID, "TITLE"=>$row->TITLE, "CONTENT"=>$row->CONTENT, 
                "FILE"=>$row->FILE, "CLIENT_ID"=>$row->CLIENT_ID, "DATE_CREATED"=>$row->DATE_CREATED, 
                "IS_CLOSED"=>$row->IS_CLOSED, "PRIORITY"=>$row->PRIORITY, "STATUS"=>$row->STATUS, 
                "USERNAME"=>$row->USERNAME, "DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, 
                "COMPANY"=>$row->COMPANY, "NAME"=>$row->NAME];
        }
        return $ret;
    }
    
    public function getTicketDetails($ticketID) {
        $ret = [];
        $strsql = "SELECT TCK_RESP_ID, trp.TCK_ID, trp.ADMIN_ID, ta.FULLNAME AS 'ADMIN_NAME', ta.USERNAME AS 'ADMIN_UNAME', 
                    trp.USER_ID, trp.CONTENT, trp.FILE, trp.RESPONSE_TYPE, trp.RESPONSEDATE, trp.SATISFACTION,
                    trp.COURTESY, trp.TIMELINESS, trp.OVERALL, trp.USER_FEEDBACK, IF(trp.ADMIN_ID, 'support', 'client') AS TYPE
                    FROM tck_reponses trp
                    LEFT JOIN tbl_admins ta ON trp.ADMIN_ID=ta.AID
                    LEFT JOIN tblclients tc ON trp.USER_ID=tc.ID 
                WHERE `TCK_ID`=? ORDER BY RESPONSEDATE DESC";
        $some_sth = $this->db->select($strsql, "i", $ticketID);
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = ["TICKETID"=>$row->TCK_ID, "TCK_RESP_ID"=>$row->TCK_RESP_ID, "CONTENT"=>$row->CONTENT, 
                "FILE"=>$row->FILE, "CLIENT_ID"=>$row->USER_ID, "RESPONSEDATE"=>$row->RESPONSEDATE, 
                "RESPONSE_TYPE"=>$row->RESPONSE_TYPE, "ADMIN_ID"=>$row->ADMIN_ID, "ADMIN_NAME"=>$row->ADMIN_NAME, 
                "ADMIN_UNAME"=>$row->ADMIN_UNAME, "SATISFACTION"=>$row->SATISFACTION, "COURTESY"=>$row->COURTESY, 
                "TIMELINESS"=>$row->TIMELINESS, "OVERALL"=>$row->OVERALL, "USER_FEEDBACK"=>$row->USER_FEEDBACK,
                "TYPE"=>($row->TYPE) ];
          //$ret[$row->TCK_RESP_ID]
        }
        return $ret;
    }
        
    
    public function getDepts() {
        $ret = [];
        $strsql = "SELECT DEPT_ID, DEPT, `DESCRIPTION`
                    FROM tck_departments ORDER BY DEPT";
        $some_sth = $this->db->select($strsql);
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->DEPT_ID] = ["DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, "DESCRIPTION"=>$row->DESCRIPTION];
        }
        return $ret;
    }
        
    
    public function getCategories() {
        $ret = [];
        $strsql = "SELECT CATEGORY_ID, CATEGORY, `DATE_ADDED`
                    FROM tck_categories ORDER BY CATEGORY";
        $some_sth = $this->db->select($strsql);
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->CATEGORY_ID] = ["CATEGORY_ID"=>$row->CATEGORY_ID, "CATEGORY"=>$row->CATEGORY, "DATE_ADDED"=>$row->DATE_ADDED];
        }
        return $ret;
    }
        
    
    public function getAdminDepts($adminID) {
        $ret = [];
        $strsql = "SELECT DEPT_ID, DEPT, `DESCRIPTION`
                    FROM tck_departments 
                    LEFT JOIN tck_dept_staff tds ON td.DEPT_ID=tds.DEPT_ID
                    WHERE tds.AID=?                 
                    ORDER BY DEPT";
        $some_sth = $this->db->select($strsql, "i", $adminID);
        while ( $row = $some_sth->fetch_object() ) {
            $ret = ["DEPT_ID"=>$row->DEPT_ID, "DEPT"=>$row->DEPT, "DESCRIPTION"=>$row->DESCRIPTION];
        }
        return $ret;
    }
    
    public function getUserDets($userID) {
        $ret = [];
        $strsql = "SELECT CONCAT(firstname, ' ',lastname) AS 'FULLNAME', RAD_USERNAME, email, mobile FROM `tblclients` tc
                    LEFT JOIN rm_users ru ON tc.RAD_USERNAME=ru.username
                WHERE tc.ID = ?";
        $some_sth = $this->db->select($strsql, "i", $userID);
        while ( $row = $some_sth->fetch_object() ) {
            $ret = ["FULLNAME"=>$row->FULLNAME, "USERNAME"=>$row->RAD_USERNAME, "EMAIL"=>$row->email, "MOBILE"=>$row->mobile];
        }
        return $ret;
    }
    
    
    public function getCannedMessage($purpose="") {
        $msg = "";
        $ad = "";
        if ($purpose <> "") :
            $purpose = mysqli_real_escape_string($this->db, $purpose); //  mysql_escape_string($purpose);
            $ad = " WHERE PURPOSE LIKE '$purpose'";
        endif;
            
        $qry = "SELECT CANNED_MSG FROM `tbl_canned_msg` $ad LIMIT 1";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $msg = $row->CANNED_MSG;
        }
        
        return $msg;
    }
    
    
    public function sendEmail($to, $from, $subject, $message) {
        if ($to <> "" && $subject <> "" && $message <> "") :
            $headers = "From: " . strip_tags($from) . "\r\n";
            $headers .= "Reply-To: ". strip_tags($from) . "\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
            
            return mail($to, $subject, nl2br($message), $headers);
        else:
            return 0;
        endif;
    }
    
    public function createTicket($title, $content, $file, $client_id, $deptid, $priority=1, $status="Needs Assistance", $category="") {
        
        $ins = "INSERT INTO tck_tickets (`TITLE`, `CONTENT`, `FILE`, `CLIENT_ID`, `DATE_CREATED`, DID, `PRIORITY`, `STATUS`, `CATEGORY`)
               VALUES (?, ?, ?, ?, NOW(), ?, ?, ?, ?)"; 
        $in_id = $this->db->insert($ins, "sssiiiss", $title, $content, $file, $client_id, $deptid, $priority, $status, $category);
        
        if ($this->ticketExist($in_id)) :
            //Get Message
            $raw_msg = $this->getCannedMessage("TICKET_CREATED_v2");
            $u = $this->getUserDets($client_id);
            $msg = sprintf($raw_msg, $u["FULLNAME"], $in_id, $u["USERNAME"], $title, $content);
            
            $adminEmail = ($deptid==1)? 'salessupport@fob.ng' : ADMIN_NOTIF_EMAIL;
			/* EMAIL_SENDER */
            $ad = new UserProfile($this->db);
            $sent = $ad->sendEmail($u["EMAIL"], EMAIL_SENDER, "Support Ticket Created on FOB Online (#$in_id)", $msg);
            $sent = $ad->sendEmail($adminEmail, $u["EMAIL"], "Support Ticket Created on FOB Online (#$in_id)", $msg);
            return $in_id;
        endif;
        return 0;
    }
    
    public function ticketExist($ticketID) {        
        if ($ticketID > 0) :            
            $ticketID = filter_var($ticketID, FILTER_SANITIZE_NUMBER_INT); 
            $strsql = "SELECT TCK_ID FROM tck_tickets WHERE TCK_ID=?";
            $some_sth = $this->db->select($strsql, "i", $ticketID);
            $rows = $some_sth->num_rows();
            return $rows;
        endif;
        
        return 0;
    }
    
    public function addComment($ticketID, $content, $file, $response_type, $createdby=0, $adminID=NULL, $userID=NULL) {
        $ins = "INSERT INTO tck_reponses (`TCK_ID`, `ADMIN_ID`, `USER_ID`, `CONTENT`, `FILE`, RESPONSE_TYPE, 
            `RESPONSEDATE`, `SATISFACTION`, `COURTESY`, `TIMELINESS`, `OVERALL`, `USER_FEEDBACK`, `CREATEDBY`)
               VALUES (?, $adminID, $userID, ?, ?, ?, NOW(), NULL, NULL, NULL, NULL, NULL, ?)"; //echo $ins;
        $in_id = $this->db->insert($ins, "isssi", $ticketID, $content, $file, $this->resp_type[$response_type], $createdby);
        
        if ($this->commentExist($in_id)) :
            $status = "";
            switch($response_type):
                case $this::RESPONSE_COMMENT:
                    $status = (is_null($adminID) || ($adminID == "NULL"))? "Needs Assistance" : "Assistance Received";
                    $upd = "UPDATE tck_tickets SET `STATUS`=? WHERE `TCK_ID`=?";
                    $rett = $this->db->execute_query($upd, "si", $status, $ticketID);
                    
                    //Get Message
                    $ad = new UserProfile($this->db);
                    if (is_null($adminID) || ($adminID == "NULL")):
                        $raw_msg = $this->getCannedMessage("TCK_ADMIN_RESPONDED");
                        $u = $this->getUserDets($userID);
                        $msg = sprintf($raw_msg, $u["FULLNAME"], $ticketID);

                        $sent = $ad->sendEmail($u["EMAIL"], EMAIL_SENDER, "New Comment on FOB Support Ticket (#$ticketID)", $msg);
                    else:
                        $raw_msg = $this->getCannedMessage("TCK_CLIENT_RESPONDED");
                        $msg = sprintf($raw_msg, $ticketID);

                        $sent = $ad->sendEmail(EMAIL_SENDER, EMAIL_SENDER, "New Comment on FOB Support Ticket (#$ticketID)", $msg);
//                        $sent = $this->sendEmail(ADMIN_NOTIF_EMAIL, EMAIL_SENDER, "New Comment on FOB Support Ticket (#$ticketID)", $msg);
                    endif;
                    break;
                case $this::RESPONSE_CLOSE:
                    $status = "Closed";
                    $upd = "UPDATE tck_tickets SET `STATUS`=?, `IS_CLOSED`=1 WHERE `TCK_ID`=?";
                    $rett = $this->db->execute_query($upd, "si", $status, $ticketID);
                    
                    //Get Message
                    $raw_msg = $this->getCannedMessage("TICKET_CLOSED");
                    $u = $this->getUserDets($userID);
                    $msg = sprintf($raw_msg, $u["FULLNAME"], $ticketID);

                    $ad = new UserProfile($this->db);
                    $sent = $ad->sendEmail($u["EMAIL"], EMAIL_SENDER, "Support Ticket Closed on FOB Online (#$ticketID)", $msg);
                    break;
            endswitch;
            
            return $in_id;
        endif;
        return 0;
    }
    
    public function rateResponse($tck_resp_id, $comment_type, $score) {
        if ($this->commentExist($tck_resp_id)) :
            $upd = "UPDATE tck_reponses SET `{$this->comment_type[$comment_type]}` = ? WHERE TCK_RESP_ID = ?";
            $rett = $this->db->execute_query($upd, "ii", $score, $tck_resp_id);
            if ($rett):
                return 1;
            else: 
                return 0;
            endif;
        else:
            return -1;
        endif;
    }
    
    public function getStaffRating($staffID) {
        $ret = [];
        $strsql = "SELECT AVG(`SATISFACTION`) AS 'SATISFACTION, AVG(`COURTESY`) AS 'COURTESY, 
                    AVG(`TIMELINESS`) AS 'TIMELINESS', AVG(`OVERALL`) AS 'OVERALL' 
                 FROM tck_reponses WHERE ADMIN_ID=? GROUP BY ADMIN_ID";
        $some_sth = $this->db->select($strsql, "i", $staffID);
        while ( $row = $some_sth->fetch_object() ) {
            $ret = ["SATISFACTION"=>$row->SATISFACTION, "COURTESY"=>$row->COURTESY,  
                "TIMELINESS"=>$row->TIMELINESS, "OVERALL"=>$row->OVERALL ];
        }
        return $ret;
    }
    
    public function commentExist($ticketRespID) {        
        if ($ticketRespID > 0) :            
            $ticketRespID = filter_var($ticketRespID, FILTER_SANITIZE_NUMBER_INT); 
            $strsql = "SELECT TCK_RESP_ID FROM tck_reponses WHERE TCK_RESP_ID=?";
            $some_sth = $this->db->select($strsql, "i", $ticketRespID);
            $rows = $some_sth->num_rows();
            return $rows;
        endif;
        
        return 0;
    }
    
}
