<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
//session_start(); 
//$sid = session_id();

//require_once '../includes/common_functions.php';
if (file_exists("includes/common_functions.php"))
    require_once "includes/common_functions.php";
elseif (file_exists("../includes/common_functions.php"))
    require_once "../includes/common_functions.php";
elseif (file_exists("../../includes/common_functions.php"))
    require_once "../../includes/common_functions.php";

if (file_exists("includes/opener.php"))
    require_once "includes/opener.php";
elseif (file_exists("../includes/opener.php"))
    require_once "../includes/opener.php";
elseif (file_exists("../../includes/opener.php"))
    require_once "../../includes/opener.php";
elseif (file_exists("../../../includes/opener.php"))
    require_once "../../../includes/opener.php";

if (file_exists("classes/PHPMailer/PHPMailerAutoload.php"))
    require_once "classes/PHPMailer/PHPMailerAutoload.php";
elseif (file_exists("../classes/PHPMailer/PHPMailerAutoload.php"))
    require_once "../classes/PHPMailer/PHPMailerAutoload.php";
elseif (file_exists("../../classes/PHPMailer/PHPMailerAutoload.php"))
    require_once "../../classes/PHPMailer/PHPMailerAutoload.php";


/**
 * Description of UserProfile
 *
 * @author OPMat
 */
class UserProfile extends Logger {
    //put your code here
    private $db;
    private $uid;
    private $fullname;
    private $is_admin; 
    private $is_enabled; 
    private $usertype; 
    private $usertype_id;
    private $username; 
    private $rad_username;
    private $lastname;
    private $firstname;
    private $package;
    private $packageid;
    private $expiration;
    private $email;
    private $mobile;
    private $sid;
    private $readonly;



    public function __construct($dbconnection) {
        $this->db = $dbconnection;
//        parent::setDB($dbconnection);
        $this->sid = session_id();
        parent::__construct($dbconnection, $_SESSION[$this->sid."username"]);
    } 
    
     
    public function authenticateUser($username, $password)  {
       $qry = "SELECT tc.ID, tc.USERNAME, tc.RAD_USERNAME, tc.IS_ENABLED, DATE_CREATED, enableuser, uplimit, downlimit, 
                    comblimit, firstname, lastname, email,
                    company, mobile, expiration, ru.srvid, rs.srvname
                FROM `tblclients` tc
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                WHERE tc.USERNAME LIKE ? AND tc.PASSWORD=?"; 
       $some_sth = $this->db->select($qry, 'ss', $username, sha1($password));
       $rows = $some_sth->num_rows();
       while ( $row = $some_sth->fetch_object() ) {
           $this->uid = $row->ID;
           $this->username = $row->USERNAME;
           $this->rad_username = $row->RAD_USERNAME;
           $this->is_admin = 0;
           $this->usertype = "USER";
           $this->usertype_id = 3;
           $this->is_enabled = ($row->IS_ENABLED == 1 && $row->enableuser == 1);
           $this->fullname = $row->firstname . " " . $row->lastname;
           $this->email = $row->email;
           $this->mobile = $row->mobile;
           $this->expiration = $row->expiration;
           $this->packageid = $row->srvid;
           $this->package = $row->srvname;
       }

       return $rows;
    } 
    
     
    public function authenticateAdmin($username, $password)  {
       $qry = "SELECT tad.AID, tad.USERNAME, tad.FULLNAME, tad.MOBILE, tad.EMAIL, tad.ACCESS_LEVEL, 
                    tal.ADMIN_TYPE, tad1.FULLNAME AS 'ADDED_BY', tad.IS_ENABLED, tad.`READONLY` 
                FROM `tbl_admins` tad
                LEFT JOIN tbl_admin_level tal ON tad.ACCESS_LEVEL = tal.ID
                LEFT JOIN tbl_admins tad1 ON tad.ADDED_BY = tad1.AID
               WHERE tad.USERNAME LIKE ? AND tad.PASSWORD=?"; 
       $some_sth = $this->db->select($qry, 'ss', $username, sha1($password));
       $rows = $some_sth->num_rows();
       while ( $row = $some_sth->fetch_object() ) {
           $this->uid = $row->AID;
           $this->username = $row->USERNAME;
           $this->rad_username = "";
           $this->is_admin = 1;
           $this->usertype = $row->ADMIN_TYPE;
           $this->usertype_id = $row->ACCESS_LEVEL;
           $this->is_enabled = $row->IS_ENABLED;
           $this->fullname = $row->FULLNAME;
           $this->email = $row->EMAIL;
           $this->mobile = $row->MOBILE;
           $this->expiration = "0000-00-00";
           $this->packageid = 0;
           $this->package = "ADMIN";
           $this->readonly = $row->READONLY;
       }

       return $rows;
    }
     
    public function loadUserProfile($radusername)  {
       $qry = "SELECT ru.username, enableuser, firstname, lastname, email,
                    company, mobile, expiration, ru.srvid, rs.srvname, address, city, state
                FROM rm_users ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                WHERE username LIKE ?"; 
       $some_sth = $this->db->select($qry, 's', $radusername);
       $rows = $some_sth->num_rows();
       if ($rows) $row = $some_sth->fetch_object(); 
       else $row = "";

       return $row;
    } 
    
    public function updateUserProfile($radusers, $email, $phone) {
        $done = 0;
        $sid = session_id();
        
        foreach ($radusers as $key => $user) {
            $upd = "UPDATE rm_users SET email=?, mobile=? WHERE username=?";
            $rett = $this->db->execute_query($upd, "sss", $email, $phone, $user);
            if ($rett) $done = 1;
        }
        
        if ($done) :            
            $_SESSION[$sid.'phoneNo'] = $phone;
            $_SESSION[$sid.'email'] = $email;
            $this->logTrail($this::INFO, "Success: Profile Update for User [$radusers]! EMAIL: $email; PHONE: $phone", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Update Completed!";
        else:
            $this->logTrail($this::INFO, "Error: Profile Update for User [$radusers] failed! EMAIL: $email; PHONE: $phone", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Update failed! No changes made.";
        endif;
    }
    
    public function updateUserProfile2($raduser, $name, $address, $city, $state) {
        $done = 0;
        $sid = session_id();
        
        if ($raduser != "") {
            $upd = "UPDATE rm_users SET firstname=?, lastname='', address=?, city=?, state=? WHERE username=?";
            $rett = $this->db->execute_query($upd, "sssss", $name, $address, $city, $state, $raduser);
            if ($rett) $done = 1;
        }
        
        if ($done) :                        
            $_SESSION[$sid.'fullname'] = $name;
            $this->logTrail($this::INFO, "Success: Profile Update for User [$radusers]! NAME: $name; ADDRESS: $address; CITY: $city; STATE: $state", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Update Completed!";
        else:
            $this->logTrail($this::INFO, "Error: Profile Update for User [$radusers] failed! NAME: $name; ADDRESS: $address; CITY: $city; STATE: $state", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Update failed! No changes made.";
        endif;
    }
    
    public function updateUserProfile3($raduser, $fname, $lname, $address, $city, $state, $email, $mobile) {
        $done = 0;
        $sid = session_id();
        
        if ($raduser != "") {
            $upd = "UPDATE rm_users SET firstname=?, lastname=?, address=?, city=?, state=?,email=?, mobile=?
                     WHERE username=?";
            $rett = $this->db->execute_query($upd, "ssssssss", $fname, $lname, $address, $city, $state, $email, $mobile, $raduser);
            if ($rett) $done = 1;
        }
        
        return $done;
    }
    
    
    public function verifyUserExist($username="") {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.USERNAME, tc.IS_ENABLED, enableuser
                FROM `tblclients` tc
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME=ru.username
                WHERE tc.USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                if ($row->IS_ENABLED == 1 && $row->enableuser == 1):
                    $exist = 1;
                else:
                    //disabled
                    $exist = 2;
                endif;
            }
        endif;
        
        return $exist;
    }
    
    public function verifyUserDepth($username) {
        $exist = 0;
        $qry = "SELECT username FROM rm_users WHERE username = ?";
        $some_sth = $this->db->select($qry, 's', $username);
        $rows = $some_sth->num_rows();
        if (!$rows):
            return $exist;
        else:
            //check if exist in eservice as Client
            $cid = $this->eServiceUserExist($username);
            if ($cid > 0):
                //check if it has subaccount
                $hasSub = $this->userHasSubAccount($cid);
                return ($hasSub)? -2 : 2;
            else:
                //check if exist as subaccount in eservice
                $ist = $this->subAccountUserExist($username);
                return ($ist > 0)? 3 : 1;
            
            endif;
        endif;
        return $exist;
    }
    
    
    public function userHasSubAccount($clientID) {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.ID
                FROM `tbl_subaccount` tc
                WHERE tc.CID LIKE ?";
            $some_sth = $this->db->select($qry, 'i', $clientID);
            $rows = $some_sth->num_rows();
            if ($rows > 0) {
                return 1;
            }
        endif;
        
        return $exist;
    }
    
    
    public function subAccountUserExist($username) {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.ID
                FROM `tbl_subaccount` tc
                WHERE tc.RAD_USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            if ($rows > 0) {
                $row = $some_sth->fetch_object();
                return $row->ID;
            }
        endif;
        
        return $exist;
    }
    
    
    public function eServiceUserExist($username) {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.ID, tc.USERNAME, tc.IS_ENABLED
                FROM `tblclients` tc
                WHERE tc.RAD_USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            if ($rows > 0) {
                $row = $some_sth->fetch_object();
                return $row->ID;
            }
        endif;
        
        return $exist;
    }
    
    
    public function verifyUserExistAlone($username="") {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT tc.USERNAME, tc.IS_ENABLED
                FROM `tblclients` tc
                WHERE tc.USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            if ($rows > 0) {
                $exist = 1;
            }
        endif;
        
        return $exist;
    }
    
    
    public function verifyAdminExist($username="") {
        $exist = 0;
        if ($username <> "") :
            $qry = "SELECT * FROM `tbl_admins`
                WHERE USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                if ($row->IS_ENABLED == 1):
                    $exist = 1;
                else:
                    //disabled
                    $exist = 2;
                endif;
            }
        endif;
        
        return $exist;
    }
    
    
    public function verifyPlanExist($plan="", $package=0) {
        $exist = 0;
        if ($plan <> "" && $package <> 0) :
            $qry = "SELECT SRVID, PLAN, IS_ENABLED
                FROM `tbl_plans` 
                WHERE PLAN =? AND SRVID=?";
            $some_sth = $this->db->select($qry, 'si', $plan, $package);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                if ($row->IS_ENABLED == 1):
                    $exist = 1;
                else:
                    //disabled
                    $exist = 2;
                endif;
            }
        endif;
        
        return $exist;
    }
    
    
    public function savePResetToken($username, $token) {
        $saved = 0;
        
        if ($username <> "") :
            $v = $this->verifyUserExist($username);
            $v1 = $this->verifyAdminExist($username);
            if ($v == 0 && $v1 == 0) :
                //Does not Exist
                $this->logTrail($this::INFO, "Error: Password Reset Request failed! User [$username] is Invalid.", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: User [$username] is Invalid.";
            elseif ($v == 2 || $v1 == 2):
                //Blocked
                $this->logTrail($this::INFO, "Error: Password Reset Request failed! User [$username] is blocked.", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: User <$username] is blocked. Please Contact the Administrator";           
            else:
                //User Is Okay
                $qry = "INSERT INTO tbl_pchange_request (USERNAME, REQUEST_TOKEN, IS_USED, REQUEST_DATE, USE_DATE) 
                 VALUES(?, ?, 0, NOW(), '0000-00-00 00:00:00')";
                $saved = $this->db->insert($qry, "ss", $username, $token);
                if ($saved > 0):
                    $this->logTrail($this::INFO, "Password Reset Request successful for User [$username].", $this::STATUS_PASSED, get_client_ip_env()); 
                    return 1;
                else:
                    $this->logTrail($this::INFO, "Error: Password Reset Request failed for User [$username]. Unable to Initiate a reset at this time", $this::STATUS_FAILED, get_client_ip_env()); 
                    return "Error: Unable to Initiate a reset at this time!";
                endif;
            endif;
        else:
            $this->logTrail($this::INFO, "Error: Password Reset Request failed! User [$username]is Invalid.", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] is Invalid!";
        endif;
        
        //return $saved;
    }
    
    
    public function sendEmail($to, $from, $subject, $message) {
        if ($to <> "" && $subject <> "" && $message <> "") :
//            $headers = "From: " . strip_tags($from) . "\r\n";
//            $headers .= "Reply-To: ". strip_tags($from) . "\r\n";
//            $headers .= "MIME-Version: 1.0\r\n";
//            $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
//            
//            return mail($to, $subject, nl2br($message), $headers);
            
            $mail = new PHPMailer;
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = 'mail.kkontech.com';  // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = 'outbound@kkontech.com';                 // SMTP username
            $mail->Password = 'outbound123';                           // SMTP password
            $mail->SMTPSecure = 'ssl';                            // Enable TLS encryption, `ssl` also accepted
            $mail->Port = 465;                                    // TCP port to connect to

            $mail->setFrom($from, 'FiberOne');
            $mail->addAddress($to);               // Name is optional
            $mail->addReplyTo($from, 'FiberOne');
            $mail->isHTML(true);                                  // Set email format to HTML

            $mail->Subject = $subject;
            $mail->Body    = nl2br($message);
            $mail->AltBody = nl2br($message);

            return $mail->send();
            
        else:
            return 0;
        endif;
    }
    
    
    public function getCannedMessage($purpose="") {
        $msg = "";
        $ad = "";
        if ($purpose <> "") :
            $purpose = mysqli_real_escape_string($this->db, $purpose);
            $ad = " WHERE PURPOSE LIKE '$purpose'";
        endif;
            
        $qry = "SELECT CANNED_MSG FROM `tbl_canned_msg` $ad LIMIT 1";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $msg = $row->CANNED_MSG;
        }
        
        return $msg;
    }
    
    public function verifyPResetToken($username, $token) {
        $is_okay = 0;
        
        if ($username <> "") :
            $qry = "SELECT * FROM tbl_pchange_request WHERE USERNAME = ? AND REQUEST_TOKEN = ? AND IS_USED = 0 AND
                     NOW() < DATE_ADD(REQUEST_DATE, INTERVAL 24 HOUR)";
            $some_sth = $this->db->select($qry, 'ss', $username, $token);
            $rows = $some_sth->num_rows();
            if ($rows)
                $is_okay = 1;
        endif;
        
        return $is_okay;
    }
    
    public function changePackage($username, $pckid, $pck, $adminName) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        if ($username <> "" && $pck <> "" && $pckid > 0) :
            $upd = "UPDATE rm_users SET srvid = ? 
                     WHERE USERNAME = ?";
            $this->db->execute_query($upd, "is", $pckid, $username)? null : $all_query_ok=false; 
            
            $ddate = date("Y-m-d");
            $ins = "INSERT INTO rm_changesrv (id, username, newsrvid, newsrvname, scheduledate, requestdate, `status`,
                    transid, requested) VALUES
                    (NULL, ?, ?, ?, ?, ?, 1, '', ?)"; 
            $this->db->insert($ins, 'sissss', $username, $pckid, $pck, $ddate, $ddate, "eservice-$adminName")? null : $all_query_ok=false;
            
            $all_query_ok ? $this->db->commit() : $this->db->rollback();
            
        else:
            $all_query_ok = FALSE;
        endif;
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok) :   
            $this->logTrail($this::SERVICE_CHANGE, "$adminName successfully changed $username service to $pck ($pckid)", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::SERVICE_CHANGE, "$adminName failed trying to change $username service to $pck ($pckid)", $this::STATUS_FAILED, get_client_ip_env()); 
            return 0;
        endif;
    }
    
    
    public function resetPassword($username, $password, $token, $is_admin=0) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        //echo "U: $all_query_ok ". $this->db->error . "<br/>" ;
        if ($username <> "" && $password <> "") :
            $upd = "UPDATE tbl_pchange_request SET IS_USED = 1, USE_DATE = NOW() 
                     WHERE USERNAME = ? AND REQUEST_TOKEN = ? AND IS_USED = 0";
            $this->db->execute_query($upd, "ss", $username, $token)? null : $all_query_ok=false; 
                  //echo "U1: $all_query_ok ". $this->db->error . "<br/>" ;     
            if ($is_admin) :              
                $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                        SELECT USERNAME, `PASSWORD`, ?, NOW(), 1 FROM tbl_admins WHERE USERNAME LIKE ?"; 
                $this->db->insert($ins, 'ss', sha1($password), $username)? null : $all_query_ok=false;
                //echo "U2: $all_query_ok ". $this->db->error . "<br/>" ;
                
                $upd = "UPDATE tbl_admins SET `PASSWORD` = ? WHERE USERNAME LIKE ?";
            else:                
                $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                        SELECT USERNAME, `PASSWORD`, ?, NOW(), 0 FROM tblclients WHERE USERNAME LIKE ?";
                $this->db->insert($ins, 'ss', sha1($password), $username)? null : $all_query_ok=false;
                
                $upd = "UPDATE tblclients SET `PASSWORD` = ? WHERE USERNAME LIKE ?";
            endif;
            
            $this->db->execute_query($upd, 'ss', sha1($password), $username)? null : $all_query_ok=false;
            //echo "U3: $all_query_ok ". $this->db->error . "<br/>" ;
            
            $all_query_ok ? $this->db->commit() : $this->db->rollback();
            
        else:
            $all_query_ok = FALSE;
        endif;
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok) :     
            $this->logTrail($this::PASSWORD_CHANGE, "Password Reset successful for User [$username]", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::PASSWORD_CHANGE, "Error: Password Reset failed for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return 0;
        endif;
    }    
    
    
    public function verifyPassword($username, $password, $is_admin = 0) {
        $all_query_ok=true; // our control variable
        //$this->db->autocommit(FALSE);
        $ret = 0;
        $tb = ($is_admin)? "tbl_admins" : "tblclients";
                
        if ($username <> "" && $password <> "") :
            $strsql = "SELECT * FROM $tb 
                     WHERE USERNAME = ? AND PASSWORD = ?";
            $some_sth = $this->db->select($strsql, "ss", $username, sha1($password)); 
            
            $rows = $some_sth->num_rows();
            if ($rows) {
                return 1;
            } else {
                return 0;
            }
            
        endif;
        
        return (-1);
    } 
    
    
    public function verifyRadiusPassword($username, $password) {

        if ($username <> "" && $password <> "") :
            $strsql = "SELECT * FROM radcheck 
                     WHERE username = ? AND `value` = ? AND `attribute`='Cleartext-Password'";
            $some_sth = $this->db->select($strsql, "ss", $username, $password); 
            
            $rows = $some_sth->num_rows();
            if ($rows) {
                return 1;
            } else {
                return 0;
            }
            
        endif;
        
        return (-1);
    }
    
    
    public function changePassword($username, $password, $old_pass) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        $ret = 0;
                
        if ($username <> "" && $password <> "") :
            $strsql = "SELECT * FROM tblclients
                     WHERE USERNAME LIKE ? AND PASSWORD = ?";
            $some_sth = $this->db->select($strsql, "ss", $username, sha1($old_pass)); 
            
            $rows = $some_sth->num_rows();
            if ($rows) {
            
                $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                        SELECT USERNAME, `PASSWORD`, ?, NOW(), 0 FROM tblclients WHERE USERNAME LIKE ?";
                $this->db->insert($ins, 'ss', sha1($password), $username)? null : $all_query_ok=false;

                $upd = "UPDATE tblclients SET `PASSWORD` = ? WHERE USERNAME LIKE ?";
                $this->db->execute_query($upd, 'ss', sha1($password), $username)? null : $all_query_ok=false;

                $all_query_ok ? $this->db->commit() : $this->db->rollback();
            
            } else {
                $all_query_ok=false;
                $ret = -1;
            }
            
        endif;
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok) :       
            $this->logTrail($this::PASSWORD_CHANGE, "User [$username] changed password successfully", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::PASSWORD_CHANGE, "Error: Password change failed for User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return $ret;
        endif;
    }
    
    public function changeAdminPassword($username, $password, $old_pass) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        $ret = 0;
                
        if ($username <> "" && $password <> "") :
            $strsql = "SELECT * FROM tbl_admins
                     WHERE USERNAME = ? AND PASSWORD = ?";
            $some_sth = $this->db->select($strsql, "ss", $username, sha1($old_pass)); 
            
            $rows = $some_sth->num_rows();
            if ($rows) {
            
                $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                        SELECT USERNAME, `PASSWORD`, ?, NOW(), 1 FROM tbl_admins WHERE USERNAME LIKE ?";
                $this->db->insert($ins, 'ss', sha1($password), $username)? null : $all_query_ok=false;

                $upd = "UPDATE tbl_admins SET `PASSWORD` = ? WHERE USERNAME LIKE ?";
                $this->db->execute_query($upd, 'ss', sha1($password), $username)? null : $all_query_ok=false;

                $all_query_ok ? $this->db->commit() : $this->db->rollback();
            
            } else {
                $all_query_ok=false;
                $ret = -1;
            }
            
        endif;
        
        $this->db->autocommit(TRUE);
        
        if ($all_query_ok) :       
            $this->logTrail($this::PASSWORD_CHANGE, "Admin [$username] changed Password successfully", $this::STATUS_PASSED, get_client_ip_env()); 
            return 1;
        else:
            $this->logTrail($this::PASSWORD_CHANGE, "Error: Password Reset failed for Admin [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
            return $ret;
        endif;
    }
    
    public function loadUsage($username, $startdate = "", $stopdate = "") {
        $rec = array();
        
        if ($username <> "") :
            if ($startdate == "") :
                $startdate = date("Y")."-".date("m")."-01 00:00:00";
                $stopdate = date("Y-m-d H:i:s");
            endif;
            $up = $down = 0;
            $qry = "SELECT acctstarttime, acctstoptime,  
                        acctsessiontime, acctinputoctets, acctoutputoctets, acctterminatecause
                    FROM `radacct`
                    WHERE username LIKE ? AND acctstarttime BETWEEN $startdate AND $stopdate 
                    ORDER BY acctstarttime ASC";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                $rec[] = array("ON"=>$row->acctstarttime, "OFF"=>$row->acctstoptime, 
                            "DURATION"=>  convertSecToStr($row->acctsessiontime), 
                            "UP"=> formatBytes($row->acctinputoctets), "DOWN"=> formatBytes($row->acctoutputoctets),
                            "REASON"=> $row->acctterminatecause);
            }
        endif;
        
        return $rec;
    }
    
    public function loadCurrentUsage($username) {
        $rec = array();
        
        if ($username <> "") :
            $up = $down = 0;
            $qry = "SELECT acctstarttime, acctstoptime,  
                        acctsessiontime, acctinputoctets, acctoutputoctets, acctterminatecause
                    FROM `radacct` r
                    WHERE username LIKE ? AND acctstarttime BETWEEN 
                    SUBDATE((SELECT expiration FROM rm_users WHERE username = r.username), INTERVAL 1 MONTH) AND NOW() 
                    ORDER BY acctstarttime ASC";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                $rec[] = array("ON"=>$row->acctstarttime, "OFF"=>$row->acctstoptime, 
                            "DURATION"=>  convertSecToStr($row->acctsessiontime), 
                            "UP"=> formatBytes($row->acctinputoctets), "DOWN"=> formatBytes($row->acctoutputoctets),
                            "REASON"=> $row->acctterminatecause);
            }
        endif;
        
        return $rec;
    }
    
    public function loadCurrentUsageTotal($username) {
        $rec = array();
        
        if ($username <> "") :
            $up = $down = 0;
            $qry = "SELECT SUM(acctsessiontime) AS 'TIMEONLINE', SUM(acctinputoctets) AS 'INPUTOCTETS', 
                        SUM(acctoutputoctets) AS 'OUTPUTOCTETS'
                    FROM `radacct` r
                    WHERE username LIKE ? AND acctstarttime BETWEEN 
                    SUBDATE((SELECT expiration FROM rm_users WHERE username = r.username), INTERVAL 1 MONTH) AND NOW() 
                    ORDER BY acctstarttime ASC";
            $some_sth = $this->db->select($qry, 's', $username);
            $rows = $some_sth->num_rows();
            while ( $row = $some_sth->fetch_object() ) {
                $rec[] = array("DURATION"=>  convertSecToStr($row->TIMEONLINE), 
                            "UP"=> formatBytes($row->INPUTOCTETS), "DOWN"=> formatBytes($row->OUTPUTOCTETS));
            }
        endif;
        
        return $rec;
    }
    
    
    public function getMonthlyDataUsageAsString($username="", $month="", $year="") {
        $ret = $rac = array();
        
        $ad = "";
        if ($username <> "") :
            $user = mysql_escape_string($username);
            $ad = " WHERE username LIKE '$user'";
        endif;
        
        $month = ($month <> "")? $month : date("m");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE MONTH(acctstarttime) = '$month'";
            else
                $ad .= " AND MONTH(acctstarttime) = '$month'";
        endif;
        
        $year = ($year <> "")? $year : date("Y");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE YEAR(acctstarttime) = '$year'";
            else
                $ad .= " AND YEAR(acctstarttime) = '$year'";
        endif;
        $qry = "SELECT DAY(acctstarttime) AS 'DAY', SUM(acctinputoctets) AS 'UP', SUM(acctoutputoctets) AS 'DOWN', 
                    SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' FROM `radacct` 
                    $ad 
                    GROUP BY DAY(acctstarttime)
                    ORDER BY DAY(acctstarttime)"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
//            $ret[$row->DAY] = array("DAY"=>$row->DAY, 
//                                    "UP"=>$row->UP, 
//                                    "DOWN"=> $row->DOWN, 
//                                    "TOTAL"=> $row->TOTAL);
            $down = bytes($row->DOWN, "MiB", '%01.2f');
            $up = bytes($row->UP, "MiB", '%01.2f');
            $total = bytes($row->TOTAL, "MiB", '%01.2f');
            $ret[1][] = "[{$row->DAY}, $down]";
            $ret[2][] = "[{$row->DAY}, $up]";
            $ret[3][] = "[{$row->DAY}, $total]";
        }
       	
        if ($rows) :
            $rac[1] = "[" . implode(", ", $ret[1]) . "]";
            $rac[2] = "[" . implode(", ", $ret[2]) . "]";
            $rac[3] = "[" . implode(", ", $ret[3]) . "]";
        endif;
        
        return $rac;
    }
    
    
    public function getMonthlyDataUsageMobile($username="", $month="", $year="") {
        $ret = $rac = array();
        
        $ad = "";
        if ($username <> "") :
            $user = mysql_escape_string($username);
            $ad = " WHERE username LIKE '$user'";
        endif;
        
        $month = ($month <> "")? $month : date("m");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE MONTH(acctstarttime) = '$month'";
            else
                $ad .= " AND MONTH(acctstarttime) = '$month'";
        endif;
        
        $year = ($year <> "")? $year : date("Y");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE YEAR(acctstarttime) = '$year'";
            else
                $ad .= " AND YEAR(acctstarttime) = '$year'";
        endif;
        $qry = "SELECT DAY(acctstarttime) AS 'DAY', SUM(acctinputoctets) AS 'UP', SUM(acctoutputoctets) AS 'DOWN', 
                    SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' FROM `radacct` 
                    $ad 
                    GROUP BY DAY(acctstarttime)
                    ORDER BY DAY(acctstarttime)"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        $lbl = [];
        while ( $row = $some_sth->fetch_object() ) {
            $down = bytes($row->DOWN, "MiB", '%01.2f');
            $up = bytes($row->UP, "MiB", '%01.2f');
            $total = bytes($row->TOTAL, "MiB", '%01.2f');
            $ret[1][$row->DAY] = $down;
            $ret[2][$row->DAY] = $up;
            $ret[3][$row->DAY] = $total;
            $lbl[] = $row->DAY;
        }
        
        if ($rows) :
            $rac['down'] = json_encode($ret[1]); // "{{v:" . implode("}, {v:", $ret[1]) . "}}";
            $rac['up'] = json_encode($ret[2]); // v:" . implode("}, {v:", $ret[2]) . "}]";
            $rac['total'] = json_encode($ret[3]); // "[{v:" . implode("}, {v:", $ret[3]) . "}]";
            $rac['label'] = json_encode($lbl); // v:" . implode("}, {v:", $lbl) . "}]";
        else:
            $rac['down'] = json_encode([0,0]);
            $rac['up'] = json_encode([0,0]);
            $rac['total'] = json_encode([0,0]);
            $rac['label'] = json_encode([1,2]);
        endif;
        
        return $rac;
    }
    public function getMonthlyDataUsage($username="", $month="", $year="") {
        $ret = $rac = array();
        
        $ad = "";
        if ($username <> "") :
            $user = mysql_escape_string($username);
            $ad = " WHERE username LIKE '$user'";
        endif;
        
        $month = ($month <> "")? $month : date("m");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE MONTH(acctstarttime) = '$month'";
            else
                $ad .= " AND MONTH(acctstarttime) = '$month'";
        endif;
        
        $year = ($year <> "")? $year : date("Y");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE YEAR(acctstarttime) = '$year'";
            else
                $ad .= " AND YEAR(acctstarttime) = '$year'";
        endif;
        $qry = "SELECT DAY(acctstarttime) AS 'DAY', SUM(acctinputoctets) AS 'UP', SUM(acctoutputoctets) AS 'DOWN', 
                    SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' FROM `radacct` 
                    $ad 
                    GROUP BY DAY(acctstarttime)
                    ORDER BY DAY(acctstarttime)"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
//            $ret[$row->DAY] = array("DAY"=>$row->DAY, 
//                                    "UP"=>$row->UP, 
//                                    "DOWN"=> $row->DOWN, 
//                                    "TOTAL"=> $row->TOTAL);
            $down = bytes($row->DOWN, "MiB", '%01.2f');
            $up = bytes($row->UP, "MiB", '%01.2f');
            $total = bytes($row->TOTAL, "MiB", '%01.2f');
            $ret[1][] = array($row->DAY, $down);
            $ret[2][] = array($row->DAY, $up);
            $ret[3][] = array($row->DAY, $total);
        }
        
//        if ($rows) :
//            $rac[1] = "[" . implode(", ", $ret[1]) . "]";
//            $rac[2] = "[" . implode(", ", $ret[2]) . "]";
//            $rac[3] = "[" . implode(", ", $ret[3]) . "]";
//        endif;
        
        return $ret;
    }
    
    public function getTotalMonthlyDataUsage($username="", $month="", $year="") {
//        $ret = $rac = array();
        
        $ad = "";
        if ($username <> "") :
            $user = mysql_escape_string($username);
            $ad = " WHERE username LIKE '$user'";
        endif;
        
        $month = ($month <> "")? $month : date("m");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE MONTH(acctstarttime) = '$month'";
            else
                $ad .= " AND MONTH(acctstarttime) = '$month'";
        endif;
        
        $year = ($year <> "")? $year : date("Y");
        if ($month) :
            if ($ad == "")
                $ad = " WHERE YEAR(acctstarttime) = '$year'";
            else
                $ad .= " AND YEAR(acctstarttime) = '$year'";
        endif;
        $qry = "SELECT SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' FROM `radacct` 
                    $ad "; //echo $qry;
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $total = bytes($row->TOTAL, "GiB", '%01.2f');
        }
        
        return $total;
    }
    
    public function getYearlyDataUsage($username="", $nmonth=11) {
        $rac = [];
        
        $ad = "";
        if ($username <> "") :
            $user = mysql_escape_string($username);
            $ad = " AND username LIKE '$user'";
        endif;
        
        $qry = "SELECT MONTH(acctstarttime) AS 'MON', MONTHNAME(acctstarttime) AS 'MON_NAME', YEAR(acctstarttime) AS 'YR', 
            SUM(acctinputoctets + acctoutputoctets) AS 'TOTAL' 
FROM `radacct` 
WHERE 1=1 $ad 
AND acctstarttime <= NOW() and acctstarttime >= DATE_ADD(NOW(),INTERVAL - $nmonth MONTH)
GROUP BY YEAR(acctstarttime), MONTH(acctstarttime) "; //echo $qry;
        $some_sth = $this->db->select($qry);
        while ( $row = $some_sth->fetch_object() ) {
            $total = bytes($row->TOTAL, "GiB", '%01.2f');
            $rac[] = ["mon" => $row->MON, "month" => $row->MON_NAME, "yr" => $row->YR, "total" => $total ];
        }
        
        return $rac;
    }
    
    
    public function loadRadUser($user="", $is_enabled=-1, $is_linked = -1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysql_escape_string($user);
            $ad = " WHERE username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            if ($ad == "")
                $ad = " WHERE username $in_not (SELECT RAD_USERNAME FROM tblclients)";
            else
                $ad .= " AND username $in_not (SELECT RAD_USERNAME FROM tblclients)";
        endif;
        $qry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration 
                FROM `rm_users` ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->username] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "IS_ENABLED" => $row->enableuser);
        }
        
        return $ret;
    }
    
    
    public function loadRadUserObject($user="", $is_enabled=-1, $is_linked = -1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysql_escape_string($user);
            $ad = " WHERE username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            if ($ad == "")
                $ad = " WHERE ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                         AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
            else
                $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tblclients)) 
                         AND (username $in_not (SELECT RAD_USERNAME FROM tbl_subaccount)) )";
        endif;
        $qry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration, company, createdon, lastlogoff, address, city, state,
                    uplimit, downlimit, comblimit
                FROM `rm_users` ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return $ret;
    }
    
    
    public function radUserIsLinked($username) {
//        $isLinked = 0;
        
        //User Exist?
        $qry = "SELECT * FROM `rm_users` WHERE username LIKE ?";
        $some_sth = $this->db->select($qry, "s", $username);
        $rows = $some_sth->num_rows();
        
        if ($rows) :
            //Is Linked?
            $qry = "SELECT USERNAME FROM tblclients WHERE RAD_USERNAME LIKE ? 
                    UNION
                    SELECT tc.USERNAME FROM tbl_subaccount sa 
                    LEFT JOIN tblclients tc ON sa.CID=tc.ID WHERE sa.RAD_USERNAME LIKE ?";
            $some_sth = $this->db->select($qry, "s", $username);
            $rows = $some_sth->num_rows();
            if ($rows) :
                $row = $some_sth->fetch_object();
                return "Success: [$username] already linked to " . $row->USERNAME;
            else: 
                return "Error: Username [$username] is yet to be linked";
            endif;
        else:
            return "Error: Username [$username] does not exist on the Radius Server";
        endif;
    }
    
    public function safeToDelete($username) {
//        $isLinked = 0;
        
        //User Exist?
        $qry = "SELECT * FROM `rm_users` WHERE username LIKE ?";
        $some_sth = $this->db->select($qry, "s", $username);
        $rows = $some_sth->num_rows();
        
        if ($rows) :
            
        else:
            
        endif;
    
    }
    
    
    public function loadAdminRec($user="", $is_enabled=-1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysql_escape_string($user);
            $ad = " WHERE tad.USERNAME LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE tad.IS_ENABLED = $is_enabled";
            else
                $ad .= " AND tad.IS_ENABLED = $is_enabled";
        endif;
        if ($ad == ""):
            $ad = " WHERE tad.USERNAME NOT LIKE 'opmat'";
        else:
            $ad .= " AND tad.USERNAME NOT LIKE 'opmat'";
        endif;
        $qry = "SELECT tad.AID, tad.USERNAME, tad.FULLNAME, tad.MOBILE, tad.EMAIL, tad.ACCESS_LEVEL, 
                    tal.ADMIN_TYPE, tad1.FULLNAME AS 'ADDED_BY', tad.IS_ENABLED, tad.`READONLY` 
                FROM `tbl_admins` tad
                LEFT JOIN tbl_admin_level tal ON tad.ACCESS_LEVEL = tal.ID
                LEFT JOIN tbl_admins tad1 ON tad.ADDED_BY = tad1.AID $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->USERNAME] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->FULLNAME, 
                        "LASTNAME"=> "", "RAD_USERNAME"=>"",
                        "MOBILE"=> $row->MOBILE, "EMAIL"=> $row->EMAIL,
                        "ADMIN_TYPE"=> $row->ADMIN_TYPE, "ACCESS_LEVEL"=>$row->ACCESS_LEVEL,
                        "ENABLED" => $row->IS_ENABLED, "UID" => $row->AID, "READONLY" => $row->READONLY);
        }
        
        return $ret;
    }
    
    
    public function loadClientRec($user="", $is_enabled=-1, $days_to_expiration=-1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad = " WHERE tc.USERNAME LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE tc.IS_ENABLED = $is_enabled";
            else
                $ad .= " AND tc.IS_ENABLED = $is_enabled";
        endif;
        $qry = "SELECT tc.ID, tc.USERNAME, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname 
                FROM tblclients tc
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->USERNAME] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID);
        }
        
        return $ret;
    }
    
    
    public function loadERPRec($user="", $erpid=0, $is_prov=-1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysqli_real_escape_string($this->db, $user);
            $ad = " WHERE RAD_USERNAME LIKE '$user'";
        endif;
        if ($is_prov <> -1 && ($is_prov == 1 || $is_prov == 0) ) :
            if ($ad == "")
                $ad = " WHERE PROVISIONED = $is_prov";
            else
                $ad .= " AND PROVISIONED = $is_prov";
        endif;
        if ($erpid > 0) :
            if ($ad == "")
                $ad = " WHERE ERPID = $erpid";
            else
                $ad .= " AND ERPID = $erpid";
        endif;
        $qry = "SELECT ID, ERPID, RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, ADDRESS, 
                CITY, STATE, EMAIL, TELEPHONE, PACKAGE, srvid, `PASSWORD`, IPADDY, DATEINITITATED, 
                PROVISIONED, DATEPROVISIONED 
                FROM `tbl_erpdata` e
                LEFT JOIN rm_services s ON e.PACKAGE=s.srvname $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->ERPID] = array("ERPID"=>$row->ERPID, "ID"=>$row->ID, 
                "RAD_USERNAME"=> $row->RAD_USERNAME, "FIRSTNAME"=>$row->FIRSTNAME,
                "LASTNAME"=> $row->LASTNAME, "COMPANY"=> $row->COMPANY,
                "ADDRESS"=> $row->ADDRESS, "CITY"=>$row->CITY, "STATE"=>$row->STATE,
                "EMAIL" => $row->EMAIL, "TELEPHONE" => $row->TELEPHONE, "SRVID" => $row->srvid,
                "PASSWORD" => $row->PASSWORD, "IPADDY" => $row->IPADDY, "PACKAGE" => $row->PACKAGE, 
                "DATEINITITATED" => $row->DATEINITITATED, "PROVISIONED" => $row->PROVISIONED,
                "DATEPROVISIONED" => $row->DATEPROVISIONED);
        }
        
        return $ret;
    }
    
    public function updateERPProvStat($erpid, $raduser) {
        $done = 0;
        
        if ($erpid > 0) {
            $upd = "UPDATE `tbl_erpdata` SET PROVISIONED=1, DATEPROVISIONED=NOW()
                     WHERE ERPID=?";
            $rett = $this->db->execute_query($upd, "i", $erpid);
            if ($rett) { $done = 1; }
            $qry = "SELECT * FROM tbl_erp WHERE ERPID=?";
            $some_sth = $this->db->select($qry, "i", $erpid);
            $rows = $some_sth->num_rows();
            if ($rows <= 0):
                $ins = "INSERT IGNORE INTO tbl_erp (ERPID, RAD_USERNAME)
                        VALUES (?, ?)";
                $this->db->insert($ins, 'is', $erpid, $raduser);
            endif;
        }
        
        return $done;
    }
    
    
    public function loadMainAccounts($user = "", $is_enabled = 1) {
        $ret = array();
        $ad = "";
        if ($user <> "") :
            $user = mysql_escape_string($user);
            $ad = " WHERE tc.USERNAME LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        
        $qry = "SELECT tc.ID, tc.USERNAME, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser 
                FROM tblclients tc
                INNER JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                $ad";
        $some_sth = $this->db->select($qry);
        
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->USERNAME] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID);
        }
        
        return $ret;
    }
    
    
    public function delSubAccount($userid=0, $raduser="", $adminUser="") {
        if ($userid == 0 || $raduser == "") :
            $this->logTrail($this::INFO, "($adminUser attempt Delete SubAccount) Error: [$raduser] User ID and the Service ID cannot be empty", $this::STATUS_FAILED, get_client_ip_env()); 
            echo "Error: User ID and the Service ID cannot be empty";
        else :
            $qry = "DELETE FROM tbl_subaccount WHERE CID = ? AND RAD_USERNAME = ?";
            $rett = $this->db->execute_query($qry, "is", $userid, $raduser);
            
            if ($rett) :
                $this->logTrail($this::INFO, "($adminUser attempt Delete SubAccount) Success: User [$raduser] Service ID Unlinked!!", $this::STATUS_PASSED, get_client_ip_env()); 
                echo "Success: Service ID Unlinked!";
            else:
                $this->logTrail($this::INFO, "($adminUser attempt Delete SubAccount) Error: User [$raduser] Unlink Process Failed!", $this::STATUS_FAILED, get_client_ip_env()); 
                echo "Error: Unlink Process Failed!";
            endif;
        endif;
    }
    
    
    public function loadSubAccount($userid=0) {
        $ret = array();
        
        $ad = "";
        if ($userid <> 0) :
            $ad = " WHERE sa.CID = '$userid'";
        endif;
        $qry = "SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname 
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username  -- tc
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->USERNAME][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID);
        }
        
        return $ret;
    }
    
    
    public function loadLowData() {
        $ret = array();
        

        $qry = "SELECT tc.ID, tc.USERNAME, tc.ID, tc.RAD_USERNAME, ru.firstname, lastname, mobile, tc.PUSHID, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'PRIMARY' AS 'ACC_TYPE', comblimit, @too :=((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                @ti := ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT, @rem := (comblimit - (@too+@ti) ) AS 'BAL', tp.LOW_LEVEL, (tp.LOW_LEVEL>@rem) AS IS_LOW
                FROM tblclients tc 
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID WHERE tp.LOW_LEVEL>0 AND tc.RAD_USERNAME NOT IN (
		SELECT USERNAME FROM tbl_lowdatalog WHERE DATE(SENDDATE) = DATE(NOW())) AND tc.IS_ENABLED=1
            UNION
                
                SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, tc.PUSHID, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'SUB-ACCOUNT' AS 'ACC_TYPE', comblimit, @tooo :=((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                @tio := ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT, @remo := (comblimit - (@tooo+@tio) ) AS 'BAL', tp.LOW_LEVEL, (tp.LOW_LEVEL>@remo) AS IS_LOW
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID WHERE tp.LOW_LEVEL>0 AND sa.RAD_USERNAME NOT IN (
		SELECT USERNAME FROM tbl_lowdatalog WHERE DATE(SENDDATE) = DATE(NOW())) AND tc.IS_ENABLED=1
                    
                ORDER BY USERNAME, ACC_TYPE, RAD_USERNAME"; //echo $qry;
        $some_sth = $this->db->select($qry);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $bal = $row->comblimit - ($row->TOTALOUTPUT + $row->TOTALINPUT);
            if ( ($bal>0) && ($row->LOW_LEVEL > $bal) ) :
                $ret[] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                            "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                            "MOBILE"=> $row->mobile, "EMAIL"=> $row->email, "LIMITCOMB" => $row->limitcomb,
                            "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                            "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
                            "ACC_TYPE" => $row->ACC_TYPE, "BALANCE" => $bal, "COMBLIMIT" => $row->comblimit,
                            "AMOUNT" => $row->AMOUNT, "LOW_LEVEL" => $row->LOW_LEVEL, "PUSHID" => $row->PUSHID);
            endif;
        }
        
        return $ret;
    }
    
    
    public function loadAllRADAccount($userid=0) {
        $ret = array();
        
        $ad = $add = "";
        if ($userid <> 0) :
            $ad = " WHERE sa.CID = '$userid'";
            $add = " WHERE tc.ID = '$userid'";
        endif;
        //echo "$ad  $add";
        $qry = "SELECT tc.ID, tc.USERNAME, tc.ID, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'PRIMARY' AS 'ACC_TYPE', comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT
                FROM tblclients tc 
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $add
            
                UNION
                
                SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'SUB-ACCOUNT' AS 'ACC_TYPE', comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $ad 
                    
                ORDER BY USERNAME, ACC_TYPE, RAD_USERNAME"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $bal = $row->comblimit - ($row->TOTALOUTPUT + $row->TOTALINPUT);
            $ret[$row->USERNAME][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email, "LIMITCOMB" => $row->limitcomb,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
                        "ACC_TYPE" => $row->ACC_TYPE, "BALANCE" => $bal, "COMBLIMIT" => $row->comblimit,
                        "AMOUNT" => $row->AMOUNT);
        }
        
        return $ret;
    }
    
    
    public function loadAllRADAccountByUsername($userid="") {
        $ret = array();
        
        $ad = $add = "";
        if ($userid <> "") :
            $ad = " WHERE LCASE(tc.USERNAME) LIKE LCASE('$userid')";
            $add = " WHERE LCASE(tc.USERNAME) LIKE LCASE('$userid')";
        endif;
        //echo "$ad  $add";
        $qry = "SELECT tc.ID, tc.USERNAME, tc.ID, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'PRIMARY' AS 'ACC_TYPE', comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT
                FROM tblclients tc 
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $add
            
                UNION
                
                SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'SUB-ACCOUNT' AS 'ACC_TYPE', comblimit, ((SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALOUTPUT,
                ((SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ru.username) - 
                    (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ru.username)) AS TOTALINPUT,
                    rs.limitcomb, tp.AMOUNT
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
                LEFT JOIN tbl_plans tp ON rs.srvid=tp.SRVID $ad 
                    
                ORDER BY USERNAME, ACC_TYPE, RAD_USERNAME"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $bal = $row->comblimit - ($row->TOTALOUTPUT + $row->TOTALINPUT);
            $ret[strtolower($row->USERNAME)][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email, "LIMITCOMB" => $row->limitcomb,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
                        "ACC_TYPE" => $row->ACC_TYPE, "EXPIRATION_FORMAT" => date("d-M-Y h:i:s A", strtotime($row->expiration)), 
                        "BALANCE" => $bal, "COMBLIMIT" => $row->comblimit, "AMOUNT" => $row->AMOUNT);
        }
        return $ret;
    }
    
    
    public function loadRADAccountByUsername($userid="") {
        $ret = array();
        
        $ad = $add = "";
        if ($userid <> "") :
            $low = strtolower($userid);
            $ad = " WHERE sa.RAD_USERNAME LIKE '$userid' OR sa.RAD_USERNAME LIKE '$low'";
            $add = " WHERE tc.USERNAME LIKE '$userid' OR tc.USERNAME LIKE '$low'";
        endif;
        
        $qry = "SELECT tc.ID, tc.USERNAME, tc.ID, tc.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'PRIMARY' AS 'ACC_TYPE'
                FROM tblclients tc 
                LEFT JOIN rm_users ru ON tc.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $add
            
                UNION
                
                SELECT tc.ID, tc.USERNAME, sa.CID, sa.RAD_USERNAME, ru.firstname, lastname, mobile, 
                    email, staticipcpe, expiration, tc.IS_ENABLED, ru.enableuser, rs.srvid, rs.srvname, 
                    'SUB-ACCOUNT' AS 'ACC_TYPE'
                FROM tbl_subaccount sa
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                LEFT JOIN rm_users ru ON sa.RAD_USERNAME = ru.username
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad 
                    
                ORDER BY USERNAME, ACC_TYPE, RAD_USERNAME"; 
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->RAD_USERNAME][] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "ENABLED" => $row->IS_ENABLED, "UID" => $row->ID,
                        "ACC_TYPE" => $row->ACC_TYPE);
        }
        
        return $ret;
    }
    
    public function loadOnlineUsers() {
        $ret = array();
        
        $qry = "SELECT * FROM `radacct` WHERE acctstoptime IS NULL";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return $ret;
    }
    
    public function loadStatess() {
        $ret = array();
        
        $qry = "SELECT NAME AS 'STATE' FROM `state` ";
        $some_sth = $this->db->select($qry);

        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row->STATE;
        }
        
        return $ret;
    }
    
    
    public function createClientOnAll($username, $password, $firstname, $lastname, $company, $email, $phoneNo, 
                    $addy, $city, $state, $planID, 
                    $srvid, $srvname, $expiry_date, $download, $upload, $total, $ip, $adminID, $adminUser) {
        $user_exist = $this->verifyUserExist($username);
        
//        parent::setUsername($adminUser);
        $this->setUsername($adminUser);
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] already Exist";
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] already Exist and Account is Disabled";
        else :
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Start to create Service ID [$username]. ", $this::STATUS_PASSED, get_client_ip_env()); 
            $all_query_ok=true; // our control variable
            $this->db->autocommit(FALSE);
            $ret = 0; $chk = "";  
            
            //Create in Radius
            $mpass = md5($password);
            $ins = "INSERT INTO rm_changesrv
                    (username, newsrvid, newsrvname, scheduledate, requestdate, `status`, requested)
                    VALUES
                    (?, ?, ?, NOW(), NOW(), 1, ?)";
            $this->db->insert($ins, 'ssss', $username, $srvid, $srvname, "eService_$adminUser")? null : $all_query_ok=false;
            $chk .= "CH1:".$all_query_ok."||";
            $ins = "INSERT INTO radcheck (UserName, Attribute, op, `Value`)
                        VALUES (?, 'Cleartext-Password', ':=', ?), "
                        . " (?, 'Simultaneous-Use', ':=', '1')";
            $this->db->insert($ins, 'sss', $username, $password, $username)? null : $all_query_ok=false;            
            $chk .= "CH2:".$all_query_ok."||";
            $dd = date("Y-m-d");
            $ins = "INSERT INTO rm_users (
   		      username, `password`, downlimit, uplimit, comblimit, firstname, lastname, company,
   		      phone, mobile, email, address, city, zip, country, state, `comment`, mac, expiration,
   		      enableuser, usemacauth, uptimelimit, srvid, staticipcm, staticipcpe, ipmodecm, ipmodecpe,
   		      createdon, acctype, createdby, taxid, maccm, credits, `owner`, groupid, custattr, poolidcm, poolidcpe,
   		      contractid, contractvalid, gpslong, gpslat, alertemail, alertsms, lang)
                      VALUES (
   		      ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '', 'Nigeria', ?, '', '', ?, " .
   		      "'1', 0, '0', ?, '', ?, 0, 2, '$dd', '0', " .
   		      "?, '', '', '0.00', 'admin', '1', '', '0', '0', " .
   		      "'', '', '0', '0', 1, 1, 'English' )";
            $useme = "eService_$adminUser";
            $this->db->insert($ins, 'ssiiissssssssssiss', $username, $mpass, $download, $upload, $total, $firstname, 
                        $lastname, $company, $phoneNo, $phoneNo, $email, $addy, $city, $state, $expiry_date,
                        $srvid, $ip, $useme)? null : $all_query_ok=false;
//            $ins = "INSERT INTO rm_users (
//   		      username, password, downlimit, uplimit, comblimit, firstname, lastname, company,
//   		      phone, mobile, email, address, city, zip, country, state, comment, mac, expiration,
//   		      enableuser, usemacauth, uptimelimit, srvid, staticipcm, staticipcpe, ipmodecm, ipmodecpe,
//   		      createdon, acctype, createdby, taxid, maccm, credits, owner, groupid, custattr, poolidcm, poolidcpe,
//   		      contractid, contractvalid, gpslong, gpslat, alertemail, alertsms, lang)
//                      VALUES (
//   		      'opma', '96f2a3e3588c33f5c0c10c9f5d27602a', 0, 0, 0, 'Opeyemi', 'Matiluko', 'OPMat Inc', '8059463559', '8059463559', 'sad@lmu.edu.ng', 'LU Staff Qtrs', 'Omu-Aran', '', 'Nigeria', 'Kwara', '', '', '2019-01-24',
//   		      '1', 0, '0', '40', '', '11.23.234.23', 0, 2, NOW(), '0',
//   		      'eService_opmat', '', '', '0.00', 'admin', '1', '', '0', '0',
//   		      '', '', '0', '0', 1, 1, 'English' )";
//            $this->db->insert($ins);
            $chk .= "CH3:".$all_query_ok."||";
            //create in eservice
            $ins = "INSERT INTO tblclients (USERNAME, `PASSWORD`, RAD_USERNAME, IS_ENABLED, DATE_CREATED, ADDED_BY)
                VALUES (?, ?, ?, 1, NOW(), ?)";
            $this->db->insert($ins, 'sssi', $username, sha1($password), $username, $adminID)? null : $all_query_ok=false;
            $chk .= "CH4:".$all_query_ok."||";
            if ($all_query_ok) {
                $this->db->commit();
                $this->logTrail($this::NEW_USER, "($adminUser attempt) Success: Created Service ID [$username] on eService and Radius!", $this::STATUS_PASSED, get_client_ip_env()); 
                $this->db->autocommit(TRUE);
                return "Success: Created Service ID [$username] on eService and Radius!$chk";
            } else {
//                $this->db->error();
                $this->db->rollback();
                $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to create Service ID [$username] on eService and Radius!", $this::STATUS_FAILED, get_client_ip_env()); 
                $this->db->autocommit(TRUE);
                return "Error: Failed to create Service ID [$username] on eService and Radius!$chk";
            }
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to create Service ID [$username]. Something Went Wrong", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Something went Wrong";
            
        endif;
    }
    
    public function deleteUserRadius($username, $adminUser) {
        $this->setUsername($adminUser);
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        
        $strsql = "DELETE FROM rm_changesrv WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM radcheck WHERE UserName = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM rm_users WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Success: Service ID [$username] deleted on Radius!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Service ID [$username] deleted on Radius!";
        } else {
//                $this->db->error();
            $this->db->rollback();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to delete Service ID [$username] on Radius!", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Failed to delete Service ID [$username] on Radius!";
        }
    }
    
    public function deleteUserRadnClient($username, $adminUser) {
        $this->setUsername($adminUser);
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        
        $strsql = "DELETE FROM rm_changesrv WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM radcheck WHERE UserName = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM tblclients WHERE RAD_USERNAME = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM rm_users WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Success: Service ID [$username] deleted on Radius and eService!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Service ID [$username] deleted on Radius and eService!";
        } else {
//                $this->db->error();
            $this->db->rollback();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to delete Service ID [$username] on Radius and eService!", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Failed to delete Service ID [$username] on Radius and eService!";
        }
    }
    
    public function deleteUserRadnSubAcct($username, $adminUser) {
        $this->setUsername($adminUser);
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        
        $strsql = "DELETE FROM rm_changesrv WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM radcheck WHERE UserName = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM rm_users WHERE username = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        $strsql = "DELETE FROM tbl_subaccount WHERE RAD_USERNAME = ?";
        $this->db->execute_query($strsql, "s", $username)? null : $all_query_ok=false;
        
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Success: Service ID [$username] deleted on Radius and eService (Sub-Account)!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Service ID [$username] deleted on Radius and eService (Sub-Account)!";
        } else {
//                $this->db->error();
            $this->db->rollback();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::NEW_USER, "($adminUser attempt) Error: Failed to delete Service ID [$username] on Radius and eService (Sub-Account)!", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Failed to delete Service ID [$username] on Radius and eService (Sub-Account)!";
        }
    }
    
    
    public function erpProvisioning($erpid, $raduser, $company, $firstname='', $lastname='',
                        $addy='', $city='', $state='', $email='', $phone='', $package='', 
                        $ip='0.0.0.0', $pass='') {
        
        $qry = "SELECT * FROM `tbl_erpdata` WHERE ERPID=? OR RAD_USERNAME=?";
        $some_sth = $this->db->select($qry, "is", $erpid, $raduser);
        $rows = $some_sth->num_rows();
        if ($rows):
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$raduser] or ERP ID [$erpid] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$raduser] or ERP ID [$erpid] already Exist"];
        endif;
        
        $user_exist = $this->verifyUserExist($raduser);
        $username = $raduser;
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$username] already Exist"];
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return ["STATUS"=>0, "MSG"=> "Error: User [$username] already Exist and Account is Disabled"];
        else :
            $ins = "INSERT INTO tbl_erpdata (ERPID, RAD_USERNAME, FIRSTNAME, LASTNAME, COMPANY, ADDRESS,
                        CITY, STATE, EMAIL, TELEPHONE, PACKAGE, PASSWORD, IPADDY, DATEINITITATED)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
            $in_id = $this->db->insert($ins, 'issssssssssss', $erpid, strtolower($raduser), $company, $lastname,
                        $company, $addy, $city, $state, $email, $phone, $package, $pass, $ip);
            
            if ($in_id) :
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Success: User [$username] provisioned!", $this::STATUS_PASSED, get_client_ip_env()); 
                return ["STATUS"=>1, "MSG"=> "Success: User [$username] provisioned!"];
            else:
                $this->logTrail($this::NEW_USER, "(ERP API attempt) Error: Unable to provision User [$username]", $this::STATUS_FAILED, get_client_ip_env()); 
                return ["STATUS"=>0, "MSG"=> "Error: Unable to provision User [$username]"];
            endif;
            
        endif;
        
    }
    
    
    public function createClient($username, $password, $raduser, $adminID, $subraduser=array()) {
        $user_exist = $this->verifyUserExist($username);
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] already Exist";
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: User [$username] already Exist and Account is Disabled";
        else :
            $ins = "INSERT INTO tblclients (USERNAME, PASSWORD, RAD_USERNAME, IS_ENABLED, DATE_CREATED, ADDED_BY)
                    VALUES (?, ?, ?, 1, NOW(), ?)";
            $in_id = $this->db->insert($ins, 'sssi', $username, sha1($password), $raduser, $adminID);
            
            $rett = 0;
            if (count($raduser) >= 1) :
                $rett = $this->createSubAccount($in_id, $adminID, $subraduser);
            endif;
            
            if ($in_id) :
                if (count($raduser) >= 1) :
                    if ($rett):
                        $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Success: User [$username] Created and Linked to Service ID [$raduser] and other sub-accounts!", $this::STATUS_PASSED, get_client_ip_env()); 
                        return "Success: User [$username] Created and Linked to Service ID [$raduser] and other sub-accounts!";
                    else:
                        $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Success: User [$username] Created but unable to link sub-account, please verify and try adding later!", $this::STATUS_PASSED, get_client_ip_env()); 
                        return "Success: User [$username] Created but unable to link sub-account, please verify and try adding later!";
                    endif;
                endif;
                $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Success: User [$username] Created and Linked to Service ID [$raduser>!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: User [$username] Created and Linked to Service ID [$raduser>!";
            else:
                $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create and link User [$username>", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create and link User [$username>";
            endif;
        endif;
        
    }
    
    
    public function createSubAccount($uid, $adminID, $raduser=array()) {
        
        if (count($raduser) < 1) :
            return 0;
        else :
            $ret = 0;
            foreach ($raduser as $k=>$v) :
                if (trim($v)) :
                    $ins = "INSERT INTO tbl_subaccount (CID, RAD_USERNAME, DATE_CREATED, ADDED_BY) 
                            VALUES (?, ?, NOW(), ?)";
                    $in_id = $this->db->insert($ins, 'isi', $uid, $v, $adminID);
                    
                    if ($in_id) {
                        $ret = 1;
                        $this->logTrail($this::NEW_USER, "($adminID attempt) Service ID [$v] created on eService (Sub-Account)!", $this::STATUS_PASSED, get_client_ip_env()); 
                    }
                endif;
            endforeach;
            
            return $ret;
            
        endif;
        
    }
    
    
    public function editUser($username, $raduser, $password="", $enabled=1, $rad_enabled = 1) {
        $adstr = "";
        
        if ($password != ""):
            $adstr .= ", `PASSWORD` = '" . sha1($password) . "'";

            $ins = "INSERT INTO tbl_pchange_log (USERNAME, OLD_PASS, NEW_PASS, DATE_CHANGED, IS_ADMIN)
                    SELECT USERNAME, `PASSWORD`, ?, NOW(), 0 FROM tblclients WHERE USERNAME LIKE ?";
            $this->db->insert($ins, 'ss', sha1($password), $username);
        endif;
        if ($raduser != ""):
            $adstr .= ", `RAD_USERNAME` = '" . $raduser . "'";
        endif;

        $upd = "UPDATE tblclients SET IS_ENABLED=? $adstr WHERE USERNAME=?"; 
        $rett = $this->db->execute_query($upd, "is", $enabled, $username);

        if ($rett) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: User ($username) Update Completed", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Update Completed!";
        else:
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error! User ($username) Update Failed", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Update failed!";
        endif;

    }
    
    public function editRadUser($username, $firstname, $lastname, $passwd, $company, $addy, $city, $state, 
                            $email, $phoneNo, $staticipcpe) {
        $all_query_ok=true; // our control variable
        $this->db->autocommit(FALSE);
        $addon = "";
        
        if ($passwd != "") :
            $strsql = "UPDATE radcheck SET `value`=? 
                WHERE username = ? AND `attribute`='Cleartext-Password'";
            $this->db->execute_query($strsql, "ss", $passwd, $username)? null : $all_query_ok=false;
            $addon = ", `password` = MD5('$passwd')";
        endif;
        
        $strsql = "UPDATE rm_users SET firstname=?, lastname=?, company=?, 
                phone=?, mobile=?, email=?, address=?, city=?, state=?, staticipcpe=? $addon WHERE username = ?";
        $this->db->execute_query($strsql, "sssssssssss", $firstname, $lastname, $company, 
                    $phoneNo, $phoneNo, $email, $addy, $city, $state, $staticipcpe, $username)? null : $all_query_ok=false;
        
        if ($all_query_ok) {
            $this->db->commit();
            $this->db->autocommit(TRUE);            
            $this->logTrail($this::INFO, "($adminUser attempt) Success: Service ID [$username] updated on Radius!", $this::STATUS_PASSED, get_client_ip_env()); 
            return "Success: Service ID [$username] updated on Radius!";
        } else {
//                $this->db->error();
            $this->db->rollback();
            $this->db->autocommit(TRUE);
            $this->logTrail($this::INFO, "($adminUser attempt) Error: Failed to update Service ID [$username] on Radius!", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Failed to update Service ID [$username] on Radius!";
        }
    }
    
    
    public function createAdmin($username, $password, $fullname, $email, $mobile, $access, $adminID, $is_enabled=1, $is_readonly=0) {
        $user_exist = $this->verifyAdminExist($username);
        
        if ($user_exist == 1) :
            $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: Admin User [$username] already Exist", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Admin User [$username] already Exist";
        elseif ($user_exist == 2) :
            $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: Admin User [$username] already Exist and Account is Disabled", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Admin User [$username] already Exist and Account is Disabled";
        else :
            $ins = "INSERT INTO tbl_admins (USERNAME, `PASSWORD`, FULLNAME, EMAIL, MOBILE, ACCESS_LEVEL,
                            IS_ENABLED, DATE_ADDED, ADDED_BY, `READONLY`)
                    VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), ?, ?)";//echo $ins;echo "<br/>($username, $password, $fullname, $email, $mobile, $access, $adminID, $is_enabled=1, $is_readonly=0)";
            $in_id = $this->db->insert($ins, 'sssssiiii', $username, sha1($password), $fullname, $email,
                            $mobile, $access, $is_enabled, $adminID, $is_readonly);
            if ($in_id) :
                $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Success: Admin User [$username] Created!", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Admin User [$username] Created!";
            else:
                $this->logTrail($this::NEW_USER, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create Admin User [$username>", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Unable to create Admin User [$username>";
            endif;
        endif;
        
    }
    
    
    public function editAdmin($username, $password="", $fullname="", $email="", $mobile="", $enabled=1, $usergroup=-1, $is_readonly=0) {
        //$user_exist = $this->verifyAdminExist($username);
        $adstr = "";
        
        //if ($user_exist == 1 || ($user_exist == 2)) :
            if ($password != ""):
                $adstr .= ", `PASSWORD` = '" . sha1($password) . "'";
            endif;
            if ($usergroup != -1 && is_numeric($usergroup) ): //echo "<$usergroup>";
                $adstr .= ", `ACCESS_LEVEL` = $usergroup";
            endif;
            
            $upd = "UPDATE tbl_admins SET FULLNAME=?, EMAIL=?, MOBILE=?, IS_ENABLED=?, `READONLY`=? $adstr WHERE USERNAME=?"; //echo $upd;
            $rett = $this->db->execute_query($upd, "sssiis", $fullname, $email, $mobile, $enabled, $is_readonly, $username);
            
            if ($rett) :
                echo "Success: Update Completed!";
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Update to Admin [$username] completed", $this::STATUS_PASSED, get_client_ip_env());
            else:
                echo "Error: Update failed!";
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Update to Admin [$username] Failed", $this::STATUS_FAILED, get_client_ip_env());
            endif;
//        else :
//            return "Error: Admin User [$username] does not Exist";        
//        endif;
    }
    
    
    public function setAdminStatus($username, $status=1) {
        if ($status == 0 || $status == 1) :
            $upd = "UPDATE tbl_admins SET IS_ENABLED=? WHERE USERNAME=?";
            $this->db->execute_query($upd, "is", $status, $username);
            
            //verify
            $qry = "SELECT * FROM tbl_admins WHERE USERNAME=? AND IS_ENABLED=?";
            $some_sth = $this->db->select($qry, "si", $username, $status);
            $rows = $some_sth->num_rows();
            if ($rows){
                $this->logTrail($this::INFO, "Admin [$username] status changed to $status", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Status set Successfully";
            } else {
                $this->logTrail($this::INFO, "Error occurred changing Admin [$username] status to $status", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Status Change Failed!";
            }
        else:
            $this->logTrail($this::INFO, "Error occurred changing Admin [$username] status to $status. Invalid Status [$status]", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Invalid Status!";
        endif;
        
    }
    
    
    public function setUserStatus($username, $status=1) {
        if ($status == 0 || $status == 1) :
            $upd = "UPDATE tblclients SET IS_ENABLED=? WHERE USERNAME=?";
            $this->db->execute_query($upd, "is", $status, $username);
            
            //verify
            $qry = "SELECT * FROM tblclients WHERE USERNAME=? AND IS_ENABLED=?";
            $some_sth = $this->db->select($qry, "si", $username, $status);
            $rows = $some_sth->num_rows();
            if ($rows) {
                $this->logTrail($this::INFO, "User [$username] status changed to $status", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Status set Successfully";
            } else {
                $this->logTrail($this::INFO, "Error occurred changing User [$username] status to $status", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Status Change Failed!";
            }
        else:
            return "Error: Invalid Status!";
        endif;
        
    }
    
    
    public function listServices($package=-1, $is_enabled=-1) {
        $ret =array();
        
        $ad = "";
        if ($package <> -1 && is_int($package)):
            $ad = " WHERE srvid = $package";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableservice = $is_enabled";
            else
                $ad .= " AND enableservice = $is_enabled";
        endif;
        
        $qry = "SELECT srvid, srvname, limitcomb, limitexpiration, monthly, 
                        enableservice, descr, trafficunitcomb,
                        (SELECT COUNT(PLAN) FROM tbl_plans tp WHERE tp.SRVID=rs.srvid) AS 'NPLANS'
                FROM `rm_services` rs $ad"; //resetcounters, 
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        if ($rows) :
            while ($row = $some_sth->fetch_object()) :
                $ret[$row->srvid] = array("PACKAGE_ID"=>$row->srvid, "PACKAGE"=>$row->srvname, 
                            "LIMITCOMB"=>$row->limitcomb, "LIMIT_EXPIRY"=>$row->limitexpiration, 
                            "MONTHLY"=>$row->monthly, /*"RESET_COUNTER"=>$row->resetcounters,*/ 
                            "IS_ENABLED"=>$row->enableservice, "DESCRIPTION"=>$row->descr, "NPLANS"=> $row->NPLANS, 
                            "DATA_SIZE"=>$row->trafficunitcomb);
            endwhile;
        endif;
        
        
        return $ret;
    }
    
    public function createPlan($plan, $package, $data, $amount, $validity, $description, $adminID) {
        $user_exist = $this->verifyPlanExist($plan, $package);
        
        if ($user_exist == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Plan [$plan] already Exist", $this::STATUS_FAILED, get_client_ip_env());
            return "Error: Plan [$plan] already Exist";
        elseif ($user_exist == 2) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Plan [$plan] already Exist under selected Package/Service but it is Disabled", $this::STATUS_FAILED, get_client_ip_env());
            return "Error: Plan [$plan] already Exist under selected Package/Service but it is Disabled";
        else :
            $qry = "INSERT INTO tbl_plans (PLAN, SRVID, DATA_VOLUME, AMOUNT, VALIDITY, CAN_SPILLOVER, 
                        DESCRIPTION, IS_ENABLED, DATE_ADDED, ADDED_BY)
                    VALUES (?, ?, ?, ?, ?, 0, ?, 1, NOW(), ?)";
            $in_id = $this->db->insert($qry, 'siidisi', $plan, $package, $data, $amount, $validity, 
                            $description, $adminID);
            if ($in_id) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Plan [$plan] Created under Selected Service!", $this::STATUS_PASSED, get_client_ip_env());
                return "Success: Plan [$plan] Created under Selected Service!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to create Plan [$plan]", $this::STATUS_FAILED, get_client_ip_env());
                return "Error: Unable to create Plan [$plan>";
            endif;
        endif;
    }
    
    
    public function editPlan($planid, $plan="", $srvid=0, $data=0, $amount=0, $validity=0, $description="", $enabled=1) {
        //$user_exist = $this->verifyAdminExist($username);
        $adstr = "";
        
        //if ($user_exist == 1 || ($user_exist == 2)) :
            if ($description != ""):
                $adstr .= ", `DESCRIPTION` = '" . $description . "'";
            endif;
            if ($plan != ""):
                $adstr .= ", `PLAN` = '" . $plan . "'";
            endif;
//            if ($srvid != 0):
//                $adstr .= ", `SRVID` = '" . $srvid . "'";
//            endif;
            if ($data >= 0):
                $adstr .= ", `DATA_VOLUME` = '" . $data . "'";
            endif;
            if ($amount != 0):
                $adstr .= ", `AMOUNT` = '" . $amount . "'";
            endif;
            if ($validity != 0):
                $adstr .= ", `VALIDITY` = '" . $validity . "'";
            endif;
            
            $upd = "UPDATE tbl_plans SET IS_ENABLED=? $adstr WHERE PLAN_ID=?"; //echo $upd; exit();
            $rett = $this->db->execute_query($upd, "ii", $enabled, $planid);
            
            if ($rett) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: Service/Plan [$plan] Update Completed!", $this::STATUS_PASSED, get_client_ip_env());
                echo "Success: Update Completed!";
            else:
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Service/Plan [$plan] Update failed!", $this::STATUS_FAILED, get_client_ip_env());
                echo "Error: Update failed!";
            endif;
//        else :
//            return "Error: Admin User [$username] does not Exist";        
//        endif;
    }
    
    
    public function loadPlans($package=-1, $plan=0, $is_enabled=-1) {
        $rec = array();
        
        $ad = "";
        if ($package<>-1):
            $ad = " WHERE tp.SRVID = $package";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE tp.IS_ENABLED = $is_enabled";
            else
                $ad .= " AND tp.IS_ENABLED = $is_enabled";
        endif;
        
        if ($plan > 0) :
            if ($ad == "")
                $ad = " WHERE tp.PLAN_ID = $plan";
            else
                $ad .= " AND tp.PLAN_ID = $plan";
        endif;
        
//        if ($plan <> 0 && $package <> 0) :
        $qry = "SELECT PLAN_ID, PLAN, tp.SRVID, DATA_VOLUME, tp.AMOUNT, tp.VALIDITY, tp.CAN_SPILLOVER, 
                    tp.DESCRIPTION, tp.IS_ENABLED, tp.DATE_ADDED, tp.ADDED_BY, rs.srvname, rs.descr, tp.PLANCODE
                FROM `tbl_plans` tp 
                LEFT JOIN rm_services rs ON tp.SRVID=rs.srvid 
                $ad";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[$row->PLAN_ID] = array("PLAN_ID"=>$row->PLAN_ID, "PLAN"=>$row->PLAN, "SRVID"=>$row->SRVID, 
                    "DATA"=>$row->DATA_VOLUME, "AMOUNT"=>$row->AMOUNT, "VALIDITY"=>$row->VALIDITY, 
                    "CAN_SPILLOVER"=>$row->CAN_SPILLOVER, "PLAN_DESC"=>$row->DESCRIPTION, 
                    "IS_ENABLED"=>$row->IS_ENABLED, "DATE_ADDED"=>$row->DATE_ADDED, "ADDED_BY"=>$row->ADDED_BY,
                    "PACKAGE"=>$row->srvname, "PACKAGE_DESC"=>$row->descr, "PLANCODE"=>$row->PLANCODE,
                    "ODATA"=>formatBytes($row->DATA_VOLUME, 2, FALSE),"DATAV"=>$row->DATA_VOLUME);

        }
//        endif;
        
        return $rec;
    }
    
    
    public function setPlanStatus($plan, $status=1) {
        if ($status == 0 || $status == 1) :
            $upd = "UPDATE tbl_plans SET IS_ENABLED=? WHERE PLAN_ID=?";
            $this->db->execute_query($upd, "ii", $status, $plan);
            
            //verify
            $qry = "SELECT * FROM tbl_plans WHERE PLAN_ID=? AND IS_ENABLED=?";
            $some_sth = $this->db->select($qry, "si", $plan, $status);
            $rows = $some_sth->num_rows();
            if ($rows) {
                $this->logTrail($this::INFO, "Plan [$plan] status changed to $status", $this::STATUS_PASSED, get_client_ip_env()); 
                return "Success: Status set Successfully";
            } else {
                $this->logTrail($this::INFO, "Error occurred changing Plan [$plan] status to $status", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Status Change Failed!";
            }
        else:
            $this->logTrail($this::INFO, "Error occurred changing Plan [$plan] status to $status. Invalid Status", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: Invalid Status!";
        endif;
        
    }
    
    public function saveExpirationLog($username, $fullname, $expiration) {
        $qry = "INSERT INTO tbl_expirationlog (USERNAME, CLIENTNAME, EXPIRATIONDATE, SENDDATE)
                    VALUES (?, ?, ?, NOW())";
        $in_id = $this->db->insert($qry, 'sss', $username, $fullname, $expiration);
        if ($in_id) :
            return "Success: Log Saved!";
        else:
            return "Error: Unable to save Log";
        endif;
    }
    
    public function saveLowDataLog($username, $databal) {
        $qry = "INSERT INTO tbl_lowdatalog (USERNAME, DATA_LEFT, SENDDATE)
                    VALUES (?, ?, NOW())";
        $in_id = $this->db->insert($qry, 'ss', $username, $databal);
        if ($in_id) :
            return "Success: Log Saved!";
        else:
            return "Error: Unable to save Log";
        endif;
    }
    
    
    public function getExpiringAccounts($days2expiry=0) {
        $rec = array();
        /*
        $qry = "SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE tc.IS_ENABLED=1 AND expiration BETWEEN NOW() AND ADDDATE(NOW(), INTERVAL ? DAY)
                UNION
                SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE tc.IS_ENABLED=1 AND expiration BETWEEN NOW() AND ADDDATE(NOW(), INTERVAL ? DAY)
                ";
         * 
         */
        $qry = "SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE tc.IS_ENABLED=1 AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND ?
                UNION
                SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE tc.IS_ENABLED=1 AND DATEDIFF(expiration,NOW()) BETWEEN 0 AND ?
                ";
        $some_sth = $this->db->select($qry, "ii", $days2expiry, $days2expiry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME,
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "EXPIRATION" => $row->expiration);

        }
        
        return $rec;
    }
    
    
    public function getExpiredAccounts() {
        $rec = array();
        
        $qry = "SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, tc.RAD_USERNAME 
                    FROM rm_users ru
                LEFT JOIN tblclients tc ON ru.username = tc.RAD_USERNAME
                WHERE tc.IS_ENABLED=1 AND expiration <= NOW()
                UNION
                SELECT firstname, lastname, tc.USERNAME, expiration, email, mobile, enableuser, sa.RAD_USERNAME 
                    FROM rm_users ru
		LEFT JOIN tbl_subaccount sa ON ru.username = sa.RAD_USERNAME
                LEFT JOIN tblclients tc ON sa.CID = tc.ID
                WHERE tc.IS_ENABLED=1 AND expiration <= NOW()
                ";
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $rec[] = array("USERNAME"=>$row->USERNAME, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "EXPIRATION" => $row->expiration);

        }
        
        return $rec;
    }
    
    public function getExpirationDate($raduser) {
        $exp = "";
        $qry = "SELECT expiration FROM rm_users WHERE username = ?";
        $some_sth = $this->db->select($qry, "s", $raduser);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $exp = $row->expiration;
        }
        
        return $exp;
    }
    
    public function logPayDirectReversal($param) {
        //$txnid = $param["TRANX_ID"];
        
        //check if reversal has already been logged
        $qry = "SELECT * FROM tbl_tranx_reversal WHERE TRANX_ID=?";
        $some_sth = $this->db->select($qry, "s", $param["TRANX_ID"]);
        $rows = $some_sth->num_rows();
        
        if ($rows < 1) :
            //Log Record
            $keys = implode(", ", array_keys($param));
            $qry = "INSERT INTO tbl_tranx_reversal (TRANX_ID, RAD_USERNAME, PAY_REFERENCE, ORIGINAL_PAY_REFERENCE, 
                        RET_REF_NO, ORIGINAL_RET_REF_NO, APPR_AMOUNT) 
                 VALUES(?, ?, ?, ?, ?, ?, ?)";
            $saved = $this->db->insert($qry, "ssssssd", $param["TRANX_ID"], $param["RAD_USERNAME"], 
                            $param["PAY_REFERENCE"], $param["ORIGINAL_PAY_REFERENCE"], $param["RET_REF_NO"], 
                            $param["ORIGINAL_RET_REF_NO"], $param["APPR_AMOUNT"]);
            $this->logTrail($this::PAYMENT, "Transaction [{$param['TRANX_ID']}] reversed", $this::STATUS_PASSED, get_client_ip_env()); 
            if ($saved > 0)
                return 1;
            else
                return 0;
        endif;
    }
    
    
    public function renewSubscription($raduser, $data_volume, $limitcomb, 
            $expiration, $tranx_id="", $is_expd=1) {
        $done = 0;
        
        $up = $down = $tot = $ntot = 0;
        $qry = "SELECT
                (SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ?) AS 'DOWN',
                (SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ?) AS 'UP',
                (SELECT comblimit FROM rm_users WHERE username = ?) AS 'COMB'";
        $some_sth = $this->db->select($qry, "sssss", $raduser, $raduser, $raduser, $raduser, $raduser);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $down = $row->DOWN;
            $up = $row->UP;
            $diff = ($row->COMB - ($down + $up));
            $combb = ( $diff<0 )? ($row->COMB+($diff * -1)) : ($row->COMB) ;
            $tot = ($is_expd)? ($down + $up) : ($combb);
        }
        
        $ntot = ($limitcomb)? ($tot + $data_volume) : $tot;
        $renewData = bytes($data_volume, "GiB", '%01.2f %s');
        $expiry_date = date("d-M-Y H:i:s", strtotime($expiration));
        
        $upd = "UPDATE rm_users SET uplimit = '$up', downlimit = '$down', comblimit = '$ntot', expiration=?
                WHERE username = ?";
        $rett = $this->db->execute_query($upd, "ss", $expiration, $raduser);
        if ($rett) :
            $done = 1;
            $upd = "UPDATE tbl_tranx SET DB_UPDATED=1 WHERE TRANX_ID=?";
            $rett = $this->db->execute_query($upd, "s", $tranx_id);
            $this->logTrail($this::RENEWAL_AUTO, "({$_SESSION[$this->sid.'username']} attempt) Success: Auto Renewal of User $raduser completed! Data Added: $renewData; New Expiry Date: $expiry_date", $this::STATUS_PASSED, get_client_ip_env()); 
        else:
            $this->logTrail($this::RENEWAL_AUTO, "({$_SESSION[$this->sid.'username']} attempt) Error: Auto Renewal of User $raduser Failed!", $this::STATUS_FAILED, get_client_ip_env()); 
        endif;
        
        return $done;
    }
    
    
    public function renewSubscriptionManual($raduser, $data_volume, $limitcomb, 
            $expiration, $tranx_id="", $adminUser="", 
            $is_extend_only=0, $is_expd=1) {
        $done = 0;
        
        $up = $down = $tot = $ntot = 0;
        $qry = "SELECT
                (SELECT SUM(acctoutputoctets) FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(dlbytes), 0) FROM rm_radacct WHERE username = ?) AS 'DOWN',
                (SELECT SUM(acctinputoctets)  FROM radacct WHERE username = ?) - 
                (SELECT COALESCE(SUM(ulbytes), 0) FROM rm_radacct WHERE username = ?) AS 'UP',
                (SELECT comblimit FROM rm_users WHERE username = ?) AS 'COMB'";
        $some_sth = $this->db->select($qry, "sssss", $raduser, $raduser, $raduser, $raduser, $raduser);
//        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $down = $row->DOWN;
            $up = $row->UP;
//            $tot = $down + $up;
            $diff = ($row->COMB - ($down + $up));
            $combb = ( $diff<0 )? ($row->COMB+($diff * -1)) : ($row->COMB) ;
            $tot = ($is_expd)? ($down + $up) : ($combb);
        }

        $ext = ($is_extend_only)? "Extension" : "Renewal";
        
        $ntot = ($limitcomb)? ($tot + $data_volume) : $tot;
        
        $renewData = bytes($data_volume, "GiB", '%01.2f %s');
        $expiry_date = date("d-M-Y H:i:s", strtotime($expiration));
        
        $upd = "UPDATE rm_users SET uplimit = '$up', downlimit = '$down', comblimit = '$ntot', expiration=?
                WHERE username = ?";
        $rett = $this->db->execute_query($upd, "ss", $expiration, $raduser);
        if ($rett) :
            $done = 1;
            if ($tranx_id != ""):
                $upd = "UPDATE tbl_tranx SET DB_UPDATED=1 WHERE TRANX_ID=?";
                $rett = $this->db->execute_query($upd, "s", $tranx_id);
            endif;
            $this->logTrail($this::RENEWAL_MANUAL, "($adminUser attempt) Success: Manual $ext of User $raduser completed by $adminUser! Data Added: $renewData; New Expiry Date: $expiry_date", $this::STATUS_PASSED, get_client_ip_env()); 
        else:
            $this->logTrail($this::RENEWAL_MANUAL, "($adminUser attempt) Error: Manual $ext of User $raduser by $adminUser Failed!", $this::STATUS_FAILED, get_client_ip_env()); 
        endif;
        
        return $done;
    }
    
    
    public function logManualRenewal($raduser, $exp_date, $nu_exp_date, $data, $extendonly, $admin) {
        
        $qry = "INSERT INTO tbl_manrenewal (RAD_USERNAME, EXPIRY_DATE, NEW_EXPIRY_DATE, 
                    ADDED_DATA, EXTEND_ONLY, ADMIN, DATEDONE) 
                 VALUES(?, ?, ?, ?, ?, ?, NOW())";
        $saved = $this->db->insert($qry, "ssssii", $raduser, $exp_date, $nu_exp_date, $data, $extendonly, $admin);
        
        if ($saved > 0)
            return 1;
        else
            return 0;
    }
    
    
     
    public function loadUserDet4Update($radusername)  {
        $ret = array();
       $qry = "SELECT ru.username, expiration, ru.srvid, rs.srvname, tp.PLAN_ID, tp.PLAN, 
                    tp.DATA_VOLUME, tp.AMOUNT, tp.VALIDITY, rs.limitcomb, firstname, lastname, email
                FROM rm_users ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid
		LEFT JOIN tbl_plans tp ON rs.srvid = tp.SRVID
                WHERE username LIKE ?"; 
       $some_sth = $this->db->select($qry, 's', $radusername);
       $rows = $some_sth->num_rows();
       while ($row = $some_sth->fetch_object()):
           $ret = array("RAD_USERNAME"=>$row->username, "EXPIRATION"=>$row->expiration, "SRVID"=>$row->srvid,
                        "SERVICE"=>$row->srvname, "PLAN"=>$row->PLAN, "PLAN_ID"=>$row->PLAN_ID, "EMAIL"=>$row->email,
                        "DATA_VOLUME"=>$row->DATA_VOLUME, "AMOUNT"=>$row->AMOUNT, "VALIDITY"=>$row->VALIDITY,
                        "LIMITCOMB"=>$row->limitcomb, "FULLNAME"=>$row->firstname." ".$row->lastname);
       endwhile;

       return $ret;
    }
    
    
    public function saveInitTranx($tranx_id, $raduser, $exp_date, $amt, $curr, $nmonths=1) {
        $ddate = date("Y-m-d H:i:s");
        $qry = "INSERT INTO tbl_tranx (TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, NMONTHS) 
                 VALUES(?, ?, ?, ?, ?, ?, ?)";
        $saved = $this->db->insert($qry, "sssdssi", $tranx_id, $raduser, $exp_date, $amt, $curr, $ddate, $nmonths);
        $this->logTrail($this::PAYMENT, "Transaction [$tranx_id] for =N=$amt initiated for user [$raduser]; ", $this::STATUS_PASSED, get_client_ip_env()); 
        if ($saved > 0)
            return 1;
        else
            return 0;
    }
    
    
    public function saveTranxResp($tranx_id, $pay_ref, $amt, $curr, $status_code, $status_msg, $nu_expd, $pdate, $gway_name, $app_date, $cardno, $retrefno, $receiptno="") {
        $done = 0;
        $upd = "UPDATE tbl_tranx SET PAY_REFERENCE=?, APPR_AMOUNT=?, APPR_CURRENCY=?, STATUS_CODE=?,
                STATUS_MSG=?, NU_EXPIRY_DATE=?, PAY_DATE=?, PAY_GATEWAY=?, APPR_DATE=?, CARDNO=?, RET_REF_NO=?, RECEIPT_NO=?
                WHERE TRANX_ID=?";
        $rett = $this->db->execute_query($upd, "sdsssssssssss", $pay_ref, $amt, $curr, $status_code, 
                                        $status_msg, $nu_expd, $pdate, $gway_name, $app_date, $cardno, $retrefno, $receiptno, $tranx_id);
        $this->logTrail($this::PAYMENT, "Transaction [$tranx_id] for =N=$amt response for user [$raduser]; STATUS: $status_msg; GW: $gway_name; PAY_DATE: $pdate", $this::STATUS_PASSED, get_client_ip_env()); 
        if ($rett) $done = 1;
        
        return $done;
    }
    
    
    public function getTranx4Verification($tranx_id) {
        $exp = array();
        $qry = "SELECT TRANX_ID, tx.RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, 
                    REQUEST_DATE, NMONTHS, STATUS_CODE, DB_UPDATED, tep.ERPID, rs.srvname, tp.ERP_CODE 
                 FROM tbl_tranx tx 
                 LEFT JOIN tbl_erp tep ON tx.RAD_USERNAME=tep.RAD_USERNAME
                 LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                 LEFT JOIN rm_services rs ON ru.srvid=rs.srvid
                 LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                 WHERE TRANX_ID = ?";
        $some_sth = $this->db->select($qry, "s", $tranx_id);
        //$rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $exp = array("TRANS_ID"=>$row->TRANX_ID, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "EXPIRY_DATE"=>$row->EXPIRY_DATE, "REQ_AMOUNT"=>$row->REQ_AMOUNT, 
                        "REQ_CURRENCY"=>$row->REQ_CURRENCY, "REQUEST_DATE"=>$row->REQUEST_DATE,
                        "NMONTHS"=>$row->NMONTHS, "STATUS_CODE" => $row->STATUS_CODE, "ERP_CODE" => $row->ERP_CODE,
                        "DB_UPDATED"=>$row->DB_UPDATED, "ERPID"=>$row->ERPID, "PACKAGE"=>$row->srvname);
        }
        
        return $exp;
    }
    
    public function getTransactions($raduser="", $has_status = 0, $limit = 0) {
        $exp = array();
        $adc = $lim = "";
        if ($limit > 0) {
            $lim = " LIMIT $limit";
        }
        
        if (is_array($raduser)) :
            $tmp = array();
            foreach ($raduser as $k=>$v):
                $tmp[] = "'" . mysqli_real_escape_string($this->db, $v) . "'";
            endforeach;
            if (count($tmp)) :
                $adc .= " WHERE RAD_USERNAME IN (" . implode(",", $tmp) . ")";
            endif;
        else:
            if ($raduser != ""):
                $adc .= " WHERE RAD_USERNAME = '" . mysqli_real_escape_string($this->db, $raduser) . "'";
            endif;
        endif;
        
        if ($has_status) :
            $adc = ($adc == "")? " WHERE STATUS_CODE IS NOT NULL" : $adc . " AND STATUS_CODE IS NOT NULL";
        endif;
                
        $qry = "SELECT TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, PAY_GATEWAY,
                    PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, NU_EXPIRY_DATE, PAY_DATE, rs.srvname, DB_UPDATED
                FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid $adc
                 ORDER BY REQUEST_DATE DESC $lim";  
 
        $some_sth = $this->db->select($qry);  
        //$rows = $some_sth->num_rows(); 
      //try {
        while ( $row = $some_sth->fetch_object() ) { //print_r($row);
            $exp[] = array("TRANS_ID"=>$row->TRANX_ID, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "EXPIRY_DATE"=>$row->EXPIRY_DATE, "REQ_AMOUNT"=>$row->REQ_AMOUNT, 
                        "REQ_CURRENCY"=>$row->REQ_CURRENCY, "REQUEST_DATE"=>$row->REQUEST_DATE,
                        "PAY_REF"=>$row->PAY_REFERENCE, "APPR_AMOUNT"=>$row->APPR_AMOUNT,
                        "STATUS_CODE"=>$row->STATUS_CODE, "STATUS_MSG"=>$row->STATUS_MSG,
                        "NU_EXPIRY_DATE"=>$row->NU_EXPIRY_DATE, "PAY_DATE"=>$row->PAY_DATE,
                        "SERVICE"=>$row->srvname, "PAY_GATEWAY"=>$row->PAY_GATEWAY, "DB_UPDATED"=>$row->DB_UPDATED);
        }
     /* } catch (Exception $ex) {
        //print_r($ex);
        echo $e->errorMessage();
      } finally {
        echo $e->errorMessage();
        print_r($exp); 
        //exit();
      }*/
        return $exp;
    }
    
    public function getDisTransaction($transid) {
        $exp = array();
        
        $qry = "SELECT TRANX_ID, RAD_USERNAME, EXPIRY_DATE, REQ_AMOUNT, REQ_CURRENCY, REQUEST_DATE, PAY_GATEWAY,
                    PAY_REFERENCE, APPR_AMOUNT, STATUS_CODE, STATUS_MSG, NU_EXPIRY_DATE, PAY_DATE, rs.srvname, DB_UPDATED
                FROM tbl_tranx tx
                LEFT JOIN rm_users ru ON tx.RAD_USERNAME=ru.username
                LEFT JOIN rm_services rs ON ru.srvid=rs.srvid 
                WHERE TRANX_ID=?";  
        $some_sth = $this->db->select($qry, "s", $transid);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $exp[] = array("TRANS_ID"=>$row->TRANX_ID, "RAD_USERNAME"=>$row->RAD_USERNAME, 
                        "EXPIRY_DATE"=>$row->EXPIRY_DATE, "REQ_AMOUNT"=>$row->REQ_AMOUNT, 
                        "REQ_CURRENCY"=>$row->REQ_CURRENCY, "REQUEST_DATE"=>$row->REQUEST_DATE,
                        "PAY_REF"=>$row->PAY_REFERENCE, "APPR_AMOUNT"=>$row->APPR_AMOUNT,
                        "STATUS_CODE"=>$row->STATUS_CODE, "STATUS_MSG"=>$row->STATUS_MSG,
                        "NU_EXPIRY_DATE"=>$row->NU_EXPIRY_DATE, "PAY_DATE"=>$row->PAY_DATE,
                        "SERVICE"=>$row->srvname, "PAY_GATEWAY"=>$row->PAY_GATEWAY, "DB_UPDATED"=>$row->DB_UPDATED);
        }
        
        return $exp;
    }
    
    
    public function loadRadUser4VOIP($user="", $is_enabled=-1, $is_linked = -1) {
        $ret = array();
        
        $ad = "";
        if (is_array($user)) :
            $tmp = array();
            foreach ($user as $k=>$v):
                $tmp[] = "'" . mysqli_real_escape_string($this->db, $v) . "'";
            endforeach;
            if (count($tmp)) :
                $ad .= " WHERE username IN (" . implode(",", $tmp) . ")";
            endif;
        else:
            if ($user != ""):
                $ad .= " WHERE username LIKE '" . mysqli_real_escape_string($this->db, $user) . "'";
            endif;
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            if ($ad == "")
                $ad = " WHERE username $in_not (SELECT RAD_USERNAME FROM tbl_voip)";
            else
                $ad .= " AND username $in_not (SELECT RAD_USERNAME FROM tbl_voip)";
        endif;
        $qry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration, VOIP_NO 
                FROM `rm_users` ru
                LEFT JOIN tbl_voip tv ON ru.username = tv.RAD_USERNAME
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad 
                 ORDER BY username"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[$row->username] = array("USERNAME"=>$row->username, "FIRSTNAME"=>$row->firstname, 
                        "LASTNAME"=> $row->lastname, "VOIP_NO" => $row->VOIP_NO, 
                        "MOBILE"=> $row->mobile, "EMAIL"=> $row->email,
                        "IP"=> $row->staticipcpe, "SERVICE_ID"=>$row->srvid, "SERVICE"=>$row->srvname,
                        "EXPIRATION" => $row->expiration, "IS_ENABLED" => $row->enableuser);
        }
        
        return $ret;
    }    
      
    
    public function loadRadUserObject4VOIP($user="", $is_enabled=-1, $is_linked = -1) {
        $ret = array();
        
        $ad = "";
        if ($user <> "") :
            $user = mysql_escape_string($user);
            $ad = " WHERE username LIKE '%$user%'";
        endif;
        if ($is_enabled <> -1 && ($is_enabled == 1 || $is_enabled == 0) ) :
            if ($ad == "")
                $ad = " WHERE enableuser = $is_enabled";
            else
                $ad .= " AND enableuser = $is_enabled";
        endif;
        if ($is_linked <> -1 && ($is_linked == 1 || $is_linked == 0) ) :
            $in_not = ($is_linked)? " IN " : " NOT IN ";
            if ($ad == "")
                $ad = " WHERE ( (username $in_not (SELECT RAD_USERNAME FROM tbl_voip))  )";
            else
                $ad .= " AND ( (username $in_not (SELECT RAD_USERNAME FROM tbl_voip))  )";
        endif;
        $qry = "SELECT username, enableuser, firstname, lastname, mobile, email, staticipcpe, 
                    ru.srvid, rs.srvname, expiration 
                FROM `rm_users` ru
                LEFT JOIN rm_services rs ON ru.srvid = rs.srvid $ad"; //echo $qry;
        $some_sth = $this->db->select($qry);
        $rows = $some_sth->num_rows();
        while ( $row = $some_sth->fetch_object() ) {
            $ret[] = $row;
        }
        
        return $ret;
    }
    
    
    public function createVOIP($raduser, $voip_no, $adminID) {
        $voip_exist = $this->verifyVOIPExist($voip_no);
        $rad_exist = $this->radAssignedVOIP($raduser);
        
        if ($voip_exist == 1) :
            $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: VOIP Number [$voip_no] already Assigned", $this::STATUS_FAILED, get_client_ip_env()); 
            return "Error: VOIP Number [$voip_no] already Assigned";
        else:
            if ($rad_exist == 1) :
                $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Service ID [$raduser] already Assigned a VOIP Number", $this::STATUS_FAILED, get_client_ip_env()); 
                return "Error: Service ID [$raduser] already Assigned a VOIP Number";
            else :
                $qry = "INSERT INTO tbl_voip (RAD_USERNAME, VOIP_NO, ADDED_BY, DATE_ADDED)
                        VALUES (?, ?, ?, NOW())";
                $in_id = $this->db->insert($qry, 'ssi', $raduser, $voip_no, $adminID);
                if ($in_id) :
                    $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Success: VOIP Number [$voip_no] successfully assigned to [$raduser]!", $this::STATUS_PASSED, get_client_ip_env());
                    return "Success: VOIP Number [$voip_no] successfully assigned to [$raduser]!";
                else:
                    $this->logTrail($this::INFO, "({$_SESSION[$this->sid.'username']} attempt) Error: Unable to assigned VOIP Number [$voip_no] to [$raduser]", $this::STATUS_FAILED, get_client_ip_env()); 
                    return "Error: Unable to assigned VOIP Number [$voip_no] to [$raduser]";
                endif;
            endif;
        endif;
    }    
    
    
    public function editVOIP($raduser, $voip_no) {
        $voip_exist = $this->verifyVOIPExist($voip_no, $raduser);
        
        if ($voip_exist == 1) :
            return "Error: VOIP Number [$voip_no] already Assigned to another account";
        else:
            $upd = "UPDATE tbl_voip SET VOIP_NO=? WHERE RAD_USERNAME=?"; 
            $rett = $this->db->execute_query($upd, "ss", $voip_no, $raduser);
            
            if ($rett) :
                return "Success: Update Completed!";
            else:
                return "Error: Update failed!";
            endif;
        endif;
    }
    
    public function verifyVOIPExist($voip_no="", $raduser="") {
        $exist = 0;
        $adc = "";
        if ($raduser != ""):
            $adc = " AND RAD_USERNAME <> '" . mysqli_real_escape_string($this->db, $raduser) . "'";
        endif;
        if ($voip_no != "") :
            $qry = "SELECT RAD_USERNAME
                FROM `tbl_voip` 
                WHERE VOIP_NO =? $adc";
            $some_sth = $this->db->select($qry, 's', $voip_no);
            $rows = $some_sth->num_rows();
            if ($rows):
                $exist = 1;
            endif;
        endif;
        
        return $exist;
    } 
    
    public function radAssignedVOIP($raduser="") {
        $exist = 0;
        if ($raduser <> "") :
            $qry = "SELECT VOIP_NO
                FROM `tbl_voip` 
                WHERE RAD_USERNAME =?";
            $some_sth = $this->db->select($qry, 's', $raduser);
            $rows = $some_sth->num_rows();
            if ($rows):
                $exist = 1;
            endif;
        endif;
        
        return $exist;
    }
    
    // data used for logging
    public function dataToStore($raduser, $tranx_id, $amount, $curr, $months=1){
        $importantValues = array($raduser, $tranx_id, $amount, $curr, $months); // you can include customer name in this (CUST_NAME) if you'll be setting that
        return @json_encode($importantValues);
    }
    
    // generate the sha512 hash
    public function hashGenerator($tranx_id, $amount, $notif_url, $hashkey){
        $dataToHash = $tranx_id . $amount . $notif_url . $hashkey;
        return hash("sha512", $dataToHash);
    }
    
    // generate the sha512 hash from supplied string
    public function hashGeneratorNew($dataToHash){
        //$dataToHash = $tranx_id . $amount . $notif_url . $hashkey;
        return hash("sha512", $dataToHash);
    }
    
    // generate the verification sha512 hash
    public function verifyHash($tranx_id, $amt_kobo, $status_code, $hashkey){
        $dataToHash = $tranx_id . $amount . $status_code . $hashkey;
        return hash("sha512", $dataToHash);
    }
        
    public function insertLog($fields, $value) {
        
        $qry = "INSERT INTO paydirect_log ($fields)
                    VALUES ($value)";
        $in_id = $this->db->insert($qry);
        if ($in_id) :
            return "Success";
        else:
            return "Error";
        endif;
         
    }      
     
    public function loadStates()  {
       $qry = "SELECT *
                FROM tbl_states ORDER BY STATENAME"; 
       $some_sth = $this->db->select($qry);
       $rows = $some_sth->num_rows();
       if ($rows) :
           while ($row = $some_sth->fetch_object()):
                $ret[] = ["STATECODE"=>$row->STATECODE, "STATENAME"=>$row->STATENAME, "STATE"=>$row->STATENAME];
           endwhile; 
       else: $ret = [];
       endif;

       return $ret;
    }    
     
    public function getUserGroupArray()  {
       $qry = "SELECT ID, ADMIN_TYPE, IS_ADMIN
                FROM tbl_admin_level ORDER BY ADMIN_TYPE"; 
       $some_sth = $this->db->select($qry);
       $rows = $some_sth->num_rows();
       if ($rows) :
           while ($row = $some_sth->fetch_object()):
                $ret[$row->ID] = ["UGID"=>$row->ID, "ADMIN_TYPE"=>$row->ADMIN_TYPE, "IS_ADMIN"=>$row->IS_ADMIN];
           endwhile; 
       else: $ret = [];
       endif;

       return $ret;
    } 
    
    public function getAdminDashStat($month=0, $yr=0) {
        if ($month == 0 && $yr == 0):
            return [];
        endif;
        
        $ret = [];
        
        $qry = "SELECT COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES' FROM `tbl_tranx` "
                . "WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) = ? AND YEAR(PAY_DATE) = ?"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        $row = $some_sth->fetch_object();
        $ret = ["NTRANS" => $row->NTRANS, "SALES" => $row->SALES]; 
        
        $qry = "SELECT COUNT(username) AS 'NUSERS' FROM rm_users WHERE MONTH(createdon)=? AND YEAR(createdon)=?"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        $row = $some_sth->fetch_object();
        $ret['NUSERS'] = $row->NUSERS;
        
        $qry = "SELECT srvname AS 'SRV', descr AS 'SRV_DESC', COUNT(TRANX_ID) AS 'NTRANS', SUM(APPR_AMOUNT) AS 'SALES' 
FROM `tbl_tranx` tx
LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
LEFT JOIN rm_services rs ON r.srvid = rs.srvid
WHERE STATUS_CODE = '00' AND MONTH(PAY_DATE) = ? AND YEAR(PAY_DATE) = ?
GROUP BY srvname"; 
        $some_sth = $this->db->select($qry, "ii", $month, $yr);
        while ($row = $some_sth->fetch_object()):
            $ret['SALES_BY_SRV'][] = ["SRV"=>$row->SRV, "SRV_DESC"=>$row->SRV_DESC, 
                            "NTRANS"=>$row->NTRANS, "SALES"=>$row->SALES];
        endwhile;
        
        return $ret;
    }
    
    public function getTranxByService($srvid=0, $startdate="", $enddate="") {
        $addthis = "";
        if (is_int($srvid) && ($srvid > 0)):
            $addthis = " AND r.srvid=$srvid";
        endif;
        
        if ($startdate <> "" && $enddate <> ""):
            $me = " AND PAY_DATE BETWEEN '$startdate' AND '$enddate' ";
            $addthis = ($addthis == "")? $me : $addthis . $me;
        else:
            $me = " AND MONTH(PAY_DATE) = MONTH(NOW()) AND YEAR(PAY_DATE) = YEAR(NOW())";
            $addthis = ($addthis == "")? $me : $addthis . $me;
        endif;
        
        $qry = "SELECT r.username, rs.srvname, tx.TRANX_ID, PAY_DATE, NU_EXPIRY_DATE, APPR_AMOUNT, NMONTHS, 
            DB_UPDATED, PAY_GATEWAY 
FROM `tbl_tranx` tx
LEFT JOIN rm_users r ON tx.RAD_USERNAME=r.username
LEFT JOIN rm_services rs ON r.srvid = rs.srvid
WHERE STATUS_CODE = '00' $addthis";  //echo $qry . "$startdate  $enddate";
        $some_sth = $this->db->select($qry);
        while ($row = $some_sth->fetch_object()):
            $ret[] = ["SRV"=>$row->srvname, "TRANSID"=>$row->TRANX_ID, "USERNAME"=>$row->username,
                            "PAY_DATE"=>$row->PAY_DATE, "NU_EXPIRY_DATE"=>$row->NU_EXPIRY_DATE,
                            "AMOUNT"=>$row->APPR_AMOUNT, "NMONTHS"=>$row->NMONTHS,
                            "DB_UPDATED"=>$row->DB_UPDATED, "PAY_GATEWAY"=>$row->PAY_GATEWAY];
        endwhile;
        
        return $ret;
    }
    
    
    public function sendToERP($url, $db, $username, $password, $erpid, $amt, $desc, $paydate, $productid=0) {
        if (file_exists("includes/ripcord-master/ripcord.php")) {
            require_once "includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../includes/ripcord-master/ripcord.php")) {
            require_once "../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../includes/ripcord-master/ripcord.php")) {
            require_once "../../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../../includes/ripcord-master/ripcord.php")) {
            require_once "../../../includes/ripcord-master/ripcord.php";
        }
        $common = ripcord::client($url . "/xmlrpc/2/common");
        
        $uid = $common->authenticate($db, $username, $password, array());         
        $models = ripcord::client($url . "/xmlrpc/2/object");
        $payment_id = $models->execute_kw($db, $uid, $password,
               'account.payment.group', 'create',
                    array(array(
                        'date'=> $paydate,
                        'is_from_rpc'=>True,
                        'journal_id'=> 8, 
                        'company_id'=> 3, 
                         'amount'=> $amt,
                         'ref' => $desc, 
                         'partner_id' => $erpid,
                         'product_id' => $productid
                    )));
        return $payment_id;
    }
    
    
    public function sendToERPv1($url, $db, $username, $password, $erpid, $amt, $desc, $paydate) {
        if (file_exists("includes/ripcord-master/ripcord.php")) {
            require_once "includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../includes/ripcord-master/ripcord.php")) {
            require_once "../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../includes/ripcord-master/ripcord.php")) {
            require_once "../../includes/ripcord-master/ripcord.php";
        } elseif (file_exists("../../../includes/ripcord-master/ripcord.php")) {
            require_once "../../../includes/ripcord-master/ripcord.php";
        }
        $common = ripcord::client($url . "/xmlrpc/2/common");
        
        $uid = $common->authenticate($db, $username, $password, array()); //echo "USER: $uid };";
        
        $models = ripcord::client($url . "/xmlrpc/2/object");
        $id_journal_entry = $models->execute_kw($db, $uid, $password,
            'account.move', 'create',
            array(array(
                'is_from_rpc'=>True,
                'date'=>$paydate,
                'journal_id'=> 52, # this is the ID of the Eservice Payment Journal Book on ODEX
                'company_id'=> 3,  # This is the FOB company ID
            ))); //echo "USER1: $uid };";
        $id_debit_journal_item = $models->execute_kw($db, $uid, $password,
            'account.move.line', 'create',
            array(array(
                'is_from_rpc'=>True,
                'move_id'=> $id_journal_entry,     
                'account_id' => 932,   # The account to debit which is the Accounts Receivable ID. 
                'name'=>$desc,
                'debit'=>$amt,  # Test value
                'partner_id' => $erpid,   # This is a temporary test partner ID (Customer) which will come from the customers ID that have to be pushed initially to eservice system
                'company_id'=> 3,  # This is the FOB company ID
                )
            ));
        $id_credit_journal_item = $models->execute_kw($db, $uid, $password,
            'account.move.line', 'create',
            array(array(
                'is_from_rpc'=>True,
                'move_id'=> $id_journal_entry,     
                'account_id' => 935,   # The account to credit which is the Accounts Receivable ID. 
                'name'=>$desc,
                'credit'=>$amt,  # Test value
                'partner_id' => $erpid,   # This is a temporary test partner ID (Customer) which will come from the customers ID that have to be pushed initially to eservice system
                'company_id'=> 3,  # This is the FOB company ID
                )
            )); //echo "USER2: $uid };";
        
        return ["DB_LEG"=>$id_debit_journal_item, "CR_LEG"=>$id_credit_journal_item];
    }
    
    
    public function manRenewRpt($month, $yr, $userid=0, $limit = 0) {
        $exp = $ret = array();
        $adc = $lim = "";
        if ($limit > 0) {
            $lim = " LIMIT $limit";
        }
        
        if ($userid > 0 && is_int($userid)):
            $userid = (int)$userid;
            $adc .= " AND ADMIN = $userid";
        endif;
        $qry = "SELECT m.RAD_USERNAME, EXPIRY_DATE, NEW_EXPIRY_DATE, ADDED_DATA, EXTEND_ONLY, 
                    ADMIN, tad.FULLNAME, DATEDONE, ru.srvid, tp.PLAN, tp.AMOUNT, DATEDIFF(NEW_EXPIRY_DATE,EXPIRY_DATE) AS 'NDAYS'  
                FROM `tbl_manrenewal` m
                LEFT JOIN tbl_admins tad ON m.ADMIN = tad.AID
                LEFT JOIN rm_users ru ON m.RAD_USERNAME=ru.username
                LEFT JOIN tbl_plans tp ON ru.srvid=tp.SRVID
                WHERE YEAR(DATEDONE)=? AND MONTH(DATEDONE)=? $adc $lim";  
 
        $some_sth = $this->db->select($qry, "ii", $yr, $month);  
        while ( $row = $some_sth->fetch_object() ) { 
            $ret["LIST"][] = ["RAD_USERNAME"=>$row->RAD_USERNAME, "EXPIRY_DATE"=>$row->EXPIRY_DATE, 
                        "NU_EXPIRY_DATE"=>$row->NEW_EXPIRY_DATE, "ADDED_DATA"=> ($row->ADDED_DATA), 
                        "EXTEND_ONLY"=>$row->EXTEND_ONLY, "ADMIN"=>$row->ADMIN, "NDAYS"=>$row->NDAYS,
                        "FULLNAME"=>$row->FULLNAME, "DATEDONE"=>$row->DATEDONE, 
                        "SRVID"=>$row->srvid, "PLAN"=>$row->PLAN, "AMOUNT"=>$row->AMOUNT];
        }        
        
        $qry = "SELECT EXTEND_ONLY, COUNT(RAD_USERNAME) AS 'NO' FROM `tbl_manrenewal` 
                WHERE YEAR(DATEDONE)=? AND MONTH(DATEDONE)=?
                GROUP BY EXTEND_ONLY";  
 
        $some_sth = $this->db->select($qry, "ii", $yr, $month);  
        while ( $row = $some_sth->fetch_object() ) { 
            $ret["EXT"][$row->EXTEND_ONLY] = $row->NO;
        }       
        
        $qry = "SELECT FULLNAME, COUNT(RAD_USERNAME) AS 'NO' FROM `tbl_manrenewal` m
                LEFT JOIN tbl_admins tad ON m.ADMIN = tad.AID
                WHERE YEAR(DATEDONE)=? AND MONTH(DATEDONE)=?
                GROUP BY FULLNAME";  
 
        $some_sth = $this->db->select($qry, "ii", $yr, $month);  
        while ( $row = $some_sth->fetch_object() ) { 
            $ret["ADMINCOUNT"][$row->FULLNAME] = $row->NO;
        }
        
        return $ret;
    }
    
    
    public function getFullName() {
         return $this->fullname;
     }
     
     
    public function getUserName() {
         return $this->username;
     }
     
     
    public function getRADUserName() {
         return $this->rad_username;
     }
     
     
    public function getUID() {
         return $this->uid;
     }
     
    
    public function getUserType() {
        return $this->usertype;
    }
    
    public function getUserTypeID() {
        return $this->usertype_id;
    }
    
    
    public function isAdmin() {
        return $this->is_admin;
    } 
    
    
    public function isEnabled() {
        return $this->is_enabled;
    } 
     
     
    public function getPackage() {
         return $this->package;
     }
     
     
    public function getPackageID() {
         return $this->packageid;
     }
     
     
    public function getExpiration() {
         return $this->expiration;
     }
     
     
    public function getEmail() {
         return $this->email;
     }
     
    public function getMobile() {
         return $this->mobile;
     }
     
    public function getReadOnly() {
         return $this->readonly;
     }
    

    public function setDB($dbconnection) {
        $this->db = $dbconnection;
    }
    
    public function savePushUUID($userid, $uuid) {
        $upd = "UPDATE tblclients SET `PUSHID` = ? WHERE `ID` = ?";
        $rett = $this->db->execute_query($upd, "si", $uuid, $userid);
        if ($rett):
            return 1;
        else: 
            return 0;
        endif;
        
    }
}
