<?php
 
/**
 * @author www.Tutorialspots.com
 * @copyright 2017
 */
 
/**
 * Corrected Block TEA implement in PHP with little modification
 * @param $v: n word data vector
 * @param $key: 4 word key
 * @param $n: length of data vector $v (positive for encrypt, negative for decrypt)
 */
  
function XXTEA($v, $key, $n = 2)
{
    $delta = 0x9e3779b9;
    if ($n > 1)
    {
         /* Coding Part */
        $rounds = 6 + 52 / $n;
        $sum = 0;
        $z = $v[$n - 1];
        do
        {
            $sum += $delta;
            $e = ($sum >> 2) & 3;
            for ($p = 0; $p < $n - 1; $p++)
            {
                $y = $v[$p + 1];
                $z = $v[$p] += ((($z >> 5 ^ $y << 2) + ($y >> 3 ^ $z << 4)) ^ (($sum ^ $y) + ($key[($p & 3) ^ $e] ^ $z)));
            }
            $y = $v[0];
            $z = $v[$n - 1] += ((($z >> 5 ^ $y << 2) + ($y >> 3 ^ $z << 4)) ^ (($sum ^ $y) + ($key[($p & 3) ^ $e] ^
                $z)));
        } while (--$rounds);
    } else
        if ($n < -1)
        {
             /* Decoding Part */
            $n = -$n;
            $rounds = 6 + 52 / $n;
            $sum = $rounds * $delta;
            $y = $v[0];
            do
            {
                $e = ($sum >> 2) & 3;
                for ($p = $n - 1; $p > 0; $p--)
                {
                    $z = $v[$p - 1];
                    $y = $v[$p] -= ((($z >> 5 ^ $y << 2) + ($y >> 3 ^ $z << 4)) ^ (($sum ^ $y) + ($key[($p & 3) ^ $e] ^ $z)));
                }
                $z = $v[$n - 1];
                $y = $v[0] -= ((($z >> 5 ^ $y << 2) + ($y >> 3 ^ $z << 4)) ^ (($sum ^ $y) + ($key[($p & 3) ^ $e] ^ $z)));
                $sum -= $delta;
            } while (--$rounds);
        }
    return $v;
}