<?php
chdir(dirname(__FILE__));
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$adminUser = 'opmat';
$adminId = 12;

$log = new Logger($db, $adminUser);
$ad = new UserProfile($db);

$appLevel = 1;

$strsql = "SELECT INCIDENCE_ID, INCIDENCE_TYPE, TICKET_ID, OLT_ID, GPON_ID, AFFECTED_USERS, START_DATE, EXPECTED_RESOLUTION_DATE,
                    ACTUAL_RESOLUTION_DATE, TICKET_STATUS, SUMMARY, CREATION_DATE, CREATED_BY, LASTUPDATED_BY, 
                    LASTUPDATED_DATE, DURATION, ISCLOSED, QUALIFIED_FOR_REWARD, IS_REWARDED, REWARD_REQUEST_BY,
                    REWARD_REQUEST_DATE, REWARD_APPROVED_BY, REWARD_APPRVAL_DATE, REWARD_APPROVAL_LEVEL, REWARD_FULLY_APPROVED,
                    APPROVED_DURATION, EXEMPTED_USERS, REQUESTED_DURATION
            FROM tbl_outage_ticket WHERE INCIDENCE_ID BETWEEN 3 AND 819";
$some_sth = $db->select($strsql);
while ( $row = $some_sth->fetch_object() ) {
    
    if ($row->REWARD_APPROVAL_LEVEL > $appLevel) {
        continue;
    }
    
    $approvedBy = (is_null($row->REWARD_APPROVED_BY))? [] : json_decode($row->REWARD_APPROVED_BY, TRUE);
    $approvedBy[] = ["APPROVER"=>'System Creator (Opeyemi)', "APPROVAL_LEVEL"=>$appLevel,
     "APPROVAL_DATE"=>date("d-m-Y H:i:s"), "DAYS_APPROVED"=>$row->REQUESTED_DURATION, 
    "DECISION"=> "Approved", "APPROVER_COMMENT"=>'Batch Approval', "REWORK"=>0 ];
    
    $approvalResponse = $ad->approveLostDaysByLevel($appLevel, $row->TICKET_ID, $row->INCIDENCE_ID, $row->REQUESTED_DURATION, 
            json_encode($approvedBy), $adminId, 1, $row->ACTUAL_RESOLUTION_DATE, 0, $row->START_DATE);

    echo $approvalResponse;
    
}