<?php
chdir(dirname(__FILE__));
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";
   
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//select one pending email
$sel = "SELECT QID, QUEUE_DATA, ADMIN_NAME, ADMIN_EMAIL, ADMIN_ID, 
                SENDEMAIL, SENDPUSH, SENDSMS, DATECREATED 
        FROM tbl_emailpush_queue WHERE SENDEMAIL=1 AND EMAILSENT=0 LIMIT 1";
$some_sth = $db->select($sel);
$row = $some_sth->fetch_assoc();

if ($some_sth->num_rows() < 1):
    exit();
endif;

$adminUser = $row['ADMIN_NAME'];
$adminId = $row['ADMIN_ID'];
$adminEmail = $row['ADMIN_EMAIL'];
$qdata = $row['QUEUE_DATA'];
$qid = $row['QID'];

// set data to processing
setStatus($db, $qid, 2);

extract(json_decode($qdata, TRUE));

$log = new Logger($db, $adminUser);
$ad = new UserProfile($db);
//$push = new PushSMS($db);

if ($sendTo == "all") :
    $criteria = [];
//    /push
    $sendToP = 1;
elseif ($sendTo == "sel") :
    $criteria = $musers;
else:
    echo "Error: Invalid Operation"; 
    exit();
endif; 

$startTime = date("Y-m-d H:i:s");

$contacts = $ad->getUserContact($sendTo, $criteria, -1); 

//Check if email exist
if (count($contacts) < 1):
    echo "Error: Record Missing; cannot send email";
    setStatus($db, $qid, -1);
    exit();
endif;
$recipient = array_column($contacts, 'EMAIL');
$mailer = new Mailer($db);
$saveid = $mailer->saveEMail($sendemail, $sendname, $title, $content, join(",",$recipient), 
            count($contacts), $sendTo, join(",",$criteria), 0, $adminId);
$status = 0;
if ( (stripos($content, "{{fulnm}}") !== false) || (stripos($content, "{{usrnm}}") !== false) ) : 
    //encoded
    $status = $mailer->sendCustomEmail($contacts, $sendemail, $sendname, $title, $content);
else: 
    //plain
    $status = $mailer->sendPlainEmail($contacts, $sendemail, $sendname, $title, $content);
endif;

/* NEW:: Log this action data */
    $stopTime = date("Y-m-d H:i:s");
    $mailer->logEmailData($saveid, $mailer->sentCount, $mailer->failedCount, json_encode($mailer->sentEmailList), 
            json_encode($mailer->failedEmailList), json_encode($mailer->sentUserList), json_encode($mailer->failedUserList), 
                                    $startTime, $stopTime);
    $start = date("d M, Y H:i:s", strtotime($startTime));
    $end = date("d M, Y H:i:s", strtotime($stopTime));

$raw_msg = $ad->getCannedMessage("EMAIL_SEND_NOTIF"); 
$msg = sprintf($raw_msg, $start, $end, $mailer->sentCount, $mailer->failedCount, 
        json_encode($mailer->sentUserList), json_encode($mailer->failedUserList), $title, $content); 
$sent = $ad->sendEmailBrevo($adminEmail, 'fiberonepayment@gmail.com', "EMAIL SEND REQUEST UPDATE - ".date("Y-m-d H:i:s"), $msg, ["CSC"=>"csc@fob.ng", "ISM"=>"ism@fob.ng", "Benaebi Adonkie"=>"benaebi.adonkie@fob.ng", "InfoSys"=>"infosystem@fob.ng"], []);
   
/* ./NEW:: Log this action data */

if ($status) :
    echo "Success: Mail Sent!";
    setStatus($db, $qid, 1);
    $mailer->updateEmailStatus($saveid, $status);
    exit();
endif;
echo "Error: Failed to send Email ";
setStatus($db, $qid, 0);
$mailer->updateEmailError($saveid, $mailer->ErrorInfo);

//$postdata = ["user"=>$createdBy, "userid"=>$adminId, "sendTo"=>"sel", "musers"=>$recipients, 
//                "sendname"=>"Customer Service", "sendemail"=>"csc@fob.ng", "title"=>"SERVICE UPDATE (#$ticketId)", 
//                "content"=>$message];
//
//$userid = $row['ADMIN_NAME'];

function setStatus($db, $qid, $status) {
    $add = ($status===1)? ", DATE_EMAILSENT=NOW()" :'';
    $upd = "UPDATE tbl_emailpush_queue SET EMAILSENT=$status $add WHERE QID=$qid";
    return $db->execute_query($upd);
}