<?php
chdir(dirname(__FILE__));
include_once "../includes/opener.php";
include_once "../includes/db.inc";
include_once "../config.php";
   
//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//select one pending email
$sel = "SELECT QID, QUEUE_DATA, ADMIN_NAME, ADMIN_EMAIL, ADMIN_ID, 
                SENDEMAIL, SENDPUSH, SENDSMS, DATECREATED 
        FROM tbl_emailpush_queue WHERE SENDPUSH=1 AND PUSHSENT=0 LIMIT 1";
$some_sth = $db->select($sel);
$row = $some_sth->fetch_assoc();

if ($some_sth->num_rows() < 1):
	echo "Empty";
    exit();
endif;

$adminUser = $row['ADMIN_NAME'];
$adminId = $row['ADMIN_ID'];
$adminEmail = $row['ADMIN_EMAIL'];
$qdata = $row['QUEUE_DATA'];
$qid = $row['QID'];

// set data to processing
setStatus($db, $qid, 2);

extract(json_decode($qdata, TRUE));

$log = new Logger($db, $adminUser);
$ad = new UserProfile($db);
$push = new PushSMS($db);

if ($sendTo == "all") :
    $criteria = [];
//    /push
    $sendToP = 1;
elseif ($sendTo == "sel") :
    $criteria = $musers;
else:
    echo "Error: Invalid Operation"; 
    exit();
endif; 

$startTime = date("Y-m-d H:i:s");

//$contacts = $ad->getUserContact($sendTo, $criteria, -1); 

//Push Checkings
if (isset($sendToP) && ($sendToP == 1)):
    //Segment
    $send_to_type = $push::SEND_TO_SEGMENT;
    $recipientP = ["All"];
    $recs = "All";
elseif (isset($sendTo) && ($sendTo == "sel")):
    //Selected Players
    $send_to_type = $push::SEND_TO_PLAYER;
    $mids = [];
    $devlst = $push->getDeviceByUser($musers);
    $recipientP = $devlst;
    $recs = $musers; 
else:
    //Selected Players by Selected Category
    $up = new UserProfile($db);
    $contacts = $up->getUserContact($sendTo, $criteria, $actstatus);
    $mids = [];
    // $devlst = $_SESSION[$sid.'devlist'];
    // $devlst = $_SESSION[$sid.'devlist'];
    // foreach ($contacts as $contact) {
    //     $mids = array_merge($mids, $push->getDeviceByUser($contact['USERNAME']) );
    // }
    $mids = $ad->getDeviceByUser(array_column($contacts,'USERNAME'));
    $send_to_type = $push::SEND_TO_PLAYER;
    $recipientP = $mids;
    $recs = ["sendTo"=>$sendTo, "group_recipient"=>$criteria]; //$selusername;
endif;

// ### Send Push #####
$pContent = str_replace("{{usrnm}}", "{{ username | default: ''}}", str_replace("{{fulnm}}", "{{ fullname | default: 'there'}}", strip_tags($content)));
$pRet = $push->sendPUSH($title, $pContent, $recipientP, $send_to_type);
$report = json_encode($pRet);

if (isset($pRet->id)):
    $av = $push->savePUSH($pRet->id, $title, $pContent, json_encode($recs), $pRet->recipients, $adminId, $send_to_type, "", 10, $report);
    setStatus($db, $qid, 1);
    $log->logTrail($log::INFO, "($adminUser attempt) Success: Sent Push SMS to {$pRet->recipients} recipients <$av>", $log::STATUS_PASSED, get_client_ip_env()); 
    echo "Success: Sent Push SMS";
else:
    $log->logTrail($log::INFO, "($adminUser attempt) Error: Fail to Send Push SMS", $log::STATUS_FAILED, get_client_ip_env()); 
    setStatus($db, $qid, 0);
    echo "Error: Fail to Send Push SMS";
endif;

// #### ./Send Push $#####

function setStatus($db, $qid, $status) {
    $add = ($status===1)? ", DATE_PUSHSENT=NOW()" :'';
    $upd = "UPDATE tbl_emailpush_queue SET PUSHSENT=$status $add WHERE QID=$qid";
    return $db->execute_query($upd);
}