<?php
$page = "Orders";
$page_url = "fob_orders";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 101)):
    ?>
    <script>
        window.location.href = 'vendor_dashboard';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$fob_vendor_id = $dashboard->getFobVendor();
$vendor_check = $dashboard->getDashboardByGlobalId($_SESSION[$sid . 'userid']);

$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));

// Handle AJAX status update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['status'])) {
    header('Content-Type: application/json');
    $orderId = $_POST['order_id'];
    $newStatus = $_POST['status'];
    $updated = $dashboard->updateOrderStatus($orderId, $newStatus); // Ensure this method exists
    if ($updated) {
        echo json_encode(['success' => true, 'message' => "Order status updated to $newStatus."]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update status.']);
    }
    exit();
}
?>

<!-- Include DataTables and Bootstrap Datepicker CSS/JS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>

<style>
    /* Reuse CSS from all_products.php with minor adjustments */
    .main-content {
        margin-left: 230px;
        min-height: 100vh;
        background: white;
    }

    .top-bar {
        background: white;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .content-area {
        padding: 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb span {
        color: #6c757d;
        margin: 0 8px;
    }

    .search-filter-bar {
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        margin-bottom: 20px;
        justify-content: space-between;
        align-items: center;
    }

    .search-input {
        flex: 1;
        max-width: 300px;
        position: relative;
    }

    .search-input input {
        width: 100%;
        padding: 8px 40px 8px 12px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .search-input i {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #6c757d;
    }

    .button-filters {
        display: flex;
        gap: 20px;
    }

    .filter-btn,
    .export-btn {
        padding: 8px 16px;
        border: 1px solid #ddd;
        background: white;
        border-radius: 4px;
        font-size: 14px;
        color: #333;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.3s ease;
    }

    .filter-btn:hover,
    .export-btn:hover {
        background: #f8f9fa;
    }

    .orders-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .orders-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
    }

    .orders-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .orders-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .filter-tabs {
        padding: 0 16px;
        background-color: #f1f5f9;
        width: fit-content;
        border-radius: 6px;
        margin-bottom: 16px;
    }

    .filter-tabs ul {
        list-style: none;
        padding: 6px 0;
        margin: 0;
        display: flex;
    }

    .filter-tabs li {
        margin-right: 30px;
    }

    .filter-tabs a {
        display: block;
        border-radius: 6px;
        padding: 8px;
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .filter-tabs a.active {
        background-color: #fff;
    }

    .filter-tabs a:hover {
        text-decoration: none;
        background: #e9ecef;
    }

    .table-container {
        overflow-x: auto;
    }

    .orders-table {
        width: 100%;
        margin: 0;
        border-collapse: collapse;
    }

    .orders-table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .orders-table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
        text-align: left;
    }

    .orders-table tbody tr {
        border-bottom: 1px solid #f8f9fa;
        transition: background 0.3s ease;
    }

    .orders-table tbody tr:hover {
        background: #f8f9fa;
    }

    .orders-table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        font-size: 14px;
    }

    .customer-info {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .order-checkbox {
        margin-right: 30px;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: #0d3e9b;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
        margin-right: 15px;
    }

    .customer-details h6 {
        margin: 0;
        color: #333;
        font-weight: 500;
        font-size: 14px;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .status-badge {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 500;
        display: inline-block;
    }

    .status-fulfilled {
        background: #4caf50;
        color: white;
    }

    .status-pending {
        background: #ff9800;
        color: white;
    }

    .status-cancelled {
        background: #f44336;
        color: white;
    }

    .status-refunded {
        background: #9c27b0;
        color: white;
    }

    .order-id,
    .order-price,
    .order-date {
        color: #6c757d;
        font-size: 14px;
    }

    .view-btn {
        background: none;
        border: none;
        color: #6c757d;
        padding: 5px;
        cursor: pointer;
        border-radius: 4px;
        transition: background 0.3s ease;
    }

    .view-btn:hover {
        background: #f8f9fa;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 5px 10px;
        border: 1px solid #ddd;
        background: white;
        border-radius: 4px;
        color: #6c757d;
        margin: 0 2px;
        transition: all 0.3s ease;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background: #f8f9fa;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: #0d3e9b;
        color: white;
        border-color: #0d3e9b;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .dataTables_info {
        color: #6c757d;
        font-size: 14px;
        padding: 20px 25px;
    }

    .modal-backdrop {
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-content {
        border-radius: 8px;
        border: none;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
    }

    .modal-header {
        border-bottom: 1px solid #e9ecef;
        padding: 20px;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    .modal-body {
        padding: 20px;
    }

    .modal-footer {
        border-top: 1px solid #e9ecef;
        padding: 15px 20px;
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .btn-primary {
        background: #0d3e9b;
        border: 1px solid #0d3e9b;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
        font-size: 14px;
        cursor: pointer;
    }

    .btn-primary:hover {
        background: #0b3484;
        border-color: #0b3484;
    }

    .btn-secondary {
        background-color: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 16px;
        border-radius: 4px;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .top-bar {
            padding: 15px 20px;
        }

        .search-filter-bar {
            flex-direction: column;
            align-items: stretch;
            gap: 10px;
        }

        .search-input {
            max-width: none;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Orders</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('marketdash')">Dashboard</a>
            <span>></span>
            <span style="color: #333; font-weight: 500">Orders</span>
        </nav>

        <!-- Search and Filter Bar -->
        <div class="search-filter-bar">
            <div class="search-input">
                <input type="text" placeholder="Search orders" id="orderSearch" />
                <i class="fa fa-search"></i>
            </div>
            <div class="button-filters">
                <button class="filter-btn" data-toggle="modal" data-target="#filterModal">
                    <i class="fa fa-filter"></i> Filter
                </button>
                <button class="export-btn" onclick="exportOrders()">
                    <i class="fa fa-download"></i> Export
                </button>
            </div>
        </div>

        <!-- Filter Tabs -->
        <div class="filter-tabs">
            <ul>
                <li><a href="#" class="active" data-status="all" onclick="filterOrders('all')">All</a></li>
                <li><a href="#" data-status="fulfilled" onclick="filterOrders('fulfilled')">Fulfilled</a></li>
                <li><a href="#" data-status="pending" onclick="filterOrders('pending')">Pending</a></li>
                <li><a href="#" data-status="cancelled" onclick="filterOrders('cancelled')">Cancelled</a></li>
                <li><a href="#" data-status="refunded" onclick="filterOrders('refunded')">Refunded</a></li>
            </ul>
        </div>

        <!-- Orders Section -->
        <div class="orders-section">
            <div class="orders-header">
                <div>
                    <h3 class="orders-title">Recent Orders</h3>
                    <p class="orders-subtitle">Recent Orders from your Stores</p>
                </div>
            </div>

            <!-- Orders Table -->
            <div class="table-container">
                <table class="orders-table" id="ordersTable">
                    <thead>
                        <tr>
                            <th>
                                <input type="checkbox" id="selectAll" onchange="toggleSelectAll()" />
                                <span style="margin-left: 10px">Customer Name</span>
                            </th>
                            <th>Order ID</th>
                            <th>Status</th>
                            <th>Total Price</th>
                            <th>Date of Order</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody id="ordersTableBody">
                        <!-- DataTables will populate this -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Filter Modal -->
<div class="modal fade" id="filterModal" tabindex="-1" role="dialog" aria-labelledby="filterModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="filterModalLabel">Filter Orders</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="startDate">Start Date</label>
                    <input type="text" class="form-control datepicker" id="startDate" placeholder="YYYY-MM-DD">
                </div>
                <div class="form-group">
                    <label for="endDate">End Date</label>
                    <input type="text" class="form-control datepicker" id="endDate" placeholder="YYYY-MM-DD">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="applyFilters()">Apply Filters</button>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    function navigateTo(page) {
        window.location.href = page + '.php';
    };

    $(document).ready(function () {
        let currentStatus = 'all';
        let currentStartDate = null;
        let currentEndDate = null;

        // Initialize Datepickers
        $('#startDate, #endDate').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true,
            todayHighlight: true
        });

        // Initialize DataTables
        const table = $('#ordersTable').DataTable({
            serverSide: true,
            processing: true,
            pageLength: 10,
            lengthChange: false,
            searching: false,
            ordering: true,
            info: true,
            ajax: {
                url: 'ajax/ajax_fob_orders.php',
                type: 'GET',
                data: function (d) {
                    d.page = Math.floor(d.start / d.length) + 1;
                    d.search = $('#orderSearch').val();
                    d.status = currentStatus;
                    d.startDate = currentStartDate;
                    d.endDate = currentEndDate;
                }
            },
            columns: [
                { data: 'customer_name', orderable: true },
                { data: 'order_id', orderable: true },
                { data: 'status', orderable: true },
                { data: 'total_amount', orderable: true },
                { data: 'created_at', orderable: true },
                { data: 'actions', orderable: false }
            ]
        });

        // Custom search
        $('#orderSearch').on('input', function () {
            table.ajax.reload();
        });

        // Filter by status
        window.filterOrders = function (status) {
            $('.filter-tabs a').removeClass('active');
            $(`.filter-tabs a[data-status="${status}"]`).addClass('active');
            currentStatus = status;
            table.ajax.reload();
        };

        // Apply date filters
        window.applyFilters = function () {
            currentStartDate = $('#startDate').val();
            currentEndDate = $('#endDate').val();
            $('#filterModal').modal('hide');
            table.ajax.reload();
        };

        // View order
        window.viewOrder = function (orderId) {
            window.location.href = `/eservice/order_detail.php?id=${encodeURIComponent(btoa(orderId))}`;
        };

        // Toggle select all checkboxes
        window.toggleSelectAll = function () {
            const selectAllCheckbox = $('#selectAll')[0];
            const orderCheckboxes = $('.order-checkbox');
            orderCheckboxes.prop('checked', selectAllCheckbox.checked);
        };

        // Export orders
        window.exportOrders = function () {
            $.ajax({
                url: 'ajax/ajax_fob_orders.php',
                type: 'GET',
                data: {
                    action: 'export',
                    search: $('#orderSearch').val(),
                    status: currentStatus,
                    startDate: currentStartDate,
                    endDate: currentEndDate
                },
                success: function (response) {
                    const data = response.data;
                    let csvContent = 'Customer Name,Customer Email,Order ID,Status,Total Price,Date of Order\n';
                    data.forEach(row => {
                        const cleanPrice = row.total_amount.replace(/[^\d.,]/g, '');
                        csvContent += `"${row.customer_name}","${row.customer_email}","${row.order_id}","${row.status}","${cleanPrice}","${row.created_at}"\n`;
                    });
                    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
                    const link = document.createElement('a');
                    link.href = URL.createObjectURL(blob);
                    link.download = 'orders.csv';
                    link.click();
                },
                error: function () {
                    alert('Failed to export orders. Please try again.');
                }
            });
        };

        // Initialize page
        console.log('Orders Dashboard initialized');
        if (window.innerWidth <= 768) {
            document.body.classList.add('mobile-view');
        }

        $(window).on('resize', function () {
            if (window.innerWidth <= 768) {
                document.body.classList.add('mobile-view');
            } else {
                document.body.classList.remove('mobile-view');
            }
        });

        // Initialize Bootstrap tooltips
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>