<?PHP
include_once "includes/opener.php";
include_once 'includes/db.inc';

extract($_GET);
$url = (isset($dir) && ($dir != '')) ? base64_decode(str_replace(['-', '_'], ['+', '/'], $dir)) : 'dash.php';

if (isset($_SESSION[$sid . 'loggedin'])) {
    echo "<script>window.location.href = '$url';</script>";
    exit;
} else {
    $https = ((!empty($_SERVER['HTTPS'])) && ($_SERVER['HTTPS'] != 'off')) ? true : false;
    if (!$https) {
        // header("location: ".SERVER_URL."/login");
        // header("location: login");
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description"
        content="FiberOne is the largest Fiber to the Home (FTTH) premium broadband provider in Nigeria. We deliver excellent Fiber internet services across homes and offices">
    <meta name="author" content="MATILUKO Opeyemi Emmanuel">
    <title>FOB Admin Portal - Login</title>

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="img/favicon.ico" />
    <link rel="icon" type="image/x-icon" href="img/favicon.ico" />
    <link rel="apple-touch-icon" sizes="180x180" href="img/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="img/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="img/favicon-16x16.png">
    <link rel="manifest" href="img/site.webmanifest">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- iCheck -->
    <link rel="stylesheet" href="plugins/iCheck/square/blue.css">

    <style>
        :root {
            --fob-primary: #0D3E9B;
            --fob-secondary: #E10000;
            --fob-light: #f8f9fa;
            --fob-dark: #2c3e50;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #ffffff;
            min-height: 100vh;
            overflow-x: hidden;
        }

        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
        }

        .login-card {
            background: rgba(255, 255, 255, 1);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(13, 62, 155, 0.1);
            overflow: hidden;
            transition: transform 0.3s ease;
        }

        .login-card:hover {
            transform: translateY(-5px);
        }

        .login-header {
            text-align: center;
            padding: 1.5rem 0 0.8rem;
            background: linear-gradient(135deg, var(--fob-primary), #1e5bb8);
            color: white;
            position: relative;
        }

        .login-header::before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 15px;
            background: white;
            border-radius: 50% 50% 0 0;
        }

        .logo-container {
            margin-bottom: 0.8rem;
            display: flex;
            justify-content: center;
        }

        .logo-wrapper {
            background: white;
            padding: 10px 15px;
            border-radius: 12px;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }

        .logo-container img {
            max-height: 40px;
            width: auto;
        }

        .welcome-text {
            font-size: 1.3rem;
            font-weight: 600;
            margin-bottom: 0.3rem;
        }

        .subtitle {
            font-size: 0.8rem;
            opacity: 0.9;
        }

        .login-form {
            padding: 1.5rem;
        }

        .form-floating {
            margin-bottom: 1rem;
        }

        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 0.75rem;
            font-size: 0.9rem;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--fob-primary);
            box-shadow: 0 0 0 0.2rem rgba(13, 62, 155, 0.25);
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--fob-primary), #1e5bb8);
            border: none;
            border-radius: 10px;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            font-size: 0.9rem;
            transition: all 0.3s ease;
            width: 100%;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #0a2f7a, var(--fob-primary));
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(13, 62, 155, 0.3);
        }

        .divider {
            text-align: center;
            margin: 1rem 0;
            position: relative;
        }

        .divider::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 1px;
            background: #e9ecef;
        }

        .divider span {
            background: white;
            padding: 0 0.8rem;
            color: #6c757d;
            font-size: 0.8rem;
        }

        .links-section {
            text-align: center;
            margin-top: 1rem;
        }

        .links-section a {
            color: var(--fob-primary);
            text-decoration: none;
            font-weight: 500;
            font-size: 0.85rem;
            transition: color 0.3s ease;
        }

        .links-section p {
            font-size: 0.85rem;
            margin-bottom: 0.5rem;
        }

        .links-section a:hover {
            color: var(--fob-secondary);
        }

        .app-download {
            margin-top: 1.5rem;
            padding: 1rem;
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            border-radius: 12px;
            text-align: center;
        }

        .app-download h6 {
            color: var(--fob-dark);
            margin-bottom: 0.8rem;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .app-buttons {
            display: flex;
            gap: 0.8rem;
            justify-content: center;
            flex-wrap: wrap;
        }

        .app-btn {
            display: inline-flex;
            align-items: center;
            gap: 0.4rem;
            padding: 0.4rem 0.8rem;
            background: var(--fob-dark);
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-size: 0.75rem;
            transition: all 0.3s ease;
        }

        .app-btn:hover {
            background: var(--fob-primary);
            color: white;
            transform: translateY(-2px);
        }

        .slider-section {
            background: linear-gradient(135deg, var(--fob-primary), #1e5bb8);
            color: white;
            padding: 1.5rem;
            display: flex;
            flex-direction: column;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }

        .slider-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('img/fob-logo-bg.jpg') center/cover;
            opacity: 0.1;
        }

        .slider-content {
            position: relative;
            z-index: 2;
        }

        .carousel-item {
            text-align: center;
            padding: 1.5rem 0.8rem;
            position: relative;
        }

        .carousel-image {
            width: 100%;
            height: 200px;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), rgba(255, 255, 255, 0.1));
            border-radius: 15px;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid rgba(255, 255, 255, 0.3);
            overflow: hidden;
        }

        .carousel-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 13px;
        }

        .carousel-item h4 {
            font-weight: 700;
            margin-bottom: 0.8rem;
            font-size: 1.2rem;
        }

        .carousel-item p {
            font-size: 0.95rem;
            line-height: 1.5;
            opacity: 0.9;
        }

        .carousel-indicators button {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            border: none;
            background: rgba(255, 255, 255, 0.5);
        }

        .carousel-indicators button.active {
            background: white;
        }

        @media (max-width: 768px) {
            .login-container {
                padding: 0.8rem;
            }

            .login-form {
                padding: 1.2rem;
            }

            .slider-section {
                order: -1;
                min-height: 250px;
                padding: 1rem;
            }

            .carousel-item {
                padding: 1rem 0.5rem;
            }

            .carousel-image {
                height: 150px;
                margin-bottom: 0.8rem;
            }

            .carousel-item h4 {
                font-size: 1rem;
            }

            .carousel-item p {
                font-size: 0.85rem;
            }

            .app-buttons {
                flex-direction: column;
                align-items: center;
                gap: 0.5rem;
            }

            .app-btn {
                width: 100%;
                max-width: 180px;
                justify-content: center;
                font-size: 0.7rem;
            }

            .login-header {
                padding: 1rem 0 0.5rem;
            }

            .welcome-text {
                font-size: 1.1rem;
            }

            .subtitle {
                font-size: 0.75rem;
            }
        }

        .floating-shapes {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: -1;
        }

        .shape {
            position: absolute;
            background: rgba(13, 62, 155, 0.03);
            border-radius: 50%;
            animation: float 6s ease-in-out infinite;
        }

        .shape1 {
            width: 80px;
            height: 80px;
            top: 20%;
            left: 10%;
            animation-delay: 0s;
        }

        .shape2 {
            width: 120px;
            height: 120px;
            top: 60%;
            right: 15%;
            animation-delay: 2s;
        }

        .shape3 {
            width: 60px;
            height: 60px;
            bottom: 20%;
            left: 20%;
            animation-delay: 4s;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-20px);
            }
        }

        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #6c757d;
            z-index: 10;
        }

        .password-field {
            position: relative;
        }

        .errPan {
            word-wrap: break-word;
            font-size: 0.85rem;
        }
    </style>
</head>

<body>
    <div class="floating-shapes">
        <div class="shape shape1"></div>
        <div class="shape shape2"></div>
        <div class="shape shape3"></div>
    </div>

    <div class="container-fluid login-container">
        <div class="row w-100 justify-content-center">
            <div class="col-lg-10 col-xl-8">
                <div class="login-card">
                    <div class="row g-0 h-100">
                        <!-- Login Form Section -->
                        <div class="col-lg-6">
                            <div class="login-header">
                                <div class="logo-container">
                                    <div class="logo-wrapper">
                                        <img src="img/thumbnail60.png" alt="Fiberone Broadband" class="img-fluid">
                                    </div>
                                </div>
                                <h2 class="welcome-text">Welcome Back</h2>
                                <p class="subtitle">Sign in to your admin account</p>
                            </div>

                            <div class="login-form">
                                <div class="alert alert-danger errPan" style="display:none" role="alert"></div>
                                <form id="loginForm" action="#" method="POST" autocomplete="off" spellcheck="off">
                                    <input type='text' name='username' id="username" value="fob0WxYz"
                                        style="visibility: hidden; display:none" required />

                                    <div class="form-floating">
                                        <input type="text" class="form-control validate-input" id="user" name="user"
                                            placeholder="Service ID" data-validate="Supply your Service ID"
                                            autocomplete="off" spellcheck="off" aria-autocomplete="both"
                                            aria-haspopup="false" autocapitalize="off" autocorrect="off" required
                                            autofocus>
                                        <label for="user"><i class="fas fa-user-md me-2"></i>Service ID</label>
                                    </div>

                                    <div class="form-floating password-field">
                                        <input type="password" class="form-control validate-input" id="pass" name="pass"
                                            placeholder="Password" data-validate="Enter password"
                                            autocomplete="new-password" spellcheck="off" aria-autocomplete="both"
                                            aria-haspopup="false" autocapitalize="off" autocorrect="off" required>
                                        <label for="pass"><i class="fas fa-lock me-2"></i>Password</label>
                                        <i class="fas fa-eye password-toggle" id="togglePassword"></i>
                                    </div>

                                    <div class="row align-items-center mb-2">
                                        <div class="col-6">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="remember"
                                                    name="remember">
                                                <label class="form-check-label" for="remember"
                                                    style="font-size: 0.8rem;">
                                                    Remember me
                                                </label>
                                            </div>
                                        </div>
                                        <div class="col-6 text-end">
                                            <a href="recover-pass" class="text-decoration-none"
                                                style="font-size: 0.8rem;">Reset Password</a>
                                        </div>
                                    </div>

                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-sign-in-alt me-2"></i>Sign In
                                    </button>
                                </form>

                                <div class="divider">
                                    <span>or</span>
                                </div>

                                <div class="links-section">
                                    <p class="mb-1">Don't have an account? <a href="https://www.fob.ng/signup">Sign up
                                            here</a></p>
                                </div>

                                <div class="app-download">
                                    <h6><i class="fas fa-mobile-alt me-2"></i>Download MyFOB App</h6>
                                    <div class="app-buttons">
                                        <a href="https://play.google.com/store/apps/details?id=ng.fob.mobile&hl=en"
                                            target="_blank" class="app-btn">
                                            <i class="fab fa-google-play"></i>
                                            <span>Google Play</span>
                                        </a>
                                        <a href="https://apps.apple.com/ng/app/myfob/id1412642843" target="_blank"
                                            class="app-btn">
                                            <i class="fab fa-apple"></i>
                                            <span>App Store</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Slider Section -->
                        <div class="col-lg-6 slider-section">
                            <div class="slider-content">
                                <div id="promoCarousel" class="carousel slide" data-bs-ride="carousel">
                                    <div class="carousel-indicators">
                                        <button type="button" data-bs-target="#promoCarousel" data-bs-slide-to="0"
                                            class="active"></button>
                                        <button type="button" data-bs-target="#promoCarousel"
                                            data-bs-slide-to="1"></button>
                                        <button type="button" data-bs-target="#promoCarousel"
                                            data-bs-slide-to="2"></button>
                                    </div>
                                    <div class="carousel-inner">
                                        <div class="carousel-item active">
                                            <div class="carousel-image">
                                                <img src="web-banners/wide1.png" alt="Ultra-Fast Fiber Internet">
                                            </div>
                                            <h4><i class="fas fa-wifi me-2"></i>Ultra-Fast Fiber Internet</h4>
                                            <p>Experience lightning-fast speeds with our premium fiber-to-home
                                                technology. Reliable, consistent, and blazing fast internet for your
                                                home and business.</p>
                                        </div>
                                        <div class="carousel-item">
                                            <div class="carousel-image">
                                                <img src="web-banners/wide2.jpg" alt="Secure & Reliable">
                                            </div>
                                            <h4><i class="fas fa-shield-alt me-2"></i>Secure & Reliable</h4>
                                            <p>Nigeria's most trusted fiber network provider. 99.9% uptime guarantee
                                                with enterprise-grade security and 24/7 customer support.</p>
                                        </div>
                                        <div class="carousel-item">
                                            <div class="carousel-image">
                                                <img src="web-banners/wide3.jpg" alt="Leading Innovation">
                                            </div>
                                            <h4><i class="fas fa-rocket me-2"></i>Leading Innovation</h4>
                                            <p>Pioneering the future of internet connectivity in Nigeria. Join thousands
                                                of satisfied customers enjoying premium fiber internet services.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <p style="display:none">Application Developed By: MATILUKO Opeyemi E. (FDLN)</p>

    <!-- jQuery -->
    <script src="bower_components/jquery/dist/jquery.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- iCheck -->
    <script src="plugins/iCheck/icheck.min.js"></script>
    <!-- Validation Scripts -->
    <script src="dist/js/jquery.validate.js" type="text/javascript" charset="utf-8"></script>
    <script src="dist/js/validator.min.js" type="text/javascript" charset="utf-8"></script>

    <script>
        $(function() {
            // Initialize iCheck
            $('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-blue',
                radioClass: 'iradio_square-blue',
                increaseArea: '20%'
            });

            // Password toggle functionality
            $('#togglePassword').on('click', function() {
                const password = $('#pass');
                const type = password.attr('type') === 'password' ? 'text' : 'password';
                password.attr('type', type);
                $(this).toggleClass('fa-eye fa-eye-slash');
            });

            // Fade in/out for error messages
            var fadeInFadeOut = function(jQueryElement, timeout) {
                jQueryElement.fadeIn(1000);
                setTimeout(function() {
                    jQueryElement.fadeOut("slow");
                }, timeout);
            };

            // Base64 encoding for password
            var Base64 = {
                _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
                encode: function(e) {
                    var t = "";
                    var n, r, i, s, o, u, a;
                    var f = 0;
                    e = Base64._utf8_encode(e);
                    while (f < e.length) {
                        n = e.charCodeAt(f++);
                        r = e.charCodeAt(f++);
                        i = e.charCodeAt(f++);
                        s = n >> 2;
                        o = (n & 3) << 4 | r >> 4;
                        u = (r & 15) << 2 | i >> 6;
                        a = i & 63;
                        if (isNaN(r)) {
                            u = a = 64;
                        } else if (isNaN(i)) {
                            a = 64;
                        }
                        t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a);
                    }
                    return t;
                },
                _utf8_encode: function(e) {
                    e = e.replace(/\r\n/g, "\n");
                    var t = "";
                    for (var n = 0; n < e.length; n++) {
                        var r = e.charCodeAt(n);
                        if (r < 128) {
                            t += String.fromCharCode(r);
                        } else if (r > 127 && r < 2048) {
                            t += String.fromCharCode(r >> 6 | 192);
                            t += String.fromCharCode(r & 63 | 128);
                        } else {
                            t += String.fromCharCode(r >> 12 | 224);
                            t += String.fromCharCode(r >> 6 & 63 | 128);
                            t += String.fromCharCode(r & 63 | 128);
                        }
                    }
                    return t;
                }
            };

            // Form validation and AJAX submission
            $('#loginForm').validator().on('submit', function(e) {
                if (e.isDefaultPrevented()) {
                    alert("Please fill in all fields correctly");
                } else {
                    e.preventDefault();
                    var username = $('#user').val();
                    var username_verify = $('#username').val();
                    var pass = $('#pass').val();
                    var npass = Base64.encode(pass);
                    var dat = "user=" + username + "&pass=" + encodeURIComponent(npass) + "&username=" + username_verify;

                    $('#myLoading').modal({
                        keyboard: false,
                        show: true,
                        backdrop: "static"
                    });

                    $.ajax({
                        type: "POST",
                        url: "ajax/loginv2.php",
                        data: dat,
                        success: function(response) {
                            if (response.match(/Success/i)) {
                                $('#myLoading').modal("hide");
                                window.location.href = '<?PHP echo $url; ?>';
                            } else {
                                $('#myLoading').modal("hide");
                                $('.errPan').html(response);
                                fadeInFadeOut($(".errPan"), 5000);
                            }
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            $('#myLoading').modal("hide");
                            $('.errPan').html("Sorry, cannot contact server at this time. Please try again later! E:" + errorThrown);
                            fadeInFadeOut($(".errPan"), 5000);
                        }
                    });
                }
            });

            // Auto-advance carousel
            const carousel = new bootstrap.Carousel(document.getElementById('promoCarousel'), {
                interval: 5000,
                ride: 'carousel'
            });

            // Add smooth animations on load
            window.addEventListener('load', function() {
                document.querySelector('.login-card').style.animation = 'fadeInUp 0.8s ease-out';
            });

            // Add CSS for fade in animation
            const style = document.createElement('style');
            style.textContent = `
                @keyframes fadeInUp {
                    from {
                        opacity: 0;
                        transform: translateY(30px);
                    }
                    to {
                        opacity: 1;
                        transform: translateY(0);
                    }
                }
            `;
            document.head.appendChild(style);
        });
    </script>
</body>

</html>