<?PHP 
$page = "Loyalty Promo Dashboard";
$page_url="loy_userdash";
include_once 'includes/header.php'; 
include_once 'includes/sidemenu.php';

if ( isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201) ) :
    
?>
   <script> window.location.href = 'dash'; </script>
<?PHP
    exit();
endif;

$user = $_SESSION[$sid.'username'];
$pck = $_SESSION[$sid.'package'];
$pckID = $_SESSION[$sid.'package_id'];

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$loy = new LoyaltyPromo($db);
$uprofile = new UserProfile($db);

//getPlan from Package
$planDet = ($uprofile->loadPlans($pckID)); 
foreach ($planDet as $key => $value) {
    $plan = $value['PLAN'];
    $planID = $value['PLAN_ID'];
}

$planStatus = $loy->getPlanStatus($planID)[0]["ISACTIVE"];
//echo "PS: $planStatus |$planID|"; print_r($loy->getPlanStatus($planID));
if ($planStatus) :
    $accumPt = $loy->getAccumulatedPoints($user)[$user]; 
    $redeemed = $loy->getRedeemedPoint($user)[$user]; 
    $redeemable = $accumPt - $redeemed; 
    $planReward = $loy->getPlanRewardPoint($planID); 
    $planRewardPt = $planReward['SERVICE_EXTENSION']["REQUIRED_POINT"]; 
    $pt2Redemption = $planRewardPt - $redeemable; 
endif;

?>
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/all.min.css" integrity="sha256-mmgLkCYLUQbXn0B1SRqzHar6dCnv9oZFPEC1g1cwlkk=" crossorigin="anonymous" />
   <link rel="stylesheet" href="dist/css/dash-widget.css"  />
   
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Loyalty Promo Dashboard
        <small>Control panel</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Loyalty Promo Dashboard</li>
      </ol>
    </section>
    
    <?PHP
    if (!$planStatus) :
    ?>
    <!-- Disabled Promo content -->
    <section class="content">
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                  <div class="box-header with-border">
                    <h3 class="box-title">Recent Activities & Points Garnered</h3>
                  </div>
                  <div class="box-body">
                      <div class="col-md-12">
                          <h3>Promo is currently not running!</h3>
                      </div>
                  </div>
                    
                </div>
            </div>
            
        </div>
    </section>

    <?PHP
    endif;
    ?>

    
    <?PHP
    if ($planStatus) :
    ?>
    <!-- Main content -->
    <section class="content">
        <!-- Stats -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.12.1/css/all.min.css" integrity="sha256-mmgLkCYLUQbXn0B1SRqzHar6dCnv9oZFPEC1g1cwlkk=" crossorigin="anonymous" />

        <div class="col-md-12 ">
            <div class="row ">
                <div class="col-xl-1 col-lg-3">
                    <div class="card l-bg-cherry">
                        <div class="card-statistic-3 p-4">
                            <div class="card-icon card-icon-large"><i class="fas fa-shopping-cart"></i></div>
                            <div class="mb-4">
                                <h5 class="card-title mb-0">Accumulated Points (Life-time)</h5>
                            </div>
                            <div class="row align-items-center mb-2 d-flex">
                                <div class="col-8">
                                    <h2 class="d-flex align-items-center mb-0">
                                        <?PHP echo number_format($accumPt, 0); ?>
                                    </h2>
                                </div>
                                <div class="col-4 text-right">
                                    <span>12.5% <i class="fa fa-arrow-up"></i></span>
                                </div>
                            </div>
                            <div class="progress mt-1 " data-height="8" style="height: 8px;">
                                <div class="progress-bar l-bg-cyan" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;">
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-1 col-lg-3">
                    <div class="card l-bg-blue-dark">
                        <div class="card-statistic-3 p-4">
                            <div class="card-icon card-icon-large"><i class="fas fa-wallet"></i></div>
                            <div class="mb-4">
                                <h5 class="card-title mb-0">Redeemable Points</h5>
                            </div>
                            <div class="row align-items-center mb-2 d-flex">
                                <div class="col-8">
                                    <h2 class="d-flex align-items-center mb-0">
                                        <?PHP echo $redeemable; ?>
                                    </h2>
                                </div>
                                <div class="col-4 text-right">
                                    <span>9.23% <i class="fa fa-arrow-up"></i></span>
                                </div>
                            </div>
                            <div class="progress mt-1 " data-height="8" style="height: 8px;">
                                <div class="progress-bar l-bg-green" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;">
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-1 col-lg-3">
                    <div class="card l-bg-green-dark">
                        <div class="card-statistic-3 p-4">
                            <div class="card-icon card-icon-large"><i class="fas fa-ticket-alt"></i></div>
                            <div class="mb-4">
                                <h5 class="card-title mb-0">Redeemed Points</h5>
                            </div>
                            <div class="row align-items-center mb-2 d-flex">
                                <div class="col-8">
                                    <h2 class="d-flex align-items-center mb-0">
                                        <?PHP echo number_format($redeemed,0); ?>
                                    </h2>
                                </div>
                                <div class="col-4 text-right">
                                    <span>10% <i class="fa fa-arrow-up"></i></span>
                                </div>
                            </div>
                            <div class="progress mt-1 " data-height="8" style="height: 8px;">
                                <div class="progress-bar l-bg-orange" role="progressbar" data-width="25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;">
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-1 col-lg-3">
                    <div class="card l-bg-orange-dark">
                        <div class="card-statistic-3 p-4">
                            <div class="card-icon card-icon-large"><i class="fas fa-battery-three-quarters"></i></div>
                            <div class="mb-4">
                                <h5 class="card-title mb-0">Point to Redemption</h5>
                            </div>
                            <div class="row align-items-center mb-2 d-flex">
                                <div class="col-8">
                                    <h2 class="d-flex align-items-center mb-0">
                                        <?PHP echo $pt2Redemption; ?>
                                    </h2>
                                </div>
                                <div class="col-4 text-right">
                                    <span><?PHP echo ((($planRewardPt-$pt2Redemption)/$planRewardPt)*100); ?>% <i class="fa fa-arrow-up"></i></span>
                                </div>
                            </div>
                            <div class="progress mt-1 " data-height="8" style="height: 8px;">
                                <div class="progress-bar l-bg-cyan" role="progressbar" data-width="<?PHP echo ((($planRewardPt-$pt2Redemption)/$planRewardPt)*100); ?>%" aria-valuenow="<?PHP echo ((($planRewardPt-$pt2Redemption)/$planRewardPt)*100); ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?PHP echo ((($planRewardPt-$pt2Redemption)/$planRewardPt)*100); ?>%;">
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.Stats -->
        
        <?PHP
        if ( ($redeemed > 0) || ($pt2Redemption <= 0) ) :
        ?>
        <!-- redemption -->
        <div class="row">
            <div class="col-md-4">
                <div class="box box-primary">
                  <div class="box-header with-border">
                    <h3 class="box-title">Redeem Point(s)</h3>
                  </div>
                  <div class="box-body">
                    <div class="col-md-12">
                       <!-- Redemption Form  -->
                    </div>

                  </div>
                  <!-- /.box-body -->
                </div>
                <!-- /.box -->

              </div>
            
            <div class="col-md-8">
                <div class="box box-primary">
                  <div class="box-header with-border">
                    <h3 class="box-title">Redemption History</h3>
                  </div>
                  <div class="box-body">
                    <div class="col-md-12">
                      <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                          <thead>
                          <tr>
                              <th>SN</th>
                              <th style='text-align: center !important;'>PLAN</th>
                              <th style='text-align: center !important;'>POINTS<br/>REDEEMED</th>
                              <th style='text-align: center !important;'>REWARD</th>
                              <th style='text-align: center !important;'>DATE</th>
                          </tr>
                          </thead>
                          <tbody>
                              <?PHP
                              $userRedemption = $loy->getRedemptionHistory($user);
                              $sn = 0; 
                              foreach ($userRedemption as $key => $value) {
                              ?>
                              <tr>
                                  <td><?PHP echo ++$sn; ?></td>
                                  <td><?PHP echo $value['USER_SERVICE']; ?></td>
                                  <td><?PHP echo $value['POINTS_REDEEMED']; ?></td>
                                  <td><?PHP echo $value['REWARD']; ?></td>
                                  <td><?PHP echo $value['DATE_REDEEMED']; ?></td>
                              </tr>
                              
                              <?PHP
                              }
                              ?>

                          </tbody>
                        </table>
<!--                          <div>** denotes Primary Service ID</div>
                          <div><span class='label-default label label-success'>&nbsp;</span> denotes Active Account</div>
                          <div><span class='label-default label label-danger'>&nbsp;</span> denotes Disabled Account</div>-->
                      </div>

                  </div>
                  <!-- /.box-body -->
                </div>
                <!-- /.box -->

              </div>
        </div>
        <!-- /.redemption -->
        
        <?PHP
        endif;
        ?>
        
        <!-- info -->
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                  <div class="box-header with-border">
                    <h3 class="box-title">Recent Activities & Points Garnered</h3>
                  </div>
                  <div class="box-body">
                    <div class="col-md-12">
                      <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                          <thead>
                          <tr>
                              <th>SN</th>
                              <th style='text-align: center !important;'>ACTIVITY</th>
                              <th style='text-align: center !important;'>QTY</th>
                              <th style='text-align: center !important;'>POINTS</th>
                              <th style='text-align: center !important;'>DATE</th>
                          </tr>
                          </thead>
                          <tbody>
                              <?PHP
                              $userActvities = $loy->getUserActivities($user);
                              $sn = 0; 
                              foreach ($userActvities as $key => $value) {
                              ?>
                              <tr>
                                  <td><?PHP echo ++$sn; ?></td>
                                  <td><?PHP echo $value['ACT_TYPE']; ?></td>
                                  <td><?PHP echo $value['QUANTITY']; ?></td>
                                  <td><?PHP echo $value['POINT_EARNED']; ?></td>
                                  <td><?PHP echo $value['ACT_DATE']; ?></td>
                              </tr>
                              
                              <?PHP
                              }
                              ?>

                          </tbody>
                        </table>
                          <div>** denotes Primary Service ID</div>
                          <div><span class='label-default label label-success'>&nbsp;</span> denotes Active Account</div>
                          <div><span class='label-default label label-danger'>&nbsp;</span> denotes Disabled Account</div>
                      </div>

                  </div>
                  <!-- /.box-body -->
                </div>
                <!-- /.box -->

              </div>
            
            
              <div class="col-md-4">
                <div class="box box-primary">
                  <div class="box-header with-border">
                    <h3 class="box-title">Activity Point(s) - <?PHP echo $plan; ?></h3>
                  </div>
                  <div class="box-body">
                    <div class="col-md-12">
                      <table id="acctable" class='table table-striped table-bordered bootstrap-datatable datatable responsive dataTable'>
                          <thead>
                          <tr>
                              <th>SN</th>
                              <th style='text-align: center !important;'>ACTIVITY</th>
                              <th style='text-align: center !important;'>POINT(S)</th>
                          </tr>
                          </thead>
                          <tbody>
                              <?PHP
                              $planPtSettings = $loy->getPointSettingsByPlan($planID);
                              foreach ($planPtSettings as $key => $value) {
                              ?>
                              <tr>
                                  <td style='text-align: center !important;'><?PHP echo $value['SN']; ?></td>
                                  <td><?PHP echo $value['ACTIVITY']; ?></td>
                                  <td style='text-align: center !important;'><?PHP echo $value['ACTIVITY_POINT']; ?></td>
                              </tr>
                              
                              <?PHP
                              }
                              ?>

                          </tbody>
                        </table>
                          <div>** point(s) above is based on your plan</div>
                      </div>

                  </div>
                  <!-- /.box-body -->
                </div>
                <!-- /.box -->

              </div>
        </div>
        
    </section>
    <!-- /.info -->

    <?PHP
    endif;
    ?>
    
</div>
<!-- /.content-wrapper -->
   
   
<?PHP include_once 'includes/footer.php'; ?>
<script type="text/javascript">
   $(document).ready(function () {
       
       
       
   });
   
</script>

<?PHP include_once 'includes/footer_end.php';