<?PHP  
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';
//include_once 'includes/hcloser.php'; //nologin

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8"); 

$ad = new UserProfile($db);

extract($_GET);
extract($_POST);

$txnid = substr(base64_decode(substr(urldecode($urv), 10)), 15); 
if ((!preg_match('/^[a-zA-Z0-9\-\/\r\n+]*={0,2}$/', $txnid))) { 
    // invalid
    die("<h2>Invalid URI</h2>");
} 
$txnref = $txnid;
$vval =  $ad->getTransactionByID($txnid);
// echo "<br>vall:: ";print_r($vval);
if (($vval['DB_UPDATED'] != 1) || $vval['STATUS_CODE'] <> '00') :
    //stop, payment not confirmed in DB
    echo "Payment yet to be processed";
    exit();
endif;
$isupcountry = $vval['IS_UPCOUNTRY'];

$db->close();
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>MyFOB [Web] | Renewal Invoice</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <meta name="description" content="FiberOne is the largest Fiber to the Home (FTTH) premium broadband provider in Nigeria. We deliver excellent Fiber internet services across homes and offices">
    <meta name="author" content="MATILUKO Opeyemi Emmanuel">
  <link rel="shortcut icon" type="image/x-icon" href="<?PHP echo SERVER_URL; ?>img/favicon.ico"/>
  <link rel="icon" type="image/x-icon" href="<?PHP echo SERVER_URL; ?>img/favicon.ico"/>
  <!-- Bootstrap 3.3.7 -->
  <link rel="stylesheet" href="<?PHP echo SERVER_URL; ?>bower_components/bootstrap/dist/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?PHP echo SERVER_URL; ?>bower_components/font-awesome/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="<?PHP echo SERVER_URL; ?>bower_components/Ionicons/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?PHP echo SERVER_URL; ?>dist/css/AdminLTE.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->

  <!-- Google Font -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
  
  <style>
      body {
          /*font-size:1.2em;*/
      }
  </style>
</head>
<body onload="">
    <div class="wrapper">
  <!-- Main content -->
  <section class="invoice" style="width:70%; margin:0px auto; min-width:330px; max-width: 1080px">
    <!-- title row -->
    <div class="row">
      <div class="col-xs-12">
        <h2 class="page-header">
          <img src="data:image/png;base64,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" data-filename="fobb 1024.png" style="width: 200px;">
          <small class="pull-right">Date: <?PHP 
          list($y, $m, $d) = sscanf($vval["PAY_DATE"], '%d-%d-%d %s');      
          $invdate = "$d-$m-$y";
          echo $invdate; ?></small>
        </h2>
      </div>
      <!-- /.col -->
    </div>
    <!-- info row -->
    <div class="row invoice-info">
      <div class="col-sm-4 invoice-col">
        From
        <address>
          <strong>FiberOne Broadband</strong><br>
          14 Allen Avenue,Ikeja<br>
          Lagos, Nigeria<br>
          Phone: 09087981900<br>
          Email: <?PHP echo ($isupcountry)? "kfiber@fob.ng" : "accounts@fob.ng" ; ?>
        </address>
      </div>
      <!-- /.col -->
      <div class="col-sm-4 invoice-col">
        To
        <address>
          <strong><?PHP echo $vval["firstname"] . " ".$vval["lastname"]; ?></strong><br>
          <?PHP echo $vval["company"]; ?><br>
          <?PHP echo $vval["address"]; ?><br>
          Phone: <?PHP echo $vval["phone"]; ?><br>
          Email: <?PHP echo $vval["email"]; ?>
        </address>
      </div>
      <!-- /.col -->
      <div class="col-sm-4 invoice-col">
        <b>Invoice #: <?PHP echo "R".$vval["ID"]; ?></b><br>
        <br>
        <b>TIN #:</b> 20458225-0001<br/>

      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->

    <!-- Table row -->
    <div class="row">
      <div class="col-xs-12 table-responsive">
          <h2>TRANSACTION #: <?PHP echo $vval["TRANX_ID"]; ?></h2>
        <table class="table table-striped table-bordered">
          <thead>
          <tr>
            <th align="center" style="text-align: center;">SN</th>
            <th>Description</th>
            <th align="center" style="text-align: center;">Qty</th>
            <th align="center" style="text-align: center;">Unit Price (&#8358;)</th>
            <th align="center" style="text-align: center;">Price (&#8358;)</th>
          </tr>
          </thead>
          <tbody>
          <tr>
            <td align="center"><?PHP echo ++$ct; ?></td>
            <td>Renewal Payment for <?PHP echo $vval["srvname"]; ?> plan for <?PHP echo $vval['NMONTHS']; ?> months <?PHP echo $vval['PROMO']?"[{$vval['PROMO']}]":""; ?></td>
            <td align="center"><?PHP echo $vval["NMONTHS"]; ?></td>
            <td align="right"><?PHP echo number_format($vval["APPR_AMOUNT"]/$vval['NMONTHS'],2); ?></td>
            <td align="right"><?PHP echo number_format($vval['APPR_AMOUNT'],2); ?></td>
          </tr>
          <tr>
            <td align="center">&nbsp;</td>
            <td>&nbsp;</td>
            <td align="center">&nbsp;</td>
            <td align="right">&nbsp;</td>
            <td align="right">&nbsp;</td>
          </tr>
          </tbody>
        </table>
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->

    <div class="row">

      <!-- /.col -->
      <div class="col-xs-6">
        <p class="lead">Payment Mode:  <?PHP echo $vval['PAY_GATEWAY']; ?></p>
        <p class="lead">Payment Ref.:  <?PHP echo $vval['PAY_REFERENCE']; ?></p>
      </div>
      <div class="col-xs-6" style="float:right">
        <div class="table-responsive">
          <table class="table">

            <tr>
              <th>Total NGN:</th> <!--  Incl. VAT -->
              <th align="right" style="text-align: right;">&#8358;<?PHP echo number_format($vval["APPR_AMOUNT"],2); ?></th>
            </tr>
          </table>
        </div>
      </div>
      <!-- /.col -->
    </div>
    <!-- /.row -->
    
    <!--Payment Status -->
      <div class="clearfix"></div>
      <div class="row ">
        <div class="col-xs-12">
            <a href="#" onclick="window.print();" class="btn btn-default"><i class="fa fa-print"></i> Print</a>
 
          <img src='data:image/png;base64,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' class='pull-right' width="200" />

<!--           <button type="button" class="btn btn-primary pull-right" style="margin-right: 20px;" onclick="downloadPDF()" style="margin-right: 15px;">
            <i class="fa fa-download"></i> Generate PDF
          </button> -->

        </div>
      </div>
      
  </section>
  <!-- /.content -->
</div>
<!-- ./wrapper -->



<!-- jQuery 3 -->
<script src="<?PHP echo SERVER_URL; ?>bower_components/jquery/dist/jquery.min.js"></script>
<!-- jQuery UI 1.11.4 -->
<script src="<?PHP echo SERVER_URL; ?>bower_components/jquery-ui/jquery-ui.min.js"></script>
<!-- <script type="text/javascript" src="<?PHP // echo SERVER_URL; ?>bower_components/pdfmake-0.1.36/pdfmake.min.js"></script>
<script type="text/javascript" src="<?PHP // echo SERVER_URL; ?>bower_components/pdfmake-0.1.36/vfs_fonts.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
<script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.36/build/vfs_fonts.js"></script>

<script src="<?PHP echo SERVER_URL; ?>dist/js/browser.js"></script>
<!-- <script src='https://requirejs.org/docs/release/2.3.5/minified/require.js'></script> -->
<script type="text/javascript">

downloadPDF = function(){
//    var cont = document.getElementsByClassName("content-wrapper").innerHTML;
    

    var cont = $('body').html();  //.html()
    // console.log(cont);
	// cont=JSON.parse(JSON.stringify(cont));
    var val = htmlToPdfmake(cont); console.log(val)
    var dd = {watermark: { text: 'FiberOne', angle: 70, color: 'blue', opacity: 0.1, fontSize: 16 }, content:val,
	styles: {
        header: {
          fontSize: '22px',
          bold: true
        },
        anotherStyle: {
          italics: true,
          alignment: 'right'
        }
      }
    }; console.log(dd)
    pdfMake.createPdf(dd).download();
};

// downloadPDF();

</script>

</body>
</html>