<?php
$page = "Order Detail Dashboard";
$page_url = "order_detail";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (!isset($_GET['id'])):
    ?>
    <script>
        window.location.href = 'vendor_orders';
    </script>
    <?php
    exit();
endif;
$orderID = base64_decode(urldecode($_GET['id']));
?>

<?php
//dexit();

$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

//include_once 'includes/accesschk.php'; 
//print_r($productId);
//$_SESSION[$sid . 'loggedin']
$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
if (isset($_SESSION[$sid . 'loggedin']) && $_SESSION[$sid . 'loggedin'] == 201) {
    $order_details = $dashboard->getFobOrderDetails($orderID);
} else {
    $vendor_id = $dashboard->getVendorState($_SESSION[$sid . 'userid']);
    $order_details = $dashboard->getVendorOrderDetails($vendor_id, $orderID);
}

?>


<style>
    .main-content {
        margin-left: 230px;
        background-color: white;
        min-height: 100vh;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb-separator {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb-current {
        color: #333;
        font-size: 14px;
    }

    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
    }

    .action-buttons {
        display: flex;
        gap: 10px;
    }

    .btn-update {
        background-color: #2c5aa0;
        border-color: #2c5aa0;
        color: white;
        padding: 8px 20px;
        font-weight: 500;
        border-radius: 4px;
        border: none;
        cursor: pointer;
    }

    .btn-disabled {
        background-color: #6c757d;
        border-color: #6c757d;
        color: white;
        padding: 8px 20px;
        font-weight: 500;
        border-radius: 4px;
        cursor: not-allowed;
        opacity: 0.65;
    }

    .info-card {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        margin-bottom: 25px;
        overflow: hidden;
    }

    .card-header {
        background-color: #f8f9fa;
        display: flex;
        justify-content: space-between;
        padding: 15px 20px;
        border-bottom: 1px solid #e9ecef;
        font-weight: 600;
        color: #333;
    }

    .card-body {
        padding: 20px;
    }

    .form-row {
        display: flex;
        margin-bottom: 15px;
        align-items: center;
        justify-content: space-between;
    }

    .form-label {
        width: 180px;
        color: #666;
        font-weight: 500;
        margin-bottom: 0;
    }

    .form-value {
        flex: 1;
        color: #333;
        font-weight: 400;
        word-break: break-word;
    }

    .status {
        display: inline-block;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 0.9em;
        font-weight: bold;
        color: white;
    }

    .status.fulfilled {
        background-color: #28a745;
    }

    .status.declined,
    .status.canceled {
        background-color: #dc3545;
    }

    .status.pending {
        background-color: #ffc107;
    }

    .table-responsive {
        margin-bottom: 20px;
    }

    .table {
        width: 100%;
        border-collapse: collapse;
        background-color: #fff;
    }

    .table th,
    .table td {
        padding: 12px;
        border: 1px solid #e9ecef;
        text-align: left;
    }

    .table th {
        background-color: #1976d2;
        color: white;
        font-weight: 600;
    }

    .table tbody tr:nth-child(even) {
        background-color: #f8f9fa;
    }

    .table tbody tr:hover {
        background-color: #e9ecef;
    }

    .alert {
        position: fixed;
        top: 90px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .alert-dismissible .close {
        position: absolute;
        top: 0;
        right: 10px;
        padding: 10px;
        color: inherit;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
            padding: 15px;
        }

        .content-area {
            padding: 0 15px 15px;
        }

        .page-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .form-row {
            flex-direction: column;
            align-items: flex-start;
            gap: 5px;
        }

        .form-label {
            width: 100%;
        }

        .form-value {
            width: 100%;
        }
    }

    @media (max-width: 576px) {
        .action-buttons {
            flex-direction: column;
            gap: 10px;
            width: 100%;
        }

        .btn-update,
        .btn-disabled {
            width: 100%;
            text-align: center;
        }
    }
</style>

<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Order Details</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span class="breadcrumb-separator">></span>
            <a href="#" onclick="navigateTo('vendor_orders')">Orders</a>
            <span class="breadcrumb-separator">></span>
            <span class="breadcrumb-current">Order Details</span>
        </nav>

        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-title">Order #<?= htmlspecialchars($order_details['order']['order_id']) ?></h1>
            <div class="action-buttons">
                <?php if (strtolower($order_details['order']['status']) === 'fulfilled'): ?>
                    <button class="btn-disabled" disabled>Fulfilled</button>
                <?php else: ?>
                    <form id="orderStatusForm" style="display:inline;">
                        <input type="hidden" name="order_id"
                            value="<?= htmlspecialchars($order_details['order']['order_id']) ?>">
                        <select name="status" id="statusSelect" style="padding:8px; border-radius:4px;">
                            <option value="">-- Change Status --</option>
                            <option value="fulfilled">Fulfilled</option>
                            <option value="declined">Declined</option>
                            <option value="canceled">Canceled</option>
                        </select>
                        <button type="submit" class="btn-update">Update</button>
                    </form>
                <?php endif; ?>
            </div>
        </div>

        <?php if (empty($order_details)): ?>
            <div class="info-card">
                <div class="card-header">
                    <p>Error</p>
                </div>
                <div class="card-body" style="text-align: center;">
                    <h2 style="color: #dc3545;">Order Not Found</h2>
                    <p>The requested order could not be found for this vendor.</p>
                </div>
            </div>
        <?php else: ?>
            <div class="row">
                <!-- Left Column -->
                <div class="col-md-6">
                    <!-- Customer Information -->
                    <div class="info-card">
                        <div class="card-header">
                            <div>
                                <p>Customer Information</p>
                                <p class="date-badge">Placed on:
                                    <?= date('F j, Y H:i', strtotime($order_details['order']['created_at'])) ?>
                                </p>
                            </div>
                            <!-- <button class="action-btn">
                                <i class="fa fa-ellipsis-v"></i>
                            </button> -->
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-label">Name</div>
                                <div class="form-value"><?= htmlspecialchars($order_details['customer']['name']) ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Email</div>
                                <div class="form-value"><?= htmlspecialchars($order_details['customer']['email']) ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Phone</div>
                                <div class="form-value"><?= htmlspecialchars($order_details['customer']['phone']) ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Address</div>
                                <div class="form-value"><?= htmlspecialchars($order_details['customer']['address']) ?></div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Status</div>
                                <div class="form-value">
                                    <span class="status <?= strtolower($order_details['order']['status']) ?>"
                                        id="currentStatus">
                                        <?= ucfirst(htmlspecialchars($order_details['order']['status'])) ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-md-6">
                    <!-- Order Summary -->
                    <div class="info-card">
                        <div class="card-header">
                            <p>Order Summary</p>
                        </div>
                        <div class="card-body">
                            <div class="form-row">
                                <div class="form-label">Subtotal</div>
                                <div class="form-value">N<?= number_format($order_details['order']['subtotal_amount'], 2) ?>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Tax</div>
                                <div class="form-value">N<?= number_format($order_details['order']['tax_amount'], 2) ?>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-label">Shipping</div>
                                <div class="form-value">N<?= number_format($order_details['order']['shipping_amount'], 2) ?>
                                </div>
                            </div>
                            <?php if ($order_details['order']['discount_amount'] > 0): ?>
                                <div class="form-row">
                                    <div class="form-label">Discount</div>
                                    <div class="form-value">
                                        -N<?= number_format($order_details['order']['discount_amount'], 2) ?></div>
                                </div>
                            <?php endif; ?>
                            <div class="form-row" style="font-weight: bold; background-color: #f0f0f0; padding: 8px;">
                                <div class="form-label">Total</div>
                                <div class="form-value">
                                    N<?= number_format($order_details['order']['subtotal_amount'] + $order_details['order']['tax_amount'] + $order_details['order']['shipping_amount'] - $order_details['order']['discount_amount'], 2) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <!-- Order Items -->
            <div class="col-12">
                <div class="info-card">
                    <div class="card-header">
                        <p>Order Items</p>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Product</th>
                                        <th style="text-align: center;">SKU</th>
                                        <th style="text-align: center;">Qty</th>
                                        <th style="text-align: right;">Unit Price</th>
                                        <th style="text-align: right;">Line Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($order_details['items'] as $item): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($item['product_name']) ?></td>
                                            <td style="text-align: center;"><?= htmlspecialchars($item['product_sku']) ?>
                                            </td>
                                            <td style="text-align: center;"><?= $item['quantity'] ?></td>
                                            <td style="text-align: right;">N<?= number_format($item['unit_price'], 2) ?>
                                            </td>
                                            <td style="text-align: right;">N<?= number_format($item['line_total'], 2) ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Alerts -->
        <div class="alert alert-danger" id="errPan" style="display: none;"></div>
        <div class="alert alert-success" id="succPan" style="display: none;"></div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>

<script>
    $(document).ready(function () {
        // Show an element and then fade it out
        var fadeInFadeOut = function (jQueryElement, timeout) {
            jQueryElement.fadeIn(1000);
            setTimeout(function () {
                jQueryElement.fadeOut("slow");
            }, timeout);
        };

        var Base64 = {
            _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
            encode: function (e) {
                var t = "";
                var n, r, i, s, o, u, a;
                var f = 0;
                e = Base64._utf8_encode(e);
                while (f < e.length) {
                    n = e.charCodeAt(f++);
                    r = e.charCodeAt(f++);
                    i = e.charCodeAt(f++);
                    s = n >> 2;
                    o = (n & 3) << 4 | r >> 4;
                    u = (r & 15) << 2 | i >> 6;
                    a = i & 63;
                    if (isNaN(r)) {
                        u = a = 64;
                    } else if (isNaN(i)) {
                        a = 64;
                    }
                    t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a);
                }
                return t;
            },
            decode: function (e) {
                var t = "";
                var n, r, i;
                var s, o, u, a;
                var f = 0;
                e = e.replace(/[^A-Za-z0-9\+\/\=]/g, "");
                while (f < e.length) {
                    s = this._keyStr.indexOf(e.charAt(f++));
                    o = this._keyStr.indexOf(e.charAt(f++));
                    u = this._keyStr.indexOf(e.charAt(f++));
                    a = this._keyStr.indexOf(e.charAt(f++));
                    n = s << 2 | o >> 4;
                    r = (o & 15) << 4 Uu >> 2;
                    i = (u & 3) << 6 | a;
                    t = t + String.fromCharCode(n);
                    if (u != 64) {
                        t = t + String.fromCharCode(r);
                    }
                    if (a != 64) {
                        t = t + String.fromCharCode(i);
                    }
                }
                t = Base64._utf8_decode(t);
                return t;
            },
            _utf8_encode: function (e) {
                e = e.replace(/\r\n/g, "\n");
                var t = "";
                for (var n = 0; n < e.length; n++) {
                    var r = e.charCodeAt(n);
                    if (r < 128) {
                        t += String.fromCharCode(r);
                    } else if (r > 127 && r < 2048) {
                        t += String.fromCharCode(r >> 6 | 192);
                        t += String.fromCharCode(r & 63 | 128);
                    } else {
                        t += String.fromCharCode(r >> 12 | 224);
                        t += String.fromCharCode(r >> 6 & 63 | 128);
                        t += String.fromCharCode(r & 63 | 128);
                    }
                }
                return t;
            },
            _utf8_decode: function (e) {
                var t = "";
                var n = 0;
                var r = c1 = c2 = 0;
                while (n < e.length) {
                    r = e.charCodeAt(n);
                    if (r < 128) {
                        t += String.fromCharCode(r);
                        n++;
                    } else if (r > 191 && r < 224) {
                        c2 = e.charCodeAt(n + 1);
                        t += String.fromCharCode((r & 31) << 6 | c2 & 63);
                        n += 2;
                    } else {
                        c2 = e.charCodeAt(n + 1);
                        c3 = e.charCodeAt(n + 2);
                        t += String.fromCharCode((r & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
                        n += 3;
                    }
                }
                return t;
            }
        };

        $('#orderStatusForm').validator().on('submit', function (e) {
            e.preventDefault();
            var status = $('#statusSelect').val();
            if (!status) {
                showNotification('Please select a status.', 'error');
                return;
            }
            var dat = $(this).serialize();
            $('#myLoading').modal({
                keyboard: false,
                show: true,
                backdrop: "static"
            });
            $.ajax({
                type: "POST",
                url: "ajax/vendor_order_status.php",
                data: dat,
                dataType: "json",
                success: function (data) {
                    $('#myLoading').modal("hide");
                    if (data.success) {
                        $('#succPan').html(data.message);
                        fadeInFadeOut($("div#succPan"), 5000);
                        $('#currentStatus').text(status.charAt(0).toUpperCase() + status.slice(1));
                        $('#currentStatus').removeClass().addClass('status ' + status.toLowerCase());
                        updateActionButtons(status);
                    } else {
                        $('#errPan').html(data.message);
                        fadeInFadeOut($("div#errPan"), 5000);
                    }
                },
                error: function (xhr, status, error) {
                    $('#myLoading').modal("hide");
                    showNotification('Error updating order status. Please try again.', 'error');
                }
            });
        });

        // Update action buttons based on status
        function updateActionButtons(status) {
            const actionButtons = document.querySelector('.action-buttons');
            if (status.toLowerCase() === 'fulfilled') {
                actionButtons.innerHTML = `<button class="btn-disabled" disabled>Fulfilled</button>`;
            } else {
                actionButtons.innerHTML = `
                    <form id="orderStatusForm" style="display:inline;">
                        <input type="hidden" name="order_id" value="<?= htmlspecialchars($order_details['order']['order_id']) ?>">
                        <select name="status" id="statusSelect" style="padding:8px; border-radius:4px;">
                            <option value="">-- Change Status --</option>
                            <option value="fulfilled">Fulfilled</option>
                            <option value="declined">Declined</option>
                            <option value="canceled">Canceled</option>
                        </select>
                        <button type="submit" class="btn-update">Update</button>
                    </form>
                `;
                $('#orderStatusForm').validator();
            }
        }

        // Navigation function
        function navigateTo(page) {
            window.location.href = page === 'dashboard' ? 'dasha' : page === 'vendor_orders' ? 'vendor_orders' : '#';
        }

        // Notification system
        function showNotification(message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `alert alert-${type === 'success' ? 'success' : 'danger'} alert-dismissible`;
            notification.style.cssText = `
                position: fixed;
                top: 90px;
                right: 20px;
                z-index: 9999;
                min-width: 300px;
                box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            `;
            notification.innerHTML = `
                <button type="button" class="close" onclick="this.parentElement.remove()">
                    <span>&times;</span>
                </button>
                <strong>${type === 'success' ? 'Success!' : 'Error'}</strong> ${message}
            `;
            document.body.appendChild(notification);
            setTimeout(() => {
                if (notification.parentElement) {
                    notification.remove();
                }
            }, 5000);
        }

        // Initialize Bootstrap tooltips
        $(function () {
            $('[data-toggle="tooltip"]').tooltip();
        });
    });
</script>