<?PHP
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';

$pubkey = PS_TEST_PUB_KEY;
?>
<!DOCTYPE html>
<html lang="en" dir="ltr">

    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

        <title>eService - FiberOne Broadband - WeMissU1 Promo</title>

        <link rel="icon" href="images/fob-logo.svg">
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="<?PHP echo SERVER_URL; ?>bower_components/bootstrap/dist/css/bootstrap.min.css">

        <link rel="stylesheet" href="dist/css/homestyle.css" />
        <style>
            .box.box-danger {
                border-top: 4px solid #dd4b39;
                padding:30px;
            }
            .box {
                position: relative;
                border-radius: 3px;
                background: #ffffff;
                border-top: 3px solid #d2d6de;
                margin-bottom: 20px;
                width: 100%;
                box-shadow: 0 3px 6px rgba(0,0,0,0.3);
            }
            .box-header {
                /* color: #444; */
                display: block;
                padding: 10px;
                position: relative;
            }
            .box-header.with-border {
                border-bottom: 1px solid #ebd9d9;
            }
            .box-body {
                border-top-left-radius: 0;
                border-top-right-radius: 0;
                border-bottom-right-radius: 3px;
                border-bottom-left-radius: 3px;
                padding: 10px;
            }
            .btn {
                display: inline-block;
                padding: 6px 12px;
                margin-bottom: 0;
                font-size: 14px;
                font-weight: 400;
                line-height: 1.42857143;
                text-align: center;
                white-space: nowrap;
                vertical-align: middle;
                -ms-touch-action: manipulation;
                touch-action: manipulation;
                cursor: pointer;
                -webkit-user-select: none;
                -moz-user-select: none;
                -ms-user-select: none;
                user-select: none;
                background-image: none;
                border: 1px solid transparent;
                border-radius: 4px;
            }

            .btn-warning {
                color: #fff;
                background-color: #f0ad4e;
                border-color: #eea236;
            }

ul {
    list-style-type: disc;
    margin-left: 20px;
    margin-bottom:10px;
}
.box-body {
    font-size: 1.5em;
    line-height: 1.5em;
}
.input-group .input-group-addon {
    border-radius: 0;
    border-color: #d2d6de;
    background-color: #fff;
}
.input-group {
    position: relative;
    display: table;
    border-collapse: separate;
}
[type=button], [type=reset], [type=submit], button {
    -webkit-appearance: button;
    background-color: #434eaf;
    background-image: none;
}
.alert-info {
    color: #31708f;
}
        </style>
        
<!-- Select2 -->
<link rel="stylesheet" href="bower_components/select2/dist/css/select2.min.css">
    </head>

    <body>

        <!-- Top Bar -->
        <section class="top-bar">

            <!-- Brand -->
            <div class="brand bg-success">
                <img src="images/fob-logo.gif" alt="" class="h-10">
            </div>

            <a href="https://eservice.fob.ng" class="btn btn_primary md:hidden ml-auto">Go To eService</a>

            <nav class="items-center ltr:ml-auto rtl:mr-auto  md:flex">
                <!-- Choose Your Journey -->
                <div class="dropdown">
                    <button class="btn btn_primary uppercase" data-toggle="dropdown-menu">
                        Choose Your Journey
                        <span class="ltr:ml-3 rtl:mr-3 la la-caret-down text-xl leading-none"></span>
                    </button>
                    <div class="dropdown-menu">
                        <a href="https://fob.ng/retail">Retail (Personal)</a>
                        <a href="https://fob.ng/enterprise">Enterprise (Corporate)</a>
                        <a href="https://eservice.fob.ng" class="btn btn_primary mt-5">Self-Service</a>
                        <a href="https://fob.ng/retail/shop" class="btn btn_primary mt-5">Go To Shop</a>
                    </div>
                </div>
            </nav>
        </section>

        <div class="container mx-0 max-w-full flex flex-col items-center justify-center mt-20 py-10 relative">
            <div class="opacity-10 bg-[url('../../images/fiberone-hq.jpg')] bg-cover bg-center absolute w-full h-full top-0 left-0"></div>

            <section class="content" style="min-width:50%">
                <div class="row">
                    <div id="verifyDiv" class="col-md-12">

                        <div class="box box-danger">
                            <div class="box-header with-border">
                                <h2 class="box-title"> WE MISS YOU 1 PROMO</h2>
                                <h4 style="font-size: 1.3em;">Renew now for at least 1 month to qualify for  the next month free</h4>
                            </div>
                            <div class="box-body">
                                <h3 style="padding-bottom: 20px; padding-top:15px;">Please provide your Client ID (for example: fobxxxxx) below to verify your details and proceed</h3>
                                <label>Enter your Client ID</label>
                                <div class="input-group" style="display:table;">

                                    <input class="form-control" type="text" id="clientId" name="clientId" />
                                    <span class="input-group-btn">
                                        <button class="btn btn-warning" id="verifyBtn" type="button">Verify ID</button>
                                    </span>
                                </div>

                                <div class="info-log mt-20 items-center justify-center" style="display:none;">
                                    <div class="alert alert-danger" id="errPan" style="display:none; font-size: 1.3rem; color: #a94442;"></div>
                                    <div class="alert alert-success" style="color:#ffffff !important; background-color: #0044cc !important; display: none; font-size: 1.3rem;" id="succPan" ></div>
                                    <center><button id="continueBtn"  class="btn btn-success z-10 hover:text-white flex-col items-center" style="display:none;"> Proceed >> </button></center>
                                </div>
                            </div>

                        </div>

                    </div>
                    <!-- ./verifyDiv -->

                    <div id="infoDiv" class="col-md-12" style="display:none;">

                        <div class="box box-danger">
                            <div class="box-header with-border">
                                <h2 class="box-title"> WE MISS YOU 1 PROMO</h2>
                                <h4 style="font-size: 1.3em;">Renew now for at least 1 month to qualify for  the next month free</h4>
                            </div>
                            <div class="box-body">
                                <h3 style="padding-bottom: 20px; padding-top:15px;"><strong>Kindly fill the form as required below.</strong></h3>
                                <hr />
                                <div class="alert alert-danger" id="errPanInfoDiv" style="display: none; " ></div>
                                <div class="alert alert-success" id="succPanInfoDiv" style="display: none" ></div>

                                <p>Please note that;
                                <ul>
                                    <li>The renewal takes effect immediately </li>
                                    <li>Payment validates plan renewal and qualification for this promo</li>
                                    <li>You can apply the "WeMissU1" Promo code by checking the necessary box below</li>
                                    <li>The "WeMissU1" Promo is strictly by invitation and applies when you pay for minimum of 1 month</li>
                                    <li>**Terms and Condition applies</li>
                                </ul>
                                </p>

                                <form role="form" class="form-horizontal" data-toggle="validator" id="cuser_form" name="cuser_form" action="" method="post">
                                    <fieldset>
                                        <input type="hidden" name="user" id="user" value="" />
                                        <input type="hidden" name="raduser" id="raduser" value="" />
                                        <input type="hidden" name="expiry" id="expiry" value="" />


                                        <div class="input-group">
                                            <span class="input-group-addon">Current Plan: </span>
                                            <input type="text" name="cur_plan" id="cur_plan" class="form-control" value="" class="form-control" required readonly />
                                            <input type="hidden" id="cur_plan_id" name="cur_plan_id" value="" />
                                            <input type="hidden" id="plan_id" name="plan_id" value="" />
                                            <input type="hidden" id="srvid" name="srvid" value="" />
                                            <input type="hidden" id="srvname" name="srvname" value="" />
                                        </div>
                                        <br />

                                        <div class="form-group has-feedback">
                                            <div class="input-group input-group-md">
                                                <span class="input-group-addon"><i class="fa fa-dropbox green"></i> Select No of Months to renew for:</span>
                                                <select class="form-control select2 repositories selectized" id="nmonths" name="nmonths" placeholder="Select Number of Months" required>
                                                    
                                                    <?PHP
                                                    for ($i = 1; $i <= 12; $i++) {
                                                        ?>
                                                        <option value="<?PHP echo $i; ?>"><?PHP echo $i; ?></option>
                                                        <?PHP
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <br />

                                        <div class="input-group">
                                            <span class="input-group-addon">New Price/month (₦): </span>
                                            <input type="text" name="plan_unit_price" id="plan_unit_price" class="form-control" value="" class="form-control" required readonly />
                                        </div>
                                        <br />

                                        <div class="input-group">
                                            <span class="input-group-addon">Total New Price (₦): </span>
                                            <input type="text" name="plan_price" id="plan_price" class="form-control" value="" required readonly />
                                            <input type="hidden" id="amount_due" name="amount_due" value="" />
                                        </div>
                                        <br />

                                        <div class="input-group">
                                            <label for="use_promo" class=" checkbox-inline">
                                                <input type="checkbox" name="use_promo" id="use_promo"  value="WeMissU1" required  />
                                                Apply <em>WeMissU1</em> promo code</label>
                                        </div>
                                        <br />

                                        <p id="btnp" class="center col-md-12" >
                                            <button type="submit" class="btn btn-block btn-primary"><i class="glyphicon glyphicon-lock green"></i> Initiate Renewal</button>
                                        </p>

                                    </fieldset>

                                </form>
                            </div>

                        </div>

                    </div>
                    <!-- ./infoDiv -->

                    <div id="payDiv" class="col-md-12" style="display:none">

                        <div class="box box-danger">
                            <div class="box-header with-border">

                                <div class="box-header with-border">
                                    <h2 class="box-title"> WE MISS YOU 1 PROMO</h2>
                                    <h4 style="font-size: 1.3em;">Renew now for at least 1 month to qualify for  the next month free</h4>
                                </div>
                            </div>
                            <div class="box-body">
                                <h3 class="box-title"> Welcome Back Promo Payment</h3>
                                <form role="form" id="paymentForm" name="paynow" action="" method="post">
                                    <script src="https://js.paystack.co/v1/inline.js"></script>
                                    <input name="email" required type="hidden" value="" />
                                    <input name="name" required type="hidden" value="" />
                                    <?php
                                    echo '<input type="hidden" name="txn_ref" id="txn_ref" value="" />';
                                    echo '<input type="hidden" name="amount" id="amount" value="" />';
                                    echo '<input type="hidden" name="currency" value="' . CURRENCY . '" />';
                                    echo '<input type="hidden" name="cust_id" value="' . $raduser . '" />';
                                    echo '<input type="hidden" name="cust_name" value="" />';

                                    echo '<input type="hidden" name="site_redirect_url" value="' . NOTIFICATION_PS_URL . '" />';
                                    echo '<input type="hidden" name="local_date_time" value="' . date("d-M-y H:i:s") . '" />';
                                    ?>

                                    <div class="alert alert-info" style="text-align:center;" >
                                        <strong>INFO:</strong> Your Transaction Number is <br />
                                        <span style="font-size: 1.4em;"><strong><span id='txnref'></span></span></strong></span><br />
                                        Kindly keep for reference purpose.
                                    </div>

                                    <div class="form-group">
                                        <label for="username">Service ID</label>
                                        <input type="text" class="form-control" id="username" name="username" value='' placeholder="Service ID" readonly>
                                    </div>

                                    <div class="form-group">
                                        <label for="plan">Plan</label>
                                        <input type="text" value="" class="form-control" id="plan" name="plan" placeholder="" readonly>
                                    </div>

                                    <div class="form-group">
                                        <label for="plan">No of Months</label>
                                        <input type="text" value="" class="form-control" id="months" name="months" placeholder="" readonly>
                                    </div>

                                    <div class="form-group">
                                        <label for="payvalue">Total Amount (₦)</label>
                                        <input type="text" value="" class="form-control" id="payvalue" name="tamount" placeholder="" readonly>
                                    </div>

                                    <div class="form-group center" style="text-align: center;">
                                        <button id="btnback" onclick="history.back()" class="btn btn-success btn-md center" ><< Back</button>
                                        <button id="btnsubmit" class="btn btn-info btn-md center" onclick="payWithPaystack(); return false;" >Proceed to Make Payment</button>

                                    </div>

                                </form>

                                <div class="form-group center" style="text-align: center;">
                                    <img src="images/pstack.png" />
                                </div>
                            </div><!-- /.box-body -->

                        </div><!-- /.box-danger -->

                    </div>
                    <!-- /.col-md-4 #payDiv -->

                </div>
            </section>

            <a href="https://fob.ng/retail/shop" class="card card_hoverable card_list mt-10 z-10 hover:text-white flex-col items-center rounded-full">
                <div class="image image_icon -mt-4">
                    <span class="la la-shopping-bag la-4x"></span>
                </div>
                <div class="body text-center -mt-2">
                    <h5>Shop</h5>
                </div>
            </a>

            <!-- Footer -->
            <footer class="mt-auto z-10">

                <div class="footer text-center text-fobBlue">
                    <span>
                        Copyright &copy; 2023 FiberOne Broadband
                        <br>
                        -
                        <br>
                        All Rights Reserved
                    </span>
                </div>
            </footer>
        </div>
        <div class="modal fade" id="myLoading" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">

            <div class="modal-dialog">
                <div class="modal-content">

                    <div class="modal-body">
                        <center>
                            <p><img src="<?PHP echo SERVER_URL; ?>img/ajax-loaders/ajax-loader-5.gif" title="<?PHP echo SERVER_URL; ?>img/ajax-loaders/ajax-loader-5.gif"></p>
                            <p>Please Wait! Loading Data</p>
                        </center>
                    </div>
                </div>
            </div>
        </div>

        <script src="<?PHP echo SERVER_URL; ?>/dist/js/vendor.js"></script>
        <script src="<?PHP echo SERVER_URL; ?>/dist/js/homescript.js"></script>
        <!-- jQuery 3 -->
        <script src="<?PHP echo SERVER_URL; ?>bower_components/jquery/dist/jquery.min.js"></script>
        <!-- Bootstrap 3.3.7 -->
        <script src="<?PHP echo SERVER_URL; ?>bower_components/bootstrap/dist/js/bootstrap.min.js"></script> 
        <!-- Ajax Form Validation Script -->
<script src="<?PHP echo SERVER_URL; ?>dist/js/jquery.validate.js" type="text/javascript" charset="utf-8"></script>
<!-- Bootstrap Validation Script -->
<script src="<?PHP echo SERVER_URL; ?>dist/js/validator.min.js" type="text/javascript" charset="utf-8"></script>
        <!-- Select2 -->
        <script src="bower_components/select2/dist/js/select2.full.min.js"></script>  
        <script type="text/javascript">
            var username = '';
            var useremail = '';
            var userphone = '';
            var userfullname = '';
            var amt_due = 0;
            var unit_price = 0;
            var month = 2;
            var txn_id = '';
            var myPlan = '';
			var planjson = {};
            var userInfo = {};

            $(document).ready(function () {
                
                // Show an element and then fade it out with the timeout given
                var fadeInFadeOut = function (jQueryElement, timeout) {
                    jQueryElement.fadeIn(1000);
                    setTimeout(function () {
                        jQueryElement.fadeOut("slow");
                    }, timeout);
                };

                var numberFormat = (no, decimal_place) => {
                    return Number(parseFloat(no).toFixed(decimal_place)).toLocaleString('en', {
                        minimumFractionDigits: decimal_place
                    });
                };

                $('#plan_id, select#nmonths').on('change', function () {
                    var sel = $("select#plan_id").val();
                    let mth = $("select#nmonths").val();
                    month = mth;
                    $.each(planjson, function (key, value) {
                        if (key === sel) {
                            let total = (value.AMOUNT * mth);
                            let totalf = numberFormat(total);
                            $("#plan_unit_price").val(value.AMOUNTF);
                            $("#plan_price").val(totalf);
                            $("#payvalue").val(totalf);
                            $("#amount_due").val(total);
                            $("#months").val(month);
                            $("#amount").val(total * 100);
                            $("#srvid").val(value.SRVID);
                            $("#srvname").val(value.PACKAGE);
                            $("#plan").val(value.PACKAGE);
                            myPlan = value.PACKAGE;
                            amt_due = (total * 100);
                            unit_price = (value.AMOUNT);
                        }
                    });
                });

                $('#continueBtn').on('click', function (e) {
                    $('#verifyDiv').hide();
                    $('#infoDiv').show();
                });

                $('#verifyBtn').on('click', function (e) {
                    var dat = "clientId=" + $('#clientId').val();
                    $('#myLoading').modal({
                        keyboard: false,
                        show: true,
                        backdrop: "static"
                    });
                    verifyAjaxCall(dat);
                });

                var verifyAjaxCall = function (dat) {
                    let mth = $("select#nmonths").val();
                    month = mth;
                    $.ajax({
                        type: "POST",
                        url: "ajax/plan_wemissu1_promo_verify.php",
                        data: dat,
                        dataType: "json",
                        success: function (response) {  //alert(response);
                            if (response.STATUS === 1) { //alert(response);   
                                $('div#succPan').html(response.MSG);
                                $('div#succPan').show();
                                $('#continueBtn').show();
                                $('div#errPan').html("");
                                $('div#errPan').hide();
                                userInfo = (response.PROFILE);
                                $('#user').val(userInfo.username);
                                $('#username').val(userInfo.username);
                                $('#raduser').val(userInfo.username);
                                $('#email').val(userInfo.email);
                                $('#name').val(userInfo.firstname + ' ' + userInfo.lastname);
                                $('#cust_name').val(userInfo.firstname + ' ' + userInfo.lastname);
                                $('#expiry').val(userInfo.expiry_formatted);
                                $('#cur_plan').val(userInfo.srvname);
                                $('#cur_plan_id').val(userInfo.srvid);
                                $('#plan_id').val(response.PLAN_ID);
                                username = userInfo.username;
                                useremail = userInfo.email;
                                userphone = userInfo.mobile;
                                userfullname = userInfo.firstname + ' ' + userInfo.lastname;
                                
                                let total = (response.AMOUNT * mth);
                                let totalf = numberFormat(total);
                                $("#plan_unit_price").val(response.AMOUNTF);
                                $("#plan_price").val(totalf);
                                $("#payvalue").val(totalf);
                                $("#amount_due").val(total);
                                $("#months").val(month);
                                $("#amount").val(total * 100);
                                $("#srvid").val(userInfo.srvid);
                                $("#srvname").val(userInfo.srvname);
                                $("#plan").val(userInfo.srvname);
                                myPlan = userInfo.srvname;
                                amt_due = (total * 100);
                                unit_price = (response.AMOUNT);
                                
                            } else {
                                $('div#errPan').html(response.MSG);
                                $('div#errPan').show();
                                $('div#succPan').html("");
                                $('div#succPan').hide();
                                $('#continueBtn').hide();
                            }
                            $('#myLoading').modal("hide");
                            $('div.info-log').show();
                        },
                        error: function (xhr, error) {
                            $('#myLoading').modal("hide");
                            alert("Sorry, cannot contact server at this time. Please try again later!" + xhr + " :: " + error);
                            //                $('div#errPan').text("Sorry, cannot contact server at this time. Please try again later!" + xhr + " :: " + error);
                            //                fadeInFadeOut($("div#errPan"), 5000);
                            console.debug(xhr);
                            console.debug(error);
                        }
                    });
                };

                var myAjaxCall = function (dat) {
                    $.ajax({
                        type: "POST",
                        url: "ajax/plan_wemissu1_promo_init.php",
                        data: dat,
                        dataType: "json",
                        success: function (response) {  //alert(response);
                            if (response.STATUS === 1) { //alert(response); 
                                $('#txn_ref').val(response.TRANX_ID);
                                $('#txnref').html(response.TRANX_ID);
                                txn_id = response.TRANX_ID;
                                $('#infoDiv').hide();
                                $('#payDiv').show();
                                $('#myLoading').modal("hide");
                                $('div#succPan').html(response);
                                fadeInFadeOut($("div#succPan"), 5000);
                            } else {
                                $('#myLoading').modal("hide");
                                $('div#errPan').html(response);
                                fadeInFadeOut($("div#errPan"), 5000);
                            }
                        },
                        error: function (xhr, error) {
                            $('#myLoading').modal("hide");
                            $('div#errPan').text("Sorry, cannot contact server at this time. Please try again later!" + xhr + " :: " + error);
                            fadeInFadeOut($("div#errPan"), 5000);
                            console.debug(xhr);
                            console.debug(error);
                        }
                    });
                };

                $('#cuser_form').validator().on('submit', function (e) {
                    if (e.isDefaultPrevented()) {
                        // handle the invalid form...
                        //alert("Error");
                    } else {
                        e.preventDefault();

                        if (!($("#use_promo").is(':checked'))) {
                            let conf = confirm("You have not applied the 'WeMissU1' promo code. \nKindly click Cancel to go back and check the promo code box or Click OK to continue without the promo code.\ nPlease note that if you continue without applying the promo you will miss out of the benefit.");
                            if (!conf) {
                                return;
                            }
                        }

                        var dat = $('#cuser_form').serialize();
                        $('#myLoading').modal({
                            keyboard: false,
                            show: true,
                            backdrop: "static"
                        });
                        myAjaxCall(dat);

                    }
                });

            });

var paymentForm = document.getElementById('paymentForm');
paymentForm.addEventListener('submit', payWithPaystack, false);

    function payWithPaystack(e){ //alert("i");
//         e.preventDefault();
         const reff = document.getElementById('txn_ref').value;
         const amot = document.getElementById('amount').value;
         const myPlan = document.getElementById('plan').value;
         const month = document.getElementById('months').value;
            var handler = PaystackPop.setup({
              key: '<?PHP echo $pubkey; ?>',
              email: useremail,
              amount: amot,
              currency: "NGN",
              ref: reff,  
              phone: userphone,
              first_name: "",
              last_name: userfullname,
            <?PHP
            if (!$isupcountry):
            ?>
               subaccount: 'ACCT_fwfgumpgdlsmn7k',
            <?PHP
            endif;
            ?>
              metadata: {
                 custom_fields: [
                    {
                        display_name: "FullName",
                        variable_name: "fullname",
                        value: userfullname
                    },
                    {
                        display_name: "ServiceID",
                        variable_name: "serviceid",
                        value: username
                    }, 
                    {
                        display_name: "Validity",
                        variable_name: "validity",
                        value: month
                    }, 
                    {
                        display_name: "PlanName",
                        variable_name: "planname",
                        value: myPlan
                    }
                 ]
              },
              callback: function(response){
                  alert('success. transaction ref is ' + response.reference);
                window.location = "<?PHP echo SERVER_URL; ?>psuccess_psfront/" + response.reference;
              },
              onClose: function(){
//                  alert('window closed');
              }
            });
            handler.openIframe();
//            alert("Ou0")
    }

        </script>

    </body>

</html>