<?php
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';

extract($_GET);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);

// Check Transaction for Lock
$ut = 0;
do {
    if ($ut++ > 0) { sleep(25); }
    if ($ut == 10) { exit(); }
    $sql = "UPDATE tbl_install_invoice SET ISLOCKED=1 WHERE ORDERNO=?";
    $locked = $db->execute_query($sql, "s", $txnref);
} while (!$locked);

$vval =  $ad->getInvoice4Verification($txnref);
if ($vval['PAID'] == 1) :
    //Already Recorded, Do something
    //Unlock Transaction
        $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
        $locked = $db->execute_query($sql, "s", $txnref);
    echo "<script> window.location.href = '".SERVER_URL."invoice'; </script>";
    exit();
endif;

$url = str_replace(':reference', $klpref, VERIFY_KLUMP_URL);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_SSLVERSION, "CURL_SSLVERSION_TLSv1_2");
curl_setopt(
  $ch, CURLOPT_HTTPHEADER, [
    'klump-secret-key: ' . KLUMP_TEST_PRIV_KEY,
    'Content-Type: application/json' ]
);
$request = curl_exec($ch);
curl_close($ch);

$is_okay = 0;

if ($request) {
    $result = json_decode($request, true);
    if(isset($result) && $result['state'] === 'success'){
      if(isset($result['data'])){
        //something came in
          $respcode = '00';
          $resp = "";
        if($result['data']['status'] == 'successful'){
            
            if ( ($vval["REQ_AMOUNT"] <= ($result['data']['amount']))
                        && ($vval['TRANS_ID'] == $result['data']['merchant_reference']) ):
                //successful do something
                $is_okay = 1;
                $resp = $result['data']['status'] . ' - ' . $msg;
            else:
                $respcode = "ZZ";
                $resp = $result['data']['status'] . ' - ' . $msg . ": Invalid Amount";
            endif; 
            
        } //if($result['data']['status'] == 'success')
        else{
          // the transaction was not successful, do not deliver value'
          // print_r($result);  //uncomment this line to inspect the result, to check why it failed.
          echo "Transaction was not successful: Last gateway response was: ".$result['data']['status'] . ' - ' . $msg;
          $respcode = "Z0";
          $resp = $result['data']['status'] . ' - ' . $msg;
        } //if($result['data']['status'] == 'success')
        
        //Save Transaction
        $pdate = date("Y-m-d H:i:s"); 
        $appDate = date("Y-m-d H:i:s");

        $ad->saveInvoiceTranxResp($result['data']['merchant_reference'], $is_okay, $result['data']['reference'], 
                            ($result['data']['amount']), CURRENCY, $respcode, $resp, $pdate, 
                            "klump-gw", $appDate, $result['data']['id'], $vval["RAD_USERNAME"]);
       
        if ($is_okay) :  //echo $vval['ERPID'] . "||" . $vval["ORDER_ERPID"]; exit();
            //send to erp
//            $ad->sendInvoiceToERP($url, $db, $username, $password, $erpid, $order_erpid, $amt, $desc, $paydate);
            if ( ($vval['ERPID']>0 && $vval["ORDER_ERPID"]>0) || ($vval["BITRIX_ID"] > 0) ) {   //ERP_DB
                //Create on eService & Radius
                $ad->accProvisionFromOrder($vval["RAD_USERNAME"], $vval['TRANS_ID']);
                
                //Unlock Transaction
                $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
                $locked = $db->execute_query($sql, "s", $txnref);
        
                //TODO: update SENTTOERP in tbl_install_invoice=1 //DONE
                if ($vval["BITRIX_ID"] > 0) {
                    $ad->sendToBitrix($vval["BITRIX_ID"], $pdate);
                } else  {
                    $ad->sendInvoiceToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], $vval["ORDER_ERPID"], ($result['data']['amount']), $vval["RAD_USERNAME"]."-ESERVICE-INIT-Invoice(klump)", date("Y-m-d") );
                }
            }
            
            //Unlock Transaction
                $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
                $locked = $db->execute_query($sql, "s", $txnref);
                
      		echo "<script> window.location.href = '".SERVER_URL."invsuc'; </script>";
        endif;
        
      } //if($result['data'])
      else{
        echo $result['message'];
        //Unlock Transaction
        $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
        $locked = $db->execute_query($sql, "s", $txnref);
      	exit();
      }
      
    } else{
        //Unlock Transaction
        $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
        $locked = $db->execute_query($sql, "s", $txnref);
      //print_r($result);
      die("Something went wrong while trying to convert the request variable to json. Uncomment the print_r command to see what is in the result variable.");
    }
    
} else {
    //Unlock Transaction
    $sql = "UPDATE tbl_install_invoice SET ISLOCKED=0 WHERE ORDERNO=?";
    $locked = $db->execute_query($sql, "s", $txnref);
    //var_dump($request);
    die("Something went wrong while executing curl. Uncomment the var_dump line above this line to see what the issue is. Please check your CURL command to make sure everything is ok");
}