<?php
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';

// only a post with paystack signature header gets our attention
if ((strtoupper($_SERVER['REQUEST_METHOD']) != 'POST' ) || (!array_key_exists('x-paystack-signature', $_SERVER) && !array_key_exists('HTTP_X_PAYSTACK_SIGNATURE', $_SERVER))) {
    // print_r($_SERVER);
    exit();
}

// Retrieve the request's body

$input = @file_get_contents("php://input");


//define('PAYSTACK_SECRET_KEY','SECRET_KEY');
// validate event do all at once to avoid timing attack
// echo hash_hmac('sha512', $input, PS_UPC_LIVE_PRIV_KEY) . " }} ";
// echo hash_hmac('sha512', $input, PS_LIVE_PRIV_KEY);
if (($_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] !== hash_hmac('sha512', $input, PS_UPC_LIVE_PRIV_KEY)) &&
        ($_SERVER['HTTP_X_PAYSTACK_SIGNATURE'] !== hash_hmac('sha512', $input, PS_LIVE_PRIV_KEY))) {
    exit();
}

// sleep(20);

http_response_code(200);
exit();
// echo "HJ";
// parse event (which is json string) as object
// Do something - that will not take long - with $event
$event = json_decode($input, TRUE); //print_r($event);
if ($event["event"] != "charge.success"): //echo "NOR";
    exit();
endif;
$info = $event["data"];

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$txnref = $txnid = $info['reference'];
$vval =  $ad->getInvoice4Verification($txnref);
if (count($vval) <= 0) {
    http_response_code(401);
    exit();
}
if ($vval['PAID'] == 1) :
    //Already Recorded, Do something
    exit();
endif;

$result = array();
//The parameter after verify/ is the transaction reference to be verified
$url = INV_VERIFY_PS_URL . $vval['TRANS_ID'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt(
  $ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . PS_INV_LIVE_PRIV_KEY]
);
$request = curl_exec($ch);
curl_close($ch);

$is_okay = 0;

if ($request) {
    $result = json_decode($request, true);
    // print_r($result);
    if($result){
      if($result['data']){
        //something came in
          $respcode = '00';
          $resp = "";
        if($result['data']['status'] == 'success'){
            
            if ( ($vval["REQ_AMOUNT"] == ($result['data']['amount']/100))
                        && ($vval['TRANS_ID'] == $result['data']['reference']) ):
                //successful do something
                $is_okay = 1;
                $resp = $result['data']['gateway_response'];
            else:
                $respcode = "ZZ";
                $resp = $result['data']['gateway_response'] . ": Invalid Amount";
            endif; 
            
        } //if($result['data']['status'] == 'success')
        else{
          // the transaction was not successful, do not deliver value'
          $respcode = "Z0";
          $resp = $result['data']['gateway_response'];
        } //if($result['data']['status'] == 'success')
        
        //Save Transaction
        $pdate = date("Y-m-d H:i:s"); 
        $appDate = date("Y-m-d H:i:s", strtotime($result['data']['transaction_date']));

        $ad->saveInvoiceTranxResp($result['data']['reference'], $is_okay, $result['data']['authorization']['authorization_code'], 
                            ($result['data']['amount']/100), CURRENCY, $respcode, $resp, $pdate, 
                            "paystack-".$result['data']['channel'], $appDate,
                            $result['data']['authorization']['last4'], $vval["RAD_USERNAME"]);
       
        if ($is_okay) :  //echo $vval['ERPID'] . "||" . $vval["ORDER_ERPID"]; exit();
            if ($vval['ERPID']>0 && $vval["ORDER_ERPID"]>0) {   //ERP_DB
                //Create on eService & Radius
                $ad->accProvisionFromOrder($vval["RAD_USERNAME"], $vval['TRANS_ID']);
            }
//      		echo "<script> window.location.href = '".SERVER_URL."invsuc'; </script>";
        endif;
        
      } //if($result['data'])
      else{
//        echo $result['message'];
        http_response_code(401);
      	exit();
      }
      
    } //if($result)
    else{
      //print_r($result);
//      die("Something went wrong while trying to convert the request variable to json. Uncomment the print_r command to see what is in the result variable.");
    }
    
} //if ($request)
else{
    //var_dump($request);
//    die("Something went wrong while executing curl. Uncomment the var_dump line above this line to see what the issue is. Please check your CURL command to make sure everything is ok");
}

