<?php
include_once 'includes/opener.php';
include_once 'includes/db.inc';
include_once 'config.php';

extract($_GET);

//open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$txnref = str_replace("_", "/", $txnid); // $txnid; 
$vval =  $ad->getOInvoice4Verification($txnref);
if ($vval['PAID'] == 1) :
    //Already Recorded, Do something
    echo "<script> window.location.href = '".SERVER_URL."oinvoice?invno=$txnref'; </script>";
    exit();
endif;

$result = array();
//The parameter after verify/ is the transaction reference to be verified
$url = OINV_VERIFY_PS_URL . str_replace("/", "_", $vval['TRANS_ID']); // $vval['TRANS_ID'];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt(
  $ch, CURLOPT_HTTPHEADER, [
    'Authorization: Bearer ' . PS_OINV_TEST_PRIV_KEY ]
);  //PS_OINV_TEST_PRIV_KEY
$request = curl_exec($ch);
curl_close($ch);

$is_okay = 0;

if ($request) {
    $result = json_decode($request, true);
    // print_r($result);
    if($result){
      if($result['data']){
        //something came in
          $respcode = '00';
          $resp = "";
          $result['data']['reference'] = str_replace("_", "/", $result['data']['reference']);
        if($result['data']['status'] == 'success'){
            
            if ( ($vval["REQ_AMOUNT"] == ($result['data']['amount']/100))
                        && ($vval['TRANS_ID'] == $result['data']['reference']) ):
                //successful do something
                $is_okay = 1;
                $resp = $result['data']['gateway_response'];
            else:
                $respcode = "ZZ";
                $resp = $result['data']['gateway_response'] . ": Invalid Amount";
            endif; 
            
        } //if($result['data']['status'] == 'success')
        else{
          // the transaction was not successful, do not deliver value'
          // print_r($result);  //uncomment this line to inspect the result, to check why it failed.
          echo "Transaction was not successful: Last gateway response was: ".$result['data']['gateway_response'];
          $respcode = "Z0";
          $resp = $result['data']['gateway_response'];
        } //if($result['data']['status'] == 'success')
        
        //Save Transaction
        $pdate = date("Y-m-d H:i:s"); 
        $appDate = date("Y-m-d H:i:s", strtotime($result['data']['transaction_date']));

        $ad->saveOInvoiceTranxResp($result['data']['reference'], $is_okay, $result['data']['authorization']['authorization_code'], 
                            ($result['data']['amount']/100), CURRENCY, $respcode, $resp, $pdate, 
                            "paystack-".$result['data']['channel'], $appDate,
                            $result['data']['authorization']['last4'], $vval["RAD_USERNAME"]);
       
        if ($is_okay) :  //echo $vval['ERPID'] . "||" . $vval["ORDER_ERPID"]; exit();
            if ($vval['ERPID']>0 && $vval["ORDER_ERPID"]>0) {   
                //TODO: update SENTTOERP in tbl_oinvoices=1 //DONE
                $journal_info = $ad->getJournalInfoERP2("PAYSTACK_OINV");
                $ad->sendOInvoiceToERP(ERP_URL, ERP_DB, ERP_USER, ERP_PASS, $vval['ERPID'], $vval["ORDER_ERPID"], ($result['data']['amount']/100), $vval["RAD_USERNAME"]."-ESERVICE-OInvoice(paystack)", date("Y-m-d"), $journal_info['JOURNALID'], $journal_info['BANK'], $journal_info['ACCOUNTNO'], $vval['TRANS_ID'] );
            }
      		echo "<script> window.location.href = '".SERVER_URL."oinvsuc'; </script>";
        endif;
        
      } //if($result['data'])
      else{
        echo $result['message'];
      	exit();
      }
      
    } //if($result)
    else{
      //print_r($result);
      die("Something went wrong while trying to convert the request variable to json. Uncomment the print_r command to see what is in the result variable.");
    }
    
} //if ($request)
else{
    //var_dump($request);
    die("Something went wrong while executing curl. Uncomment the var_dump line above this line to see what the issue is. Please check your CURL command to make sure everything is ok");
}

