<?php
$page = "Marketplace Sales Dashboard";
$page_url = "sales_dash";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';

if (isset($_SESSION[$sid . 'loggedin']) && ($_SESSION[$sid . 'loggedin'] == 201)):
    ?>
    <script>
        window.location.href = 'sales_dash_internal';
    </script>
    <?php
    exit();
endif;

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$colors = ["#00a65a", "#f56954", "#00c0ef", "rgba(18, 31, 113, 1)"];
$sales_check = $dashboard->getSalesDashboardOverview($_SESSION[$sid . 'userid']);
if ($sales_check !== null) {
    $lastPending = $dashboard->getSalesadminPending($_SESSION[$sid . 'userid']);
}
$startDate = date('Y-m-d', strtotime('first day of this month'));
$endDate = date('Y-m-d', strtotime('last day of this month'));
//print_r($_SESSION[$sid . 'usertype_id']);

?>

<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .top-bar {
        background: white;
        padding: 15px 30px;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 10px;
        display: flex;
        justify-content: space-between;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        color: #0f172a;
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .content-area {
        padding: 0 30px 30px;
    }

    .stats-row {
        margin-bottom: 30px;
    }

    .stat-card {
        border-radius: 8px;
        padding: 25px;
        border: 1px solid #e4e4e7;
        position: relative;
        height: 150px;
    }

    .stat-header {
        display: flex;
        justify-content: space-between;
        color: #0f172a;
    }

    .stat-value {
        font-size: 23px;
        font-weight: 700;
        color: #0f172a;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6c757d;
        font-size: 14px;
        margin-bottom: 15px;
    }

    .stat-icon {
        width: 40px;
        height: 40px;
    }

    .sales-section {
        border-radius: 8px;
        border: 1px solid #e9ecef;
    }

    .sales-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .sales-title {
        font-size: 18px;
        font-weight: 600;
        color: #0f172a;
        margin: 0;
    }

    .sales-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .view-all-btn {
        background: #0d3e9b;
        color: white;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
        font-size: 14px;
        cursor: pointer;
        transition: background 0.3s ease;
    }

    .view-all-btn:hover {
        background: #3367d6;
    }

    .sales-list {
        padding: 0;
    }

    .sale-item {
        padding: 15px 25px;
        border-bottom: 1px solid #f8f9fa;
        display: flex;
        align-items: center;
        justify-content: space-between;
        transition: background 0.3s ease;
    }

    .sale-item:hover {
        background: #f8f9fa;
    }

    .sale-item:last-child {
        border-bottom: none;
    }

    .customer-info {
        display: flex;
        align-items: center;
        flex: 1;
    }

    .customer-avatar {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 600;
        font-size: 14px;
    }

    .customer-details h6 {
        margin: 0;
        color: #0f172a;
        font-size: 14px;
        font-weight: 500;
    }

    .customer-details p {
        margin: 2px 0 0;
        color: #6c757d;
        font-size: 12px;
    }

    .product-name {
        flex: 1;
        color: #6c757d;
        font-size: 14px;
        text-align: center;
    }

    .sale-amount {
        color: #0f172a;
        font-weight: 500;
        font-size: 14px;
    }

    .avatar-pink {
        background: #e91e63;
    }

    .avatar-blue {
        background: #2196f3;
    }

    .avatar-orange {
        background: #ff9800;
    }

    .avatar-green {
        background: #4caf50;
    }

    .avatar-purple {
        background: #9c27b0;
    }

    .avatar-teal {
        background: #009688;
    }

    .avatar-red {
        background: #f44336;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 0 15px 30px;
        }

        .stat-card {
            margin-bottom: 15px;
        }
    }
</style>

<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Dashboard</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">

        <!-- Stats Row -->
        <div class="row stats-row">
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Registered</div>
                        <div class="stat-icon">
                            <i class="fa-regular fa-badge-dollar"></i>
                        </div>
                    </div>
                    <div class="stat-value"><?= number_format($sales_check['total_registered'] ?? 0) ?></div>
                    <div class="stat-label">Leads</div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Pending</div>
                        <div class="stat-icon">
                            <i class="fa fa-shopping-cart"></i>
                        </div>
                    </div>
                    <div class="stat-value"><?= number_format($sales_check['total_pending'] ?? 0) ?></div>
                    <div class="stat-label">In Progress</div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-header">
                        <div>Customers</div>
                        <div class="stat-icon">
                            <i class="fa fa-star"></i>
                        </div>
                    </div>
                    <div class="stat-value"><?= number_format($sales_check['total_customers'] ?? 0) ?></div>
                    <div class="stat-label">Subscribers</div>
                </div>
            </div>
        </div>

        <!-- Recent Pending Customers Section -->
        <?php if (!empty($lastPending)): ?>
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Last Pending Customers</h3>
                        <p class="sales-subtitle">Latest customers who haven’t completed payment</p>
                    </div>
                </div>
                <div class="sales-list">
                    <?php
                    $avatar_colors = ['avatar-pink', 'avatar-blue', 'avatar-orange', 'avatar-green', 'avatar-purple', 'avatar-teal', 'avatar-red'];
                    $color_index = 0;
                    foreach ($lastPending as $customer):
                        $initials = strtoupper(substr($customer['customer_name'], 0, 1) . (strpos($customer['customer_name'], ' ') !== false ? substr($customer['customer_name'], strpos($customer['customer_name'], ' ') + 1, 1) : ''));
                        ?>
                        <div class="sale-item">
                            <div class="customer-info">
                                <div class="customer-avatar <?= $avatar_colors[$color_index] ?>"><?= $initials ?></div>
                                <div class="customer-details">
                                    <h6><?= htmlspecialchars($customer['customer_name']) ?></h6>
                                    <p><?= htmlspecialchars($customer['customer_email']) ?></p>
                                    <small
                                        class="text-muted"><?= htmlspecialchars($customer['customer_address'] ?? 'N/A') ?></small>
                                </div>
                            </div>
                            <div class="sale-actions">
                                <button class="btn btn-sm btn-primary resend-link-btn"
                                    data-customer-id="<?= $customer['customer_id'] ?>">
                                    Resend Payment Link
                                </button>
                            </div>
                        </div>
                        <?php
                        $color_index = ($color_index + 1) % count($avatar_colors);
                    endforeach;
                    ?>
                </div>
            </div>
        <?php else: ?>
            <div class="sales-section">
                <div class="sales-header">
                    <div>
                        <h3 class="sales-title">Last Pending Customers</h3>
                        <p class="sales-subtitle">Latest customers who haven’t completed payment</p>
                    </div>
                </div>
                <p style="text-align: center; color: #6c757d; font-style: italic; padding: 20px;">No pending customers found
                    for this
                    agent.
                </p>
            </div>
        <?php endif; ?>


    </div>
</div>
<script src="bower_components/jquery/dist/jquery.min.js"></script>
<!-- Bootstrap 3.3.7 -->
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
<!-- iCheck -->
<script src="plugins/iCheck/icheck.min.js"></script>

<!-- Ajax Form Validation Script -->
<script src="dist/js/jquery.validate.js" type="text/javascript" charset="utf-8"></script>
<!-- Bootstrap Validation Script -->
<script src="dist/js/validator.min.js" type="text/javascript" charset="utf-8"></script>

<script>
    // View All button functionality
    $(".view-all-btn").click(function () {
        window.location.href = "vendor_orders.php";
    });

    // Sale item click functionality
    $(".sale-item").click(function () {
        $(this).css("background-color", "#e3f2fd").animate({
            backgroundColor: "#f8f9fa"
        }, 300);
    });

    // Initialize tooltips if needed
    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });


    $(document).ready(function () {
        $('.resend-link-btn').on('click', function () {
            var customerId = $(this).data('customer-id');
            var button = $(this);

            button.prop('disabled', true).text('Sending...');

            $.ajax({
                url: 'ajax/resend_payment_link.php',
                method: 'POST',
                data: {
                    customer_id: customerId
                },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        alert('Payment link resent successfully!');
                    } else {
                        alert('Failed to resend link: ' + response.message);
                    }
                    button.prop('disabled', false).text('Resend Payment Link');
                },
                error: function (xhr, status, error) {
                    alert('AJAX error: ' + error);
                    button.prop('disabled', false).text('Resend Payment Link');
                }
            });
        });
    });
</script>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>