<?php
ob_start();
$page = "Sales Earnings by Month";
$page_url = "sales_earnings_bymonth";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php';


$month = isset($_GET['month']) ? (int) $_GET['month'] : null;
$year = isset($_GET['year']) ? (int) $_GET['year'] : date('Y');

$start_date = null;
$end_date = null;

if (!empty($_GET['start_date']) && !empty($_GET['end_date'])) {
    $start_date = $_GET['start_date'];
    $end_date = $_GET['end_date'];
}


//var_dump($year, $month);
if ($month !== null && ($month < 1 || $month > 12)) {
    $month = date('m');
}
// if ($month !== null && (!ctype_digit($month) || (int) $month < 1 || (int) $month > 12)) {
//     $month = date('m');
// }

// Validate year
if (!ctype_digit((string) $year) || (int) $year < 2000 || (int) $year > (int) date('Y') + 1) {
    $year = date('Y'); // fallback to current year
}

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$salesagent_Id = $dashboard->getSalesAdminState($_SESSION[$sid . 'userid']);
//$testdetails = $dashboard->calculateCommission($totalAmount, $planId);




if (isset($_POST['calculateCommission'])) {
    $totalAmount = $_POST['totalAmount'];
    $planId = $_POST['planId'];

    // $testdetails = $dashboard->updateAgentCommission($totalAmount, $planId);

    // You can print it, save it, or use it as needed
    // echo "Commission: " . htmlspecialchars($testdetails);
}
if ($salesagent_Id === null) {
    // ob_end_clean();
    echo "<script>alert('Invalid or missing sales agent.'); window.location.href = 'sales_earnings';</script>";
    exit();
}

//if ($month !== null) {
$monthlyOrders = $dashboard->getPaidOrdersWithCustomerDetailswrkn(
    $salesagent_Id,
    (int) $month,
    (int) $year,
    $start_date,
    $end_date
);
//var_dump($monthlyOrders);
?>

<!-- Include Dependencies -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>

<style>
    .main-content {
        margin-left: 230px;
        min-height: 100vh;
        background: white;
    }

    .top-bar {
        background: white;
        padding: 20px 30px;
        border-bottom: 1px solid #e9ecef;
        display: flex;
        justify-content: space-between;
        align-items: center;
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .page-title {
        font-size: 24px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .content-area {
        padding: 30px;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        margin: 0 0 20px;
    }

    .breadcrumb a {
        color: #6c757d;
        text-decoration: none;
        font-size: 14px;
    }

    .breadcrumb a:hover {
        color: #2563eb;
    }

    .breadcrumb span {
        color: #6c757d;
        margin: 0 8px;
    }

    .breadcrumb-current {
        color: #333;
        font-weight: 500;
    }

    .stats-card {
        background: white;
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
        margin-bottom: 25px;
    }

    .stats-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 15px;
    }

    .stats-title {
        font-size: 14px;
        color: #6c757d;
        font-weight: 500;
        text-transform: uppercase;
    }

    .stats-value {
        font-size: 32px;
        font-weight: 700;
        color: #333;
    }

    .stats-icon {
        width: 50px;
        height: 50px;
        background: #0d3e9b;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 24px;
    }

    .orders-section {
        background: white;
        border-radius: 8px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        border: 1px solid #e9ecef;
    }

    .orders-header {
        padding: 25px 25px 15px;
        border-bottom: 1px solid #f8f9fa;
    }

    .orders-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .orders-subtitle {
        color: #6c757d;
        font-size: 14px;
        margin-top: 5px;
    }

    .table-container {
        overflow-x: auto;
    }

    .orders-table {
        width: 100%;
        margin: 0;
        border-collapse: collapse;
    }

    .orders-table thead {
        background: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
    }

    .orders-table th {
        padding: 15px 25px;
        border: none;
        font-weight: 500;
        color: #6c757d;
        font-size: 14px;
        text-align: left;
    }

    .orders-table tbody tr {
        border-bottom: 1px solid #f8f9fa;
        transition: background 0.3s ease;
    }

    .orders-table tbody tr:hover {
        background: #f8f9fa;
    }

    .orders-table td {
        padding: 15px 25px;
        border: none;
        vertical-align: middle;
        font-size: 14px;
    }

    .badge-light {
        background: #eef2ff;
        color: #4338ca;
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        display: inline-block;
    }

    .view-btn {
        background: none;
        border: none;
        color: #0d3e9b;
        padding: 5px 10px;
        cursor: pointer;
        border-radius: 4px;
        transition: background 0.3s ease;
        text-decoration: none;
        font-size: 14px;
    }

    .view-btn:hover {
        background: #f8f9fa;
        color: #0d3e9b;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 5px 10px;
        border: 1px solid #ddd;
        background: white;
        border-radius: 4px;
        color: #6c757d;
        margin: 0 2px;
        transition: all 0.3s ease;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
        background: #f8f9fa;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
        background: #0d3e9b;
        color: white;
        border-color: #0d3e9b;
    }

    .dataTables_wrapper .dataTables_paginate .paginate_button.disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }

    .dataTables_wrapper .dataTables_paginate span:empty {
        display: none;
    }

    .dataTables_wrapper .dataTables_paginate .ellipsis {
        display: none;
    }

    .dataTables_info {
        color: #6c757d;
        font-size: 14px;
        padding: 20px 25px;
    }

    .no-orders {
        text-align: center;
        color: #6c757d;
        padding: 40px;
        font-style: italic;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .content-area {
            padding: 15px;
        }
    }
</style>
<!-- Main Content -->
<div class="main-content">
    <!-- Top Bar -->
    <div class="top-bar">
        <h1 class="page-title">Sales Earnings</h1>
    </div>

    <!-- Content Area -->
    <div class="content-area">
        <!-- Breadcrumb -->
        <nav class="breadcrumb">
            <a href="#" onclick="navigateTo('dashboard')">Dashboard</a>
            <span>></span>
            <a href="sales_earnings.php">Sales Earnings</a>
            <span>></span>
            <span class="breadcrumb-current">
                <?php
                if (!empty($start_date) && !empty($end_date)) {
                    echo htmlspecialchars($start_date) . ' to ' . htmlspecialchars($end_date);
                } else {
                    echo date('F Y', mktime(0, 0, 0, (int) $month, 1, (int) $year));
                }
                ?>
            </span>
        </nav>

        <!-- Stats Summary -->
        <?php
        $totalEarnings = 0;
        $totalOrders = count($monthlyOrders ?? []);
        if (!empty($monthlyOrders)) {
            foreach ($monthlyOrders as $order) {
                $totalEarnings += $order['total_price'];
            }
        }
        ?>


        <!-- Orders Section -->
        <div class="orders-section">
            <div class="orders-header">
                <div>
                    <h3 class="orders-title">Paid Orders -
                        <?php
                        if (!empty($start_date) && !empty($end_date)) {
                            echo htmlspecialchars($start_date) . ' to ' . htmlspecialchars($end_date);
                        } else {
                            echo date('F Y', mktime(0, 0, 0, (int) $month, 1, (int) $year));
                        }
                        ?>
                    </h3>
                    <p class="orders-subtitle">View all paid orders for this month</p>
                </div>
            </div>

            <!-- Orders Table -->
            <div class="table-container">
                <?php if (!empty($monthlyOrders)): ?>
                    <table class="orders-table" id="ordersTable">
                        <thead>
                            <tr>
                                <th>Plan Name</th>
                                <th>Customer Name</th>
                                <th>Tracking ID</th>
                                <th>Total Price</th>
                                <th>Payment Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($monthlyOrders as $order): ?>
                                <tr>
                                    <td><?= htmlspecialchars($order['plan_name']) ?></td>
                                    <td><?= htmlspecialchars($order['name']) ?></td>
                                    <td>
                                        <span class="badge-light">
                                            <?= htmlspecialchars($order['tracking_id'] ?? 'N/A') ?>
                                        </span>
                                    </td>
                                    <td style="color: #16a34a; font-weight: 600;">
                                        ₦<?= number_format($order['total_price'], 2) ?>
                                    </td>
                                    <td><?= date("M j, Y • g:i A", strtotime($order['order_created_at'])) ?></td>
                                    <td>
                                        <a href="order_view.php?id=<?= urlencode(base64_encode($order['order_id'])) ?>"
                                            class="view-btn" title="View Order">
                                            <i class="fa fa-eye"></i> View
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p class="no-orders">No paid orders found for this month.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>
<?php ob_end_flush(); ?>

<script>
    $(document).ready(function () {
        // Initialize DataTables if there are orders
        <?php if (!empty($monthlyOrders)): ?>
            const table = $('#ordersTable').DataTable({
                pageLength: 10,
                lengthChange: false,
                searching: true,
                ordering: true,
                info: true,
                dom: 'rtip'
            });
        <?php endif; ?>
    });

    // Navigation function
    function navigateTo(page) {
        if (page === 'dashboard') {
            window.location.href = 'sales_dash.php';
        }
    }
</script>