<?php

use Slim\Http\Request;
use Slim\Http\Response;
use \Firebase\JWT\JWT;

//ini_set('display_errors', '1');
//ini_set('display_startup_errors', '1');
//error_reporting(E_ALL);

// Routes

//$app->get('/[{name}]', function (Request $request, Response $response, array $args) {
//    // Sample log message
//    $this->logger->info("Slim-Skeleton '/' route");
//
//    // Render index view
//    return $this->renderer->render($response, 'index.phtml', $args);
//});
//
// $app->get('/hello/{name}', function ($request, $response, $args) {
//    return $response->write("Hello " . $args['name']);
// });

//$app->get('/erpgen', function ($request, $response, $args) {
//  // $key = random_bytes(32);
//        // $iv = random_bytes(openssl_cipher_iv_length(NIBSS_HASH_CIPHER_METHOD));
//   $settings = $this->get('settings'); // get settings array.
//   
//   $token = JWT::encode(['id' => "nibss-epay", 'entry' => "webservice!23**"], $settings['jwt']['secret'], "HS512");
//
//   return $this->response->withJson(['token' => $token]);
//});

 $app->get('/resetMe', function ($request, $response, $args) {
     global $ad;
     try {
        $key = substr(bin2hex(openssl_random_pseudo_bytes(32)), 0, openssl_cipher_iv_length(NIBSS_HASH_CIPHER_METHOD));
        $iv = substr(bin2hex(openssl_random_pseudo_bytes(openssl_cipher_iv_length(NIBSS_HASH_CIPHER_METHOD))), 0, openssl_cipher_iv_length(NIBSS_HASH_CIPHER_METHOD));
        $saveThis = $ad->saveNIBSSSecret($key, $iv);
        
        if ($saveThis) {
            $msg = "Sequel to the Reset Request received from NIBSS on FiberOne Broadband API, the operation has been completed and the information is as found below;
                    <br />
                    <strong>IV:</strong> $iv 
                    <strong>SECRET KEY:</strong> $key 
                    <br />
                    Thank you
                    ";
            $sent = $ad->sendEmail(NIBSS_RESET_EMAIL, EMAIL_SENDER, "FiberOne BroadBand NIBSS Reset Request", $msg, [], ['Opeyemi'=>'opmat01@yahoo.com']);
            if ($sent) {
                return $this->response->withStatus(200)->write(json_encode(["Message"=>"New Information sent", "HasError"=> false]));
            } else {
                return $this->response->withStatus(402)->write(json_encode(["Message"=>"Sending Failed", "HasError"=> true]));
            }
            
        } else {
            return $this->response->withStatus(401)->write(json_encode(["Message"=>"Could not reset secret at the moment", "HasError"=> true]));
        }
        
     } catch (Exception $ex) {
        return $this->response->withStatus(404)->write(json_encode(["Message"=>"An Error Occured", "HasError"=> true]));
     }
     

    // return $this->response->withJson(['token' => $token]);
 });

$app->get('/check', function ($request, $response, $args) {
  
//    $settings = $this->get('settings'); // get settings array.
   
//    $token = JWT::encode(['id' => "whatsapp_pay", 'entry' => "webservice!23**"], $settings['jwt']['secret'], "HS512");

//    return $this->response->withJson(['token' => $token]);
	// $tok = $request->getAttribute('decoded_token_data');
	return $this->response->write(json_encode(['token' => "Kity", "Params" => (object)[] ]));
});


$app->group('/epay', function(\Slim\App $app) {

	
    $app->post('/validator',function(Request $request, Response $response, array $args) {
        global $ad;
    	
    	try {
            $nibssParam = $ad->getNIBSSSecret();
            
            $logtable = 'tbl_nibsspay_log';
            $fields = "`STATE`, `LOG`";
            
            $sign = $request->getHeader('SIGNATURE')[0];
            $sign_meth = $request->getHeader('SIGNATURE_METH')[0];
            $autho = $request->getHeader('Authorization')[0]; 
            $hash = $request->getHeader('HASH')[0];
            
            $encodedData = $hash; //file_get_contents('php://input');
            $logFrag = $encodedData . "|||" . $nibssParam['NIBSS_SECRET'] . "|||" . $nibssParam['NIBSS_IV'];
            
            if ($encodedData == $hash) {
                if (hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']) == $sign) {
                    $data = json_decode(aes_decrypt($encodedData, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV'] ), TRUE); 
                    
                    $value = "'IN', '" . $logFrag . "|||" . json_encode($data) . "'";
                    $ad->insertLog($fields, $value, $logtable);

                    $srcBankCode = filter_var($data['SourceBankCode'], FILTER_SANITIZE_STRING);
                    $srcBankName = filter_var($data['SourceBankName'], FILTER_SANITIZE_STRING);
                    $instCode = filter_var($data['InstitutionCode'], FILTER_SANITIZE_STRING);
                    $chanCode = filter_var($data['ChannelCode'], FILTER_SANITIZE_STRING);
                    $billerID = filter_var($data['BillerId'], FILTER_SANITIZE_STRING);
                    $billerName = filter_var($data['BillerName'], FILTER_SANITIZE_STRING);
                    $productID = filter_var($data['ProductID'], FILTER_SANITIZE_STRING);
                    $prodName = filter_var($data['ProductName'], FILTER_SANITIZE_STRING);
                    $txnamt = filter_var($data['Amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
                    $param = $data['Params'];
                    
                    $uname = filter_var($param['CustormerID'], FILTER_SANITIZE_STRING);
                    $nMonths = filter_var($param['NumberOfMonths'], FILTER_SANITIZE_NUMBER_INT);
                    
                    if ($uname == '') {
                        $value = "'OUT', '(/validator Request) Blank CustormerID'";
                        $ad->insertLog($fields, $value, $logtable);
                        $ret = json_encode(["Message"=>"Error", "Amount"=>0, 
                            "HasError"=> true, "Params"=>$param, "ErrorMessages"=>["Blank CustormerID"]]);
                        $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                        return $response
                                ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                ->withAddedHeader('HASH', $resp)
                                ->withStatus(404)->write($resp);
                    }
                    $sacct = $ad->loadRADAccountByUsername(trim($uname));
                    foreach ($sacct as $key=>$vall):
                        $sacc=$vall;
                        break;
                    endforeach;
                    if ( (count($sacct) < 1) || (!isset($sacc[0]['ENABLED'])) || !$sacc[0]['ENABLED']) { 
                        $value = "'OUT', '(/validator Request) Invalid Customer ID/Account is Disabled.'";
                        $ad->insertLog($fields, $value, $logtable);
                        $ret = json_encode(["Message"=>"An Error Occured", "Amount"=>0, 
                            "HasError"=> true, "Params"=>$param, "ErrorMessages"=>["Invalid Customer ID/Account is Disabled. Contact Support"]]);
                        $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                        return $response
                                ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                ->withAddedHeader('HASH', $resp)
                                ->withStatus(404)->write($resp);

                    } else { 
                        $srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); 
                        foreach ($srvlist as $key => $value) {
                            $amt = $value["AMOUNT"];
//                            $upcountrycheck = $value["IS_UPCOUNTRY"];
                            $plan = $value["PLAN"];
                            break;
                        }
                    }
                    $fname = $sacc[0]["FIRSTNAME"]; 
                    $lname = $sacc[0]["LASTNAME"]; 
                    $email = $sacc[0]["EMAIL"]; 
                    $mobile = $sacc[0]["MOBILE"];

                    $value = "'OUT', '(/validator Request) Customer Found and Sent.'";
                    $ad->insertLog($fields, $value, $logtable);
                    $params = array_merge($param, ["NameOfCustomer"=>trim(trim($fname)." " .trim($lname)), "CustormerID"=>$uname,
                            "CustomerProductType"=> $plan, /*$sacc[0]['SERVICE'],*/
                            "PhoneNumber" => trim(str_replace(" ","",$mobile)), "Amount" => ($amt * $nMonths), "UnitPricePerMonth" =>$amt]);
                    $ret = json_encode(["Message"=>"Success", "Amount"=> ($amt * $nMonths), 
                        "HasError"=> false, "Params"=>$params, "ErrorMessages"=>[]]);
                    $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                    return $response
                            ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                            ->withAddedHeader('SIGNATURE_METH', 'sha256')
                            ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                            ->withAddedHeader('HASH', $resp)
                            ->withStatus(200)->write($resp);
                    
                } else {
                    $value = "'IN', '" . $logFrag . "'";
                    $ad->insertLog($fields, $value, $logtable);
                    
                    $value = "'OUT', '(/validator Request) Invalid Signature.'";
                    $ad->insertLog($fields, $value, $logtable);
                    $ret = json_encode(["Message"=>"Error", "Amount"=>0, 
                        "HasError"=> true, "Params"=>(object)[], "ErrorMessages"=>["Invalid Signature"]]);
                    $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                    return $response
                            ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                            ->withAddedHeader('SIGNATURE_METH', 'sha256')
                            ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                            ->withAddedHeader('HASH', $resp)
                            ->withStatus(404)->write($resp);
                }
            } else {
                $value = "'IN', '" . $logFrag . "'";
                $ad->insertLog($fields, $value, $logtable);
                    
                $value = "'OUT', '(/validator Request) Invalid Hash.'";
                $ad->insertLog($fields, $value, $logtable);
                $ret = json_encode(["Message"=>"Error", "Amount"=>0, 
                        "HasError"=> true, "Params"=>(object)[], "ErrorMessages"=>["Invalid Hash/Data"]]);
                $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                return $response
                        ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                        ->withAddedHeader('SIGNATURE_METH', 'sha256')
                        ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                        ->withAddedHeader('HASH', $resp)
                        ->withStatus(404)->write($resp);
            }
            
        } catch (Exception $ex) {
            $value = "'OUT', '(/validator Request) An Error Occured:" . $ex->getMessage() . " .'";
            $ad->insertLog($fields, $value, $logtable);
            $ret = json_encode(["Message"=>"Error", "Amount"=>0, 
                "HasError"=> true, "Params"=>(object)[], "ErrorMessages"=>["An Error Occured"]]);
            $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
            return $response
                    ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                    ->withAddedHeader('SIGNATURE_METH', 'sha256')
                    ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                    ->withAddedHeader('HASH', $resp)
                    ->withStatus(404)->write($resp);
        }
        
        
    });
    
    $app->post('/payNotifier',function(Request $request, Response $response, array $args) {
        global $ad;
    	
    	try {
            
            $nibssParam = $ad->getNIBSSSecret();
            
            $logtable = 'tbl_nibsspay_log';
            $fields = "`STATE`, `LOG`";
            
            $sign = $request->getHeader('SIGNATURE')[0];
            $sign_meth = $request->getHeader('SIGNATURE_METH')[0];
            $autho = $request->getHeader('Authorization')[0]; 
            $hash = $request->getHeader('HASH')[0];
            
            $encodedData = $hash; //file_get_contents('php://input');
            $logFrag = $encodedData . "|||" . $nibssParam['NIBSS_SECRET'] . "|||" . $nibssParam['NIBSS_IV'];
            
            if ($encodedData == $hash) {
                if (hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']) == $sign) {
                    $data = json_decode(aes_decrypt($encodedData, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV'] ), TRUE); 
                    
                    $value = "'IN3', '" . $logFrag . "|||" . json_encode($data) . "'";
                    $ad->insertLog($fields, $value, $logtable);

                    $txnID = $txnref = filter_var($data['SessionId'], FILTER_SANITIZE_STRING);
                    $txnDate = filter_var($data['TransactionDate'], FILTER_SANITIZE_STRING);
                    $txnTime = filter_var($data['TransactionTime'], FILTER_SANITIZE_STRING);
                    $payDate = date("Y-m-d H:i:s", strtotime("$txnDate $txnTime"));
                    $txnamt = filter_var($data['Amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
                    $channelCode = filter_var($data['ChannelCode'], FILTER_SANITIZE_STRING);
                    $bankName = filter_var($data['BankName'], FILTER_SANITIZE_STRING);
                    $branchName = filter_var($data['BranchName'], FILTER_SANITIZE_STRING);
                    $billerName = filter_var($data['BillerName'], FILTER_SANITIZE_STRING);
                    $billerID = filter_var($data['BillerId'], FILTER_SANITIZE_STRING);
                    $param = $data['Params'];
                    
                    $uname = $custref = filter_var($param['CustormerID'], FILTER_SANITIZE_STRING);
                    $nMonths = $nmonths = filter_var($param['NumberOfMonths'], FILTER_SANITIZE_NUMBER_INT);
                    
                    if ($uname == '') {
                        $value = "'OUT3', '(/payNotifier Request) Blank CustomerID'";
                        $ad->insertLog($fields, $value, $logtable);
                        $ret = json_encode(["Message"=>"Error", 
                            "HasError"=> true, "ErrorMessages"=>["Blank CustomerID"]]);
                        $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                        return $response
                                ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                ->withAddedHeader('HASH', $resp)
                                ->withStatus(404)->write($resp);
                    }

                    $sacct = $ad->loadRADAccountByUsername(trim($uname));
                    foreach ($sacct as $key=>$vall):
                        $sacc=$vall;
                        break;
                    endforeach;
                    if ( (count($sacct) < 1) ) {  //|| (!isset($sacc[0]['ENABLED'])) || !$sacc[0]['ENABLED']
                        $value = "'OUT3', '(/payNotifier Request) Invalid CustomerID'";
                        $ad->insertLog($fields, $value, $logtable);
                        $ret = json_encode(["Message"=>"Error", 
                            "HasError"=> true, "ErrorMessages"=>["Invalid CustomerID"]]);
                        $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                        return $response
                                ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                ->withAddedHeader('HASH', $resp)
                                ->withStatus(404)->write($resp);
                    }
                    
//                    $pgen = new Password_Generator();
//                    $payRef = "NIB-$uname-" . $pgen->generate(7, 7, false, true, true, false) ;
                
                    $srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); //echo "YES";
                    foreach ($srvlist as $key => $value) {
                        $amount_due = $amt_due = $value["AMOUNT"] * $nmonths;
                        $planid = $value["PLAN_ID"];
                        break;
                    }

                    $expiry = $ad->getExpirationDate($custref);	
                    $vval =  $ad->getTranx4Verification($txnref); 

                    if (count($vval) <= 0) { $saveRet = $ad->saveInitTranx($txnref, $custref, $expiry, $amount_due, CURRENCY, $nmonths, $planid); }
                    
                    $vval =  $ad->getTranx4Verification($txnref); 
                    //upcountry
                    $isupcountry = $vval['IS_UPCOUNTRY'];
                    if ($isupcountry):
                        $erpacct = PAYSTACK_UPCOUNTRY;
                    else:
                        $erpacct = GTC_FIBERONE;
                    endif;
                    if ( (count($vval) <= 0) || ($txnamt == 0) ) :
                        $value = "'OUT3', '(/payNotifier Request) Invalid Transaction/Reference'";
                        $ad->insertLog($fields, $value, $logtable);
                        $ret = json_encode(["Message"=>"Error", 
                                "HasError"=> true, "ErrorMessages"=>["Invalid Transaction/Reference"]]);
                        $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                        return $response
                                ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                ->withAddedHeader('HASH', $resp)
                                ->withStatus(404)->write($resp);
                    endif;
                    
                    if ($vval["STATUS_CODE"] == "00") { 
                        //Payment Processed to DB Already
                        $value = "'OUT3', '(/payNotify Request) Already Processed'";
                        $ad->insertLog($fields, $value, $logtable);
                        $ret = json_encode(["Message"=>"Error", 
                                "HasError"=> true, "ErrorMessages"=>["Transaction Already Processed"]]);
                        $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                        return $response
                                ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                ->withAddedHeader('HASH', $resp)
                                ->withStatus(202)->write($resp);
                    } else {
                        //Not Yet Processed to DB, Process Now!
                        if ($vval['DB_UPDATED'] == 1) :
                            $value = "'OUT3', '(/payNotify Request) Already Processed'";
                            $ad->insertLog($fields, $value, $logtable);
                            $ret = json_encode(["Message"=>"Error", 
                                "HasError"=> true, "ErrorMessages"=>["Transaction Already Processed"]]);
                            $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                            return $response
                                    ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                    ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                    ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                    ->withAddedHeader('HASH', $resp)
                                    ->withStatus(202)->write($resp);
                        endif;

                        if (($txnamt > 0) && ($vval["REQ_AMOUNT"] <= $txnamt)) :  // ($vval["REQ_AMOUNT"] == $txnamt) :
                            $codeg = new Password_Generator();
                            $payref = "NIB-$custref-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);

                            $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);

                            $exp = isExpired($userdet['EXPIRATION']);
                            $expd = $userdet['EXPIRATION'];
                            $limitcomb = $userdet["LIMITCOMB"];

                            $validity = ($vval["NMONTHS"] >= 12)? ($vval["NMONTHS"]*$userdet["VALIDITY"])+8 : ($vval["NMONTHS"]*$userdet["VALIDITY"]);
                            if ($exp) :
                                $nu_expd = add_date(date("Y-m-d H:i:s"), $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                            else:
                                $nu_expd = add_date($userdet['EXPIRATION'], $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                            endif;

                            //TODO: Maybe Confirm
            //                if ($isupcountry):
            //                    $oprivkey = OGA_UPC_TEST_PRIV_KEY;
            //                    $otoken = OGA_UPC_TEST_TOKEN;
            //                else:
            //                    $oprivkey = OGA_REG_TEST_PRIV_KEY;
            //                    $otoken = OGA_REG_TEST_TOKEN;
            //                endif; 
            //                //get Public Key
            //                $pubkey = getOgaranyaPublicKey($otoken, $oprivKey);
            //                $checkRes = curlURL(OGA_URL . MERCHANT_ID . "/payment/". $txnref . "/status/NG", "", $extraHeaders=["token: $otoken", "publickey: $pubkey"]);
            //                $checkStatus = $checkRes["status"];
            //                if ($checkStatus !== "success"){
            //                    return $response->withStatus(401)->write(json_encode(["STATUS"=>0, "DATA"=>[], "MSG"=>"Payment Verification Failed"]));
            //                }

                            //Save Transaction
                            $pdate = $payDate; // date("Y-m-d H:i:s"); 
                            $appDate = date("Y-m-d H:i:s"); //, strtotime($payxml->PaymentDate)

                            $payloc = "NIBSS-{$bankName}-{$branchName}-{$channelCode}";

                            $ad->saveTranxResp($txnref, $payref, $txnamt, CURRENCY, 
                                               "00", "Approved by Financial Institution", $nu_expd, $pdate, 
                                                $payloc, $appDate,
                                               "NIBSS", $txnref, $txnref, $vval["RAD_USERNAME"]);

                            $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"]*$userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $txnref, $exp);
                            //Log To ERP  - ERP_DB  - Enable for LIVE
                            if ($vval['ERPID']>0) { $ad->sendToERP(ERP_URL, "ERP_TEST", ERP_USER, ERP_PASS, $vval['ERPID'], $txnamt, $vval["RAD_USERNAME"]."-ESERVICE-{$vval["PACKAGE"]}-Renewal(NIBSS)-$txnref", date("Y-m-d"), $vval['ERP_CODE'], $vval["NMONTHS"], $erpacct, $txnref); }

                            //Get Message
                            $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS_NEW");
                            $url = SERVER_URL . "";
                            $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $txnamt, $vval["PACKAGE"], $nu_expd, $txnref, $payref, $url);

                            $sent = $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "Account Renewal on FiberOne Online", $msg);

                            //Send Admin Email
                            $raw_msg = $ad->getCannedMessage("ADMIN_NOTIFICATION");
                            $payDate = $pdate; // date("d-m-Y H:i:s", strtotime($payxml->PaymentDate));
                            $msg = sprintf($raw_msg, $txnref, "Approved by Financial Institution", $vval["RAD_USERNAME"], $payDate, number_format($txnamt, 2));

                            $adminsent = $ad->sendEmail(PAY_NOTIF_EMAIL, EMAIL_SENDER, "Succesful Transaction on GTCollections", $msg);

            //                return $response->withStatus(200)->write(json_encode(["STATUS"=>1, "DATA"=>["transID"=>$transID, "uname"=>$uname,
            //                                       "paymentReference"=>$payref], "MSG"=>"Transaction Processed"]));
                            $value = "'OUT3', '(/payNotifier Request) Transaction Processed'";
                            $ad->insertLog($fields, $value, $logtable);
                            $ret = json_encode(["Message"=>"Success", 
                                "HasError"=> false, "ErrorMessages"=>["Transaction Processed"]]);
                            $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                            return $response
                                    ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                    ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                    ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                    ->withAddedHeader('HASH', $resp)
                                    ->withStatus(200)->write($resp);

                        else: 
                            //reverse
            //                return $response->withStatus(401)->write(json_encode(["STATUS"=>0, "DATA"=>[], "MSG"=>"Invalid Amount"]));
                            $value = "'OUT3', '(/payNotifier Request) Invalid Amount'";
                            $ad->insertLog($fields, $value, $logtable);
                            $ret = json_encode(["Message"=>"Error", 
                                "HasError"=> true, "ErrorMessages"=>["Invalid Amount"]]);
                            $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                            return $response
                                    ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                                    ->withAddedHeader('SIGNATURE_METH', 'sha256')
                                    ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                                    ->withAddedHeader('HASH', $resp)
                                    ->withStatus(401)->write($resp);
                        endif;

                    }
                    
                } else {
                    $value = "'IN3', '" . $logFrag . "'";
                    $ad->insertLog($fields, $value, $logtable);
                    
                    $value = "'OUT3', '(/payNotifier Request) Invalid Signature.'";
                    $ad->insertLog($fields, $value, $logtable);
                    $ret = json_encode(["Message"=>"Error", "HasError"=> true, "ErrorMessages"=>["Invalid Signature"]]);
                    $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                    return $response
                            ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                            ->withAddedHeader('SIGNATURE_METH', 'sha256')
                            ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                            ->withAddedHeader('HASH', $resp)
                            ->withStatus(404)->write($resp);
                }
            } else {
                $value = "'IN3', '" . $logFrag . "'";
                $ad->insertLog($fields, $value, $logtable);
                    
                $value = "'OUT3', '(/payNotifier Request) Invalid Hash.'";
                $ad->insertLog($fields, $value, $logtable);
                $ret = json_encode(["Message"=>"Error", "HasError"=> true, "ErrorMessages"=>["Invalid Hash/Data"]]);
                $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
                return $response
                        ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                        ->withAddedHeader('SIGNATURE_METH', 'sha256')
                        ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                        ->withAddedHeader('HASH', $resp)
                        ->withStatus(404)->write($resp);
            }
            
            
        } catch (Exception $ex) {
            $value = "'EXC3', '(/payNotifier Request) An Error Occured:" . $ex->getMessage() . " .'";
            $ad->insertLog($fields, $value, $logtable);
            $ret = json_encode(["Message"=>"Error", "HasError"=> true, "ErrorMessages"=>["An Error Occured"]]);
            $resp = aes_encrypt($ret, $nibssParam['NIBSS_SECRET'], $nibssParam['NIBSS_IV']);
            return $response
                    ->withHeader('SIGNATURE', hash("sha256",date("Ymd").$nibssParam['NIBSS_SECRET']))
                    ->withAddedHeader('SIGNATURE_METH', 'sha256')
                    ->withAddedHeader('Authorization', base64_encode(str_replace(" ", "", $billerName)))
                    ->withAddedHeader('HASH', $resp)
                    ->withStatus(404)->write($resp);
        }
        
    });
    
    $app->post('/payNotify',function(Request $request, Response $response, array $args) {
        global $ad;
    	
    	try {
        
//            $tok = $request->getAttribute('decoded_token_data'); 
            $nibssParam = $ad->getNIBSSSecret();
            $sign = $request->getHeader('SIGNATURE');
            $autho = $request->getHeader('Authorization'); 
            $hash = $request->getHeader('HASH');

//            if ( ($tok->id === 'nibss-epay' && $tok->entry === "webservice!23**") ) : 
                $data = $request->getParsedBody();
                $hashVerify = openssl_encrypt(json_encode($data), NIBSS_HASH_CIPHER_METHOD, $nibssParam['NIBSS_SECRET'],
                        OPENSSL_ZERO_PADDING, $nibssParam['NIBSS_IV']);
                
                
                $data = $request->getParsedBody();

                $logtable = 'tbl_nibsspay_log';
                $fields = "`STATE`, `LOG`";
                $value = "'IN3', '" . json_encode($data) . "'";
                $ad->insertLog($fields, $value, $logtable);

                $srcBankCode = filter_var($data['SourceBankCode'], FILTER_SANITIZE_STRING);
                $srcBankName = filter_var($data['SourceBankName'], FILTER_SANITIZE_STRING);
                $instCode = filter_var($data['InstitutionCode'], FILTER_SANITIZE_STRING);
                $chanCode = filter_var($data['ChannelCode'], FILTER_SANITIZE_STRING);
                $custName = filter_var($data['CustomerName'], FILTER_SANITIZE_STRING);
                $custAccNo = filter_var($data['CustomerAccountNumber'], FILTER_SANITIZE_STRING);
                $billerID = filter_var($data['BillerID'], FILTER_SANITIZE_STRING);
                $billerName = filter_var($data['BillerName'], FILTER_SANITIZE_STRING);
                $productID = filter_var($data['ProductID'], FILTER_SANITIZE_STRING);
                $prodName = filter_var($data['ProductName'], FILTER_SANITIZE_STRING);
                $txnamt = filter_var($data['Amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
//                $param = filter_var($data['Param'], FILTER_SANITIZE_STRING);
                $param = $data['Param'];
//                $params = json_decode($param, TRUE);
                
                if ( $hash != $hashVerify ) { 
                    $value = "'OUT', '(/validate Request) Invalid Hash.'";
                    $ad->insertLog($fields, $value, $logtable);
                    return $response->withStatus(404)->write(json_encode(["Message"=>"Invalid Hash", "Amount"=>0, 
                        "HasError"=> true, "Params"=>$param, "ErrorMessages"=>["Invalid Hash"]]));                        
                }
                $payDate = date("Y-m-d H:i:s");
                $uname = '';
                foreach ($param as $key => $value) {
                    if ($value['Key'] == 'ClientId') {
                        $uname = $custref = trim($value['Value']);
                    }
                }
                if ($uname == '') {
                    $value = "'OUT3', '(/payNotify Request) Blank ClientID'";
                    $ad->insertLog($fields, $value, $logtable);
                    return $response->withStatus(404)->write(json_encode(["Message"=>"An Error Occured", 
                        "HasError"=> true, "ErrorMessages"=>["Blank ClientID"]]));
                }
                
                $sacct = $ad->loadRADAccountByUsername(trim($uname));
                foreach ($sacct as $key=>$vall):
                    $sacc=$vall;
                    break;
                endforeach;
                if ( (count($sacct) < 1) ) {  //|| (!isset($sacc[0]['ENABLED'])) || !$sacc[0]['ENABLED']
                    $value = "'OUT3', '(/payNotify Request) Invalid Customer Reference'";
                    $ad->insertLog($fields, $value, $logtable);
                    return $response->withStatus(404)->write(json_encode(["Message"=>"An Error Occured", 
                        "HasError"=> true, "ErrorMessages"=>["Invalid Customer Reference"]]));
                        
                } 
                
                $pgen = new Password_Generator();
                $txnref = "NIB-$uname-" . $pgen->generate(7, 7, false, true, true, false) ;
                
                $srvlist = $ad->loadPlans($sacc[0]['SERVICE_ID']); //echo "YES";
        	foreach ($srvlist as $key => $value) {
                    $amount_due = $amt_due = $value["AMOUNT"];
                    $planid = $value["PLAN_ID"];
                    break;
        	}

        	$expiry = $ad->getExpirationDate($custref);	
    		$nmonths = 1; 
    		$vval =  $ad->getTranx4Verification($txnref);

        	if (count($vval) <= 0) { $saveRet = $ad->saveInitTranx($txnref, $custref, $expiry, $amount_due, CURRENCY, $nmonths, $planid); }

        	/*MODIFY*/
        	$vval =  $ad->getTranx4Verification($txnref);
        	//upcountry
        	$isupcountry = $vval['IS_UPCOUNTRY'];
        	if ($isupcountry):
                    $erpacct = PAYSTACK_UPCOUNTRY;
        	else:
                    $erpacct = GTC_FIBERONE;
        	endif;        	
        
                if ( (count($vval) <= 0) || ($txnamt == 0) ) :
                    $value = "'OUT3', '(/payNotify Request) Invalid Transaction/Reference'";
                    $ad->insertLog($fields, $value, $logtable);
                    return $response->withStatus(404)->write(json_encode(["Message"=>"An Error Occured", 
                            "HasError"=> true, "ErrorMessages"=>["Invalid Transaction/Reference"]]));
                endif;
                
        
        if ($vval["STATUS_CODE"] == "00") { 
            //Payment Processed to DB Already
            $value = "'OUT3', '(/payNotify Request) Already Processed'";
            $ad->insertLog($fields, $value, $logtable);
            return $response->withStatus(202)->write(json_encode(["Message"=>"An Error Occured", 
                    "HasError"=> true, "ErrorMessages"=>["Transaction Already Processed"]]));
        } else {
            //Not Yet Processed to DB, Process Now!
            if ($vval['DB_UPDATED'] == 1) :
                $value = "'OUT3', '(/payNotify Request) Already Processed'";
                $ad->insertLog($fields, $value, $logtable);
                return $response->withStatus(202)->write(json_encode(["Message"=>"An Error Occured", 
                    "HasError"=> true, "ErrorMessages"=>["Transaction Already Processed"]]));
            endif;
            
            if (($txnamt > 0)) :  // ($vval["REQ_AMOUNT"] == $txnamt) :
                $codeg = new Password_Generator();
                $payref = "NIB-$custref-". date("ymdHi") . $codeg->generate(3, 3, false, TRUE, true, false);
                
                $userdet = $ad->loadUserDet4Update($vval["RAD_USERNAME"]);
        
                $exp = isExpired($userdet['EXPIRATION']);
                $expd = $userdet['EXPIRATION'];
                $limitcomb = $userdet["LIMITCOMB"];

                $validity = ($vval["NMONTHS"] >= 12)? ($vval["NMONTHS"]*$userdet["VALIDITY"])+8 : ($vval["NMONTHS"]*$userdet["VALIDITY"]);
                if ($exp) :
                    $nu_expd = add_date(date("Y-m-d H:i:s"), $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                else:
                    $nu_expd = add_date($userdet['EXPIRATION'], $validity ); //($vval["NMONTHS"]*$userdet["VALIDITY"])
                endif;
                
                //TODO: Maybe Confirm
//                if ($isupcountry):
//                    $oprivkey = OGA_UPC_TEST_PRIV_KEY;
//                    $otoken = OGA_UPC_TEST_TOKEN;
//                else:
//                    $oprivkey = OGA_REG_TEST_PRIV_KEY;
//                    $otoken = OGA_REG_TEST_TOKEN;
//                endif; 
//                //get Public Key
//                $pubkey = getOgaranyaPublicKey($otoken, $oprivKey);
//                $checkRes = curlURL(OGA_URL . MERCHANT_ID . "/payment/". $txnref . "/status/NG", "", $extraHeaders=["token: $otoken", "publickey: $pubkey"]);
//                $checkStatus = $checkRes["status"];
//                if ($checkStatus !== "success"){
//                    return $response->withStatus(401)->write(json_encode(["STATUS"=>0, "DATA"=>[], "MSG"=>"Payment Verification Failed"]));
//                }
        		
                //Save Transaction
                $pdate = $payDate; // date("Y-m-d H:i:s"); 
                $appDate = date("Y-m-d H:i:s"); //, strtotime($payxml->PaymentDate)

                $payloc = "NIBSS-{$srcBankName}-{$custAccNo}";
                
                $ad->saveTranxResp($txnref, $payref, $txnamt, CURRENCY, 
                                   "00", "Approved by Financial Institution", $nu_expd, $pdate, 
                                    $payloc, $appDate,
                                   "NIBSS", $txnref, $txnref, $vval["RAD_USERNAME"]);
                
                $ad->renewSubscription($vval["RAD_USERNAME"], ($vval["NMONTHS"]*$userdet["DATA_VOLUME"]), $limitcomb, $nu_expd, $txnref, $exp);
                //Log To ERP  - ERP_DB  - Enable for LIVE
                if ($vval['ERPID']>0) { $ad->sendToERP(ERP_URL, "ERP_TEST", ERP_USER, ERP_PASS, $vval['ERPID'], $txnamt, $vval["RAD_USERNAME"]."-ESERVICE-{$vval["PACKAGE"]}-Renewal(NIBSS)-$txnref", date("Y-m-d"), $vval['ERP_CODE'], $vval["NMONTHS"], $erpacct, $txnref); }

                //Get Message
                $raw_msg = $ad->getCannedMessage("RENEWAL_SUCCESS_NEW");
                $url = SERVER_URL . "";
                $msg = sprintf($raw_msg, $userdet["FULLNAME"], $vval["RAD_USERNAME"], $txnamt, $vval["PACKAGE"], $nu_expd, $txnref, $payref, $url);

                $sent = $ad->sendEmail($userdet["EMAIL"], EMAIL_SENDER, "Account Renewal on FiberOne Online", $msg);

                //Send Admin Email
                $raw_msg = $ad->getCannedMessage("ADMIN_NOTIFICATION");
                $payDate = $pdate; // date("d-m-Y H:i:s", strtotime($payxml->PaymentDate));
                $msg = sprintf($raw_msg, $txnref, "Approved by Financial Institution", $vval["RAD_USERNAME"], $payDate, number_format($txnamt, 2));

                $adminsent = $ad->sendEmail(PAY_NOTIF_EMAIL, EMAIL_SENDER, "Succesful Transaction on GTCollections", $msg);
      
//                return $response->withStatus(200)->write(json_encode(["STATUS"=>1, "DATA"=>["transID"=>$transID, "uname"=>$uname,
//                                       "paymentReference"=>$payref], "MSG"=>"Transaction Processed"]));
                $value = "'OUT3', '(/payNotify Request) Transaction Processed'";
                $ad->insertLog($fields, $value, $logtable);
                return $response->withStatus(200)->write(json_encode(["Message"=>"Success", 
                    "HasError"=> false, "ErrorMessages"=>["Transaction Processed"]]));
                
            else: 
                //reverse
//                return $response->withStatus(401)->write(json_encode(["STATUS"=>0, "DATA"=>[], "MSG"=>"Invalid Amount"]));
                $value = "'OUT3', '(/payNotify Request) Invalid Amount'";
                $ad->insertLog($fields, $value, $logtable);
                return $response->withStatus(401)->write(json_encode(["Message"=>"An Error Occured", 
                    "HasError"=> true, "ErrorMessages"=>["Invalid Amount"]]));
            endif;
        
        }
                
                
                
            /* Remove Header Auth
            } else {
                $logtable = 'tbl_nibsspay_log';
    		$fields = "`STATE`, `LOG`";
        	$value = "'OUT3', '(/payNotify Request) Authentication Failed'";
        	$ad->insertLog($fields, $value, $logtable);
                return $response->withStatus(404)->write(json_encode(["Message"=>"An Error Occured", "Amount"=>0, 
                    "HasError"=> true, "Params"=>$params, "ErrorMessages"=>["Authentication Failed"]]));
            }   
             * 
             */
            
        } catch (Exception $ex) {
        	global $ad;
        	$logtable = 'tbl_nibsspay_log';
    		$fields = "`STATE`, `LOG`";
        	$value = "'EXC3', '(/payNotify Request) {$ex->getCode()} :: {$ex->getMessage()}'";
        	$ad->insertLog($fields, $value, $logtable);
        
        	return $response->withStatus(401)->write(json_encode(["Message"=>"An Error Occured", "Amount"=>0, 
                    "HasError"=> true, "Params"=>$params, "ErrorMessages"=>["Unable to complete Transaction"]]));
        
        }
        
    });


   
});



// Catch-all route to serve a 404 Not Found page if none of the routes match
// NOTE: make sure this route is defined last
$app->map(['GET', 'POST', 'PUT', 'DELETE', 'PATCH'], '/{routes:.+}', function($req, $res) {
    $handler = $this->notFoundHandler; // handle using the default Slim page not found handler
    return $handler($req, $res);
});