<?PHP
include_once "includes/opener.php";
include_once 'includes/db.inc';

$pubkey = "pk_test_8b59b340591f86af7c6641bdf2577cfca2526961";
//$pubkey = PS_TEST_PUB_KEY;
if (isset($_SESSION[$sid . 'loggedin'])):
    ?>
    <script>
        window.location.href = 'dasha.php';
    </script>
    <?PHP
else:
    $https = ((!empty($_SERVER['HTTPS'])) && ($_SERVER['HTTPS'] != 'off')) ? true : false;
    if (!$https):
        header("location: " . "/recover-pass");
    endif;
endif;
$order_number = '';
if (isset($_GET['order'])) {
    $order_number = base64_decode($_GET['order']);
}

?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>MyFOB [Web] | Enter Tracking ID</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="description"
        content="FiberOne is the largest Fiber to the Home (FTTH) premium broadband provider in Nigeria. We deliver excellent Fiber internet services across homes and offices">
    <meta name="author" content="MATILUKO Opeyemi Emmanuel">
    <link rel="shortcut icon" type="image/x-icon" href="img/favicon.ico" />
    <link rel="icon" type="image/x-icon" href="img/favicon.ico" />
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="bower_components/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/fontheadache.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <!-- iCheck -->
    <link rel="stylesheet" href="plugins/iCheck/square/blue.css">
    <link rel="stylesheet" href="dist/css/custom.css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
    <script src="https://js.paystack.co/v1/inline.js"></script>

    <!-- Google Font -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <style>
        /* General Reset and Base Styles */
        body {
            font-family: 'Helvetica Neue', Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f8f9fc;
            display: flex;
            justify-content: center;
        }

        .screen-container {
            width: 100%;
            max-width: 80%;
            background-color: #ffffff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            /* min-height: 100vh; */
            height: fit-content;

            display: flex;
            flex-direction: column;
        }

        /* --- Main Content Styling --- */
        .content-area {
            padding: 30px 20px;
            flex-grow: 1;
        }

        .main-title {
            font-size: 24px;
            font-weight: 700;
            color: #333333;
            margin-top: 0;
            margin-bottom: 10px;
        }

        .subtitle {
            font-size: 14px;
            color: #6a6a6a;
            margin-bottom: 30px;
        }

        /* --- Form Styling --- */
        .tracking-form {
            display: flex;
            flex-direction: column;
        }

        .input-label {
            font-size: 14px;
            color: #333333;
            font-weight: 500;
            margin-bottom: 8px;
        }

        .tracking-input {
            padding: 15px;
            font-size: 16px;
            border: 1px solid #d9d9d9;
            border-radius: 8px;
            margin-bottom: 25px;
            outline: none;
        }

        .tracking-input::placeholder {
            color: #a0a0a0;
        }

        .tracking-input:focus {
            border-color: #007bff;
        }

        .continue-button {
            background-color: #0d3e9b;
            color: #ffffff;
            border: none;
            padding: 15px;
            font-size: 18px;
            font-weight: 600;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .continue-button:hover {
            background-color: #7a9fd8;
        }

        /* Payment View Styles */
        .payment-view {
            display: none;
        }

        .page-header {
            font-size: 20px;
            font-weight: 600;
            color: #09090b;
            margin-bottom: 20px;
        }

        .cart-section {
            margin-bottom: 20px;
        }

        .cart-item {
            background: #fff;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .cart-item-name {
            font-size: 14px;
            font-weight: 500;
            color: #333;
        }

        .cart-item-price {
            font-size: 14px;
            font-weight: 600;
            color: #333;
        }

        .summary-section {
            background: #fff;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }

        .summary-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 15px;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            font-size: 14px;
        }

        .summary-row.total {
            font-weight: 600;
            font-size: 16px;
            padding-top: 10px;
            border-top: 1px solid #e5e7eb;
            margin-top: 5px;
        }

        .pay-button {
            background: #0d3e9b;
            color: #fff;
            border: none;
            padding: 15px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 8px;
            width: 100%;
            cursor: pointer;
            transition: background 0.2s;
        }

        .pay-button:hover {
            background: #3a7bc8;
        }

        /* Timeline View Styles */
        .timeline-view {
            display: none;
        }

        .card-custom {
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            margin-bottom: 20px;
        }

        .timeline {
            position: relative;
            padding-left: 0;
        }

        .timeline-item {
            position: relative;
            display: flex;
            align-items: center;
            margin-bottom: 20px;
            padding-left: 35px;
        }

        .timeline-item:last-child {
            margin-bottom: 0;
        }

        .timeline-item::before {
            content: "";
            position: absolute;
            left: 8px;
            top: 50%;
            transform: translateY(-50%);
            width: 16px;
            height: 16px;
            border-radius: 50%;
            border: 2px solid #0d3e9b;
            background: #fff;
            z-index: 2;
        }

        .timeline-item.completed::before {
            background: #0d3e9b;
        }

        .timeline-item.current::before {
            background: #0d3e9b;
            box-shadow: 0 0 0 4px rgba(74, 144, 226, 0.2);
        }

        .timeline-item.pending::before {
            border-color: #e0e0e0;
        }

        .timeline-item:not(:last-child)::after {
            content: "";
            position: absolute;
            left: 15px;
            top: calc(50% + 8px);
            width: 2px;
            height: 30px;
            background: #0d3e9b;
            z-index: 1;
        }

        .timeline-item.pending:not(:last-child)::after {
            background: #e0e0e0;
        }

        .timeline-content {
            flex: 1;
        }

        .timeline-title {
            font-size: 14px;
            font-weight: 500;
            color: #333;
            margin: 0;
        }

        .timeline-date {
            font-size: 12px;
            color: #6c757d;
            margin: 2px 0 0 0;
        }

        .timeline-link {
            color: #0d3e9b;
            text-decoration: none;
            font-size: 12px;
        }

        .timeline-link:hover {
            text-decoration: underline;
        }

        .timeline-item.pending .timeline-title {
            color: #999;
        }

        .timeline-item.pending .timeline-date {
            color: #ccc;
        }

        .view-box h6 {
            font-size: 19px;
            font-weight: 500;
        }

        .view-box a {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px;
            border-bottom: 1px solid #e9ecef;
            text-decoration: none;
            color: #000;
            font-weight: 500;
        }

        .view-box a:last-child {
            border-bottom: none;
        }

        .view-box a:hover {
            background: #f1f3f5;
        }

        /* Installation Date View Styles */
        .installation-view {
            display: none;
        }

        .back-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 15px 20px;
            font-weight: 500;
            border-bottom: 1px solid #e0e0e0;
            background: #fff;
        }

        .back-header a {
            color: #000;
            text-decoration: none;
            font-size: 18px;
        }

        .installation-form {
            padding: 20px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px;
            display: block;
            color: #333;
        }

        .form-control {
            width: 100%;
            font-size: 14px;
            border: 1px solid #d9d9d9;
            border-radius: 6px;
            height: 42px;
            padding: 0 15px;
            outline: none;
        }

        .form-control:focus {
            border-color: #0d3e9b;
        }

        .installation-box {
            border: 1px solid #e0e0e0;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 15px;
            background: #fff;
        }

        .installation-box h6 {
            font-weight: 600;
            color: #0052cc;
            margin-bottom: 8px;
        }

        .installation-box p {
            font-size: 13px;
            color: #555;
            margin-bottom: 20px;
        }

        .date-time-group {
            margin-bottom: 15px;
        }

        .footer-note {
            font-size: 12px;
            color: #777;
            margin-bottom: 15px;
        }

        .btn-schedule {
            width: 100%;
            background: #d6e4ff;
            color: #0052cc;
            font-weight: 500;
            border-radius: 8px;
            border: none;
            height: 45px;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-schedule:hover {
            background: #0052cc;
            color: #fff;
        }

        .btn-schedule:disabled {
            background: #e0e0e0;
            color: #999;
            cursor: not-allowed;
        }

        .errPan {
            background: #fee;
            border: 1px solid #fcc;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 15px;
        }

        .success-message {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 15px;
            display: none;
        }

        .input-error {
            border-color: #dc3545 !important;
        }

        .error-text {
            color: #dc3545;
            font-size: 12px;
            margin-top: 5px;
            display: none;
        }

        /* Customer Details Styles */
        .customer-details-section {
            background: #fff;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }

        .customer-details-title {
            font-size: 18px;
            font-weight: 600;
            color: #09090b;
            margin-bottom: 15px;
            border-bottom: 1px solid #e5e7eb;
            padding-bottom: 10px;
        }

        .customer-detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #f5f5f5;
        }

        .customer-detail-row:last-child {
            border-bottom: none;
        }

        .customer-detail-label {
            font-size: 14px;
            color: #6c757d;
            font-weight: 500;
        }

        .customer-detail-value {
            font-size: 14px;
            color: #333;
            font-weight: 400;
            text-align: right;
            max-width: 60%;
            word-break: break-word;
        }

        /* Button Loading States */
        .continue-button:disabled,
        .pay-button:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            position: relative;
        }

        .button-spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid #ffffff;
            border-radius: 50%;
            border-top-color: transparent;
            animation: spin 0.8s linear infinite;
            margin-right: 8px;
            vertical-align: middle;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        /* Success Modal Styles */
        .success-modal {
            display: none;
            position: fixed;
            z-index: 10000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            animation: fadeIn 0.3s ease;
        }

        .success-modal-content {
            background-color: #fff;
            margin: 10% auto;
            padding: 0;
            border-radius: 12px;
            max-width: 400px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            animation: slideDown 0.3s ease;
        }

        .success-modal-header {
            padding: 25px;
            text-align: center;
            border-bottom: 1px solid #e5e7eb;
        }

        .success-icon {
            width: 60px;
            height: 60px;
            background-color: #10b981;
            border-radius: 50%;
            margin: 0 auto 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            animation: scaleIn 0.3s ease;
        }

        .success-icon i {
            color: #fff;
            font-size: 32px;
        }

        .success-modal-title {
            font-size: 22px;
            font-weight: 600;
            color: #111827;
            margin: 0 0 8px 0;
        }

        .success-modal-body {
            padding: 20px 25px;
            text-align: center;
            color: #6b7280;
            font-size: 15px;
            line-height: 1.6;
        }

        .success-modal-footer {
            padding: 20px 25px;
            text-align: center;
            border-top: 1px solid #e5e7eb;
        }

        .success-modal-btn {
            background-color: #0d3e9b;
            color: #fff;
            border: none;
            padding: 12px 32px;
            font-size: 15px;
            font-weight: 500;
            border-radius: 8px;
            cursor: pointer;
            transition: background 0.2s;
            min-width: 120px;
        }

        .success-modal-btn:hover {
            background-color: #3a7bc8;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes slideDown {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        @keyframes scaleIn {
            from {
                transform: scale(0);
            }

            to {
                transform: scale(1);
            }
        }
    </style>
</head>

<body class="hold-transition login-page" style="font-family: HeadacheNormal !important;  ">
    <div class="screen-container">
        <!-- Tracking ID Entry View -->
        <main class="content-area tracking-entry-view">
            <h1 class="main-title">Enter Your Tracking ID</h1>
            <p class="subtitle">
                Paste or type the tracking ID from your email to continue
            </p>
            <div class="errPan" style="display:none; color:red;"></div>
            <form class="tracking-form">
                <label for="trackingId" class="input-label">Tracking Id</label>
                <input type="text" id="trackingId" name="trackingId" placeholder="Enter Tracking Id"
                    class="tracking-input" maxlength="50" autocomplete="off"
                    value="<?php echo htmlspecialchars($order_number); ?>">
                <span class="error-text" id="trackingIdError">Please enter a valid tracking ID</span>
                <button type="submit" id="orderId" class="continue-button">Track Order</button>
            </form>
        </main>

        <!-- Payment View -->
        <div class="payment-view">
            <div class="content-area">
                <h2 class="page-header">Cart (<span id="cartCount">0</span> Items)</h2>

                <!-- Customer Details Section -->
                <div class="customer-details-section">
                    <div class="customer-details-title">Customer Details</div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Name:</span>
                        <span class="customer-detail-value" id="paymentCustomerName">-</span>
                    </div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Email:</span>
                        <span class="customer-detail-value" id="paymentCustomerEmail">-</span>
                    </div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Phone:</span>
                        <span class="customer-detail-value" id="paymentCustomerPhone">-</span>
                    </div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Address:</span>
                        <span class="customer-detail-value" id="paymentCustomerAddress">-</span>
                    </div>
                    <div class="customer-detail-row" id="paymentCompanyRow" style="display:none;">
                        <span class="customer-detail-label">Company:</span>
                        <span class="customer-detail-value" id="paymentCustomerCompany">-</span>
                    </div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Tracking ID:</span>
                        <span class="customer-detail-value" id="paymentTrackingId">-</span>
                    </div>
                </div>

                <div class="cart-section" id="cartItems">
                    <!-- Cart items will be dynamically inserted here -->
                </div>

                <div class="summary-section">
                    <div class="summary-title">Order Summary</div>
                    <div class="summary-row">
                        <span>Subtotal</span>
                        <span id="subtotalAmount">₦0.00</span>
                    </div>
                    <div class="summary-row">
                        <span>Delivery fee</span>
                        <span id="deliveryFee">₦0.00</span>
                    </div>
                    <div class="summary-row total">
                        <span>Total</span>
                        <span id="totalAmount">₦0.00</span>
                    </div>
                </div>

                <button class="pay-button" id="proceedToPayBtn">Proceed to pay</button>
            </div>
        </div>

        <!-- Timeline View -->
        <div class="timeline-view">
            <div class="content-area">
                <h2 class="page-header">Timeline</h2>

                <!-- Customer Details Section -->
                <div class="customer-details-section">
                    <div class="customer-details-title">Customer Details</div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Name:</span>
                        <span class="customer-detail-value" id="timelineCustomerName">-</span>
                    </div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Email:</span>
                        <span class="customer-detail-value" id="timelineCustomerEmail">-</span>
                    </div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Phone:</span>
                        <span class="customer-detail-value" id="timelineCustomerPhone">-</span>
                    </div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Address:</span>
                        <span class="customer-detail-value" id="timelineCustomerAddress">-</span>
                    </div>
                    <div class="customer-detail-row" id="timelineCompanyRow" style="display:none;">
                        <span class="customer-detail-label">Company:</span>
                        <span class="customer-detail-value" id="timelineCustomerCompany">-</span>
                    </div>
                    <div class="customer-detail-row">
                        <span class="customer-detail-label">Tracking ID:</span>
                        <span class="customer-detail-value" id="timelineTrackingId">-</span>
                    </div>
                </div>

                <div class="card-custom timeline">
                    <div class="timeline-item completed">
                        <div class="timeline-content">
                            <div class="timeline-title">Location Received</div>
                            <div class="timeline-date" id="locationDate">-</div>
                        </div>
                    </div>

                    <div class="timeline-item current">
                        <div class="timeline-content">
                            <div class="timeline-title">Request Approved</div>
                            <div class="timeline-date" id="approvalDate">-</div>
                        </div>
                    </div>

                    <div class="timeline-item pending" id="scheduleItem">
                        <div class="timeline-content">
                            <div class="timeline-title">Scheduled for Installation</div>
                            <a href="#" class="timeline-link" id="scheduleLink">Click here to schedule your installation
                                date</a>
                        </div>
                    </div>

                    <div class="timeline-item pending">
                        <div class="timeline-content">
                            <div class="timeline-title">Assigned to Technician</div>
                            <div class="timeline-date">Pending</div>
                        </div>
                    </div>

                    <div class="timeline-item pending">
                        <div class="timeline-content">
                            <div class="timeline-title">Installation in Progress</div>
                            <div class="timeline-date">Pending</div>
                        </div>
                    </div>

                    <div class="timeline-item pending">
                        <div class="timeline-content">
                            <div class="timeline-title">Installation Complete</div>
                            <div class="timeline-date">Pending</div>
                        </div>
                    </div>
                </div>

                <!-- View Section -->
                <div class="card-custom view-box">
                    <h6 class="font-weight-bold mb-3">View</h6>
                    <a href="#">
                        Support Ticket
                        <span>&rsaquo;</span>
                    </a>
                    <a href="#">
                        Invoices
                        <span>&rsaquo;</span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Installation Date Scheduling View -->
        <div class="installation-view">
            <div class="back-header">
                <a href="#" id="backToTimeline">&larr; Back</a>
                <span>Installation Date</span>
                <span>&#128339;</span>
            </div>

            <div class="installation-form">
                <form id="installationForm">
                    <div class="success-message" id="successMessage"></div>
                    <div class="errPan" style="display:none;"></div>

                    <div class="form-group">
                        <label for="trackingIdDisplay">Tracking ID</label>
                        <input type="text" id="trackingIdDisplay" class="form-control" disabled />
                    </div>

                    <div class="installation-box">
                        <h6>Set Installation Date</h6>
                        <p>
                            Please select your preferred installation date. Our team will contact you to confirm the
                            appointment.
                        </p>

                        <div class="date-time-group">
                            <label for="installDate">Preferred Date <span style="color: red;">*</span></label>
                            <input type="date" class="form-control" id="installDate" name="installDate" required
                                min="" />
                            <span class="error-text" id="installDateError">Please select a valid date</span>
                        </div>

                        <div class="date-time-group">
                            <label for="installTime">Preferred Time <span style="color: red;">*</span></label>
                            <input type="time" class="form-control" id="installTime" name="installTime" required
                                min="08:00" max="16:00" />
                            <span class="error-text" id="installTimeError">Please select a valid time</span>
                            <p style="font-size: 12px; color: #666; margin-top: 8px; margin-bottom: 0;">
                                <i class="fa fa-info-circle"></i> Please choose a time between 8:00 AM and 4:00 PM
                            </p>
                        </div>
                    </div>

                    <p class="footer-note">
                        Please ensure your selected date is within your actual availability. Our team will confirm the
                        final installation date based on your preference and technician availability.
                    </p>

                    <button type="submit" class="btn-schedule" id="scheduleBtn">Set Installation Date</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Success Modal -->
    <div id="successModal" class="success-modal">
        <div class="success-modal-content">
            <div class="success-modal-header">
                <div class="success-icon">
                    <i class="fa fa-check"></i>
                </div>
                <h2 class="success-modal-title">Success!</h2>
            </div>
            <div class="success-modal-body" id="successModalMessage">
                Your action has been completed successfully.
            </div>
            <div class="success-modal-footer">
                <button class="success-modal-btn" id="successModalBtn">Continue</button>
            </div>
        </div>
    </div>




    <!-- jQuery 3 -->
    <script src="bower_components/jquery/dist/jquery.min.js"></script>
    <!-- Bootstrap 3.3.7 -->
    <script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- iCheck -->
    <script src="plugins/iCheck/icheck.min.js"></script>

    <!-- Ajax Form Validation Script -->
    <script src="dist/js/jquery.validate.js" type="text/javascript" charset="utf-8"></script>
    <!-- Bootstrap Validation Script -->
    <script src="dist/js/validator.min.js" type="text/javascript" charset="utf-8"></script>
    <script>
        $(document).ready(function () {
            let orderData = null;

            // Set minimum date for installation date picker (tomorrow)
            const tomorrow = new Date();
            tomorrow.setDate(tomorrow.getDate() + 1);
            const minDate = tomorrow.toISOString().split('T')[0];
            $('#installDate').attr('min', minDate);

            // Input sanitization function
            function sanitizeInput(input) {
                return input.replace(/[<>\"'&]/g, function (char) {
                    const entities = {
                        '<': '&lt;',
                        '>': '&gt;',
                        '"': '&quot;',
                        "'": '&#39;',
                        '&': '&amp;'
                    };
                    return entities[char];
                });
            }

            // Validate tracking ID format
            function validateTrackingId(trackingId) {
                // Must match format: SO-YYYYMMDD-HHMMSS-XXXX
                const pattern = /^SO-\d{8}-\d{6}-\d{4}$/;
                return pattern.test(trackingId);
            }

            // Validate date is in future
            function validateFutureDate(dateString) {
                const selectedDate = new Date(dateString);
                const today = new Date();
                today.setHours(0, 0, 0, 0);
                return selectedDate > today;
            }

            // Show error for specific field
            function showFieldError(fieldId, errorId, message) {
                $('#' + fieldId).addClass('input-error');
                $('#' + errorId).text(message).show();
            }

            // Clear field error
            function clearFieldError(fieldId, errorId) {
                $('#' + fieldId).removeClass('input-error');
                $('#' + errorId).hide();
            }

            // Show general error message
            function showError(message) {
                const sanitizedMessage = sanitizeInput(message);
                $('.errPan')
                    .html(sanitizedMessage)
                    .fadeIn(300);
            }

            // Hide error message
            function hideError() {
                $('.errPan').fadeOut(300);
            }

            // Show success message
            function showSuccess(message) {
                const sanitizedMessage = sanitizeInput(message);
                $('#successMessage')
                    .html(sanitizedMessage)
                    .fadeIn(300);
            }

            // Track Order Form Submission with validation
            $('.tracking-form').on('submit', function (e) {
                e.preventDefault();

                clearFieldError('trackingId', 'trackingIdError');
                hideError();

                const trackingId = $('#trackingId').val().trim();

                // Validation checks
                if (trackingId === '') {
                    showFieldError('trackingId', 'trackingIdError', 'Please enter a Tracking ID');
                    return false;
                }

                if (!validateTrackingId(trackingId)) {
                    showFieldError('trackingId', 'trackingIdError', 'Invalid Tracking ID format (Expected: SO-YYYYMMDD-HHMMSS-XXXX)');
                    return false;
                }

                // Show loading state on button
                const submitBtn = $('#orderId');
                const originalText = submitBtn.html();
                submitBtn.prop('disabled', true).html('<span class="button-spinner"></span>Tracking...');

                // Show loading modal
                $('#myLoading').modal({
                    keyboard: false,
                    show: true,
                    backdrop: "static"
                });

                $.ajax({
                    type: "GET",
                    url: "ajax/ajax_trackorder.php",
                    data: {
                        tracking_id: sanitizeInput(trackingId)
                    },
                    success: function (response) {
                        $('#myLoading').modal("hide");
                        submitBtn.prop('disabled', false).html(originalText);

                        try {
                            const res = (typeof response === "string") ? JSON.parse(response) : response;

                            if (!res.success) {
                                showError(res.message || 'Unable to track order');
                            } else {
                                hideError();
                                orderData = res.data;

                                // Show appropriate view based on payment status
                                if (orderData.status.toLowerCase() === 'paid') {
                                    showTimelineView();
                                } else {
                                    showPaymentView();
                                }
                            }
                        } catch (e) {
                            showError("Unexpected response format from server.");
                            console.error("Parsing error:", e, response);
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        $('#myLoading').modal("hide");
                        submitBtn.prop('disabled', false).html(originalText);
                        showError("Cannot contact server. Please try again later.");
                        console.error("AJAX error details:", jqXHR.responseText);
                    }
                });
            });

            // Clear error on input
            $('#trackingId').on('input', function () {
                clearFieldError('trackingId', 'trackingIdError');
            });

            $('#installDate').on('change', function () {
                clearFieldError('installDate', 'installDateError');
            });

            $('#installTime').on('change', function () {
                clearFieldError('installTime', 'installTimeError');
            });

            // Show Payment View
            function showPaymentView() {
                $('.tracking-entry-view').hide();
                $('.timeline-view').hide();
                $('.installation-view').hide();
                $('.payment-view').show();

                populatePaymentView();
            }

            // Populate Payment View with Data
            function populatePaymentView() {
                if (!orderData) return;

                // Populate customer details
                $('#paymentCustomerName').text(orderData.name || '-');
                $('#paymentCustomerEmail').text(orderData.email || '-');
                $('#paymentCustomerPhone').text(orderData.phone || '-');
                $('#paymentCustomerAddress').text(orderData.address || '-');
                $('#paymentTrackingId').text(orderData.tracking_id || '-');

                if (orderData.company_name && orderData.company_name.trim() !== '') {
                    $('#paymentCustomerCompany').text(orderData.company_name);
                    $('#paymentCompanyRow').show();
                } else {
                    $('#paymentCompanyRow').hide();
                }

                let cartHTML = '';
                let itemCount = 0;

                if (orderData.plan_name) {
                    cartHTML += `
                        <div class="cart-item">
                            <div class="cart-item-name">${sanitizeInput(orderData.plan_name)}</div>
                            <div class="cart-item-price">₦${formatAmount(orderData.plan_amount)}</div>
                        </div>
                    `;
                    itemCount++;
                }

                if (orderData.otc_cost && parseFloat(orderData.otc_cost) > 0) {
                    cartHTML += `
                        <div class="cart-item">
                            <div class="cart-item-name">Installation Fee</div>
                            <div class="cart-item-price">₦${formatAmount(orderData.otc_cost)}</div>
                        </div>
                    `;
                    itemCount++;
                }

                $('#cartItems').html(cartHTML);
                $('#cartCount').text(itemCount);

                const subtotal = parseFloat(orderData.total_amount) || 0;
                const deliveryFee = 0;
                const total = subtotal + deliveryFee;

                $('#subtotalAmount').text('₦' + formatAmount(subtotal));
                $('#deliveryFee').text('₦' + formatAmount(deliveryFee));
                $('#totalAmount').text('₦' + formatAmount(total));
            }

            // Proceed to Pay Button
            $('#proceedToPayBtn').on('click', function () {
                if (orderData) {
                    const payBtn = $(this);
                    payBtn.prop('disabled', true).html('<span class="button-spinner"></span>Processing...');

                    // Re-enable button after a short delay to allow Paystack to open
                    setTimeout(function () {
                        payBtn.prop('disabled', false).html('Proceed to pay');
                    }, 2000);

                    payWithPaystack(orderData);
                }
            });

            // Show Timeline View
            function showTimelineView() {
                $('.tracking-entry-view').hide();
                $('.payment-view').hide();
                $('.installation-view').hide();
                $('.timeline-view').show();

                populateTimelineView();
            }

            // Populate Timeline View
            function populateTimelineView() {
                if (!orderData) return;

                // Populate customer details
                $('#timelineCustomerName').text(orderData.name || '-');
                $('#timelineCustomerEmail').text(orderData.email || '-');
                $('#timelineCustomerPhone').text(orderData.phone || '-');
                $('#timelineCustomerAddress').text(orderData.address || '-');
                $('#timelineTrackingId').text(orderData.tracking_id || '-');

                if (orderData.company_name && orderData.company_name.trim() !== '') {
                    $('#timelineCustomerCompany').text(orderData.company_name);
                    $('#timelineCompanyRow').show();
                } else {
                    $('#timelineCompanyRow').hide();
                }

                const createdDate = new Date(orderData.created_at);
                $('#locationDate').text(formatDate(createdDate));

                const approvalDate = new Date(createdDate);
                approvalDate.setDate(approvalDate.getDate());
                $('#approvalDate').text(formatDate(approvalDate));

                // Check if installation date already exists in response
                if (orderData.appointment_date) {
                    const installDate = orderData.appointment_date;

                    // Update timeline item to completed state
                    $('#scheduleItem').removeClass('pending').addClass('completed');

                    // Replace the link with the scheduled date
                    const formattedInstallDate = formatDate(new Date(installDate));
                    $('#scheduleLink').replaceWith('<div class="timeline-date" id="scheduledDate">' + formattedInstallDate + '</div>');
                } else {
                    // Reset to pending state if no date exists
                    $('#scheduleItem').removeClass('completed').addClass('pending');

                    // Ensure link is available if date div exists from previous view
                    if (!$('#scheduleLink').length && $('#scheduledDate').length) {
                        $('#scheduledDate').replaceWith('<a href="#" class="timeline-link" id="scheduleLink">Click here to schedule your installation date</a>');

                        // Reattach click event
                        $('#scheduleLink').on('click', function (e) {
                            e.preventDefault();
                            showInstallationView();
                        });
                    }
                }
            }

            // Schedule Link Click
            $('#scheduleLink').on('click', function (e) {
                e.preventDefault();
                showInstallationView();
            });

            // Show Installation Date View
            function showInstallationView() {
                $('.tracking-entry-view').hide();
                $('.payment-view').hide();
                $('.timeline-view').hide();
                $('.installation-view').show();

                if (orderData) {
                    $('#trackingIdDisplay').val(orderData.tracking_id);
                }
            }

            // Back to Timeline
            $('#backToTimeline').on('click', function (e) {
                e.preventDefault();
                showTimelineView();
            });

            // Installation Form Submission with validation
            $('#installationForm').on('submit', function (e) {
                e.preventDefault();

                clearFieldError('installDate', 'installDateError');
                clearFieldError('installTime', 'installTimeError');
                hideError();
                $('#successMessage').hide();

                const installDate = $('#installDate').val();
                const installTime = $('#installTime').val();

                // Validation checks
                if (!installDate) {
                    showFieldError('installDate', 'installDateError', 'Please select an installation date');
                    return false;
                }

                if (!installTime) {
                    showFieldError('installTime', 'installTimeError', 'Please select an installation time');
                    return false;
                }

                if (!validateFutureDate(installDate)) {
                    showFieldError('installDate', 'installDateError', 'Installation date must be in the future');
                    return false;
                }

                // Validate time is between 8:00 AM and 4:00 PM
                const [hours, minutes] = installTime.split(':').map(Number);
                if (hours < 8 || hours >= 16) {
                    showFieldError('installTime', 'installTimeError', 'Time must be between 8:00 AM and 4:00 PM');
                    return false;
                }

                // Combine date and time
                const installDateTime = installDate + ' ' + installTime + ':00';

                // Disable submit button to prevent double submission
                const submitBtn = $('#scheduleBtn');
                submitBtn.prop('disabled', true).text('Saving...');

                $.ajax({
                    type: "POST",
                    url: "ajax/set-installation-date.php",
                    data: {
                        tracking_id: sanitizeInput(orderData.tracking_id),
                        installDate: sanitizeInput(installDateTime)
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            showSuccess(response.message || 'Installation date and time set successfully!');

                            // Update orderData with the new installation datetime (use appointment_date to match backend)
                            orderData.appointment_date = installDateTime;

                            // Redirect back to timeline after 2 seconds
                            setTimeout(function () {
                                showTimelineView();
                            }, 2000);
                        } else {
                            showError(response.message || 'Failed to set installation date');
                            submitBtn.prop('disabled', false).text('Set Installation Date');
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("AJAX Error:", status, error);
                        showError("Something went wrong. Please try again later.");
                        submitBtn.prop('disabled', false).text('Set Installation Date');
                    }
                });
            });

            // Paystack Payment Handler
            function payWithPaystack(data) {
                const amountKobo = parseFloat(data.total_amount) * 100;
                const reference = data.paystack_reference;

                var handler = PaystackPop.setup({
                    key: '<?PHP echo $pubkey; ?>',
                    email: data.email,
                    amount: amountKobo,
                    currency: "NGN",
                    ref: reference,
                    phone: data.phone || "",
                    first_name: data.name,
                    last_name: "",
                    metadata: {
                        custom_fields: [{
                            display_name: "Full Name",
                            variable_name: "fullname",
                            value: data.name
                        },
                        {
                            display_name: "Plan Name",
                            variable_name: "planname",
                            value: data.plan_name
                        },
                        {
                            display_name: "Plan ID",
                            variable_name: "planid",
                            value: data.plan_id
                        },
                        {
                            display_name: "No of Months",
                            variable_name: "months",
                            value: data.no_of_months
                        },
                        {
                            display_name: "Tracking ID",
                            variable_name: "tracking_id",
                            value: data.tracking_id
                        }
                        ]
                    },
                    callback: function (response) {
                        console.log("Payment completed, verifying...", response.reference);

                        // Show loading during verification
                        $('#myLoading').modal({
                            keyboard: false,
                            show: true,
                            backdrop: "static"
                        });

                        $.ajax({
                            type: "POST",
                            url: "ajax/ajax_verify_payment.php",
                            data: {
                                reference: response.reference,
                                tracking_id: data.tracking_id
                            },
                            success: function (res) {
                                $('#myLoading').modal("hide");
                                const result = (typeof res === "string") ? JSON.parse(res) : res;

                                if (result.success) {
                                    showSuccessModal("Payment verified successfully! Your order is now being processed.", function () {
                                        orderData.status = 'paid';
                                        showTimelineView();
                                    });
                                } else {
                                    showError("Payment verification failed. Please contact support.");
                                }
                            },
                            error: function (err) {
                                $('#myLoading').modal("hide");
                                console.error("Verification error:", err);
                                showError("Could not verify payment. Please try again later.");
                            }
                        });
                    },
                    onClose: function () {
                        console.log('Payment window closed');
                    }
                });
                handler.openIframe();
            }

            // Utility Functions
            function formatAmount(amount) {
                return parseFloat(amount).toLocaleString('en-NG', {
                    minimumFractionDigits: 2,
                    maximumFractionDigits: 2
                });
            }

            function formatDate(date) {
                const options = {
                    day: 'numeric',
                    month: 'long',
                    year: 'numeric',
                    hour: '2-digit',
                    minute: '2-digit'
                };
                return date.toLocaleDateString('en-GB', options).replace(',', ' -');
            }

            // Success Modal Functions
            function showSuccessModal(message, callback) {
                $('#successModalMessage').text(message);
                $('#successModal').fadeIn(300);

                // Handle button click
                $('#successModalBtn').off('click').on('click', function () {
                    hideSuccessModal();
                    if (typeof callback === 'function') {
                        callback();
                    }
                });
            }

            function hideSuccessModal() {
                $('#successModal').fadeOut(300);
            }

            // Close modal on outside click
            $('#successModal').on('click', function (e) {
                if (e.target.id === 'successModal') {
                    hideSuccessModal();
                }
            });
        });
    </script>




</body>

</html>